/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import hudson.model.Descriptor;
import hudson.tools.InstallSourceProperty;
import hudson.tools.Messages;
import hudson.tools.PropertyDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.tools.ToolPropertyDescriptor;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.tools.ToolConfigurationCategory;
import net.sf.json.JSONObject;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public abstract class ToolDescriptor<T extends ToolInstallation>
extends Descriptor<ToolInstallation> {
    private T[] installations;

    public T[] getInstallations() {
        if (this.installations != null) {
            return (ToolInstallation[])this.installations.clone();
        }
        Type bt = Types.getBaseClass(this.getClass(), ToolDescriptor.class);
        if (bt instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)bt;
            Class t = Types.erasure((Type)pt.getActualTypeArguments()[0]);
            return (ToolInstallation[])Array.newInstance(t, 0);
        }
        return (ToolInstallation[])new Object[0];
    }

    public void setInstallations(T ... installations) {
        this.installations = (ToolInstallation[])installations.clone();
    }

    public List<ToolPropertyDescriptor> getPropertyDescriptors() {
        return PropertyDescriptor.for_(ToolProperty.all(), this.clazz);
    }

    @Override
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(ToolConfigurationCategory.class);
    }

    public List<? extends ToolInstaller> getDefaultInstallers() {
        return Collections.emptyList();
    }

    public DescribableList<ToolProperty<?>, ToolPropertyDescriptor> getDefaultProperties() throws IOException {
        DescribableList r = new DescribableList(NOOP);
        List<ToolInstaller> installers = this.getDefaultInstallers();
        if (!installers.isEmpty()) {
            r.add(new InstallSourceProperty(installers));
        }
        return r;
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.setInstallations(req.bindJSONToList(this.clazz, json.get("tool")).toArray((ToolInstallation[])Array.newInstance(this.clazz, 0)));
        return true;
    }

    public FormValidation doCheckHome(@QueryParameter File value) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        if (value.getPath().isEmpty()) {
            return FormValidation.ok();
        }
        if (!value.isDirectory()) {
            return FormValidation.warning(Messages.ToolDescriptor_NotADirectory(value));
        }
        return this.checkHomeDirectory(value);
    }

    protected FormValidation checkHomeDirectory(File home) {
        return FormValidation.ok();
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        return FormValidation.validateRequired(value);
    }
}

