/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class AtomicFileWriter
extends Writer {
    private final Writer core;
    private final File tmpFile;
    private final File destFile;

    public AtomicFileWriter(File f) throws IOException {
        this(f, "UTF-8");
    }

    public AtomicFileWriter(File f, String encoding) throws IOException {
        File dir = f.getParentFile();
        try {
            dir.mkdirs();
            this.tmpFile = File.createTempFile("atomic", null, dir);
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temporary file in " + dir, e);
        }
        this.destFile = f;
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        this.core = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpFile), encoding));
    }

    @Override
    public void write(int c) throws IOException {
        this.core.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.core.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.core.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.core.flush();
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    public void abort() throws IOException {
        this.close();
        this.tmpFile.delete();
    }

    public void commit() throws IOException {
        this.close();
        if (this.destFile.exists()) {
            try {
                Util.deleteFile(this.destFile);
            }
            catch (IOException x) {
                this.tmpFile.delete();
                throw x;
            }
        }
        this.tmpFile.renameTo(this.destFile);
    }

    protected void finalize() throws Throwable {
        this.close();
        this.tmpFile.delete();
    }

    public File getTemporaryFile() {
        return this.tmpFile;
    }
}

