/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.util.Area;
import hudson.util.Graph;
import java.awt.Font;
import java.io.IOException;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ChartUtil {
    @Deprecated
    public static boolean awtProblem = false;
    public static Throwable awtProblemCause = null;
    public static double CHEBYSHEV_N = 3.0;

    @Deprecated
    public static void generateGraph(StaplerRequest req, StaplerResponse rsp, JFreeChart chart, Area defaultSize) throws IOException {
        ChartUtil.generateGraph(req, rsp, chart, defaultSize.width, defaultSize.height);
    }

    @Deprecated
    public static void generateGraph(StaplerRequest req, StaplerResponse rsp, final JFreeChart chart, int defaultW, int defaultH) throws IOException {
        new Graph(-1L, defaultW, defaultH){

            @Override
            protected JFreeChart createGraph() {
                return chart;
            }
        }.doPng(req, rsp);
    }

    @Deprecated
    public static void generateClickableMap(StaplerRequest req, StaplerResponse rsp, JFreeChart chart, Area defaultSize) throws IOException {
        ChartUtil.generateClickableMap(req, rsp, chart, defaultSize.width, defaultSize.height);
    }

    @Deprecated
    public static void generateClickableMap(StaplerRequest req, StaplerResponse rsp, final JFreeChart chart, int defaultW, int defaultH) throws IOException {
        new Graph(-1L, defaultW, defaultH){

            @Override
            protected JFreeChart createGraph() {
                return chart;
            }
        }.doMap(req, rsp);
    }

    public static void adjustChebyshev(CategoryDataset dataset, NumberAxis yAxis) {
        double sum = 0.0;
        double sum2 = 0.0;
        int nColumns = dataset.getColumnCount();
        int nRows = dataset.getRowCount();
        for (int i = 0; i < nRows; ++i) {
            Comparable rowKey = dataset.getRowKey(i);
            for (int j = 0; j < nColumns; ++j) {
                Comparable columnKey = dataset.getColumnKey(j);
                double n = dataset.getValue(rowKey, columnKey).doubleValue();
                sum += n;
                sum2 += n * n;
            }
        }
        double average = sum / (double)(nColumns * nRows);
        double stddev = Math.sqrt(sum2 / (double)(nColumns * nRows) - average * average);
        double rangeMin = average - stddev * CHEBYSHEV_N;
        double rangeMax = average + stddev * CHEBYSHEV_N;
        boolean found = false;
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < nRows; ++i) {
            Comparable rowKey = dataset.getRowKey(i);
            for (int j = 0; j < nColumns; ++j) {
                Comparable columnKey = dataset.getColumnKey(j);
                double n = dataset.getValue(rowKey, columnKey).doubleValue();
                if (n < rangeMin || rangeMax < n) {
                    found = true;
                    continue;
                }
                min = Math.min(min, n);
                max = Math.max(max, n);
            }
        }
        if (!found) {
            return;
        }
        min = Math.min(0.0, min);
        max += yAxis.getUpperMargin() * (max - min);
        yAxis.setRange(min, max);
    }

    static {
        try {
            new Font("SansSerif", 1, 18).toString();
        }
        catch (Throwable t) {
            awtProblemCause = t;
            awtProblem = true;
        }
    }

    public static final class NumberOnlyBuildLabel
    implements Comparable<NumberOnlyBuildLabel> {
        private final Run<?, ?> run;
        @Deprecated
        public final AbstractBuild build;

        public NumberOnlyBuildLabel(Run<?, ?> run) {
            this.run = run;
            this.build = run instanceof AbstractBuild ? (AbstractBuild)run : null;
        }

        @Deprecated
        public NumberOnlyBuildLabel(AbstractBuild build) {
            this.run = build;
            this.build = build;
        }

        public Run<?, ?> getRun() {
            return this.run;
        }

        @Override
        public int compareTo(NumberOnlyBuildLabel that) {
            return this.run.number - that.run.number;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NumberOnlyBuildLabel)) {
                return false;
            }
            NumberOnlyBuildLabel that = (NumberOnlyBuildLabel)o;
            return this.run == that.run;
        }

        public int hashCode() {
            return this.run.hashCode();
        }

        public String toString() {
            return this.run.getDisplayName();
        }
    }
}

