/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.triggers.SafeTimerTask;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DoubleLaunchChecker {
    private long lastWriteTime = 0L;
    private boolean ignore = false;
    private final Random random = new Random();
    public final File home = Jenkins.getInstance().getRootDir();
    private String collidingId;
    private static final Logger LOGGER = Logger.getLogger(DoubleLaunchChecker.class.getName());

    protected void execute() {
        File timestampFile = new File(this.home, ".owner");
        long t = timestampFile.lastModified();
        if (t != 0L && this.lastWriteTime != 0L && t != this.lastWriteTime && !this.ignore) {
            try {
                this.collidingId = FileUtils.readFileToString((File)timestampFile);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to read collision file", e);
            }
            Jenkins.getInstance().servletContext.setAttribute("app", (Object)this);
            LOGGER.severe("Collision detected. timestamp=" + t + ", expected=" + this.lastWriteTime);
        }
        try {
            FileUtils.writeStringToFile((File)timestampFile, (String)this.getId());
            this.lastWriteTime = timestampFile.lastModified();
        }
        catch (IOException e) {
            this.lastWriteTime = 0L;
        }
        this.schedule();
    }

    public String getId() {
        Jenkins h = Jenkins.getInstance();
        String contextPath = "";
        try {
            Method m = ServletContext.class.getMethod("getContextPath", new Class[0]);
            contextPath = " contextPath=\"" + m.invoke((Object)h.servletContext, new Object[0]) + "\"";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return h.hashCode() + contextPath + " at " + ManagementFactory.getRuntimeMXBean().getName();
    }

    public String getCollidingId() {
        return this.collidingId;
    }

    public void schedule() {
        long MINUTE = 60000L;
        Timer.get().schedule(new SafeTimerTask(){

            @Override
            protected void doRun() {
                DoubleLaunchChecker.this.execute();
            }
        }, (long)(this.random.nextInt(30) + 60) * MINUTE, TimeUnit.MILLISECONDS);
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void init() {
        new DoubleLaunchChecker().schedule();
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        rsp.setStatus(500);
        req.getView((Object)this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doIgnore(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.ignore = true;
        Jenkins.getInstance().servletContext.setAttribute("app", (Object)Jenkins.getInstance());
        rsp.sendRedirect2(req.getContextPath() + '/');
    }
}

