/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;

public abstract class FileVisitor {
    public abstract void visit(File var1, String var2) throws IOException;

    public void visitSymlink(File link, String target, String relativePath) throws IOException {
        this.visit(link, relativePath);
    }

    public boolean understandsSymlink() {
        return false;
    }

    public final FileVisitor with(FileFilter f) {
        if (f == null) {
            return this;
        }
        return new FilterFileVisitor(f, this);
    }

    private static final class FilterFileVisitor
    extends FileVisitor
    implements Serializable {
        private final FileFilter filter;
        private final FileVisitor visitor;
        private static final FileFilter PASS_THROUGH = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        };
        private static final long serialVersionUID = 1L;

        private FilterFileVisitor(FileFilter filter, FileVisitor visitor) {
            this.filter = filter != null ? filter : PASS_THROUGH;
            this.visitor = visitor;
        }

        @Override
        public void visit(File f, String relativePath) throws IOException {
            if (f.isDirectory() || this.filter.accept(f)) {
                this.visitor.visit(f, relativePath);
            }
        }
    }
}

