/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.model.Saveable;
import hudson.util.CopyOnWriteList;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@BridgeMethodsAdded
public class PersistedList<T>
extends AbstractList<T> {
    protected final CopyOnWriteList<T> data = new CopyOnWriteList();
    protected Saveable owner = Saveable.NOOP;

    protected PersistedList() {
    }

    protected PersistedList(Collection<? extends T> initialList) {
        this.data.replaceBy(initialList);
    }

    public PersistedList(Saveable owner) {
        this.setOwner(owner);
    }

    public void setOwner(Saveable owner) {
        this.owner = owner;
    }

    @Override
    @WithBridgeMethods(value={void.class})
    public boolean add(T item) {
        this.data.add(item);
        this._onModified();
        return true;
    }

    @Override
    @WithBridgeMethods(value={void.class})
    public boolean addAll(Collection<? extends T> items) {
        this.data.addAll(items);
        this._onModified();
        return true;
    }

    public void replaceBy(Collection<? extends T> col) throws IOException {
        this.data.replaceBy(col);
        this.onModified();
    }

    @Override
    public T get(int index) {
        return this.data.get(index);
    }

    public <U extends T> U get(Class<U> type) {
        for (T t : this.data) {
            if (!type.isInstance(t)) continue;
            return type.cast(t);
        }
        return null;
    }

    public <U extends T> List<U> getAll(Class<U> type) {
        ArrayList<U> r = new ArrayList<U>();
        for (T t : this.data) {
            if (!type.isInstance(t)) continue;
            r.add(type.cast(t));
        }
        return r;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public void remove(Class<? extends T> type) throws IOException {
        for (T t : this.data) {
            if (t.getClass() != type) continue;
            this.data.remove(t);
            this.onModified();
            return;
        }
    }

    public void replace(T from, T to) throws IOException {
        ArrayList<T> copy = new ArrayList<T>(this.data.getView());
        for (int i = 0; i < copy.size(); ++i) {
            if (!copy.get(i).equals(from)) continue;
            copy.set(i, to);
        }
        this.data.replaceBy((Collection<T>)copy);
    }

    @Override
    public boolean remove(Object o) {
        boolean b = this.data.remove(o);
        if (b) {
            this._onModified();
        }
        return b;
    }

    public void removeAll(Class<? extends T> type) throws IOException {
        boolean modified = false;
        for (T t : this.data) {
            if (t.getClass() != type) continue;
            this.data.remove(t);
            modified = true;
        }
        if (modified) {
            this.onModified();
        }
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    protected void onModified() throws IOException {
        this.owner.save();
    }

    private void _onModified() {
        try {
            this.onModified();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> toList() {
        return this.data.getView();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.data.toArray(array);
    }

    public void addAllTo(Collection<? super T> dst) {
        this.data.addAllTo(dst);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object item) {
        return this.data.contains(item);
    }

    @Override
    public String toString() {
        return this.toList().toString();
    }

    public static class ConverterImpl
    extends AbstractCollectionConverter {
        CopyOnWriteList.ConverterImpl copyOnWriteListConverter = new CopyOnWriteList.ConverterImpl(this.mapper());

        public ConverterImpl(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return PersistedList.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            for (Object o : (PersistedList)source) {
                this.writeItem(o, context, writer);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            CopyOnWriteList core = this.copyOnWriteListConverter.unmarshal(reader, context);
            try {
                PersistedList r = (PersistedList)context.getRequiredType().newInstance();
                r.data.replaceBy(core);
                return r;
            }
            catch (InstantiationException e) {
                InstantiationError x = new InstantiationError();
                x.initCause(e);
                throw x;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
        }
    }
}

