/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.util.RobustReflectionConverter;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import jenkins.util.xstream.CriticalXStreamException;

public class RobustCollectionConverter
extends CollectionConverter {
    private final SerializableConverter sc;

    public RobustCollectionConverter(XStream xs) {
        this(xs.getMapper(), xs.getReflectionProvider());
    }

    public RobustCollectionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper);
        this.sc = new SerializableConverter(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return super.canConvert(type) || type == CopyOnWriteArrayList.class || type == CopyOnWriteArraySet.class;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String s = reader.getAttribute("serialization");
        if (s != null && s.equals("custom")) {
            return this.sc.unmarshal(reader, context);
        }
        return super.unmarshal(reader, context);
    }

    protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            try {
                Object item = this.readItem(reader, context, collection);
                collection.add(item);
            }
            catch (CriticalXStreamException e) {
                throw e;
            }
            catch (XStreamException e) {
                RobustReflectionConverter.addErrorInContext(context, e);
            }
            catch (LinkageError e) {
                RobustReflectionConverter.addErrorInContext(context, e);
            }
            reader.moveUp();
        }
    }
}

