/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.CloseProofOutputStream;
import hudson.console.ConsoleNote;
import hudson.console.HudsonExceptionNote;
import hudson.remoting.RemoteOutputStream;
import hudson.util.AbstractTaskListener;
import hudson.util.NullStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

public class StreamTaskListener
extends AbstractTaskListener
implements Serializable,
Closeable {
    private PrintStream out;
    private Charset charset;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(StreamTaskListener.class.getName());

    @Deprecated
    public StreamTaskListener(PrintStream out) {
        this(out, null);
    }

    public StreamTaskListener(OutputStream out) {
        this(out, null);
    }

    public StreamTaskListener(OutputStream out, Charset charset) {
        try {
            this.out = charset == null ? (out instanceof PrintStream ? (PrintStream)out : new PrintStream(out, false)) : new PrintStream(out, false, charset.name());
            this.charset = charset;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public StreamTaskListener(File out) throws IOException {
        this(out, null);
    }

    public StreamTaskListener(File out, Charset charset) throws IOException {
        this(new FileOutputStream(out), charset);
    }

    public StreamTaskListener(File out, boolean append, Charset charset) throws IOException {
        this(new FileOutputStream(out, append), charset);
    }

    public StreamTaskListener(Writer w) throws IOException {
        this((OutputStream)new WriterOutputStream(w));
    }

    @Deprecated
    public StreamTaskListener() throws IOException {
        this(new NullStream());
    }

    public static StreamTaskListener fromStdout() {
        return new StreamTaskListener(System.out, Charset.defaultCharset());
    }

    public static StreamTaskListener fromStderr() {
        return new StreamTaskListener(System.err, Charset.defaultCharset());
    }

    @Override
    public PrintStream getLogger() {
        return this.out;
    }

    private PrintWriter _error(String prefix, String msg) {
        this.out.print(prefix);
        this.out.println(msg);
        try {
            this.annotate(new HudsonExceptionNote());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new PrintWriter((Writer)(this.charset != null ? new OutputStreamWriter((OutputStream)this.out, this.charset) : new OutputStreamWriter(this.out)), true);
    }

    @Override
    public PrintWriter error(String msg) {
        return this._error("ERROR: ", msg);
    }

    @Override
    public PrintWriter error(String format, Object ... args) {
        return this.error(String.format(format, args));
    }

    @Override
    public PrintWriter fatalError(String msg) {
        return this._error("FATAL: ", msg);
    }

    @Override
    public PrintWriter fatalError(String format, Object ... args) {
        return this.fatalError(String.format(format, args));
    }

    @Override
    public void annotate(ConsoleNote ann) throws IOException {
        ann.encodeTo(this.out);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(new RemoteOutputStream(new CloseProofOutputStream(this.out)));
        out.writeObject(this.charset == null ? null : this.charset.name());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.out = new PrintStream((OutputStream)in.readObject(), true);
        String name = (String)in.readObject();
        this.charset = name == null ? null : Charset.forName(name);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to close", e);
        }
    }
}

