/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ReopenableFileOutputStream
extends OutputStream {
    protected final File out;
    private OutputStream current;
    private boolean appendOnNextOpen = false;

    public ReopenableFileOutputStream(File out) {
        this.out = out;
    }

    private synchronized OutputStream current() throws IOException {
        if (this.current == null) {
            try {
                this.current = new FileOutputStream(this.out, this.appendOnNextOpen);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Failed to open " + this.out, e);
            }
        }
        return this.current;
    }

    @Override
    public void write(int b) throws IOException {
        this.current().write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.current().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.current().write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.current().flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.current != null) {
            this.current.close();
            this.appendOnNextOpen = true;
            this.current = null;
        }
    }

    public synchronized void rewind() throws IOException {
        this.close();
        this.appendOnNextOpen = false;
    }
}

