/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.spring;

import hudson.util.spring.BeanConfiguration;
import hudson.util.spring.DefaultBeanConfiguration;
import hudson.util.spring.RuntimeSpringConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StaticWebApplicationContext;

class DefaultRuntimeSpringConfiguration
implements RuntimeSpringConfiguration {
    private static final Logger LOGGER = Logger.getLogger(DefaultRuntimeSpringConfiguration.class.getName());
    private StaticWebApplicationContext context;
    private Map<String, BeanConfiguration> beanConfigs = new HashMap<String, BeanConfiguration>();
    private Map<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
    private List<String> beanNames = new ArrayList<String>();

    public DefaultRuntimeSpringConfiguration() {
        this.context = new StaticWebApplicationContext();
    }

    public DefaultRuntimeSpringConfiguration(ApplicationContext parent) {
        this.context = new StaticWebApplicationContext();
        this.context.setParent(parent);
    }

    @Override
    public BeanConfiguration addSingletonBean(String name, Class clazz) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public BeanConfiguration addPrototypeBean(String name, Class clazz) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz, true);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public WebApplicationContext getApplicationContext() {
        this.registerBeansWithContext((StaticApplicationContext)this.context);
        this.context.refresh();
        return this.context;
    }

    @Override
    public WebApplicationContext getUnrefreshedApplicationContext() {
        return this.context;
    }

    @Override
    public BeanConfiguration addSingletonBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public BeanConfiguration createSingletonBean(Class clazz) {
        return new DefaultBeanConfiguration(clazz);
    }

    @Override
    public BeanConfiguration addSingletonBean(String name, Class clazz, Collection args) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz, args);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public BeanConfiguration addPrototypeBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, true);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    private void registerBeanConfiguration(String name, BeanConfiguration bc) {
        this.beanConfigs.put(name, bc);
        this.beanNames.add(name);
    }

    @Override
    public BeanConfiguration createSingletonBean(Class clazz, Collection constructorArguments) {
        return new DefaultBeanConfiguration(clazz, constructorArguments);
    }

    @Override
    public void setServletContext(ServletContext context) {
        this.context.setServletContext(context);
    }

    @Override
    public BeanConfiguration createPrototypeBean(String name) {
        return new DefaultBeanConfiguration(name, true);
    }

    @Override
    public BeanConfiguration createSingletonBean(String name) {
        return new DefaultBeanConfiguration(name);
    }

    @Override
    public void addBeanConfiguration(String beanName, BeanConfiguration beanConfiguration) {
        beanConfiguration.setName(beanName);
        this.registerBeanConfiguration(beanName, beanConfiguration);
    }

    @Override
    public void addBeanDefinition(String name, BeanDefinition bd) {
        this.beanDefinitions.put(name, bd);
        this.beanNames.add(name);
    }

    @Override
    public boolean containsBean(String name) {
        return this.beanNames.contains(name);
    }

    @Override
    public BeanConfiguration getBeanConfig(String name) {
        return this.beanConfigs.get(name);
    }

    @Override
    public AbstractBeanDefinition createBeanDefinition(String name) {
        if (this.containsBean(name)) {
            if (this.beanDefinitions.containsKey(name)) {
                return (AbstractBeanDefinition)this.beanDefinitions.get(name);
            }
            if (this.beanConfigs.containsKey(name)) {
                return this.beanConfigs.get(name).getBeanDefinition();
            }
        }
        return null;
    }

    @Override
    public void registerPostProcessor(BeanFactoryPostProcessor processor) {
        this.context.addBeanFactoryPostProcessor(processor);
    }

    @Override
    public List<String> getBeanNames() {
        return this.beanNames;
    }

    @Override
    public void registerBeansWithContext(StaticApplicationContext applicationContext) {
        for (BeanConfiguration bc : this.beanConfigs.values()) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("[RuntimeConfiguration] Registering bean [" + bc.getName() + "]");
                if (LOGGER.isLoggable(Level.FINEST)) {
                    PropertyValue[] pvs;
                    for (PropertyValue pv : pvs = bc.getBeanDefinition().getPropertyValues().getPropertyValues()) {
                        LOGGER.finest("[RuntimeConfiguration] With property [" + pv.getName() + "] set to [" + pv.getValue() + "]");
                    }
                }
            }
            if (applicationContext.containsBeanDefinition(bc.getName())) {
                applicationContext.removeBeanDefinition(bc.getName());
            }
            applicationContext.registerBeanDefinition(bc.getName(), (BeanDefinition)bc.getBeanDefinition());
        }
        for (String key : this.beanDefinitions.keySet()) {
            BeanDefinition bd = this.beanDefinitions.get(key);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("[RuntimeConfiguration] Registering bean [" + key + "]");
                if (LOGGER.isLoggable(Level.FINEST)) {
                    for (PropertyValue pv : bd.getPropertyValues().getPropertyValues()) {
                        LOGGER.finest("[RuntimeConfiguration] With property [" + pv.getName() + "] set to [" + pv.getValue() + "]");
                    }
                }
            }
            if (applicationContext.containsBean(key)) {
                applicationContext.removeBeanDefinition(key);
            }
            applicationContext.registerBeanDefinition(key, bd);
        }
    }

    @Override
    public BeanConfiguration addAbstractBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name);
        bc.setAbstract(true);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }
}

