/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.util.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import jenkins.security.ConfidentialKey;
import jenkins.security.ConfidentialStore;

public class CryptoConfidentialKey
extends ConfidentialKey {
    private volatile SecretKey secret;
    private static final String ALGORITHM = "AES";

    public CryptoConfidentialKey(String id) {
        super(id);
    }

    public CryptoConfidentialKey(Class owner, String shortName) {
        this(owner.getName() + '.' + shortName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getKey() {
        try {
            if (this.secret == null) {
                CryptoConfidentialKey cryptoConfidentialKey = this;
                synchronized (cryptoConfidentialKey) {
                    if (this.secret == null) {
                        byte[] payload = this.load();
                        if (payload == null) {
                            payload = ConfidentialStore.get().randomBytes(256);
                            this.store(payload);
                        }
                        this.secret = new SecretKeySpec(payload, 0, 16, ALGORITHM);
                    }
                }
            }
            return this.secret;
        }
        catch (IOException e) {
            throw new Error("Failed to load the key: " + this.getId(), e);
        }
    }

    public Cipher encrypt() {
        try {
            Cipher cipher = Secret.getCipher(ALGORITHM);
            cipher.init(1, this.getKey());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Cipher decrypt() {
        try {
            Cipher cipher = Secret.getCipher(ALGORITHM);
            cipher.init(2, this.getKey());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }
}

