/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import hudson.Extension;
import hudson.remoting.ChannelBuilder;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.security.ChannelConfigurator;
import jenkins.security.Roles;
import jenkins.security.s2m.CallableWhitelist;
import jenkins.util.SystemProperties;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CallableDirectionChecker
extends RoleChecker {
    private final Object context;
    private static final String BYPASS_PROP = CallableDirectionChecker.class.getName() + ".allow";
    public static boolean BYPASS = SystemProperties.getBoolean(BYPASS_PROP);
    private static final Logger LOGGER = Logger.getLogger(CallableDirectionChecker.class.getName());

    private CallableDirectionChecker(Object context) {
        this.context = context;
    }

    @Override
    public void check(RoleSensitive subject, @Nonnull Collection<Role> expected) throws SecurityException {
        String name = subject.getClass().getName();
        if (expected.contains(Roles.MASTER)) {
            LOGGER.log(Level.FINE, "Executing {0} is allowed since it is targeted for the master role", name);
            return;
        }
        if (this.isWhitelisted(subject, expected)) {
            LOGGER.log(Level.FINE, "Explicitly allowing {0} to be sent from agent to master", name);
            return;
        }
        throw new SecurityException("Sending " + name + " from agent to master is prohibited.\nSee http://jenkins-ci.org/security-144 for more details");
    }

    private boolean isWhitelisted(RoleSensitive subject, Collection<Role> expected) {
        for (CallableWhitelist w : CallableWhitelist.all()) {
            if (!w.isWhitelisted(subject, expected, this.context)) continue;
            return true;
        }
        return false;
    }

    @Extension(ordinal=100.0)
    public static class DefaultWhitelist
    extends CallableWhitelist {
        @Override
        public boolean isWhitelisted(RoleSensitive subject, Collection<Role> expected, Object context) {
            return BYPASS;
        }
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    public static class ChannelConfiguratorImpl
    extends ChannelConfigurator {
        @Override
        public void onChannelBuilding(ChannelBuilder builder, Object context) {
            if (!BYPASS) {
                builder.withRemoteClassLoadingAllowed(false);
            }
            builder.withRoleChecker(new CallableDirectionChecker(context));
        }
    }
}

