/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.widgets.HistoryWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.widgets.HistoryPageEntry;

public class HistoryPageFilter<T> {
    private final int maxEntries;
    private Long newerThan;
    private Long olderThan;
    private String searchString;
    public final List<HistoryPageEntry<Queue.Item>> queueItems = new ArrayList<HistoryPageEntry<Queue.Item>>();
    public final List<HistoryPageEntry<Run>> runs = new ArrayList<HistoryPageEntry<Run>>();
    public boolean hasUpPage = false;
    public boolean hasDownPage = false;
    public long nextBuildNumber;
    public HistoryWidget widget;
    public long newestOnPage = Long.MIN_VALUE;
    public long oldestOnPage = Long.MAX_VALUE;

    public HistoryPageFilter(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setNewerThan(Long newerThan) {
        if (this.olderThan != null) {
            throw new UnsupportedOperationException("Cannot set 'newerThan'. 'olderThan' already set.");
        }
        this.newerThan = newerThan;
    }

    public void setOlderThan(Long olderThan) {
        if (this.newerThan != null) {
            throw new UnsupportedOperationException("Cannot set 'olderThan'. 'newerThan' already set.");
        }
        this.olderThan = olderThan;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }

    public void add(@Nonnull List<T> items) {
        block18: {
            block19: {
                int i;
                block17: {
                    if (items.isEmpty()) {
                        return;
                    }
                    this.sort(items);
                    this.nextBuildNumber = this.getNextBuildNumber(items.get(0));
                    if (this.newerThan != null || this.olderThan != null) break block17;
                    for (T item : items) {
                        this.add(item);
                        if (!this.isFull()) continue;
                        break;
                    }
                    this.hasDownPage = items.size() > this.maxEntries;
                    break block18;
                }
                if (this.newerThan == null) break block19;
                int toFillCount = this.getFillCount();
                if (toFillCount <= 0) break block18;
                long newestInList = HistoryPageEntry.getEntryId(items.get(0));
                long oldestInList = HistoryPageEntry.getEntryId(items.get(items.size() - 1));
                int newerThanIdx = -1;
                if (this.newerThan <= newestInList) {
                    if (this.newerThan >= oldestInList) {
                        for (i = 0; i < items.size(); ++i) {
                            T item = items.get(i);
                            if (HistoryPageEntry.getEntryId(item) > this.newerThan) continue;
                            newerThanIdx = i;
                            break;
                        }
                    } else if (this.newerThan < oldestInList) {
                        newerThanIdx = items.size();
                    }
                }
                if (newerThanIdx != -1) {
                    if (newerThanIdx <= this.maxEntries) {
                        int itemCountToAdd = Math.min(toFillCount, items.size());
                        for (int i2 = 0; i2 < itemCountToAdd; ++i2) {
                            this.add(items.get(i2));
                        }
                    } else {
                        for (i = newerThanIdx - toFillCount; i < newerThanIdx; ++i) {
                            this.add(items.get(i));
                        }
                        this.hasUpPage = true;
                    }
                    this.hasDownPage = items.size() > newerThanIdx + 1;
                } else {
                    this.hasDownPage = true;
                }
                break block18;
            }
            if (this.olderThan != null) {
                for (int i = 0; i < items.size(); ++i) {
                    T item = items.get(i);
                    if (HistoryPageEntry.getEntryId(item) >= this.olderThan) {
                        this.hasUpPage = true;
                        continue;
                    }
                    this.add(item);
                    if (!this.isFull()) continue;
                    this.hasDownPage = i + 1 < items.size();
                    break;
                }
            }
        }
    }

    public int size() {
        return this.queueItems.size() + this.runs.size();
    }

    private void sort(List<T> items) {
        Collections.sort(items, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                long o2QID;
                long o1QID = HistoryPageEntry.getEntryId(o1);
                if (o1QID < (o2QID = HistoryPageEntry.getEntryId(o2))) {
                    return 1;
                }
                if (o1QID == o2QID) {
                    return 0;
                }
                return -1;
            }
        });
    }

    private long getNextBuildNumber(@Nonnull T entry) {
        if (entry instanceof Queue.Item) {
            Queue.Task task = ((Queue.Item)entry).task;
            if (task instanceof Job) {
                return ((Job)((Object)task)).getNextBuildNumber();
            }
        } else if (entry instanceof Run) {
            return ((Job)((Run)entry).getParent()).getNextBuildNumber();
        }
        return HistoryPageEntry.getEntryId(entry) + 1L;
    }

    private void addQueueItem(Queue.Item item) {
        HistoryPageEntry<Queue.Item> entry = new HistoryPageEntry<Queue.Item>(item);
        this.queueItems.add(entry);
        this.updateNewestOldest(entry.getEntryId());
    }

    private void addRun(Run run) {
        HistoryPageEntry<Run> entry = new HistoryPageEntry<Run>(run);
        this.runs.add(entry);
        this.updateNewestOldest(entry.getEntryId());
    }

    private void updateNewestOldest(long entryId) {
        this.newestOnPage = Math.max(this.newestOnPage, entryId);
        this.oldestOnPage = Math.min(this.oldestOnPage, entryId);
    }

    private boolean add(T entry) {
        if (entry instanceof Queue.Item) {
            Queue.Item item = (Queue.Item)entry;
            if (this.searchString != null && !this.fitsSearchParams(item)) {
                return false;
            }
            this.addQueueItem(item);
            return true;
        }
        if (entry instanceof Run) {
            Run run = (Run)entry;
            if (this.searchString != null && !this.fitsSearchParams(run)) {
                return false;
            }
            this.addRun(run);
            return true;
        }
        return false;
    }

    private boolean isFull() {
        return this.size() >= this.maxEntries;
    }

    private int getFillCount() {
        return Math.max(0, this.maxEntries - this.size());
    }

    private boolean fitsSearchParams(@Nonnull Queue.Item item) {
        if (this.fitsSearchString(item.getDisplayName())) {
            return true;
        }
        return this.fitsSearchString(item.getId());
    }

    private boolean fitsSearchParams(@Nonnull Run run) {
        if (this.searchString == null) {
            return true;
        }
        if (this.fitsSearchString(run.getDisplayName())) {
            return true;
        }
        if (this.fitsSearchString(run.getDescription())) {
            return true;
        }
        if (this.fitsSearchString(run.getNumber())) {
            return true;
        }
        if (this.fitsSearchString(run.getQueueId())) {
            return true;
        }
        return this.fitsSearchString(run.getResult());
    }

    private boolean fitsSearchString(Object data) {
        if (this.searchString == null) {
            return true;
        }
        if (data != null) {
            if (data instanceof Number) {
                return data.toString().equals(this.searchString);
            }
            return data.toString().toLowerCase().contains(this.searchString);
        }
        return false;
    }
}

