/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jcifs.util.Encdec;
import ndr.NdrException;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComObjectImpl;
import org.jinterop.dcom.core.JICurrency;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIInterfacePointerBody;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIUnion;
import org.jinterop.dcom.core.JIUnsignedByte;
import org.jinterop.dcom.core.JIUnsignedFactory;
import org.jinterop.dcom.core.JIUnsignedInteger;
import org.jinterop.dcom.core.JIUnsignedShort;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.core.VariantBody;
import rpc.core.UUID;

final class JIMarshalUnMarshalHelper {
    private static Map mapOfSerializers = new HashMap();
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JICurrency;
    static /* synthetic */ Class class$org$jinterop$dcom$core$VariantBody;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIVariant;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$rpc$core$UUID;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIInterfacePointer;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIInterfacePointerBody;
    static /* synthetic */ Class class$org$jinterop$dcom$impls$automation$IJIDispatch;
    static /* synthetic */ Class class$org$jinterop$dcom$core$IJIComObject;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIPointer;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIStruct;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIUnion;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIString;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIUnsignedByte;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIUnsignedShort;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIUnsignedInteger;
    static /* synthetic */ Class class$org$jinterop$dcom$core$JIArray;

    JIMarshalUnMarshalHelper() {
    }

    static byte[] readOctetArrayLE(NetworkDataRepresentation ndr, int length) {
        byte[] bytes = new byte[8];
        ndr.readOctetArray(bytes, 0, 8);
        for (int i = 0; i < 4; ++i) {
            byte t = bytes[i];
            bytes[i] = bytes[7 - i];
            bytes[7 - i] = t;
        }
        return bytes;
    }

    static void writeOctetArrayLE(NetworkDataRepresentation ndr, byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            ndr.writeUnsignedSmall((int)b[b.length - i - 1]);
        }
    }

    static void serialize(NetworkDataRepresentation ndr, Class c, Object value, List defferedPointers, int FLAG) {
        if (c.equals(class$org$jinterop$dcom$core$JIArray == null ? (class$org$jinterop$dcom$core$JIArray = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIArray")) : class$org$jinterop$dcom$core$JIArray)) {
            ((JIArray)value).encode(ndr, ((JIArray)value).getArrayInstance(), defferedPointers, FLAG);
        } else {
            if ((c != (class$org$jinterop$dcom$core$IJIComObject == null ? (class$org$jinterop$dcom$core$IJIComObject = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.IJIComObject")) : class$org$jinterop$dcom$core$IJIComObject) || c != (class$org$jinterop$dcom$impls$automation$IJIDispatch == null ? (class$org$jinterop$dcom$impls$automation$IJIDispatch = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.impls.automation.IJIDispatch")) : class$org$jinterop$dcom$impls$automation$IJIDispatch)) && value instanceof IJIComObject) {
                c = class$org$jinterop$dcom$core$IJIComObject == null ? (class$org$jinterop$dcom$core$IJIComObject = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.IJIComObject")) : class$org$jinterop$dcom$core$IJIComObject;
            }
            JIMarshalUnMarshalHelper.alignMemberWhileEncoding(ndr, c, value);
            if (c.equals(class$org$jinterop$dcom$core$JIString == null ? (class$org$jinterop$dcom$core$JIString = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIString")) : class$org$jinterop$dcom$core$JIString)) {
                ((JIString)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(class$org$jinterop$dcom$core$JIPointer == null ? (class$org$jinterop$dcom$core$JIPointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIPointer")) : class$org$jinterop$dcom$core$JIPointer)) {
                ((JIPointer)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(class$org$jinterop$dcom$core$JIStruct == null ? (class$org$jinterop$dcom$core$JIStruct = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIStruct")) : class$org$jinterop$dcom$core$JIStruct)) {
                ((JIStruct)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(class$org$jinterop$dcom$core$JIUnion == null ? (class$org$jinterop$dcom$core$JIUnion = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIUnion")) : class$org$jinterop$dcom$core$JIUnion)) {
                ((JIUnion)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(class$org$jinterop$dcom$core$JIInterfacePointer == null ? (class$org$jinterop$dcom$core$JIInterfacePointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIInterfacePointer")) : class$org$jinterop$dcom$core$JIInterfacePointer)) {
                ((JIInterfacePointer)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(class$org$jinterop$dcom$core$JIVariant == null ? (class$org$jinterop$dcom$core$JIVariant = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIVariant")) : class$org$jinterop$dcom$core$JIVariant)) {
                ((JIVariant)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (c.equals(class$org$jinterop$dcom$core$VariantBody == null ? (class$org$jinterop$dcom$core$VariantBody = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.VariantBody")) : class$org$jinterop$dcom$core$VariantBody)) {
                ((VariantBody)value).encode(ndr, defferedPointers, FLAG);
                return;
            }
            if (mapOfSerializers.get(c) == null) {
                throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), c.toString()));
            }
            ((SerializerDeserializer)mapOfSerializers.get(c)).serializeData(ndr, value, defferedPointers, FLAG);
        }
    }

    static void alignMemberWhileEncoding(NetworkDataRepresentation ndr, Class c, Object obj) {
        double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
        if (c.equals(class$org$jinterop$dcom$core$JIStruct == null ? (class$org$jinterop$dcom$core$JIStruct = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIStruct")) : class$org$jinterop$dcom$core$JIStruct)) {
            double align = new Integer(((JIStruct)obj).getAlignment()).doubleValue();
            long i = Math.round(index % align);
            i = (long)(i == 0L ? 0.0 : align - (double)i);
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(class$org$jinterop$dcom$core$JIUnion == null ? (class$org$jinterop$dcom$core$JIUnion = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIUnion")) : class$org$jinterop$dcom$core$JIUnion)) {
            double align = new Integer(((JIUnion)obj).getAlignment()).doubleValue();
            long i = Math.round(index % align);
            i = (long)(i == 0L ? 0.0 : align - (double)i);
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JIMarshalUnMarshalHelper.class$("java.lang.Integer")) : class$java$lang$Integer) || c.equals(class$java$lang$Float == null ? (class$java$lang$Float = JIMarshalUnMarshalHelper.class$("java.lang.Float")) : class$java$lang$Float) || c.equals(class$org$jinterop$dcom$core$JIVariant == null ? (class$org$jinterop$dcom$core$JIVariant = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIVariant")) : class$org$jinterop$dcom$core$JIVariant) || c.equals(class$java$lang$String == null ? (class$java$lang$String = JIMarshalUnMarshalHelper.class$("java.lang.String")) : class$java$lang$String) || c.equals(class$org$jinterop$dcom$core$JIPointer == null ? (class$org$jinterop$dcom$core$JIPointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIPointer")) : class$org$jinterop$dcom$core$JIPointer)) {
            long i = Math.round(index % 4.0);
            i = i == 0L ? 0L : 4L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(class$java$lang$Double == null ? (class$java$lang$Double = JIMarshalUnMarshalHelper.class$("java.lang.Double")) : class$java$lang$Double)) {
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(class$java$lang$Short == null ? (class$java$lang$Short = JIMarshalUnMarshalHelper.class$("java.lang.Short")) : class$java$lang$Short)) {
            long i = Math.round(index % 2.0);
            i = i == 0L ? 0L : 2L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
        }
    }

    static void alignMemberWhileDecoding(NetworkDataRepresentation ndr, Class c, Object obj) {
        double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
        if (c.equals(class$org$jinterop$dcom$core$JIStruct == null ? (class$org$jinterop$dcom$core$JIStruct = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIStruct")) : class$org$jinterop$dcom$core$JIStruct)) {
            double align = new Integer(((JIStruct)obj).getAlignment()).doubleValue();
            long i = Math.round(index % align);
            i = (long)(i == 0L ? 0.0 : align - (double)i);
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(class$org$jinterop$dcom$core$JIUnion == null ? (class$org$jinterop$dcom$core$JIUnion = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIUnion")) : class$org$jinterop$dcom$core$JIUnion)) {
            double align = new Integer(((JIUnion)obj).getAlignment()).doubleValue();
            long i = Math.round(index % align);
            i = (long)(i == 0L ? 0.0 : align - (double)i);
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JIMarshalUnMarshalHelper.class$("java.lang.Integer")) : class$java$lang$Integer) || c.equals(class$java$lang$Float == null ? (class$java$lang$Float = JIMarshalUnMarshalHelper.class$("java.lang.Float")) : class$java$lang$Float) || c.equals(class$org$jinterop$dcom$core$JIVariant == null ? (class$org$jinterop$dcom$core$JIVariant = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIVariant")) : class$org$jinterop$dcom$core$JIVariant) || c.equals(class$java$lang$String == null ? (class$java$lang$String = JIMarshalUnMarshalHelper.class$("java.lang.String")) : class$java$lang$String) || c.equals(class$org$jinterop$dcom$core$JIPointer == null ? (class$org$jinterop$dcom$core$JIPointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIPointer")) : class$org$jinterop$dcom$core$JIPointer)) {
            long i = Math.round(index % 4.0);
            i = i == 0L ? 0L : 4L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(class$java$lang$Double == null ? (class$java$lang$Double = JIMarshalUnMarshalHelper.class$("java.lang.Double")) : class$java$lang$Double)) {
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        } else if (c.equals(class$java$lang$Short == null ? (class$java$lang$Short = JIMarshalUnMarshalHelper.class$("java.lang.Short")) : class$java$lang$Short)) {
            long i = Math.round(index % 2.0);
            i = i == 0L ? 0L : 2L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
        }
    }

    static Object deSerialize(NetworkDataRepresentation ndr, Object obj, List defferedPointers, int FLAG, Map additionalData) {
        Class<?> c = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (c.equals(class$org$jinterop$dcom$core$JIArray == null ? (class$org$jinterop$dcom$core$JIArray = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIArray")) : class$org$jinterop$dcom$core$JIArray)) {
            return ((JIArray)obj).decode(ndr, ((JIArray)obj).getArrayClass(), ((JIArray)obj).getDimensions(), defferedPointers, FLAG, additionalData);
        }
        JIMarshalUnMarshalHelper.alignMemberWhileDecoding(ndr, c, obj);
        if (c.equals(class$org$jinterop$dcom$core$JIPointer == null ? (class$org$jinterop$dcom$core$JIPointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIPointer")) : class$org$jinterop$dcom$core$JIPointer)) {
            JIPointer retVal = ((JIPointer)obj).decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (c.equals(class$org$jinterop$dcom$core$JIStruct == null ? (class$org$jinterop$dcom$core$JIStruct = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIStruct")) : class$org$jinterop$dcom$core$JIStruct)) {
            JIStruct retVal = ((JIStruct)obj).decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (c.equals(class$org$jinterop$dcom$core$JIUnion == null ? (class$org$jinterop$dcom$core$JIUnion = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIUnion")) : class$org$jinterop$dcom$core$JIUnion)) {
            JIUnion retVal = ((JIUnion)obj).decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (c.equals(class$org$jinterop$dcom$core$JIString == null ? (class$org$jinterop$dcom$core$JIString = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIString")) : class$org$jinterop$dcom$core$JIString)) {
            JIString retVal = ((JIString)obj).decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (obj.equals(class$org$jinterop$dcom$core$JIInterfacePointer == null ? (class$org$jinterop$dcom$core$JIInterfacePointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIInterfacePointer")) : class$org$jinterop$dcom$core$JIInterfacePointer)) {
            JIInterfacePointer retVal = JIInterfacePointer.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (obj.equals(class$org$jinterop$dcom$core$JIVariant == null ? (class$org$jinterop$dcom$core$JIVariant = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIVariant")) : class$org$jinterop$dcom$core$JIVariant)) {
            JIVariant retVal = JIVariant.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (obj.equals(class$org$jinterop$dcom$core$VariantBody == null ? (class$org$jinterop$dcom$core$VariantBody = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.VariantBody")) : class$org$jinterop$dcom$core$VariantBody)) {
            VariantBody retVal = VariantBody.decode(ndr, defferedPointers, FLAG, additionalData);
            return retVal;
        }
        if (mapOfSerializers.get(obj) == null) {
            throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), obj.toString()));
        }
        return ((SerializerDeserializer)mapOfSerializers.get(obj)).deserializeData(ndr, defferedPointers, additionalData, FLAG);
    }

    static int getLengthInBytes(Class c, Object obj, int FLAG) {
        if (obj != null && obj.getClass().equals(class$org$jinterop$dcom$core$JIArray == null ? (class$org$jinterop$dcom$core$JIArray = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIArray")) : class$org$jinterop$dcom$core$JIArray)) {
            return ((JIArray)obj).getSizeOfAllElementsInBytes();
        }
        if ((c != (class$org$jinterop$dcom$core$IJIComObject == null ? (class$org$jinterop$dcom$core$IJIComObject = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.IJIComObject")) : class$org$jinterop$dcom$core$IJIComObject) || c != (class$org$jinterop$dcom$impls$automation$IJIDispatch == null ? (class$org$jinterop$dcom$impls$automation$IJIDispatch = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.impls.automation.IJIDispatch")) : class$org$jinterop$dcom$impls$automation$IJIDispatch)) && obj instanceof IJIComObject) {
            Class clazz = c = class$org$jinterop$dcom$core$IJIComObject == null ? (class$org$jinterop$dcom$core$IJIComObject = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.IJIComObject")) : class$org$jinterop$dcom$core$IJIComObject;
        }
        if ((SerializerDeserializer)mapOfSerializers.get(c) == null) {
            throw new IllegalStateException(MessageFormat.format(JISystem.getLocalizedMessage(4111), c.toString()));
        }
        return ((SerializerDeserializer)mapOfSerializers.get(c)).getLengthInBytes(obj, FLAG);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mapOfSerializers.put(class$java$util$Date == null ? (class$java$util$Date = JIMarshalUnMarshalHelper.class$("java.util.Date")) : class$java$util$Date, new DateImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JICurrency == null ? (class$org$jinterop$dcom$core$JICurrency = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JICurrency")) : class$org$jinterop$dcom$core$JICurrency, new JICurrencyImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$VariantBody == null ? (class$org$jinterop$dcom$core$VariantBody = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.VariantBody")) : class$org$jinterop$dcom$core$VariantBody, new JIVariant2Impl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIVariant == null ? (class$org$jinterop$dcom$core$JIVariant = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIVariant")) : class$org$jinterop$dcom$core$JIVariant, new JIVariantImpl());
        mapOfSerializers.put(class$java$lang$Double == null ? (class$java$lang$Double = JIMarshalUnMarshalHelper.class$("java.lang.Double")) : class$java$lang$Double, new DoubleImpl());
        mapOfSerializers.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JIMarshalUnMarshalHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanImpl());
        mapOfSerializers.put(class$java$lang$Short == null ? (class$java$lang$Short = JIMarshalUnMarshalHelper.class$("java.lang.Short")) : class$java$lang$Short, new ShortImpl());
        mapOfSerializers.put(class$java$lang$Integer == null ? (class$java$lang$Integer = JIMarshalUnMarshalHelper.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerImpl());
        mapOfSerializers.put(class$java$lang$Float == null ? (class$java$lang$Float = JIMarshalUnMarshalHelper.class$("java.lang.Float")) : class$java$lang$Float, new FloatImpl());
        mapOfSerializers.put(class$java$lang$String == null ? (class$java$lang$String = JIMarshalUnMarshalHelper.class$("java.lang.String")) : class$java$lang$String, new StringImpl());
        mapOfSerializers.put(class$rpc$core$UUID == null ? (class$rpc$core$UUID = JIMarshalUnMarshalHelper.class$("rpc.core.UUID")) : class$rpc$core$UUID, new UUIDImpl());
        mapOfSerializers.put(class$java$lang$Byte == null ? (class$java$lang$Byte = JIMarshalUnMarshalHelper.class$("java.lang.Byte")) : class$java$lang$Byte, new ByteImpl());
        mapOfSerializers.put(class$java$lang$Long == null ? (class$java$lang$Long = JIMarshalUnMarshalHelper.class$("java.lang.Long")) : class$java$lang$Long, new LongImpl());
        mapOfSerializers.put(class$java$lang$Character == null ? (class$java$lang$Character = JIMarshalUnMarshalHelper.class$("java.lang.Character")) : class$java$lang$Character, new CharacterImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIInterfacePointer == null ? (class$org$jinterop$dcom$core$JIInterfacePointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIInterfacePointer")) : class$org$jinterop$dcom$core$JIInterfacePointer, new MInterfacePointerImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIInterfacePointerBody == null ? (class$org$jinterop$dcom$core$JIInterfacePointerBody = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIInterfacePointerBody")) : class$org$jinterop$dcom$core$JIInterfacePointerBody, new MInterfacePointerImpl2());
        mapOfSerializers.put(class$org$jinterop$dcom$impls$automation$IJIDispatch == null ? (class$org$jinterop$dcom$impls$automation$IJIDispatch = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.impls.automation.IJIDispatch")) : class$org$jinterop$dcom$impls$automation$IJIDispatch, new IJIComObjectSerDer());
        mapOfSerializers.put(class$org$jinterop$dcom$core$IJIComObject == null ? (class$org$jinterop$dcom$core$IJIComObject = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.IJIComObject")) : class$org$jinterop$dcom$core$IJIComObject, new IJIComObjectSerDer());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIPointer == null ? (class$org$jinterop$dcom$core$JIPointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIPointer")) : class$org$jinterop$dcom$core$JIPointer, new PointerImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIStruct == null ? (class$org$jinterop$dcom$core$JIStruct = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIStruct")) : class$org$jinterop$dcom$core$JIStruct, new StructImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIUnion == null ? (class$org$jinterop$dcom$core$JIUnion = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIUnion")) : class$org$jinterop$dcom$core$JIUnion, new UnionImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIString == null ? (class$org$jinterop$dcom$core$JIString = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIString")) : class$org$jinterop$dcom$core$JIString, new JIStringImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIUnsignedByte == null ? (class$org$jinterop$dcom$core$JIUnsignedByte = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIUnsignedByte")) : class$org$jinterop$dcom$core$JIUnsignedByte, new JIUnsignedByteImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIUnsignedShort == null ? (class$org$jinterop$dcom$core$JIUnsignedShort = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIUnsignedShort")) : class$org$jinterop$dcom$core$JIUnsignedShort, new JIUnsignedShortImpl());
        mapOfSerializers.put(class$org$jinterop$dcom$core$JIUnsignedInteger == null ? (class$org$jinterop$dcom$core$JIUnsignedInteger = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIUnsignedInteger")) : class$org$jinterop$dcom$core$JIUnsignedInteger, new JIUnsignedIntImpl());
    }

    private static class MInterfacePointerImpl2
    implements SerializerDeserializer {
        private MInterfacePointerImpl2() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            ((JIInterfacePointerBody)value).encode(ndr, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            return JIInterfacePointerBody.decode(ndr, FLAG);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIInterfacePointerBody)value).getLength();
        }
    }

    private static class MInterfacePointerImpl
    implements SerializerDeserializer {
        private MInterfacePointerImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIInterfacePointer)value).getLength();
        }
    }

    private static class UUIDImpl
    implements SerializerDeserializer {
        private UUIDImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            try {
                ((UUID)value).encode(ndr, ndr.getBuffer());
            }
            catch (NdrException e) {
                JISystem.getLogger().throwing("UUIDImpl", "serializeData", e);
            }
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            UUID ret = new UUID();
            try {
                ret.decode(ndr, ndr.getBuffer());
            }
            catch (NdrException e) {
                JISystem.getLogger().throwing("UUIDImpl", "deserializeData", e);
                ret = null;
            }
            return ret;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 16;
        }
    }

    private static class JIStringImpl
    implements SerializerDeserializer {
        private JIStringImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            int length = 4;
            if (((JIString)value).getString() == null) {
                return length;
            }
            return (length += ((JIString)value).getType() == 2 ? 0 : 2) + JIMarshalUnMarshalHelper.getLengthInBytes(class$java$lang$String == null ? (class$java$lang$String = JIMarshalUnMarshalHelper.class$("java.lang.String")) : class$java$lang$String, ((JIString)value).getString(), ((JIString)value).getType() | FLAG);
        }
    }

    private static class StringImpl
    implements SerializerDeserializer {
        private StringImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            if ((FLAG & 0x4000) != 16384) {
                throw new JIRuntimeException(4165);
            }
            String str = (String)value;
            if (str == null) {
                str = "";
            }
            if ((FLAG & 1) == 1) {
                byte[] strBytes = null;
                try {
                    strBytes = str.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new JIRuntimeException(4153);
                }
                ndr.writeUnsignedLong(strBytes.length / 2);
                ndr.writeUnsignedLong(strBytes.length);
                ndr.writeUnsignedLong(strBytes.length / 2);
                for (int i = 0; i < strBytes.length; ++i) {
                    ndr.writeUnsignedSmall((int)strBytes[i]);
                }
            } else if ((FLAG & 2) == 2) {
                int strlen = (int)Math.round((double)str.length() / 2.0);
                ndr.writeUnsignedLong(strlen + 1);
                ndr.writeUnsignedLong(0);
                ndr.writeUnsignedLong(strlen + 1);
                if (str.length() != 0) {
                    ndr.writeCharacterArray(str.toCharArray(), 0, str.length());
                    if (str.length() % 2 != 0) {
                        ndr.writeUnsignedSmall(0);
                    }
                }
                ndr.writeUnsignedShort(0);
            } else if ((FLAG & 4) == 4) {
                byte[] strBytes = null;
                try {
                    strBytes = str.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    throw new JIRuntimeException(4153);
                }
                ndr.writeUnsignedLong(strBytes.length / 2 + 1);
                ndr.writeUnsignedLong(0);
                ndr.writeUnsignedLong(strBytes.length / 2 + 1);
                for (int i = 0; i < strBytes.length; ++i) {
                    ndr.writeUnsignedSmall((int)strBytes[i]);
                }
                ndr.writeUnsignedShort(0);
            }
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            if ((FLAG & 0x4000) != 16384) {
                throw new JIRuntimeException(4165);
            }
            int retVal = -1;
            String retString = null;
            try {
                if ((FLAG & 1) == 1) {
                    ndr.readUnsignedLong();
                    ndr.readUnsignedLong();
                    int actuallength = ndr.readUnsignedLong() * 2;
                    byte[] buffer = new byte[actuallength];
                    for (int i = 0; i < actuallength; ++i) {
                        retVal = ndr.readUnsignedSmall();
                        buffer[i] = (byte)retVal;
                    }
                    retString = new String(buffer, "UTF-16LE");
                } else if ((FLAG & 2) == 2) {
                    int actuallength = ndr.readUnsignedLong();
                    if (actuallength == 0) {
                        return null;
                    }
                    ndr.readUnsignedLong();
                    ndr.readUnsignedLong();
                    char[] ret = new char[actuallength * 2 - 2];
                    ndr.readCharacterArray(ret, 0, actuallength * 2 - 2);
                    retString = ret[ret.length - 1] == '0' ? new String(ret, 0, ret.length - 1) : new String(ret);
                    ndr.readUnsignedShort();
                } else if ((FLAG & 4) == 4) {
                    int maxlength = ndr.readUnsignedLong();
                    if (maxlength == 0) {
                        return null;
                    }
                    ndr.readUnsignedLong();
                    int actuallength = ndr.readUnsignedLong() * 2;
                    byte[] buffer = new byte[actuallength - 2];
                    for (int i = 0; i < actuallength - 2; ++i) {
                        retVal = ndr.readUnsignedSmall();
                        buffer[i] = (byte)retVal;
                    }
                    if (actuallength != 0) {
                        ndr.readUnsignedShort();
                    }
                    retString = new String(buffer, "UTF-16LE");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new JIRuntimeException(4153);
            }
            return retString;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            int length = 12;
            if ((FLAG & 1) != 1) {
                length += 2;
            }
            if ((FLAG & 2) == 2) {
                length += ((String)value).length();
                if (((String)value).length() % 2 != 0) {
                    ++length;
                }
            } else {
                length += ((String)value).length() * 2;
            }
            return length;
        }
    }

    private static class FloatImpl
    implements SerializerDeserializer {
        private FloatImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            if (value == null) {
                value = new Float(Float.NaN);
            }
            ndr.getBuffer().align(4);
            Encdec.enc_floatle((float)((Float)value).floatValue(), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(4);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            ndr.getBuffer().align(4);
            Float b = new Float(Encdec.dec_floatle((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex()));
            ndr.getBuffer().advance(4);
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class DateImpl
    implements SerializerDeserializer {
        private DateImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            ndr.getBuffer().align(8);
            Encdec.enc_doublele((double)this.convertMillisecondsToWindowsTime(((Date)value).getTime()), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Date b = new Date(this.convertWindowsTimeToMilliseconds(Encdec.dec_doublele((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex())));
            ndr.getBuffer().advance(8);
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }

        private long convertWindowsTimeToMilliseconds(double comTime) {
            long result = 0L;
            Calendar cal = Calendar.getInstance();
            result = Math.round(8.64E7 * (comTime -= 25569.0)) - (long)cal.get(15);
            cal.setTime(new Date(result));
            return result -= (long)cal.get(16);
        }

        private double convertMillisecondsToWindowsTime(long milliseconds) {
            double result = 0.0;
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(milliseconds);
            result = (double)(milliseconds += (long)(cal.get(15) + cal.get(16))) / 8.64E7 + 25569.0;
            return result;
        }
    }

    private static class JICurrencyImpl
    implements SerializerDeserializer {
        private JICurrencyImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            JICurrency currency = (JICurrency)value;
            int units = currency.getUnits();
            int fractionalUnits = currency.getFractionalUnits();
            int toSend = units * 10000 + fractionalUnits;
            String toSend2 = Integer.toHexString(toSend);
            int hibytes = 0;
            int lowbytes = 0;
            if (toSend2.length() > 8) {
                lowbytes = Integer.valueOf(toSend2.substring(8), 16);
                hibytes = Integer.valueOf(toSend2.substring(0, 8), 16);
            } else {
                lowbytes = toSend;
                if (toSend < 0) {
                    hibytes = -1;
                }
            }
            double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.writeOctetArray(new byte[(int)i], 0, (int)i);
            JIStruct struct = new JIStruct();
            try {
                struct.addMember(new Integer(lowbytes));
                struct.addMember(new Integer(hibytes));
            }
            catch (JIException e) {
                // empty catch block
            }
            JIMarshalUnMarshalHelper.serialize(ndr, class$org$jinterop$dcom$core$JIStruct == null ? (class$org$jinterop$dcom$core$JIStruct = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIStruct")) : class$org$jinterop$dcom$core$JIStruct, struct, null, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
            long i = Math.round(index % 8.0);
            i = i == 0L ? 0L : 8L - i;
            ndr.readOctetArray(new byte[(int)i], 0, (int)i);
            int lowbyte = ndr.readUnsignedLong();
            int hibyte = ndr.readUnsignedLong();
            if (hibyte < 0) {
                lowbyte = -1 * Math.abs(lowbyte);
            }
            return new JICurrency((lowbyte - lowbyte % 10000) / 10000, lowbyte % 10000);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class DoubleImpl
    implements SerializerDeserializer {
        private DoubleImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            if (value == null) {
                value = new Double(Double.NaN);
            }
            ndr.getBuffer().align(8);
            Encdec.enc_doublele((double)((Double)value), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Double b = new Double(Encdec.dec_doublele((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex()));
            ndr.getBuffer().advance(8);
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class LongImpl
    implements SerializerDeserializer {
        private LongImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            if (value == null) {
                value = new Long(Long.MIN_VALUE);
            }
            ndr.getBuffer().align(8);
            Encdec.enc_uint64le((long)((Long)value), (byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex());
            ndr.getBuffer().advance(8);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            ndr.getBuffer().align(8);
            Long b = new Long(Encdec.dec_uint64le((byte[])ndr.getBuffer().getBuffer(), (int)ndr.getBuffer().getIndex()));
            ndr.getBuffer().advance(8);
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 8;
        }
    }

    private static class IntegerImpl
    implements SerializerDeserializer {
        private IntegerImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            if (value == null) {
                value = new Integer(Integer.MIN_VALUE);
            }
            ndr.writeUnsignedLong(((Integer)value).intValue());
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            return new Integer(ndr.readUnsignedLong());
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class BooleanImpl
    implements SerializerDeserializer {
        private BooleanImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            if (value == null) {
                value = Boolean.FALSE;
            }
            if ((FLAG & 0x2000) == 8192) {
                ndr.writeUnsignedShort((Boolean)value == true ? 65535 : 0);
            } else {
                ndr.writeBoolean(((Boolean)value).booleanValue());
            }
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            int s;
            Boolean b = null;
            b = (FLAG & 0x2000) == 8192 ? ((s = ndr.readUnsignedShort()) != 0 ? Boolean.TRUE : Boolean.FALSE) : Boolean.valueOf(ndr.readBoolean());
            return b;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            if ((FLAG & 0x2000) == 8192) {
                return 2;
            }
            return 1;
        }
    }

    private static class ShortImpl
    implements SerializerDeserializer {
        private ShortImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            if (value == null) {
                value = new Short(Short.MIN_VALUE);
            }
            ndr.writeUnsignedShort((int)((Short)value).shortValue());
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            Short s = new Short((short)ndr.readUnsignedShort());
            return s;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class ByteImpl
    implements SerializerDeserializer {
        private ByteImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            ndr.writeUnsignedSmall((int)((Byte)value).byteValue());
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            Byte c = new Byte((byte)ndr.readUnsignedSmall());
            return c;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class CharacterImpl
    implements SerializerDeserializer {
        private CharacterImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            ndr.writeUnsignedSmall((int)((Character)value).charValue());
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            Character c = new Character((char)ndr.readUnsignedSmall());
            return c;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class JIVariantImpl
    implements SerializerDeserializer {
        private JIVariantImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            try {
                return ((JIVariant)value).getLengthInBytes(FLAG);
            }
            catch (JIException e) {
                throw new JIRuntimeException(e.getErrorCode());
            }
        }
    }

    private static class JIVariant2Impl
    implements SerializerDeserializer {
        private JIVariant2Impl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((VariantBody)value).getLengthInBytes();
        }
    }

    private static class IJIComObjectSerDer
    implements SerializerDeserializer {
        private IJIComObjectSerDer() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            JIMarshalUnMarshalHelper.serialize(ndr, class$org$jinterop$dcom$core$JIInterfacePointer == null ? (class$org$jinterop$dcom$core$JIInterfacePointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIInterfacePointer")) : class$org$jinterop$dcom$core$JIInterfacePointer, ((IJIComObject)value).internal_getInterfacePointer(), defferedPointers, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            JISession session = (JISession)additionalData.get("CURRENTSESSION");
            JIComObjectImpl comObject = new JIComObjectImpl(session, (JIInterfacePointer)JIMarshalUnMarshalHelper.deSerialize(ndr, class$org$jinterop$dcom$core$JIInterfacePointer == null ? (class$org$jinterop$dcom$core$JIInterfacePointer = JIMarshalUnMarshalHelper.class$("org.jinterop.dcom.core.JIInterfacePointer")) : class$org$jinterop$dcom$core$JIInterfacePointer, defferedPointers, FLAG, additionalData));
            ((ArrayList)additionalData.get("COMOBJECTS")).add(comObject);
            return comObject;
        }

        public int getLengthInBytes(Object value, int FLAG) {
            JIInterfacePointer interfacePointer = ((IJIComObject)value).internal_getInterfacePointer();
            return interfacePointer.getLength();
        }
    }

    private static class UnionImpl
    implements SerializerDeserializer {
        private UnionImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIUnion)value).getLength();
        }
    }

    private static class StructImpl
    implements SerializerDeserializer {
        private StructImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIStruct)value).getLength();
        }
    }

    private static class JIUnsignedShortImpl
    implements SerializerDeserializer {
        private JIUnsignedShortImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            JIMarshalUnMarshalHelper.serialize(ndr, class$java$lang$Short == null ? (class$java$lang$Short = JIMarshalUnMarshalHelper.class$("java.lang.Short")) : class$java$lang$Short, new Short(((JIUnsignedShort)value).getValue().shortValue()), null, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            Short b = (Short)JIMarshalUnMarshalHelper.deSerialize(ndr, class$java$lang$Short == null ? (class$java$lang$Short = JIMarshalUnMarshalHelper.class$("java.lang.Short")) : class$java$lang$Short, null, FLAG, additionalData);
            return JIUnsignedFactory.getUnsigned(new Integer((int)(b & 0xFFFF)), 512);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 2;
        }
    }

    private static class JIUnsignedByteImpl
    implements SerializerDeserializer {
        private JIUnsignedByteImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            JIMarshalUnMarshalHelper.serialize(ndr, class$java$lang$Byte == null ? (class$java$lang$Byte = JIMarshalUnMarshalHelper.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(((JIUnsignedByte)value).getValue().byteValue()), null, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            Byte b = (Byte)JIMarshalUnMarshalHelper.deSerialize(ndr, class$java$lang$Byte == null ? (class$java$lang$Byte = JIMarshalUnMarshalHelper.class$("java.lang.Byte")) : class$java$lang$Byte, null, FLAG, additionalData);
            return JIUnsignedFactory.getUnsigned(new Short((short)(b & 0xFF)), 256);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 1;
        }
    }

    private static class JIUnsignedIntImpl
    implements SerializerDeserializer {
        private JIUnsignedIntImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            JIMarshalUnMarshalHelper.serialize(ndr, class$java$lang$Integer == null ? (class$java$lang$Integer = JIMarshalUnMarshalHelper.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(((JIUnsignedInteger)value).getValue().intValue()), null, FLAG);
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            Integer b = (Integer)JIMarshalUnMarshalHelper.deSerialize(ndr, class$java$lang$Integer == null ? (class$java$lang$Integer = JIMarshalUnMarshalHelper.class$("java.lang.Integer")) : class$java$lang$Integer, null, FLAG, additionalData);
            return JIUnsignedFactory.getUnsigned(new Long((long)b.intValue() & 0xFFFFFFFFL), 1024);
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return 4;
        }
    }

    private static class PointerImpl
    implements SerializerDeserializer {
        private PointerImpl() {
        }

        public void serializeData(NetworkDataRepresentation ndr, Object value, List defferedPointers, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public Object deserializeData(NetworkDataRepresentation ndr, List defferedPointers, Map additionalData, int FLAG) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4105));
        }

        public int getLengthInBytes(Object value, int FLAG) {
            return ((JIPointer)value).getLength();
        }
    }

    private static interface SerializerDeserializer {
        public void serializeData(NetworkDataRepresentation var1, Object var2, List var3, int var4);

        public Object deserializeData(NetworkDataRepresentation var1, List var2, Map var3, int var4);

        public int getLengthInBytes(Object var1, int var2);
    }
}

