/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.Key;
import java.security.KeyPair;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import org.apache.sshd.common.KeyPairProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyPairProvider
implements KeyPairProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public KeyPair loadKey(String type) {
        KeyPair[] keys;
        assert (type != null);
        for (KeyPair key : keys = this.loadKeys()) {
            if (!type.equals(this.getKeyType(key))) continue;
            return key;
        }
        return null;
    }

    public String getKeyTypes() {
        KeyPair[] keys;
        ArrayList<String> types = new ArrayList<String>();
        for (KeyPair key : keys = this.loadKeys()) {
            String type = this.getKeyType(key);
            if (type == null || types.contains(type)) continue;
            types.add(type);
        }
        StringBuilder sb = new StringBuilder();
        for (String type : types) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(type);
        }
        return sb.toString();
    }

    protected String getKeyType(KeyPair kp) {
        Key key;
        Key key2 = key = kp.getPrivate() != null ? kp.getPrivate() : kp.getPublic();
        if (key instanceof DSAKey) {
            return "ssh-dss";
        }
        if (key instanceof RSAKey) {
            return "ssh-rsa";
        }
        return null;
    }

    protected abstract KeyPair[] loadKeys();
}

