/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.checker;

import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.CredentialsExpiredException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.LockedException;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsChecker;
import org.springframework.context.support.MessageSourceAccessor;

public class AccountStatusUserDetailsChecker
implements UserDetailsChecker {
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();

    public void check(UserDetails user) {
        if (!user.isAccountNonLocked()) {
            throw new LockedException(this.messages.getMessage("UserDetailsService.locked", "User account is locked"), user);
        }
        if (!user.isEnabled()) {
            throw new DisabledException(this.messages.getMessage("UserDetailsService.disabled", "User is disabled"), user);
        }
        if (!user.isAccountNonExpired()) {
            throw new AccountExpiredException(this.messages.getMessage("UserDetailsService.expired", "User account has expired"), user);
        }
        if (!user.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException(this.messages.getMessage("UserDetailsService.credentialsExpired", "User credentials have expired"), user);
        }
    }
}

