/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.compression;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.stapler.compression.CompressionServletResponse;
import org.kohsuke.stapler.compression.UncaughtExceptionHandler;

public class CompressionFilter
implements Filter {
    private ServletContext context;
    public static boolean DISABLED = Boolean.getBoolean(CompressionFilter.class.getName() + ".disabled");

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest _req, ServletResponse _rsp, FilterChain filterChain) throws IOException, ServletException {
        Object old1 = this.swapAttribute(_req, CompressionFilter.class, true);
        CompressionServletResponse rsp = new CompressionServletResponse((HttpServletResponse)_rsp);
        Object old2 = this.swapAttribute(_req, CompressionServletResponse.class, (Object)rsp);
        try {
            filterChain.doFilter(_req, (ServletResponse)rsp);
        }
        catch (IOException e) {
            if (DISABLED) {
                throw e;
            }
            this.reportException(e, (HttpServletRequest)_req, (HttpServletResponse)rsp);
        }
        catch (ServletException e) {
            if (DISABLED) {
                throw e;
            }
            this.reportException(e, (HttpServletRequest)_req, (HttpServletResponse)rsp);
        }
        catch (RuntimeException e) {
            if (DISABLED) {
                throw e;
            }
            this.reportException(e, (HttpServletRequest)_req, (HttpServletResponse)rsp);
        }
        catch (Error e) {
            if (DISABLED) {
                throw e;
            }
            this.reportException(e, (HttpServletRequest)_req, (HttpServletResponse)rsp);
        }
        finally {
            rsp.close();
            _req.setAttribute(CompressionFilter.class.getName(), old1);
            _req.setAttribute(CompressionServletResponse.class.getName(), old2);
        }
    }

    private Object swapAttribute(ServletRequest req, Class<?> key, Object value) {
        Object old = req.getAttribute(key.getName());
        req.setAttribute(key.getName(), value);
        return old;
    }

    private void reportException(Throwable e, HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        CompressionFilter.getUncaughtExceptionHandler(this.context).reportException(e, this.context, req, rsp);
    }

    public void destroy() {
    }

    public static void setUncaughtExceptionHandler(ServletContext context, UncaughtExceptionHandler handler) {
        context.setAttribute(UncaughtExceptionHandler.class.getName(), (Object)handler);
    }

    public static UncaughtExceptionHandler getUncaughtExceptionHandler(ServletContext context) {
        UncaughtExceptionHandler h = (UncaughtExceptionHandler)context.getAttribute(UncaughtExceptionHandler.class.getName());
        if (h == null) {
            h = UncaughtExceptionHandler.DEFAULT;
        }
        return h;
    }

    public static boolean has(ServletRequest req) {
        return req.getAttribute(CompressionServletResponse.class.getName()) != null;
    }

    public static boolean activate(ServletRequest req) throws IOException {
        CompressionServletResponse rsp = (CompressionServletResponse)((Object)req.getAttribute(CompressionServletResponse.class.getName()));
        if (rsp != null) {
            rsp.activate();
            return true;
        }
        return false;
    }
}

