/*
 * Office JavaScript API library
 *
 * Copyright (c) Microsoft Corporation.  All rights reserved.
 *
 * Your use of this file is governed by the license terms for the Microsoft Office JavaScript (Office.js) API library: https://github.com/OfficeDev/office-js/blob/release/LICENSE.md
 *
 * This file also contains the following Promise implementation (with a few small modifications):
 *      * @overview es6-promise - a tiny implementation of Promises/A+.
 *      * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 *      * @license   Licensed under MIT license
 *      *            See https://raw.githubusercontent.com/jakearchibald/es6-promise/master/LICENSE
 *      * @version   2.3.0
 */
var OSFPerformance,CustomFunctionMappings,CustomFunctions,Strings;!function(e){e.now=function(){return"undefined"!=typeof performance&&performance.now?performance.now():0},e.getTotalJSHeapSize=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.totalJSHeapSize:0},e.getUsedJSHeapSize=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.usedJSHeapSize:0},e.getJSHeapSizeLimit=function(){return"undefined"!=typeof performance&&performance.memory?performance.memory.jsHeapSizeLimit:0},e.officeExecuteStartDate=e.officeExecuteStartDate||Date.now(),e.officeExecuteStart=e.officeExecuteStart||0,e.officeExecuteEnd=e.officeExecuteEnd||0,e.hostInitializationStart=0,e.hostInitializationEnd=0,e.totalJSHeapSize=0,e.usedJSHeapSize=0,e.jsHeapSizeLimit=0,e.createOMEnd=0,e.hostSpecificFileName="",e.getAppContextStart=0,e.getAppContextEnd=0,e.getAppContextXdmStart=0,e.getAppContextXdmEnd=0,e.officeOnReady=0}(OSFPerformance=OSFPerformance||{}),(OSF||(OSF={})).definePropertyOnNamespace=function(e,t,n){Object.defineProperty(e,t,{get:function(){return n()},configurable:!0,enumerable:!0})},OSFPerformance.hostInitializationStart=OSFPerformance.now(),function(e){var t;function n(){return t.m_association||(t.m_association=new OSF.Association),t.m_association}(t=e.actions||(e.actions={})).m_association=t.m_association,t.associate=function(){n().associate.apply(n(),arguments)},OSF.definePropertyOnNamespace(t,"_association",n)}(Office=Office||{}),function(e){var t;(t=e.AgaveHostAction||(e.AgaveHostAction={}))[t.Select=0]="Select",t[t.UnSelect=1]="UnSelect",t[t.CancelDialog=2]="CancelDialog",t[t.InsertAgave=3]="InsertAgave",t[t.CtrlF6In=4]="CtrlF6In",t[t.CtrlF6Exit=5]="CtrlF6Exit",t[t.CtrlF6ExitShift=6]="CtrlF6ExitShift",t[t.SelectWithError=7]="SelectWithError",t[t.NotifyHostError=8]="NotifyHostError",t[t.RefreshAddinCommands=9]="RefreshAddinCommands",t[t.PageIsReady=10]="PageIsReady",t[t.TabIn=11]="TabIn",t[t.TabInShift=12]="TabInShift",t[t.TabExit=13]="TabExit",t[t.TabExitShift=14]="TabExitShift",t[t.EscExit=15]="EscExit",t[t.F2Exit=16]="F2Exit",t[t.ExitNoFocusable=17]="ExitNoFocusable",t[t.ExitNoFocusableShift=18]="ExitNoFocusableShift",t[t.MouseEnter=19]="MouseEnter",t[t.MouseLeave=20]="MouseLeave",t[t.UpdateTargetUrl=21]="UpdateTargetUrl",t[t.InstallCustomFunctions=22]="InstallCustomFunctions",t[t.SendTelemetryEvent=23]="SendTelemetryEvent",t[t.UninstallCustomFunctions=24]="UninstallCustomFunctions",t[t.SendMessage=25]="SendMessage",t[t.LaunchExtensionComponent=26]="LaunchExtensionComponent",t[t.StopExtensionComponent=27]="StopExtensionComponent",t[t.RestartExtensionComponent=28]="RestartExtensionComponent",t[t.EnableTaskPaneHeaderButton=29]="EnableTaskPaneHeaderButton",t[t.DisableTaskPaneHeaderButton=30]="DisableTaskPaneHeaderButton",t[t.TaskPaneHeaderButtonClicked=31]="TaskPaneHeaderButtonClicked",t[t.RemoveAppCommandsAddin=32]="RemoveAppCommandsAddin",t[t.RefreshRibbonGallery=33]="RefreshRibbonGallery",t[t.GetOriginalControlId=34]="GetOriginalControlId",t[t.OfficeJsReady=35]="OfficeJsReady",t[t.InsertDevManifest=36]="InsertDevManifest",t[t.InsertDevManifestError=37]="InsertDevManifestError",t[t.SendCustomerContent=38]="SendCustomerContent",t[t.KeyboardShortcuts=39]="KeyboardShortcuts",t[t.CloseSDXDialog=42]="CloseSDXDialog",t[t.ResizeSDXDialog=43]="ResizeSDXDialog",t[t.SendNonStandardEvent=44]="SendNonStandardEvent"}(OSF=OSF||{}),function(o){var e=(t.prototype.initializeEventHandler=function(e){var t=this;this.addHandlerAsync(o.EventType.AppCommandInvoked,function(e){t._processAppCommandInvocation(e)},e)},t.prototype.appCommandInvocationCompletedAsync=function(t,n,r,e){o._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(94,{fromSafeArrayHost:function(e){return e},fromWebHost:function(e){return e},toSafeArrayHost:function(){return[t,n,r]},toWebHost:function(){var e={};return e[0]=t,e[1]=n,e[2]=r,e}},e)},t.prototype.addHandlerAsync=function(e,t,n){o.EventHelper.addEventHandler(e,t,n,this._eventDispatch,void 0,o.OUtil.isPopupWindow())},t.prototype._verifyManifestCallback=function(e){var t={callback:null,errorCode:11101};e=e.trim();try{var n=this._getCallbackFunc(e);if("function"!=typeof n)return t}catch(e){return t}return{callback:n,errorCode:0}},t.prototype._getCallbackFuncFromActionAssociateTable=function(e){var t=e.toUpperCase();return Office.actions._association.mappings[t]},t.prototype._getCallbackFunc=function(e){return this._getCallbackFuncFromActionAssociateTable(e)},t.prototype._invokeAppCommandCompletedMethod=function(e,t,n){this.appCommandInvocationCompletedAsync(e,t,n,function(e){e.status!==Office.AsyncResultStatus.Succeeded&&console.error("Failed to notify the host thta app command is completed")})},t.prototype._constructEventObjectForCallback=function(n){var e,r,o=this;try{e=JSON.parse(n.eventObjStr),r=JSON.parse(n.eventObjStr)}catch(e){}return r=r||{},(e=e||{}).completed=function(e){r.completedContext=e;var t=JSON.stringify(r);o._invokeAppCommandCompletedMethod(n.appCommandId,0,t)},e},t.initialize=function(){null==t._instance&&(t._instance=new t).initializeEventHandler(function(e){e.status!==Office.AsyncResultStatus.Succeeded&&console.error("Cannot initialize app command: "+JSON.stringify(e))})},t._instance=null,t);function t(){var r=this;this._processAppCommandInvocation=function(e){var t=r._verifyManifestCallback(e.callbackName);if(0==t.errorCode){var n=r._constructEventObjectForCallback(e);n?window.setTimeout(function(){t.callback(n)},0):r._invokeAppCommandCompletedMethod(e.appCommandId,5001,"")}else r._invokeAppCommandCompletedMethod(e.appCommandId,t.errorCode,"")},this._eventDispatch=new o.EventDispatch([{type:o.EventType.AppCommandInvoked,id:o.EventDispId.dispidAppCommandInvokedEvent,getTargetId:function(){return""},fromSafeArrayHost:function(e){return{type:o.EventType.AppCommandInvoked,appCommandId:e[0],callbackName:e[1],eventObjStr:e[2]}},fromWebHost:function(e){return{type:o.EventType.AppCommandInvoked,appCommandId:e[0],callbackName:e[1],eventObjStr:e[2]}}}])}o.AppCommandManager=e}(OSF=OSF||{}),function(e){var t;(t=e.AppName||(e.AppName={}))[t.Unsupported=0]="Unsupported",t[t.Excel=1]="Excel",t[t.Word=2]="Word",t[t.PowerPoint=4]="PowerPoint",t[t.Outlook=8]="Outlook",t[t.ExcelWebApp=16]="ExcelWebApp",t[t.WordWebApp=32]="WordWebApp",t[t.OutlookWebApp=64]="OutlookWebApp",t[t.Project=128]="Project",t[t.AccessWebApp=256]="AccessWebApp",t[t.PowerpointWebApp=512]="PowerpointWebApp",t[t.ExcelIOS=1024]="ExcelIOS",t[t.Sway=2048]="Sway",t[t.WordIOS=4096]="WordIOS",t[t.PowerPointIOS=8192]="PowerPointIOS",t[t.Access=16384]="Access",t[t.Lync=32768]="Lync",t[t.OutlookIOS=65536]="OutlookIOS",t[t.OneNoteWebApp=131072]="OneNoteWebApp",t[t.OneNote=262144]="OneNote",t[t.ExcelWinRT=524288]="ExcelWinRT",t[t.WordWinRT=1048576]="WordWinRT",t[t.PowerpointWinRT=2097152]="PowerpointWinRT",t[t.OutlookAndroid=4194304]="OutlookAndroid",t[t.OneNoteWinRT=8388608]="OneNoteWinRT",t[t.ExcelAndroid=8388609]="ExcelAndroid",t[t.VisioWebApp=8388610]="VisioWebApp",t[t.OneNoteIOS=8388611]="OneNoteIOS",t[t.WordAndroid=8388613]="WordAndroid",t[t.PowerpointAndroid=8388614]="PowerpointAndroid",t[t.Visio=8388615]="Visio",t[t.OneNoteAndroid=4194305]="OneNoteAndroid"}(OSF=OSF||{}),function(e){var t=(n.prototype.associate=function(e,t){function n(e){"undefined"!=typeof console&&console.warn&&console.warn(e)}if(1==arguments.length&&"object"==typeof e&&e){var r=e;for(var o in r)this.associate(o,r[o])}else if(2==arguments.length){var i=e,a=t;if("string"!=typeof i)return void n("[InvalidArg] Function=associate");if("function"!=typeof a)return void n("[InvalidArg] Function=associate");var s=i.toUpperCase();this.m_mappings[s]&&n("[DuplicatedName] Function="+i),this.m_mappings[s]=a;for(var c=0;c<this.m_onchangeHandlers.length;c++)this.m_onchangeHandlers[c]()}else n("[InvalidArg] Function=associate")},n.prototype.onchange=function(e){e&&this.m_onchangeHandlers.push(e)},Object.defineProperty(n.prototype,"mappings",{get:function(){return this.m_mappings},enumerable:!0,configurable:!0}),n);function n(){this.m_mappings={},this.m_onchangeHandlers=[]}e.Association=t}(OSF=OSF||{}),function(e){var t=(n.prototype.invokeCallback=function(e,t,n,r,o){if(0==n){var i={status:Office.AsyncResultStatus.Succeeded,value:r,asyncContext:o};"function"==typeof t&&t(i)}else{var a={status:Office.AsyncResultStatus.Failed,error:{code:n},asyncContext:o};"function"==typeof t&&t(a)}},n);function n(){}e.AsyncMethodExecutor=t}(OSF=OSF||{}),function(d){var e=(t.prototype.handleSafeArrayHostResponse=function(e,t,n,r,o,i,a){var s,c;if(1==(c="number"==typeof(e=d.Utility.fromSafeArray(e))?(s=[],e):(s=e)[0]))return null!=(l=s[1])&&(n[l[0]]=l[1]),!1;if(r){var l;if(0==c){if(2<s.length){l=[];for(var u=1;u<s.length;u++)l[u-1]=s[u]}else l=s[1];if(0<n.length&&null!=l){var p=l[l.length-1];n.length==p?l[l.length-1]=n:c=5001}}else l=s[1];var f=null;0==c&&(f=o.fromSafeArrayHost(l)),this._asyncMethodExecutor.invokeCallback(i,r,c,f,a)}return!0},t.prototype.handleWebHostResponse=function(e,t,n,r,o,i){var a=null;0==t&&(a=r.fromWebHost(e)),this._asyncMethodExecutor.invokeCallback(o,n,t,a,i)},t);function t(e){this._asyncMethodExecutor=e}d.AsyncMethodExecutorHelper=e}(OSF=OSF||{}),function(e){!function(e){var t,n,r,o;t=e.AsyncResultEnum||(e.AsyncResultEnum={}),(n=t.Properties||(t.Properties={})).Context="Context",n.Value="Value",n.Status="Status",n.Error="Error",(r=t.ErrorCode||(t.ErrorCode={}))[r.Success=0]="Success",r[r.Failed=1]="Failed",(o=t.ErrorProperties||(t.ErrorProperties={})).Name="Name",o.Message="Message",o.Code="Code";function i(e,t){this.value=e.Value,this.status=t?Office.AsyncResultStatus.Failed:Office.AsyncResultStatus.Succeeded,e.Context&&(this.asyncContext=e.Context),t&&(this.error=new a(t.Name,t.Message,t.Code))}e.AsyncResult=i;var a=function(e,t,n){this.name=e,this.message=t,this.code=n};e.Error=a}(e.DDA||(e.DDA={}))}(OSF=OSF||{}),function(n){var e;(e=n.BootStrapExtension||(n.BootStrapExtension={})).createWebClientHostControllerHelper=function(e,t){return new n.WebClientHostControllerHelper(e,t)},e.createAsyncMethodExecutorHelper=function(e){return new n.AsyncMethodExecutorHelper(e)}}(OSF=OSF||{}),function(e){var t;(t=e.ConstantNames||(e.ConstantNames={})).DefaultLocale="en-us",t.OfficeJS="office.js",t.OfficeDebugJS="office.debug.js",t.OfficeStringsId="OFFICESTRINGS",t.OfficeJsId="OFFICEJS",t.HostFileId="HOST",t.OfficeStringJS="office_strings.js",t.OfficeStringDebugJS="office_strings.debug.js",t.FileVersion="16.0.18408.15020"}(OSF=OSF||{}),function(e){var t=(n.NotificationConversationIdSuffix="_ntf",n);function n(){}e.Constants=t}(OSF=OSF||{}),CustomFunctionMappings=CustomFunctionMappings||{},function(e){e.delayInitialization=function(){CustomFunctionMappings.__delay__=!0},e._association=e._association||new OSF.Association,e.associate=function(){e._association.associate.apply(e._association,arguments),delete CustomFunctionMappings.__delay__}}(CustomFunctions=CustomFunctions||{}),function(e){var t,n,r,o;t=e.DDA||(e.DDA={}),n=t.ErrorCodeManager||(t.ErrorCodeManager={}),o=!(r={}),n.getErrorArgs=function(e){var t;o||(t=Strings.OfficeOM,r[1e3]={name:t.L_InvalidCoercion,message:t.L_CoercionTypeNotSupported},r[1001]={name:t.L_DataReadError,message:t.L_GetSelectionNotSupported},r[1002]={name:t.L_InvalidCoercion,message:t.L_CoercionTypeNotMatchBinding},r[1003]={name:t.L_DataReadError,message:t.L_InvalidGetRowColumnCounts},r[1004]={name:t.L_DataReadError,message:t.L_SelectionNotSupportCoercionType},r[1005]={name:t.L_DataReadError,message:t.L_InvalidGetStartRowColumn},r[1006]={name:t.L_DataReadError,message:t.L_NonUniformPartialGetNotSupported},r[1008]={name:t.L_DataReadError,message:t.L_GetDataIsTooLarge},r[1009]={name:t.L_DataReadError,message:t.L_FileTypeNotSupported},r[1010]={name:t.L_DataReadError,message:t.L_GetDataParametersConflict},r[1011]={name:t.L_DataReadError,message:t.L_InvalidGetColumns},r[1012]={name:t.L_DataReadError,message:t.L_InvalidGetRows},r[1013]={name:t.L_DataReadError,message:t.L_InvalidReadForBlankRow},r[2e3]={name:t.L_DataWriteError,message:t.L_UnsupportedDataObject},r[2001]={name:t.L_DataWriteError,message:t.L_CannotWriteToSelection},r[2002]={name:t.L_DataWriteError,message:t.L_DataNotMatchSelection},r[2003]={name:t.L_DataWriteError,message:t.L_OverwriteWorksheetData},r[2004]={name:t.L_DataWriteError,message:t.L_DataNotMatchBindingSize},r[2005]={name:t.L_DataWriteError,message:t.L_InvalidSetStartRowColumn},r[2006]={name:t.L_InvalidFormat,message:t.L_InvalidDataFormat},r[2007]={name:t.L_InvalidDataObject,message:t.L_DataNotMatchCoercionType},r[2008]={name:t.L_InvalidDataObject,message:t.L_DataNotMatchBindingType},r[2009]={name:t.L_DataWriteError,message:t.L_SetDataIsTooLarge},r[2010]={name:t.L_DataWriteError,message:t.L_NonUniformPartialSetNotSupported},r[2011]={name:t.L_DataWriteError,message:t.L_InvalidSetColumns},r[2012]={name:t.L_DataWriteError,message:t.L_InvalidSetRows},r[2013]={name:t.L_DataWriteError,message:t.L_SetDataParametersConflict},r[3e3]={name:t.L_BindingCreationError,message:t.L_SelectionCannotBound},r[3002]={name:t.L_InvalidBindingError,message:t.L_BindingNotExist},r[3003]={name:t.L_BindingCreationError,message:t.L_BindingToMultipleSelection},r[3004]={name:t.L_BindingCreationError,message:t.L_InvalidSelectionForBindingType},r[3005]={name:t.L_InvalidBindingOperation,message:t.L_OperationNotSupportedOnThisBindingType},r[3006]={name:t.L_BindingCreationError,message:t.L_NamedItemNotFound},r[3007]={name:t.L_BindingCreationError,message:t.L_MultipleNamedItemFound},r[3008]={name:t.L_BindingCreationError,message:t.L_InvalidNamedItemForBindingType},r[3009]={name:t.L_InvalidBinding,message:t.L_UnknownBindingType},r[3010]={name:t.L_InvalidBindingOperation,message:t.L_OperationNotSupportedOnMatrixData},r[3011]={name:t.L_InvalidBinding,message:t.L_InvalidColumnsForBinding},r[4e3]={name:t.L_ReadSettingsError,message:t.L_SettingNameNotExist},r[4001]={name:t.L_SaveSettingsError,message:t.L_SettingsCannotSave},r[4002]={name:t.L_SettingsStaleError,message:t.L_SettingsAreStale},r[5e3]={name:t.L_HostError,message:t.L_OperationNotSupported},r[5001]={name:t.L_InternalError,message:t.L_InternalErrorDescription},r[5002]={name:t.L_PermissionDenied,message:t.L_DocumentReadOnly},r[5003]={name:t.L_EventRegistrationError,message:t.L_EventHandlerNotExist},r[5004]={name:t.L_InvalidAPICall,message:t.L_InvalidApiCallInContext},r[5005]={name:t.L_ShuttingDown,message:t.L_ShuttingDown},r[5007]={name:t.L_UnsupportedEnumeration,message:t.L_UnsupportedEnumerationMessage},r[5008]={name:t.L_IndexOutOfRange,message:t.L_IndexOutOfRange},r[5009]={name:t.L_APINotSupported,message:t.L_BrowserAPINotSupported},r[5011]={name:t.L_APICallFailed,message:t.L_RequestTimeout},r[5012]={name:t.L_InvalidOrTimedOutSession,message:t.L_InvalidOrTimedOutSessionMessage},r[5013]={name:t.L_APICallFailed,message:t.L_InvalidApiArgumentsMessage},r[5015]={name:t.L_APICallFailed,message:t.L_WorkbookHiddenMessage},r[5016]={name:t.L_APICallFailed,message:t.L_WriteNotSupportedWhenModalDialogOpen},r[5017]={name:t.L_APICallFailed,message:t.L_UndoNotSupportedMessage},r[5100]={name:t.L_APICallFailed,message:t.L_TooManyIncompleteRequests},r[5101]={name:t.L_APICallFailed,message:t.L_RequestTokenUnavailable},r[5102]={name:t.L_APICallFailed,message:t.L_ActivityLimitReached},r[5103]={name:t.L_APICallFailed,message:t.L_RequestPayloadSizeLimitExceededMessage},r[5104]={name:t.L_APICallFailed,message:t.L_ResponsePayloadSizeLimitExceededMessage},r[6e3]={name:t.L_InvalidNode,message:t.L_CustomXmlNodeNotFound},r[6100]={name:t.L_CustomXmlError,message:t.L_CustomXmlError},r[6101]={name:t.L_CustomXmlExceedQuotaName,message:t.L_CustomXmlExceedQuotaMessage},r[6102]={name:t.L_CustomXmlOutOfDateName,message:t.L_CustomXmlOutOfDateMessage},r[7e3]={name:t.L_PermissionDenied,message:t.L_NoCapability},r[7001]={name:t.L_CannotNavigateTo,message:t.L_CannotNavigateTo},r[7002]={name:t.L_SpecifiedIdNotExist,message:t.L_SpecifiedIdNotExist},r[7004]={name:t.L_NavOutOfBound,message:t.L_NavOutOfBound},r[2014]={name:t.L_DataWriteReminder,message:t.L_CellDataAmountBeyondLimits},r[8e3]={name:t.L_MissingParameter,message:t.L_ElementMissing},r[8001]={name:t.L_PermissionDenied,message:t.L_NoCapability},r[8010]={name:t.L_InvalidValue,message:t.L_InvalidCellsValue},r[8011]={name:t.L_InvalidValue,message:t.L_InvalidTableOptionValue},r[8012]={name:t.L_InvalidValue,message:t.L_InvalidFormatValue},r[8020]={name:t.L_OutOfRange,message:t.L_RowIndexOutOfRange},r[8021]={name:t.L_OutOfRange,message:t.L_ColIndexOutOfRange},r[8022]={name:t.L_OutOfRange,message:t.L_FormatValueOutOfRange},r[8023]={name:t.L_FormattingReminder,message:t.L_CellFormatAmountBeyondLimits},r[1e4]={name:t.L_UserNotSignedIn,message:t.L_UserNotSignedIn},r[11e3]={name:t.L_MemoryLimit,message:t.L_CloseFileBeforeRetrieve},r[11001]={name:t.L_NetworkProblem,message:t.L_NetworkProblemRetrieveFile},r[11002]={name:t.L_InvalidValue,message:t.L_SliceSizeNotSupported},r[12007]={name:t.L_DisplayDialogError,message:t.L_DialogAlreadyOpened},r[12e3]={name:t.L_IndexOutOfRange,message:t.L_IndexOutOfRange},r[12001]={name:t.L_IndexOutOfRange,message:t.L_IndexOutOfRange},r[12002]={name:t.L_DisplayDialogError,message:t.L_NetworkProblem},r[12003]={name:t.L_DialogNavigateError,message:t.L_DialogInvalidScheme},r[12004]={name:t.L_DisplayDialogError,message:t.L_DialogAddressNotTrusted},r[12005]={name:t.L_DisplayDialogError,message:t.L_DialogRequireHTTPS},r[12009]={name:t.L_DisplayDialogError,message:t.L_UserClickIgnore},r[12011]={name:t.L_DisplayDialogError,message:t.L_NewWindowCrossZoneErrorString},r[13e3]={name:t.L_APINotSupported,message:t.L_InvalidSSOAddinMessage},r[13001]={name:t.L_UserNotSignedIn,message:t.L_UserNotSignedIn},r[13002]={name:t.L_UserAborted,message:t.L_UserAbortedMessage},r[13003]={name:t.L_UnsupportedUserIdentity,message:t.L_UnsupportedUserIdentityMessage},r[13004]={name:t.L_InvalidResourceUrl,message:t.L_InvalidResourceUrlMessage},r[13005]={name:t.L_InvalidGrant,message:t.L_InvalidGrantMessage},r[13006]={name:t.L_SSOClientError,message:t.L_SSOClientErrorMessage},r[13007]={name:t.L_SSOServerError,message:t.L_SSOServerErrorMessage},r[13008]={name:t.L_AddinIsAlreadyRequestingToken,message:t.L_AddinIsAlreadyRequestingTokenMessage},r[13009]={name:t.L_SSOUserConsentNotSupportedByCurrentAddinCategory,message:t.L_SSOUserConsentNotSupportedByCurrentAddinCategoryMessage},r[13010]={name:t.L_SSOConnectionLostError,message:t.L_SSOConnectionLostErrorMessage},r[13012]={name:t.L_APINotSupported,message:t.L_SSOUnsupportedPlatform},r[13013]={name:t.L_APICallFailed,message:t.L_RequestTokenUnavailable},r[5014]={name:t.L_OperationCancelledError,message:t.L_OperationCancelledErrorMessage},o=!0);var n=r[e];return n?(n.name||(n.name=r[5001].name),n.message||(n.message=r[5001].message)):n=r[5001],n},n.addErrorMessage=function(e,t){r[e]=t}}(OSF=OSF||{}),function(e){var t=(n.prototype.getSupportedEvents=function(){var e=[];for(var t in this._eventHandlers)e.push(t);return e},n.prototype.supportsEvent=function(e){for(var t in this._eventHandlers)if(e==t)return!0;return!1},n.prototype.hasEventHandler=function(e,t){var n=this._eventHandlers[e];if(n&&0<n.length)for(var r=0;r<n.length;r++)if(n[r]===t)return!0;return!1},n.prototype.addEventHandler=function(e,t){if("function"!=typeof t)return!1;var n=this._eventHandlers[e];return!(!n||this.hasEventHandler(e,t)||(n.push(t),0))},n.prototype.addEventHandlerAndFireQueuedEvent=function(e,t){var n=this._eventHandlers[e],r=!n||0==n.length,o=this.addEventHandler(e,t);return r&&o&&this.fireQueuedEvent(e),o},n.prototype.removeEventHandler=function(e,t){var n=this._eventHandlers[e];if(n&&0<n.length)for(var r=0;r<n.length;r++)if(n[r]===t)return n.splice(r,1),!0;return!1},n.prototype.clearEventHandlers=function(e){return void 0!==this._eventHandlers[e]&&0<this._eventHandlers[e].length&&(this._eventHandlers[e]=[],!0)},n.prototype.getEventHandlerCount=function(e){return null!=this._eventHandlers[e]?this._eventHandlers[e].length:-1},n.prototype.getEventInfo=function(e){return this._eventInfos[e]},n.prototype.fireEvent=function(e){if(null==e.type)return!1;var t=e.type;if(t&&this._eventHandlers[t]){for(var n=this._eventHandlers[t],r=0;r<n.length;r++)n[r](e);return!0}return!1},n.prototype.fireOrQueueEvent=function(e){if(null==e.type)return!1;var t=e.type;if(t&&this._eventHandlers[t]){var n=this._eventHandlers[t],r=this._queuedEventsArgs[t];return 0==n.length?r.push(e):this.fireEvent(e),!0}return!1},n.prototype.fireQueuedEvent=function(e){if(e&&this._eventHandlers[e]){var t=this._eventHandlers[e],n=this._queuedEventsArgs[e];if(0<t.length){for(var r=t[0];0<n.length;)r(n.shift());return!0}}return!1},n.prototype.clearQueuedEvent=function(e){e&&this._eventHandlers[e]&&this._queuedEventsArgs[e]&&(this._queuedEventsArgs[e]=[])},n);function n(e){if(this._eventInfos={},this._queuedEventsArgs={},this._eventHandlers={},this._queuedEventsArgs={},null!=e)for(var t=0;t<e.length;t++)if("string"==typeof e[t]){var n=e[t];this._eventHandlers[n]=[],this._queuedEventsArgs[n]=[]}else{n=e[t].type;this._eventInfos[n]=e[t],this._eventHandlers[n]=[],this._queuedEventsArgs[n]=[]}}e.EventDispatch=t}(OSF=OSF||{}),function(e){var t;(t=e.EventDispId||(e.EventDispId={})).dispidEventMin=0,t.dispidInitializeEvent=0,t.dispidSettingsChangedEvent=1,t.dispidDocumentSelectionChangedEvent=2,t.dispidBindingSelectionChangedEvent=3,t.dispidBindingDataChangedEvent=4,t.dispidDocumentOpenEvent=5,t.dispidDocumentCloseEvent=6,t.dispidActiveViewChangedEvent=7,t.dispidDocumentThemeChangedEvent=8,t.dispidOfficeThemeChangedEvent=9,t.dispidDialogMessageReceivedEvent=10,t.dispidDialogNotificationShownInAddinEvent=11,t.dispidDialogParentMessageReceivedEvent=12,t.dispidObjectDeletedEvent=13,t.dispidObjectSelectionChangedEvent=14,t.dispidObjectDataChangedEvent=15,t.dispidContentControlAddedEvent=16,t.dispidLiveShareStateChangedEvent=17,t.dispidActivationStatusChangedEvent=32,t.dispidRichApiMessageEvent=33,t.dispidAppCommandInvokedEvent=39,t.dispidOnSdxSendMessageEvent=40,t.dispidDataNodeAddedEvent=60,t.dispidDataNodeReplacedEvent=61,t.dispidDataNodeDeletedEvent=62}(OSF=OSF||{}),function(d){var e=(h.addEventHandler=function(t,n,r,o,i,e){var a=0;function s(e){0==e&&(o.hasEventHandler(t,n)||o.addEventHandler(t,n)||(e=5010)),d._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(a,r,e,null,i)}var c=o.getEventInfo(t);if(c)try{if(e)return void s(0);a=c.id;var l=c.getTargetId();0==o.getEventHandlerCount(t)?d._OfficeAppFactory.getAsyncMethodExecutor().registerEventAsync(a,c.type,l,function(e){o.fireEvent(e)},c,function(e){s(d.Utility.getErrorCodeFromAsyncResult(e))},i):s(0)}catch(e){h.onException(a,e,r)}else s(5010)},h.removeEventHandler=function(e,t,n,r,o,i){var a=0;function s(e){d._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(a,n,e,null,o)}var c=r.getEventInfo(e);if(c)try{a=c.id;var l=c.getTargetId(),u=0,p=!0;u=null===t?(p=r.clearEventHandlers(e),0):(p=r.removeEventHandler(e,t))?0:5003;var f=r.getEventHandlerCount(e);p&&0==f?d._OfficeAppFactory.getAsyncMethodExecutor().unregisterEventAsync(a,c.type,l,function(e){s(d.Utility.getErrorCodeFromAsyncResult(e))},o):s(u)}catch(e){h.onException(a,e,n)}else s(5010)},h.onException=function(e,t,n){if("number"!=typeof t)throw t;d._OfficeAppFactory.getAsyncMethodExecutor().invokeCallback(e,n,t,null)},h);function h(){}d.EventHelper=e}(OSF=OSF||{}),function(e){var t;(t=e.EventType||(e.EventType={})).ActiveViewChanged="activeViewChanged",t.AppCommandInvoked="appCommandInvoked",t.RichApiMessage="richApiMessage",t.DocumentSelectionChanged="documentSelectionChanged",t.BindingSelectionChanged="bindingSelectionChanged",t.BindingDataChanged="bindingDataChanged",t.OfficeThemeChanged="officeThemeChanged",t.DocumentThemeChanged="documentThemeChanged",t.LiveShareStateChanged="liveShareStateChanged",t.DataNodeDeleted="nodeDeleted",t.DataNodeInserted="nodeInserted",t.DataNodeReplaced="nodeReplaced",t.DialogMessageReceived="dialogMessageReceived",t.DialogParentMessageReceived="dialogParentMessageReceived",t.DialogParentEventReceived="dialogParentEventReceived",t.DialogEventReceived="dialogEventReceived",t.NodeDeleted="nodeDeleted",t.NodeInserted="nodeInserted",t.NodeReplaced="nodeReplaced",t.SettingsChanged="settingsChanged"}(OSF=OSF||{}),function(e){var t,n;function r(){this.platformRemappings={web:Office.PlatformType.OfficeOnline,winrt:Office.PlatformType.Universal,win32:Office.PlatformType.PC,mac:Office.PlatformType.Mac,ios:Office.PlatformType.iOS,android:Office.PlatformType.Android},this.camelCaseMappings={powerpoint:Office.HostType.PowerPoint,onenote:Office.HostType.OneNote},this.hostInfo=e._OfficeAppFactory.getHostInfo()}t=e.HostName||(e.HostName={}),r.prototype.capitalizeFirstLetter=function(e){return e?e[0].toUpperCase()+e.slice(1).toLowerCase():e},r.getInstance=function(){return void 0===r.hostObj&&(r.hostObj=new r),r.hostObj},r.prototype.getPlatform=function(e){if(this.hostInfo&&this.hostInfo.hostPlatform){var t=this.hostInfo.hostPlatform.toLowerCase();if(this.platformRemappings[t])return this.platformRemappings[t]}return null},r.prototype.getHost=function(e){if(this.hostInfo&&this.hostInfo.hostType){var t=this.hostInfo.hostType.toLowerCase();if(this.camelCaseMappings[t])return this.camelCaseMappings[t];if(t=this.capitalizeFirstLetter(this.hostInfo.hostType),Office.HostType[t])return Office.HostType[t]}return null},r.prototype.getDefaultVersion=function(){return this.getHost()?"16.0.0000.0000":null},r.prototype.getDiagnostics=function(e){return{host:this.getHost(),version:e||this.getDefaultVersion(),platform:this.getPlatform()}},n=r,t.Host=n}(OSF=OSF||{}),function(e){var t;(t=e.HostInfoFlags||(e.HostInfoFlags={}))[t.SharedApp=1]="SharedApp",t[t.CustomFunction=2]="CustomFunction",t[t.ProtectedDocDisable=4]="ProtectedDocDisable",t[t.ExperimentJsEnabled=8]="ExperimentJsEnabled",t[t.PublicAddin=16]="PublicAddin",t[t.BundleJsEnabled=32]="BundleJsEnabled",t[t.IsMos=64]="IsMos",t[t.IsMonarch=128]="IsMonarch"}(OSF=OSF||{}),function(e){var t;(t=e.HostInfoHostType||(e.HostInfoHostType={})).excel="excel",t.word="word"}(OSF=OSF||{}),function(e){var t;(t=e.HostInfoPlatform||(e.HostInfoPlatform={})).web="web",t.winrt="winrt",t.win32="win32",t.mac="mac",t.ios="ios",t.android="android"}(OSF=OSF||{}),function(i){var e=(t.prototype.saveAndSetDialogInfo=function(e){},t.prototype.setAgaveHostCommunication=function(){},t.prototype.createClientHostController=function(){return null},t.prototype.createAsyncMethodExecutor=function(){return null},t.prototype.createClientSettingsManager=function(){return null},t.prototype.createSettings=function(e){var t=i.OUtil.getSessionStorage();if(t){var n=t.getItem(i._OfficeAppFactory.getCachedSessionSettingsKey());n?e=JSON.parse(n):(n=JSON.stringify(e),t.setItem(i._OfficeAppFactory.getCachedSessionSettingsKey(),n))}var r=i.OUtil.deserializeSettings(e),o=this.createClientSettingsManager();return new Office.Settings(r,o)},t.prototype.prepareApiSurface=function(e){var t=e.get_featureGates();t&&(Microsoft.Office.WebExtension.FeatureGates=t),i.BootStrapExtension.prepareApiSurface&&i.BootStrapExtension.prepareApiSurface(),i.BootStrapExtension.prepareHostSpecificSurface&&i.BootStrapExtension.prepareHostSpecificSurface(),OSFPerformance.createOMEnd=OSFPerformance.now()},t.prototype.getTabbableElements=function(){return null},t);function t(e,t,n,r){this._hostInfo=e,this._webAppState=t,this._context=n,this._hostFacade=r}i.InitializationHelper=e}(OSF=OSF||{}),function(e){var t;(t=e.InitializationReason||(e.InitializationReason={})).Inserted="inserted",t.DocumentOpened="documentOpened"}(OSF=OSF||{}),function(l){!function(e){var i,t=null,n=!1,d=["excel","word","powerpoint","outlook","office-common","office.common","office","officebase"],h=[".js",".debug.js"],g="_osfDisableHostCheck",o=function(){try{return document.currentScript}catch(e){return null}}();function r(){return a(),i.trustedTypesOptIn}function a(){if(!i){function e(e){var t=null!=e?e.src:null;if(!t)return null;for(var n=t.toLowerCase(),r=0;r<d.length;r++)for(var o=0;o<h.length;o++){var i=d[r]+h[o],a=n.indexOf(i);if(0<=a&&(0===a||"/"===t.charAt(a-1)||"\\"===t.charAt(a-1))&&(a+i.length===t.length||"?"===t.charAt(a+i.length))){var s=t.substring(0,a),c=0<n.indexOf(".debug.js",a),l=e.getAttribute("data-is-sdx"),u="1"===l||"true"===l,p=e.getAttribute("data-enable-trusted-types"),f="1"===p||"true"===p;return{basePath:s,name:i,isDebugJs:c,isSdx:u,disableHostCheck:window.hasOwnProperty(g)&&!0===window[g],trustedTypesOptIn:f}}}return null}if(!(i=e(o))){for(var t=document.getElementsByTagName("script"),n=t.length,r=0;r<n;r++)if(i=e(t[r]))return;i={basePath:"",name:"",isDebugJs:!1,isSdx:!1,disableHostCheck:!1,trustedTypesOptIn:!1}}}}e.getHostBundleJsBasePath=function(){return a(),i.basePath},e.getHostBundleJsName=function(){return a(),i.name},e.getOfficeStringJsName=function(){return a(),i.isDebugJs?l.ConstantNames.OfficeStringDebugJS:l.ConstantNames.OfficeStringJS},e.isSdx=function(){return a(),i.isSdx},e.disableHostCheck=function(){return a(),i.disableHostCheck},e.trustedTypesOptIn=r,e.loadScriptWithBasename=function(e,t,n){a();var r=e+(i.isDebugJs?".debug.js":".js");r=r.toLowerCase();var o=i.basePath+r;l.OUtil.loadScript(o,t,c())};var s=["https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js"];function c(){if(!n){n=!0;try{if(!r()||!window.trustedTypes||!window.trustedTypes.createPolicy)return null;var e=o.src,i=new URL(e).origin.toLowerCase();if(!i)return null;t=window.trustedTypes.createPolicy("officejs",{createScriptURL:function(e){var t=e.toLowerCase(),n=new URL(t).origin;if(i&&i===n)return e;for(var r=0,o=s;r<o.length;r++){if(t===o[r])return e}throw new Error("Untrusted script URL")}})}catch(e){}}return t}e.getTrustedTypesPolicy=c}(l.LoadScriptHelper||(l.LoadScriptHelper={}))}(OSF=(OSF=OSF||{})||{}),function(r){var e;((e=r.DDA||(r.DDA={})).Auth||(e.Auth={})).getAuthContextAsync=function(e){function t(e){var t=e.userObjectId||"",n=e.tenantId||"",r=e.userPrincipalName||"";return{userObjectId:t,tenantId:n,userPrincipalName:r,authorityType:e.authorityType||"",authorityBaseUrl:e.authorityBaseUrl||"",puid:e.puid||"",loginHint:e.loginHint||r}}var n={toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){try{return t(JSON.parse(e))}catch(e){return null}},toWebHost:function(){return{}},fromWebHost:function(e){return t(e)}};r._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(205,n,e)}}(OSF=OSF||{}),function(e){var t,n;(n=t=e.LiveShareStateParams||(e.LiveShareStateParams={}))[n.MaxLiveShareStateDataSizeInBytes=1024]="MaxLiveShareStateDataSizeInBytes";var r=(o.prototype.get=function(){return this._liveShareState},o.prototype.set=function(e){if((new TextEncoder).encode(e).length>t.MaxLiveShareStateDataSizeInBytes)throw new Error("State data size is limited to "+t.MaxLiveShareStateDataSizeInBytes+" bytes.");this._liveShareState=e},o.prototype.addHandlerAsync=function(e,t,n){OSF.EventHelper.addEventHandler(e,t,n,this._eventDispatch)},o.prototype.removeHandlerAsync=function(e,t,n){OSF.EventHelper.removeEventHandler(e,t,n,this._eventDispatch)},o);function o(e){var t=this;e=e||null,this._liveShareState=e,this._eventDispatch=new OSF.EventDispatch([{id:OSF.EventDispId.dispidLiveShareStateChangedEvent,type:OSF.EventType.LiveShareStateChanged,getTargetId:function(){return""},fromSafeArrayHost:function(e){return{type:OSF.EventType.LiveShareStateChanged,liveShareState:t}},fromWebHost:function(e){return{type:OSF.EventType.LiveShareStateChanged,liveShareState:t}}}])}e.LiveShareState=r}(Office=Office||{}),function(e){var o={"ar-sa":!0,"bg-bg":!0,"bn-in":!0,"ca-es":!0,"cs-cz":!0,"da-dk":!0,"de-de":!0,"el-gr":!0,"en-us":!0,"es-es":!0,"et-ee":!0,"eu-es":!0,"fa-ir":!0,"fi-fi":!0,"fr-fr":!0,"gl-es":!0,"he-il":!0,"hi-in":!0,"hr-hr":!0,"hu-hu":!0,"id-id":!0,"it-it":!0,"ja-jp":!0,"kk-kz":!0,"ko-kr":!0,"lo-la":!0,"lt-lt":!0,"lv-lv":!0,"ms-my":!0,"nb-no":!0,"nl-nl":!0,"nn-no":!0,"pl-pl":!0,"pt-br":!0,"pt-pt":!0,"ro-ro":!0,"ru-ru":!0,"sk-sk":!0,"sl-si":!0,"sr-cyrl-cs":!0,"sr-cyrl-rs":!0,"sr-latn-cs":!0,"sr-latn-rs":!0,"sv-se":!0,"th-th":!0,"tr-tr":!0,"uk-ua":!0,"ur-pk":!0,"vi-vn":!0,"zh-cn":!0,"zh-tw":!0},i={ar:"ar-sa",bg:"bg-bg",bn:"bn-in",ca:"ca-es",cs:"cs-cz",da:"da-dk",de:"de-de",el:"el-gr",en:"en-us",es:"es-es",et:"et-ee",eu:"eu-es",fa:"fa-ir",fi:"fi-fi",fr:"fr-fr",gl:"gl-es",he:"he-il",hi:"hi-in",hr:"hr-hr",hu:"hu-hu",id:"id-id",it:"it-it",ja:"ja-jp",kk:"kk-kz",ko:"ko-kr",lo:"lo-la",lt:"lt-lt",lv:"lv-lv",ms:"ms-my",nb:"nb-no",nl:"nl-nl",nn:"nn-no",pl:"pl-pl",pt:"pt-br",ro:"ro-ro",ru:"ru-ru",sk:"sk-sk",sl:"sl-si",sr:"sr-cyrl-cs",sv:"sv-se",th:"th-th",tr:"tr-tr",uk:"uk-ua",ur:"ur-pk",vi:"vi-vn",zh:"zh-cn"};e.getSupportedLocale=function(e,t){if(void 0===t&&(t="en-us"),!e)return t;var n;if((e=e.toLowerCase())in o)n=e;else{var r=e.split("-",1);r&&0<r.length&&(n=i[r[0]])}return n=n||t}}(OSF=OSF||{}),function(e){e.OfficeOM||(e.OfficeOM={})}(Strings=Strings||{}),function(o){var i,e;(i=o.OUtil||(o.OUtil={})).ensureOfficeStringsJs=function(){return e=e||(1==o.OUtil.getLibraryReleaseVehicle()?new Office.Promise(function(e,t){e()}):new Office.Promise(function(n,r){if(o._OfficeAppFactory.getHostInfo().hostLocale){var e=o.LoadScriptHelper.getHostBundleJsBasePath()+o._OfficeAppFactory.getHostInfo().hostLocale+"/"+o.LoadScriptHelper.getOfficeStringJsName();o.OUtil.loadScript(e,function(e){if(e)n();else{var t=o.LoadScriptHelper.getHostBundleJsBasePath()+o.ConstantNames.DefaultLocale+"/"+o.LoadScriptHelper.getOfficeStringJsName();i.loadScript(t,function(e){e?n():r(new Error("Cannot load "+o.ConstantNames.OfficeStringJS))},o.LoadScriptHelper.getTrustedTypesPolicy())}},o.LoadScriptHelper.getTrustedTypesPolicy())}else r(new Error("No host locale"))}))}}(OSF=OSF||{}),function(u){var e,t,n;e=u.context||(u.context={}),t=e.document||(e.document={}),OSF.definePropertyOnNamespace(t,"url",function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_docUrl()}),OSF.definePropertyOnNamespace(t,"mode",function(){return 0==OSF._OfficeAppFactory.getOfficeAppContext().get_clientMode()?u.DocumentMode.ReadOnly:u.DocumentMode.ReadWrite}),OSF.definePropertyOnNamespace(t,"settings",function(){if(!n){var e=OSF._OfficeAppFactory.getOfficeAppContext().get_settingsFunc()();n=OSF._OfficeAppFactory.getInitializationHelper().createSettings(e)}return n}),t.goToByIdAsync=function(e,t,n,r){var o={};o[u.GoToType.Binding]=0,o[u.GoToType.NamedItem]=1,o[u.GoToType.Slide]=2,o[u.GoToType.Index]=3;var i={};i[u.SelectionMode.Default]=0,i[u.SelectionMode.Selected]=1,i[u.SelectionMode.None]=2;var a=o[t],s=0,c=r;"function"==typeof n?c=n:void 0!==n&&(s=i[n]);var l={toSafeArrayHost:function(){return[e,a,s]},fromSafeArrayHost:function(e){return e},toWebHost:function(){return{DdaGoToByIdMethod:{Id:e,GoToType:a,SelectionMode:s}}},fromWebHost:function(e){return e}};OSF._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(82,l,c)}}(Office=Office||{}),function(e){var t,n;t=e.context||(e.context={}),(n=t.messaging||(t.messaging={})).sendMessage=function(e){if(OSF._OfficeAppFactory.getHostInfo().hostPlatform==OSF.HostInfoPlatform.web){var t=OSF._OfficeAppFactory.getWebAppState();t.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[t.id,OSF.AgaveHostAction.SendMessage,e])}else{var n=JSON.stringify(e);OSF._OfficeAppFactory.getClientHostController().execute(208,[n],null)}},n.registerOnMessageEventHandler=function(r){if(OSF._OfficeAppFactory.getHostInfo().hostPlatform==OSF.HostInfoPlatform.web)n.onMessage=r;else{OSF._OfficeAppFactory.getClientHostController().registerEvent(OSF.EventDispId.dispidOnSdxSendMessageEvent,"","",function(e,t){var n=t.toArray();r(JSON.parse(n[0]))},null)}}}(Office=Office||{}),function(r){var e,t,o;e=r.context||(r.context={}),OSF.definePropertyOnNamespace(e,"contentLanguage",function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_dataLocale()}),OSF.definePropertyOnNamespace(e,"displayLanguage",function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_appUILocale()}),OSF.definePropertyOnNamespace(e,"partitionKey",function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_partitionKey()}),OSF.definePropertyOnNamespace(e,"isDialog",function(){return OSF._OfficeAppFactory.getHostInfo().isDialog}),OSF.definePropertyOnNamespace(e,"touchEnabled",function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_touchEnabled()}),OSF.definePropertyOnNamespace(e,"commerceAllowed",function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_commerceAllowed()}),OSF.definePropertyOnNamespace(e,"host",function(){return OSF.HostName.Host.getInstance().getHost()}),OSF.definePropertyOnNamespace(e,"platform",function(){return OSF.HostName.Host.getInstance().getPlatform()}),OSF.definePropertyOnNamespace(e,"diagnostics",function(){return OSF.HostName.Host.getInstance().getDiagnostics(OSF._OfficeAppFactory.getOfficeAppContext().get_hostFullVersion())}),OSF.definePropertyOnNamespace(e,"requirements",function(){if(!t){var e=OSF._OfficeAppFactory.getOfficeAppContext();e&&(t=e.get_isDialog()?OSF.Requirement.RequirementsMatrixFactory.getDefaultDialogRequirementMatrix(e):OSF.Requirement.RequirementsMatrixFactory.getDefaultRequirementMatrix(e))}return t}),OSF.definePropertyOnNamespace(e,"officeTheme",function(){var e=OSF._OfficeAppFactory.getOfficeAppContext().get_officeThemeFunc();return e?"function"==typeof e?e():e:void 0}),OSF.definePropertyOnNamespace(e,"webAuth",function(){if(OSF.DDA.WebAuth)return OSF.DDA.WebAuth}),OSF.definePropertyOnNamespace(e,"auth",function(){if(OSF.DDA.Auth)return OSF.DDA.Auth}),OSF.definePropertyOnNamespace(e,"license",function(){return OSF._OfficeAppFactory.getOfficeAppContext().get_eToken()}),OSF.definePropertyOnNamespace(e,"hostSettings",function(){if(!o){var e=OSF._OfficeAppFactory.getOfficeAppContext().get_hostSettingsFunc();if(void 0!==e){var t=e(),n=OSF.OUtil.deserializeSettings(t);o=new r.Settings(n,void 0)}}return o})}(Office=Office||{}),function(e){var t;((t=e.context||(e.context={})).ribbonGallery||(t.ribbonGallery={})).refreshRibbon=function(e){OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[OSF._OfficeAppFactory.getWebAppState().id,OSF.AgaveHostAction.RefreshRibbonGallery,e])}}(Office=Office||{}),function(e){var t,n;t=e.context||(e.context={}),(n=t.ui||(t.ui={})).taskPaneAction||(n.taskPaneAction={})}(Office=Office||{});var __assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var o in t=arguments[n])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)};!function(n){function t(){n._officeOnReadyState.officeOnReadyPromise||(n._officeOnReadyState.officeOnReadyPromise=new n.Promise(function(e,t){n._officeOnReadyState.officeOnReadyPromiseResolve=e}))}function r(e){return t(),e&&(n._officeOnReadyState.officeOnReadyFired?e(n._officeOnReadyState.officeOnReadyHostAndPlatformInfo):n._officeOnReadyState.officeOnReadyCallbacks.push(e)),n._officeOnReadyState.officeOnReadyPromise}n._officeOnReadyState=n._officeOnReadyState||{isOfficeOnReadyCalled:!1,officeOnReadyPromise:null,officeOnReadyPromiseResolve:null,officeOnReadyCallbacks:[],officeOnReadyHostAndPlatformInfo:null,officeOnReadyFired:!1},n.initialize=n.initialize,n.onReadyInternal=r,n.onReady=function(e){return n._officeOnReadyState.isOfficeOnReadyCalled=!0,r(e)},n.fireOnReady=function(e){for(t(),n._officeOnReadyState.officeOnReadyHostAndPlatformInfo=__assign({},e),n._officeOnReadyState.officeOnReadyFired=!0,OSFPerformance.officeOnReady=OSFPerformance.now();0<n._officeOnReadyState.officeOnReadyCallbacks.length;)n._officeOnReadyState.officeOnReadyCallbacks.shift()(n._officeOnReadyState.officeOnReadyHostAndPlatformInfo);n._officeOnReadyState.officeOnReadyPromiseResolve(n._officeOnReadyState.officeOnReadyHostAndPlatformInfo),n._officeOnReadyState.isOfficeOnReadyCalled||OSF.OUtil.waitForFunction(function(){return"function"==typeof n.initialize},function(e){e&&n.initialize(OSF._OfficeAppFactory.getOfficeAppContext().get_reason())},400,50)}}(Office=Office||{}),function(R){var e=(t.prototype.get_id=function(){return this._id},t.prototype.get_appName=function(){return this._appName},t.prototype.get_appVersion=function(){return this._appVersion},t.prototype.get_appUILocale=function(){return this._appUILocale},t.prototype.get_dataLocale=function(){return this._dataLocale},t.prototype.get_docUrl=function(){return this._docUrl},t.prototype.get_clientMode=function(){return this._isWeb?this._clientMode:0==this._clientMode?Office.DocumentMode.ReadWrite:Office.DocumentMode.ReadOnly},t.prototype.get_settingsFunc=function(){return this._settingsFunc},t.prototype.get_reason=function(){return this._reason},t.prototype.get_osfControlType=function(){return this._osfControlType},t.prototype.get_eToken=function(){return this._eToken},t.prototype.get_correlationId=function(){return this._correlationId},t.prototype.get_appInstanceId=function(){return this._appInstanceId},t.prototype.get_touchEnabled=function(){return this._touchEnabled},t.prototype.get_commerceAllowed=function(){return this._commerceAllowed},t.prototype.get_appMinorVersion=function(){return this._appMinorVersion},t.prototype.get_requirementMatrix=function(){return this._requirementMatrix},t.prototype.get_dialogRequirementMatrix=function(){return this._dialogRequirementMatrix},t.prototype.get_hostCustomMessage=function(){return this._hostCustomMessage},t.prototype.get_hostFullVersion=function(){return this._hostFullVersion},t.prototype.get_isDialog=function(){return this._isDialog},t.prototype.get_clientWindowHeight=function(){return this._clientWindowHeight},t.prototype.get_clientWindowWidth=function(){return this._clientWindowWidth},t.prototype.get_addinName=function(){return this._addinName},t.prototype.get_appDomains=function(){return this._appDomains},t.prototype.get_taskpaneUrl=function(){return this._taskpaneUrl},t.prototype.set_taskpaneUrl=function(e){this._taskpaneUrl=e},t.prototype.get_featureGates=function(){return this._featureGates},t.prototype.get_officeThemeFunc=function(){return this._officeThemeFunc},t.prototype.get_initialDisplayMode=function(){return this._initialDisplayMode?this._initialDisplayMode:0},t.prototype.get_isFromWacAutomation=function(){return this._isFromWacAutomation},t.prototype.get_wopiHostOriginForSingleSignOn=function(){return this._wopiHostOriginForSingleSignOn},t.prototype.get_hostSettingsFunc=function(){return this._hostSettingsFunc},t.prototype.get_isWeb=function(){return this._isWeb},t.prototype.get_nestedAppAuthBridgeType=function(){return this._nestedAppAuthBridgeType},t.prototype.get_partitionKey=function(){return this._partitionKey},t);function t(e,t,n,r,o,i,a,s,c,l,u,p,f,d,h,g,m,y,v,b,_,O,S,C,A,P,E,T,w,I,x,D,F){this._id=e,this._appName=t,this._appVersion=n,this._appUILocale=r,this._dataLocale=o,this._docUrl=i,this._clientMode=a,this._settingsFunc=s,this._reason=c,this._osfControlType=l,this._eToken=u,this._correlationId=p,this._appInstanceId=f,this._touchEnabled=d,this._commerceAllowed=h,this._appMinorVersion=g,this._requirementMatrix=m,this._hostCustomMessage=y,this._hostFullVersion=v,this._isDialog=R.OUtil.isDialog(),this._clientWindowHeight=b,this._clientWindowWidth=_,this._addinName=O,this._appDomains=S,this._dialogRequirementMatrix=C,this._featureGates=A,this._officeThemeFunc=P,this._initialDisplayMode=E,this._isFromWacAutomation=T,this._wopiHostOriginForSingleSignOn=w,this._hostSettingsFunc=I,this._isWeb=x,this._nestedAppAuthBridgeType=D,this._partitionKey=F}R.OfficeAppContext=e}(OSF=OSF||{}),function(l){(l._OfficeAppFactory||(l._OfficeAppFactory={})).retrieveHostInfo=function(){var e={isO15:!0,isRichClient:!0,hostType:"",hostPlatform:"",hostSpecificFileVersion:"",hostLocale:"",osfControlAppCorrelationId:"",isDialog:!1,disableLogging:!1,flags:0},t="_host_Info",n=null;try{if(window.external=window.external||{},"undefined"!=typeof agaveHost&&agaveHost.GetHostInfo&&(window.external.GetHostInfo=function(){return agaveHost.GetHostInfo()}),window.external.GetHostInfo){var r=window.external.GetHostInfo();if("isDialog"==r)e.isO15=!0,e.isDialog=!0;else{var o=r.split(t+"=");n=1<o.length?o[1]:r}}}catch(e){l.Utility.log(JSON.stringify(e))}if(!n)try{var i=window.name;if(i){var a=JSON.parse(i);n=a?a.hostInfo:null}}catch(e){l.Utility.log(JSON.stringify(e))}n=n||l.Utility.getQueryStringValue(t);var s=l.OUtil.getSessionStorage();if(!n&&s.getItem("hostInfoValue")&&(n=s.getItem("hostInfoValue")),n){n=decodeURIComponent(n),e.isO15=!1;var c=n.split("$");void 0===c[2]&&(c=n.split("|")),e.hostType=void 0===c[0]?"":c[0].toLowerCase(),e.hostPlatform=void 0===c[1]?"":c[1].toLowerCase(),e.hostSpecificFileVersion=void 0===c[2]?"":c[2].toLowerCase(),e.hostLocale=void 0===c[3]?"":c[3].toLowerCase(),e.osfControlAppCorrelationId=void 0===c[4]?"":c[4],"telemetry"==e.osfControlAppCorrelationId&&(e.osfControlAppCorrelationId=""),e.isDialog=void 0!==c[5]&&"isDialog"==c[5],e.disableLogging=void 0!==c[6]&&"disableLogging"==c[6],e.flags="string"==typeof c[7]&&0<c[7].length?parseInt(c[7]):0,s.setItem("hostInfoValue",n)}else e.isO15=!0,e.hostLocale=l.Utility.getQueryStringValue("locale");return e}}(OSF=OSF||{}),function(f){var e;!function(e){var t,n,r,o,i,a,s,c,l;"undefined"!=typeof window&&(window.location&&(t=window.location.hash,n=window.location.search),r=window.name);var u={0:"Unknown",1:"Hidden",2:"Taskpane",3:"Dialog"};function p(e,t){f.AppCommandManager.initialize();var n=e.get_appName(),r=null;0!=(o.flags&f.HostInfoFlags.SharedApp)&&(r={visibilityMode:u[e.get_initialDisplayMode()]}),Office.fireOnReady({host:f.HostName.Host.getInstance().getHost(n),platform:f.HostName.Host.getInstance().getPlatform(n),addin:r}),o.hostPlatform==f.HostInfoPlatform.web&&null!=i.clientEndPoint&&i.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i.id,f.AgaveHostAction.OfficeJsReady,Date.now()]),t(e)}e.bootstrap=function(t,n){if(i={id:null,webAppUrl:null,conversationID:null,clientEndPoint:null,wnd:window.parent,focused:!1,serviceEndPoint:null},o=e.retrieveHostInfo(),function(){0;try{if(o.disableLogging)return 0;window.external=window.external||{},void 0===window.external.GetLoggingAllowed||window.external.GetLoggingAllowed()}catch(e){}}(),function(){if(o.hostPlatform===f.HostInfoPlatform.web)a=new f.WebInitializationHelper(o,i,null,null);else if(o.hostPlatform===f.HostInfoPlatform.win32)a=new f.RichClientInitializationHelper(o,i,null,null);else if(o.hostPlatform===f.HostInfoPlatform.ios||o.hostPlatform===f.HostInfoPlatform.mac){if(!(window.webkit&&window.webkit.messageHandlers&&window.webkit.messageHandlers.Agave))throw f.Utility.createNotImplementedException();a=new f.WebkitInitializationHelper(o,i,null,null)}else o.hostPlatform===f.HostInfoPlatform.android||o.hostPlatform===f.HostInfoPlatform.winrt?a=new f.WebViewInitializationHelper(o,i,null,null):console.warn("Office.js is loaded inside in unknown host or platform "+o.hostPlatform)}(),a){o.hostPlatform===f.HostInfoPlatform.web&&a.saveAndSetDialogInfo(f.Utility.getQueryStringValue("_host_Info")),a.setAgaveHostCommunication(),OSFPerformance.getAppContextStart=OSFPerformance.now();a.getAppContext(window,function(e){OSFPerformance.getAppContextEnd=OSFPerformance.now(),f.AppTelemetry.initialize(e),c=e,l=a.createClientHostController(),s=a.createAsyncMethodExecutor(),a.prepareApiSurface(e),f.BootStrapExtension.onGetAppContext?f.BootStrapExtension.onGetAppContext(e,i.wnd).then(function(){p(e,t)}):p(e,t)},function(e){n(e)})}else n(new Error("Office.js cannot be initialized."))},e.getWindowName=function(){return r},e.getWindowLocationHash=function(){return t},e.getWindowLocationSearch=function(){return n},e.getAsyncMethodExecutor=function(){return s},e.getOfficeAppContext=function(){return c},e.getHostInfo=function(){return o},e.getCachedSessionSettingsKey=function(){return(null!=i.conversationID?i.conversationID:c.get_appInstanceId())+"CachedSessionSettings"},e.getWebAppState=function(){return i},e.getId=function(){return i.id},e.getInitializationHelper=function(){return a},e.getClientHostController=function(){return l}}(e=f._OfficeAppFactory||(f._OfficeAppFactory={})),f.getClientEndPoint=function(){return e.getWebAppState().clientEndPoint}}(OSF=OSF||{}),function(e){var t,n,r,o,i,a,s,c,l,u,p,f,d;(t=e.AsyncResultStatus||(e.AsyncResultStatus={})).Succeeded="succeeded",t.Failed="failed",(n=e.DocumentMode||(e.DocumentMode={})).ReadOnly="readOnly",n.ReadWrite="readWrite",(r=e.HostType||(e.HostType={})).Word="Word",r.Excel="Excel",r.PowerPoint="PowerPoint",r.Outlook="Outlook",r.OneNote="OneNote",r.Project="Project",r.Access="Access",r.Visio="Visio",(o=e.InitializationReason||(e.InitializationReason={})).Inserted="inserted",o.DocumentOpened="documentOpened",(i=e.PlatformType||(e.PlatformType={})).PC="PC",i.OfficeOnline="OfficeOnline",i.Mac="Mac",i.iOS="iOS",i.Android="Android",i.Universal="Universal",(a=e.GoToType||(e.GoToType={})).Binding="binding",a.NamedItem="namedItem",a.Slide="slide",a.Index="index",(s=e.SelectionMode||(e.SelectionMode={})).Default="default",s.Selected="selected",s.None="none",(c=e.ValueFormat||(e.ValueFormat={})).Unformatted="unformatted",c.Formatted="formatted",(l=e.FileType||(e.FileType={})).Text="text",l.Compressed="compressed",l.Pdf="pdf",e.CoercionType={Html:"html",Matrix:"matrix",Ooxml:"ooxml",OoxmlPackage:"ooxmlPackage",PdfFile:"pdfFile",SlideRange:"slideRange",Table:"table",Text:"text"},(u=e.BindingType||(e.BindingType={})).Table="table",u.Text="text",u.Matrix="matrix",(p=e.FilterType||(e.FilterType={})).OnlyVisible="onlyVisible",p.All="all",(f=e.Table||(e.Table={}))[f.All=0]="All",f[f.Data=1]="Data",f[f.Headers=2]="Headers",(d=e.ActiveView||(e.ActiveView={})).Read="read",d.Edit="edit"}(Office=Office||{});var OSFPerfUtil,__extends=this&&this.__extends||function(){var r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)};return function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}}();(OfficeExt||(OfficeExt={})).appSpecificCheckOrigin=function(e,t,n,r){return!1},function(P){var a=(e.prototype.getMethod=function(){return this._method},e.prototype.getInvokeType=function(){return this._invokeType},e.prototype.getBlockingFlag=function(){return this._blockingOthers},e);function e(e,t,n){this._method=e,this._invokeType=t,this._blockingOthers=n}P.XdmMethodObject=a;var s=(t.prototype.getRegisterMethodObject=function(){return this._registerMethodObject},t.prototype.getUnregisterMethodObject=function(){return this._unregisterMethodObject},t);function t(e,t){this._registerMethodObject=e,this._unregisterMethodObject=t}P.XdmEventMethodObject=s;var n=(r.prototype.registerMethod=function(e,t,n,r){if(0!==n&&1!==n)throw P.Utility.createArgumentException("invokeType");var o=new a(t,n,r);this._methodObjectList[e]=o},r.prototype.unregisterMethod=function(e){delete this._methodObjectList[e]},r.prototype.registerEvent=function(e,t,n){var r=new s(new a(t,4,!1),new a(n,5,!1));this._methodObjectList[e]=r},r.prototype.registerEventEx=function(e,t,n,r,o){var i=new s(new a(t,n,!1),new a(r,o,!1));this._methodObjectList[e]=i},r.prototype.unregisterEvent=function(e){this.unregisterMethod(e)},r.prototype.registerConversation=function(e,t,n){if(P.Utility.xdmDebugLog("registerConversation: cId="+e+" Url="+t),n){if(!Array.isArray(n))throw P.Utility.createArgumentException("appDomains");this._appDomains[e]=n}this._conversations[e]={url:t}},r.prototype.unregisterConversation=function(e){delete this._conversations[e]},r.prototype.setPolicyManager=function(e){if(!e.checkPermission)throw P.Utility.createArgumentException("policyManager");this._policyManager=e},r.prototype.getPolicyManager=function(){return this._policyManager},r.prototype.dispose=function(){this._methodObjectList=null,this._eventHandlerProxyList=null,this._Id=null,this._conversations=null,this._policyManager=null,this._appDomains=null,this._onHandleRequestError=null},r);function r(e){this._methodObjectList={},this._eventHandlerProxyList={},this._conversations={},this._policyManager=null,this._appDomains={},this._onHandleRequestError=null,this._methodObjectList={},this._eventHandlerProxyList={},this._Id=e,this._conversations={},this._policyManager=null,this._appDomains={},this._onHandleRequestError=null}P.XdmServiceEndPoint=n;var l,o,E,T,w,I,x,D,F,i,c=(Object.defineProperty(u.prototype,"targetUrl",{get:function(){return this._targetUrl},enumerable:!0,configurable:!0}),Object.defineProperty(u.prototype,"hostTrustCheckStatus",{get:function(){return this._hostTrustCheckStatus},set:function(e){this._hostTrustCheckStatus=e},enumerable:!0,configurable:!0}),Object.defineProperty(u.prototype,"fHostTrusted",{get:function(){return this._fHostTrusted},enumerable:!0,configurable:!0}),Object.defineProperty(u.prototype,"checkStatusLogged",{get:function(){return this._checkStatusLogged},set:function(e){this._checkStatusLogged=e},enumerable:!0,configurable:!0}),Object.defineProperty(u.prototype,"checkReceiverOriginAndRun",{get:function(){return this._checkReceiverOriginAndRun},set:function(e){this._checkReceiverOriginAndRun=e},enumerable:!0,configurable:!0}),u.prototype.invoke=function(i,a,s){function e(){var t=c._callingIndex++,e=new Date,n={callback:a,createdOn:e.getTime()};s&&"object"==typeof s&&"number"==typeof s.__timeout__&&(n.timeout=s.__timeout__,delete s.__timeout__),c._callbackList[t]=n;try{if(3!==c._hostTrustCheckStatus&&"ContextActivationManager_getAppContextAsync"!==i)throw"Access Denied";var r=new m(i,0,c._conversationId,t,s),o=B.envelope(r);c._targetWindow.postMessage(o,c._targetUrl),l._startMethodTimeoutTimer()}catch(e){try{null!==a&&a(-1,e)}finally{delete c._callbackList[t]}}}var c=this;this._checkReceiverOriginAndRun?this._checkReceiverOriginAndRun(e):(this._hostTrustCheckStatus=3,e())},u.prototype.registerForEvent=function(e,t,n,r){var o=this._callingIndex++,i=new Date;this._callbackList[o]={callback:n,createdOn:i.getTime()};try{var a=new m(e,1,this._conversationId,o,r),s=B.envelope(a);this._targetWindow.postMessage(s,this._targetUrl),l._startMethodTimeoutTimer(),this._eventHandlerList[e]=t}catch(e){try{null!==n&&n(-1,e)}finally{delete this._callbackList[o]}}},u.prototype.unregisterForEvent=function(e,t,n){var r=this._callingIndex++,o=new Date;this._callbackList[r]={callback:t,createdOn:o.getTime()};try{var i=new m(e,2,this._conversationId,r,n),a=B.envelope(i);this._targetWindow.postMessage(a,this._targetUrl),l._startMethodTimeoutTimer()}catch(e){try{null!==t&&t(-1,e)}finally{delete this._callbackList[r]}}finally{delete this._eventHandlerList[e]}},u);function u(e,t,n){this._callbackList={},this._eventHandlerList={},this._hostTrustCheckStatus=0,this._checkStatusLogged=!1,this._fHostTrusted=!1,this._conversationId=e,this._targetWindow=t,this._targetUrl=n,this._callingIndex=0,this._callbackList={},this._eventHandlerList={},this._checkReceiverOriginAndRun=null}function R(){null!==w?x||(0<E.length?N(E.shift()):(clearInterval(w),w=null)):P.Utility.xdmDebugLog("channel is not ready.")}function N(e){x=e.getInvokeBlockingFlag(),e.invoke(),T=(new Date).getTime()}function M(){x=!1}function j(e,t){var n=!1;if(!(t&&"null"!==t&&t.length&&e&&e instanceof Array&&e.length))return n;for(var r=0;r<e.length&&!n;r++)if(-1!==e[r].indexOf("://")){var o=P.OUtil.parseUrl(t,!0);n=U(P.OUtil.parseUrl(e[r],!0),o)}return n}function k(e){if(!e||"null"===e)return!1;var t=new Array("^outlook\\.office\\.com$","^outlook-sdf\\.office\\.com$","^outlook\\.office\\.com$","^outlook-sdf\\.office\\.com$","^outlook\\.live\\.com$","^outlook-sdf\\.live\\.com$","^consumer\\.live-int\\.com$","^outlook-tdf\\.live\\.com$","^sdfpilot\\.live\\.com$","^outlook\\.office365\\.us$","^outlook\\.office365\\.com$","^exchangelabs\\.live-int\\.com$","^.*\\.dod\\.online\\.office365\\.us$","^.*\\.gov\\.online\\.office365\\.us$","^.*\\.officeapps\\.live\\.com$","^.*\\.officeapps-df\\.live\\.com$","^"+document.domain.replace(new RegExp("\\.","g"),"\\.")+"$");return!0===P.OUtil.getCustomOfficeInitializationSettings().trustAllCloudEnvironments&&t.push("^partner\\.outlook\\.cn$","^.*\\.partner\\.officewebapps\\.cn$"),new RegExp(t.join("|")).test(e)}function H(e,t){if(!e||!t||"null"===e||"null"===t)return!1;var n=P.OUtil.parseUrl(e,!0),r=P.OUtil.parseUrl(t,!0);if(null==n||null==r)return!1;var o=n.protocol===r.protocol,i=n.port===r.port,a=r.hostname,s=n.hostname,c=a===s,l=!1;return!c&&a.length>s.length+1&&(l=a.slice(-(s.length+1))==="."+s),i&&o&&(c||l)}function U(e,t){return e.hostname==t.hostname&&e.protocol==t.protocol&&e.port==t.port}function p(t){if(""!=t.data){var n,e=t.data;try{n=B.unenvelope(e)}catch(e){return}if(P.Utility.xdmDebugLog(e),0===n._messageType){var r=null==t.origin||"null"===t.origin?n._origin:t.origin;try{var o=function(e){for(var t in D)if(D[t]._conversations[e])return D[t];throw P.Utility.createArgumentException("conversationId")}(n._conversationId);P.Utility.xdmDebugLog("_receive: request, origin="+r+" sourceURL:"+o._conversations[n._conversationId]);var i=o._conversations[n._conversationId];P.Utility.xdmDebugLog("_receive: request, origin="+r+" sourceURL:"+i.url);var a=[i.url].concat(o._appDomains[n._conversationId]);if(!j(a,t.origin))if(!OfficeExt.appSpecificCheckOrigin(a,t,n._origin,j))if(!H(i.url,t.origin))throw"Failed origin check";var s=o.getPolicyManager();if(s&&!s.checkPermission(n._conversationId,n._actionName,n._data))throw"Access Denied";var c=function(e,t){var n=e._methodObjectList[t._actionName];if(!n)throw P.Utility.xdmDebugLog("The specified method is not registered on service endpoint:"+t._actionName),P.Utility.createArgumentException("messageObject");return 0===t._actionType?n:1===t._actionType?n.getRegisterMethodObject():n.getUnregisterMethodObject()}(o,n),l=new W(t.source,r,n._actionName,n._conversationId,n._correlationId,M),u=new q(c,n._data,l,o._eventHandlerProxyList,n._conversationId,n._actionName),p=!0;null==w&&((null==T||(new Date).getTime()-T>I)&&!x?(N(u),p=!1):w=setInterval(R,I)),p&&(A=u,E.push(A))}catch(e){o&&o._onHandleRequestError&&o._onHandleRequestError(n,e);var f=-2;"Access Denied"==e&&(f=-5);var d=new L(n._actionName,n._conversationId,n._correlationId,f,0,e),h=B.envelope(d),g=!1;try{g=!(!t.source||!t.source.postMessage)}catch(e){}var m=!1;if(window.location.href&&t.origin&&"null"!==t.origin&&H(window.location.href,t.origin))m=!0;else if(t.origin&&"null"!==t.origin)m=k(P.OUtil.parseUrl(t.origin,!0).hostname);g&&m&&t.source.postMessage(h,r)}}else{if(1!==n._messageType)return;var y=(S=n._conversationId,(C=F[S])||P.Utility.xdmDebugLog("Unknown conversation Id."),C);if(!y)return;if(P.Utility.xdmDebugLog("_receive: response, origin="+t.origin+" targetURL:"+y._targetUrl),_=y._targetUrl,O=t.origin,!(_&&O&&"null"!==_&&"null"!==O&&_.length&&O.length&&U(P.OUtil.parseUrl(_,!0),P.OUtil.parseUrl(O,!0))))throw"Failed orgin check";if(3==y._hostTrustCheckStatus&&(y._fHostTrusted=!0),0===n._responseType){var v=y._callbackList[n._correlationId];if(v)try{v.callback&&v.callback(n._errorCode,n._data)}finally{delete y._callbackList[n._correlationId]}}else{var b=y._eventHandlerList[n._actionName];null!=b&&b(n._data)}}}var _,O,S,C,A}function f(){i||(function(e){if(window.addEventListener)window.addEventListener("message",e,!1);else{if(!(-1<navigator.userAgent.indexOf("MSIE")&&window.attachEvent))throw P.Utility.xdmDebugLog("Browser doesn't support the required API."),P.Utility.createArgumentException("Browser");window.attachEvent("onmessage",e)}}(p),i=!0)}P.XdmClientEndPoint=c,o=l=P.XdmCommunicationManager||(P.XdmCommunicationManager={}),E=[],w=T=null,x=!(I=10),D={},i=!(F={}),o.connect=function(e,t,n){var r=F[e];return r||(f(),r=new c(e,t,n),F[e]=r),r},o.getClientEndPoint=function(e){return F[e]},o.createServiceEndPoint=function(e){f();var t=new n(e);return D[e]=t},o.getServiceEndPoint=function(e){return D[e]},o.deleteClientEndPoint=function(e){delete F[e]},o.deleteServiceEndPoint=function(e){delete D[e]},o.checkUrlWithAppDomains=function(e,t){return j(e,t)},o.isTargetSubdomainOfSourceLocation=function(e,t){return H(e,t)},o._setMethodTimeout=function(e){0},o._startMethodTimeoutTimer=function(){},o.isHostNameValidWacDomain=function(e){return k(e)};var d=(h.prototype.getActionName=function(){return this._actionName},h.prototype.getConversationId=function(){return this._conversationId},h.prototype.getCorrelationId=function(){return this._correlationId},h.prototype.getOrigin=function(){return this._origin},h.prototype.getData=function(){return this._data},h.prototype.getMessageType=function(){return this._messageType},h);function h(e,t,n,r,o){this._messageType=e,this._actionName=t,this._conversationId=n,this._correlationId=r,this._origin=window.location.origin,this._data=void 0===o?null:o}var g,m=(__extends(y,g=d),y.prototype.getActionType=function(){return this._actionType},y);function y(e,t,n,r,o){var i=g.call(this,0,e,n,r,o)||this;return i._actionType=t,i}var v,L=(__extends(b,v=d),b.prototype.getErrorCode=function(){return this._errorCode},b.prototype.getResponseType=function(){return this._responseType},b);function b(e,t,n,r,o,i){var a=v.call(this,1,e,t,n,i)||this;return a._errorCode=r,a._responseType=o,a}var B=(_.envelope=function(e){return JSON.stringify(e)},_.unenvelope=function(e){return JSON.parse(e)},_);function _(){}var O=(S.prototype.getRequesterWindow=function(){return this._requesterWindow},S.prototype.getRequesterUrl=function(){return this._requesterUrl},S.prototype.getActionName=function(){return this._actionName},S.prototype.getConversationId=function(){return this._conversationId},S.prototype.getCorrelationId=function(){return this._correlationId},S.prototype.getSend=function(){return this._send},S.prototype.setResultCode=function(e){this._invokeResultCode=e},S);function S(e,t,n,r,o,i){var a=this;this._invokeResultCode=0,this._requesterWindow=e,this._requesterUrl=t,this._actionName=n,this._conversationId=r,this._correlationId=o,this._invokeResultCode=0,this._responseType=i,this._send=function(e){try{var t=new L(a._actionName,a._conversationId,a._correlationId,a._invokeResultCode,a._responseType,e),n=B.envelope(t);a._requesterWindow.postMessage(n,a._requesterUrl),P.Utility.xdmDebugLog("_send: requestUrl="+a._requesterUrl+" _actionName:"+a._actionName)}catch(e){P.Utility.xdmDebugLog("ResponseSender._send error:"+e.message)}}}var C,W=(__extends(A,C=O),A);function A(e,t,n,r,o,i){var a=C.call(this,e,t,n,r,o,0)||this;return a._postCallbackHandler=i,a._send=function(e,t){null!=t&&(a._invokeResultCode=t);try{var n=new L(a._actionName,a._conversationId,a._correlationId,a._invokeResultCode,a._responseType,e),r=B.envelope(n);a._requesterWindow.postMessage(r,a._requesterUrl),a._postCallbackHandler()}catch(e){P.Utility.xdmDebugLog("InvokeCompleteCallback._send error:"+e.message)}},a}var q=(V.prototype.invoke=function(){try{var e;switch(this._methodObject.getInvokeType()){case 0:this._methodObject.getMethod()(this._param,this._invokeCompleteCallback.getSend());break;case 1:e=this._methodObject.getMethod()(this._param),this._invokeCompleteCallback.getSend()(e);break;case 4:var t=this._createEventHandlerProxyObject(this._invokeCompleteCallback);e=this._methodObject.getMethod()(t.getSend(),this._param),this._eventHandlerProxyList[this._conversationId+this._eventName]=t.getSend(),this._invokeCompleteCallback.getSend()(e);break;case 5:var n=this._eventHandlerProxyList[this._conversationId+this._eventName];e=this._methodObject.getMethod()(n,this._param),delete this._eventHandlerProxyList[this._conversationId+this._eventName],this._invokeCompleteCallback.getSend()(e);break;case 2:var r=this._createEventHandlerProxyObject(this._invokeCompleteCallback);this._methodObject.getMethod()(r.getSend(),this._invokeCompleteCallback.getSend(),this._param),this._eventHandlerProxyList[this._callerId+this._eventName]=r.getSend();break;case 3:var o=this._eventHandlerProxyList[this._callerId+this._eventName];this._methodObject.getMethod()(o,this._invokeCompleteCallback.getSend(),this._param),delete this._eventHandlerProxyList[this._callerId+this._eventName]}}catch(e){this._invokeCompleteCallback.setResultCode(-3),this._invokeCompleteCallback.getSend()(e)}},V.prototype.getInvokeBlockingFlag=function(){return this._methodObject.getBlockingFlag()},V.prototype._createEventHandlerProxyObject=function(e){return new O(e.getRequesterWindow(),e.getRequesterUrl(),e.getActionName(),e.getConversationId(),e.getCorrelationId(),1)},V);function V(e,t,n,r,o,i){this._callerId="",this._methodObject=e,this._param=t,this._invokeCompleteCallback=n,this._eventHandlerProxyList=r,this._conversationId=o,this._eventName=i}}(OSF=OSF||{}),function(){function t(e,t){return t+="_Resource",void 0!==oteljs?[oteljs.makeDoubleDataField(t+"_responseEnd",e.responseEnd),oteljs.makeDoubleDataField(t+"_responseStart",e.responseStart),oteljs.makeDoubleDataField(t+"_startTime",e.startTime),oteljs.makeDoubleDataField(t+"_transferSize",e.transferSize)]:[]}(OSFPerfUtil||(OSFPerfUtil={})).sendPerformanceTelemetry=function(){if(OSF.AppTelemetry.enableTelemetry&&"undefined"!=typeof performance&&performance.getEntriesByType){var n,r,o=OSF.LoadScriptHelper.getHostBundleJsName().toLowerCase();performance.getEntriesByType("resource").forEach(function(e){var t=e.name.toLowerCase();OSF.Utility.stringEndsWith(t,o)?n=e:(OSF.Utility.stringEndsWith(t,OSF.ConstantNames.OfficeDebugJS)||OSF.Utility.stringEndsWith(t,OSF.ConstantNames.OfficeJS))&&(r=e)}),OTel.OTelLogger.onTelemetryLoaded(function(){var e=[];n&&(e=e.concat(t(n,"HostJs"))),r&&(e=e.concat(t(r,"OfficeJs"))),e=e.concat([oteljs.makeDoubleDataField("officeExecuteStartDate",OSFPerformance.officeExecuteStartDate),oteljs.makeDoubleDataField("officeExecuteStart",OSFPerformance.officeExecuteStart),oteljs.makeDoubleDataField("officeExecuteEnd",OSFPerformance.officeExecuteEnd),oteljs.makeDoubleDataField("hostInitializationStart",OSFPerformance.hostInitializationStart),oteljs.makeDoubleDataField("hostInitializationEnd",OSFPerformance.hostInitializationEnd),oteljs.makeDoubleDataField("totalJSHeapSize",OSFPerformance.totalJSHeapSize),oteljs.makeDoubleDataField("usedJSHeapSize",OSFPerformance.usedJSHeapSize),oteljs.makeDoubleDataField("jsHeapSizeLimit",OSFPerformance.jsHeapSizeLimit),oteljs.makeDoubleDataField("getAppContextStart",OSFPerformance.getAppContextStart),oteljs.makeDoubleDataField("getAppContextEnd",OSFPerformance.getAppContextEnd),oteljs.makeDoubleDataField("getAppContextXdmStart",OSFPerformance.getAppContextXdmStart),oteljs.makeDoubleDataField("getAppContextXdmEnd",OSFPerformance.getAppContextXdmEnd),oteljs.makeDoubleDataField("createOMEnd",OSFPerformance.createOMEnd),oteljs.makeDoubleDataField("officeOnReady",OSFPerformance.officeOnReady),oteljs.makeBooleanDataField("isSharedRuntime",0!=(OSF._OfficeAppFactory.getHostInfo().flags&OSF.HostInfoFlags.SharedApp))]),Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.JSPerformanceTelemetryV06",dataFields:e,eventFlags:{dataCategories:2,diagnosticLevel:110}})})}}}(),function(e){var t,n,r,o,i,l;t=e.OUtil||(e.OUtil={}),l={},o=t.Guid||(t.Guid={}),i=["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"],o.generateNewGuid=function(){for(var e="",t=(new Date).getTime(),n=0;n<32&&0<t;n++)8!=n&&12!=n&&16!=n&&20!=n||(e+="-"),e+=i[t%16],t=Math.floor(t/16);for(;n<32;n++)8!=n&&12!=n&&16!=n&&20!=n||(e+="-"),e+=i[Math.floor(16*Math.random())];return e},t.loadScript=function(n,e,t,r){if(n&&e){var o=window.document,i=l[n];if(i)i.loaded?e(!0):i.pendingCallbacks.push(e);else{var a=o.createElement("script");a.type="text/javascript",i={loaded:!1,pendingCallbacks:[e],timer:null},l[n]=i;function s(){null!=i.timer&&(clearTimeout(i.timer),delete i.timer),i.loaded=!0;for(var e=i.pendingCallbacks.length,t=0;t<e;t++){i.pendingCallbacks.shift()(!0)}}function c(){delete l[n],null!=i.timer&&(clearTimeout(i.timer),delete i.timer);for(var e=i.pendingCallbacks.length,t=0;t<e;t++){i.pendingCallbacks.shift()(!1)}}a.readyState?a.onreadystatechange=function(){"loaded"!=a.readyState&&"complete"!=a.readyState||(a.onreadystatechange=null,s())}:a.onload=s,a.onerror=c,r=r||3e4,i.timer=setTimeout(c,r),a.setAttribute("crossOrigin","anonymous"),a.src=t?t.createScriptURL(n):n,o.getElementsByTagName("head")[0].appendChild(a)}}},t.getSessionStorage=function(){if(!n){try{var t=window.sessionStorage}catch(e){t=null}n=new e.SafeStorage(t)}return n},t.getLocalStorage=function(){if(!r){try{var t=window.localStorage}catch(e){t=null}r=new e.SafeStorage(t)}return r},t.waitForFunction=function(e,t,n,r){var o,i=n,a=function(){i--,e()?t(!0):0<i?(o=window.setTimeout(a,r),i--):(window.clearTimeout(o),t(!1))};a()}}(OSF=OSF||{}),function(v){v.Flights=[],v.DisabledChangeGates=[];v.FlightTreatmentNames={EnableMsal3SsoApi:"Microsoft.Office.SharedOnline.EnableMsal3SsoApi"},function(p){var a="&_flights=",s="&_disabledChangeGates=",c="_flights=",l="_disabledChangeGates=",f="&";function o(e,t){return e.substr(0,t.length)===t}function u(e,t,n,r){return o(e,t+"//"+n+":"+r)||o(e,n+":"+r)}p.isArray=function(e){return"[object Array]"===Object.prototype.toString.apply(e)},p.isFunction=function(e){return"[object Function]"===Object.prototype.toString.apply(e)},p.isDate=function(e){return"[object Date]"===Object.prototype.toString.apply(e)},p.addEventListener=function(e,t,n){if(e.addEventListener)e.addEventListener(t,n,!1);else{if(!e.attachEvent)throw new Error("Cannot attach event");e.attachEvent("on"+t,n)}},p.removeEventListener=function(e,t,n){if(e.removeEventListener)e.removeEventListener(t,n,!1);else{if(!e.detachEvent)throw new Error("Cannot remove event");e.detachEvent("on"+t,n)}};function d(e){var t=[];try{t=JSON.parse(e)}catch(e){}return Array.isArray(t)||(t=[]),t}function h(e,t,n){try{var r=JSON.parse(t),o=null!=r?r[n]:null,i=p.getSessionStorage();if(!e&&i&&null!=r){var a=r.baseFrameName+n;o?i.setItem(a,o):o=i.getItem(a)}return o}catch(e){return null}}function g(e,t,n,r,o){var i=o.split(e),a=1<i.length?i[i.length-1]:null;n&&null!=a&&(0<=a.indexOf(f)&&(a=a.split(f)[0]),a=decodeURIComponent(a));var s=p.getSessionStorage();if(!r&&s){var c=window.name.indexOf(t);if(-1<c){var l=window.name.indexOf(";",c);-1==l&&(l=window.name.length);var u=window.name.substring(c,l);a?s.setItem(u,a):a=s.getItem(u)}}return a}function n(e,t){for(var n=0;n<e.length;n++)if(e.charAt(n)===t){if(n+1>=e.length)return this.removeChar(e,n);if("/"===t){if("?"===e.charAt(n+1)||"#"===e.charAt(n+1))return this.removeChar(e,n)}else if("?"===t&&"#"===e.charAt(n+1))return this.removeChar(e,n)}return e}function m(e){if(e=n(e,"/"),e=n(e,"?"),"https://"==(e=n(e,"#")).substr(0,8))-1!=(t=e.indexOf(":443"))&&(t!=e.length-4&&"/"!=e.charAt(t+4)&&"?"!=e.charAt(t+4)&&"#"!=e.charAt(t+4)||(e=e.substring(0,t)+e.substring(t+4)));else if("http://"==e.substr(0,7)){var t;-1!=(t=e.indexOf(":80"))&&(t!=e.length-3&&"/"!=e.charAt(t+3)&&"?"!=e.charAt(t+3)&&"#"!=e.charAt(t+3)||(e=e.substring(0,t)+e.substring(t+3)))}return e}function y(e){var t,n,r=[],o=[],i=e.length;for(t=0;t<i;t++)(n=e[t]).tabIndex?0<n.tabIndex?o.push(n):0===n.tabIndex&&r.push(n):r.push(n);return o=o.sort(function(e,t){var n=e.tabIndex-t.tabIndex;return 0===n&&(n=o.indexOf(e)-o.indexOf(t)),n}),[].concat(o,r)}p.serializeSettings=function(e){var t={};for(var n in e){var r=e[n];try{r=JSON.stringify(r,function(e,t){return v.OUtil.isDate(this[e])?"Date("+this[e].getTime()+")":t}),t[n]=r}catch(e){}}return t},p.deserializeSettings=function(e){var t={};for(var n in e=e||{}){var r=e[n];try{r=JSON.parse(r,function(e,t){var n;return"string"==typeof t&&t&&6<t.length&&"Date("===t.slice(0,5)&&")"===t.slice(-1)&&(n=new Date(parseInt(t.slice(5,-1))))?n:t}),t[n]=r}catch(e){}}return t},p.convertIntToCssHexColor=function(e){return"#"+(Number(e)+16777216).toString(16).slice(-6)},p.parseAppContextFromWindowName=function(e,t){return p.parseInfoFromWindowName(e,t,"appContext")},p.parseHostInfoFromWindowName=function(e,t){return v.OUtil.parseInfoFromWindowName(e,t,"hostInfo")},p.parseXdmInfo=function(e){var t=p.parseXdmInfoWithGivenFragment(e,window.location.hash);return t=t||p.parseXdmInfoFromWindowName(e,window.name)},p.parseXdmInfoFromWindowName=function(e,t){return v.OUtil.parseInfoFromWindowName(e,t,"xdmInfo")},p.parseXdmInfoWithGivenFragment=function(e,t){return v.OUtil.parseInfoWithGivenFragment("&_xdm_Info=","_xdm_",!1,e,t)},p.parseFlights=function(e){var t,n,r,o,i=(t=e,n=window.location.hash,d(g(a,c,!0,t,n)));return 0==i.length&&(r=e,o=window.name,i=d(h(r,o,"flights"))),i},p.parseDisabledChangeGates=function(e){var t,n,r,o,i=(t=e,n=window.location.hash,d(g(s,l,!0,t,n)));return 0==i.length&&(r=e,o=window.name,i=d(h(r,o,"disabledChangeGates"))),i},p.checkFlight=function(e){return v.Flights&&0<=v.Flights.indexOf(e)},p.isChangeGateEnabled=function(e){return!v.DisabledChangeGates||-1===v.DisabledChangeGates.indexOf(e)},p.parseInfoFromWindowName=h,p.parseInfoWithGivenFragment=g,p.getConversationId=function(){var e=window.location.search,t=null;if(e){var n=e.indexOf("&");(t=0<n?e.substring(1,n):e.substr(1))&&"="===t.charAt(t.length-1)&&(t=(t=t.substring(0,t.length-1))&&decodeURIComponent(t))}return t},p.getInfoItems=function(e){var t=e.split("$");return void 0===t[1]&&(t=e.split("|")),void 0===t[1]&&(t=e.split("%7C")),t},p.getXdmFieldValue=function(e,t){var n="",r=v.OUtil.parseXdmInfo(t);if(r){var o=v.OUtil.getInfoItems(r);if(null!=o&&3<=o.length)switch(e){case"ConversationUrl":n=o[2];break;case"AppId":n=o[1]}}return n},p.parseUrl=function(e,t){if(void 0===t&&(t=!1),void 0!==e&&e){var n,r,o="NotHttps",i="undefined"!=typeof window&&void 0!==window.navigator&&0<window.navigator.userAgent.indexOf("Trident"),a=("undefined"!=typeof window&&void 0!==window.navigator&&window.navigator.userAgent.indexOf("Edge"),{protocol:void 0,hostname:void 0,host:void 0,port:void 0,pathname:void 0,search:void 0,hash:void 0,isPortPartOfUrl:void 0});try{if(i){var s=document.createElement("a");if(s.href=e,!(s&&s.protocol&&s.host&&s.hostname&&s.href&&m(s.href).toLowerCase()===m(e).toLowerCase()))throw"InvalidUrl";if(v.OUtil.checkFlight(2)&&t&&"https:"!=s.protocol)throw new Error(o);var c=(r=s,(n=e)&&r?"https:"==r.protocol&&u(n,"https:",r.hostname,"443")?":443":"http:"==r.protocol&&u(n,"http:",r.hostname,"80")?":80":"":"");a.protocol=s.protocol,a.hostname=s.hostname,a.port=c?"":s.port,a.host=c?s.hostname:s.host,a.pathname=(i?"/":"")+s.pathname,a.search=s.search,a.hash=s.hash,a.isPortPartOfUrl=u(e,s.protocol,s.hostname,s.port)}else{var l=new URL(e);if(l&&l.protocol&&l.host&&l.hostname){if(v.OUtil.checkFlight(2)&&t&&"https:"!=l.protocol)throw new Error(o);a.protocol=l.protocol,a.hostname=l.hostname,a.port=l.port,a.host=l.host,a.pathname=l.pathname,a.search=l.search,a.hash=l.hash,a.isPortPartOfUrl=l.host.lastIndexOf(":"+l.port)==l.host.length-l.port.length-1}}}catch(e){if(e.message===o)throw e}return a}},p.focusToFirstTabbable=function(e,t){function n(e){c=!0}var r,o,i,a,s,c=!1;if(e=y(e),r=t?e.length-1:0,0===e.length)return null;for(;!c&&0<=r&&r<e.length;)o=e[r],window.focus(),o.addEventListener("focus",n),o.focus(),o.removeEventListener("focus",n),i=e.length,s=t,r=(a=r)<0||i<a||0===a&&s||a===i-1&&!s?-1:s?a-1:a+1,c||o!==document.activeElement||(c=!0);return c?o:null},p.focusToNextTabbable=function(e,t,n){function r(e){c=!0}function o(e,t,n){return!(t<0||e<t)&&(0!==t||!n)&&(t!==e-1||n)?n?t-1:t+1:-1}var i,a,s,c=!1;if(i=function(e,t){for(var n=0;n<e.length;n++)if(e[n]===t)return n;return-1}(e=y(e),t),(a=o(e.length,i,n))<0)return null;for(;!c&&0<=a&&a<e.length;)(s=e[a]).addEventListener("focus",r),s.focus(),s.removeEventListener("focus",r),a=o(e.length,a,n),c||s!==document.activeElement||(c=!0);return c?s:null},p.defineMethodOnNamespace=function(e,t,n){e[t]=n},p.isDialog=function(){return v._OfficeAppFactory.getHostInfo().isDialog},p.isPopupWindow=function(){return v.OUtil.isDialog()&&v._OfficeAppFactory.getHostInfo().hostPlatform==v.HostInfoPlatform.web&&null!=window.opener},p.getHostPlatform=function(){return v._OfficeAppFactory.getHostInfo().hostPlatform},p.getCustomOfficeInitializationSettings=function(){return"object"==typeof officeInitializationSettings?officeInitializationSettings:{}};var t=0;p.getLibraryReleaseVehicle=function(){return t},p.setLibraryReleaseVehicle=function(e){t=e}}(v.OUtil||(v.OUtil={}))}(OSF=OSF||{}),function(e){var t;(t=e.ParameterNames||(e.ParameterNames={})).Callback="callback",t.AsyncContext="asyncContext",t.Data="data",t.MessageToParent="messageToParent",t.MessageContent="messageContent",t.MessageOrigin="messageOrigin",t.TargetOrigin="targetOrigin",t.AppCommandInvocationCompletedData="appCommandInvocationCompletedData"}(OSF=OSF||{}),function(h){!function(e){function t(){}e.RequirementVersion=t;var c=(n.prototype.isSetSupported=function(e,t){if(null==e)return!1;null==t&&(t=0);var n=this._setMap._sets;if(n.hasOwnProperty(e.toLowerCase())){var r=n[e.toLowerCase()];try{var o=this._getVersion(r+"");t+="";var i=this._getVersion(t);if(0<o.major&&o.major>i.major)return!0;if(0<o.major&&0<=o.minor&&o.major==i.major&&o.minor>=i.minor)return!0}catch(e){return!1}}return!1},n.prototype._getVersion=function(e){var t=(e+="").split("."),n=0,r=0;if(t.length<2&&isNaN(Number(e)))throw"version format incorrect";if(n=Number(t[0]),2<=t.length&&(r=Number(t[1])),isNaN(n)||isNaN(r))throw"version format incorrect";return{minor:r,major:n}},n);function n(e){this._setMap=e}e.RequirementMatrix=c;var l=(r.prototype._addSetMap=function(e){for(var t in e)this._sets[t]=e[t]},r);function r(e){this._sets=e}e.DefaultSetRequirement=l;var o,u=(__extends(i,o=l),i);function i(){return o.call(this,{dialogapi:1.1})||this}e.DefaultRequiredDialogSetRequirement=u;var a,p=(__extends(s,a=l),s);function s(){return a.call(this,{dialogorigin:1.1})||this}e.DefaultOptionalDialogSetRequirement=p;var f=(d.getDefaultRequirementMatrix=function(e){var t=void 0,n=e.get_requirementMatrix();if(null!=n&&0<n.length){var r=JSON.parse(e.get_requirementMatrix().toLowerCase());if(h._OfficeAppFactory.getHostInfo().hostPlatform==h.HostInfoPlatform.web)try{var o="dialogorigin";r.hasOwnProperty(o)||(r[o]=1.1)}catch(e){}t=new c(new l(r))}else t=new c(new l({}));return t},d.getDefaultDialogRequirementMatrix=function(e){var t=void 0,n=e.get_dialogRequirementMatrix();if(null!=n&&0<n.length){var r=JSON.parse(e.get_requirementMatrix().toLowerCase());t=new l(r)}else{t=new u;var o=e.get_requirementMatrix();if(null!=o&&0<o.length&&"undefined"!=typeof JSON){for(var i in r=JSON.parse(o.toLowerCase()),t._sets)r.hasOwnProperty(i)&&(t._sets[i]=r[i]);var a=new p;for(var i in a._sets)r.hasOwnProperty(i)&&(t._sets[i]=r[i])}}if(h._OfficeAppFactory.getHostInfo().hostPlatform==h.HostInfoPlatform.web)try{var s="dialogorigin";!t._sets.hasOwnProperty(s)&&window.opener&&(t._sets[s]=1.1)}catch(e){}return new c(t)},d);function d(){}e.RequirementsMatrixFactory=f}(h.Requirement||(h.Requirement={}))}(OSF=OSF||{}),function(r){var e,t,n;e=r.DDA||(r.DDA={}),(t=e.RichApi||(e.RichApi={})).executeRichApiRequestAsync=function(e,t){var n={toSafeArrayHost:function(){return[e]},fromSafeArrayHost:function(e){return{data:e}},toWebHost:function(){return{ArrayData:e}},fromWebHost:function(e){return{data:e.Data}}};r._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(93,n,t)},Object.defineProperty(t,"richApiMessageManager",{get:function(){return n=n||new r.RichApiMessageManager}})}(OSF=OSF||{}),function(o){var e=(n.transferEventArgument=function(e){var t=[];if(e)for(var n=0;n<e.length;n++){var r=e[n];r.toArray&&(r=r.toArray()),t.push({messageCategory:r[0],messageType:r[1],targetId:r[2],message:r[3],id:r[4],isRemoteOverride:r[5]})}return{type:o.EventType.RichApiMessage,entries:t}},n.prototype.addHandlerAsync=function(e,t,n){o.EventHelper.addEventHandler(e,t,n,this._eventDispatch)},n.prototype.removeHandlerAsync=function(e,t,n){o.EventHelper.removeEventHandler(e,t,n,this._eventDispatch)},n.prototype.register=function(e){var r=this;return this._registerPromise||(this._registerPromise=new Office.Promise(function(t,n){r.addHandlerAsync(o.EventType.RichApiMessage,function(t){r._registerHandlers.forEach(function(e){e&&e(t)})},function(e){"failed"==e.status?n(e.error):t()})})),this._registerPromise.then(function(){r._registerHandlers.push(e)})},n);function n(){this._registerHandlers=[],this._eventDispatch=new o.EventDispatch([{type:o.EventType.RichApiMessage,id:o.EventDispId.dispidRichApiMessageEvent,getTargetId:function(){return""},fromSafeArrayHost:function(e){return n.transferEventArgument(e)},fromWebHost:function(e){var t=e.ArrayData;return n.transferEventArgument(t)}}])}o.RichApiMessageManager=e}(OSF=OSF||{}),function(n){var e=(t.prototype.execute=function(e,t,n){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.Execute(e,t,n,OsfOMToken):window.external.Execute(e,t,n)},t.prototype.registerEvent=function(e,t,n,r,o){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.RegisterEvent(e,n,r,o,OsfOMToken):window.external.RegisterEvent(e,n,r,o)},t.prototype.unregisterEvent=function(e,t,n,r){"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.UnregisterEvent(e,n,r,OsfOMToken):window.external.UnregisterEvent(e,n,r)},t.prototype.closeSdxDialog=function(e){throw n.Utility.createNotImplementedException()},t.prototype.resizeSdxDialog=function(e,t){throw n.Utility.createNotImplementedException()},t);function t(){}n.RichClientHostController=e}(OSF=OSF||{}),function(M){var t,e=(t=M.InitializationHelper,__extends(n,t),n.prototype.getOsfControlContext=function(){if(!this._osfControlContext){var t="Warning: Office.js is loaded outside of Office client";try{if(!window.external)return console.error("There is no window.external."),M.Utility.trace(t),null;this._osfControlContext=window.external.GetContext()}catch(e){return console.error("Error when call window.external.GetContext() :"+JSON.stringify(e)),M.Utility.trace(t),null}}return this._osfControlContext},n.prototype.getAppContext=function(e,t,n){var r=this,o=this.getOsfControlContext();if(o){var i,a,s,c,l,u,p,f,d,h,g,m,y,v,b,_,O,S,C,A,P,E,T,w,I,x,D=0,F=!1;if((R=M.Utility.externalNativeFunctionExists)(typeof o.GetContextDataInJson)&&"undefined"!=typeof OsfOMToken&&OsfOMToken?((I=o.GetContextDataInJson(OsfOMToken))&&(x=JSON.parse(I)),x?(i=x.appType,a=x.solutionRef,s=x.versionMajor,c=x.versionMinor,l=x.uiLocale,u=x.dataLocale,p=x.docUrl,f=x.clientMode,d=x.activationMode,g=x.controlType,m=x.eToken,y=x.correlationId,v=x.appInstanceId,b=x.touchEnabled,_=o.commerceAllowed,O=x.requirementMatrix,C=x.hostFullVersion,A=x.requirementMatrix,(N=x.featureGates)&&(P=JSON.parse(N)),D=x.initialDisplayMode,E=function(){var e,t=x.settings;t&&(e=JSON.parse(t));var n={};if(e)for(var r=e.names,o=e.values,i=0;i<r.length;i++)n[r[i]]=o[i];return n},T=function(){var e=x.themeInfo;return r.getOfficeThemeFromInfoString(e)}):F=!0):F=!0,F){i=o.GetAppType(),a=o.GetSolutionRef(),s=o.GetAppVersionMajor(),c=o.GetAppVersionMinor(),l=o.GetAppUILocale(),u=o.GetAppDataLocale(),p=o.GetDocUrl(),f=o.GetAppCapabilities(),d=o.GetActivationMode(),g=o.GetControlIntegrationLevel();try{m=o.GetSolutionToken()}catch(e){}var R;if((R=M.Utility.externalNativeFunctionExists)(typeof o.GetCorrelationId)&&(y=o.GetCorrelationId()),R(typeof o.GetInstanceId)&&(v=o.GetInstanceId()),R(typeof o.GetTouchEnabled)&&(b=o.GetTouchEnabled()),R(typeof o.GetCommerceAllowed)&&(_=o.GetCommerceAllowed()),R(typeof o.GetSupportedMatrix)&&(O=o.GetSupportedMatrix()),R(typeof o.GetHostCustomMessage)&&(S=o.GetHostCustomMessage()),R(typeof o.GetHostFullVersion)&&(C=o.GetHostFullVersion()),R(typeof o.GetDialogRequirementMatrix)&&(A=o.GetDialogRequirementMatrix()),R(typeof o.GetFeaturesForSolution))try{var N;(N=o.GetFeaturesForSolution())&&(P=JSON.parse(N))}catch(e){M.Utility.trace("Exception while creating the SDX FeatureGates object. Details: "+e)}R(typeof o.GetInitialDisplayMode)&&(D=o.GetInitialDisplayMode()),E=function(){return r.getSerializedSettings()},T=function(){return r.getOfficeTheme()},w=function(){return r.getSerializedHostSettings()}}h=2===d?Office.InitializationReason.DocumentOpened:Office.InitializationReason.Inserted,m=m?m.toString():"",t(new M.OfficeAppContext(a,i,s,l,u,p,f,E,h,g,m,y,v,b,_,c,O,S,C,void 0,void 0,void 0,void 0,A,P,T,D,void 0,void 0,w,!1,void 0,void 0))}else n(new Error("The Office.js is loaded outside of Office client"))},n.prototype.createClientHostController=function(){if(!this._clientHostController){if(this._hostInfo.hostPlatform!==M.HostInfoPlatform.win32)throw M.Utility.createNotImplementedException();this._clientHostController=new M.Win32RichClientHostController}return this._clientHostController},n.prototype.createAsyncMethodExecutor=function(){return new M.SafeArrayAsyncMethodExecutor(this._clientHostController)},n.prototype.createClientSettingsManager=function(){return new M.RichClientSettingsManager(this.getOsfControlContext())},n.prototype.getSerializedSettings=function(){var e=this.getOsfControlContext(),t=[],n=[];"undefined"!=typeof OsfOMToken&&OsfOMToken?e.GetSettings(OsfOMToken).Read(t,n):e.GetSettings().Read(t,n);for(var r={},o=0;o<t.length;o++)r[t[o]]=n[o];return r},n.prototype.getOfficeTheme=function(){var e=this.getOsfControlContext();if(e){if(!(this.officeTheme&&this.officeThemeTimeStamp&&(new Date).getTime()-this.officeThemeTimeStamp<n.officeThemeCacheValidPeriod)){var t=e.GetOfficeThemeInfo();this.officeTheme=this.getOfficeThemeFromInfoString(t),this.officeThemeTimeStamp=(new Date).getTime()}return this.officeTheme}},n.prototype.getOfficeThemeFromInfoString=function(e){var t=null;if(e)try{t=JSON.parse(e)}catch(e){M.AppTelemetry&&M.AppTelemetry.logAppException("Exception while parsing officeThemeInfo. Details: "+e)}var n={};if(t){var r={bodyBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},bodyForegroundColor:{name:"bodyForegroundColor",convertToHex:!0},controlBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0},controlForegroundColor:{name:"controlForegroundColor",convertToHex:!0},primaryFontColor:{name:"bodyForegroundColor",convertToHex:!0},primaryBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},secondaryFontColor:{name:"controlForegroundColor",convertToHex:!0},secondaryBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0}};for(var o in t){var i=!1,a=o;r[o]&&(a=r[o].name,i=r[o].convertToHex),n[a]=i?M.OUtil.convertIntToCssHexColor(t[o]):t[o]}}return n},n.prototype.getSerializedHostSettings=function(){var e=this.getOsfControlContext(),t=[],n=[];"function"==typeof e.GetSettings().ReadHost&&("undefined"!=typeof OsfOMToken&&OsfOMToken?e.GetSettings(OsfOMToken).ReadHost(t,n):e.GetSettings().ReadHost(t,n));for(var r={},o=0;o<t.length;o++)r[t[o]]=n[o];return r},n.officeThemeCacheValidPeriod=5e3,n);function n(){var e=null!==t&&t.apply(this,arguments)||this;return e.officeThemeTimeStamp=null,e.officeTheme=null,e}M.RichClientInitializationHelper=e}(OSF=OSF||{}),function(e){var t=(n.prototype.read=function(o){var i,e=this._osfClientContext;function t(){var e=[],t=[];i.Read(e,t);for(var n={},r=0;r<e.length;r++)n[e[r]]=t[r];o&&o(0,n)}(i="undefined"!=typeof OsfOMToken&&OsfOMToken?e.GetSettings(OsfOMToken):e.GetSettings()).RefreshAsync?i.RefreshAsync(function(){t()}):t()},n.prototype.write=function(e,t){var n=[],r=[];for(var o in e)n.push(o),r.push(e[o]);var i,a=this._osfClientContext;void 0!==(i="undefined"!=typeof OsfOMToken&&OsfOMToken?a.GetSettings(OsfOMToken):a.GetSettings()).WriteAsync?i.WriteAsync(n,r,t):(i.Write(n,r),t(0))},n);function n(e){this._osfClientContext=e}e.RichClientSettingsManager=t}(OSF=OSF||{}),function(l){var n,e=(n=l.AsyncMethodExecutor,__extends(t,n),t.prototype.executeAsync=function(r,o,i,a){var s=this;try{var c=new Array;this._clientHostController.execute(r,o.toSafeArrayHost(),function(e,t){var n=l.Utility.fromSafeArray(e);return s._asyncMethodExecutorHelper.handleSafeArrayHostResponse(n,t,c,i,o,r,a)})}catch(e){this.onException(e,r,i)}},t.prototype.registerEventAsync=function(r,e,t,o,i,a,s){var c=this;try{this._clientHostController.registerEvent(r,e,t,function(e,t){var n=l.Utility.fromSafeArray(t),r=i.fromSafeArrayHost(n);o(r)},function(e){var t,n=l.Utility.fromSafeArray(e);return t="number"==typeof n?n:n[0],c.invokeCallback(r,a,t,null,s),!0})}catch(e){this.onException(e,r,a)}},t.prototype.unregisterEventAsync=function(o,e,t,i,a){var s=this;try{this._clientHostController.unregisterEvent(o,e,t,function(e,t){var n,r=l.Utility.fromSafeArray(e);return n="number"==typeof r?r:r[0],s.invokeCallback(o,i,n,null,a),!0})}catch(e){this.onException(e,o,i)}},t.prototype.onException=function(e,t,n){var r,o=e.number;if(o)switch(o){case-2146828218:r=7e3;break;case-2147467259:r=t==l.EventDispId.dispidDialogMessageReceivedEvent?12007:5001;break;case-2146828283:case-2147209089:r=5010;break;case-2147208704:r=5100;break;case-2146827850:default:r=5001}n&&this.invokeCallback(t,n,r||5001,null)},t);function t(e){var t=n.call(this)||this;return t._clientHostController=e,t._asyncMethodExecutorHelper=l.BootStrapExtension.createAsyncMethodExecutorHelper(t),t}l.SafeArrayAsyncMethodExecutor=e}(OSF=OSF||{}),function(e){var t=(n.prototype.getItem=function(e){try{return this._internalStorage&&this._internalStorage.getItem(e)}catch(e){return null}},n.prototype.setItem=function(e,t){try{this._internalStorage&&this._internalStorage.setItem(e,t)}catch(e){}},n.prototype.clear=function(){try{this._internalStorage&&this._internalStorage.clear()}catch(e){}},n.prototype.removeItem=function(e){try{this._internalStorage&&this._internalStorage.removeItem(e)}catch(e){}},n.prototype.getKeysWithPrefix=function(e){var t=[];try{for(var n=this._internalStorage&&this._internalStorage.length||0,r=0;r<n;r++){var o=this._internalStorage.key(r);0===o.indexOf(e)&&t.push(o)}}catch(e){}return t},n);function n(e){this._internalStorage=e}e.SafeStorage=t}(OSF=OSF||{}),function(i){var e=(t.prototype.cacheSessionSettings=function(e){var t=OSF.OUtil.getSessionStorage();if(t){var n=OSF.OUtil.serializeSettings(e),r=JSON.stringify(n);t.setItem(OSF._OfficeAppFactory.getCachedSessionSettingsKey(),r)}},t.prototype.get=function(e){var t=this._settings[e];return void 0===t?null:t},t.prototype.set=function(e,t){this._settings[e]=t,this.cacheSessionSettings(this._settings)},t.prototype.remove=function(e){delete this._settings[e],this.cacheSessionSettings(this._settings)},t.prototype.saveAsync=function(n){var e=this._clientSettingsManager,t=OSF.OUtil.serializeSettings(this._settings);e.write(t,function(e){var t=OSF.Utility.asyncResultFromErrorCode(e);n&&n(t)})},t.prototype.refreshAsync=function(r){var o=this;this._clientSettingsManager.read(function(e,t){var n=OSF.Utility.asyncResultFromErrorCode(e);n.status===i.AsyncResultStatus.Succeeded&&(o._settings=OSF.OUtil.deserializeSettings(t),n.value=o),r&&r(n)})},t.prototype.addHandlerAsync=function(e,t,n){OSF.EventHelper.addEventHandler(e,t,n,this._eventDispatch)},t.prototype.removeHandlerAsync=function(e,t,n){OSF.EventHelper.removeEventHandler(e,t,n,this._eventDispatch)},t.prototype.toJSON=function(){return this._settings},t);function t(e,t){var n=this;this._clientSettingsManager=t,e=e||{},this._settings=e,this._eventDispatch=new OSF.EventDispatch([{id:OSF.EventDispId.dispidSettingsChangedEvent,type:OSF.EventType.SettingsChanged,getTargetId:function(){return""},fromSafeArrayHost:function(e){return{type:OSF.EventType.SettingsChanged,settings:n}},fromWebHost:function(e){return{type:OSF.EventType.SettingsChanged,settings:n}}}])}i.Settings=e}(Office=Office||{});var OSFWebkit,OTel,Microsoft,__awaiter=this&&this.__awaiter||function(i,a,s,c){return new(s=s||Promise)(function(e,t){function n(e){try{o(c.next(e))}catch(e){t(e)}}function r(e){try{o(c.throw(e))}catch(e){t(e)}}function o(t){t.done?e(t.value):new s(function(e){e(t.value)}).then(n,r)}o((c=c.apply(i,a||[])).next())})},__generator=this&&this.__generator||function(n,r){var o,i,a,e,s={label:0,sent:function(){if(1&a[0])throw a[1];return a[1]},trys:[],ops:[]};return e={next:t(0),throw:t(1),return:t(2)},"function"==typeof Symbol&&(e[Symbol.iterator]=function(){return this}),e;function t(t){return function(e){return function(t){if(o)throw new TypeError("Generator is already executing.");for(;s;)try{if(o=1,i&&(a=2&t[0]?i.return:t[0]?i.throw||((a=i.return)&&a.call(i),0):i.next)&&!(a=a.call(i,t[1])).done)return a;switch(i=0,a&&(t=[2&t[0],a.value]),t[0]){case 0:case 1:a=t;break;case 4:return s.label++,{value:t[1],done:!1};case 5:s.label++,i=t[1],t=[0];continue;case 7:t=s.ops.pop(),s.trys.pop();continue;default:if(!(a=0<(a=s.trys).length&&a[a.length-1])&&(6===t[0]||2===t[0])){s=0;continue}if(3===t[0]&&(!a||t[1]>a[0]&&t[1]<a[3])){s.label=t[1];break}if(6===t[0]&&s.label<a[1]){s.label=a[1],a=t;break}if(a&&s.label<a[2]){s.label=a[2],s.ops.push(t);break}a[2]&&s.ops.pop(),s.trys.pop();continue}t=r.call(n,s)}catch(e){t=[6,e],i=0}finally{o=a=0}if(5&t[0])throw t[1];return{value:t[0]?t[1]:void 0,done:!0}}([t,e])}}};!function(c){var e=(t.isSovereignVersion=function(){return"undefined"!=typeof isOsfSovereignVersion&&!0===isOsfSovereignVersion},t.prototype.getEnvironmentName=function(){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(t=e.sent())&&t.envName?t.envName:null]}})})},t.prototype.getEnvironmentType=function(){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(t=e.sent())&&t.envType?t.envType:null]}})})},t.prototype.getTrustedHostOrigins=function(){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return[4,this.getConfig()];case 1:return[2,null!=(t=e.sent())?t.trustedHostOrigins:null]}})})},t.prototype.isConfigAvailable=function(){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return[4,this.getConfig()];case 1:return[2,!!e.sent()]}})})},t.prototype.isSovereignHostTrusted=function(n){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return n?n===window.location.hostname?[2,!0]:[4,this.getTrustedHostOrigins()]:[2,!1];case 1:return(t=e.sent())&&0!=t.length?[2,new RegExp(t.join("|")).test(n)]:[2,!1]}})})},t.prototype.getConfigPath=function(){var e=c.LoadScriptHelper.getHostBundleJsBasePath();if(e){var t=(e=e.toLowerCase()).indexOf("/lib/");if(-1<t)return e.toLowerCase().substring(0,t+"/lib/".length)+"officeconfig.json"}return""},t.prototype.getConfig=function(){return this._configPromise||(this._configPromise=this.tryLoadConfig()),this._configPromise},t.prototype.tryLoadConfig=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i,a,s;return __generator(this,function(e){switch(e.label){case 0:if(!(t=this.getConfigPath()))return[3,2];if(n=c.OUtil.getLocalStorage(),r=t+"_cache",o=n.getItem(r),i=null,o){try{i=JSON.parse(o)}catch(e){}if(a=(new Date).getTime(),i&&i.config&&i.createTime<=a&&i.createTime+864e5>=a)return[2,i.config]}return[4,this.downloadConfig(t)];case 1:return(s=e.sent())?(i={createTime:(new Date).getTime(),config:s},n.setItem(r,JSON.stringify(i))):i&&(s=i.config),[2,s];case 2:return[2,null]}})})},t.prototype.downloadConfig=function(t){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return e.trys.push([0,3,,4]),[4,fetch(t)];case 1:return[4,e.sent().json()];case 2:return[2,e.sent()];case 3:return e.sent(),[3,4];case 4:return[2,null]}})})},t);function t(){}c.SovereignHelper=e}(OSF=OSF||{}),function(e){var t;function n(e){return void 0===e||null===e}(t=e.Utility||(e.Utility={})).createParameterException=function(e){return new Error("Parameter count mismatch: "+e)},t.createArgumentException=function(e){return new Error("Invalid argument "+e)},t.createNotImplementedException=function(){return new Error("Not implemented yet")},t.log=function(e){console.log(e)},t.trace=function(e){console.log(e)},t.debugLog=function(e){console.log(e)},t.getQueryStringValue=function(e){if("undefined"!=typeof window&&window.location&&window.location.search){var t=new RegExp("[?&]"+e+"=([^&]*)").exec(window.location.search);if(t)return t[1]}return null},t.isNullOrUndefined=n,t.isNullOrEmpty=function(e){return!!n(e)||0===e.length},t.isInUnittest=function(){return"boolean"==typeof g_osfUnittest&&g_osfUnittest}}(OSF=OSF||{}),function(e){var n;function t(e){return new Promise(e)}function i(e){var t=e,n=1;if(("object"==typeof e||"unknown"==typeof e)&&null!=e&&e.toArray)if(e.dimensions&&(n=e.dimensions()),2===n)t=a(e);else{var r=e.toArray();t=new Array(r.length);for(var o=0;o<r.length;o++)t[o]=i(r[o])}return t}function a(e){var t;try{var n=e.ubound(1),r=e.ubound(2);if(e=e.toArray(),1==n&&1==r)t=[e];else{t=[];for(var o=0;o<n;o++){for(var i=[],a=0;a<r;a++){var s=e[o*r+a];"{66e7831f-81b2-42e2-823c-89e872d541b3}"!=s&&i.push(s)}0<i.length&&t.push(i)}}}catch(e){}return t}e.isOfficeReactNative=function(){try{return"undefined"!=typeof OfficePlatformGlobal&&void 0!==OfficePlatformGlobal.ReactNativeReka}catch(e){return!1}},(n=e.Utility||(e.Utility={})).xdmDebugLog=function(e){n._DebugXdm&&console.log(e)},n.enableDebugXdm=function(){n._DebugXdm=!0},n.createPromiseFromResult=function(e){return Promise.resolve(e)},n.createPromise=t,n.promisify=function(e,r){return t(function(t,n){e(function(e){(0===e?t:n)()}),setTimeout(function(){n()},r)})},n.compareVersions=function(e,t){var n,r=e.split("."),o=t.split(".");for(n in r){if(parseInt(r[n])<parseInt(o[n]))return!1;if(parseInt(r[n])>parseInt(o[n]))return!0}return!1},n.getErrorCodeFromAsyncResult=function(e){return e.status===Office.AsyncResultStatus.Succeeded?0:e.error&&e.error.code?e.error.code:5001},n.externalNativeFunctionExists=function(e){return"unknown"===e||"undefined"!==e},n.stringEndsWith=function(e,t){if(n.isNullOrUndefined(e))throw n.createArgumentException("value");if(n.isNullOrUndefined(t))throw n.createArgumentException("subString");return!(t.length>e.length)&&e.substr(e.length-t.length)===t},n.fromSafeArray=function(e){var t=e;if(("object"==typeof e||"unknown"==typeof e)&&null!=e&&e.toArray){var n=e.toArray();t=new Array(n.length);for(var r=0;r<n.length;r++)t[r]=i(n[r])}return t},n.twoDVBArrayToJaggedArray=a,n.asyncResultFromErrorCode=function(e){return Array.isArray(e)&&1===e.length&&(e=e[0]),0===e?{status:Office.AsyncResultStatus.Succeeded}:{status:Office.AsyncResultStatus.Failed,error:{code:e}}},n._DebugXdm=!1}(OSF=OSF||{}),function(n){var r,e=(r=n.AsyncMethodExecutor,__extends(t,r),t.prototype.executeAsync=function(n,r,o,i){var a=this;this._clientHostController.execute(n,r.toWebHost(),function(e,t){return o&&a._asyncMethodExecutorHelper.handleWebHostResponse(t,e,o,r,n,i),!0})},t.prototype.registerEventAsync=function(n,e,t,r,o,i,a){var s=this;this._clientHostController.registerEvent(n,e,t,function(e){var t=e,n=o.fromWebHost(t);r(n)},function(e,t){return i&&s.invokeCallback(n,i,e,null,a),!0})},t.prototype.unregisterEventAsync=function(n,e,t,r,o){var i=this;this._clientHostController.unregisterEvent(n,e,t,function(e,t){return r&&i.invokeCallback(n,r,e,null,o),!0})},t);function t(e){var t=r.call(this)||this;return t._clientHostController=e,t._asyncMethodExecutorHelper=n.BootStrapExtension.createAsyncMethodExecutorHelper(t),t}n.WebAsyncMethodExecutor=e}(OSF=OSF||{}),function(u){var e;((e=u.DDA||(u.DDA={})).WebAuth||(e.WebAuth={})).getAuthContextAsync=function(e){u._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(99,{toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{}},fromWebHost:function(e){return e.authContext}},e)},function(a){var s,e;(e=s=a.AuthFlow||(a.AuthFlow={})).AuthCode="authcode",e.Broker="broker",e.Implicit="implicit",a.loadAttempts=0;var o="webauth/",i="webauth.browserauth.debug.js",c="webauth.browserauth.js",l=!1;a.load=function(){return a.config&&a.config.authFlow===s.AuthCode?(a.loadAttempts++,(l=a.config&&(!0===a.config.useMsal3||!1!==a.config.useMsal3&&u.OUtil.checkFlight(u.FlightTreatmentNames.EnableMsal3SsoApi)))&&(i="webauth.browserauth.msal3.debug.js",c="webauth.browserauth.msal3.js"),new Promise(function(t,n){function e(i,a,s){return new Promise(function(r,o){i?u.OUtil.loadScript(i,function(e){if("boolean"!=typeof e||e)if(e instanceof Event&&e)o(new Event("loadScript: "+e.type+" '"+i+"'"));else if(s&&!a())var t=0,n=setInterval(function(){t+=500,!(a()||s<t)||(clearInterval(n),a())||o(new Event("Missing expected object after loaded."))},500);else r(null);else o(new Event("loadScript: failed to load '"+i+"'"))},u.LoadScriptHelper.getTrustedTypesPolicy(),s):r(null)})}var r=[e(a.config&&a.config.authVersion?u.LoadScriptHelper.getHostBundleJsBasePath()+o+a.config.authVersion+"/"+(a.config&&a.config.debugging?i:c):u.LoadScriptHelper.getHostBundleJsBasePath()+o+(a.config&&a.config.debugging?i:c),function(){return BrowserAuth},a.config.delayWebAuth)];l||r.push(e(a.config.msal,function(){return msal},a.config.delayMsal)),Promise.all(r).then(function(){a.config?BrowserAuth.Load(a.config,u._OfficeAppFactory.getHostInfo().osfControlAppCorrelationId).then(function(e){t(e)},function(e){n(e)}):n(new Event("config is empty."))},function(e){n(e)})})):new Promise(function(e,t){return t(new Event("'authcode' as authFlow is only supported"))})},a.getToken=function(e,t,n,r,o,i){return a.config&&a.config.authFlow===s.AuthCode?l?BrowserAuth.GetToken({resource:e,scopes:t,applicationId:n,correlationId:r,popup:!!o,claims:i}):BrowserAuth.GetToken(e,n,r,!!o,!!o,!1,i):Promise.reject(new Event("'authcode' as authFlow is only supported"))}}(u.WebAuth||(u.WebAuth={}))}(OSF=OSF||{}),function(s){var e=(t.prototype.execute=function(r,e,o){var i=this,t=this._webClientHostControllerHelper.getHostCallArgs(r,e),n=this._webClientHostControllerHelper.getTargetMethodName(r);this._webAppState.clientEndPoint.invoke(n,function(e,t){var n=0;if(0==e)i._delegateVersion=t.Version,n=i._webClientHostControllerHelper.parseErrorFromPayload(r,t);else switch(e){case-5:n=7e3;break;default:n=5001}o&&o(n,t)},t)},t.prototype.registerEvent=function(e,t,n,r,o){this._webAppState.clientEndPoint.registerForEvent(this.getXdmEventName(n,t),function(e){r&&r(e)},this._getOnAfterRegisterEvent(!0,e,o),{controlId:this._webAppState.id,eventDispId:e,targetId:n,__timeout__:-1})},t.prototype.unregisterEvent=function(e,t,n,r){this._webAppState.clientEndPoint.unregisterForEvent(this.getXdmEventName(n,t),this._getOnAfterRegisterEvent(!1,e,r),{controlId:this._webAppState.id,eventDispId:e,targetId:n,__timeout__:-1})},t.prototype.messageParent=function(e){throw s.Utility.createNotImplementedException()},t.prototype.openDialog=function(e,t,n,r,o){throw s.Utility.createNotImplementedException()},t.prototype.closeDialog=function(e,t,n,r){throw s.Utility.createNotImplementedException()},t.prototype.sendMessage=function(e){throw s.Utility.createNotImplementedException()},t.prototype.closeSdxDialog=function(e){this._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[this._webAppState.id,s.AgaveHostAction.CloseSDXDialog,{InstanceId:this._webAppState.id,DialogCloseCallbackParam:e}])},t.prototype.resizeSdxDialog=function(e,t){this._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[this._webAppState.id,s.AgaveHostAction.ResizeSDXDialog,{InstanceId:this._webAppState.id,DialogWidth:e+"px",DialogHeight:t+"px"}])},t.prototype.getXdmEventName=function(e,t){return t==s.EventType.BindingSelectionChanged||t==s.EventType.BindingDataChanged||t==s.EventType.DataNodeDeleted||t==s.EventType.DataNodeInserted||t==s.EventType.DataNodeReplaced?e+"_"+t:t},t.prototype._getOnAfterRegisterEvent=function(r,o,i){var a=(new Date).getTime();return function(e,t){var n;if(0!=e)switch(e){case-5:n=7e3;break;default:n=5001}else n=t?t.Error?t.Error:0:5001;i&&i(n),s.AppTelemetry&&s.AppTelemetry.onRegisterDone(r,o,Math.abs((new Date).getTime()-a),n)}},t);function t(e){this._delegateVersion=1,this._webAppState=e,this._webClientHostControllerHelper=s.BootStrapExtension.createWebClientHostControllerHelper(this._webAppState,this._delegateVersion)}s.WebClientHostController=e}(OSF=OSF||{}),function(e){var t=(n.prototype.getHostCallArgs=function(e,t){var n=t;return(n=n||{}).DdaMethod={ControlId:this.getControlId(),DispatchId:e,Version:this._delegateVersion},n.__timeout__=-1,n},n.prototype.getTargetMethodName=function(e){return"executeMethod"},n.prototype.parseErrorFromPayload=function(e,t){return t.Error},n.prototype.getControlId=function(){return this._webAppState.id},n);function n(e,t){this._webAppState=e,this._delegateVersion=t}e.WebClientHostControllerHelper=t}(OSF=OSF||{}),function(s){var e=(t.prototype.read=function(i){s._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(75,{toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{}},fromWebHost:function(e){return e.Properties.Settings}},function(e){if(e.status===Office.AsyncResultStatus.Succeeded){for(var t={},n=0;n<e.value.length;n++){var r=e.value[n];Array.isArray(r)?t[r[0]]=r[1]:t[r.Name]=r.Value}i(0,t)}else{var o=e.error.code;i(o,{})}})},t.prototype.write=function(e,n){var t=s._OfficeAppFactory.getAsyncMethodExecutor(),r=[];for(var o in e){var i=[];i.push(o),i.push(e[o]),r.push(i)}var a={toSafeArrayHost:function(){return null},fromSafeArrayHost:function(e){return null},toWebHost:function(){return{DdaSettingsMethod:{OverwriteIfStale:!0,Properties:r}}},fromWebHost:function(e){return null}};t.executeAsync(76,a,function(e){if(e.status===Office.AsyncResultStatus.Succeeded)n(0);else{var t=e.error.code;n(t)}})},t);function t(){}s.WebClientSettingsManager=e}(OSF=OSF||{}),function(S){var i,e=(i=S.InitializationHelper,__extends(t,i),Object.defineProperty(t.prototype,"isHostOriginTrusted",{get:function(){return this._isHostOriginTrustedFunc},set:function(e){this._isHostOriginTrustedFunc=e},enumerable:!0,configurable:!0}),t.prototype.saveAndSetDialogInfo=function(e){var t,n=S.OUtil.getSessionStorage();if(n){if((e=e||S.OUtil.parseHostInfoFromWindowName(!0,S._OfficeAppFactory.getWindowName()))&&-1<e.indexOf("isDialog")){var r=(t=S.OUtil.parseXdmInfo(!0))?t.split("|")[1]:null;return null!=r&&n.setItem(r+"IsDialog","true"),void(this._hostInfo.isDialog=!0)}this._hostInfo.isDialog=null!=n.getItem(S.OUtil.getXdmFieldValue("AppId",!1)+"IsDialog")}},t.prototype.checkReceiverOriginAndRun=function(p){return __awaiter(this,void 0,void 0,function(){var a,t,s,c,l,n,r,o,i,u;return __generator(this,function(e){switch(e.label){case 0:return 3===(a=this)._webAppState.clientEndPoint.hostTrustCheckStatus?(p(),[2]):(t=S.OUtil.parseUrl(a._webAppState.clientEndPoint.targetUrl,!1),s="https:"==t.protocol,c=t.hostname,l="NotHttps",0!==a._webAppState.clientEndPoint.hostTrustCheckStatus?[3,4]:(s||(a._webAppState.clientEndPoint.hostTrustCheckStatus=2),2==a._webAppState.clientEndPoint.hostTrustCheckStatus?[3,4]:(n=!1,(r=S.SovereignHelper.isSovereignVersion())&&!0!==S.OUtil.getCustomOfficeInitializationSettings().trustAllCloudEnvironments||(n=S.XdmCommunicationManager.isHostNameValidWacDomain(c),a.isHostOriginTrusted&&(n=n||a.isHostOriginTrusted(c))),n||!r?[3,3]:(a._sovereignHelper||(a._sovereignHelper=new S.SovereignHelper),[4,(o=a._sovereignHelper).isConfigAvailable()]))));case 1:return e.sent()?[4,o.isSovereignHostTrusted(c)]:[2];case 2:n=e.sent(),e.label=3;case 3:n&&(a._webAppState.clientEndPoint.hostTrustCheckStatus=3),e.label=4;case 4:if(a._webAppState.clientEndPoint.checkStatusLogged||null==a._hostInfo||void 0===a._hostInfo||(S.AppTelemetry.onCheckWACHost(a._webAppState.clientEndPoint.hostTrustCheckStatus,a._webAppState.id,a._hostInfo.hostType,a._hostInfo.hostPlatform,a._webAppState.clientEndPoint.targetUrl),a._webAppState.clientEndPoint.checkStatusLogged=!0),3===a._webAppState.clientEndPoint.hostTrustCheckStatus||S.LoadScriptHelper.disableHostCheck())p();else{if(S.LoadScriptHelper.isSdx())throw new Error("Not supported host");i=function(){var t=S.LoadScriptHelper.getHostBundleJsBasePath().match(/^https?:\/\/[^:/?#]*(?::([0-9]+))?/);if(t&&t[0]){var n=S.LoadScriptHelper.getHostBundleJsBasePath()+"AgaveErrorUX/index.html#",r={error:"NotTrustedWAC",locale:S.getSupportedLocale(a._hostInfo.hostLocale,S.ConstantNames.DefaultLocale),hostname:c,noHttps:!s,validate:!1},o=document.createElement("iframe");o.style.visibility="hidden",o.style.height="0",o.style.width="0";var i=function(e){if(e.source==o.contentWindow&&e.origin==t[0])try{!0===JSON.parse(e.data).hostUserTrusted?(a._webAppState.clientEndPoint.hostTrustCheckStatus=3,S.OUtil.removeEventListener(window,"message",i),document.body.removeChild(o)):(r.validate=!1,window.location.replace(n+encodeURIComponent(JSON.stringify(r)))),p()}catch(e){S.OUtil.ensureOfficeStringsJs().then(function(){document.body.textContent=Strings.OfficeOM.L_NotTrustedWAC})}};S.OUtil.addEventListener(window,"message",i),r.validate=!0,o.setAttribute("src",n+encodeURIComponent(JSON.stringify(r))),o.onload=function(){var e={hostname:c,noHttps:!s};o.contentWindow.postMessage(JSON.stringify(e),t[0])},document.body.appendChild(o)}else S.OUtil.ensureOfficeStringsJs().then(function(){document.body.textContent=Strings.OfficeOM.L_NotTrustedWAC});if(S.OUtil.checkFlight(2)&&!s)throw new Error(l)},document.body?i():(u=!1,document.addEventListener("DOMContentLoaded",function(){u||(u=!0,i())}))}return[2]}})})},t.prototype.setAgaveHostCommunication=function(){try{var o=this,e=S.OUtil.parseXdmInfoWithGivenFragment(!1,S._OfficeAppFactory.getWindowLocationHash());if(e=e||S.OUtil.parseXdmInfoFromWindowName(!1,S._OfficeAppFactory.getWindowName())){var t=S.OUtil.getInfoItems(e);null!=t&&3<=t.length&&(o._webAppState.conversationID=t[0],o._webAppState.id=t[1],o._webAppState.webAppUrl=0<=t[2].indexOf(":")?t[2]:decodeURIComponent(t[2]))}if(o._webAppState.wnd=null!=window.opener?window.opener:window.parent,this._hostInfo.isDialog&&null!=window.opener)return;o._webAppState.clientEndPoint=S.XdmCommunicationManager.connect(o._webAppState.conversationID,o._webAppState.wnd,o._webAppState.webAppUrl),o._webAppState.serviceEndPoint=S.XdmCommunicationManager.createServiceEndPoint(o._webAppState.id),o._webAppState.clientEndPoint.checkReceiverOriginAndRun=function(e){o.checkReceiverOriginAndRun(e)};var n=o._webAppState.conversationID+S.Constants.NotificationConversationIdSuffix;o._webAppState.serviceEndPoint.registerConversation(n,o._webAppState.webAppUrl),o._webAppState.serviceEndPoint.registerMethod("Office_notifyAgave",function(e){var t;switch(t="string"==typeof e?e:e[0]){case S.AgaveHostAction.Select:o._webAppState.focused=!0;break;case S.AgaveHostAction.UnSelect:o._webAppState.focused=!1;break;case S.AgaveHostAction.TabIn:case S.AgaveHostAction.CtrlF6In:window.focus();var n=document.querySelectorAll(o._tabbableElements);S.OUtil.focusToFirstTabbable(n,!1)||(window.blur(),o._webAppState.focused=!1,o._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[o._webAppState.id,S.AgaveHostAction.ExitNoFocusable]));break;case S.AgaveHostAction.TabInShift:window.focus(),n=document.querySelectorAll(o._tabbableElements),S.OUtil.focusToFirstTabbable(n,!0)||(window.blur(),o._webAppState.focused=!1,o._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[o._webAppState.id,S.AgaveHostAction.ExitNoFocusableShift]));break;case S.AgaveHostAction.SendMessage:if(Office.context.messaging.onMessage){var r=e[1];Office.context.messaging.onMessage(r)}break;case S.AgaveHostAction.TaskPaneHeaderButtonClicked:Office.context.ui.taskPaneAction.onHeaderButtonClick&&Office.context.ui.taskPaneAction.onHeaderButtonClick();break;default:S.Utility.trace("actionId "+t+" notifyAgave is wrong.")}},0,!1),o.addOrRemoveEventListenersForWindow(!0)}catch(e){throw S.AppTelemetry&&S.AppTelemetry.logAppException("Exception thrown in setAgaveHostCommunication. Exception:["+e+"]"),e}},t.prototype.getAppContext=function(e,v,b){function t(e,t){if(OSFPerformance.getAppContextXdmEnd=OSFPerformance.now(),t._appName===S.AppName.ExcelWebApp){var n=t._settings;_._serializedSettings={};for(var r=0,o=n;r<o.length;r++){var i=o[r],a=i[0],s=i[1];_._serializedSettings[a]=s}var c=t._hostSettings;_._serializedHostSettings={};for(var l=0,u=c;l<u.length;l++){var p=u[l];a=p[0],s=p[1],_._serializedHostSettings[a]=s}}else _._serializedSettings=t._settings,_._serializedHostSettings=t._hostSettings;if(!O._hostInfo.isDialog||null==window.opener){var f=window.location.href;O._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[O._webAppState.id,S.AgaveHostAction.UpdateTargetUrl,f])}if(0===e&&null!=t._id&&null!=t._appName&&null!=t._appVersion&&null!=t._appUILocale&&null!=t._dataLocale&&null!=t._docUrl&&null!=t._clientMode&&null!=t._reason){var d=(O._appContext=t)._appInstanceId?t._appInstanceId:t._id,h=0;null!=t._appMinorVersion&&(h=t._appMinorVersion);var g=void 0;null!=t._requirementMatrix&&(g=t._requirementMatrix),t.eToken=t.eToken?t.eToken:"";var m=new S.OfficeAppContext(t._id,t._appName,t._appVersion,t._appUILocale,t._dataLocale,t._docUrl,t._clientMode,function(){return _._serializedSettings},t._reason,t._osfControlType,t._eToken,t._correlationId,d,!1,!0,h,g,t._hostCustomMessage,t._hostFullVersion,t._clientWindowHeight,t._clientWindowWidth,t._addinName,t._appDomains,t._dialogRequirementMatrix,t._featureGates,t._officeTheme,t._initialDisplayMode,t._isFromWacAutomation,t._wopiHostOriginForSingleSignOn,function(){return _._serializedHostSettings},!0,t._nestedAppAuthBridgeType,t._partitionKey);m.set_taskpaneUrl(t._taskpaneUrl),v(m)}else{var y="Function ContextActivationManager_getAppContextAsync call failed. ErrorCode is "+e+", exception: "+t;S.AppTelemetry&&S.AppTelemetry.logAppException(y),b(y)}}var _=this,O=this;try{var n=!0;this._hostInfo.isDialog&&null!=window.opener&&(n=!1);var r=S.OUtil.parseAppContextFromWindowName(n,S._OfficeAppFactory.getWindowName());r?t(0,r):(OSFPerformance.getAppContextXdmStart=OSFPerformance.now(),this._webAppState.clientEndPoint.invoke("ContextActivationManager_getAppContextAsync",t,this._webAppState.id))}catch(e){S.AppTelemetry&&S.AppTelemetry.logAppException("Exception thrown when trying to invoke getAppContextAsync. Exception:["+e+"]"),b(e)}},t.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new S.WebClientHostController(this._webAppState)),this._clientHostController},t.prototype.createAsyncMethodExecutor=function(){return new S.WebAsyncMethodExecutor(this._clientHostController)},t.prototype.createClientSettingsManager=function(){return new S.WebClientSettingsManager},t.prototype.addOrRemoveEventListenersForWindow=function(e){function t(){i._webAppState.focused||(i._webAppState.focused=!0),i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,S.AgaveHostAction.Select])}function n(){S&&(i._webAppState.focused&&(i._webAppState.focused=!1),i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,S.AgaveHostAction.UnSelect]))}function r(e){if(e.preventDefault=e.preventDefault||function(){e.returnValue=!1},117==e.keyCode&&(e.ctrlKey||e.metaKey)){e.preventDefault();var t=S.AgaveHostAction.CtrlF6Exit;e.shiftKey&&(t=S.AgaveHostAction.CtrlF6ExitShift),i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,t])}else if(9==e.keyCode){e.preventDefault();var n=document.querySelectorAll(i._tabbableElements);S.OUtil.focusToNextTabbable(n,e.target||e.srcElement,e.shiftKey)||(i._hostInfo.isDialog?S.OUtil.focusToFirstTabbable(n,e.shiftKey):e.shiftKey?i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,S.AgaveHostAction.TabExitShift]):i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,S.AgaveHostAction.TabExit]))}else if(27==e.keyCode)e.preventDefault(),i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,S.AgaveHostAction.EscExit]);else if(113==e.keyCode)e.preventDefault(),i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,S.AgaveHostAction.F2Exit]);else if((e.ctrlKey||e.metaKey||e.shiftKey||e.altKey)&&1<=e.keyCode&&e.keyCode<=255){var r={keyCode:e.keyCode,shiftKey:e.shiftKey,altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey};i._webAppState.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,S.AgaveHostAction.KeyboardShortcuts,r])}}function o(e){117==e.keyCode&&e.ctrlKey&&(e.preventDefault?e.preventDefault():e.returnValue=!1)}var i=this;S.Utility._DebugXdm||(e?(S.OUtil.addEventListener(window,"focus",t),S.OUtil.addEventListener(window,"blur",n),S.OUtil.addEventListener(window,"keydown",r),S.OUtil.addEventListener(window,"keypress",o)):(S.OUtil.removeEventListener(window,"focus",t),S.OUtil.removeEventListener(window,"blur",n),S.OUtil.removeEventListener(window,"keydown",r),S.OUtil.removeEventListener(window,"keypress",o)))},t.prototype.getTabbableElements=function(){return this._tabbableElements},t);function t(e,t,n,r){var o=i.call(this,e,t,n,r)||this;return o._appContext={},o._tabbableElements="a[href]:not([tabindex='-1']),area[href]:not([tabindex='-1']),button:not([disabled]):not([tabindex='-1']),input:not([disabled]):not([tabindex='-1']),select:not([disabled]):not([tabindex='-1']),textarea:not([disabled]):not([tabindex='-1']),*[tabindex]:not([tabindex='-1']),*[contenteditable]:not([disabled]):not([tabindex='-1'])",o}S.WebInitializationHelper=e}(OSF=OSF||{}),function(a){var e=(t.prototype.read=function(n){this._initializationHelper.getAppContext(null,function(e){if(n){var t=e.get_settingsFunc()();n(0,t)}},function(e){n&&n(5001,{})})},t.prototype.write=function(e,t){var n={},r=[],o=[];for(var i in e)r.push(i),o.push(e[i]);n.keys=r,n.values=o,this._scriptMessager.invokeMethod(a.Webkit.MessageHandlerName,a.Webkit.MethodId.WriteSettings,n,function(e){t&&t(e[0])})},t);function t(e,t){this._initializationHelper=e,this._scriptMessager=t}a.WebkitClientSettingsManager=e}(OSF=OSF||{}),function(d){!function(e){var t,n;e.MessageHandlerName="Agave",e.PopupMessageHandlerName="WefPopupHandler",(t=e.AppContextProperties||(e.AppContextProperties={}))[t.Settings=0]="Settings",t[t.SolutionReferenceId=1]="SolutionReferenceId",t[t.AppType=2]="AppType",t[t.MajorVersion=3]="MajorVersion",t[t.MinorVersion=4]="MinorVersion",t[t.RevisionVersion=5]="RevisionVersion",t[t.APIVersionSequence=6]="APIVersionSequence",t[t.AppCapabilities=7]="AppCapabilities",t[t.APPUILocale=8]="APPUILocale",t[t.AppDataLocale=9]="AppDataLocale",t[t.BindingCount=10]="BindingCount",t[t.DocumentUrl=11]="DocumentUrl",t[t.ActivationMode=12]="ActivationMode",t[t.ControlIntegrationLevel=13]="ControlIntegrationLevel",t[t.SolutionToken=14]="SolutionToken",t[t.APISetVersion=15]="APISetVersion",t[t.CorrelationId=16]="CorrelationId",t[t.InstanceId=17]="InstanceId",t[t.TouchEnabled=18]="TouchEnabled",t[t.CommerceAllowed=19]="CommerceAllowed",t[t.RequirementMatrix=20]="RequirementMatrix",t[t.HostCustomMessage=21]="HostCustomMessage",t[t.HostFullVersion=22]="HostFullVersion",t[t.InitialDisplayMode=23]="InitialDisplayMode",t[t.FeatureGates=24]="FeatureGates",t[t.HostSettings=25]="HostSettings",t[t.OfficeThemeInfo=26]="OfficeThemeInfo",(n=e.MethodId||(e.MethodId={}))[n.Execute=1]="Execute",n[n.RegisterEvent=2]="RegisterEvent",n[n.UnregisterEvent=3]="UnregisterEvent",n[n.WriteSettings=4]="WriteSettings",n[n.GetContext=5]="GetContext",n[n.SendMessage=6]="SendMessage",n[n.MessageParent=7]="MessageParent",n[n.SendMessage2=8]="SendMessage2",n[n.MessageParent2=9]="MessageParent2",n[n.CloseSdxDialog=10]="CloseSdxDialog",n[n.ResizeSdxDialog=11]="ResizeSdxDialog";var r=(f.prototype.execute=function(e,t,o){var n={id:e,apiArgs:t};this.hostScriptProxy.invokeMethod(d.Webkit.MessageHandlerName,d.Webkit.MethodId.Execute,n,function(e){if(o){var t=[];if(d.OUtil.isArray(e))for(var n=0;n<e.length;n++){var r=e[n];d.OUtil.isArray(r)&&(r=new d.WebkitSafeArray(r)),t.unshift(r)}return o.apply(null,t)}})},f.prototype.registerEvent=function(e,t,n,r,o){this.hostScriptProxy.registerEvent(d.Webkit.MessageHandlerName,d.Webkit.MethodId.RegisterEvent,e,n,function(e){var t=e,n=0;d.OUtil.isArray(e)&&2<=e.length&&(t=e[0],n=e[1]),r&&r(n,new d.WebkitSafeArray(t))},function(e){if(o)return o(new d.WebkitSafeArray(e))})},f.prototype.unregisterEvent=function(e,t,n,r){this.hostScriptProxy.unregisterEvent(d.Webkit.MessageHandlerName,d.Webkit.MethodId.UnregisterEvent,e,n,function(e){return r(new d.WebkitSafeArray(e))})},f.prototype.messageParent=function(e){var t,n;if(n=this.osfSupportsDialogOrigin&&e[d.ParameterNames.TargetOrigin]?(t=this.useFullDialogAPI?JSON.stringify(e):e[d.ParameterNames.MessageToParent],d.Webkit.MethodId.MessageParent2):(t=e[d.ParameterNames.MessageToParent],d.Webkit.MethodId.MessageParent),this.useFullDialogAPI)this.hostScriptProxy.invokeMethod(d.Webkit.MessageHandlerName,n,t,null);else{var r={dialogMessage:{messageType:0,messageContent:t}},o=n==d.Webkit.MethodId.MessageParent2?e[d.ParameterNames.TargetOrigin]:window.location.origin;window.opener.postMessage(JSON.stringify(r),o)}},f.prototype.openDialog=function(n,e,t,r,o){if(this.useFullDialogAPI)this.registerEvent(n,e,t,r,o);else if(!f.popup||f.popup.closed){f.OpenDialogCallback=void 0;var i=JSON.parse(t),a=i.url;if(a){var s=a.split("#"),c="?";-1<s[0].indexOf("?")&&(c="&");var l="width="+screen.width*i.width/100+", height="+screen.height*i.height/100;s[0]=s[0].concat(c).concat("action=displayDialog");var u=s.join("#");f.popup=window.open(u,"",l),f.DialogEventListener=function(t){if(t.origin==window.location.origin)try{var e=JSON.parse(t.data);e.dialogMessage&&r(n,[0,e.dialogMessage.messageContent,t.origin])}catch(e){d.Utility.trace("messages received cannot be handlered. Message:"+t.data)}},f.OpenDialogCallback=function(e){0==e&&(window.addEventListener("message",f.DialogEventListener),f.interval=window.setInterval(p,1e3),f.NotifyError=function(e){r(n,[e])}),o(e)}}else o(12003)}else o(12007);function p(){try{null!=f.popup&&!f.popup.closed||(window.clearInterval(f.interval),window.removeEventListener("message",f.DialogEventListener),f.NotifyError=null,f.popup=null,r(n,[12006]))}catch(e){d.Utility.trace("Error happened when popup window closed.")}}},f.prototype.closeDialog=function(e,t,n,r){this.useFullDialogAPI?this.unregisterEvent(e,t,n,r):f.popup?(f.interval&&window.clearInterval(f.interval),f.popup.close(),f.popup=null,window.removeEventListener("message",f.DialogEventListener),f.NotifyError=null,r(0)):r(5001)},f.prototype.sendMessage=function(e){var t,n;this.osfSupportsDialogOrigin&&e[d.ParameterNames.TargetOrigin]?(t=JSON.stringify(e),n=d.Webkit.MethodId.SendMessage2):(t=e[d.ParameterNames.MessageContent],n=d.Webkit.MethodId.SendMessage,!isNaN(parseFloat(t))&&isFinite(t)&&(t=t.toString())),this.hostScriptProxy.invokeMethod(d.Webkit.MessageHandlerName,n,t,null)},f.prototype.closeSdxDialog=function(e){var t=[e],n=d.Webkit.MethodId.CloseSdxDialog;this.hostScriptProxy.invokeMethod(d.Webkit.MessageHandlerName,n,t,null)},f.prototype.resizeSdxDialog=function(e,t){var n=[e,t],r=d.Webkit.MethodId.ResizeSdxDialog;this.hostScriptProxy.invokeMethod(d.Webkit.MessageHandlerName,r,n,null)},f);function f(e){this.hostScriptProxy=e,this.useFullDialogAPI=!!window._enableFullDialogAPI,this.osfSupportsDialogOrigin=!!window._osfEnableDialogOrigin}e.WebkitHostController=r}(d.Webkit||(d.Webkit={}))}(OSF=OSF||{}),function(k){var i,e=(i=k.InitializationHelper,__extends(t,i),t.prototype.initializeWebkitMessaging=function(){k.ScriptMessaging=OSFWebkit.ScriptMessaging},t.prototype.getAppContext=function(e,M,t){var n,j=this;n=this._hostInfo.isDialog&&window.webkit.messageHandlers[k.Webkit.PopupMessageHandlerName]?k.Webkit.PopupMessageHandlerName:k.Webkit.MessageHandlerName,k.ScriptMessaging.GetScriptMessenger().invokeMethod(n,k.Webkit.MethodId.GetContext,[],function(e){var t,n=k.Webkit.AppContextProperties,r=e[n.AppType],o=e[n.Settings];j._serializedSettings={};for(var i=o[0],a=o[1],s=0;s<i.length;s++)j._serializedSettings[i[s]]=a[s];var c=e[n.HostSettings];if(j._serializedHostSettings={},c)for(i=c[0],a=c[1],s=0;s<i.length;s++)j._serializedHostSettings[i[s]]=a[s];var l=e[n.SolutionReferenceId],u=e[n.MajorVersion],p=e[n.MinorVersion],f=e[n.AppCapabilities],d=e[n.APPUILocale],h=e[n.AppDataLocale],g=e[n.DocumentUrl],m=e[n.ActivationMode],y=e[n.ControlIntegrationLevel],v=e[n.SolutionToken];v=v?v.toString():"";var b,_=e[n.CorrelationId],O=e[n.InstanceId],S=e[n.TouchEnabled],C=e[n.CommerceAllowed],A=e[n.RequirementMatrix],P=e[n.HostCustomMessage],E=e[n.HostFullVersion],T=e[n.InitialDisplayMode],w=e[n.FeatureGates];if(w)try{b=JSON.parse(w)}catch(e){k.AppTelemetry&&k.AppTelemetry.logAppException("Exception trying to parse FeatureGates."+e)}var I=null;if(e[n.OfficeThemeInfo])try{I=JSON.parse(e[n.OfficeThemeInfo])}catch(e){k.AppTelemetry&&k.AppTelemetry.logAppException("Exception while parsing officeThemeInfo. Details: "+e)}var x={};if(I){var D={bodyBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},bodyForegroundColor:{name:"bodyForegroundColor",convertToHex:!0},controlBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0},controlForegroundColor:{name:"controlForegroundColor",convertToHex:!0},primaryFontColor:{name:"bodyForegroundColor",convertToHex:!0},primaryBackgroundColor:{name:"bodyBackgroundColor",convertToHex:!0},secondaryFontColor:{name:"controlForegroundColor",convertToHex:!0},secondaryBackgroundColor:{name:"controlBackgroundColor",convertToHex:!0}};for(var F in I){var R=!1,N=F;D[F]&&(N=D[F].name,R=D[F].convertToHex),x[N]=R?k.OUtil.convertIntToCssHexColor(I[F]):I[F]}}t=new k.OfficeAppContext(l,r,u,d,h,g,f,function(){return j._serializedSettings},m,y,v,_,O,S,C,p,A,P,E,void 0,void 0,void 0,void 0,void 0,b,x,T,void 0,void 0,function(){return j._serializedHostSettings},!1,void 0,void 0),M(t)})},t.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new k.Webkit.WebkitHostController(k.ScriptMessaging.GetScriptMessenger())),this._clientHostController},t.prototype.createAsyncMethodExecutor=function(){return new k.SafeArrayAsyncMethodExecutor(this.createClientHostController())},t.prototype.createClientSettingsManager=function(){return new k.WebkitClientSettingsManager(this,k.ScriptMessaging.GetScriptMessenger())},t);function t(e,t,n,r){var o=i.call(this,e,t,n,r)||this;return o.initializeWebkitMessaging(),o}k.WebkitInitializationHelper=e}(OSF=OSF||{}),function(s){var e=(r.prototype.dimensions=function(){var e=0;return this.safeArrayFlag?e=this.data[0][0]:this.isArray()&&(e=2),e},r.prototype.getItem=function(){var e=null;e=this.safeArrayFlag?this.toArray():this.data;for(var t=0;t<arguments.length;t++)e=e[arguments[t]];return e},r.prototype.lbound=function(e){return 0},r.prototype.ubound=function(e){var t=0;if(this.safeArrayFlag)t=this.data[0][e];else if(this.isArray()){if(1==e)return this.data.length;if(2==e){if(s.OUtil.isArray(this.data[0]))return this.data[0].length;if(null!=this.data[0])return 1}}return t},r.prototype.toArray=function(){if(0==this.isArray())return this.data;for(var e=[],t=this.safeArrayFlag?1:0;t<this.data.length;t++){var n=this.data[t];this.isSafeArray(n)?e.push(new r(n)):e.push(n)}return e},r.prototype.isArray=function(){return s.OUtil.isArray(this.data)},r.prototype.isSafeArray=function(e){var t=!1;if(s.OUtil.isArray(e)&&s.OUtil.isArray(e[0])){var n=e[0],r=n[0];if(n.length!=r+1)return!1;for(var o=1,i=1;i<n.length;i++){var a=n[i];if(0==isFinite(a))return!1;o*=a}t=++o==e.length}return t},r);function r(e){this.data=e,this.safeArrayFlag=this.isSafeArray(e)}s.WebkitSafeArray=e}(OSF=OSF||{}),function(e){!function(e){var n=null;e.agaveHostCallback=function(e,t){n.agaveHostCallback(e,t)},e.agaveHostEventCallback=function(e,t){n.agaveHostEventCallback(e,t)},e.GetScriptMessenger=function(){return null==n&&(n=t.IsSupportedByHost()?new t:new o("OSF.ScriptMessaging.agaveHostCallback","OSF.ScriptMessaging.agaveHostEventCallback")),n};var l=function(e,t,n){this.id=e,this.targetId=t,this.handler=n},t=(r.IsSupportedByHost=function(){return!!window._osfHostAPI},r.prototype.invokeMethod=function(e,t,n,r){window._osfHostAPI(e,this.constructMessagingArgs(t,n),function(e){var t=r(e);return void 0===t||!0===t})},r.prototype.registerEvent=function(e,t,n,r,o,i){var a={id:n,targetId:r},s=window._osfHostRegisterEvent(e,this.constructMessagingArgs(t,a),function(e){return o(e),!1},function(e){return i(e),!0});this.eventHandlers.push({targetId:r,dispId:n,callbackId:s.eventCallbackId})},r.prototype.unregisterEvent=function(e,t,n,r,o){var i={id:n,targetId:r};window._osfHostAPI(e,this.constructMessagingArgs(t,i),function(e){return o(e),!0});for(var a=this.eventHandlers.length-1;0<=a;a--){var s=this.eventHandlers[a];s.dispId===n&&s.targetId===r&&(this.eventHandlers.splice(a,1),window._osfHostUnregisterCallback(s.callbackId))}},r.prototype.agaveHostCallback=function(e,t){},r.prototype.agaveHostEventCallback=function(e,t){},r.prototype.constructMessagingArgs=function(e,t){return{params:t,methodId:e}},r);function r(){this.eventHandlers=[]}var o=(c.prototype.invokeMethod=function(e,t,n,r){this.postWebkitMessage({},e,t,n,r)},c.prototype.registerEvent=function(e,t,n,r,o,i){var a={eventCallbackFunction:this.eventCallbackFunctionName},s={id:n,targetId:r},c=this.postWebkitMessage(a,e,t,s,i);this.eventHandlerList[c]=new l(n,r,o)},c.prototype.unregisterEvent=function(e,t,n,r,o){var i={id:n,targetId:r};for(var a in this.eventHandlerList)if(this.eventHandlerList.hasOwnProperty(a)){var s=this.eventHandlerList[a];s.id==n&&s.targetId==r&&delete this.eventHandlerList[a]}this.invokeMethod(e,t,i,o)},c.prototype.agaveHostCallback=function(e,t){var n=this.callbackList[e];if(n){var r=n(t);void 0!==r&&!0!==r||delete this.callbackList[e]}},c.prototype.agaveHostEventCallback=function(e,t){var n=this.eventHandlerList[e];n&&n.handler(t)},c.prototype.postWebkitMessage=function(e,t,n,r,o){e.methodId=n,e.params=r;var i="";function a(){window.webkit.messageHandlers[t].postMessage(JSON.stringify(e))}o&&(i=this.generateCorrelationId(),this.callbackList[i]=o,e.callbackId=i,e.callbackFunction=this.asyncMethodCallbackFunctionName);var s=c.getCurrentTimeMS();return null==this.lastMessageTimestamp||s-this.lastMessageTimestamp>=c.MESSAGE_TIME_DELTA?(a(),this.lastMessageTimestamp=s):(this.lastMessageTimestamp+=c.MESSAGE_TIME_DELTA,setTimeout(function(){a()},this.lastMessageTimestamp-s)),i},c.prototype.generateCorrelationId=function(){return++this.callingIndex,this.conversationId+this.callingIndex},c.getCurrentTimeMS=function(){return(new Date).getTime()},c.MESSAGE_TIME_DELTA=10,c);function c(e,t){this.callingIndex=0,this.callbackList={},this.eventHandlerList={},this.asyncMethodCallbackFunctionName=e,this.eventCallbackFunctionName=t,this.conversationId=c.getCurrentTimeMS().toString()}}(e.ScriptMessaging||(e.ScriptMessaging={}))}(OSFWebkit=OSFWebkit||{}),function(a){var e=(t.prototype.read=function(n){this._initializationHelper.getAppContext(null,function(e){if(n){var t=e.get_settingsFunc()();n(0,t)}},function(e){n&&n(5001,{})})},t.prototype.write=function(e,t){var n={},r=[],o=[];for(var i in e)r.push(i),o.push(e[i]);n.keys=r,n.values=o,this._scriptMessager.invokeMethod(a.WebView.MessageHandlerName,a.WebView.MethodId.WriteSettings,n,function(e){t&&t(e[0])})},t);function t(e,t){this._initializationHelper=e,this._scriptMessager=t}a.WebViewClientSettingsManager=e}(OSF=OSF||{}),function(d){!function(e){var t,n;e.MessageHandlerName="Agave",e.PopupMessageHandlerName="WefPopupHandler",(t=e.AppContextProperties||(e.AppContextProperties={}))[t.Settings=0]="Settings",t[t.SolutionReferenceId=1]="SolutionReferenceId",t[t.AppType=2]="AppType",t[t.MajorVersion=3]="MajorVersion",t[t.MinorVersion=4]="MinorVersion",t[t.RevisionVersion=5]="RevisionVersion",t[t.APIVersionSequence=6]="APIVersionSequence",t[t.AppCapabilities=7]="AppCapabilities",t[t.APPUILocale=8]="APPUILocale",t[t.AppDataLocale=9]="AppDataLocale",t[t.BindingCount=10]="BindingCount",t[t.DocumentUrl=11]="DocumentUrl",t[t.ActivationMode=12]="ActivationMode",t[t.ControlIntegrationLevel=13]="ControlIntegrationLevel",t[t.SolutionToken=14]="SolutionToken",t[t.APISetVersion=15]="APISetVersion",t[t.CorrelationId=16]="CorrelationId",t[t.InstanceId=17]="InstanceId",t[t.TouchEnabled=18]="TouchEnabled",t[t.CommerceAllowed=19]="CommerceAllowed",t[t.RequirementMatrix=20]="RequirementMatrix",t[t.OfficeThemeInfo=21]="OfficeThemeInfo",(n=e.MethodId||(e.MethodId={}))[n.Execute=1]="Execute",n[n.RegisterEvent=2]="RegisterEvent",n[n.UnregisterEvent=3]="UnregisterEvent",n[n.WriteSettings=4]="WriteSettings",n[n.GetContext=5]="GetContext",n[n.OnKeydown=6]="OnKeydown",n[n.AddinInitialized=7]="AddinInitialized",n[n.OpenWindow=8]="OpenWindow",n[n.MessageParent=9]="MessageParent",n[n.SendMessage=10]="SendMessage";var r=(f.prototype.execute=function(e,t,n){var r=t;null==r&&(r=[]);var o={id:e,apiArgs:r};this.hostScriptProxy.invokeMethod(d.WebView.MessageHandlerName,d.WebView.MethodId.Execute,o,function(e){var t=e;if(d.OUtil.isArray(e)&&2<=e.length&&(e[0],t=e[1]),n)return n(new d.WebkitSafeArray(t))})},f.prototype.registerEvent=function(e,t,n,r,o){this.hostScriptProxy.registerEvent(d.WebView.MessageHandlerName,d.WebView.MethodId.RegisterEvent,e,n,function(e){var t=e,n=0;d.OUtil.isArray(e)&&2<=e.length&&(n=e[0],t=e[1]),r&&r(n,new d.WebkitSafeArray(t))},function(e){if(o)return o(new d.WebkitSafeArray(e))})},f.prototype.unregisterEvent=function(e,t,n,r){this.hostScriptProxy.unregisterEvent(d.WebView.MessageHandlerName,d.WebView.MethodId.UnregisterEvent,e,n,function(e){return r(new d.WebkitSafeArray(e))})},f.prototype.messageParent=function(e){var t={dialogMessage:{messageType:0,messageContent:e[d.ParameterNames.MessageToParent]}};window.opener.postMessage(JSON.stringify(t),window.location.origin)},f.prototype.openDialog=function(n,e,t,r,o){var i=JSON.parse(t),a=i.url;if(a){var s=a.split("#"),c="?";-1<a.indexOf("?")&&(c="&");var l="width="+screen.width*i.width/100+", height="+screen.height*i.height/100;s[0]=s[0].concat(c).concat("action=displayDialog");var u,p=s.join("#");f.popup=window.open(p,"",l),window.addEventListener("message",function(t){if(t.source==f.popup)try{var e=JSON.parse(t.data);e.dialogMessage&&r(n,[0,e.dialogMessage.messageContent])}catch(e){d.Utility.trace("messages received cannot be handled. Message:"+t.data)}}),u=window.setInterval(function(){try{null!=f.popup&&!f.popup.closed||(window.clearInterval(u),r(n,[12006]))}catch(e){d.Utility.trace("Error happened when popup window closed.")}},1e3),o(0)}},f.prototype.closeDialog=function(e,t,n,r){f.popup?(f.popup.close(),f.popup=null,r(0)):r(5001)},f.prototype.sendMessage=function(e){var t=e[d.ParameterNames.MessageContent];!isNaN(parseFloat(t))&&isFinite(t)&&(t=t.toString()),this.hostScriptProxy.invokeMethod(d.WebView.MessageHandlerName,d.WebView.MethodId.SendMessage,t,null)},f.prototype.closeSdxDialog=function(e){throw d.Utility.createNotImplementedException()},f.prototype.resizeSdxDialog=function(e,t){throw d.Utility.createNotImplementedException()},f);function f(e){this.hostScriptProxy=e}e.WebViewHostController=r}(d.WebView||(d.WebView={}))}(OSF=OSF||{}),function(w){var i,e=(i=w.InitializationHelper,__extends(t,i),t.prototype.initializeWebViewMessaging=function(){w.ScriptMessaging=w.WebView.ScriptMessaging},t.prototype.getAppContext=function(e,E,t){var n,T=this;n=this._hostInfo.isDialog?w.WebView.PopupMessageHandlerName:w.WebView.MessageHandlerName,w.ScriptMessaging.GetScriptMessenger().invokeMethod(n,w.WebView.MethodId.GetContext,[],function(e){var t,n=w.Webkit.AppContextProperties,r=e[n.AppType],o=e[n.Settings];T._serializedSettings={};for(var i=o[0],a=o[1],s=0;s<i.length;s++)T._serializedSettings[i[s]]=a[s];var c=e[n.SolutionReferenceId],l=e[n.MajorVersion],u=e[n.MinorVersion],p=e[n.AppCapabilities],f=e[n.APPUILocale],d=e[n.AppDataLocale],h=e[n.DocumentUrl],g=e[n.ActivationMode],m=e[n.ControlIntegrationLevel],y=e[n.SolutionToken];y=y?y.toString():"";var v=e[n.CorrelationId],b=e[n.InstanceId],_=e[n.TouchEnabled],O=e[n.CommerceAllowed],S=e[n.RequirementMatrix],C=e[n.HostCustomMessage],A=e[n.HostFullVersion],P=e[n.InitialDisplayMode];t=new w.OfficeAppContext(c,r,l,f,d,h,p,function(){return T._serializedSettings},g,m,y,v,b,_,O,u,S,C,A,void 0,void 0,void 0,void 0,void 0,void 0,void 0,P,void 0,void 0,void 0,!1,void 0,void 0),E(t)})},t.prototype.createClientHostController=function(){return this._clientHostController||(this._clientHostController=new w.WebView.WebViewHostController(w.ScriptMessaging.GetScriptMessenger())),this._clientHostController},t.prototype.createAsyncMethodExecutor=function(){return new w.SafeArrayAsyncMethodExecutor(this.createClientHostController())},t.prototype.createClientSettingsManager=function(){return new w.WebViewClientSettingsManager(this,w.ScriptMessaging.GetScriptMessenger())},t);function t(e,t,n,r){var o=i.call(this,e,t,n,r)||this;return o.initializeWebViewMessaging(),o}w.WebViewInitializationHelper=e}(OSF=OSF||{}),function(n){var r,e,t,o,i;function a(){}function s(){window.addEventListener("message",this.OnReceiveMessage.bind(this))}!function(e){var t;(t=e.CallbackType||(e.CallbackType={}))[t.MethodCallback=0]="MethodCallback",t[t.EventCallback=1]="EventCallback";function n(e,t,n){this.callbackType=e,this.callbackId=t,this.params=n}e.CallbackData=n}(r=r||{}),e=n.Android||(n.Android={}),a.getInstance=function(){return null==a.uniqueInstance&&(a.uniqueInstance=new a),a.uniqueInstance},a.prototype.postMessage=function(e,t){agaveHost.postMessage(t)},a.prototype.ReceiveMessage=function(e){switch(e.callbackType){case r.CallbackType.MethodCallback:n.WebView.ScriptMessaging.agaveHostCallback(e.callbackId,e.params);break;case r.CallbackType.EventCallback:n.WebView.ScriptMessaging.agaveHostEventCallback(e.callbackId,e.params)}},t=a,e.Poster=t,o=n.WinRT||(n.WinRT={}),s.prototype.postMessage=function(e,t){window.parent.postMessage(t,"*")},s.prototype.OnReceiveMessage=function(e){if(e.source==window.parent&&window.parent==window.top&&e.origin.startsWith("ms-appx-web://")){var t;try{t=JSON.parse(e.data)}catch(e){return}switch(t.callbackType){case r.CallbackType.MethodCallback:n.WebView.ScriptMessaging.agaveHostCallback(t.callbackId,JSON.parse(t.params));break;case r.CallbackType.EventCallback:n.WebView.ScriptMessaging.agaveHostEventCallback(t.callbackId,JSON.parse(t.params))}}},i=s,o.Poster=i}(OSF=OSF||{}),function(o){var e;(function(e){var n=null;e.agaveHostCallback=function(e,t){n.agaveHostCallback(e,t)},e.agaveHostEventCallback=function(e,t){n.agaveHostEventCallback(e,t)},e.GetScriptMessenger=function(){if(null==n){var e=o._OfficeAppFactory.getHostInfo().hostPlatform;if(e===o.HostInfoPlatform.android)n=new t("OSF.ScriptMessaging.agaveHostCallback","OSF.ScriptMessaging.agaveHostEventCallback",o.Android.Poster.getInstance());else{if(e!==o.HostInfoPlatform.winrt)throw o.Utility.createNotImplementedException();n=new t("agaveHostCallback","agaveHostEventCallback",new o.WinRT.Poster)}}return n};var l=function(e,t,n){this.id=e,this.targetId=t,this.handler=n},t=(r.prototype.invokeMethod=function(e,t,n,r){this.postMessage({},e,t,n,r)},r.prototype.registerEvent=function(e,t,n,r,o,i){var a={eventCallbackFunction:this.eventCallbackFunctionName},s={id:n,targetId:r},c=this.postMessage(a,e,t,s,i);this.eventHandlerList[c]=new l(n,r,o)},r.prototype.unregisterEvent=function(e,t,n,r,o){var i={id:n,targetId:r};for(var a in this.eventHandlerList)if(this.eventHandlerList.hasOwnProperty(a)){var s=this.eventHandlerList[a];s.id==n&&s.targetId==r&&delete this.eventHandlerList[a]}this.invokeMethod(e,t,i,o)},r.prototype.agaveHostCallback=function(e,t){var n=this.callbackList[e];if(n){var r=n(t);void 0!==r&&!0!==r||delete this.callbackList[e]}},r.prototype.agaveHostEventCallback=function(e,t){var n=this.eventHandlerList[e];n&&n.handler(t)},r.prototype.postMessage=function(e,t,n,r,o){var i=this.generateCorrelationId();return this.callbackList[i]=o,e.methodId=n,e.params=r,e.callbackId=i,e.callbackFunction=this.asyncMethodCallbackFunctionName,this.poster.postMessage(t,JSON.stringify(e)),i},r.prototype.generateCorrelationId=function(){return++this.callingIndex,this.conversationId+this.callingIndex},r.getCurrentTimeMS=function(){return(new Date).getTime()},r.MESSAGE_TIME_DELTA=10,r);function r(e,t,n){this.callingIndex=0,this.callbackList={},this.eventHandlerList={},this.asyncMethodCallbackFunctionName=e,this.eventCallbackFunctionName=t,this.poster=n,this.conversationId=r.getCurrentTimeMS().toString()}})((e=o.WebView||(o.WebView={})).ScriptMessaging||(e.ScriptMessaging={}))}(OSF=OSF||{}),function(n){var e,t=(e=n.RichClientHostController,__extends(r,e),r.prototype.messageParent=function(e){if(n.Utility.externalNativeFunctionExists(typeof window.external.MessageParent2))"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.MessageParent2(JSON.stringify(e),OsfOMToken):window.external.MessageParent2(JSON.stringify(e));else{var t=e[n.ParameterNames.MessageToParent];window.external.MessageParent(t)}},r.prototype.openDialog=function(e,t,n,r,o){this.registerEvent(e,t,n,r,o)},r.prototype.closeDialog=function(e,t,n,r){this.unregisterEvent(e,t,n,r)},r.prototype.sendMessage=function(e){if(n.Utility.externalNativeFunctionExists(typeof window.external.MessageChild2))"undefined"!=typeof OsfOMToken&&OsfOMToken?window.external.MessageChild2(JSON.stringify(e),OsfOMToken):window.external.MessageChild2(JSON.stringify(e));else{var t=e[n.ParameterNames.MessageContent];window.external.MessageChild(t)}},r.prototype.closeSdxDialog=function(e){n.Utility.externalNativeFunctionExists(typeof window.external.closeSdxDialog)&&window.external.closeSdxDialog(e)},r.prototype.resizeSdxDialog=function(e,t){n.Utility.externalNativeFunctionExists(typeof window.external.resizeSdxDialog)&&window.external.resizeSdxDialog(e,t)},r);function r(){return null!==e&&e.apply(this,arguments)||this}n.Win32RichClientHostController=t}(OSF=OSF||{}),function(f){var e,t=(e=f.Webkit.WebkitHostController,__extends(d,e),d.prototype.openDialog=function(n,e,t,r,o){if(!d.popup||d.popup.closed){window.dialogAPIErrorCode=void 0;var i=JSON.parse(t),a=i.url;if(a){var s=a.split("#"),c="?";-1<s[0].indexOf("?")&&(c="&");var l="width="+screen.width*i.width/100+", height="+screen.height*i.height/100;s[0]=s[0].concat(c).concat("action=displayDialog");var u=s.join("#");if(d.popup=window.open(u,"",l),d.DialogEventListener=function(t){if(t.source==d.popup)try{var e=JSON.parse(t.data);e.dialogMessage&&r(n,[0,e.dialogMessage.messageContent])}catch(e){f.Utility.trace("messages received cannot be handlered. Message:"+t.data)}},null!=d.popup&&null==window.dialogAPIErrorCode)window.addEventListener("message",d.DialogEventListener),d.interval=window.setInterval(function(){try{null!=d.popup&&!d.popup.closed||(window.clearInterval(d.interval),window.removeEventListener("message",d.DialogEventListener),d.NotifyError=null,r(n,[12006]))}catch(e){f.Utility.trace("Error happened when popup window closed.")}},500),d.NotifyError=function(e){r(n,[e])},o(0);else{var p=5001;window.dialogAPIErrorCode&&(p=window.dialogAPIErrorCode),o(p)}}else o(12003)}else o(12007)},d.prototype.messageParent=function(e){var t={dialogMessage:{messageType:0,messageContent:e[f.ParameterNames.MessageToParent]}};window.opener.postMessage(JSON.stringify(t),window.location.origin)},d.prototype.closeDialog=function(e,t,n,r){d.popup?(d.interval&&window.clearInterval(d.interval),d.popup.close(),d.popup=null,window.removeEventListener("message",d.DialogEventListener),d.NotifyError=null,r(0)):r(5001)},d);function d(){return null!==e&&e.apply(this,arguments)||this}f.MacRichClientHostController=t}(OSF=OSF||{}),function(e){var t,n,r;((n=e._Internal||(e._Internal={})).PromiseImpl||(n.PromiseImpl={})).Init=function(){return function(){"use strict";function l(e){return"function"==typeof e}var n,a=Array.isArray?Array.isArray:function(e){return"[object Array]"===Object.prototype.toString.call(e)},r=0,s=function(e,t){p[r]=e,p[r+1]=t,2===(r+=2)&&(n?n(f):o())};var e="undefined"!=typeof process&&"[object process]"==={}.toString.call(process),t="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;var o,i,c,u,p=new Array(1e3);function f(){for(var e=0;e<r;e+=2){(0,p[e])(p[e+1]),p[e]=void 0,p[e+1]=void 0}r=0}function d(){}o=e?(c=process.nextTick,u=process.versions.node.match(/^(?:(\d+)\.)?(?:(\d+)\.)?(\*|\d+)$/),Array.isArray(u)&&"0"===u[1]&&"10"===u[2]&&(c=setImmediate),function(){c(f)}):t?((i=new MessageChannel).port1.onmessage=f,function(){i.port2.postMessage(0)}):function(){setTimeout(f,1)};var h=void 0,g=1,m=2,y=new E;function v(e,r,o){s(function(t){var n=!1,e=function(e,t,n,r){try{e.call(t,n,r)}catch(e){return e}}(o,r,function(e){n||(n=!0,(r!==e?_:S)(t,e))},function(e){n||(n=!0,C(t,e))},t._label);!n&&e&&(n=!0,C(t,e))},e)}function b(e,t){if(t.constructor===e.constructor)r=e,(o=t)._state===g?S(r,o._result):o._state===m?C(r,o._result):A(o,void 0,function(e){_(r,e)},function(e){C(r,e)});else{var n=function(e){try{return e.then}catch(e){return y.error=e,y}}(t);n===y?C(e,y.error):void 0!==n&&l(n)?v(e,t,n):S(e,t)}var r,o}function _(e,t){var n;e===t?C(e,new TypeError("You cannot resolve a promise with itself")):("function"==typeof(n=t)||"object"==typeof n&&null!==n?b:S)(e,t)}function O(e){e._onerror&&e._onerror(e._result),P(e)}function S(e,t){e._state===h&&(e._result=t,e._state=g,0!==e._subscribers.length&&s(P,e))}function C(e,t){e._state===h&&(e._state=m,e._result=t,s(O,e))}function A(e,t,n,r){var o=e._subscribers,i=o.length;e._onerror=null,o[i]=t,o[i+g]=n,o[i+m]=r,0===i&&e._state&&s(P,e)}function P(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var r,o,i=e._result,a=0;a<t.length;a+=3)r=t[a],o=t[a+n],r?w(n,r,o,i):o(i);e._subscribers.length=0}}function E(){this.error=null}var T=new E;function w(e,t,n,r){var o,i,a,s,c=l(n);if(c){if((o=function(e,t){try{return e(t)}catch(e){return T.error=e,T}}(n,r))===T?(s=!0,i=o.error,o=null):a=!0,t===o)return void C(t,new TypeError("A promises callback cannot return that same promise."))}else o=r,a=!0;t._state!==h||(c&&a?_(t,o):s?C(t,i):e===g?S(t,o):e===m&&C(t,o))}function I(e,t){var n=this;n._instanceConstructor=e,n.promise=new e(d),n._validateInput(t)?(n._input=t,n.length=t.length,n._remaining=t.length,n._init(),0===n.length?S(n.promise,n._result):(n.length=n.length||0,n._enumerate(),0===n._remaining&&S(n.promise,n._result))):C(n.promise,n._validationError())}I.prototype._validateInput=function(e){return a(e)},I.prototype._validationError=function(){return new Error("Array Methods must be provided an Array")},I.prototype._init=function(){this._result=new Array(this.length)};var x=I;I.prototype._enumerate=function(){for(var e=this.length,t=this.promise,n=this._input,r=0;t._state===h&&r<e;r++)this._eachEntry(n[r],r)},I.prototype._eachEntry=function(e,t){var n,r=this,o=r._instanceConstructor;"object"==typeof(n=e)&&null!==n?e.constructor===o&&e._state!==h?(e._onerror=null,r._settledAt(e._state,t,e._result)):r._willSettleAt(o.resolve(e),t):(r._remaining--,r._result[t]=e)},I.prototype._settledAt=function(e,t,n){var r=this,o=r.promise;o._state===h&&(r._remaining--,e===m?C(o,n):r._result[t]=n),0===r._remaining&&S(o,r._result)},I.prototype._willSettleAt=function(e,t){var n=this;A(e,void 0,function(e){n._settledAt(g,t,e)},function(e){n._settledAt(m,t,e)})};function D(e){var t=new this(d);if(!a(e))return C(t,new TypeError("You must pass an array to race.")),t;var n=e.length;function r(e){_(t,e)}function o(e){C(t,e)}for(var i=0;t._state===h&&i<n;i++)A(this.resolve(e[i]),void 0,r,o);return t}function F(e){if(e&&"object"==typeof e&&e.constructor===this)return e;var t=new this(d);return _(t,e),t}function R(e){var t=new this(d);return C(t,e),t}var N=0;var M=j;function j(e){this._id=N++,this._state=void 0,this._result=void 0,this._subscribers=[],d!==e&&(l(e)||function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof j||function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}(),function(t,e){try{e(function(e){_(t,e)},function(e){C(t,e)})}catch(e){C(t,e)}}(this,e))}return j.all=function(e){return new x(this,e).promise},j.race=D,j.resolve=F,j.reject=R,j._setScheduler=function(e){n=e},j._setAsap=function(e){s=e},j._asap=s,j.prototype={constructor:j,then:function(e,t){var n=this._state;if(n===g&&!e||n===m&&!t)return this;var r=new this.constructor(d),o=this._result;if(n){var i=arguments[n-1];s(function(){w(n,r,i,o)})}else A(this,r,e,t);return r},catch:function(e){return this.then(null,e)}},M}.call(this)},(r=t=e._Internal||(e._Internal={})).OfficePromise=function(){if("undefined"==typeof window&&"function"==typeof Promise)return Promise;if("undefined"!=typeof window){if(window.Promise)return window.Promise;var e=r.PromiseImpl.Init();return window.Promise=e}}(),e.OfficePromise=t.OfficePromise,e.Promise=e.OfficePromise}(Office=Office||{}),function(m){!function(o){var i,a=m.OUtil.Guid.generateNewGuid(),s=new RegExp("^https?://store\\.office(ppe|-int)?\\.com/","i"),c=!1,l="PRIVATE";o.enableTelemetry=!0;var u=function(){};o.AppInfo=u;var p=(e.prototype.getClientId=function(){var e=this.getValue(this.clientIDKey);return(!e||e.length<=0||40<e.length)&&(e=m.OUtil.Guid.generateNewGuid(),this.setValue(this.clientIDKey,e)),e},e.prototype.getValue=function(e){var t=m.OUtil.getLocalStorage(),n="";return t&&(n=t.getItem(e)),n},e.prototype.setValue=function(e,t){var n=m.OUtil.getLocalStorage();n&&n.setItem(e,t)},e);function e(){this.clientIDKey="Office API client",this.logIdSetKey="Office App Log Id Set"}function f(e){return(e=e&&e.replace(/[{}]/g,"").toLowerCase())||""}function t(){i&&(c||OTel.OTelLogger.onTelemetryLoaded(function(){var e=[],t=i.isMos?1:0;e=e.concat([oteljs.makeStringDataField("Browser",i.browser),oteljs.makeInt64DataField("AppSizeWidth",window.innerWidth),oteljs.makeInt64DataField("AppSizeHeight",window.innerHeight),oteljs.makeInt64DataField("IsMOS",t)]),Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AppActivatedX",dataFields:e,eventFlags:{dataCategories:2,diagnosticLevel:110,samplingPolicy:191}})}))}function n(e,t){}function d(){var e=0!=(m._OfficeAppFactory.getHostInfo().flags&m.HostInfoFlags.PublicAddin);return e||!!i&&r(m._OfficeAppFactory.getHostInfo().hostPlatform,i.hostVersion)}function h(e,t){return d()||t!==e?t:l}function r(e,t){var n=!1,r=/^(\d+)\.(\d+)\.(\d+)\.(\d+)$/.exec(t);if(r){var o=parseInt(r[1]),i=parseInt(r[2]),a=parseInt(r[3]);e==m.HostInfoPlatform.win32?(o<16||16==o&&a<14225)&&(n=!0):e==m.HostInfoPlatform.mac&&(o<16||16==o&&(i<52||52==i&&a<808))&&(n=!0)}return n}function g(){return 0!=(m._OfficeAppFactory.getHostInfo().flags&m.HostInfoFlags.IsMos)}o.initialize=function(e){if(o.enableTelemetry&&!i){i=new u,e.get_hostFullVersion()?i.hostVersion=e.get_hostFullVersion():i.hostVersion=e.get_appVersion(),i.appId=d()?e.get_id():l,i.marketplaceType=e._marketplaceType,i.host=""+e.get_appName(),i.browser=window.navigator.userAgent,i.correlationId=f(e.get_correlationId()),i.clientId=(new p).getClientId(),i.appInstanceId=e.get_appInstanceId(),i.appInstanceId&&(i.appInstanceId=f(i.appInstanceId),i.appInstanceId=h(e.get_id(),i.appInstanceId)),i.message=e.get_hostCustomMessage(),i.officeJSVersion=m.ConstantNames.FileVersion,i.hostJSVersion="NA",e._wacHostEnvironment&&(i.wacHostEnvironment=e._wacHostEnvironment);var t=e.get_isFromWacAutomation();null!=t&&(i.isFromWacAutomation=t.toString().toLowerCase());var n=e.get_docUrl();i.docUrl=s.test(n)?n:"";var r=location.href;r&&(i.isPreload=-1!==r.indexOf("preload=1"),r=r.split("?")[0].split("#")[0]),i.isMos=g(),function(e,t){t.assetId="",t.userId="";try{if(!m.Utility.isNullOrEmpty(e)){var n=decodeURIComponent(e),r=new DOMParser,o=void 0;if(m.LoadScriptHelper.trustedTypesOptIn()&&window.trustedTypes&&window.trustedTypes.createPolicy)o=window.trustedTypes.createPolicy("officejs-domparser",{createHTML:function(e){return e}}).createHTML(n);else o=n;var i=r.parseFromString(o,"text/xml"),a=i.getElementsByTagName("t")[0].attributes.getNamedItem("cid"),s=i.getElementsByTagName("t")[0].attributes.getNamedItem("oid");a&&a.nodeValue?t.userId=a.nodeValue:s&&s.nodeValue&&(t.userId=s.nodeValue),t.assetId=i.getElementsByTagName("t")[0].attributes.getNamedItem("aid").nodeValue}}catch(e){}}(e.get_eToken(),i),i.sessionId=a,OTel.OTelLogger.initialize(i),i.isPreload?c=!0:o.onAppActivated()}},o.onAppActivated=t,o.onScriptDone=function(e,t,n,r){},o.onCallDone=function(e,t,n,r,o){},o.onMethodDone=function(e,t,n,r){},o.onPropertyDone=function(e,t){m.AppTelemetry.onCallDone("property",-1,e,t,0)},o.onCheckWACHost=function(e,t,n,r,o){},o.onEventDone=function(e,t){m.AppTelemetry.onCallDone("event",e,null,0,t)},o.onRegisterDone=function(e,t,n,r){m.AppTelemetry.onCallDone(e?"registerevent":"unregisterevent",t,null,n,r)},o.onAppClosed=function(e,t){},o.setOsfControlAppCorrelationId=function(e){f(e)},o.doAppInitializationLogging=n,o.logAppCommonMessage=function(e){},o.logAppException=function(e){},o.CallOnAppActivatedIfPending=function(){c&&(c=!1,t())},o.canSendAddinId=d,o.getCompliantAppInstanceId=h,o._isComplianceExceptedHost=r,o.isMos=g}(m.AppTelemetry||(m.AppTelemetry={}))}(OSF=OSF||{}),function(i){var e=(n.loaded=function(){return!(void 0===n.logger)},n.create=function(e){var t,n={id:e.appId,marketplaceType:e.marketplaceType,assetId:e.assetId,officeJsVersion:e.officeJSVersion,hostJsVersion:e.hostJSVersion,browserToken:e.clientId,instanceId:e.appInstanceId,sessionId:e.sessionId},r=oteljs.Contracts.Office.System.SDX.getFields("SDX",n);if("web"===OSF._OfficeAppFactory.getHostInfo().hostPlatform)t=new i.SdxWacSink;else{if(!Office.context.requirements.isSetSupported("Telemetry","1.2"))return console.error("Cannot create telemetry sink successfully"),null;t=new i.RichApiSink,this.richApiSink=t}var o=new oteljs.SimpleTelemetryLogger(void 0,r);return o.addSink(t),o.setTenantToken("Office.Extensibility.OfficeJs","db334b301e7b474db5e0f02f07c51a47-a1b5bc36-1bbe-482f-a64a-c2d9cb606706-7439",1755),oteljs.onNotification().addListener(function(e){OSF.Utility.debugLog(e.message())}),o},n.checkAndResolvePromises=function(){n.loaded()&&(n.promises.forEach(function(e){e()}),n.promises=[])},n.initialize=function(e){n.Enabled?Office.onReadyInternal().then(function(){n.loaded()||(OSF.Utility.debugLog("Creating OTelLogger"),n.logger=n.create(e),n.checkAndResolvePromises())}):n.promises=[]},n.sendTelemetryEvent=function(e){n.onTelemetryLoaded(function(){try{n.logger.sendTelemetryEvent(e),OSF.Utility.debugLog("Sent telemetry")}catch(e){console.error("Cannot send telemetry event: "+JSON.stringify(e))}})},n.sendNonStandardEvent=function(e,t){n.onTelemetryLoaded(function(){try{n.logger.sendNonStandardEvent(e,t),OSF.Utility.debugLog("Sent telemetry")}catch(e){console.error("Cannot send telemetry event: "+JSON.stringify(e))}})},n.flushTelemetryQueue=function(){var t=this;return new Office.Promise(function(e){n.onTelemetryLoaded(function(){t.richApiSink?t.richApiSink.flushTelemetryQueue().then(function(){e()}):e()})})},n.onTelemetryLoaded=function(e){n.Enabled&&(n.loaded()?e():n.promises.push(e))},n.promises=[],n.Enabled=!0,n);function n(){}i.OTelLogger=e}(OTel=OTel||{}),function(e){var t=(n.prototype.sendTelemetryEvent=function(e){this._telemetryQueue.push([e,1]),this._requestIsPending||this.processWorkBacklog()},n.prototype.sendNonStandardEvent=function(e,t){this._telemetryQueue.push([e,t]),this._requestIsPending||this.processWorkBacklog()},n.prototype.flushTelemetryQueue=function(){var n=this;return new Office.Promise(function(e){var t=n._telemetryQueue;n._telemetryQueue=[],n.processTelemetryEvents(t).then(function(){e()})})},n.prototype.processWorkBacklog=function(){var t=this;this._requestIsPending=!0;var e=this._telemetryQueue;this._telemetryQueue=[],this.processTelemetryEvents(e).then(this.waitAndProcessMore.bind(this)).catch(function(e){oteljs.logError(1,"RichApiSink Error",e),t.waitAndProcessMore.bind(t)()})},n.prototype.waitAndProcessMore=function(){var e=this;this.pause(1e3).then(function(){0<e._telemetryQueue.length&&setTimeout(function(){return e.processWorkBacklog()},0),e._requestIsPending=!1}).catch(function(){})},n.prototype.processTelemetryEvents=function(e){var i=this,a=new OfficeCore.RequestContext;return e.forEach(function(e){var t=e[0],n=e[1];if(t.telemetryProperties){var r=[];i.addDataFields(r,t.dataFields);var o=t.eventContract?t.eventContract.name:"";t.eventContract&&i.addDataFields(r,t.eventContract.dataFields),1===n?a.telemetry.sendTelemetryEvent(t.telemetryProperties,t.eventName,o,oteljs.getEffectiveEventFlags(t),r):a.telemetry.sendNonStandardEvent(t.telemetryProperties,t.eventName,o,oteljs.getEffectiveEventFlags(t),r,n)}}),a.sync().catch(function(){oteljs.logNotification(2,1,function(){return"RichApi telemetry call failed."})})},n.prototype.addDataFields=function(t,e){e&&e.forEach(function(e){t.push({name:e.name,value:e.value,classification:e.classification?e.classification:4,type:e.dataType})})},n.prototype.pause=function(t){return new Office.Promise(function(e){return setTimeout(e,t)})},n);function n(){var t=this;this._requestIsPending=!0,this._telemetryQueue=[],this.pause(1e3).then(function(){var e=t._telemetryQueue;t._telemetryQueue=[],t._requestIsPending=!1,t.processTelemetryEvents(e)})}e.RichApiSink=t}(OTel=OTel||{}),function(e){var t=(n.prototype.sendTelemetryEvent=function(e,t){try{if(e.dataFields&&0<e.dataFields.filter(function(e){var t=e.classification;return t&&4!==t&&1!==t}).length)return;var n=OSF._OfficeAppFactory.getId(),r=OSF.AgaveHostAction.SendTelemetryEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n,r,e])}catch(e){oteljs.logError(1,"AgaveWacSink",e)}},n.prototype.sendNonStandardEvent=function(e,t){try{if(1===t)throw new Error("Please call sendTelemetryEvent for events of type "+t);if(e.dataFields&&0<e.dataFields.filter(function(e){var t=e.classification;return t&&4!==t&&1!==t&&32!==t&&2048!==t}).length)return;var n=OSF._OfficeAppFactory.getId(),r=OSF.AgaveHostAction.SendNonStandardEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n,r,e])}catch(e){oteljs.logError(1,"AgaveWacSink",e)}},n);function n(){}e.SdxWacSink=t}(OTel=OTel||{}),function(){var t,e=[];function p(e,t,n){OTel.OTelLogger.onTelemetryLoaded(function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionRequest",dataFields:[oteljs.makeStringDataField("invocationId",e),oteljs.makeStringDataField("methodPath",t),oteljs.makeStringDataField("params",n)],eventFlags:{dataCategories:2,diagnosticLevel:110}})})}function f(e,t,n){OTel.OTelLogger.onTelemetryLoaded(function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionResponse",dataFields:[oteljs.makeStringDataField("invocationId",e),oteljs.makeBooleanDataField("isSuccessful",t),oteljs.makeStringDataField("error",n?JSON.stringify({name:n.name,code:n.code,message:n.message}):void 0)],eventFlags:{dataCategories:2,diagnosticLevel:110}})})}try{function n(o){var i=Navigator.prototype[o];i&&(Navigator.prototype[o]=function(e,t,n){if(3===arguments.length&&Function.prototype.isPrototypeOf(t)&&Function.prototype.isPrototypeOf(n)){var r=(d++).toString();return p(r,"Navigator.prototype."+o,JSON.stringify([{audio:!!e.audio,video:!!e.video}])),i.apply(this,[e,function(){return f(r,!0),t.apply(this,arguments)},function(){return f(r,!1,arguments[0]),n.apply(this,arguments)}])}return i.apply(this,arguments)},e.push("Navigator.prototype."+o))}for(var d=0,r=0,o=["getUserMedia","webkitGetUserMedia","mozGetUserMedia"];r<o.length;r++){n(o[r])}var i=MediaDevices.prototype.getUserMedia;i&&(MediaDevices.prototype.getUserMedia=function(e){var t=(d++).toString();return 1===arguments.length&&void 0!==e?(p(t,"MediaDevices.prototype.getUserMedia",JSON.stringify([{audio:!!e.audio,video:!!e.video}])),i.apply(this,arguments).then(function(){return f(t,!0),arguments[0]},function(){throw f(t,!1,arguments[0]),arguments[0]})):i.apply(this,arguments)},e.push("MediaDevices.prototype.getUserMedia"));function a(l){var u=Geolocation.prototype[l];u&&(Geolocation.prototype[l]=function(e,t,n){for(var r=[],o=3;o<arguments.length;o++)r[o-3]=arguments[o];var i=(d++).toString(),a=!1;p(i,"Geolocation.prototype."+l,JSON.stringify([]));var s=Function.prototype.isPrototypeOf(e)?function(){return a||(f(i,!0),a=!0),e.apply(this,arguments)}:e,c=Function.prototype.isPrototypeOf(t)?function(){return a||(f(i,!1,arguments[0]),a=!0),t.apply(this,arguments)}:t;return u.apply(this,[s,c,n].concat(r))},e.push("Geolocation.prototype."+l))}for(var s=0,c=["getCurrentPosition","watchPosition"];s<c.length;s++){a(c[s])}}catch(e){t=e.toString()}OTel.OTelLogger.onTelemetryLoaded(function(){Microsoft.Office.WebExtension.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.AddinSpecialPermissionHookInstall",dataFields:[oteljs.makeStringDataField("hooksInstalled",JSON.stringify(e)),oteljs.makeStringDataField("error",t)],eventFlags:{dataCategories:2,diagnosticLevel:110}})})}(Office=Office||{}),function(e){var t,n;t=e.Office||(e.Office={}),(n=t.WebExtension||(t.WebExtension={})).FeatureGates={},n.EventType=OSF.EventType,n.sendTelemetryEvent=function(e){OTel.OTelLogger.sendTelemetryEvent(e)},n.sendNonStandardEvent=function(e,t){OTel.OTelLogger.sendNonStandardEvent(e,t)},n.flushTelemetryQueue=function(){return OTel.OTelLogger.flushTelemetryQueue()},n.telemetrySink=OTel.OTelLogger}(Microsoft=Microsoft||{}),function(o){o.sendTelemetryEvent=function(e){Microsoft.Office.WebExtension.sendTelemetryEvent(e)},o.sendNonStandardEvent=function(e,t){Microsoft.Office.WebExtension.sendNonStandardEvent(e,t)},o.flushTelemetryQueue=function(){return Microsoft.Office.WebExtension.flushTelemetryQueue()},o.telemetrySink=Microsoft.Office.WebExtension.telemetrySink,o.isTrustedHost=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return e.trys.push([0,6,,7]),OSF._OfficeAppFactory.getHostInfo().hostPlatform===OSF.HostInfoPlatform.web?[3,2]:[4,o.onReady()];case 1:return e.sent(),[2,!0];case 2:return null!=(t=OSF._OfficeAppFactory.getWebAppState().clientEndPoint)&&t.fHostTrusted||null!=document.referrer&&(n=OSF.OUtil.parseUrl(document.referrer,!1),"https:"==n.protocol&&OSF.XdmCommunicationManager.isHostNameValidWacDomain(n.hostname)&&!new RegExp("^"+document.domain.replace(new RegExp("\\.","g"),"\\.")+"$").test(n.hostname))?[2,!0]:null==t?[3,4]:[4,OSF.Utility.promisify(function(e){t.invoke("ContextActivationManager_getAppContextAsync",e,OSF._OfficeAppFactory.getWebAppState().id)},1e4)];case 3:return e.sent(),[2,!0];case 4:return[2,!1];case 5:return[3,7];case 6:return r=e.sent(),OSF.AppTelemetry&&OSF.AppTelemetry.logAppException("Exception happens at Office.isTrustedHost."+r),[2,!1];case 7:return[2]}})})},Microsoft.Office.WebExtension.onReadyInternal=o.onReadyInternal}(Office=Office||{});var OfficeExtension;__extends=this&&this.__extends||function(){var r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)};return function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}}();!function(m){var a,e;(e=a=m.RemoteEndpointType||(m.RemoteEndpointType={})).graph="graph",e.wfe="wfe";var y=(t.prototype._resolveRequestUrlAndHeaderInfo=function(){return C._createPromiseFromResult(null)},t.prototype._createRequestExecutorOrNull=function(){return null},t.prototype.getEventRegistration=function(e){return null},t);function t(){}m.SessionBase=y;var s=(n.setCustomSendRequestFunc=function(e){n.s_customSendRequestFunc=e},n.xhrSendRequestFunc=function(o){return C.createPromise(function(t,e){var n=new XMLHttpRequest;if(n.open(o.method,o.url),n.onload=function(){var e={statusCode:n.status,headers:C._parseHttpResponseHeaders(n.getAllResponseHeaders()),body:n.responseText};t(e)},n.onerror=function(){e(new h.RuntimeError({code:g.connectionFailure,httpStatusCode:n.status,message:C._getResourceString(v.connectionFailureWithStatus,n.statusText)}))},o.headers)for(var r in o.headers)n.setRequestHeader(r,o.headers[r]);n.send(C._getRequestBodyText(o))})},n.fetchSendRequestFunc=function(e){var t=C._getRequestBodyText(e);return""===t&&(t=void 0),fetch(e.url,{method:e.method,headers:e.headers,body:t}).then(function(r){return r.text().then(function(e){var t=r.status,n={};return r.headers.forEach(function(e,t){n[t]=e}),{statusCode:t,headers:n,body:e}})})},n.sendRequest=function(e){n.validateAndNormalizeRequest(e);var t=n.s_customSendRequestFunc;return(t=t||("undefined"!=typeof fetch?n.fetchSendRequestFunc:n.xhrSendRequestFunc))(e)},n.setCustomSendLocalDocumentRequestFunc=function(e){n.s_customSendLocalDocumentRequestFunc=e},n.sendLocalDocumentRequest=function(e){return n.validateAndNormalizeRequest(e),(n.s_customSendLocalDocumentRequestFunc||n.officeJsSendLocalDocumentRequestFunc)(e)},n.officeJsSendLocalDocumentRequestFunc=function(e){e=C._validateLocalDocumentRequest(e);var t=C._buildRequestMessageSafeArray(e);return C.createPromise(function(n,e){OSF.DDA.RichApi.executeRichApiRequestAsync(t,function(e){var t;t="succeeded"==e.status?{statusCode:O.getResponseStatusCode(e),headers:O.getResponseHeaders(e),body:O.getResponseBody(e)}:O.buildHttpResponseFromOfficeJsError(e.error.code,e.error.message),C.log("Response:"),C.log(JSON.stringify(t)),n(t)})})},n.validateAndNormalizeRequest=function(e){if(C.isNullOrUndefined(e))throw h.RuntimeError._createInvalidArgError({argumentName:"request"});C.isNullOrEmptyString(e.method)&&(e.method="GET"),e.method=e.method.toUpperCase();var t=!1;if("object"==typeof e.headers&&e.headers[d.testRequestNameHeader]&&(t=!0),!t){var n=P._getCurrentTestNameWithSequenceId();n&&(e.headers||(e.headers={}),e.headers[d.testRequestNameHeader]=n)}},n.logRequest=function(e){if(C._logEnabled){if(C.log("---HTTP Request---"),C.log(e.method+" "+e.url),e.headers)for(var t in e.headers)C.log(t+": "+e.headers[t]);n._logBodyEnabled&&C.log(C._getRequestBodyText(e))}},n.logResponse=function(e){if(C._logEnabled){if(C.log("---HTTP Response---"),C.log(""+e.statusCode),e.headers)for(var t in e.headers)C.log(t+": "+e.headers[t]);n._logBodyEnabled&&C.log(e.body)}},n._logBodyEnabled=!1,n);function n(){}m.HttpUtility=s;var h,r,o,i,c=(l.init=function(e){if("object"==typeof e&&e){var a=new l(e);l.s_instance=a,s.setCustomSendLocalDocumentRequestFunc(function(e){e=C._validateLocalDocumentRequest(e);var t=0;C.isReadonlyRestRequest(e.method)||(t=1);var n=e.url.indexOf("?");if(0<=n){var r=e.url.substr(n+1),o=C._parseRequestFlagsAndCustomDataFromQueryStringIfAny(r);0<=o.flags&&(t=o.flags)}"string"==typeof e.body&&(e.body=JSON.parse(e.body));var i={id:l.nextId(),type:1,flags:t,message:e};return a.sendMessageToHostAndExpectResponse(i).then(function(e){return e.message})});for(var t=0;t<l.s_onInitedHandlers.length;t++)l.s_onInitedHandlers[t](a)}},Object.defineProperty(l,"instance",{get:function(){return l.s_instance},enumerable:!0,configurable:!0}),l.prototype.sendMessageToHost=function(e){this.m_bridge.sendMessageToHost(JSON.stringify(e))},l.prototype.sendMessageToHostAndExpectResponse=function(n){var r=this,e=C.createPromise(function(e,t){r.m_promiseResolver[n.id]=e});return this.m_bridge.sendMessageToHost(JSON.stringify(n)),e},l.prototype.addHostMessageHandler=function(e){this.m_handlers.push(e)},l.prototype.removeHostMessageHandler=function(e){var t=this.m_handlers.indexOf(e);0<=t&&this.m_handlers.splice(t,1)},l.onInited=function(e){l.s_onInitedHandlers.push(e),l.s_instance&&e(l.s_instance)},l.prototype.dispatchMessage=function(e){if("number"==typeof e.id){var t=this.m_promiseResolver[e.id];if(t)return t(e),void delete this.m_promiseResolver[e.id]}for(var n=0;n<this.m_handlers.length;n++)this.m_handlers[n](e)},l.nextId=function(){return l.s_nextId++},l.s_onInitedHandlers=[],l.s_nextId=1,l);function l(e){var a=this;this.m_bridge=e,this.m_promiseResolver={},this.m_handlers=[],this.m_bridge.onMessageFromHost=function(e){var t=JSON.parse(e);if(3==t.type){var n=t.message;if(n&&n.entries)for(var r=0;r<n.entries.length;r++){var o=n.entries[r];if(Array.isArray(o)){var i={messageCategory:o[0],messageType:o[1],targetId:o[2],message:o[3],id:o[4]};n.entries[r]=i}}}a.dispatchMessage(t)}}function u(e){var t=o.call(this,"string"==typeof e?e:e.message)||this;if(Object.setPrototypeOf(t,u.prototype),t.name="RichApi.Error","string"==typeof e?t.message=e:(t.code=e.code,t.message=e.message,t.traceMessages=e.traceMessages||[],t.innerError=e.innerError||null,t.debugInfo=t._createDebugInfo(e.debugInfo||{}),t.httpStatusCode=e.httpStatusCode,t.data=e.data),C.isNullOrUndefined(t.httpStatusCode)||200===t.httpStatusCode){var n={};n[g.accessDenied]=401,n[g.connectionFailure]=500,n[g.generalException]=500,n[g.invalidArgument]=400,n[g.invalidObjectPath]=400,n[g.invalidOrTimedOutSession]=408,n[g.invalidRequestContext]=400,n[g.timeout]=408,n[g.valueNotLoaded]=400,t.httpStatusCode=n[t.code]}return C.isNullOrUndefined(t.httpStatusCode)&&(t.httpStatusCode=500),t}m.HostBridge=c,"object"==typeof _richApiNativeBridge&&_richApiNativeBridge&&c.init(_richApiNativeBridge),r=h=m._Internal||(m._Internal={}),o=Error,__extends(u,o),u.prototype.toString=function(){return this.code+": "+this.message},u.prototype._createDebugInfo=function(e){var t={code:this.code,message:this.message,toString:function(){return JSON.stringify(this)}};for(var n in e)t[n]=e[n];return this.innerError&&(this.innerError instanceof r.RuntimeError?t.innerError=this.innerError.debugInfo:t.innerError=this.innerError),t},u._createInvalidArgError=function(e){return new r.RuntimeError({code:g.invalidArgument,httpStatusCode:400,message:C.isNullOrEmptyString(e.argumentName)?C._getResourceString(v.invalidArgumentGeneric):C._getResourceString(v.invalidArgument,e.argumentName),debugInfo:e.errorLocation?{errorLocation:e.errorLocation}:{},innerError:e.innerError})},i=u,r.RuntimeError=i,m.Error=h.RuntimeError;var g=(p.apiNotFound="ApiNotFound",p.accessDenied="AccessDenied",p.generalException="GeneralException",p.activityLimitReached="ActivityLimitReached",p.invalidArgument="InvalidArgument",p.connectionFailure="ConnectionFailure",p.timeout="Timeout",p.invalidOrTimedOutSession="InvalidOrTimedOutSession",p.invalidObjectPath="InvalidObjectPath",p.invalidRequestContext="InvalidRequestContext",p.valueNotLoaded="ValueNotLoaded",p.requestPayloadSizeLimitExceeded="RequestPayloadSizeLimitExceeded",p.responsePayloadSizeLimitExceeded="ResponsePayloadSizeLimitExceeded",p.writeNotSupportedWhenModalDialogOpen="WriteNotSupportedWhenModalDialogOpen",p.undoNotSupported="UndoNotSupported",p);function p(){}m.CoreErrorCodes=g;var v=(f.apiNotFoundDetails="ApiNotFoundDetails",f.connectionFailureWithStatus="ConnectionFailureWithStatus",f.connectionFailureWithDetails="ConnectionFailureWithDetails",f.invalidArgument="InvalidArgument",f.invalidArgumentGeneric="InvalidArgumentGeneric",f.timeout="Timeout",f.invalidOrTimedOutSessionMessage="InvalidOrTimedOutSessionMessage",f.invalidSheetName="InvalidSheetName",f.invalidObjectPath="InvalidObjectPath",f.invalidRequestContext="InvalidRequestContext",f.valueNotLoaded="ValueNotLoaded",f);function f(){}m.CoreResourceStrings=v;var d=(b.flags="flags",b.sourceLibHeader="SdkVersion",b.processQuery="ProcessQuery",b.localDocument="http://document.localhost/",b.localDocumentApiPrefix="http://document.localhost/_api/",b.customData="customdata",b.testRequestNameHeader="x-test-request-name",b);function b(){}m.CoreConstants=d;var _,O=(S.buildMessageArrayForIRequestExecutor=function(e,t,n,r){var o=JSON.stringify(n.Body);C.log("Request:"),C.log(o);var i={};return C._copyHeaders(n.Headers,i),i[d.sourceLibHeader]=r,S.buildRequestMessageSafeArray(e,t,"POST",d.processQuery,i,o)},S.buildResponseOnSuccess=function(e,t){var n={HttpStatusCode:200,ErrorCode:"",ErrorMessage:"",Headers:null,Body:null};return n.Body=JSON.parse(e),n.Headers=t,n},S.buildResponseOnError=function(e,t){var n={HttpStatusCode:500,ErrorCode:"",ErrorMessage:"",Headers:null,Body:null};return n.ErrorCode=g.generalException,n.ErrorMessage=t,e==S.OfficeJsErrorCode_ooeNoCapability?(n.ErrorCode=g.accessDenied,n.HttpStatusCode=401):e==S.OfficeJsErrorCode_ooeActivityLimitReached?(n.ErrorCode=g.activityLimitReached,n.HttpStatusCode=429):e==S.OfficeJsErrorCode_ooeInvalidOrTimedOutSession?(n.ErrorCode=g.invalidOrTimedOutSession,n.HttpStatusCode=408,n.ErrorMessage=C._getResourceString(v.invalidOrTimedOutSessionMessage)):e==S.OfficeJsErrorCode_ooeRequestPayloadSizeLimitExceeded?(n.ErrorCode=g.requestPayloadSizeLimitExceeded,n.HttpStatusCode=400):e==S.OfficeJsErrorCode_ooeResponsePayloadSizeLimitExceeded?(n.ErrorCode=g.responsePayloadSizeLimitExceeded,n.HttpStatusCode=400):e==S.OfficeJsErrorCode_ooeWriteNotSupportedWhenModalDialogOpen?(n.ErrorCode=g.writeNotSupportedWhenModalDialogOpen,n.HttpStatusCode=400):e==S.OfficeJsErrorCode_ooeInvalidSheetName?(n.ErrorCode=g.invalidRequestContext,n.HttpStatusCode=400,n.ErrorMessage=C._getResourceString(v.invalidSheetName)):e==S.OfficeJsErrorCode_ooeUndoNotSupported&&(n.ErrorCode=g.undoNotSupported,n.HttpStatusCode=400),n},S.buildHttpResponseFromOfficeJsError=function(e,t){var n=500,r={error:{}};return r.error.code=g.generalException,r.error.message=t,e===S.OfficeJsErrorCode_ooeNoCapability?(n=403,r.error.code=g.accessDenied):e===S.OfficeJsErrorCode_ooeActivityLimitReached&&(n=429,r.error.code=g.activityLimitReached),{statusCode:n,headers:{},body:JSON.stringify(r)}},S.buildRequestMessageSafeArray=function(e,t,n,r,o,i){var a=[];if(o)for(var s in o)a.push(s),a.push(o[s]);return[e,n,r,a,i,0,t,"","","","","",""]},S.getResponseBody=function(e){return S.getResponseBodyFromSafeArray(e.value.data)},S.getResponseHeaders=function(e){return S.getResponseHeadersFromSafeArray(e.value.data)},S.getResponseBodyFromSafeArray=function(e){var t=e[2];return"string"==typeof t?t:t.join("")},S.getResponseHeadersFromSafeArray=function(e){var t=e[1];if(!t)return null;for(var n={},r=0;r<t.length-1;r+=2)n[t[r]]=t[r+1];return n},S.getResponseStatusCode=function(e){return S.getResponseStatusCodeFromSafeArray(e.value.data)},S.getResponseStatusCodeFromSafeArray=function(e){return e[0]},S.OfficeJsErrorCode_ooeInvalidOrTimedOutSession=5012,S.OfficeJsErrorCode_ooeActivityLimitReached=5102,S.OfficeJsErrorCode_ooeNoCapability=7e3,S.OfficeJsErrorCode_ooeRequestPayloadSizeLimitExceeded=5103,S.OfficeJsErrorCode_ooeResponsePayloadSizeLimitExceeded=5104,S.OfficeJsErrorCode_ooeWriteNotSupportedWhenModalDialogOpen=5016,S.OfficeJsErrorCode_ooeInvalidSheetName=1014,S.OfficeJsErrorCode_ooeUndoNotSupported=5017,S);function S(){}m.RichApiMessageUtility=O,(_=h=m._Internal||(m._Internal={})).getPromiseType=function(){if("undefined"!=typeof Promise)return Promise;if(void 0!==Office&&Office.Promise)return Office.Promise;if(void 0!==OfficeExtension&&OfficeExtension.Promise)return OfficeExtension.Promise;throw new _.Error("No Promise implementation found")};var C=(A.log=function(e){A._logEnabled&&"undefined"!=typeof console&&console.log&&console.log(e)},A.checkArgumentNull=function(e,t){if(A.isNullOrUndefined(e))throw h.RuntimeError._createInvalidArgError({argumentName:t})},A.isNullOrUndefined=function(e){return null==e},A.isUndefined=function(e){return void 0===e},A.isNullOrEmptyString=function(e){return null==e||0==e.length},A.isPlainJsonObject=function(e){if(A.isNullOrUndefined(e))return!1;if("object"!=typeof e)return!1;if("[object Object]"!==Object.prototype.toString.apply(e))return!1;if(e.constructor&&!Object.prototype.hasOwnProperty.call(e,"constructor")&&!Object.prototype.hasOwnProperty.call(e.constructor.prototype,"hasOwnProperty"))return!1;for(var t in e)if(!Object.prototype.hasOwnProperty.call(e,t))return!1;return!0},A.trim=function(e){return e.replace(new RegExp("^\\s+|\\s+$","g"),"")},A.caseInsensitiveCompareString=function(e,t){return A.isNullOrUndefined(e)?A.isNullOrUndefined(t):!A.isNullOrUndefined(t)&&e.toUpperCase()==t.toUpperCase()},A.isReadonlyRestRequest=function(e){return A.caseInsensitiveCompareString(e,"GET")},A._getResourceString=function(e,t){var n;if("undefined"!=typeof window&&window.Strings&&window.Strings.OfficeOM){var r="L_"+e,o=window.Strings.OfficeOM[r];o&&(n=o)}return n=(n=n||A.s_resourceStringValues[e])||e,A.isNullOrUndefined(t)||(n=Array.isArray(t)?A._formatString(n,t):n.replace("{0}",t)),n},A._formatString=function(e,n){return e.replace(/\{\d\}/g,function(e){var t=parseInt(e.substr(1,e.length-2));if(t<n.length)return n[t];throw h.RuntimeError._createInvalidArgError({argumentName:"format"})})},Object.defineProperty(A,"Promise",{get:function(){return h.getPromiseType()},enumerable:!0,configurable:!0}),A.createPromise=function(e){return new A.Promise(e)},A._createPromiseFromResult=function(n){return A.createPromise(function(e,t){e(n)})},A._createPromiseFromException=function(n){return A.createPromise(function(e,t){t(n)})},A._createTimeoutPromise=function(n){return A.createPromise(function(e,t){setTimeout(function(){e(null)},n)})},A._createInvalidArgError=function(e){return h.RuntimeError._createInvalidArgError(e)},A._isLocalDocumentUrl=function(e){return 0<A._getLocalDocumentUrlPrefixLength(e)},A._getLocalDocumentUrlPrefixLength=function(e){for(var t=["http://document.localhost","https://document.localhost","//document.localhost"],n=e.toLowerCase().trim(),r=0;r<t.length;r++){if(n===t[r])return t[r].length;if(n.substr(0,t[r].length+1)===t[r]+"/")return t[r].length+1}return 0},A._validateLocalDocumentRequest=function(e){var t=A._getLocalDocumentUrlPrefixLength(e.url);if(t<=0)throw h.RuntimeError._createInvalidArgError({argumentName:"request"});var n=e.url.substr(t),r=n.toLowerCase();return"_api"===r?n="":"_api/"===r.substr(0,"_api/".length)&&(n=n.substr("_api/".length)),{method:e.method,url:n,headers:e.headers,body:e.body}},A._parseRequestFlagsAndCustomDataFromQueryStringIfAny=function(e){for(var t={flags:-1,customData:""},n=e.split("&"),r=0;r<n.length;r++){var o=n[r].split("=");if(o[0].toLowerCase()===d.flags){var i=parseInt(o[1]);i&=32767,t.flags=i}else o[0].toLowerCase()===d.customData&&(t.customData=decodeURIComponent(o[1]))}return t},A._getRequestBodyText=function(e){var t="";return"string"==typeof e.body?t=e.body:e.body&&"object"==typeof e.body&&(t=JSON.stringify(e.body)),t},A._parseResponseBody=function(e){if("string"!=typeof e.body)return e.body;var t=A.trim(e.body);return JSON.parse(t)},A._buildRequestMessageSafeArray=function(e){var t=0;A.isReadonlyRestRequest(e.method)||(t=1);var n="";if(e.url.substr(0,d.processQuery.length).toLowerCase()===d.processQuery.toLowerCase()){var r=e.url.indexOf("?");if(0<r){var o=e.url.substr(r+1),i=A._parseRequestFlagsAndCustomDataFromQueryStringIfAny(o);0<=i.flags&&(t=i.flags),n=i.customData}}return O.buildRequestMessageSafeArray(n,t,e.method,e.url,e.headers,A._getRequestBodyText(e))},A._parseHttpResponseHeaders=function(e){var t={};if(!A.isNullOrEmptyString(e))for(var n=new RegExp("\r?\n"),r=e.split(n),o=0;o<r.length;o++){var i=r[o];if(null!=i){var a=i.indexOf(":");if(0<a){var s=i.substr(0,a),c=i.substr(a+1);s=A.trim(s),c=A.trim(c),t[s.toUpperCase()]=c}}}return t},A._parseErrorResponse=function(e){var t=A._parseErrorResponseBody(e),n=e.statusCode.toString();if(A.isNullOrUndefined(t)||"object"!=typeof t||!t.error)return A._createDefaultErrorResponse(n);var r=t.error,o=r.innerError;return o&&o.code?A._createErrorResponse(o.code,n,o.message):r.code?A._createErrorResponse(r.code,n,r.message):A._createDefaultErrorResponse(n)},A._parseErrorResponseBody=function(e){if(A.isPlainJsonObject(e.body))return e.body;if(!A.isNullOrEmptyString(e.body)){var t=A.trim(e.body);try{return JSON.parse(t)}catch(e){A.log("Error when parse "+t)}}},A._createDefaultErrorResponse=function(e){return{errorCode:g.connectionFailure,errorMessage:A._getResourceString(v.connectionFailureWithStatus,e)}},A._createErrorResponse=function(e,t,n){return{errorCode:e,errorMessage:A._getResourceString(v.connectionFailureWithDetails,[t,e,n])}},A._copyHeaders=function(e,t){if(e&&t)for(var n in e)t[n]=e[n]},A.addResourceStringValues=function(e){for(var t in e)A.s_resourceStringValues[t]=e[t]},A._logEnabled=!1,A.s_resourceStringValues={ApiNotFoundDetails:"The method or property {0} is part of the {1} requirement set, which is not available in your version of {2}.",ConnectionFailureWithStatus:"The request failed with status code of {0}.",ConnectionFailureWithDetails:"The request failed with status code of {0}, error code {1} and the following error message: {2}",InvalidArgument:"The argument '{0}' doesn't work for this situation, is missing, or isn't in the right format.",InvalidObjectPath:'The object path \'{0}\' isn\'t working for what you\'re trying to do. If you\'re using the object across multiple "context.sync" calls and outside the sequential execution of a ".run" batch, please use the "context.trackedObjects.add()" and "context.trackedObjects.remove()" methods to manage the object\'s lifetime.',InvalidRequestContext:"Cannot use the object across different request contexts.",Timeout:"The operation has timed out.",ValueNotLoaded:'The value of the result object has not been loaded yet. Before reading the value property, call "context.sync()" on the associated request context.'},A);function A(){}m.CoreUtility=C;var P=(E.setMock=function(e){E.s_isMock=e},E.isMock=function(){return E.s_isMock},E._setCurrentTestName=function(e){E.s_currentTestName=e,E.s_currentTestSequenceId=0},E._getCurrentTestNameWithSequenceId=function(){return E.s_currentTestName?E.s_currentTestName+"."+ ++E.s_currentTestSequenceId:null},E);function E(){}m.TestUtility=P,m._internalConfig={showDisposeInfoInDebugInfo:!1,showInternalApiInDebugInfo:!1,enableEarlyDispose:!0,alwaysPolyfillClientObjectUpdateMethod:!1,alwaysPolyfillClientObjectRetrieveMethod:!1,enableConcurrentFlag:!0,enableUndoableFlag:!0,appendTypeNameToObjectPathInfo:!1,enablePreviewExecution:!1},m.config={extendedErrorLogging:!1};var T=(w.createSetPropertyAction=function(e,t,n,r,o){$.validateObjectPath(t);var i={Id:e._nextId(),ActionType:4,Name:n,ObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}},a=[r],s=$.setMethodArguments(e,i.ArgumentInfo,a);$.validateReferencedObjectPaths(s);var c=new D(i,0,o);if(c.referencedObjectPath=t._objectPath,c.referencedArgumentObjectPaths=s,m._internalConfig.enablePreviewExecution&&0!=(16&o)){var l={Id:e._nextId(),ActionType:4,Name:n,ObjectId:"",ObjectType:"",Arguments:[r]};t._addPreviewExecutionAction(l)}return t._addAction(c)},w.createQueryAction=function(e,t,n,r){$.validateObjectPath(t);var o={Id:e._nextId(),ActionType:2,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,QueryInfo:n},i=new D(o,1,4);return i.referencedObjectPath=t._objectPath,t._addAction(i,r)},w.createQueryAsJsonAction=function(e,t,n,r){$.validateObjectPath(t);var o={Id:e._nextId(),ActionType:7,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,QueryInfo:n},i=new D(o,1,4);return i.referencedObjectPath=t._objectPath,t._addAction(i,r)},w.createUpdateAction=function(e,t,n){$.validateObjectPath(t);var r={Id:e._nextId(),ActionType:9,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,ObjectState:n},o=new D(r,0,0);return o.referencedObjectPath=t._objectPath,t._addAction(o)},w);function w(){}m.CommonActionFactory=T;var I=(Object.defineProperty(x.prototype,"_objectPath",{get:function(){return this.m_objectPath},enumerable:!0,configurable:!0}),Object.defineProperty(x.prototype,"_context",{get:function(){return this.m_contextBase},enumerable:!0,configurable:!0}),x.prototype._addAction=function(n,r){var o=this;return void 0===r&&(r=null),C.createPromise(function(e,t){o._context._addServiceApiAction(n,r,e,t)})},x.prototype._addPreviewExecutionAction=function(e){},x.prototype._retrieve=function(e,t){var n=m._internalConfig.alwaysPolyfillClientObjectRetrieveMethod;n=n||!$.isSetSupported("RichApiRuntime","1.1");var r=M._parseQueryOption(e);return n?T.createQueryAction(this._context,this,r,t):T.createQueryAsJsonAction(this._context,this,r,t)},x.prototype._recursivelyUpdate=function(e){var t=m._internalConfig.alwaysPolyfillClientObjectUpdateMethod;t=t||!$.isSetSupported("RichApiRuntime","1.2");try{var n=this[K.scalarPropertyNames];n=n||[];var r=this[K.scalarPropertyUpdateable];if(!r){r=[];for(var o=0;o<n.length;o++)r.push(!1)}var i=this[K.navigationPropertyNames];i=i||[];var a={},s={},c=0;for(var l in e){var u=n.indexOf(l);if(0<=u){if(!r[u])throw new h.RuntimeError({code:g.invalidArgument,httpStatusCode:400,message:C._getResourceString(ee.attemptingToSetReadOnlyProperty,l),debugInfo:{errorLocation:l}});a[l]=e[l],++c}else{if(!(0<=i.indexOf(l)))throw new h.RuntimeError({code:g.invalidArgument,httpStatusCode:400,message:C._getResourceString(ee.propertyDoesNotExist,l),debugInfo:{errorLocation:l}});s[l]=e[l]}}if(0<c)if(t)for(o=0;o<n.length;o++){var p=a[l=n[o]];$.isUndefined(p)||T.createSetPropertyAction(this._context,this,l,p)}else T.createUpdateAction(this._context,this,a);for(var l in s){var f=this[l],d=s[l];f._recursivelyUpdate(d)}}catch(e){throw new h.RuntimeError({code:g.invalidArgument,httpStatusCode:400,message:C._getResourceString(v.invalidArgument,"properties"),debugInfo:{errorLocation:this._className+".update"},innerError:e})}},x);function x(e,t){this.m_contextBase=e,this.m_objectPath=t}m.ClientObjectBase=I;var D=(Object.defineProperty(F.prototype,"actionInfo",{get:function(){return this.m_actionInfo},enumerable:!0,configurable:!0}),Object.defineProperty(F.prototype,"operationType",{get:function(){return this.m_operationType},enumerable:!0,configurable:!0}),Object.defineProperty(F.prototype,"flags",{get:function(){return this.m_flags},enumerable:!0,configurable:!0}),F);function F(e,t,n){this.m_actionInfo=e,this.m_operationType=t,this.m_flags=n}m.Action=D;var R=(Object.defineProperty(N.prototype,"id",{get:function(){var e=this.m_objectPathInfo.ArgumentInfo;if(e){var t=e.Arguments;if(t)return t[0]}},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"parent",{get:function(){var e=this.m_parentObjectPath;if(e)return e},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"parentId",{get:function(){return this.parent?this.parent.id:void 0},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"objectPathInfo",{get:function(){return this.m_objectPathInfo},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"operationType",{get:function(){return this.m_operationType},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"flags",{get:function(){return this.m_flags},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"isCollection",{get:function(){return this.m_isCollection},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"isInvalidAfterRequest",{get:function(){return this.m_isInvalidAfterRequest},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"parentObjectPath",{get:function(){return this.m_parentObjectPath},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"argumentObjectPaths",{get:function(){return this.m_argumentObjectPaths},set:function(e){this.m_argumentObjectPaths=e},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"isValid",{get:function(){return this.m_isValid},set:function(e){!(this.m_isValid=e)&&6===this.m_objectPathInfo.ObjectPathType&&this.m_savedObjectPathInfo&&(N.copyObjectPathInfo(this.m_savedObjectPathInfo.pathInfo,this.m_objectPathInfo),this.m_parentObjectPath=this.m_savedObjectPathInfo.parent,this.m_isValid=!0,this.m_savedObjectPathInfo=null)},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"originalObjectPathInfo",{get:function(){return this.m_originalObjectPathInfo},enumerable:!0,configurable:!0}),Object.defineProperty(N.prototype,"getByIdMethodName",{get:function(){return this.m_getByIdMethodName},set:function(e){this.m_getByIdMethodName=e},enumerable:!0,configurable:!0}),N.prototype._updateAsNullObject=function(){this.resetForUpdateUsingObjectData(),this.m_objectPathInfo.ObjectPathType=7,this.m_objectPathInfo.Name="",this.m_parentObjectPath=null},N.prototype.saveOriginalObjectPathInfo=function(){m.config.extendedErrorLogging&&!this.m_originalObjectPathInfo&&(this.m_originalObjectPathInfo={},N.copyObjectPathInfo(this.m_objectPathInfo,this.m_originalObjectPathInfo))},N.prototype.updateUsingObjectData=function(e,t){var n=e[K.referenceId];if(!C.isNullOrEmptyString(n)){if(!this.m_savedObjectPathInfo&&!this.isInvalidAfterRequest&&N.isRestorableObjectPath(this.m_objectPathInfo.ObjectPathType)){var r={};N.copyObjectPathInfo(this.m_objectPathInfo,r),this.m_savedObjectPathInfo={pathInfo:r,parent:this.m_parentObjectPath}}return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),this.m_objectPathInfo.ObjectPathType=6,this.m_objectPathInfo.Name=n,delete this.m_objectPathInfo.ParentObjectPathId,void(this.m_parentObjectPath=null)}if(t){var o=t[K.collectionPropertyPath];if(!C.isNullOrEmptyString(o)&&t.context){var i=$.tryGetObjectIdFromLoadOrRetrieveResult(e);if(!C.isNullOrUndefined(i)){for(var a=o.split("."),s=t.context[a[0]],c=1;c<a.length;c++)s=s[a[c]];return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),this.m_parentObjectPath=s._objectPath,this.m_objectPathInfo.ParentObjectPathId=this.m_parentObjectPath.objectPathInfo.Id,this.m_objectPathInfo.ObjectPathType=5,this.m_objectPathInfo.Name="",void(this.m_objectPathInfo.ArgumentInfo.Arguments=[i])}}}var l=this.parentObjectPath&&this.parentObjectPath.isCollection,u=this.getByIdMethodName;if((l||!C.isNullOrEmptyString(u))&&(i=$.tryGetObjectIdFromLoadOrRetrieveResult(e),!C.isNullOrUndefined(i)))return this.saveOriginalObjectPathInfo(),this.resetForUpdateUsingObjectData(),C.isNullOrEmptyString(u)?(this.m_objectPathInfo.ObjectPathType=5,this.m_objectPathInfo.Name=""):(this.m_objectPathInfo.ObjectPathType=3,this.m_objectPathInfo.Name=u),void(this.m_objectPathInfo.ArgumentInfo.Arguments=[i])},N.prototype.resetForUpdateUsingObjectData=function(){this.m_isInvalidAfterRequest=!1,this.m_isValid=!0,this.m_operationType=1,this.m_flags=4,this.m_objectPathInfo.ArgumentInfo={},this.m_argumentObjectPaths=null,this.m_getByIdMethodName=null},N.isRestorableObjectPath=function(e){return 1===e||5===e||3===e||4===e},N.copyObjectPathInfo=function(e,t){t.Id=e.Id,t.ArgumentInfo=e.ArgumentInfo,t.Name=e.Name,t.ObjectPathType=e.ObjectPathType,t.ParentObjectPathId=e.ParentObjectPathId},N);function N(e,t,n,r,o,i){this.m_objectPathInfo=e,this.m_parentObjectPath=t,this.m_isCollection=n,this.m_isInvalidAfterRequest=r,this.m_isValid=!0,this.m_operationType=o,this.m_flags=i}m.ObjectPath=R;var M=(j.prototype._nextId=function(){return++this.m_nextId},j.prototype._addServiceApiAction=function(e,t,n,r){this.m_serviceApiQueue||(this.m_serviceApiQueue=new q(this)),this.m_serviceApiQueue.add(e,t,n,r)},j._parseQueryOption=function(e){var t={};if("string"==typeof e){var n=e;t.Select=$._parseSelectExpand(n)}else if(Array.isArray(e))t.Select=e;else if("object"==typeof e){var r=e;if(j.isLoadOption(r)){if("string"==typeof r.select)t.Select=$._parseSelectExpand(r.select);else if(Array.isArray(r.select))t.Select=r.select;else if(!$.isNullOrUndefined(r.select))throw h.RuntimeError._createInvalidArgError({argumentName:"option.select"});if("string"==typeof r.expand)t.Expand=$._parseSelectExpand(r.expand);else if(Array.isArray(r.expand))t.Expand=r.expand;else if(!$.isNullOrUndefined(r.expand))throw h.RuntimeError._createInvalidArgError({argumentName:"option.expand"});if("number"==typeof r.top)t.Top=r.top;else if(!$.isNullOrUndefined(r.top))throw h.RuntimeError._createInvalidArgError({argumentName:"option.top"});if("number"==typeof r.skip)t.Skip=r.skip;else if(!$.isNullOrUndefined(r.skip))throw h.RuntimeError._createInvalidArgError({argumentName:"option.skip"})}else t=j.parseStrictLoadOption(e)}else if(!$.isNullOrUndefined(e))throw h.RuntimeError._createInvalidArgError({argumentName:"option"});return t},j.isLoadOption=function(e){if(!$.isUndefined(e.select)&&("string"==typeof e.select||Array.isArray(e.select)))return!0;if(!$.isUndefined(e.expand)&&("string"==typeof e.expand||Array.isArray(e.expand)))return!0;if(!$.isUndefined(e.top)&&"number"==typeof e.top)return!0;if(!$.isUndefined(e.skip)&&"number"==typeof e.skip)return!0;for(var t in e)return!1;return!0},j.parseStrictLoadOption=function(e){var t={Select:[]};return j.parseStrictLoadOptionHelper(t,"","option",e),t},j.combineQueryPath=function(e,t,n){return 0===e.length?t:e+n+t},j.parseStrictLoadOptionHelper=function(e,t,n,r){for(var o in r){var i=r[o];if("$all"===o){if("boolean"!=typeof i)throw h.RuntimeError._createInvalidArgError({argumentName:j.combineQueryPath(n,o,".")});i&&e.Select.push(j.combineQueryPath(t,"*","/"))}else if("$top"===o){if("number"!=typeof i||0<t.length)throw h.RuntimeError._createInvalidArgError({argumentName:j.combineQueryPath(n,o,".")});e.Top=i}else if("$skip"===o){if("number"!=typeof i||0<t.length)throw h.RuntimeError._createInvalidArgError({argumentName:j.combineQueryPath(n,o,".")});e.Skip=i}else if("boolean"==typeof i)i&&e.Select.push(j.combineQueryPath(t,o,"/"));else{if("object"!=typeof i)throw h.RuntimeError._createInvalidArgError({argumentName:j.combineQueryPath(n,o,".")});j.parseStrictLoadOptionHelper(e,j.combineQueryPath(t,o,"/"),j.combineQueryPath(n,o,"."),i)}}},j);function j(){this.m_nextId=0}m.ClientRequestContextBase=M;var k=(H.prototype._handleResult=function(e){C.isNullOrUndefined(e)?this.m_objectPath._updateAsNullObject():this.m_objectPath.updateUsingObjectData(e,null)},H);function H(e){this.m_objectPath=e}var U=(L.prototype.addAction=function(e){this.m_actions.push(e),1==e.actionInfo.ActionType&&(this.m_instantiatedObjectPaths[e.actionInfo.ObjectPathId]=e)},L.prototype.addPreviewExecutionAction=function(e){this.m_previewExecutionActions.push(e)},Object.defineProperty(L.prototype,"hasActions",{get:function(){return 0<this.m_actions.length},enumerable:!0,configurable:!0}),L.prototype._getLastAction=function(){return this.m_actions[this.m_actions.length-1]},L.prototype.ensureInstantiateObjectPath=function(e){if(e){if(this.m_instantiatedObjectPaths[e.objectPathInfo.Id])return;if(this.ensureInstantiateObjectPath(e.parentObjectPath),this.ensureInstantiateObjectPaths(e.argumentObjectPaths),!this.m_instantiatedObjectPaths[e.objectPathInfo.Id]){var t={Id:this.m_contextBase._nextId(),ActionType:1,Name:"",ObjectPathId:e.objectPathInfo.Id},n=new D(t,1,4);n.referencedObjectPath=e,this.addReferencedObjectPath(e),this.addAction(n);var r=new k(e);this.addActionResultHandler(n,r)}}},L.prototype.ensureInstantiateObjectPaths=function(e){if(e)for(var t=0;t<e.length;t++)this.ensureInstantiateObjectPath(e[t])},L.prototype.addReferencedObjectPath=function(e){if(e&&!this.m_referencedObjectPaths[e.objectPathInfo.Id]){if(!e.isValid)throw new h.RuntimeError({code:g.invalidObjectPath,httpStatusCode:400,message:C._getResourceString(v.invalidObjectPath,$.getObjectPathExpression(e)),debugInfo:{errorLocation:$.getObjectPathExpression(e)}});for(;e;)3==(this.m_referencedObjectPaths[e.objectPathInfo.Id]=e).objectPathInfo.ObjectPathType&&this.addReferencedObjectPaths(e.argumentObjectPaths),e=e.parentObjectPath}},L.prototype.addReferencedObjectPaths=function(e){if(e)for(var t=0;t<e.length;t++)this.addReferencedObjectPath(e[t])},L.prototype.addActionResultHandler=function(e,t){this.m_actionResultHandler[e.actionInfo.Id]=t},L.prototype.aggregrateRequestFlags=function(e,t,n){return 0===t&&(e|=1,0==(2&n)&&(e&=-17),0==(8&n)&&(e&=-257),e&=-5),1&n&&(e|=2),0==(4&n)&&(e&=-5),e},L.prototype.finallyNormalizeFlags=function(e){return 0==(1&e)&&(e&=-17,e&=-257),m._internalConfig.enableConcurrentFlag||(e&=-5),m._internalConfig.enableUndoableFlag||(e&=-17),$.isSetSupported("RichApiRuntimeFlag","1.1")||(e&=-5,e&=-17),$.isSetSupported("RichApiRuntimeFlag","1.2")||(e&=-257),"number"==typeof this.m_flagsForTesting&&(e=this.m_flagsForTesting),e},L.prototype.buildRequestMessageBodyAndRequestFlags=function(){m._internalConfig.enableEarlyDispose&&L._calculateLastUsedObjectPathIds(this.m_actions);var e=276,t={};for(var n in this.m_referencedObjectPaths)e=this.aggregrateRequestFlags(e,this.m_referencedObjectPaths[n].operationType,this.m_referencedObjectPaths[n].flags),t[n]=this.m_referencedObjectPaths[n].objectPathInfo;for(var r=[],o=!1,i=0;i<this.m_actions.length;i++){var a=this.m_actions[i];3===a.actionInfo.ActionType&&a.actionInfo.Name===K.keepReference&&(o=!0),e=this.aggregrateRequestFlags(e,a.operationType,a.flags),r.push(a.actionInfo)}e=this.finallyNormalizeFlags(e);var s={AutoKeepReference:this.m_contextBase._autoCleanup&&o,Actions:r,ObjectPaths:t};return 0<this.m_previewExecutionActions.length&&(s.PreviewExecutionActions=this.m_previewExecutionActions,e|=4096),{body:s,flags:e}},L.prototype.processResponse=function(e){if(e)for(var t=0;t<e.length;t++){var n=e[t],r=this.m_actionResultHandler[n.ActionId];r&&r._handleResult(n.Value)}},L.prototype.invalidatePendingInvalidObjectPaths=function(){for(var e in this.m_referencedObjectPaths)this.m_referencedObjectPaths[e].isInvalidAfterRequest&&(this.m_referencedObjectPaths[e].isValid=!1)},L.prototype._addPreSyncPromise=function(e){this.m_preSyncPromises.push(e)},Object.defineProperty(L.prototype,"_preSyncPromises",{get:function(){return this.m_preSyncPromises},enumerable:!0,configurable:!0}),Object.defineProperty(L.prototype,"_actions",{get:function(){return this.m_actions},enumerable:!0,configurable:!0}),Object.defineProperty(L.prototype,"_objectPaths",{get:function(){return this.m_referencedObjectPaths},enumerable:!0,configurable:!0}),L.prototype._removeKeepReferenceAction=function(e){for(var t=this.m_actions.length-1;0<=t;t--){var n=this.m_actions[t].actionInfo;if(n.ObjectPathId===e&&3===n.ActionType&&n.Name===K.keepReference){this.m_actions.splice(t,1);break}}},L._updateLastUsedActionIdOfObjectPathId=function(e,t,n){for(;t;){if(e[t.objectPathInfo.Id])return;e[t.objectPathInfo.Id]=n;var r=t.argumentObjectPaths;if(r)for(var o=r.length,i=0;i<o;i++)L._updateLastUsedActionIdOfObjectPathId(e,r[i],n);t=t.parentObjectPath}},L._calculateLastUsedObjectPathIds=function(e){for(var t={},n=e.length,r=n-1;0<=r;--r){var o=(p=e[r]).actionInfo.Id;p.referencedObjectPath&&L._updateLastUsedActionIdOfObjectPathId(t,p.referencedObjectPath,o);var i=p.referencedArgumentObjectPaths;if(i)for(var a=i.length,s=0;s<a;s++)L._updateLastUsedActionIdOfObjectPathId(t,i[s],o)}var c={};for(var l in t){var u=c[o=t[l]];u||(u=[],c[o]=u),u.push(parseInt(l))}for(r=0;r<n;r++){var p,f=c[(p=e[r]).actionInfo.Id];f&&0<f.length?p.actionInfo.L=f:p.actionInfo.L&&delete p.actionInfo.L}},L);function L(e){this.m_contextBase=e,this.m_actions=[],this.m_actionResultHandler={},this.m_referencedObjectPaths={},this.m_instantiatedObjectPaths={},this.m_preSyncPromises=[],this.m_previewExecutionActions=[]}m.ClientRequestBase=U;var B=(Object.defineProperty(W.prototype,"value",{get:function(){if(!this.m_isLoaded)throw new h.RuntimeError({code:g.valueNotLoaded,httpStatusCode:400,message:C._getResourceString(v.valueNotLoaded),debugInfo:{errorLocation:"clientResult.value"}});return this.m_value},enumerable:!0,configurable:!0}),W.prototype._handleResult=function(e){this.m_isLoaded=!0,"object"==typeof e&&e&&e._IsNull||(1===this.m_type?this.m_value=$.adjustToDateTime(e):this.m_value=e)},W);function W(e){this.m_type=e}m.ClientResult=B;var q=(V.prototype.add=function(e,t,n,r){var o=this;this.m_actions.push({action:e,resultHandler:t,resolve:n,reject:r}),1===this.m_actions.length&&setTimeout(function(){return o.processActions()},0)},V.prototype.processActions=function(){var t=this;if(0!==this.m_actions.length){var n=this.m_actions;this.m_actions=[];for(var r=new U(this.m_context),e=0;e<n.length;e++){var o=n[e];r.ensureInstantiateObjectPath(o.action.referencedObjectPath),r.ensureInstantiateObjectPaths(o.action.referencedArgumentObjectPaths),r.addAction(o.action),r.addReferencedObjectPath(o.action.referencedObjectPath),r.addReferencedObjectPaths(o.action.referencedArgumentObjectPaths)}var i=r.buildRequestMessageBodyAndRequestFlags(),a=i.body,s=i.flags,c={Url:d.localDocumentApiPrefix,Headers:null,Body:a};C.log("Request:"),C.log(JSON.stringify(a)),(new G).executeAsync(this.m_context._customData,s,c).then(function(e){t.processResponse(r,n,e)}).catch(function(e){for(var t=0;t<n.length;t++)n[t].reject(e)})}},V.prototype.processResponse=function(e,t,n){var r=this.getErrorFromResponse(n),o=null;n.Body.Results?o=n.Body.Results:n.Body.ProcessedResults&&n.Body.ProcessedResults.Results&&(o=n.Body.ProcessedResults.Results),o=o||[],this.processActionResults(e,t,o,r)},V.prototype.getErrorFromResponse=function(e){return C.isNullOrEmptyString(e.ErrorCode)?e.Body&&e.Body.Error?new h.RuntimeError({code:e.Body.Error.Code,httpStatusCode:e.Body.Error.HttpStatusCode,message:e.Body.Error.Message}):null:new h.RuntimeError({code:e.ErrorCode,httpStatusCode:e.HttpStatusCode,message:e.ErrorMessage})},V.prototype.processActionResults=function(e,t,n,r){e.processResponse(n);for(var o=0;o<t.length;o++){for(var i=t[o],a=i.action.actionInfo.Id,s=!1,c=0;c<n.length;c++)if(a==n[c].ActionId){var l=n[c].Value;i.resultHandler&&(i.resultHandler._handleResult(l),l=i.resultHandler.value),i.resolve&&i.resolve(l),s=!0;break}!s&&i.reject&&(r?i.reject(r):i.reject("No response for the action."))}},V);function V(e){this.m_context=e,this.m_actions=[]}var G=(J.prototype.getRequestUrl=function(e,t,n){void 0===n&&(n=a.graph.toString());var r=d.flags+"="+t.toString();switch(n){case a.graph.toString():"/"!=e.charAt(e.length-1)&&(e+="/"),e=(e+=d.processQuery)+"?"+r;break;case a.wfe.toString():e=(e=e+"&"+r)+"&wdRestPart=_api/"+d.processQuery}return e},J.prototype.executeAsync=function(e,t,n){var r=n.Headers?n.Headers[K.remoteEndpointTypeHeaderKey]:a.graph.toString(),o={method:"POST",url:this.getRequestUrl(n.Url,t,r),headers:{},body:n.Body};if(o.headers[d.sourceLibHeader]=J.SourceLibHeaderValue,o.headers["CONTENT-TYPE"]="application/json",n.Headers)for(var i in n.Headers)o.headers[i]=n.Headers[i];return(C._isLocalDocumentUrl(o.url)?s.sendLocalDocumentRequest:s.sendRequest)(o).then(function(e){var t;if(200===e.statusCode)t={HttpStatusCode:e.statusCode,ErrorCode:null,ErrorMessage:null,Headers:e.headers,Body:C._parseResponseBody(e)};else{C.log("Error Response:"+e.body);var n=C._parseErrorResponse(e);t={HttpStatusCode:e.statusCode,ErrorCode:n.errorCode,ErrorMessage:n.errorMessage,Headers:e.headers,Body:null,RawErrorResponseBody:C._parseErrorResponseBody(e)}}return t})},J.SourceLibHeaderValue="officejs-rest",J);function J(){}m.HttpRequestExecutor=G;var z,K=(__extends(X,z=d),X.collectionPropertyPath="_collectionPropertyPath",X.id="Id",X.idLowerCase="id",X.idPrivate="_Id",X.keepReference="_KeepReference",X.objectPathIdPrivate="_ObjectPathId",X.referenceId="_ReferenceId",X.items="_Items",X.itemsLowerCase="items",X.scalarPropertyNames="_scalarPropertyNames",X.scalarPropertyOriginalNames="_scalarPropertyOriginalNames",X.navigationPropertyNames="_navigationPropertyNames",X.scalarPropertyUpdateable="_scalarPropertyUpdateable",X.previewExecutionObjectId="_previewExecutionObjectId",X.remoteEndpointTypeHeaderKey="X-EndpointType",X);function X(){return null!==z&&z.apply(this,arguments)||this}m.CommonConstants=K;var Q,$=(__extends(Z,Q=C),Z.validateObjectPath=function(e){for(var t=e._objectPath;t;){if(!t.isValid)throw new h.RuntimeError({code:g.invalidObjectPath,httpStatusCode:400,message:C._getResourceString(v.invalidObjectPath,Z.getObjectPathExpression(t)),debugInfo:{errorLocation:Z.getObjectPathExpression(t)}});t=t.parentObjectPath}},Z.validateReferencedObjectPaths=function(e){if(e)for(var t=0;t<e.length;t++)for(var n=e[t];n;){if(!n.isValid)throw new h.RuntimeError({code:g.invalidObjectPath,httpStatusCode:400,message:C._getResourceString(v.invalidObjectPath,Z.getObjectPathExpression(n))});n=n.parentObjectPath}},Z._toCamelLowerCase=function(e){if(C.isNullOrEmptyString(e))return e;for(var t=0;t<e.length&&65<=e.charCodeAt(t)&&e.charCodeAt(t)<=90;)t++;return t<e.length?e.substr(0,t).toLowerCase()+e.substr(t):e.toLowerCase()},Z.adjustToDateTime=function(e){if(C.isNullOrUndefined(e))return null;if("string"==typeof e)return new Date(e);if(Array.isArray(e)){for(var t=e,n=0;n<t.length;n++)t[n]=Z.adjustToDateTime(t[n]);return t}throw C._createInvalidArgError({argumentName:"date"})},Z.tryGetObjectIdFromLoadOrRetrieveResult=function(e){var t=e[K.id];return C.isNullOrUndefined(t)&&(t=e[K.idLowerCase]),C.isNullOrUndefined(t)&&(t=e[K.idPrivate]),t},Z.getObjectPathExpression=function(e){for(var t="";e;){switch(e.objectPathInfo.ObjectPathType){case 1:t=t;break;case 2:t="new()"+(0<t.length?".":"")+t;break;case 3:t=Z.normalizeName(e.objectPathInfo.Name)+"()"+(0<t.length?".":"")+t;break;case 4:t=Z.normalizeName(e.objectPathInfo.Name)+(0<t.length?".":"")+t;break;case 5:t="getItem()"+(0<t.length?".":"")+t;break;case 6:t="_reference()"+(0<t.length?".":"")+t}e=e.parentObjectPath}return t},Z.setMethodArguments=function(e,t,n){if(C.isNullOrUndefined(n))return null;var r=new Array,o=new Array,i=Z.collectObjectPathInfos(e,n,r,o);return t.Arguments=n,i&&(t.ReferencedObjectPathIds=o),r},Z.validateContext=function(e,t){if(e&&t&&t._context!==e)throw new h.RuntimeError({code:g.invalidRequestContext,httpStatusCode:400,message:C._getResourceString(v.invalidRequestContext)})},Z.isSetSupported=function(e,t){return"function"==typeof Z.isSetSupportedOverride?Z.isSetSupportedOverride(e,t):!("undefined"!=typeof window&&window.Office&&window.Office.context&&window.Office.context.requirements)||window.Office.context.requirements.isSetSupported(e,t)},Z.throwIfApiNotSupported=function(e,t,n,r){if(Z._doApiNotSupportedCheck&&!Z.isSetSupported(t,n)){var o=C._getResourceString(v.apiNotFoundDetails,[e,t+" "+n,r]);throw new h.RuntimeError({code:g.apiNotFound,httpStatusCode:404,message:o,debugInfo:{errorLocation:e}})}},Z.calculateApiFlags=function(e,t,n){var r=window&&window.location&&window.location.href&&-1!==window.location.href.indexOf("eed0a086-3498-4f91-a377-1e0265ecc0cc");return("function"==typeof Z.isSetSupportedOverride?Z.isSetSupportedOverride(t,n):!r&&Z.isSetSupported(t,n))||(e&=-3),e},Z._parseSelectExpand=function(e){var t=[];if(!C.isNullOrEmptyString(e))for(var n=e.split(","),r=0;r<n.length;r++){var o=n[r];0<(o=i(o.trim())).length&&t.push(o)}return t;function i(e){var t=e.toLowerCase();return"items"===t||"items/"===t?"*":("items/"!==t.substr(0,6)&&"items."!==t.substr(0,6)||(e=e.substr(6)),e.replace(new RegExp("[/.]items[/.]","gi"),"/"))}},Z.changePropertyNameToCamelLowerCase=function(e){if(Array.isArray(e)){for(var t=[],n=0;n<e.length;n++)t.push(this.changePropertyNameToCamelLowerCase(e[n]));return t}if("object"!=typeof e||null===e)return e;for(var r in t={},e){var o=e[r];if(r===K.items){(t={})[K.itemsLowerCase]=this.changePropertyNameToCamelLowerCase(o);break}t[Z._toCamelLowerCase(r)]=this.changePropertyNameToCamelLowerCase(o)}return t},Z.purifyJson=function(e){if(Array.isArray(e)){for(var t=[],n=0;n<e.length;n++)t.push(this.purifyJson(e[n]));return t}if("object"!=typeof e||null===e)return e;for(var r in t={},e)if(95!==r.charCodeAt(0)){var o=e[r];"object"==typeof o&&null!==o&&Array.isArray(o.items)&&(o=o.items),t[r]=this.purifyJson(o)}return t},Z.collectObjectPathInfos=function(e,t,n,r){for(var o=!1,i=0;i<t.length;i++)if(t[i]instanceof I){var a=t[i];Z.validateContext(e,a),t[i]=a._objectPath.objectPathInfo.Id,r.push(a._objectPath.objectPathInfo.Id),n.push(a._objectPath),o=!0}else if(Array.isArray(t[i])){var s=new Array;Z.collectObjectPathInfos(e,t[i],n,s)?(r.push(s),o=!0):r.push(0)}else C.isPlainJsonObject(t[i])?(r.push(0),Z.replaceClientObjectPropertiesWithObjectPathIds(t[i],n)):r.push(0);return o},Z.replaceClientObjectPropertiesWithObjectPathIds=function(e,t){var n,r;for(var o in e){var i=e[o];if(i instanceof I)t.push(i._objectPath),e[o]=((n={})[K.objectPathIdPrivate]=i._objectPath.objectPathInfo.Id,n);else if(Array.isArray(i))for(var a=0;a<i.length;a++)if(i[a]instanceof I){var s=i[a];t.push(s._objectPath),i[a]=((r={})[K.objectPathIdPrivate]=s._objectPath.objectPathInfo.Id,r)}else C.isPlainJsonObject(i[a])&&Z.replaceClientObjectPropertiesWithObjectPathIds(i[a],t);else C.isPlainJsonObject(i)&&Z.replaceClientObjectPropertiesWithObjectPathIds(i,t)}},Z.normalizeName=function(e){return e.substr(0,1).toLowerCase()+e.substr(1)},Z._doApiNotSupportedCheck=!1,Z);function Z(){return null!==Q&&Q.apply(this,arguments)||this}m.CommonUtility=$;var Y,ee=(__extends(te,Y=v),te.propertyDoesNotExist="PropertyDoesNotExist",te.attemptingToSetReadOnlyProperty="AttemptingToSetReadOnlyProperty",te);function te(){return null!==Y&&Y.apply(this,arguments)||this}m.CommonResourceStrings=ee;var ne,re=(__extends(oe,ne=g),oe.propertyNotLoaded="PropertyNotLoaded",oe.runMustReturnPromise="RunMustReturnPromise",oe.cannotRegisterEvent="CannotRegisterEvent",oe.invalidOrTimedOutSession="InvalidOrTimedOutSession",oe.cannotUpdateReadOnlyProperty="CannotUpdateReadOnlyProperty",oe);function oe(){return null!==ne&&ne.apply(this,arguments)||this}m.ErrorCodes=re;var ie=(ae.prototype._handleResult=function(e){this.m_callback&&this.m_callback()},ae);function ae(e){this.m_callback=e}var se,ce=(__extends(le,se=T),le.createMethodAction=function(e,t,n,r,o,i){rt.validateObjectPath(t);var a={Id:e._nextId(),ActionType:3,Name:n,ObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}},s=rt.setMethodArguments(e,a.ArgumentInfo,o);rt.validateReferencedObjectPaths(s);var c=rt._fixupApiFlags(i),l=new D(a,r,c);if(l.referencedObjectPath=t._objectPath,l.referencedArgumentObjectPaths=s,t._addAction(l),m._internalConfig.enablePreviewExecution&&0!=(16&c)){var u={Id:e._nextId(),ActionType:3,Name:n,Arguments:o,ObjectId:"",ObjectType:""};t._addPreviewExecutionAction(u)}return l},le.createRecursiveQueryAction=function(e,t,n){rt.validateObjectPath(t);var r={Id:e._nextId(),ActionType:6,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,RecursiveQueryInfo:n},o=new D(r,1,4);return o.referencedObjectPath=t._objectPath,t._addAction(o),o},le.createEnsureUnchangedAction=function(e,t,n){rt.validateObjectPath(t);var r={Id:e._nextId(),ActionType:8,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id,ObjectState:n},o=new D(r,1,4);return o.referencedObjectPath=t._objectPath,t._addAction(o),o},le.createInstantiateAction=function(e,t){rt.validateObjectPath(t),e._pendingRequest.ensureInstantiateObjectPath(t._objectPath.parentObjectPath),e._pendingRequest.ensureInstantiateObjectPaths(t._objectPath.argumentObjectPaths);var n={Id:e._nextId(),ActionType:1,Name:"",ObjectPathId:t._objectPath.objectPathInfo.Id},r=new D(n,1,4);return r.referencedObjectPath=t._objectPath,t._addAction(r,new qe(t),!0),r},le.createTraceAction=function(e,t,n){var r={Id:e._nextId(),ActionType:5,Name:"Trace",ObjectPathId:0},o=new D(r,1,4);return e._pendingRequest.addAction(o),n&&e._pendingRequest.addTrace(r.Id,t),o},le.createTraceMarkerForCallback=function(e,t){var n=le.createTraceAction(e,null,!1);e._pendingRequest.addActionResultHandler(n,new ie(t))},le);function le(){return null!==se&&se.apply(this,arguments)||this}m.ActionFactory=ce;var ue,pe=(__extends(fe,ue=I),Object.defineProperty(fe.prototype,"context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),Object.defineProperty(fe.prototype,"isNull",{get:function(){return(void 0!==this.m_isNull||!P.isMock())&&(rt.throwIfNotLoaded("isNull",this._isNull,null,this._isNull),this._isNull)},enumerable:!0,configurable:!0}),Object.defineProperty(fe.prototype,"isNullObject",{get:function(){return(void 0!==this.m_isNull||!P.isMock())&&(rt.throwIfNotLoaded("isNullObject",this._isNull,null,this._isNull),this._isNull)},enumerable:!0,configurable:!0}),Object.defineProperty(fe.prototype,"_isNull",{get:function(){return this.m_isNull},set:function(e){(this.m_isNull=e)&&this._objectPath&&this._objectPath._updateAsNullObject()},enumerable:!0,configurable:!0}),fe.prototype._addAction=function(e,t,n){return void 0===t&&(t=null),n||(this.context._pendingRequest.ensureInstantiateObjectPath(this._objectPath),this.context._pendingRequest.ensureInstantiateObjectPaths(e.referencedArgumentObjectPaths)),this.context._pendingRequest.addAction(e),this.context._pendingRequest.addReferencedObjectPath(this._objectPath),this.context._pendingRequest.addReferencedObjectPaths(e.referencedArgumentObjectPaths),this.context._pendingRequest.addActionResultHandler(e,t),C._createPromiseFromResult(null)},fe.prototype._addPreviewExecutionAction=function(e){if(!rt.isUndefined(this._className)){e.ObjectType=this._className;var t=rt._getPropertyValueWithoutCheckLoaded(this,Ae.idLowerCase);rt.isUndefined(t)&&(t=rt._getPropertyValueWithoutCheckLoaded(this,Ae.idPrivate)),rt.isUndefined(t)&&(t=rt._getPropertyValueWithoutCheckLoaded(this,Ae.previewExecutionObjectId)),e.ObjectId=t,this.context._pendingRequest.addPreviewExecutionAction(e)}},fe.prototype._handleResult=function(e){this._isNull=rt.isNullOrUndefined(e),this.context.trackedObjects._autoTrackIfNecessaryWhenHandleObjectResultValue(this,e)},fe.prototype._handleIdResult=function(e){this._isNull=rt.isNullOrUndefined(e),rt.fixObjectPathIfNecessary(this,e),this.context.trackedObjects._autoTrackIfNecessaryWhenHandleObjectResultValue(this,e)},fe.prototype._handleRetrieveResult=function(e,t){this._handleIdResult(e)},fe.prototype._recursivelySet=function(e,t,n,r,o){var i=e instanceof fe,a=e;if(i){if(Object.getPrototypeOf(this)!==Object.getPrototypeOf(e))throw h.RuntimeError._createInvalidArgError({argumentName:"properties",errorLocation:this._className+".set"});e=JSON.parse(JSON.stringify(e))}try{for(var s,c=0;c<n.length;c++)s=n[c],e.hasOwnProperty(s)&&void 0!==e[s]&&(this[s]=e[s]);for(c=0;c<r.length;c++)if(s=r[c],e.hasOwnProperty(s)&&void 0!==e[s]){var l=i?a[s]:e[s];this[s].set(l,t)}var u=!i;for(t&&!rt.isNullOrUndefined(u)&&(u=t.throwOnReadOnly),c=0;c<o.length;c++)if(s=o[c],e.hasOwnProperty(s)&&void 0!==e[s]&&u)throw new h.RuntimeError({code:g.invalidArgument,httpStatusCode:400,message:C._getResourceString(et.cannotApplyPropertyThroughSetMethod,s),debugInfo:{errorLocation:s}});for(s in e)if(n.indexOf(s)<0&&r.indexOf(s)<0){var p=Object.getOwnPropertyDescriptor(Object.getPrototypeOf(this),s);if(!p)throw new h.RuntimeError({code:g.invalidArgument,httpStatusCode:400,message:C._getResourceString(ee.propertyDoesNotExist,s),debugInfo:{errorLocation:s}});if(u&&!p.set)throw new h.RuntimeError({code:g.invalidArgument,httpStatusCode:400,message:C._getResourceString(ee.attemptingToSetReadOnlyProperty,s),debugInfo:{errorLocation:s}})}}catch(e){throw new h.RuntimeError({code:g.invalidArgument,httpStatusCode:400,message:C._getResourceString(v.invalidArgument,"properties"),debugInfo:{errorLocation:this._className+".set"},innerError:e})}},fe);function fe(e,t){var n=ue.call(this,e,t)||this;return rt.checkArgumentNull(e,"context"),n.m_context=e,n._objectPath&&(!e._processingResult&&e._pendingRequest&&(ce.createInstantiateAction(e,n),e._autoCleanup&&n._KeepReference&&e.trackedObjects._autoAdd(n)),m._internalConfig.appendTypeNameToObjectPathInfo&&n._objectPath.objectPathInfo&&n._className&&(n._objectPath.objectPathInfo.T=n._className)),n}m.ClientObject=pe;var de=(he.prototype.executeAsync=function(e,t,n){var r={url:d.processQuery,method:"POST",headers:n.Headers,body:n.Body},o="";n.Headers&&(o=n.Headers[Ae.officeControlId]);var i={id:c.nextId(),type:1,flags:t,controlId:o,message:r,customData:e};return C.log(JSON.stringify(i)),this.m_session.sendMessageToHost(i).then(function(e){C.log("Received response: "+JSON.stringify(e));var t,n=e.message;if(200===n.statusCode)t={HttpStatusCode:n.statusCode,ErrorCode:null,ErrorMessage:null,Headers:n.headers,Body:C._parseResponseBody(n)};else{C.log("Error Response:"+n.body);var r=C._parseErrorResponse(n);t={HttpStatusCode:n.statusCode,ErrorCode:r.errorCode,ErrorMessage:r.errorMessage,Headers:n.headers,Body:null}}return t})},he);function he(e){this.m_session=e}var ge,me=(__extends(ye,ge=y),ye.getInstanceIfHostBridgeInited=function(){return c.instance?(!C.isNullOrUndefined(ye.s_instance)&&ye.s_instance.m_bridge===c.instance||(ye.s_instance=new ye(c.instance)),ye.s_instance):null},ye.prototype._resolveRequestUrlAndHeaderInfo=function(){return C._createPromiseFromResult(null)},ye.prototype._createRequestExecutorOrNull=function(){return C.log("NativeBridgeSession::CreateRequestExecutor"),new de(this)},ye.prototype.getEventRegistration=function(e){return He.getGenericEventRegistration(e)},ye.prototype.sendMessageToHost=function(e){return this.m_bridge.sendMessageToHostAndExpectResponse(e)},ye);function ye(e){var t=ge.call(this)||this;return t.m_bridge=e,t.m_bridge.addHostMessageHandler(function(e){if(3===e.type){var t=e.controlId;if(C.isNullOrEmptyString(t))He.getGenericEventRegistration(t)._handleRichApiMessage(e.message);else{var n=He.peekGenericEventRegistrationOrNull(t);n&&n._handleRichApiMessage(e.message),(n=He.peekGenericEventRegistrationOrNull(""))&&n._handleRichApiMessage(e.message)}}}),t}m.HostBridgeSession=me;var ve,be=(__extends(_e,ve=M),Object.defineProperty(_e.prototype,"session",{get:function(){return this.m_session},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"eventRegistration",{get:function(){return this.m_session?this.m_session.getEventRegistration(this._controlId):h.officeJsEventRegistration},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"_url",{get:function(){return this.m_requestUrlAndHeaderInfo?this.m_requestUrlAndHeaderInfo.url:null},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"_pendingRequest",{get:function(){return null==this.m_pendingRequest&&(this.m_pendingRequest=new Te(this)),this.m_pendingRequest},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"_controlId",{get:function(){var e=this.m_customRequestHeaders[Ae.officeControlId];return C.isNullOrUndefined(e)&&(e=""),e},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"debugInfo",{get:function(){return{pendingStatements:new $e(this._rootObjectPropertyName,this._pendingRequest._objectPaths,this._pendingRequest._actions,m._internalConfig.showDisposeInfoInDebugInfo).process()}},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"trackedObjects",{get:function(){return this.m_trackedObjects||(this.m_trackedObjects=new Xe(this)),this.m_trackedObjects},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"requestHeaders",{get:function(){return this.m_customRequestHeaders},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"batchMode",{get:function(){return this.m_batchMode},enumerable:!0,configurable:!0}),Object.defineProperty(_e.prototype,"getAdditionalHeaders",{set:function(e){this.m_getAdditionalHeaders=e},enumerable:!0,configurable:!0}),_e.prototype.ensureInProgressBatchIfBatchMode=function(){if(1===this.m_batchMode&&!this.m_explicitBatchInProgress)throw rt.createRuntimeError(g.generalException,C._getResourceString(et.notInsideBatch),null)},_e.prototype.load=function(e,t){rt.validateContext(this,e);var n=_e._parseQueryOption(t);T.createQueryAction(this,e,n,e)},_e.prototype.loadRecursive=function(e,t,n){if(!rt.isPlainJsonObject(t))throw h.RuntimeError._createInvalidArgError({argumentName:"options"});var r={};for(var o in t)r[o]=_e._parseQueryOption(t[o]);var i=ce.createRecursiveQueryAction(this,e,{Queries:r,MaxDepth:n});this._pendingRequest.addActionResultHandler(i,e)},_e.prototype.trace=function(e){ce.createTraceAction(this,e,!0)},_e.prototype._processOfficeJsErrorResponse=function(e,t){},_e.prototype.ensureRequestUrlAndHeaderInfo=function(){var n=this;return rt._createPromiseFromResult(null).then(function(){if(!n.m_requestUrlAndHeaderInfo)return n.m_requestUrlAndHeaderInfoResolver._resolveRequestUrlAndHeaderInfo().then(function(e){if(n.m_requestUrlAndHeaderInfo=e,n.m_requestUrlAndHeaderInfo||(n.m_requestUrlAndHeaderInfo={url:d.localDocument,headers:{}}),rt.isNullOrEmptyString(n.m_requestUrlAndHeaderInfo.url)&&(n.m_requestUrlAndHeaderInfo.url=d.localDocument),n.m_requestUrlAndHeaderInfo.headers||(n.m_requestUrlAndHeaderInfo.headers={}),"function"==typeof n.m_requestUrlAndHeaderInfoResolver._createRequestExecutorOrNull){var t=n.m_requestUrlAndHeaderInfoResolver._createRequestExecutorOrNull();t&&(n._requestExecutor=t)}})})},_e.prototype.syncPrivateMain=function(){var t=this;return this.ensureRequestUrlAndHeaderInfo().then(function(){var e=t._pendingRequest;return t.m_pendingRequest=null,t.processPreSyncPromises(e).then(function(){return t.syncPrivate(e)})})},_e.prototype.syncPrivate=function(n){var t=this;if(P.isMock())return C._createPromiseFromResult(null);if(!n.hasActions)return this.processPendingEventHandlers(n);var e=n.buildRequestMessageBodyAndRequestFlags(),r=e.body,o=e.flags;this._requestFlagModifier&&(o|=this._requestFlagModifier),this._requestExecutor||(C._isLocalDocumentUrl(this.m_requestUrlAndHeaderInfo.url)?this._requestExecutor=new ze(this):this._requestExecutor=new G);var i=this._requestExecutor,a={};C._copyHeaders(this.m_requestUrlAndHeaderInfo.headers,a),C._copyHeaders(this.m_customRequestHeaders,a),delete this.m_customRequestHeaders[Ae.officeScriptEventId],this.m_getAdditionalHeaders&&C._copyHeaders(this.m_getAdditionalHeaders(),a);var s=P._getCurrentTestNameWithSequenceId();s&&(a[d.testRequestNameHeader]=s);var c={Url:this.m_requestUrlAndHeaderInfo.url,Headers:a,Body:r};n.invalidatePendingInvalidObjectPaths();var l=null,u=null;return this._lastSyncStart="undefined"==typeof performance?Date.now():performance.now(),this._lastRequestFlags=o,i.executeAsync(this._customData,o,c).then(function(e){return t._lastSyncEnd="undefined"==typeof performance?Date.now():performance.now(),m.config.executePerfLogFunc&&m.config.executePerfLogFunc({syncStart:t._lastSyncStart,syncEnd:t._lastSyncEnd}),l=t.processRequestExecutorResponseMessage(n,e),t.processPendingEventHandlers(n).catch(function(e){C.log("Error in processPendingEventHandlers"),C.log(JSON.stringify(e)),u=e})}).then(function(){if(l)throw C.log("Throw error from response: "+JSON.stringify(l)),l;if(u){C.log("Throw error from ProcessEventHandler: "+JSON.stringify(u));var e=null;if(u instanceof h.RuntimeError)(e=u).traceMessages=n._responseTraceMessages;else{var t=null;t="string"==typeof u?u:u.message,rt.isNullOrEmptyString(t)&&(t=C._getResourceString(et.cannotRegisterEvent)),e=new h.RuntimeError({code:re.cannotRegisterEvent,httpStatusCode:400,message:t,traceMessages:n._responseTraceMessages})}throw e}})},_e.prototype.processRequestExecutorResponseMessage=function(e,t){t.Body&&t.Body.TraceIds&&e._setResponseTraceIds(t.Body.TraceIds);var n=e._responseTraceMessages,r=null;if(t.Body){if(t.Body.Error&&0<=t.Body.Error.ActionIndex){var o=new $e(this._rootObjectPropertyName,e._objectPaths,e._actions,!1,!0),i=o.processForDebugStatementInfo(t.Body.Error.ActionIndex);r={statement:i.statement,surroundingStatements:i.surroundingStatements,fullStatements:["Please enable config.extendedErrorLogging to see full statements."]},m.config.extendedErrorLogging&&(o=new $e(this._rootObjectPropertyName,e._objectPaths,e._actions,!1,!1),r.fullStatements=o.process())}var a=null;if(t.Body.Results?a=t.Body.Results:t.Body.ProcessedResults&&t.Body.ProcessedResults.Results&&(a=t.Body.ProcessedResults.Results),a){this._processingResult=!0;try{e.processResponse(a)}finally{this._processingResult=!1}}}if(!rt.isNullOrEmptyString(t.ErrorCode))return new h.RuntimeError({code:t.ErrorCode,httpStatusCode:t.HttpStatusCode,message:t.ErrorMessage,traceMessages:n,data:{responseBody:t.RawErrorResponseBody}});if(t.Body&&t.Body.Error){var s={errorLocation:t.Body.Error.Location};return r&&(s.statement=r.statement,s.surroundingStatements=r.surroundingStatements,s.fullStatements=r.fullStatements),new h.RuntimeError({code:t.Body.Error.Code,httpStatusCode:t.Body.Error.HttpStatusCode,message:t.Body.Error.Message,traceMessages:n,debugInfo:s})}return null},_e.prototype.processPendingEventHandlers=function(e){for(var t=rt._createPromiseFromResult(null),n=0;n<e._pendingProcessEventHandlers.length;n++){var r=e._pendingProcessEventHandlers[n];t=t.then(this.createProcessOneEventHandlersFunc(r,e))}return t},_e.prototype.createProcessOneEventHandlersFunc=function(e,t){return function(){return e._processRegistration(t)}},_e.prototype.processPreSyncPromises=function(e){for(var t=rt._createPromiseFromResult(null),n=0;n<e._preSyncPromises.length;n++){var r=e._preSyncPromises[n];t=t.then(this.createProcessOneProSyncFunc(r))}return t},_e.prototype.createProcessOneProSyncFunc=function(e){return function(){return e}},_e.prototype.sync=function(e){return P.isMock()?C._createPromiseFromResult(e):this.syncPrivateMain().then(function(){return e})},_e.prototype.batch=function(e){var t=this;if(1!==this.m_batchMode)return C._createPromiseFromException(rt.createRuntimeError(g.generalException,null,null));if(this.m_explicitBatchInProgress)return C._createPromiseFromException(rt.createRuntimeError(g.generalException,C._getResourceString(et.pendingBatchInProgress),null));if(rt.isNullOrUndefined(e))return rt._createPromiseFromResult(null);this.m_explicitBatchInProgress=!0;var n,r,o=this.m_pendingRequest;this.m_pendingRequest=new Te(this);try{n=e(this._rootObject,this)}catch(e){return this.m_explicitBatchInProgress=!1,this.m_pendingRequest=o,C._createPromiseFromException(e)}return("object"==typeof n&&n&&"function"==typeof n.then?rt._createPromiseFromResult(null).then(function(){return n}).then(function(e){return t.m_explicitBatchInProgress=!1,r=t.m_pendingRequest,t.m_pendingRequest=o,e}).catch(function(e){return t.m_explicitBatchInProgress=!1,r=t.m_pendingRequest,t.m_pendingRequest=o,C._createPromiseFromException(e)}):(this.m_explicitBatchInProgress=!1,r=this.m_pendingRequest,this.m_pendingRequest=o,rt._createPromiseFromResult(n))).then(function(e){return t.ensureRequestUrlAndHeaderInfo().then(function(){return t.syncPrivate(r)}).then(function(){return e})})},_e._run=function(e,t,n,r,o,i){return void 0===n&&(n=3),void 0===r&&(r=5e3),_e._runCommon("run",null,e,0,t,n,r,null,o,i)},_e.isValidRequestInfo=function(e){return"string"==typeof e||_e.isRequestUrlAndHeaderInfo(e)||_e.isRequestUrlAndHeaderInfoResolver(e)},_e.isRequestUrlAndHeaderInfo=function(e){return"object"==typeof e&&null!==e&&Object.getPrototypeOf(e)===Object.getPrototypeOf({})&&!rt.isNullOrUndefined(e.url)},_e.isRequestUrlAndHeaderInfoResolver=function(e){return"object"==typeof e&&null!==e&&"function"==typeof e._resolveRequestUrlAndHeaderInfo},_e._runBatch=function(e,t,n,r,o,i,a,s){return void 0===o&&(o=3),void 0===i&&(i=5e3),_e._runBatchCommon(0,e,t,n,o,i,r,a,s)},_e._runExplicitBatch=function(e,t,n,r,o,i,a,s){return void 0===o&&(o=3),void 0===i&&(i=5e3),_e._runBatchCommon(1,e,t,n,o,i,r,a,s)},_e._runBatchCommon=function(e,t,n,r,o,i,a,s,c){var l,u;void 0===o&&(o=3),void 0===i&&(i=5e3);var p=null,f=null,d=null,h=0,g=null;if(0<n.length)if(_e.isValidRequestInfo(n[0]))p=n[0],h=1;else if(rt.isPlainJsonObject(n[0])){if(null!=(p=(g=n[0]).session)&&!_e.isValidRequestInfo(p))return _e.createErrorPromise(t);f=g.getAdditionalHeaders,d=g.previousObjects,h=1}if(n.length==h+1)u=n[h+0];else{if(null!=g||n.length!=h+2)return _e.createErrorPromise(t);d=n[h+0],u=n[h+1]}if(null!=d)if(d instanceof pe)l=function(){return d.context};else if(d instanceof _e)l=function(){return d};else{if(!Array.isArray(d))return _e.createErrorPromise(t);var m=d;if(0==m.length)return _e.createErrorPromise(t);for(var y=0;y<m.length;y++){if(!(m[y]instanceof pe))return _e.createErrorPromise(t);if(m[y].context!=m[0].context)return _e.createErrorPromise(t,et.invalidRequestContext)}l=function(){return m[0].context}}else l=r;var v=null;return a&&(v=function(e){return a(g||{},e)}),_e._runCommon(t,p,l,e,u,o,i,v,s,c,f)},_e.createErrorPromise=function(e,t){return void 0===t&&(t=v.invalidArgument),C._createPromiseFromException(rt.createRuntimeError(t,C._getResourceString(t),e))},_e._runCommon=function(t,n,e,r,o,s,c,i,l,u,a){y._overrideSession&&(n=y._overrideSession);var p,f,d,h=C.createPromise(function(e,t){e()}),g=!1;return h.then(function(){if((p=e(n)).getAdditionalHeaders=a,p._autoCleanup)return new m.Promise(function(e,t){p._onRunFinishedNotifiers.push(function(){p._autoCleanup=!0,e()})});p._autoCleanup=!0}).then(function(){return"function"!=typeof o?_e.createErrorPromise(t):(d=p.m_batchMode,p.m_batchMode=r,i&&i(p),e=o(1==r?p.batch.bind(p):p),!rt.isNullOrUndefined(e)&&"function"==typeof e.then||rt.throwError(et.runMustReturnPromise),e);var e}).then(function(e){return 1===r?e:p.sync(e)}).then(function(e){g=!0,f=e}).catch(function(e){f=e}).then(function(){var o=p.trackedObjects._retrieveAndClearAutoCleanupList();for(var e in p._autoCleanup=!1,p.m_batchMode=d,o)o[e]._objectPath.isValid=!1;var i=0;if(rt._synchronousCleanup||_e.isRequestUrlAndHeaderInfoResolver(n))return a();function a(){i++;var e=p.m_pendingRequest,t=p.m_batchMode,n=new Te(p);p.m_pendingRequest=n,p.m_batchMode=0;try{for(var r in o)p.trackedObjects.remove(o[r])}finally{p.m_batchMode=t,p.m_pendingRequest=e}return p.syncPrivate(n).then(function(){l&&l(i)}).catch(function(){u&&u(i),i<s&&setTimeout(function(){a()},c)})}a()}).then(function(){if(p._onRunFinishedNotifiers&&0<p._onRunFinishedNotifiers.length&&p._onRunFinishedNotifiers.shift()(),g)return f;throw f})},_e);function _e(e){var t=ve.call(this)||this;if(t.m_customRequestHeaders={},t.m_batchMode=0,t._onRunFinishedNotifiers=[],y._overrideSession)t.m_requestUrlAndHeaderInfoResolver=y._overrideSession;else if((rt.isNullOrUndefined(e)||"string"==typeof e&&0===e.length)&&(e=(e=_e.defaultRequestUrlAndHeaders)||{url:d.localDocument,headers:{}}),"string"==typeof e)t.m_requestUrlAndHeaderInfo={url:e,headers:{}};else if(_e.isRequestUrlAndHeaderInfoResolver(e))t.m_requestUrlAndHeaderInfoResolver=e;else{if(!_e.isRequestUrlAndHeaderInfo(e))throw h.RuntimeError._createInvalidArgError({argumentName:"url"});var n=e;t.m_requestUrlAndHeaderInfo={url:n.url,headers:{}},C._copyHeaders(n.headers,t.m_requestUrlAndHeaderInfo.headers)}return!t.m_requestUrlAndHeaderInfoResolver&&t.m_requestUrlAndHeaderInfo&&C._isLocalDocumentUrl(t.m_requestUrlAndHeaderInfo.url)&&me.getInstanceIfHostBridgeInited()&&(t.m_requestUrlAndHeaderInfo=null,t.m_requestUrlAndHeaderInfoResolver=me.getInstanceIfHostBridgeInited()),t.m_requestUrlAndHeaderInfoResolver instanceof y&&(t.m_session=t.m_requestUrlAndHeaderInfoResolver),t._processingResult=!1,t._customData=Ae.iterativeExecutor,t.sync=t.sync.bind(t),t}m.ClientRequestContext=be;var Oe=(Object.defineProperty(Se.prototype,"$proxy",{get:function(){return this.m_proxy},enumerable:!0,configurable:!0}),Object.defineProperty(Se.prototype,"$isNullObject",{get:function(){if(!this.m_isLoaded)throw new h.RuntimeError({code:re.valueNotLoaded,httpStatusCode:400,message:C._getResourceString(et.valueNotLoaded),debugInfo:{errorLocation:"retrieveResult.$isNullObject"}});return this.m_isNullObject},enumerable:!0,configurable:!0}),Se.prototype.toJSON=function(){if(this.m_isLoaded)return this.m_isNullObject?null:(rt.isUndefined(this.m_json)&&(this.m_json=rt.purifyJson(this.m_value)),this.m_json)},Se.prototype.toString=function(){return JSON.stringify(this.toJSON())},Se.prototype._handleResult=function(e){this.m_isLoaded=!0,null===e||"object"==typeof e&&e&&e._IsNull?(this.m_isNullObject=!0,e=null):this.m_isNullObject=!1,this.m_shouldPolyfill&&(e=rt.changePropertyNameToCamelLowerCase(e)),this.m_value=e,this.m_proxy._handleRetrieveResult(e,this)},Se);function Se(e,t){this.m_proxy=e,this.m_shouldPolyfill=t;var n=e[Ae.scalarPropertyNames],r=e[Ae.navigationPropertyNames],o=e[Ae.className],i=e[Ae.isCollection];if(n)for(var a=0;a<n.length;a++)rt.definePropertyThrowUnloadedException(this,o,n[a]);if(r)for(a=0;a<r.length;a++)rt.definePropertyThrowUnloadedException(this,o,r[a]);i&&rt.definePropertyThrowUnloadedException(this,o,Ae.itemsLowerCase)}var Ce,Ae=(__extends(Pe,Ce=K),Pe.getItemAt="GetItemAt",Pe.index="_Index",Pe.iterativeExecutor="IterativeExecutor",Pe.isTracked="_IsTracked",Pe.eventMessageCategory=65536,Pe.eventWorkbookId="Workbook",Pe.eventSourceRemote="Remote",Pe.proxy="$proxy",Pe.className="_className",Pe.isCollection="_isCollection",Pe.collectionPropertyPath="_collectionPropertyPath",Pe.objectPathInfoDoNotKeepReferenceFieldName="D",Pe.officeScriptEventId="X-OfficeScriptEventId",Pe.officeScriptFireRecordingEvent="X-OfficeScriptFireRecordingEvent",Pe.officeControlId="X-OfficeControlId",Pe);function Pe(){return null!==Ce&&Ce.apply(this,arguments)||this}m.Constants=Ae;var Ee,Te=(__extends(we,Ee=U),Object.defineProperty(we.prototype,"traceInfos",{get:function(){return this.m_traceInfos},enumerable:!0,configurable:!0}),Object.defineProperty(we.prototype,"_responseTraceMessages",{get:function(){return this.m_responseTraceMessages},enumerable:!0,configurable:!0}),Object.defineProperty(we.prototype,"_responseTraceIds",{get:function(){return this.m_responseTraceIds},enumerable:!0,configurable:!0}),we.prototype._setResponseTraceIds=function(e){if(e)for(var t=0;t<e.length;t++){var n=e[t];this.m_responseTraceIds[n]=n;var r=this.m_traceInfos[n];C.isNullOrUndefined(r)||this.m_responseTraceMessages.push(r)}},we.prototype.addTrace=function(e,t){this.m_traceInfos[e]=t},we.prototype._addPendingEventHandlerAction=function(e,t){this.m_pendingEventHandlerActions[e._id]||(this.m_pendingEventHandlerActions[e._id]=[],this.m_pendingProcessEventHandlers.push(e)),this.m_pendingEventHandlerActions[e._id].push(t)},Object.defineProperty(we.prototype,"_pendingProcessEventHandlers",{get:function(){return this.m_pendingProcessEventHandlers},enumerable:!0,configurable:!0}),we.prototype._getPendingEventHandlerActions=function(e){return this.m_pendingEventHandlerActions[e._id]},we);function we(e){var t=Ee.call(this,e)||this;return t.m_context=e,t.m_pendingProcessEventHandlers=[],t.m_pendingEventHandlerActions={},t.m_traceInfos={},t.m_responseTraceIds={},t.m_responseTraceMessages=[],t}m.ClientRequest=Te;var Ie=(Object.defineProperty(xe.prototype,"_registered",{get:function(){return this.m_registered},enumerable:!0,configurable:!0}),Object.defineProperty(xe.prototype,"_id",{get:function(){return this.m_id},enumerable:!0,configurable:!0}),Object.defineProperty(xe.prototype,"_handlers",{get:function(){return this.m_handlers},enumerable:!0,configurable:!0}),Object.defineProperty(xe.prototype,"_context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),Object.defineProperty(xe.prototype,"_callback",{get:function(){return this.m_callback},enumerable:!0,configurable:!0}),xe.prototype.add=function(e){var t=ce.createTraceAction(this.m_context,null,!1);return this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:t.actionInfo.Id,handler:e,operation:0}),new Re(this.m_context,this,e)},xe.prototype.remove=function(e){var t=ce.createTraceAction(this.m_context,null,!1);this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:t.actionInfo.Id,handler:e,operation:1})},xe.prototype.removeAll=function(){var e=ce.createTraceAction(this.m_context,null,!1);this.m_context._pendingRequest._addPendingEventHandlerAction(this,{id:e.actionInfo.Id,handler:null,operation:2})},xe.prototype._processRegistration=function(e){var t=this,n=C._createPromiseFromResult(null),r=e._getPendingEventHandlerActions(this);if(!r)return n;for(var o=[],i=0;i<this.m_handlers.length;i++)o.push(this.m_handlers[i]);var a=!1;for(i=0;i<r.length;i++)if(e._responseTraceIds[r[i].id])switch(a=!0,r[i].operation){case 0:o.push(r[i].handler);break;case 1:for(var s=o.length-1;0<=s;s--)if(o[s]===r[i].handler){o.splice(s,1);break}break;case 2:o=[]}return a&&(!this.m_registered&&0<o.length?n=n.then(function(){return t.m_eventInfo.registerFunc(t.m_callback)}).then(function(){return t.m_registered=!0}):this.m_registered&&0==o.length&&(n=n.then(function(){return t.m_eventInfo.unregisterFunc(t.m_callback)}).catch(function(e){C.log("Error when unregister event: "+JSON.stringify(e))}).then(function(){return t.m_registered=!1})),n=n.then(function(){return t.m_handlers=o})),n},xe.prototype.fireEvent=function(e){for(var t=[],n=0;n<this.m_handlers.length;n++){var r=this.m_handlers[n],o=C._createPromiseFromResult(null).then(this.createFireOneEventHandlerFunc(r,e)).catch(function(e){C.log("Error when invoke handler: "+JSON.stringify(e))});t.push(o)}C.Promise.all(t)},xe.prototype.createFireOneEventHandlerFunc=function(e,t){return function(){return e(t)}},xe);function xe(e,t,n,r){var o=this;this.m_id=e._nextId(),this.m_context=e,this.m_name=n,this.m_handlers=[],this.m_registered=!1,this.m_eventInfo=r,this.m_callback=function(e){o.m_eventInfo.eventArgsTransformFunc(e).then(function(e){return o.fireEvent(e)})}}m.EventHandlers=Ie;var De,Fe,Re=(Object.defineProperty(Ne.prototype,"context",{get:function(){return this.m_context},enumerable:!0,configurable:!0}),Ne.prototype.remove=function(){this.m_allHandlers&&this.m_handler&&(this.m_allHandlers.remove(this.m_handler),this.m_allHandlers=null,this.m_handler=null)},Ne);function Ne(e,t,n){this.m_context=e,this.m_allHandlers=t,this.m_handler=n}function Me(){}m.EventHandlerResult=Re,De=h=m._Internal||(m._Internal={}),Me.prototype.register=function(e,t,n){switch(e){case 4:return rt.promisify(function(e){return Office.context.document.bindings.getByIdAsync(t,e)}).then(function(t){return rt.promisify(function(e){return t.addHandlerAsync(Office.EventType.BindingDataChanged,n,e)})});case 3:return rt.promisify(function(e){return Office.context.document.bindings.getByIdAsync(t,e)}).then(function(t){return rt.promisify(function(e){return t.addHandlerAsync(Office.EventType.BindingSelectionChanged,n,e)})});case 2:return rt.promisify(function(e){return Office.context.document.addHandlerAsync(Office.EventType.DocumentSelectionChanged,n,e)});case 1:return rt.promisify(function(e){return Office.context.document.settings.addHandlerAsync(Office.EventType.SettingsChanged,n,e)});case 5:return OSF.DDA.RichApi.richApiMessageManager.register(n);case 13:return rt.promisify(function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectDeleted,n,{id:t},e)});case 14:return rt.promisify(function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectSelectionChanged,n,{id:t},e)});case 15:return rt.promisify(function(e){return Office.context.document.addHandlerAsync(Office.EventType.ObjectDataChanged,n,{id:t},e)});case 16:return rt.promisify(function(e){return Office.context.document.addHandlerAsync(Office.EventType.ContentControlAdded,n,{id:t},e)});default:throw De.RuntimeError._createInvalidArgError({argumentName:"eventId"})}},Me.prototype.unregister=function(e,t,n){switch(e){case 4:return rt.promisify(function(e){return Office.context.document.bindings.getByIdAsync(t,e)}).then(function(t){return rt.promisify(function(e){return t.removeHandlerAsync(Office.EventType.BindingDataChanged,{handler:n},e)})});case 3:return rt.promisify(function(e){return Office.context.document.bindings.getByIdAsync(t,e)}).then(function(t){return rt.promisify(function(e){return t.removeHandlerAsync(Office.EventType.BindingSelectionChanged,{handler:n},e)})});case 2:return rt.promisify(function(e){return Office.context.document.removeHandlerAsync(Office.EventType.DocumentSelectionChanged,{handler:n},e)});case 1:return rt.promisify(function(e){return Office.context.document.settings.removeHandlerAsync(Office.EventType.SettingsChanged,{handler:n},e)});case 5:return rt.promisify(function(e){return OSF.DDA.RichApi.richApiMessageManager.removeHandlerAsync("richApiMessage",{handler:n},e)});case 13:return rt.promisify(function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectDeleted,{id:t,handler:n},e)});case 14:return rt.promisify(function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectSelectionChanged,{id:t,handler:n},e)});case 15:return rt.promisify(function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ObjectDataChanged,{id:t,handler:n},e)});case 16:return rt.promisify(function(e){return Office.context.document.removeHandlerAsync(Office.EventType.ContentControlAdded,{id:t,handler:n},e)});default:throw De.RuntimeError._createInvalidArgError({argumentName:"eventId"})}},Fe=Me,De.officeJsEventRegistration=new Fe;var je=(ke.getTargetIdOrDefault=function(e){return rt.isNullOrUndefined(e)?"":e},ke.prototype.getHandlers=function(e,t){t=ke.getTargetIdOrDefault(t);var n=this.m_handlersByEventByTarget[e];n||(n={},this.m_handlersByEventByTarget[e]=n);var r=n[t];return r||(r=[],n[t]=r),r},ke.prototype.callHandlers=function(e,t,n){for(var r=this.getHandlers(e,t),o=0;o<r.length;o++)r[o](n)},ke.prototype.hasHandlers=function(e,t){return 0<this.getHandlers(e,t).length},ke.prototype.register=function(e,t,n){if(!n)throw h.RuntimeError._createInvalidArgError({argumentName:"handler"});var r=this.getHandlers(e,t);return r.push(n),1===r.length?this.m_registerEventImpl(e,t):rt._createPromiseFromResult(null)},ke.prototype.unregister=function(e,t,n){if(!n)throw h.RuntimeError._createInvalidArgError({argumentName:"handler"});for(var r=this.getHandlers(e,t),o=r.length-1;0<=o;o--)if(r[o]===n){r.splice(o,1);break}return 0===r.length?this.m_unregisterEventImpl(e,t):rt._createPromiseFromResult(null)},ke);function ke(e,t){this.m_handlersByEventByTarget={},this.m_registerEventImpl=e,this.m_unregisterEventImpl=t}m.EventRegistration=je;var He=(Ue.prototype.ready=function(){var e=this;return this.m_ready||(Ue._testReadyImpl?this.m_ready=Ue._testReadyImpl().then(function(){e.m_isReady=!0}):c.instance?this.m_ready=rt._createPromiseFromResult(null).then(function(){e.m_isReady=!0}):this.m_ready=h.officeJsEventRegistration.register(5,"",this.m_richApiMessageHandler).then(function(){e.m_isReady=!0})),this.m_ready},Object.defineProperty(Ue.prototype,"isReady",{get:function(){return this.m_isReady},enumerable:!0,configurable:!0}),Ue.prototype.register=function(e,t,n){var r=this;return this.ready().then(function(){return r.m_eventRegistration.register(e,t,n)})},Ue.prototype.unregister=function(e,t,n){var r=this;return this.ready().then(function(){return r.m_eventRegistration.unregister(e,t,n)})},Ue.prototype._registerEventImpl=function(e,t){return rt._createPromiseFromResult(null)},Ue.prototype._unregisterEventImpl=function(e,t){return rt._createPromiseFromResult(null)},Ue.prototype._handleRichApiMessage=function(e){if(e&&e.entries)for(var t=0;t<e.entries.length;t++){var n=e.entries[t];if(n.messageCategory==Ae.eventMessageCategory){C._logEnabled&&C.log(JSON.stringify(n));var r=n.messageType,o=n.targetId;if(this.m_eventRegistration.hasHandlers(r,o)){var i=JSON.parse(n.message);n.isRemoteOverride&&(i.source=Ae.eventSourceRemote),this.m_eventRegistration.callHandlers(r,o,i)}}}},Ue.getGenericEventRegistration=function(e){C.isNullOrUndefined(e)&&(e="");var t=Ue.s_genericEventRegistrations[e];return t||(t=new Ue,Ue.s_genericEventRegistrations[e]=t),t},Ue.peekGenericEventRegistrationOrNull=function(e){return C.isNullOrUndefined(e)&&(e=""),Ue.s_genericEventRegistrations[e]},Ue.richApiMessageEventCategory=65536,Ue.s_genericEventRegistrations={},Ue);function Ue(){this.m_eventRegistration=new je(this._registerEventImpl.bind(this),this._unregisterEventImpl.bind(this)),this.m_richApiMessageHandler=this._handleRichApiMessage.bind(this)}m.GenericEventRegistration=He,m._testSetRichApiMessageReadyImpl=function(e){He._testReadyImpl=e},m._testTriggerRichApiMessageEvent=function(e){He.getGenericEventRegistration("")._handleRichApiMessage(e)};var Le,Be=(__extends(We,Le=Ie),We.prototype.add=function(e){var t=this;0==this._handlers.length&&this.m_genericEventInfo.registerFunc&&this.m_genericEventInfo.registerFunc();var n=this._context._controlId;return He.getGenericEventRegistration(n).isReady||this._context._pendingRequest._addPreSyncPromise(He.getGenericEventRegistration(n).ready()),ce.createTraceMarkerForCallback(this._context,function(){t._handlers.push(e),1==t._handlers.length&&He.getGenericEventRegistration(n).register(t.m_genericEventInfo.eventType,t.m_genericEventInfo.getTargetIdFunc(),t._callback)}),new Re(this._context,this,e)},We.prototype.remove=function(n){var r=this;1==this._handlers.length&&this.m_genericEventInfo.unregisterFunc&&this.m_genericEventInfo.unregisterFunc();var o=this._context._controlId;ce.createTraceMarkerForCallback(this._context,function(){for(var e=r._handlers,t=e.length-1;0<=t;t--)if(e[t]===n){e.splice(t,1);break}0==e.length&&He.getGenericEventRegistration(o).unregister(r.m_genericEventInfo.eventType,r.m_genericEventInfo.getTargetIdFunc(),r._callback)})},We.prototype.removeAll=function(){},We);function We(e,t,n,r){var o=Le.call(this,e,t,n,r)||this;return o.m_genericEventInfo=r,o}m.GenericEventHandlers=Be;var qe=(Ve.prototype._handleResult=function(e){this.m_clientObject._handleIdResult(e)},Ve);function Ve(e){this.m_clientObject=e}var Ge=(Je.createGlobalObjectObjectPath=function(e){var t={Id:e._nextId(),ObjectPathType:1,Name:""};return new R(t,null,!1,!1,1,4)},Je.createNewObjectObjectPath=function(e,t,n,r){var o={Id:e._nextId(),ObjectPathType:2,Name:t};return new R(o,null,n,!1,1,rt._fixupApiFlags(r))},Je.createPropertyObjectPath=function(e,t,n,r,o,i){var a={Id:e._nextId(),ObjectPathType:4,Name:n,ParentObjectPathId:t._objectPath.objectPathInfo.Id};return new R(a,t._objectPath,r,o,1,rt._fixupApiFlags(i))},Je.createIndexerObjectPath=function(e,t,n){var r={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return r.ArgumentInfo.Arguments=n,new R(r,t._objectPath,!1,!1,1,4)},Je.createIndexerObjectPathUsingParentPath=function(e,t,n){var r={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t.objectPathInfo.Id,ArgumentInfo:{}};return r.ArgumentInfo.Arguments=n,new R(r,t,!1,!1,1,4)},Je.createMethodObjectPath=function(e,t,n,r,o,i,a,s,c){var l={Id:e._nextId(),ObjectPathType:3,Name:n,ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}},u=rt.setMethodArguments(e,l.ArgumentInfo,o),p=new R(l,t._objectPath,i,a,r,rt._fixupApiFlags(c));return p.argumentObjectPaths=u,p.getByIdMethodName=s,p},Je.createReferenceIdObjectPath=function(e,t){var n={Id:e._nextId(),ObjectPathType:6,Name:t,ArgumentInfo:{}};return new R(n,null,!1,!1,1,4)},Je.createChildItemObjectPathUsingIndexerOrGetItemAt=function(e,t,n,r,o){var i=rt.tryGetObjectIdFromLoadOrRetrieveResult(r);return e&&!rt.isNullOrUndefined(i)?Je.createChildItemObjectPathUsingIndexer(t,n,r):Je.createChildItemObjectPathUsingGetItemAt(t,n,r,o)},Je.createChildItemObjectPathUsingIndexer=function(e,t,n){var r=rt.tryGetObjectIdFromLoadOrRetrieveResult(n),o=o={Id:e._nextId(),ObjectPathType:5,Name:"",ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return o.ArgumentInfo.Arguments=[r],new R(o,t._objectPath,!1,!1,1,4)},Je.createChildItemObjectPathUsingGetItemAt=function(e,t,n,r){var o=n[Ae.index];o&&(r=o);var i={Id:e._nextId(),ObjectPathType:3,Name:Ae.getItemAt,ParentObjectPathId:t._objectPath.objectPathInfo.Id,ArgumentInfo:{}};return i.ArgumentInfo.Arguments=[r],new R(i,t._objectPath,!1,!1,1,4)},Je);function Je(){}m.ObjectPathFactory=Ge;var ze=(Ke.prototype.executeAsync=function(e,t,n){var r=this,o=O.buildMessageArrayForIRequestExecutor(e,t,n,Ke.SourceLibHeaderValue);return new m.Promise(function(n,e){OSF.DDA.RichApi.executeRichApiRequestAsync(o,function(e){var t;C.log("Response:"),C.log(JSON.stringify(e)),"succeeded"==e.status?t=O.buildResponseOnSuccess(O.getResponseBody(e),O.getResponseHeaders(e)):(t=O.buildResponseOnError(e.error.code,e.error.message),r.m_context._processOfficeJsErrorResponse(e.error.code,t)),n(t)})})},Ke.SourceLibHeaderValue="officejs",Ke);function Ke(e){this.m_context=e}var Xe=(Qe.prototype.add=function(e){var t=this;Array.isArray(e)?e.forEach(function(e){return t._addCommon(e,!0)}):this._addCommon(e,!0)},Qe.prototype._autoAdd=function(e){this._addCommon(e,!1),this._autoCleanupList[e._objectPath.objectPathInfo.Id]=e},Qe.prototype._autoTrackIfNecessaryWhenHandleObjectResultValue=function(e,t){this.m_context._autoCleanup&&!e[Ae.isTracked]&&e!==this.m_context._rootObject&&t&&!rt.isNullOrEmptyString(t[Ae.referenceId])&&((this._autoCleanupList[e._objectPath.objectPathInfo.Id]=e)[Ae.isTracked]=!0)},Qe.prototype._addCommon=function(e,t){if(e[Ae.isTracked])t&&this.m_context._autoCleanup&&delete this._autoCleanupList[e._objectPath.objectPathInfo.Id];else{var n=e[Ae.referenceId];if(e._objectPath.objectPathInfo[Ae.objectPathInfoDoNotKeepReferenceFieldName])throw rt.createRuntimeError(g.generalException,C._getResourceString(et.objectIsUntracked),null);rt.isNullOrEmptyString(n)&&e._KeepReference&&(e._KeepReference(),ce.createInstantiateAction(this.m_context,e),t&&this.m_context._autoCleanup&&delete this._autoCleanupList[e._objectPath.objectPathInfo.Id],e[Ae.isTracked]=!0)}},Qe.prototype.remove=function(e){var t=this;Array.isArray(e)?e.forEach(function(e){return t._removeCommon(e)}):this._removeCommon(e)},Qe.prototype._removeCommon=function(e){e._objectPath.objectPathInfo[Ae.objectPathInfoDoNotKeepReferenceFieldName]=!0,e.context._pendingRequest._removeKeepReferenceAction(e._objectPath.objectPathInfo.Id);var t=e[Ae.referenceId];if(!rt.isNullOrEmptyString(t)){var n=this.m_context._rootObject;n._RemoveReference&&n._RemoveReference(t)}delete e[Ae.isTracked]},Qe.prototype._retrieveAndClearAutoCleanupList=function(){var e=this._autoCleanupList;return this._autoCleanupList={},e},Qe);function Qe(e){this._autoCleanupList={},this.m_context=e}m.TrackedObjects=Xe;var $e=(Ze.prototype.process=function(){this.m_showDispose&&Te._calculateLastUsedObjectPathIds(this.m_actions);for(var e=0;e<this.m_actions.length;e++)this.processOneAction(this.m_actions[e]);return this.m_statements},Ze.prototype.processForDebugStatementInfo=function(e){this.m_showDispose&&Te._calculateLastUsedObjectPathIds(this.m_actions),this.m_statements=[];for(var t=-1,n=0;n<this.m_actions.length&&(this.processOneAction(this.m_actions[n]),e==n&&(t=this.m_statements.length-1),!(0<=t&&this.m_statements.length>t+5+1));n++);if(t<0)return null;var r=t-5;r<0&&(r=0);var o=t+1+5;o>this.m_statements.length&&(o=this.m_statements.length);var i=[];0!=r&&i.push("...");for(var a=r;a<t;a++)i.push(this.m_statements[a]);i.push("// >>>>>"),i.push(this.m_statements[t]),i.push("// <<<<<");for(var s=t+1;s<o;s++)i.push(this.m_statements[s]);return o<this.m_statements.length&&i.push("..."),{statement:this.m_statements[t],surroundingStatements:i}},Ze.prototype.processOneAction=function(e){switch(e.actionInfo.ActionType){case 1:this.processInstantiateAction(e);break;case 3:this.processMethodAction(e);break;case 2:this.processQueryAction(e);break;case 7:this.processQueryAsJsonAction(e);break;case 6:this.processRecursiveQueryAction(e);break;case 4:this.processSetPropertyAction(e);break;case 5:this.processTraceAction(e);break;case 8:this.processEnsureUnchangedAction(e);break;case 9:this.processUpdateAction(e)}},Ze.prototype.processInstantiateAction=function(e){var t=e.actionInfo.ObjectPathId,n=this.m_referencedObjectPaths[t],r=this.getObjVarName(t);if(this.m_declaredObjectPathMap[t])o="// Instantiate {"+r+"}",o=this.appendDisposeCommentIfRelevant(o,e),this.m_statements.push(o);else{var o="var "+r+" = "+this.buildObjectPathExpressionWithParent(n)+";";o=this.appendDisposeCommentIfRelevant(o,e),this.m_statements.push(o),this.m_declaredObjectPathMap[t]=r}},Ze.prototype.processMethodAction=function(e){var t=e.actionInfo.Name;if("_KeepReference"===t){if(!m._internalConfig.showInternalApiInDebugInfo)return;t="track"}var n=this.getObjVarName(e.actionInfo.ObjectPathId)+"."+rt._toCamelLowerCase(t)+"("+this.buildArgumentsExpression(e.actionInfo.ArgumentInfo)+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},Ze.prototype.processQueryAction=function(e){var t=this.buildQueryExpression(e),n=this.getObjVarName(e.actionInfo.ObjectPathId)+".load("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},Ze.prototype.processQueryAsJsonAction=function(e){var t=this.buildQueryExpression(e),n=this.getObjVarName(e.actionInfo.ObjectPathId)+".retrieve("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},Ze.prototype.processRecursiveQueryAction=function(e){var t="";e.actionInfo.RecursiveQueryInfo&&(t=JSON.stringify(e.actionInfo.RecursiveQueryInfo));var n=this.getObjVarName(e.actionInfo.ObjectPathId)+".loadRecursive("+t+");";n=this.appendDisposeCommentIfRelevant(n,e),this.m_statements.push(n)},Ze.prototype.processSetPropertyAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+"."+rt._toCamelLowerCase(e.actionInfo.Name)+" = "+this.buildArgumentsExpression(e.actionInfo.ArgumentInfo)+";";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},Ze.prototype.processTraceAction=function(e){var t="context.trace();";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},Ze.prototype.processEnsureUnchangedAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+".ensureUnchanged("+JSON.stringify(e.actionInfo.ObjectState)+");";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},Ze.prototype.processUpdateAction=function(e){var t=this.getObjVarName(e.actionInfo.ObjectPathId)+".update("+JSON.stringify(e.actionInfo.ObjectState)+");";t=this.appendDisposeCommentIfRelevant(t,e),this.m_statements.push(t)},Ze.prototype.appendDisposeCommentIfRelevant=function(e,t){var n=this;if(this.m_showDispose){var r=t.actionInfo.L;if(r&&0<r.length)return e+" // And then dispose {"+r.map(function(e){return n.getObjVarName(e)}).join(", ")+"}"}return e},Ze.prototype.buildQueryExpression=function(e){if(e.actionInfo.QueryInfo){var t={};return t.select=e.actionInfo.QueryInfo.Select,t.expand=e.actionInfo.QueryInfo.Expand,t.skip=e.actionInfo.QueryInfo.Skip,t.top=e.actionInfo.QueryInfo.Top,void 0===t.top&&void 0===t.skip&&void 0===t.expand?void 0===t.select?"":JSON.stringify(t.select):JSON.stringify(t)}return""},Ze.prototype.buildObjectPathExpressionWithParent=function(e){return 5!=e.objectPathInfo.ObjectPathType&&3!=e.objectPathInfo.ObjectPathType&&4!=e.objectPathInfo.ObjectPathType||!e.objectPathInfo.ParentObjectPathId?this.buildObjectPathExpression(e):this.getObjVarName(e.objectPathInfo.ParentObjectPathId)+"."+this.buildObjectPathExpression(e)},Ze.prototype.buildObjectPathExpression=function(e){var t=this.buildObjectPathInfoExpression(e.objectPathInfo),n=e.originalObjectPathInfo;return n&&(t=t+" /* originally "+this.buildObjectPathInfoExpression(n)+" */"),t},Ze.prototype.buildObjectPathInfoExpression=function(e){switch(e.ObjectPathType){case 1:return"context."+this.m_globalObjName;case 5:return"getItem("+this.buildArgumentsExpression(e.ArgumentInfo)+")";case 3:return rt._toCamelLowerCase(e.Name)+"("+this.buildArgumentsExpression(e.ArgumentInfo)+")";case 2:return e.Name+".newObject()";case 7:return"null";case 4:return rt._toCamelLowerCase(e.Name);case 6:return"context."+this.m_globalObjName+"._getObjectByReferenceId("+JSON.stringify(e.Name)+")"}},Ze.prototype.buildArgumentsExpression=function(e){var t="";if(!e.Arguments||0===e.Arguments.length)return t;if(this.m_removePII)return void 0===e.Arguments[0]?t:"...";for(var n=0;n<e.Arguments.length;n++)0<n&&(t+=", "),t+=this.buildArgumentLiteral(e.Arguments[n],e.ReferencedObjectPathIds?e.ReferencedObjectPathIds[n]:null);return"undefined"===t&&(t=""),t},Ze.prototype.buildArgumentLiteral=function(e,t){return"number"==typeof e&&e===t?this.getObjVarName(t):JSON.stringify(e)},Ze.prototype.getObjVarNameBase=function(e){var t="v",n=this.m_referencedObjectPaths[e];if(n)switch(n.objectPathInfo.ObjectPathType){case 1:t=this.m_globalObjName;break;case 4:t=rt._toCamelLowerCase(n.objectPathInfo.Name);break;case 3:var r=n.objectPathInfo.Name;3<r.length&&"Get"===r.substr(0,3)&&(r=r.substr(3)),t=rt._toCamelLowerCase(r);break;case 5:var o=this.getObjVarNameBase(n.objectPathInfo.ParentObjectPathId);t="s"===o.charAt(o.length-1)?o.substr(0,o.length-1):o+"Item"}return t},Ze.prototype.getObjVarName=function(e){if(this.m_variableNameForObjectPathMap[e])return this.m_variableNameForObjectPathMap[e];var t=this.getObjVarNameBase(e);if(!this.m_variableNameToObjectPathMap[t])return this.m_variableNameForObjectPathMap[e]=t,this.m_variableNameToObjectPathMap[t]=e,t;for(var n=1;this.m_variableNameToObjectPathMap[t+n.toString()];)n++;return t+=n.toString(),this.m_variableNameForObjectPathMap[e]=t,this.m_variableNameToObjectPathMap[t]=e,t},Ze);function Ze(e,t,n,r,o){e=e||"root",this.m_globalObjName=e,this.m_referencedObjectPaths=t,this.m_actions=n,this.m_statements=[],this.m_variableNameForObjectPathMap={},this.m_variableNameToObjectPathMap={},this.m_declaredObjectPathMap={},this.m_showDispose=r,this.m_removePII=o}var Ye,et=(__extends(tt,Ye=ee),tt.cannotRegisterEvent="CannotRegisterEvent",tt.connectionFailureWithStatus="ConnectionFailureWithStatus",tt.connectionFailureWithDetails="ConnectionFailureWithDetails",tt.propertyNotLoaded="PropertyNotLoaded",tt.runMustReturnPromise="RunMustReturnPromise",tt.moreInfoInnerError="MoreInfoInnerError",tt.cannotApplyPropertyThroughSetMethod="CannotApplyPropertyThroughSetMethod",tt.invalidOperationInCellEditMode="InvalidOperationInCellEditMode",tt.objectIsUntracked="ObjectIsUntracked",tt.customFunctionDefintionMissing="CustomFunctionDefintionMissing",tt.customFunctionImplementationMissing="CustomFunctionImplementationMissing",tt.customFunctionNameContainsBadChars="CustomFunctionNameContainsBadChars",tt.customFunctionNameCannotSplit="CustomFunctionNameCannotSplit",tt.customFunctionUnexpectedNumberOfEntriesInResultBatch="CustomFunctionUnexpectedNumberOfEntriesInResultBatch",tt.customFunctionCancellationHandlerMissing="CustomFunctionCancellationHandlerMissing",tt.customFunctionInvalidFunction="CustomFunctionInvalidFunction",tt.customFunctionInvalidFunctionMapping="CustomFunctionInvalidFunctionMapping",tt.customFunctionWindowMissing="CustomFunctionWindowMissing",tt.customFunctionDefintionMissingOnWindow="CustomFunctionDefintionMissingOnWindow",tt.pendingBatchInProgress="PendingBatchInProgress",tt.notInsideBatch="NotInsideBatch",tt.cannotUpdateReadOnlyProperty="CannotUpdateReadOnlyProperty",tt);function tt(){return null!==Ye&&Ye.apply(this,arguments)||this}m.ResourceStrings=et,C.addResourceStringValues({CannotRegisterEvent:"The event handler cannot be registered.",PropertyNotLoaded:"The property '{0}' is not available. Before reading the property's value, call the load method on the containing object and call \"context.sync()\" on the associated request context.",RunMustReturnPromise:'The batch function passed to the ".run" method didn\'t return a promise. The function must return a promise, so that any automatically-tracked objects can be released at the completion of the batch operation. Typically, you return a promise by returning the response from "context.sync()".',InvalidOrTimedOutSessionMessage:"Your Office Online session has expired or is invalid. To continue, refresh the page.",InvalidOperationInCellEditMode:"Excel is in cell-editing mode. Please exit the edit mode by pressing ENTER or TAB or selecting another cell, and then try again.",InvalidSheetName:"The request cannot be processed because the specified worksheet cannot be found. Please try again.",CustomFunctionDefintionMissing:"A property with the name '{0}' that represents the function's definition must exist on Excel.Script.CustomFunctions.",CustomFunctionDefintionMissingOnWindow:"A property with the name '{0}' that represents the function's definition must exist on the window object.",CustomFunctionImplementationMissing:"The property with the name '{0}' on Excel.Script.CustomFunctions that represents the function's definition must contain a 'call' property that implements the function.",CustomFunctionNameContainsBadChars:"The function name may only contain letters, digits, underscores, and periods.",CustomFunctionNameCannotSplit:"The function name must contain a non-empty namespace and a non-empty short name.",CustomFunctionUnexpectedNumberOfEntriesInResultBatch:"The batching function returned a number of results that doesn't match the number of parameter value sets that were passed into it.",CustomFunctionCancellationHandlerMissing:"The cancellation handler onCanceled is missing in the function. The handler must be present as the function is defined as cancelable.",CustomFunctionInvalidFunction:"The property with the name '{0}' that represents the function's definition is not a valid function.",CustomFunctionInvalidFunctionMapping:"The property with the name '{0}' on CustomFunctionMappings that represents the function's definition is not a valid function.",CustomFunctionWindowMissing:"The window object was not found.",PendingBatchInProgress:"There is a pending batch in progress. The batch method may not be called inside another batch, or simultaneously with another batch.",NotInsideBatch:"Operations may not be invoked outside of a batch method.",CannotUpdateReadOnlyProperty:"The property '{0}' is read-only and it cannot be updated.",ObjectIsUntracked:"The object is untracked."});var nt,rt=(__extends(ot,nt=$),ot.fixObjectPathIfNecessary=function(e,t){e&&e._objectPath&&t&&e._objectPath.updateUsingObjectData(t,e)},ot.load=function(e,t){return e.context.load(e,t),e},ot.loadAndSync=function(e,t){return e.context.load(e,t),e.context.sync().then(function(){return e})},ot.retrieve=function(e,t){var n=m._internalConfig.alwaysPolyfillClientObjectRetrieveMethod;n=n||!ot.isSetSupported("RichApiRuntime","1.1");var r=new Oe(e,n);return e._retrieve(t,r),r},ot.retrieveAndSync=function(e,t){var n=ot.retrieve(e,t);return e.context.sync().then(function(){return n})},ot.toJson=function(e,t,n,r){var o={};for(var i in t)void 0!==(a=t[i])&&(o[i]=a);for(var i in n){var a;void 0!==(a=n[i])&&(a[ot.fieldName_isCollection]&&void 0!==a[ot.fieldName_m__items]?o[i]=a.toJSON().items:o[i]=a.toJSON())}return r&&(o.items=r.map(function(e){return e.toJSON()})),o},ot.throwError=function(e,t,n){throw new h.RuntimeError({code:e,httpStatusCode:400,message:C._getResourceString(e,t),debugInfo:n?{errorLocation:n}:void 0})},ot.createRuntimeError=function(e,t,n,r,o){return new h.RuntimeError({code:e,httpStatusCode:r,message:t,debugInfo:{errorLocation:n},data:o})},ot.throwIfNotLoaded=function(e,t,n,r){if(!r&&C.isUndefined(t)&&e.charCodeAt(0)!=ot.s_underscoreCharCode&&!ot.s_suppressPropertyNotLoadedException)throw ot.createPropertyNotLoadedException(n,e)},ot._getPropertyValueWithoutCheckLoaded=function(e,t){ot.s_suppressPropertyNotLoadedException=!0;try{return e[t]}finally{ot.s_suppressPropertyNotLoadedException=!1}},ot.createPropertyNotLoadedException=function(e,t){return new h.RuntimeError({code:re.propertyNotLoaded,httpStatusCode:400,message:C._getResourceString(et.propertyNotLoaded,t),debugInfo:e?{errorLocation:e+"."+t}:void 0})},ot.createCannotUpdateReadOnlyPropertyException=function(e,t){return new h.RuntimeError({code:re.cannotUpdateReadOnlyProperty,httpStatusCode:400,message:C._getResourceString(et.cannotUpdateReadOnlyProperty,t),debugInfo:e?{errorLocation:e+"."+t}:void 0})},ot.promisify=function(e){return new m.Promise(function(t,n){e(function(e){"failed"==e.status?n(e.error):t(e.value)})})},ot._addActionResultHandler=function(e,t,n){e.context._pendingRequest.addActionResultHandler(t,n)},ot._handleNavigationPropertyResults=function(e,t,n){for(var r=0;r<n.length-1;r+=2)C.isUndefined(t[n[r+1]])||e[n[r]]._handleResult(t[n[r+1]])},ot._fixupApiFlags=function(e){return"boolean"==typeof e&&(e=e?1:0),e},ot.definePropertyThrowUnloadedException=function(e,t,n){Object.defineProperty(e,n,{configurable:!0,enumerable:!0,get:function(){throw ot.createPropertyNotLoadedException(t,n)},set:function(){throw ot.createCannotUpdateReadOnlyPropertyException(t,n)}})},ot.defineReadOnlyPropertyWithValue=function(e,t,n){Object.defineProperty(e,t,{configurable:!0,enumerable:!0,get:function(){return n},set:function(){throw ot.createCannotUpdateReadOnlyPropertyException(null,t)}})},ot.processRetrieveResult=function(e,t,n,r){if(!C.isNullOrUndefined(t))if(r){var o=t[Ae.itemsLowerCase];if(Array.isArray(o)){for(var i=[],a=0;a<o.length;a++){var s=r(o[a],a),c={};(c[Ae.proxy]=s)._handleRetrieveResult(o[a],c),i.push(c)}ot.defineReadOnlyPropertyWithValue(n,Ae.itemsLowerCase,i)}}else{var l=e[Ae.scalarPropertyNames],u=e[Ae.navigationPropertyNames],p=e[Ae.className];if(l)for(a=0;a<l.length;a++){var f=t[d=l[a]];C.isUndefined(f)?ot.definePropertyThrowUnloadedException(n,p,d):ot.defineReadOnlyPropertyWithValue(n,d,f)}if(u)for(a=0;a<u.length;a++){var d;if(f=t[d=u[a]],C.isUndefined(f))ot.definePropertyThrowUnloadedException(n,p,d);else{var h=e[d],g={};h._handleRetrieveResult(f,g),g[Ae.proxy]=h,Array.isArray(g[Ae.itemsLowerCase])&&(g=g[Ae.itemsLowerCase]),ot.defineReadOnlyPropertyWithValue(n,d,g)}}}},ot.setMockData=function(e,t,n,r){if(C.isNullOrUndefined(t))e._handleResult(t);else{if(e[Ae.scalarPropertyOriginalNames]){for(var o={},i=e[Ae.scalarPropertyOriginalNames],a=e[Ae.scalarPropertyNames],s=0;s<a.length;s++)void 0!==t[a[s]]&&(o[i[s]]=t[a[s]]);e._handleResult(o)}if(e[Ae.navigationPropertyNames]){var c=e[Ae.navigationPropertyNames];for(s=0;s<c.length;s++)if(void 0!==t[c[s]]){var l=e[c[s]];l.setMockData&&l.setMockData(t[c[s]])}}if(e[Ae.isCollection]&&n){var u=Array.isArray(t)?t:t[Ae.itemsLowerCase];if(Array.isArray(u)){var p=[];for(s=0;s<u.length;s++){var f=n(u,s);ot.setMockData(f,u[s]),p.push(f)}r(p)}}}},ot.applyMixin=function(t,n){Object.getOwnPropertyNames(n.prototype).forEach(function(e){"constructor"!==e&&Object.defineProperty(t.prototype,e,Object.getOwnPropertyDescriptor(n.prototype,e))})},ot.ensureTypeInitialized=function(e){var t=new be;new e(t,Ge.createNewObjectObjectPath(t,"Temp",!1,0))},ot.fieldName_m__items="m__items",ot.fieldName_isCollection="_isCollection",ot._synchronousCleanup=!1,ot.s_underscoreCharCode="_".charCodeAt(0),ot.s_suppressPropertyNotLoadedException=!1,ot);function ot(){return null!==nt&&nt.apply(this,arguments)||this}m.Utility=rt;var it=(at.invokeMethod=function(e,t,n,r,o,i){var a=ce.createMethodAction(e.context,e,t,n,r,o),s=new B(i);return rt._addActionResultHandler(e,a,s),s},at.invokeEnsureUnchanged=function(e,t){ce.createEnsureUnchangedAction(e.context,e,t)},at.invokeSetProperty=function(e,t,n,r){ce.createSetPropertyAction(e.context,e,t,n,r)},at.createRootServiceObject=function(e,t){return new e(t,Ge.createGlobalObjectObjectPath(t))},at.createObjectFromReferenceId=function(e,t,n){return new e(t,Ge.createReferenceIdObjectPath(t,n))},at.createTopLevelServiceObject=function(e,t,n,r,o){return new e(t,Ge.createNewObjectObjectPath(t,n,r,o))},at.createPropertyObject=function(e,t,n,r,o){var i=Ge.createPropertyObjectPath(t.context,t,n,r,!1,o);return new e(t.context,i)},at.createIndexerObject=function(e,t,n){var r=Ge.createIndexerObjectPath(t.context,t,n);return new e(t.context,r)},at.createMethodObject=function(e,t,n,r,o,i,a,s,c){var l=Ge.createMethodObjectPath(t.context,t,n,r,o,i,a,s,c);return new e(t.context,l)},at.createChildItemObject=function(e,t,n,r,o){var i=Ge.createChildItemObjectPathUsingIndexerOrGetItemAt(t,n.context,n,r,o);return new e(n.context,i)},at);function at(){}m.BatchApiHelper=it;var st=(ct.prototype.ensureArraySize=function(e,t){for(var n=t-e.length;0<n;)e.push(0),n--},ct.prototype.getString=function(e){return"number"==typeof e?0<e?this.m_strings[e-1]:null:e},ct.prototype.buildEnumType=function(e){var t;if(Array.isArray(e)){(t={name:e[0],fields:e[2]}).fields||(t.fields={});var n=e[1];if(Array.isArray(n))for(var r=0;r<n.length;r++)t.fields[n[r]]=this.toSimpleCamelUpperCase(n[r])}else t=e;this.m_targetNamespaceObject[t.name]=t.fields},ct.prototype.buildClientObjectType=function(n,e){function t(e,t){pe.apply(this,arguments),r.m_targetNamespaceObject[n.name]._typeInited||(r.buildPrototype(r.m_targetNamespaceObject[n.name],n),r.m_targetNamespaceObject[n.name]._typeInited=!0),m._internalConfig.appendTypeNameToObjectPathInfo&&this._objectPath&&this._objectPath.objectPathInfo&&this._className&&(this._objectPath.objectPathInfo.T=this._className)}var r=this;this.m_targetNamespaceObject[n.name]=t,this.extendsType(t,pe),this.buildNewObject(t,n),0!=(2&n.behaviorFlags)&&(t.prototype._KeepReference=function(){it.invokeMethod(this,"_KeepReference",1,[],0,0)}),0!=(32&n.behaviorFlags)&&this.getFunction(ct.CustomizationCodeNamespace+"."+n.name+"_StaticCustomize").call(null,t),e&&(this.buildPrototype(t,n),t._typeInited=!0)},ct.prototype.extendsType=function(e,t){function n(){this.constructor=e}e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)},ct.prototype.findObjectUnderPath=function(e,t,n){for(var r=e,o=n;o<t.length;o++){if("object"!=typeof r)throw new m.Error("Cannot find "+t.join("."));r=r[t[o]]}return r},ct.prototype.getFunction=function(e){var t=this.resolveObjectByFullName(e);if("function"!=typeof t)throw new m.Error("Cannot find function or type: "+e);return t},ct.prototype.resolveObjectByFullName=function(e){var t=e.split(".");if(1===t.length)return this.m_targetNamespaceObject[t[0]];var n=t[0];return n===this.m_namespace?this.findObjectUnderPath(this.m_targetNamespaceObject,t,1):this.m_namespaceMap[n]?this.findObjectUnderPath(this.m_namespaceMap[n],t,1):this.findObjectUnderPath(this.m_targetNamespaceObject,t,0)},ct.prototype.evaluateSimpleExpression=function(e,t){if(rt.isNullOrUndefined(e))return null;var n=e.split(".");if(3===n.length&&"OfficeExtension"===n[0]&&"Constants"===n[1])return Ae[n[2]];if("this"!==n[0])throw new m.Error("Cannot evaluate: "+e);for(var r=t,o=1;o<n.length;o++)r="toString()"==n[o]?r.toString():"()"===n[o].substr(n[o].length-2)?r[n[o].substr(0,n[o].length-2)]():r[n[o]];return r},ct.prototype.evaluateEventTargetId=function(e,t){return rt.isNullOrEmptyString(e)?"":this.evaluateSimpleExpression(e,t)},ct.prototype.isAllDigits=function(e){for(var t="0".charCodeAt(0),n="9".charCodeAt(0),r=0;r<e.length;r++)if(e.charCodeAt(r)<t||e.charCodeAt(r)>n)return!1;return!0},ct.prototype.evaluateEventType=function(e){if(rt.isNullOrEmptyString(e))return 0;if(this.isAllDigits(e))return parseInt(e);var t=this.resolveObjectByFullName(e);if("number"!=typeof t)throw new m.Error("Invalid event type: "+e);return t},ct.prototype.buildPrototype=function(e,t){this.buildScalarProperties(e,t),this.buildNavigationProperties(e,t),this.buildScalarMethods(e,t),this.buildNavigationMethods(e,t),this.buildEvents(e,t),this.buildHandleResult(e,t),this.buildHandleIdResult(e,t),this.buildHandleRetrieveResult(e,t),this.buildLoad(e,t),this.buildRetrieve(e,t),this.buildSetMockData(e,t),this.buildEnsureUnchanged(e,t),this.buildUpdate(e,t),this.buildSet(e,t),this.buildToJSON(e,t),this.buildItems(e,t),this.buildTypeMetadataInfo(e,t),this.buildTrackUntrack(e,t),this.buildMixin(e,t)},ct.prototype.toSimpleCamelUpperCase=function(e){return e.substr(0,1).toUpperCase()+e.substr(1)},ct.prototype.ensureOriginalName=function(e){null===e.originalName&&(e.originalName=this.toSimpleCamelUpperCase(e.name))},ct.prototype.getFieldName=function(e){return"m_"+e.name},ct.prototype.throwIfApiNotSupported=function(e,t){if(this.m_apiSets&&0<t.apiSetInfoOrdinal){var n=this.m_apiSets[t.apiSetInfoOrdinal-1];n&&rt.throwIfApiNotSupported(e.name+"."+t.name,n.name,n.version,this.m_hostName)}},ct.prototype.buildScalarProperties=function(e,t){if(Array.isArray(t.scalarProperties))for(var n=0;n<t.scalarProperties.length;n++){var r=t.scalarProperties[n];Array.isArray(r)&&(this.ensureArraySize(r,6),t.scalarProperties[n]={name:this.getString(r[0]),behaviorFlags:r[1],apiSetInfoOrdinal:r[2],originalName:this.getString(r[3]),setMethodApiFlags:r[4],undoableApiSetInfoOrdinal:r[5]}),this.buildScalarProperty(e,t,t.scalarProperties[n])}},ct.prototype.calculateApiFlags=function(e,t){if(0<t){var n=this.m_apiSets[t-1];n&&(e=$.calculateApiFlags(e,n.name,n.version))}return e},ct.prototype.buildScalarProperty=function(e,n,r){this.ensureOriginalName(r);var o=this,i=this.getFieldName(r),t={get:function(){return rt.throwIfNotLoaded(r.name,this[i],n.name,this._isNull),o.throwIfApiNotSupported(n,r),this[i]},enumerable:!0,configurable:!0};0==(2&r.behaviorFlags)&&(t.set=function(e){if(!(4&r.behaviorFlags&&o.getFunction(ct.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Set").call(this,this,e).handled)){this[i]=e;var t=o.calculateApiFlags(r.setMethodApiFlags,r.undoableApiSetInfoOrdinal);it.invokeSetProperty(this,r.originalName,e,t)}}),Object.defineProperty(e.prototype,r.name,t)},ct.prototype.buildNavigationProperties=function(e,t){if(Array.isArray(t.navigationProperties))for(var n=0;n<t.navigationProperties.length;n++){var r=t.navigationProperties[n];Array.isArray(r)&&(this.ensureArraySize(r,8),t.navigationProperties[n]={name:this.getString(r[0]),behaviorFlags:r[2],apiSetInfoOrdinal:r[3],originalName:this.getString(r[4]),getMethodApiFlags:r[5],setMethodApiFlags:r[6],propertyTypeFullName:this.getString(r[1]),undoableApiSetInfoOrdinal:r[7]}),this.buildNavigationProperty(e,t,t.navigationProperties[n])}},ct.prototype.buildNavigationProperty=function(e,n,r){this.ensureOriginalName(r);var o=this,i=this.getFieldName(r),t={get:function(){return this[o.getFieldName(r)]||(o.throwIfApiNotSupported(n,r),this[i]=it.createPropertyObject(o.getFunction(r.propertyTypeFullName),this,r.originalName,0!=(16&r.behaviorFlags),r.getMethodApiFlags)),64&r.behaviorFlags&&o.getFunction(ct.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Get").call(this,this,this[i]),this[i]},enumerable:!0,configurable:!0};0==(2&r.behaviorFlags)&&(t.set=function(e){if(!(4&r.behaviorFlags&&o.getFunction(ct.CustomizationCodeNamespace+"."+n.name+"_"+r.originalName+"_Set").call(this,this,e).handled)){this[i]=e;var t=o.calculateApiFlags(r.setMethodApiFlags,r.undoableApiSetInfoOrdinal);it.invokeSetProperty(this,r.originalName,e,t)}}),Object.defineProperty(e.prototype,r.name,t)},ct.prototype.buildScalarMethods=function(e,t){if(Array.isArray(t.scalarMethods))for(var n=0;n<t.scalarMethods.length;n++){var r=t.scalarMethods[n];Array.isArray(r)&&(this.ensureArraySize(r,7),t.scalarMethods[n]={name:this.getString(r[0]),behaviorFlags:r[2],apiSetInfoOrdinal:r[3],originalName:this.getString(r[5]),apiFlags:r[4],parameterCount:r[1],undoableApiSetInfoOrdinal:r[6]}),this.buildScalarMethod(e,t,t.scalarMethods[n])}},ct.prototype.buildScalarMethod=function(e,p,f){this.ensureOriginalName(f);var d=this;e.prototype[f.name]=function(){var e=[];if(64&f.behaviorFlags&&0<f.parameterCount){for(var t=0;t<f.parameterCount-1;t++)e.push(arguments[t]);var n=[];for(t=f.parameterCount-1;t<arguments.length;t++)n.push(arguments[t]);e.push(n)}else for(t=0;t<arguments.length;t++)e.push(arguments[t]);if(1&f.behaviorFlags){var r=d.getFunction(ct.CustomizationCodeNamespace+"."+p.name+"_"+f.originalName),o=[this];for(t=0;t<e.length;t++)o.push(e[t]);var i=r.apply(this,o),a=i.handled,s=i.result;if(a)return s}d.throwIfApiNotSupported(p,f);var c=0;32&f.behaviorFlags&&(c=1);var l=0;2&f.behaviorFlags&&(l=1);var u=d.calculateApiFlags(f.apiFlags,f.undoableApiSetInfoOrdinal);return it.invokeMethod(this,f.originalName,l,e,u,c)}},ct.prototype.buildNavigationMethods=function(e,t){if(Array.isArray(t.navigationMethods))for(var n=0;n<t.navigationMethods.length;n++){var r=t.navigationMethods[n];Array.isArray(r)&&(this.ensureArraySize(r,9),t.navigationMethods[n]={name:this.getString(r[0]),behaviorFlags:r[3],apiSetInfoOrdinal:r[4],originalName:this.getString(r[6]),apiFlags:r[5],parameterCount:r[2],returnTypeFullName:this.getString(r[1]),returnObjectGetByIdMethodName:this.getString(r[7]),undoableApiSetInfoOrdinal:r[8]}),this.buildNavigationMethod(e,t,t.navigationMethods[n])}},ct.prototype.buildNavigationMethod=function(e,u,p){this.ensureOriginalName(p);var f=this;e.prototype[p.name]=function(){var e=[];if(64&p.behaviorFlags&&0<p.parameterCount){for(var t=0;t<p.parameterCount-1;t++)e.push(arguments[t]);var n=[];for(t=p.parameterCount-1;t<arguments.length;t++)n.push(arguments[t]);e.push(n)}else for(t=0;t<arguments.length;t++)e.push(arguments[t]);if(1&p.behaviorFlags){var r=f.getFunction(ct.CustomizationCodeNamespace+"."+u.name+"_"+p.originalName),o=[this];for(t=0;t<e.length;t++)o.push(e[t]);var i=r.apply(this,o),a=i.handled,s=i.result;if(a)return s}if(f.throwIfApiNotSupported(u,p),0!=(16&p.behaviorFlags))return it.createIndexerObject(f.getFunction(p.returnTypeFullName),this,e);var c=0;2&p.behaviorFlags&&(c=1);var l=f.calculateApiFlags(p.apiFlags,p.undoableApiSetInfoOrdinal);return it.createMethodObject(f.getFunction(p.returnTypeFullName),this,p.originalName,c,e,0!=(4&p.behaviorFlags),0!=(8&p.behaviorFlags),p.returnObjectGetByIdMethodName,l)}},ct.prototype.buildHandleResult=function(e,l){var u=this;e.prototype._handleResult=function(e){if(pe.prototype._handleResult.call(this,e),!rt.isNullOrUndefined(e)){if(rt.fixObjectPathIfNecessary(this,e),8&l.behaviorFlags&&u.getFunction(ct.CustomizationCodeNamespace+"."+l.name+"_HandleResult").call(this,this,e),l.scalarProperties)for(var t=0;t<l.scalarProperties.length;t++)rt.isUndefined(e[l.scalarProperties[t].originalName])||(0!=(8&l.scalarProperties[t].behaviorFlags)?this[u.getFieldName(l.scalarProperties[t])]=rt.adjustToDateTime(e[l.scalarProperties[t].originalName]):this[u.getFieldName(l.scalarProperties[t])]=e[l.scalarProperties[t].originalName]);if(l.navigationProperties){for(var n=[],r=0;r<l.navigationProperties.length;r++)n.push(l.navigationProperties[r].name),n.push(l.navigationProperties[r].originalName);rt._handleNavigationPropertyResults(this,e,n)}if(0!=(1&l.behaviorFlags)){var o=u.hasIndexMethod(l);if(!rt.isNullOrUndefined(e[Ae.items])){this.m__items=[];for(var i=e[Ae.items],a=u.getFunction(l.childItemTypeFullName),s=0;s<i.length;s++){var c=it.createChildItemObject(a,o,this,i[s],s);c._handleResult(i[s]),this.m__items.push(c)}}}}}},ct.prototype.buildHandleRetrieveResult=function(e,a){var s=this;e.prototype._handleRetrieveResult=function(e,t){if(pe.prototype._handleRetrieveResult.call(this,e,t),!rt.isNullOrUndefined(e)){if(a.scalarProperties)for(var n=0;n<a.scalarProperties.length;n++)8&a.scalarProperties[n].behaviorFlags&&(rt.isNullOrUndefined(e[a.scalarProperties[n].name])||(e[a.scalarProperties[n].name]=rt.adjustToDateTime(e[a.scalarProperties[n].name])));if(1&a.behaviorFlags){var r=s.hasIndexMethod(a),o=s.getFunction(a.childItemTypeFullName),i=this;rt.processRetrieveResult(i,e,t,function(e,t){return it.createChildItemObject(o,r,i,e,t)})}else rt.processRetrieveResult(this,e,t)}}},ct.prototype.buildHandleIdResult=function(e,r){var o=this;e.prototype._handleIdResult=function(e){if(pe.prototype._handleIdResult.call(this,e),!rt.isNullOrUndefined(e)&&(16&r.behaviorFlags&&o.getFunction(ct.CustomizationCodeNamespace+"."+r.name+"_HandleIdResult").call(this,this,e),r.scalarProperties))for(var t=0;t<r.scalarProperties.length;t++){var n=r.scalarProperties[t].originalName;"Id"!==n&&"_Id"!==n&&"_ReferenceId"!==n||rt.isNullOrUndefined(e[r.scalarProperties[t].originalName])||(this[o.getFieldName(r.scalarProperties[t])]=e[r.scalarProperties[t].originalName])}}},ct.prototype.buildLoad=function(e,t){e.prototype.load=function(e){return rt.load(this,e)}},ct.prototype.buildRetrieve=function(e,t){e.prototype.retrieve=function(e){return rt.retrieve(this,e)}},ct.prototype.buildNewObject=function(t,n){rt.isNullOrEmptyString(n.newObjectServerTypeFullName)||(t.newObject=function(e){return it.createTopLevelServiceObject(t,e,n.newObjectServerTypeFullName,0!=(1&n.behaviorFlags),n.newObjectApiFlags)})},ct.prototype.buildSetMockData=function(e,r){var o=this;if(1&r.behaviorFlags){var i=o.hasIndexMethod(r);e.prototype.setMockData=function(e){var n=this;rt.setMockData(n,e,function(e,t){return it.createChildItemObject(o.getFunction(r.childItemTypeFullName),i,n,e,t)},function(e){n.m__items=e})}}else e.prototype.setMockData=function(e){rt.setMockData(this,e)}},ct.prototype.buildEnsureUnchanged=function(e,t){e.prototype.ensureUnchanged=function(e){it.invokeEnsureUnchanged(this,e)}},ct.prototype.buildUpdate=function(e,t){e.prototype.update=function(e){this._recursivelyUpdate(e)}},ct.prototype.buildSet=function(e,t){if(0==(1&t.behaviorFlags)){var n=[],r=[];if(t.scalarProperties)for(var o=0;o<t.scalarProperties.length;o++)0==(2&t.scalarProperties[o].behaviorFlags)&&0!=(1&t.scalarProperties[o].behaviorFlags)?r.push(t.scalarProperties[o].name):n.push(t.scalarProperties[o].name);var i=[];if(t.navigationProperties)for(o=0;o<t.navigationProperties.length;o++)0!=(16&t.navigationProperties[o].behaviorFlags)||0==(1&t.navigationProperties[o].behaviorFlags)||0==(32&t.navigationProperties[o].behaviorFlags)?n.push(t.navigationProperties[o].name):i.push(t.navigationProperties[o].name);0===i.length&&0===r.length||(e.prototype.set=function(e,t){this._recursivelySet(e,t,r,i,n)})}},ct.prototype.buildItems=function(e,t){0!=(1&t.behaviorFlags)&&Object.defineProperty(e.prototype,"items",{get:function(){return rt.throwIfNotLoaded("items",this.m__items,t.name,this._isNull),this.m__items},enumerable:!0,configurable:!0})},ct.prototype.buildToJSON=function(e,r){var o=this;0==(1&r.behaviorFlags)?e.prototype.toJSON=function(){var e={};if(r.scalarProperties)for(var t=0;t<r.scalarProperties.length;t++)0!=(1&r.scalarProperties[t].behaviorFlags)&&(e[r.scalarProperties[t].name]=this[o.getFieldName(r.scalarProperties[t])]);var n={};if(r.navigationProperties)for(t=0;t<r.navigationProperties.length;t++)0!=(1&r.navigationProperties[t].behaviorFlags)&&(n[r.navigationProperties[t].name]=this[o.getFieldName(r.navigationProperties[t])]);return rt.toJson(this,e,n)}:e.prototype.toJSON=function(){return rt.toJson(this,{},{},this.m__items)}},ct.prototype.buildTypeMetadataInfo=function(e,t){Object.defineProperty(e.prototype,"_className",{get:function(){return t.name},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_isCollection",{get:function(){return 0!=(1&t.behaviorFlags)},enumerable:!0,configurable:!0}),rt.isNullOrEmptyString(t.collectionPropertyPath)||Object.defineProperty(e.prototype,"_collectionPropertyPath",{get:function(){return t.collectionPropertyPath},enumerable:!0,configurable:!0}),t.scalarProperties&&0<t.scalarProperties.length&&(Object.defineProperty(e.prototype,"_scalarPropertyNames",{get:function(){return this.m__scalarPropertyNames||(this.m__scalarPropertyNames=t.scalarProperties.map(function(e){return e.name})),this.m__scalarPropertyNames},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_scalarPropertyOriginalNames",{get:function(){return this.m__scalarPropertyOriginalNames||(this.m__scalarPropertyOriginalNames=t.scalarProperties.map(function(e){return e.originalName})),this.m__scalarPropertyOriginalNames},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_scalarPropertyUpdateable",{get:function(){return this.m__scalarPropertyUpdateable||(this.m__scalarPropertyUpdateable=t.scalarProperties.map(function(e){return 0==(2&e.behaviorFlags)})),this.m__scalarPropertyUpdateable},enumerable:!0,configurable:!0})),t.navigationProperties&&0<t.navigationProperties.length&&Object.defineProperty(e.prototype,"_navigationPropertyNames",{get:function(){return this.m__navigationPropertyNames||(this.m__navigationPropertyNames=t.navigationProperties.map(function(e){return e.name})),this.m__navigationPropertyNames},enumerable:!0,configurable:!0})},ct.prototype.buildTrackUntrack=function(e,t){2&t.behaviorFlags&&(e.prototype.track=function(){return this.context.trackedObjects.add(this),this},e.prototype.untrack=function(){return this.context.trackedObjects.remove(this),this})},ct.prototype.buildMixin=function(e,t){if(4&t.behaviorFlags){var n=this.getFunction(t.name+"Custom");rt.applyMixin(e,n)}},ct.prototype.getOnEventName=function(e){return"_"===e[0]?"_on"+e.substr(1):"on"+e},ct.prototype.buildEvents=function(e,t){if(t.events)for(var n=0;n<t.events.length;n++){var r=t.events[n];Array.isArray(r)&&(this.ensureArraySize(r,7),t.events[n]={name:this.getString(r[0]),behaviorFlags:r[1],apiSetInfoOrdinal:r[2],typeExpression:this.getString(r[3]),targetIdExpression:this.getString(r[4]),register:this.getString(r[5]),unregister:this.getString(r[6])}),this.buildEvent(e,t,t.events[n])}},ct.prototype.buildEvent=function(e,t,n){1&n.behaviorFlags?this.buildV0Event(e,t,n):this.buildV2Event(e,t,n)},ct.prototype.buildV2Event=function(e,i,a){var s=this,t=this.getOnEventName(a.name),c=this.getFieldName(a);Object.defineProperty(e.prototype,t,{get:function(){if(!this[c]){s.throwIfApiNotSupported(i,a);var t=this,e=null;"null"!==a.register&&(e=this[a.register].bind(this));var n=null;"null"!==a.unregister&&(n=this[a.unregister].bind(this));var r=null;2&a.behaviorFlags&&(r=s.getFunction(ct.CustomizationCodeNamespace+"."+i.name+"_"+a.name+"_EventArgsTransform"));var o=s.evaluateEventType(a.typeExpression);this[c]=new Be(this.context,this,a.name,{eventType:o,getTargetIdFunc:function(){return s.evaluateEventTargetId(a.targetIdExpression,t)},registerFunc:e,unregisterFunc:n,eventArgsTransformFunc:function(e){return r&&(e=r.call(t,t,e)),rt._createPromiseFromResult(e)}})}return this[c]},enumerable:!0,configurable:!0})},ct.prototype.buildV0Event=function(e,c,l){var u=this,t=this.getOnEventName(l.name),p=this.getFieldName(l);Object.defineProperty(e.prototype,t,{get:function(){if(!this[p]){u.throwIfApiNotSupported(c,l);var n=this,e=null;if(rt.isNullOrEmptyString(l.register)){var r=u.evaluateEventType(l.typeExpression);e=function(e){var t=u.evaluateEventTargetId(l.targetIdExpression,n);return n.context.eventRegistration.register(r,t,e)}}else if("null"!==l.register){var t=u.getFunction(l.register);e=function(e){return t.call(n,n,e)}}var o=null;if(rt.isNullOrEmptyString(l.unregister)){var i=u.evaluateEventType(l.typeExpression);o=function(e){var t=u.evaluateEventTargetId(l.targetIdExpression,n);return n.context.eventRegistration.unregister(i,t,e)}}else if("null"!==l.unregister){var a=u.getFunction(l.unregister);o=function(e){return a.call(n,n,e)}}var s=null;2&l.behaviorFlags&&(s=u.getFunction(ct.CustomizationCodeNamespace+"."+c.name+"_"+l.name+"_EventArgsTransform")),this[p]=new Ie(this.context,this,l.name,{registerFunc:e,unregisterFunc:o,eventArgsTransformFunc:function(e){return s&&(e=s.call(n,n,e)),rt._createPromiseFromResult(e)}})}return this[p]},enumerable:!0,configurable:!0})},ct.prototype.hasIndexMethod=function(e){var t=!1;if(e.navigationMethods)for(var n=0;n<e.navigationMethods.length;n++)if(0!=(16&e.navigationMethods[n].behaviorFlags)){t=!0;break}return t},ct.CustomizationCodeNamespace="_CC",ct);function ct(e){if(this.m_namespaceMap={},this.m_namespace=e.metadata.name,this.m_targetNamespaceObject=e.targetNamespaceObject,this.m_namespaceMap[this.m_namespace]=e.targetNamespaceObject,e.namespaceMap)for(var t in e.namespaceMap)this.m_namespaceMap[t]=e.namespaceMap[t];this.m_defaultApiSetName=e.metadata.defaultApiSetName,this.m_hostName=e.metadata.hostName;var n=e.metadata;if(n.enumTypes)for(var r=0;r<n.enumTypes.length;r++)this.buildEnumType(n.enumTypes[r]);if(n.apiSets){for(r=0;r<n.apiSets.length;r++){var o=n.apiSets[r];Array.isArray(o)&&(n.apiSets[r]={version:o[0],name:o[1]||this.m_defaultApiSetName})}this.m_apiSets=n.apiSets}if(this.m_strings=n.strings,n.clientObjectTypes)for(r=0;r<n.clientObjectTypes.length;r++){o=n.clientObjectTypes[r];Array.isArray(o)&&(this.ensureArraySize(o,11),n.clientObjectTypes[r]={name:this.getString(o[0]),behaviorFlags:o[1],collectionPropertyPath:this.getString(o[6]),newObjectServerTypeFullName:this.getString(o[9]),newObjectApiFlags:o[10],childItemTypeFullName:this.getString(o[7]),scalarProperties:o[2],navigationProperties:o[3],scalarMethods:o[4],navigationMethods:o[5],events:o[8]}),this.buildClientObjectType(n.clientObjectTypes[r],e.fullyInitialize)}}m.LibraryBuilder=st}(OfficeExtension=OfficeExtension||{}),function(e){var t;(t||(t={})).getPromiseType=function(){if("undefined"!=typeof Promise)return Promise;if(void 0!==Office&&Office.Promise)return Office.Promise;throw new e.Error("No Promise implementation found")},Object.defineProperty(e,"Promise",{get:function(){return t.getPromiseType()},enumerable:!0,configurable:!0})}(OfficeExtension=OfficeExtension||{});try{if("undefined"!=typeof OfficePlatformGlobal&&void 0!==OfficePlatformGlobal.ReactNativeReka){var RichApiBridgeImpl=function(){function e(){}return e.prototype.sendMessageToHost=function(e){OfficePlatformGlobal.ReactNativeReka.RekaInstance.InvokeNative("RichApiDataService","ProcessMessageToHost",e)},e}(),RichApiBridge_1=new RichApiBridgeImpl,RichApiDataService_1=function(){function e(){}return e.prototype.Invoke=function(e,t){"ProcessMessageFromHost"===e&&RichApiBridge_1.onMessageFromHost&&RichApiBridge_1.onMessageFromHost(t)},e}();OfficePlatformGlobal.ReactNativeReka.initReka(),OfficePlatformGlobal.ReactNativeReka.RekaInstance.RegisterService("RichApiDataService",function(){return new RichApiDataService_1}),OfficeExtension.HostBridge.init(RichApiBridge_1),OfficeExtension.HostBridgeSession.getInstanceIfHostBridgeInited()}}catch(e){}var oteljs;__assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var o in t=arguments[n])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)};!function(e){function r(e,t,n,r){return{name:e,dataType:t,value:n,classification:r||4}}e.makeBooleanDataField=function(e,t,n){return r(e,1,t,n)},e.makeInt64DataField=function(e,t,n){return r(e,2,t,n)},e.makeDoubleDataField=function(e,t,n){return r(e,3,t,n)},e.makeStringDataField=function(e,t,n){return r(e,0,t,n)},e.makeGuidDataField=function(e,t,n){return r(e,4,t,n)}}(oteljs=oteljs||{}),function(e){var t,n,r,o,i,a,s,c,l,u,p,f,d;(t=e.DataClassification||(e.DataClassification={}))[t.EssentialServiceMetadata=1]="EssentialServiceMetadata",t[t.AccountData=2]="AccountData",t[t.SystemMetadata=4]="SystemMetadata",t[t.OrganizationIdentifiableInformation=8]="OrganizationIdentifiableInformation",t[t.EndUserIdentifiableInformation=16]="EndUserIdentifiableInformation",t[t.CustomerContent=32]="CustomerContent",t[t.AccessControl=64]="AccessControl",t[t.PublicNonPersonalData=128]="PublicNonPersonalData",t[t.EndUserPseudonymousInformation=256]="EndUserPseudonymousInformation",t[t.PublicPersonalData=512]="PublicPersonalData",t[t.SupportData=1024]="SupportData",t[t.DirectMeasurementData=2048]="DirectMeasurementData",t[t.Everything=65535]="Everything",(n=e.DataFieldType||(e.DataFieldType={}))[n.String=0]="String",n[n.Boolean=1]="Boolean",n[n.Int64=2]="Int64",n[n.Double=3]="Double",n[n.Guid=4]="Guid",(r=e.SamplingPolicy||(e.SamplingPolicy={}))[r.NotSet=0]="NotSet",r[r.Measure=1]="Measure",r[r.Diagnostics=2]="Diagnostics",r[r.CriticalBusinessImpact=191]="CriticalBusinessImpact",r[r.CriticalCensus=192]="CriticalCensus",r[r.CriticalExperimentation=193]="CriticalExperimentation",r[r.CriticalUsage=194]="CriticalUsage",(o=e.PersistencePriority||(e.PersistencePriority={}))[o.NotSet=0]="NotSet",o[o.Normal=1]="Normal",o[o.High=2]="High",(i=e.CostPriority||(e.CostPriority={}))[i.NotSet=0]="NotSet",i[i.Normal=1]="Normal",i[i.High=2]="High",(a=e.DataCategories||(e.DataCategories={}))[a.NotSet=0]="NotSet",a[a.SoftwareSetup=1]="SoftwareSetup",a[a.ProductServiceUsage=2]="ProductServiceUsage",a[a.ProductServicePerformance=4]="ProductServicePerformance",a[a.DeviceConfiguration=8]="DeviceConfiguration",a[a.InkingTypingSpeech=16]="InkingTypingSpeech",(s=e.DiagnosticLevel||(e.DiagnosticLevel={}))[s.ReservedDoNotUse=0]="ReservedDoNotUse",s[s.Required=10]="Required",s[s.BasicEvent=10]="BasicEvent",s[s.Optional=100]="Optional",s[s.FullEvent=100]="FullEvent",s[s.RequiredServiceData=110]="RequiredServiceData",s[s.NecessaryServiceDataEvent=110]="NecessaryServiceDataEvent",s[s.RequiredServiceDataForEssentialServices=120]="RequiredServiceDataForEssentialServices",s[s.AlwaysOnNecessaryServiceDataEvent=120]="AlwaysOnNecessaryServiceDataEvent",(c=e.CustomerContentType||(e.CustomerContentType={}))[c.None=0]="None",c[c.MocaAddIn=1]="MocaAddIn",(l=e.LogLevel||(e.LogLevel={}))[l.Error=0]="Error",l[l.Warning=1]="Warning",l[l.Info=2]="Info",l[l.Verbose=3]="Verbose",(u=e.Category||(e.Category={}))[u.Core=0]="Core",u[u.Sink=1]="Sink",u[u.Transport=2]="Transport",(p=e.DnmInterval||(e.DnmInterval={}))[p.Hourly=1]="Hourly",p[p.Daily=2]="Daily",(f=e.AllowedPartA||(e.AllowedPartA={}))[f.ReleaseAudienceGroup=1]="ReleaseAudienceGroup",f[f.WacRing=2]="WacRing",f[f.AppName=3]="AppName",f[f.AppPlatform=4]="AppPlatform",f[f.AppVersion=5]="AppVersion",(d=e.EventType||(e.EventType={}))[d.SendTelemetryEvent=1]="SendTelemetryEvent",d[d.CustomerContent=2]="CustomerContent",d[d.DirectNumericEvent=3]="DirectNumericEvent"}(oteljs=oteljs||{}),function(n){n.getEffectiveEventFlags=function(e){var t={costPriority:1,samplingPolicy:1,persistencePriority:1,dataCategories:0,diagnosticLevel:100};return e.eventFlags&&e.eventFlags.dataCategories||n.logNotification(0,0,function(){return"DataCategories"}),e.eventFlags&&(e.eventFlags.costPriority&&(t.costPriority=e.eventFlags.costPriority),e.eventFlags.samplingPolicy&&(t.samplingPolicy=e.eventFlags.samplingPolicy),e.eventFlags.persistencePriority&&(t.persistencePriority=e.eventFlags.persistencePriority),e.eventFlags.dataCategories&&(t.dataCategories=e.eventFlags.dataCategories),e.eventFlags.diagnosticLevel&&(t.diagnosticLevel=e.eventFlags.diagnosticLevel)),t}}(oteljs=oteljs||{}),function(e){var n,r=(n=[],{fireEvent:function(t){n.forEach(function(e){return e(t)})},addListener:function(e){e&&n.push(e)}});function o(e,t,n){r.fireEvent({level:e,category:t,message:n})}e.onNotification=function(){return r},e.logNotification=o,e.logError=function(e,t,n){o(0,e,function(){var e=n instanceof Error?n.message:"";return"".concat(t,": ").concat(e)})}}(oteljs=oteljs||{}),function(a){var e,t;function o(e){var t={eventName:e.eventName,eventFlags:e.eventFlags||{},telemetryProperties:e.telemetryProperties?__assign({},e.telemetryProperties):{},dataFields:e.dataFields?e.dataFields.slice():[],timestamp:e.timestamp||(new Date).getTime()};return e.eventContract&&(t.eventContract={name:e.eventContract.name,dataFields:e.eventContract.dataFields.slice()}),t}(t=e=e||{})[t.TelemetryData=0]="TelemetryData",t[t.AnonymousData=1]="AnonymousData",t[t.CustomerContent=2]="CustomerContent",a.SuppressNexus=-1,a.cloneEvent=o;var n=(r.prototype.addEventContentType=function(e,t){e.push(a.makeInt64DataField("EventContent.Type",t))},r.prototype.sendTelemetryEvent=function(e){var t=o(e),n=t.telemetryProperties;n.nexusTenantToken=a.SuppressNexus;var r=n.ariaTenantToken;r||a.fillTenantTokens(t.eventName,n)||r?this.sendTelemetryEventInternal(t,1):a.logNotification(0,0,function(){return"No tenant token: "+e.eventName})},r.prototype.sendNonStandardEvent=function(e,t){var n=o(e);this.sendTelemetryEventInternal(n,t)},r.prototype.sendCustomerContent=function(e){var t=o(e),n=t.telemetryProperties,r=n.customerContentVersion;return(!r||2<r)&&(n.customerContentVersion=2),n.ariaTenantToken=void 0,n.nexusTenantToken=void 0,n.dnmToken=void 0,this.addEventContentType(t.dataFields,2),this.sendTelemetryEventInternal(t,2)},r.prototype.sendDirectNumericEvent=function(e){var t=o(e),n=t.telemetryProperties;n.dnmToken||a.fillTenantTokens(t.eventName,n)||n.dnmToken?(this.addEventContentType(t.dataFields,1),this.sendTelemetryEventInternal(t,3)):a.logNotification(0,0,function(){return"No dnm token: "+t.eventName})},r.prototype.sendTelemetryEventInternal=function(t,n){if(2===n||!t.telemetryProperties.customerContentVersion&&!t.telemetryProperties.customerContentType){try{if(0===this.telemetrySinks.length)return void(this.config.enableQueue&&this.eventQueue.length<1e3?this.eventQueue.push([t,n]):a.logNotification(1,0,function(){return"No telemetry sinks are attached."}));this.processTelemetryEvent(t,n)}catch(e){return void a.logError(0,"SendTelemetryEvent",e)}this.telemetrySinks.forEach(function(e){try{3===n||2===n?e.sendNonStandardEvent&&e.sendNonStandardEvent(t,n):e.sendTelemetryEvent(t)}catch(e){}})}else a.logNotification(0,0,function(){return"Customer content"})},r.prototype.processTelemetryEvent=function(e,t){var n,r,o;if(e.dataFields&&(null!==(o=e.dataFields)&&void 0!==o&&o.unshift(a.makeStringDataField("OTelJS.Version",a.oteljsVersion)),3!==t&&this.persistentDataFields&&(n=e.dataFields).unshift.apply(n,this.persistentDataFields)),0<this.partAFields.length){var i=e.eventContract||{name:"",dataFields:[]};(r=i.dataFields).push.apply(r,this.partAFields),e.eventContract=i}this.config.disableValidation||a.validateTelemetryEvent(e)},r.prototype.addSink=function(e){this.telemetrySinks.push(e),this.flushQueue()},r.prototype.flushQueue=function(){var e=this.eventQueue;if(this.eventQueue=[],0<this.telemetrySinks.length)for(var t=0,n=e;t<n.length;t++){var r=n[t],o=r[0],i=r[1];this.sendTelemetryEventInternal(o,i)}},r.prototype.setTenantToken=function(e,t,n){a.setTenantTokens(e,{ariaTenantToken:t,nexusTenantToken:n})},r.prototype.setDNMToken=function(e,t){a.setTenantTokens(e,{dnmToken:t})},r.prototype.cloneEvent=function(e){return o(e)},r.prototype.getConfig=function(){return this.config},r);function r(e,t,n){var r,o,i;this.telemetrySinks=[],this.persistentDataFields=[],this.partAFields=[],this.eventQueue=[],this.config=n||{},e&&(this.telemetrySinks=e.telemetrySinks,(r=this.persistentDataFields).push.apply(r,e.persistentDataFields),this.config=__assign(__assign({},e.getConfig()),this.config),(o=this.partAFields).push.apply(o,e.partAFields)),t&&(i=this.persistentDataFields).push.apply(i,t)}a.SimpleTelemetryLogger=n}(oteljs=oteljs||{}),function(e){var t=9007199254740991,n=-t,r=98,o=/^Office(\.[A-Z][a-zA-Z0-9]*){2,}$/,i=/^[a-zA-Z0-9_\.]{1,95}$/;function a(e){return i.test(e)}function s(e){e&&e.forEach(function(e){if("string"!=typeof e.name||!a(e.name))throw new Error("Invalid dataField name");2===e.dataType&&c(e.value)})}function c(e){if("number"!=typeof e||!isFinite(e)||Math.floor(e)!==e||e<n||t<e)throw new Error("Invalid integer ".concat(JSON.stringify(e)))}e.validateTelemetryEvent=function(e){if(!function(e){if(!e||e.length>r)return;return o.test(e)}(e.eventName))throw new Error("Invalid eventName");var t=e.eventContract;if(t){if(t.name&&!a(t.name))throw new Error("Invalid eventContract");s(t.dataFields)}s(e.dataFields)},e.validateInt=c}(oteljs=oteljs||{}),function(n){var i={};n.setTenantTokens=function(e,t){"Office."===e.substring(0,7)&&"."!==e[e.length-1]?i[e]?(t.ariaTenantToken&&(i[e].ariaTenantToken=t.ariaTenantToken),t.dnmToken&&(i[e].dnmToken=t.dnmToken)):i[e]=t:n.logNotification(0,0,function(){return"Namespace: ".concat(e)})},n.fillTenantTokens=function(e,t){for(var n=e.length;0<n;){var r=e.substr(0,n);if(i[r]){var o=i[r];return t.ariaTenantToken=o.ariaTenantToken,t.dnmToken=o.dnmToken,!0}n=e.lastIndexOf(".",n-1)}return!1},n.clear=function(){i={}}}(oteljs=oteljs||{}),(oteljs||(oteljs={})).oteljsVersion="4.18.0",function(a){var e=(t.isSupportedByDeclaration=function(){return t.isSupportedVersion("1.2")},t.isSupportedVersion=function(e){return Office.context.requirements.isSetSupported("Telemetry",e)},t.prototype.sendCustomerContent=function(e){t.isSupportedVersion("1.3")&&(this._customerContentQueue.push(e),this.processWorkBacklog())},t.prototype.sendTelemetryEvent=function(e){this._telemetryQueue.push(e),this.processWorkBacklog()},t.prototype.processWorkBacklog=function(){var t=this;this._requestIsPending||(this._requestIsPending=!0,this.processTelemetryEvents().then(function(){t.waitAndProcessMore()}).catch(function(e){a.logError(1,"RichApiSink Error",e),t.waitAndProcessMore()}))},t.prototype.waitAndProcessMore=function(){var e=this;this.pause(1e3).then(function(){e._requestIsPending=!1,0<e._telemetryQueue.length&&setTimeout(function(){return e.processWorkBacklog()},0)}).catch(function(){e._requestIsPending=!1})},t.prototype.processTelemetryEvents=function(){var o=this,e=this._telemetryQueue;this._telemetryQueue=[];var t=this._customerContentQueue;function n(e,t){if(e.telemetryProperties){var n=[];o.addDataFields(n,e.dataFields);var r=e.eventContract?e.eventContract.name:"";e.eventContract&&o.addDataFields(n,e.eventContract.dataFields),t(e.telemetryProperties,e.eventName,r,a.getEffectiveEventFlags(e),n)}}this._customerContentQueue=[];var i=new OfficeCore.RequestContext;return e.forEach(function(e){n(e,function(e,t,n,r,o){i.telemetry.sendTelemetryEvent(e,t,n,r,o)})}),t.forEach(function(e){n(e,function(e,t,n,r,o){i.telemetry.sendCustomerContent(e,t,n,r,o)})}),i.sync().catch(function(e){a.logError(1,"RichApi telemetry failed.",e)})},t.prototype.addDataFields=function(t,e){e&&e.forEach(function(e){t.push({name:e.name,value:e.value,classification:e.classification?e.classification:4,type:4===e.dataType?0:e.dataType})})},t.prototype.pause=function(t){return new Office.Promise(function(e){return setTimeout(e,t)})},t);function t(){var e=this;this._requestIsPending=!0,this._telemetryQueue=[],this._customerContentQueue=[],this.pause(1e3).then(function(){return e._requestIsPending=!1,e.processTelemetryEvents()}).catch()}a.RichApiSink=e}(oteljs=oteljs||{}),function(r){var e,t,n;e=r.Contracts||(r.Contracts={}),t=e.Office||(e.Office={}),((n=t.System||(t.System={})).SDX||(n.SDX={})).getFields=function(e,t){var n=[];return void 0!==t.id&&n.push(r.makeStringDataField("".concat(e,".Id"),t.id)),void 0!==t.version&&n.push(r.makeStringDataField("".concat(e,".Version"),t.version)),void 0!==t.instanceId&&n.push(r.makeStringDataField("".concat(e,".InstanceId"),t.instanceId)),void 0!==t.name&&n.push(r.makeStringDataField("".concat(e,".Name"),t.name)),void 0!==t.marketplaceType&&n.push(r.makeStringDataField("".concat(e,".MarketplaceType"),t.marketplaceType)),void 0!==t.sessionId&&n.push(r.makeStringDataField("".concat(e,".SessionId"),t.sessionId)),void 0!==t.browserToken&&n.push(r.makeStringDataField("".concat(e,".BrowserToken"),t.browserToken)),void 0!==t.osfRuntimeVersion&&n.push(r.makeStringDataField("".concat(e,".OsfRuntimeVersion"),t.osfRuntimeVersion)),void 0!==t.officeJsVersion&&n.push(r.makeStringDataField("".concat(e,".OfficeJsVersion"),t.officeJsVersion)),void 0!==t.hostJsVersion&&n.push(r.makeStringDataField("".concat(e,".HostJsVersion"),t.hostJsVersion)),void 0!==t.assetId&&n.push(r.makeStringDataField("".concat(e,".AssetId"),t.assetId)),void 0!==t.providerName&&n.push(r.makeStringDataField("".concat(e,".ProviderName"),t.providerName)),void 0!==t.type&&n.push(r.makeStringDataField("".concat(e,".Type"),t.type)),n}}(oteljs=oteljs||{}),function(o){var e=(t.isSupported=function(){return Office.context&&Office.context.platform?Office.context.platform===Office.PlatformType.OfficeOnline:OfficeExt&&OfficeExt.HostName&&OfficeExt.HostName.Host&&OfficeExt.HostName.Host.getInstance().getPlatform()===Office.PlatformType.OfficeOnline},t.prototype.sendTelemetryEvent=function(e,t){try{if(e.dataFields&&0<e.dataFields.filter(function(e){var t=e.classification;return t&&4!==t&&1!==t}).length)return;var n=OSF._OfficeAppFactory.getId(),r=OSF.AgaveHostAction.SendTelemetryEvent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n,r,e])}catch(e){o.logError(1,"AgaveWacSink",e)}},t.prototype.sendCustomerContent=function(e,t){try{if(e.dataFields&&0<e.dataFields.filter(function(e){var t=e.classification;return t&&4!==t&&1!==t&&32!==t}).length)return;var n=OSF._OfficeAppFactory.getId(),r=OSF.AgaveHostAction.SendCustomerContent;OSF.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[n,r,e])}catch(e){o.logError(1,"AgaveWacSink",e)}},t);function t(){}o.SdxWacSink=e}(oteljs=oteljs||{});var OfficeFirstPartyDialog,OfficeFirstPartyAuth,OfficeCore,OfficeFirstParty;__extends=this&&this.__extends||function(){var r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)};return function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}}(),__awaiter=this&&this.__awaiter||function(i,a,s,c){return new(s=s||Promise)(function(e,t){function n(e){try{o(c.next(e))}catch(e){t(e)}}function r(e){try{o(c.throw(e))}catch(e){t(e)}}function o(t){t.done?e(t.value):new s(function(e){e(t.value)}).then(n,r)}o((c=c.apply(i,a||[])).next())})},__generator=this&&this.__generator||function(n,r){var o,i,a,e,s={label:0,sent:function(){if(1&a[0])throw a[1];return a[1]},trys:[],ops:[]};return e={next:t(0),throw:t(1),return:t(2)},"function"==typeof Symbol&&(e[Symbol.iterator]=function(){return this}),e;function t(t){return function(e){return function(t){if(o)throw new TypeError("Generator is already executing.");for(;s;)try{if(o=1,i&&(a=2&t[0]?i.return:t[0]?i.throw||((a=i.return)&&a.call(i),0):i.next)&&!(a=a.call(i,t[1])).done)return a;switch(i=0,a&&(t=[2&t[0],a.value]),t[0]){case 0:case 1:a=t;break;case 4:return s.label++,{value:t[1],done:!1};case 5:s.label++,i=t[1],t=[0];continue;case 7:t=s.ops.pop(),s.trys.pop();continue;default:if(!(a=0<(a=s.trys).length&&a[a.length-1])&&(6===t[0]||2===t[0])){s=0;continue}if(3===t[0]&&(!a||t[1]>a[0]&&t[1]<a[3])){s.label=t[1];break}if(6===t[0]&&s.label<a[1]){s.label=a[1],a=t;break}if(a&&s.label<a[2]){s.label=a[2],s.ops.push(t);break}a[2]&&s.ops.pop(),s.trys.pop();continue}t=r.call(n,s)}catch(e){t=[6,e],i=0}finally{o=a=0}if(5&t[0])throw t[1];return{value:t[0]?t[1]:void 0,done:!0}}([t,e])}}},__assign=this&&this.__assign||function(){return(__assign=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var o in t=arguments[n])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e}).apply(this,arguments)};!function(t){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var n,r=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,o=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),i=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),e=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),a=OfficeExtension.Utility.fixObjectPathIfNecessary,s=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),c=(n=OfficeExtension.ClientObject,__extends(l,n),Object.defineProperty(l.prototype,"_className",{get:function(){return"BiShim"},enumerable:!0,configurable:!0}),l.prototype.initialize=function(e){o(this,"Initialize",0,[e],0,0)},l.prototype.getData=function(){return o(this,"getData",1,[],4,0)},l.prototype.setVisualObjects=function(e){o(this,"setVisualObjects",0,[e],2,0)},l.prototype.setVisualObjectsToPersist=function(e){o(this,"setVisualObjectsToPersist",0,[e],2,0)},l.prototype._handleResult=function(e){n.prototype._handleResult.call(this,e),i(e)||a(this,e)},l.prototype._handleRetrieveResult=function(e,t){n.prototype._handleRetrieveResult.call(this,e,t),s(this,e,t)},l.newObject=function(e){return r(t.BiShim,e,"Microsoft.AgaveVisual.BiShim",!1,4)},l.prototype.toJSON=function(){return e(this,{},{})},l);function l(){return null!==n&&n.apply(this,arguments)||this}t.BiShim=c,(t.AgaveVisualErrorCodes||(t.AgaveVisualErrorCodes={})).generalException1="GeneralException"}(OfficeCore=OfficeCore||{}),function(o){OfficeExtension.BatchApiHelper.createPropertyObject;var n,i=OfficeExtension.BatchApiHelper.createMethodObject,t=(OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject),r=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),a=OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,s=(OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),c=OfficeExtension.Utility.isUndefined,e=OfficeExtension.Utility.throwIfNotLoaded,l=(OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load),u=OfficeExtension.Utility.retrieve,p=OfficeExtension.Utility.toJson,f=OfficeExtension.Utility.fixObjectPathIfNecessary,d=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),h=(n=OfficeExtension.ClientObject,__extends(g,n),Object.defineProperty(g.prototype,"_className",{get:function(){return"FlightingService"},enumerable:!0,configurable:!0}),g.prototype.getClientSessionId=function(){return r(this,"GetClientSessionId",1,[],4,0)},g.prototype.getDeferredFlights=function(){return r(this,"GetDeferredFlights",1,[],4,0)},g.prototype.getFeature=function(e,t,n,r){return i(o.ABType,this,"GetFeature",1,[e,t,n,r],!1,!1,null,4)},g.prototype.getFeatureGate=function(e,t){return i(o.ABType,this,"GetFeatureGate",1,[e,t],!1,!1,null,4)},g.prototype.resetOverride=function(e){r(this,"ResetOverride",0,[e],0,0)},g.prototype.setOverride=function(e,t,n){r(this,"SetOverride",0,[e,t,n],0,0)},g.prototype._handleResult=function(e){n.prototype._handleResult.call(this,e),s(e)||f(this,e)},g.prototype._handleRetrieveResult=function(e,t){n.prototype._handleRetrieveResult.call(this,e,t),d(this,e,t)},g.newObject=function(e){return t(o.FlightingService,e,"Microsoft.Experiment.FlightingService",!1,4)},g.prototype.toJSON=function(){return p(this,{},{})},g);function g(){return null!==n&&n.apply(this,arguments)||this}o.FlightingService=h;var m,y,v=(m=OfficeExtension.ClientObject,__extends(b,m),Object.defineProperty(b.prototype,"_className",{get:function(){return"ABType"},enumerable:!0,configurable:!0}),Object.defineProperty(b.prototype,"_scalarPropertyNames",{get:function(){return["value"]},enumerable:!0,configurable:!0}),Object.defineProperty(b.prototype,"value",{get:function(){return e("value",this._V,"ABType",this._isNull),this._V},enumerable:!0,configurable:!0}),b.prototype._handleResult=function(e){if(m.prototype._handleResult.call(this,e),!s(e)){var t=e;f(this,t),c(t.Value)||(this._V=t.Value)}},b.prototype.load=function(e){return l(this,e)},b.prototype.retrieve=function(e){return u(this,e)},b.prototype._handleRetrieveResult=function(e,t){m.prototype._handleRetrieveResult.call(this,e,t),d(this,e,t)},b.prototype.toJSON=function(){return p(this,{value:this._V},{})},b.prototype.ensureUnchanged=function(e){a(this,e)},b);function b(){return null!==m&&m.apply(this,arguments)||this}o.ABType=v,(y=o.FeatureType||(o.FeatureType={})).boolean="Boolean",y.integer="Integer",y.string="String",(o.ExperimentErrorCodes||(o.ExperimentErrorCodes={})).generalException="GeneralException"}(OfficeCore=OfficeCore||{}),function(r){var e,t,n=(o.prototype.close=function(){return this._dialogService.close(),this._dialogService.context.sync()},o.prototype.messageChild=function(e,t){DialogApiManager&&DialogApiManager.messageChildRichApiBridge&&DialogApiManager.messageChildRichApiBridge(e,t)},o);function o(e){this._dialogService=e}r.Dialog=n,r.displayWebDialog=function(n,h){return void 0===h&&(h={}),new OfficeExtension.CoreUtility.Promise(function(l,u){if(h.width&&h.height&&(!e(h.width)||!e(h.height)))throw new OfficeExtension.Error({code:"InvalidArgument",message:'Dimensions must be "number%" or number.'});var p=new OfficeExtension.ClientRequestContext,t=OfficeCore.FirstPartyDialogService.newObject(p),f=new r.Dialog(t),d=t.onDialogMessage.add(function(e){OfficeExtension.Utility.log("dialogMessageHandler:"+JSON.stringify(e));var t,n,r,o=JSON.parse(e.message),i=o.errorCode?new OfficeExtension.Error((t=o.errorCode,(n={})[12002]={code:"InvalidUrl",message:"Cannot load URL, no such page or bad URL syntax."},n[12003]={code:"InvalidUrl",message:"HTTPS is required."},n[12004]={code:"Untrusted",message:"Domain is not trusted."},n[12005]={code:"InvalidUrl",message:"HTTPS is required."},n[12007]={code:"FailedToOpen",message:"Another dialog is already opened."},(r=n)[t]?r[t]:{code:"Unknown",message:"An unknown error has occured with code: "+t})):null,a=o.type,s=o.origin,c=o.message;switch(a){case 17:i?u(i):l(f);break;case 12:h.onMessage&&h.onMessage(c,f,s);break;case 10:default:12006===o.errorCode?(d&&(d.remove(),p.sync()),h.onClose&&h.onClose()):h.onRuntimeError&&(h.onRuntimeError(i,f),u(i))}return OfficeExtension.CoreUtility.Promise.resolve()});return p.sync().then(function(){var e={width:h.width?parseInt(h.width):50,height:h.height?parseInt(h.height):50,displayInIFrame:h.displayInIFrame,dialogTitle:h.dialogTitle,disableESCKeyCloseDialog:void 0!==h.disableESCKeyCloseDialog&&h.disableESCKeyCloseDialog};return t.displayDialog(n,e),p.sync()}).catch(function(e){u(e)})});function e(e){return/^(\-|\+)?([0-9]+)%?$/.test(e)}},(t=e=e||{})[t.dialogMessageReceived=0]="dialogMessageReceived",t[t.dialogEventReceived=1]="dialogEventReceived"}(OfficeFirstPartyDialog=OfficeFirstPartyDialog||{}),function(n){n.OfficeOnlineDomainList=["*.dod.online.office365.us","*.gov.online.office365.us","*.officeapps-df.live.com","*.officeapps.live.com","*.online.office.de","*.partner.officewebapps.cn"],n.isHostOriginTrusted=function(){if(void 0!==window.external&&void 0!==window.external.GetContext)return!0;var e=OSF.getClientEndPoint()._targetUrl,t=e.split("/")[2].split(":")[0].split("?")[0];return 0!=e.indexOf("https:")||n.OfficeOnlineDomainList.forEach(function(e){if(0==e.indexOf("*.")&&(e=e.substring(2)),t.indexOf(e)==t.length-e.length)return!0}),!1}}(OfficeCore=OfficeCore||{}),function(n){var e=(Object.defineProperty(t.prototype,"roamingSettings",{get:function(){return this.m_roamingSettings||(this.m_roamingSettings=n.AuthenticationService.newObject(this.context).roamingSettings),this.m_roamingSettings},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tap",{get:function(){return this.m_tap||(this.m_tap=n.Tap.newObject(this.context)),this.m_tap},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"skill",{get:function(){return this.m_skill||(this.m_skill=n.Skill.newObject(this.context)),this.m_skill},enumerable:!0,configurable:!0}),t);function t(e){this.context=e}n.FirstPartyApis=e;var r,o=(r=OfficeExtension.ClientRequestContext,__extends(i,r),Object.defineProperty(i.prototype,"firstParty",{get:function(){return this.m_firstPartyApis||(this.m_firstPartyApis=new e(this)),this.m_firstPartyApis},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"flighting",{get:function(){return this.flightingService},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"telemetry",{get:function(){return this.m_telemetry||(this.m_telemetry=n.TelemetryService.newObject(this)),this.m_telemetry},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"ribbon",{get:function(){return this.m_ribbon||(this.m_ribbon=n.DynamicRibbon.newObject(this)),this.m_ribbon},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"bi",{get:function(){return this.m_biShim||(this.m_biShim=n.BiShim.newObject(this)),this.m_biShim},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"flightingService",{get:function(){return this.m_flightingService||(this.m_flightingService=n.FlightingService.newObject(this)),this.m_flightingService},enumerable:!0,configurable:!0}),i);function i(e){return r.call(this,e)||this}n.RequestContext=o,n.run=function(e,t){return OfficeExtension.ClientRequestContext._runBatch("OfficeCore.run",arguments,function(e){return new n.RequestContext(e)})}}(OfficeCore=OfficeCore||{}),function(e){var t;function s(){var e=new OfficeCore.RequestContext;return"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e._customData="WacPartition"),e}(t=e.license||(e.license={})).isFeatureEnabled=function(o,i){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=s(),n=OfficeCore.License.newObject(t),r=n.isFeatureEnabled(o,i),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.getFeatureTier=function(o,i){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=s(),n=OfficeCore.License.newObject(t),r=n.getFeatureTier(o,i),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.isFreemiumUpsellEnabled=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=s(),n=OfficeCore.License.newObject(t),r=n.isFreemiumUpsellEnabled(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.launchUpsellExperience=function(n){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=s(),OfficeCore.License.newObject(t).launchUpsellExperience(n),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.onFeatureStateChanged=function(i,a){return __awaiter(this,void 0,void 0,function(){var t,n,r,o;return __generator(this,function(e){switch(e.label){case 0:return t=s(),n=OfficeCore.License.newObject(t),(r=n.getLicenseFeature(i)).onStateChanged.add(a),o=function(){return r.onStateChanged.remove(a),null},[4,t.sync()];case 1:return e.sent(),[2,o]}})})},t.getMsaDeviceTicket=function(o,i,a){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=s(),n=OfficeCore.License.newObject(t),r=n.getMsaDeviceTicket(o,i,a),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})}}(Office=Office||{}),function(e){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod,OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined,OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson,OfficeExtension.Utility.fixObjectPathIfNecessary,OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult,OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags;(e._CC||(e._CC={})).Skill_HostSkillEvent_EventArgsTransform=function(e,t){return{type:t.type,data:t.data}},(e.SkillErrorCodes||(e.SkillErrorCodes={})).generalException="GeneralException";new OfficeExtension.LibraryBuilder({metadata:{version:"1.0.0",name:"OfficeCore",defaultApiSetName:"OfficeSharedApi",hostName:"Office",apiSets:[["1.1","SharedApiUndo"]],strings:["Skill","registerHostSkillEvent","unregisterHostSkillEvent"],enumTypes:[],clientObjectTypes:[[1,0,0,0,[["executeAction",3,2,0,5],["notifyPaneEvent",2,2,0,5],[2,0,0,0,3,0,1],[3,0,0,0,3,0,1],["testFireEvent",0,0,0,3,0,1]],0,0,0,[["HostSkillEvent",2,0,"65538","",2,3]],"Microsoft.SkillApi.Skill",4]]},targetNamespaceObject:e})}(OfficeCore=OfficeCore||{}),function(t){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var n,e,r,o=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,a=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),i=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),s=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported),c=(OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),l=OfficeExtension.Utility.fixObjectPathIfNecessary,u=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),p=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,n=OfficeExtension.ClientObject,__extends(f,n),Object.defineProperty(f.prototype,"_className",{get:function(){return"TelemetryService"},enumerable:!0,configurable:!0}),f.prototype.sendNonStandardEvent=function(e,t,n,r,o,i){s("TelemetryService.sendNonStandardEvent","Telemetry","1.4","OfficeCore"),a(this,"SendNonStandardEvent",1,[e,t,n,r,o,i],4,0)},f.prototype.sendTelemetryEvent=function(e,t,n,r,o){a(this,"SendTelemetryEvent",1,[e,t,n,r,o],4,0)},f.prototype._handleResult=function(e){n.prototype._handleResult.call(this,e),i(e)||l(this,e)},f.prototype._handleRetrieveResult=function(e,t){n.prototype._handleRetrieveResult.call(this,e,t),u(this,e,t)},f.newObject=function(e){return o(t.TelemetryService,e,"Microsoft.Telemetry.TelemetryService",!1,4)},f.prototype.toJSON=function(){return c(this,{},{})},f);function f(){return null!==n&&n.apply(this,arguments)||this}t.TelemetryService=p,(e=t.DataFieldType||(t.DataFieldType={})).unset="Unset",e.string="String",e.boolean="Boolean",e.int64="Int64",e.double="Double",(r=t.EventType||(t.EventType={})).sendTelemetryEvent="SendTelemetryEvent",r.customerContent="CustomerContent",r.directNumericEvent="DirectNumericEvent",(t.TelemetryErrorCodes||(t.TelemetryErrorCodes={})).generalException="GeneralException"}(OfficeCore=OfficeCore||{}),function(c){var l="officeWebAuthReplyUrls",u=!1,r=null;function e(n){function r(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return o=n.apply(void 0,e)}var o=null,i=null;return{immediateCall:r,delayCall:function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];i=function(){return r.apply(void 0,e)}},waitForPromise:function(){return i&&(i(),i=null),o||OfficeExtension.CoreUtility.Promise.resolve()}}}function p(e){var t=!1;return r&&(r.supportsAuthToken?t=!0:e&&r.authenticationApiEnabled&&(t=!r.hostPageSupportsAuth||c.supportsTeamsTokenFlow)),t}c.authFlow="authcode",c.autoPopup=!1,c.upnCheck=!0,c.timeout=void 0,c.msal="https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js",c.debugging=!1,c.useMsal3=void 0,c.delay=0,c.delayMsal=0,c.supportsOauthManager=!1,c.supportsTeamsTokenFlow=!0,c.supportsBrowserAuth=!0;var f=e(function(i,a,s){return c.supportsBrowserAuth?new OfficeExtension.CoreUtility.Promise(function(t,n){try{var e="msa"===i.authorityType.toLowerCase();if(OSF.WebAuth.config={authFlow:c.authFlow,authVersion:c.authVersion?c.authVersion:null,msal:c.msal,delayWebAuth:c.delay,delayMsal:c.delayMsal,debugging:c.debugging,useMsal3:c.useMsal3,authority:c.authorityOverride?c.authorityOverride:i.authority,idp:i.authorityType.toLowerCase(),appIds:[e&&i.msaAppId?i.msaAppId:i.appId],redirectUri:a||null,upn:i.upn,puid:i.userId,prefetch:s,telemetryInstance:"otel",autoPopup:c.autoPopup,enableUpnCheck:c.upnCheck,enableConsoleLogging:c.debugging,tenantId:i.tenantId,timeout:c.timeout},OSF.WebAuth.load().then(function(e){d(e,u=!0),t()}).catch(function(e){d(e,u),n({code:"PackageNotLoaded",message:e instanceof Event?e.type:e})}),"implicit"===c.authFlow){var r=a||window.location.href.split("?")[0],o=sessionStorage.getItem(l);o||""===o?o=r:o+=", "+r,o&&sessionStorage.setItem(l,o)}}catch(e){OSF.WebAuth.config=null,OSF.WebAuth.load().then(function(){t()}).catch(function(){n({code:"FailedToLoad",message:e})})}}):OfficeExtension.CoreUtility.Promise.reject({code:"PackageNotLoaded"})});var n=e(function(t,n){return OSF.WebAuth&&"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform?(Office&&Office.context&&Office.context.webAuth?new OfficeExtension.CoreUtility.Promise(function(t,n){Office.context.webAuth.getAuthContextAsync(function(e){if("succeeded"===e.status){if(!(r=e.value)||r.isAnonymous)return void n({code:"CannotGetAuthContext",message:r?r.Error:void 0});if(!r.appId)return void n({code:"CannotGetAuthContext",message:"App ID is missing from getAuthContextAsync. Please verify the WebApplicationInfo node in app manifest."});t(r)}else n({code:"CannotGetAuthContext",message:e.status})})}):OfficeExtension.CoreUtility.Promise.reject({code:"GetAuthContextAsyncMissing",message:"Office:["+!Office+"],Office.context:["+!Office.context+"],Office.context.webAuth:["+!Office.context.webAuth+"]"})).then(function(e){if(f.delayCall(e,t,n),!p(c.supportsOauthManager))return f.waitForPromise()}):OfficeExtension.CoreUtility.Promise.resolve()});function t(e,t){return n.immediateCall(e,t)}function d(n,r){void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded(function(){var e=[oteljs.makeStringDataField("IdentityProvider",OSF.WebAuth.config.idp),oteljs.makeStringDataField("AppId",OSF.WebAuth.config.appIds[0]),oteljs.makeStringDataField("Target",{authFlow:OSF.WebAuth.config.authFlow,authVersion:OSF.WebAuth.config.authVersion,msal:OSF.WebAuth.config.msal,autoPopup:OSF.WebAuth.config.autoPopup,enableUpnCheck:OSF.WebAuth.config.upnCheck}),oteljs.makeBooleanDataField("Result",r),oteljs.makeStringDataField("Error",n instanceof Event?n.type:"")];if(n&&!(n instanceof Event)&&n.Telemetry)for(var t in n.Telemetry)if(n.Telemetry[t])switch(t){case"succeeded":e.push(oteljs.makeBooleanDataField(t,n.Telemetry[t]));break;case"loadedApplicationCount":case"timeToLoad":e.push(oteljs.makeInt64DataField(t,n.Telemetry[t]));break;default:e.push(oteljs.makeStringDataField(t,n.Telemetry[t]))}OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.Load",dataFields:e,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})})}function h(n,r,o){void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded(function(){var e=[oteljs.makeStringDataField("IdentityProvider",OSF.WebAuth.config.idp),oteljs.makeStringDataField("AppId",OSF.WebAuth.config.appIds[0]),oteljs.makeStringDataField("Target",{authFlow:OSF.WebAuth.config.authFlow,authVersion:OSF.WebAuth.config.authVersion,msal:OSF.WebAuth.config.msal,autoPopup:OSF.WebAuth.config.autoPopup,enableUpnCheck:OSF.WebAuth.config.upnCheck}),oteljs.makeBooleanDataField("Popup","boolean"==typeof o&&o),oteljs.makeBooleanDataField("Result",r),oteljs.makeStringDataField("Error",n instanceof Event?n.type:n.ErrorCode)];if(n&&!(n instanceof Event)&&n.Telemetry)for(var t in n.Telemetry)if(n.Telemetry[t])switch(t){case"succeeded":e.push(oteljs.makeBooleanDataField(t,n.Telemetry[t]));break;case"timeToGetToken":e.push(oteljs.makeInt64DataField(t,n.Telemetry[t]));break;default:e.push(oteljs.makeStringDataField(t,n.Telemetry[t]))}OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.GetAccessToken",dataFields:e,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})})}c.load=t,c.getAccessToken=function(c,l){return n.waitForPromise().then(function(){return new OfficeExtension.CoreUtility.Promise(function(r,o){if("web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform)if(p(!!c.appName)){var e=new OfficeCore.RequestContext,t=OfficeCore.AuthenticationService.newObject(e);e._customData="WacPartition";var n=t.getAccessToken(c,null);e.sync().then(function(){r(n.value)}).catch(function(e){return o(e)})}else f.waitForPromise().then(function(){var t,n;OSF.WebAuth&&u?OSF.WebAuth.config.appIds[0]&&OSF.WebAuth.getToken(c.resource,null,OSF.WebAuth.config.appIds[0],OSF._OfficeAppFactory.getHostInfo().osfControlAppCorrelationId,l&&l.popup?l.popup:null,c&&c.authChallenge?c.authChallenge:null).then(function(e){h(e,!0,!(!l||!l.popup)&&l.popup),r({accessToken:e.Token,tokenIdenityType:"msa"==OSF.WebAuth.config.idp.toLowerCase()?OfficeCore.IdentityType.microsoftAccount:OfficeCore.IdentityType.organizationAccount})}).catch(function(e){h(e,!1,!(!l||!l.popup)&&l.popup),o({code:e.ErrorCode,message:e instanceof Event?e.type:e.ErrorMessage})}):(t=u,n=OSF.WebAuth.loadAttempts,void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded(function(){var e=[oteljs.makeBooleanDataField("Loaded",t),oteljs.makeInt64DataField("LoadAttempts","number"==typeof n?n:0)];OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.OfficeFirstPartyAuth.UnexpectedAcquire",dataFields:e,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})}))}).catch(function(e){return o(e)});else{var i=new OfficeCore.RequestContext,a=OfficeCore.AuthenticationService.newObject(i),s=a.onTokenReceived.add(function(t){if(!OfficeExtension.CoreUtility.isNullOrUndefined(t))if(s.remove(),i.sync().catch(function(){}),0==t.code)r(t.tokenValue);else if(OfficeExtension.CoreUtility.isNullOrUndefined(t.errorInfo))o({code:t.code});else try{o(JSON.parse(t.errorInfo))}catch(e){o({code:t.code,message:t.errorInfo})}return null});i.sync().then(function(){var t=a.getAccessToken(c,a._targetId);return i.sync().then(function(){if(OfficeExtension.CoreUtility.isNullOrUndefined(t.value))return null;var e=t.value.accessToken;OfficeExtension.CoreUtility.isNullOrUndefined(e)||r(t.value)})}).catch(function(e){o(e)})}})})},c.getPrimaryIdentityInfo=function(){var e=new OfficeCore.RequestContext,t=OfficeCore.AuthenticationService.newObject(e);e._customData="WacPartition";var n=t.getPrimaryIdentityInfo();return e.sync().then(function(){return n.value})},c.getIdentities=function(){var e=new OfficeCore.RequestContext,t=OfficeCore.AuthenticationService.newObject(e).getIdentities();return e.sync().then(function(){return t.value})},c.onIdentityChanged=function(o){return __awaiter(this,void 0,void 0,function(){var t,n,r=this;return __generator(this,function(e){switch(e.label){case 0:return(e.trys.push([0,3,,4]),"web"===OSF._OfficeAppFactory.getHostInfo().hostPlatform)?[3,2]:(t=new OfficeCore.RequestContext,n=OfficeCore.AuthenticationService.newObject(t),n.onIdentityChanged.add(o),[4,t.sync()]);case 1:return e.sent(),[2,function(){return __awaiter(r,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return n.onIdentityChanged.remove(o),[4,t.sync()];case 1:return e.sent(),[2]}})})}];case 2:return[3,4];case 3:return e.sent(),[3,4];case 4:return[2,function(){return Promise.resolve()}]}})})},"undefined"!=typeof window&&window.OSF&&function(){try{if("undefined"==typeof window||!window.sessionStorage)return;var e=sessionStorage.getItem(l);null!==e&&-1!==e.indexOf(window.location.origin+window.location.pathname)&&t()}catch(e){console.error(e)}}()}(OfficeFirstPartyAuth=OfficeFirstPartyAuth||{}),function(e){!function(l){var r,e,p,t;(e=r=l.PopupOptions||(l.PopupOptions={}))[e.None=0]="None",e[e.Auto=1]="Auto",e[e.Force=2]="Force",(t=p=l.AuthErrorCode||(l.AuthErrorCode={}))[t.UnsupportedUserIdentity=13003]="UnsupportedUserIdentity",t[t.UserAborted=13004]="UserAborted",t[t.InteractionRequired=13005]="InteractionRequired",t[t.ClientError=13006]="ClientError",t[t.ServerError=13007]="ServerError",t[t.NotAvailable=13012]="NotAvailable",t[t.InternalError=5001]="InternalError",t[t.InvalidApiArguments=5013]="InvalidApiArguments";var f={ACCOUNT_UNAVAILABLE:p.UnsupportedUserIdentity,USER_CANCEL:p.UserAborted,USER_INTERACTION_REQUIRED:p.InteractionRequired,PERSISTENT_ERROR:p.ClientError,NO_NETWORK:p.ServerError,TRANSIENT_ERROR:p.ServerError,NESTED_APP_AUTH_UNAVAILABLE:p.NotAvailable},o={POPUP_WINDOW_ERROR:p.ClientError,USER_CANCELLED:p.UserAborted},u={ACCESS_TOKEN:"access_token",XMS_CC:"xms_cc"},d=0,h=!1,g=!1,n=void 0,s=null,m=void 0;l.clientCapabilities=[],l.upnCheck=!0,l.timeout=void 0,l.msal="https://alcdn.msauth.net/browser-1p/2.28.1/js/msal-browser-1p.min.js",l.debugging=!1,l.delay=0,l.delayMsal=0,l.useMsal3=void 0;var y={},v=function(e){try{var t="string"==typeof e?e:e.data,n=JSON.parse(t);if(n.requestId){var r=n.requestId;if(y.hasOwnProperty(r)){var o=p.InternalError,i=y[r],a=i[0],s=i[1];delete y[r];var c=n.token;if(c&&!0===n.success&&c.access_token&&"number"==typeof c.expires_in)return void a({accessToken:c.access_token,expiresOn:new Date(Date.now()+1e3*c.expires_in)});var l=n.error;if(l){var u=l.status;f[u]&&(o=f[u])}s({code:o})}}}catch(e){}},b={code:p.NotAvailable};function i(i,a){function e(e){function t(e,t){var n=Date.now()-r;!function(t,n,r,o,i){if(0<d&&!r)return;d++,void 0!==OTel&&OTel.OTelLogger.onTelemetryLoaded(function(){var e=[oteljs.makeStringDataField("AppId",t),oteljs.makeStringDataField("CorrelationId",n),oteljs.makeBooleanDataField("Popup",r),oteljs.makeInt64DataField("Duration",o),oteljs.makeInt64DataField("ErrorCode",i?i.code:0),oteljs.makeBooleanDataField("BridgeAvailable",_())];OTel.OTelLogger.sendTelemetryEvent({eventName:"Office.Extensibility.OfficeJs.NestedAppAuth.GetAccessToken",dataFields:e,eventFlags:{dataCategories:oteljs.DataCategories.ProductServiceUsage}})})}(s,c,a,n,t)}return e.then(function(e){t(0,null)}).catch(function(e){t(0,e)}),e}var s=i.clientId||m,c=i.correlationId||OSF.OUtil.Guid.generateNewGuid(),r=Date.now();return _()?e(new Promise(function(e,t){var n=OSF.OUtil.Guid.generateNewGuid(),r=i.scopes.join(" "),o={messageType:"NestedAppAuthRequest",method:a?"GetTokenPopup":"GetToken",requestId:n,clientLibrary:"officejs",sendTime:Date.now(),tokenParams:{clientId:s,scope:r,correlationId:c,claims:function(e){if(0===l.clientCapabilities.length)return e;var t={};if(e)try{t=JSON.parse(e)}catch(e){}return t.hasOwnProperty(u.ACCESS_TOKEN)||(t[u.ACCESS_TOKEN]={}),t[u.ACCESS_TOKEN][u.XMS_CC]={values:l.clientCapabilities},JSON.stringify(t)}(i.claims)}};h||(nestedAppAuthBridge.addEventListener("message",v),h=!0),y[n]=[e,t],nestedAppAuthBridge.postMessage(JSON.stringify(o))})):e(n?n.then(function(){if(!g)return Promise.reject(b);var e=i.scopes.join(" ");return e=e.replace(/(\/.default)$/,""),OSF.WebAuth.getToken(e,i.scopes,s,c,a,i.claims).then(function(e){return{accessToken:e.Token,expiresOn:e.MsalResult?e.MsalResult.expiresOn:void 0}}).catch(function(e){var t=p.InternalError,n=void 0;if(e)if(n=e.ErrorMessage,e.MsalResult&&"InteractionRequiredAuthError"===e.MsalResult.name)t=p.InteractionRequired;else if(e.ErrorCode){var r=e.ErrorCode.toUpperCase();o[r]&&(t=o[r])}return Promise.reject({code:t,description:n})})}):Promise.reject(b))}function _(){return"undefined"!=typeof nestedAppAuthBridge}l.isBridgeAvailable=_,l.load=function(r,o,i,a){return m=r,a&&(l.clientCapabilities=a),n||(n=new Promise(function(t,n){if(_())t();else if(Office&&Office.context&&Office.context.auth&&OSF.WebAuth)try{Office.context.auth.getAuthContextAsync(function(e){if("succeeded"===e.status){if(!(s=e.value))return void n(b);OSF.WebAuth.config={authFlow:"authcode",authVersion:l.authVersion?l.authVersion:null,msal:l.msal,delayWebAuth:l.delay,delayMsal:l.delayMsal,debugging:l.debugging,useMsal3:l.useMsal3,authority:l.authorityOverride?l.authorityOverride:s.authorityBaseUrl,idp:"msa"===s.authorityType.toLowerCase()?"msa":"aad",appIds:[r],redirectUri:o||null,upn:s.userPrincipalName,prefetch:i,telemetryInstance:"otel",enableUpnCheck:l.upnCheck,enableConsoleLogging:l.debugging,checkActiveAccount:!0,tenantId:s.tenantId,timeout:l.timeout,clientCapabilities:a},OSF.WebAuth.load().then(function(e){g=!0,t()}).catch(function(e){n(__assign({},b,{description:e instanceof Event?e.type:void 0}))})}else n(b)})}catch(e){n(b)}else n(b)}))},l.getAccessToken=function(t){var n=null==t.popup?r.None:t.popup;if(n===r.Auto&&!t.directUserActionCallback)throw{code:p.InvalidApiArguments};return i(t,n===r.Force).catch(function(e){if(e.code==p.InteractionRequired&&n===r.Auto&&t.directUserActionCallback)return t.directUserActionCallback().then(function(e){if(e)return i(t,!0);throw{code:p.UserAborted}}).catch(function(){throw{code:p.UserAborted}});throw e})}}(e.NestedAppAuth||(e.NestedAppAuth={}))}(OfficeFirstPartyAuth=OfficeFirstPartyAuth||{}),function(i){var n,e;OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod,OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined,OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson,OfficeExtension.Utility.fixObjectPathIfNecessary,OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult,OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags;(i._CC||(i._CC={})).LicenseFeature_StateChanged_EventArgsTransform=function(e,t){var n={feature:t.featureName,isEnabled:t.isEnabled,tier:t.tierName};return t.tierName&&(n.tier=0==t.tierName?LicenseFeatureTier.unknown:1==t.tierName?LicenseFeatureTier.basic:2==t.tierName?LicenseFeatureTier.premium:t.tierName),n},(i._CC||(i._CC={})).ThemeService_OfficeThemeChanged_EventArgsTransform=function(e,t){return{bodyBackgroundColor:t.bodyBackgroundColor,bodyForegroundColor:t.bodyForegroundColor,controlBackgroundColor:t.controlBackgroundColor,controlForegroundColor:t.controlForegroundColor}},(e=n=i.PersonaPromiseType||(i.PersonaPromiseType={}))[e.immediate=0]="immediate",e[e.load=3]="load";var a=function(){};i.PersonaInfoAndSource=a;var t=(r.prototype.performAsyncOperation=function(e,l,u,p){var t=this;e!=n.immediate?p().then(function(e){if(e)u();else{var c=t;c.load("hostId"),c.context.sync().then(function(){var s=c.hostId;t.getPersonaLifetime().then(function(i){var a=function(o){return new OfficeExtension.CoreUtility.Promise(function(t,e){if(o.sendingPersonaHostId==s)for(var n=0;n<o.dataUpdated.length;++n){var r=o.dataUpdated[n];if(l==r)return void p().then(function(e){e&&(u(),i.onPersonaUpdated.remove(a),c.context.sync()),t(e)})}t(!1)})};i.onPersonaUpdated.add(a),c.context.sync()})})}}):u()},r.prototype.getOrganizationAsync=function(n){var o=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var r=o;o.performAsyncOperation(n,PersonaDataUpdated.organization,function(){var e=r.organization;e.load("*"),r.context.sync().then(function(){t(e)})},function(){return new OfficeExtension.CoreUtility.Promise(function(e,t){var n=r.organization;n.load("isWarmedUp"),r.context.sync().then(function(){e(n.isWarmedUp)})})})})},r.prototype.getIsPersonaInfoResolvedCheck=function(){var r=this;return new OfficeExtension.CoreUtility.Promise(function(e,t){var n=r.personaInfo;n.load("isPersonResolved"),r.context.sync().then(function(){e(n.isPersonResolved)})})},r.prototype.getPersonaInfoAsync=function(r){var o=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var n=o;o.performAsyncOperation(r,PersonaDataUpdated.personaInfo,function(){var e=n.personaInfo;e.load(),n.context.sync().then(function(){t(e)})},function(){return o.getIsPersonaInfoResolvedCheck()})})},r.prototype.getPersonaInfoWithSourceAsync=function(r){var o=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var n=o;o.performAsyncOperation(r,PersonaDataUpdated.personaInfo,function(){var e=new a;e.info=n.personaInfo,e.info.load(),e.source=n.personaInfo.sources,e.source.load(),n.context.sync().then(function(){t(e)})},function(){return o.getIsPersonaInfoResolvedCheck()})})},r.prototype.getUnifiedCommunicationInfo=function(r){var o=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var n=o;o.performAsyncOperation(r,PersonaDataUpdated.personaInfo,function(){var e=n.unifiedCommunicationInfo;e.load("*"),n.context.sync().then(function(){t(e)})},function(){return o.getIsPersonaInfoResolvedCheck()})})},r.prototype.getUnifiedGroupInfoAsync=function(r){var o=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var n=o;o.performAsyncOperation(r,PersonaDataUpdated.personaInfo,function(){var e=n.unifiedGroupInfo;e.load("*"),n.context.sync().then(function(){t(e)})},function(){return o.getIsPersonaInfoResolvedCheck()})})},r.prototype.getTypeAsync=function(r){var o=this;return new OfficeExtension.CoreUtility.Promise(function(e,t){var n=o;o.performAsyncOperation(r,PersonaDataUpdated.personaInfo,function(){n.load("type"),n.context.sync().then(function(){e(i.PersonaType[n.type.valueOf()])})},function(){return o.getIsPersonaInfoResolvedCheck()})})},r.prototype.getCustomizationsAsync=function(r){var o=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var n=o;o.performAsyncOperation(r,PersonaDataUpdated.personaInfo,function(){var e=n.getCustomizations();n.context.sync().then(function(){t(e.value)})},function(){return o.getIsPersonaInfoResolvedCheck()})})},r.prototype.getMembersAsync=function(n){var o=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var r=o;o.performAsyncOperation(n,PersonaDataUpdated.members,function(){var e=r.getMembers();e.load("isWarmedUp"),r.context.sync().then(function(){t(e)})},function(){return new OfficeExtension.CoreUtility.Promise(function(e,t){var n=r.getMembers();n.load("isWarmedUp"),r.context.sync().then(function(){e(n.isWarmedUp)})})})})},r.prototype.getMembershipAsync=function(r){var o=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var n=o;o.performAsyncOperation(r,PersonaDataUpdated.membership,function(){var e=n.getMembership();e.load("*"),n.context.sync().then(function(){t(e)})},function(){return new OfficeExtension.CoreUtility.Promise(function(e){var t=n.getMembership();t.load("isWarmedUp"),n.context.sync().then(function(){e(t.isWarmedUp)})})})})},r.prototype.getPersonaLifetime=function(){var r=this;return new OfficeExtension.CoreUtility.Promise(function(t,e){var n=r;n.load("instanceId"),n.context.sync().then(function(){new o(n.context,n.instanceId).getPersonaLifetime().then(function(e){t(e)})})})},r);function r(){}i.PersonaCustom=t;var o=(Object.defineProperty(s.prototype,"serviceContext",{get:function(){return this.m_serviceConext||(this.m_serviceConext=i.ServiceContext.newObject(this.context)),this.m_serviceConext},enumerable:!0,configurable:!0}),s.prototype.getPersonaLifetime=function(){var r=this;return new OfficeExtension.CoreUtility.Promise(function(e,t){var n=r.serviceContext.getPersonaLifetime(r.instanceId);r.context.sync().then(function(){n.load("instanceId"),r.context.sync().then(function(){e(n)})})})},s.prototype.getInitialPersona=function(){var r=this;return new OfficeExtension.CoreUtility.Promise(function(e,t){var n=r.serviceContext.getInitialPersona(r.instanceId);r.context.sync().then(function(){e(n)})})},s.prototype.getLokiTokenProvider=function(){var r=this;return new OfficeExtension.CoreUtility.Promise(function(e,t){var n=r.serviceContext.getLokiTokenProvider(r.instanceId);r.context.sync().then(function(){n.load("instanceId"),r.context.sync().then(function(){e(n)})})})},s);function s(e,t){this.context=e,this.instanceId=t}i.PeopleApiContext=o,(i._CC||(i._CC={})).FirstPartyDialogService_DialogMessage_EventArgsTransform=function(e,t){return{message:t.message}};var c,l,u=(Object.defineProperty(p.prototype,"_targetId",{get:function(){return null==this.m_targetId&&(void 0!==OSF&&OSF.OUtil?this.m_targetId=OSF.OUtil.Guid.generateNewGuid():this.m_targetId=""+this.context._nextId()),this.m_targetId},enumerable:!0,configurable:!0}),p);function p(){}i.AuthenticationServiceCustom=u,(i._CC||(i._CC={})).AuthenticationService_TokenReceived_EventArgsTransform=function(e,t){return{tokenValue:t.tokenValue,code:t.code,errorInfo:t.errorInfo}},(c=i._CC||(i._CC={})).ExternalCodeService_ExternalCodeExecutionCompleted_EventArgsTransform=function(e,t){return{result:t.result}},c.ExternalCodeService_ExternalCodeServiceRequestCompleted_EventArgsTransform=function(e,t){return t},c.ExternalCodeService_ExternalCodeServiceResult_EventArgsTransform=function(e,t){return t},(i._CC||(i._CC={})).AddinSkillActionService_ReplyReceived_EventArgsTransform=function(e,t){return{actionCorrelationId:t.actionCorrelationId,replyMessage:t.replyMessage,resultCode:t.resultCode}},(l=i.ErrorCodes||(i.ErrorCodes={})).apiNotAvailable="ApiNotAvailable",l.clientError="ClientError",l.clpSessionError="ClpSessionError",l.controlIdNotFound="ControlIdNotFound",l.docCookieError="DocCookieError",l.entryIdRequired="EntryIdRequired",l.errorPointer="ErrorPointer",l.generalException="GeneralException",l.hostIntegrationManagerError="HostIntegrationManagerError",l.hostRestartNeeded="HostRestartNeeded",l.instanceNotFound="InstanceNotFound",l.interactiveFlowAborted="InteractiveFlowAborted",l.invalidArgument="InvalidArgument",l.invalidGrant="InvalidGrant",l.invalidResourceUrl="InvalidResourceUrl",l.invalidRibbonDefinition="InvalidRibbonDefinition",l.labelingDisabledAppguard="LabelingDisabledAppguard",l.labelingDisabledNoSignedInClpCompatibleUsers="LabelingDisabledNoSignedInClpCompatibleUsers",l.labelingDisabledPrivacySettings="LabelingDisabledPrivacySettings",l.labelingDisabledProtectedView="LabelingDisabledProtectedView",l.labelingDisabledUnsupportedLabelClient="LabelingDisabledUnsupportedLabelClient",l.msoOLDocumentError="MsoOLDocumentError",l.notImplement="NotImplement",l.objectNotFound="ObjectNotFound",l.officeJSItemLabelForIdentityError="OfficeJSItemLabelForIdentityError",l.officeJSRMSLicenseError="OfficeJSRMSLicenseError",l.officeJSSessionOrDocError="OfficeJSSessionOrDocError",l.officeSolutionFrameworkHostError="OfficeSolutionFrameworkHostError",l.omworkflowUserNotFound="OMWorkflowUserNotFound",l.osfControlContainerError="OsfControlContainerError",l.outOfMemory="OutOfMemory",l.resourceNotSupported="ResourceNotSupported",l.sensitivityDocumentReadOnly="SensitivityDocumentReadOnly",l.sensitivityInsufficientPermission="SensitivityInsufficientPermission",l.sensitivityLabelDisabled="SensitivityLabelDisabled",l.sensitivityLabelingDisabled="SensitivityLabelingDisabled",l.sensitivityLabelNotFound="SensitivityLabelNotFound",l.sensitivityNewLabelSensitivityOrder="SensitivityNewLabelSensitivityOrder",l.sensitivityUnsupportedContentType="SensitivityUnsupportedContentType",l.sensitivityUnsupportedCrossTenant="SensitivityUnsupportedCrossTenant",l.sensitivityUnsupportedDke="SensitivityUnsupportedDke",l.sensitivityUnsupportedUdp="SensitivityUnsupportedUdp",l.serverError="ServerError",l.serviceUrlNotFound="ServiceUrlNotFound",l.sharedRuntimeNotAvailable="SharedRuntimeNotAvailable",l.ticketInvalidParams="TicketInvalidParams",l.ticketNetworkError="TicketNetworkError",l.ticketUnauthorized="TicketUnauthorized",l.ticketUninitialized="TicketUninitialized",l.ticketUnknownError="TicketUnknownError",l.unexpectedError="UnexpectedError",l.unsupportedUserIdentity="UnsupportedUserIdentity",l.userNotSignedIn="UserNotSignedIn",i.Interfaces||(i.Interfaces={});new OfficeExtension.LibraryBuilder({metadata:{version:"1.0.0",name:"OfficeCore",defaultApiSetName:"OfficeSharedApi",hostName:"Office",apiSets:[["1.2","SharedApiUndo"],["1.2","SharedRuntimeInternal"],["1.1","SnapshotControl"],["1.1","SharedApiUndo"],["1.2","DynamicRibbon"],["1.1","DynamicRibbonUndo"],["1.2","FirstPartyAuthentication"],["1.3","FirstPartyAuthentication"],["1.5","FirstPartyAuthentication"],["1.1","SensitivityUndo"],["1.2","SensitivityService"],["1.2","SensitivityUndo"],["1.3","SensitivityService"],["1.3","SensitivityUndo"],["1.1","PrivateAPI"],["1.1","ExternalCodeServiceUndo"],["1.1","TaskpaneAPI"]],strings:["DialogPage","License","LicenseFeature","MsaDeviceTicketOptions","AppRuntimePersistenceService","AppRuntimeService","ThemeService","Tap","MemberInfoList","PersonaActions","PersonaInfoSource","PersonaInfo","PersonaUnifiedCommunicationInfo","PersonaPhotoInfo","PersonaCollection","PersonaOrganizationInfo","UnifiedGroupInfo","Persona","PersonaLifetime","LokiTokenProvider","LokiTokenProviderFactory","ServiceContext","RichapiPcxFeatureChecks","Comment","CommentCollection","ExtensionLifeCycle","OfficeServicesManagerApi","LocaleApi","FirstPartyDialogService","DynamicRibbon","RibbonTab","RibbonButton","RibbonButtonCollection","ServiceUrlProvider","LinkedIn","NetworkUsage","BeforeDocumentCloseNotification","AuthenticationService","RoamingSetting","RoamingSettingCollection","SharedFilePicker","ActionService","Auth","AugLoopEventService","UndoService","UserFeedbackService","NotificationService","SensitivityService","CopilotService","PrivateApiService","ExternalCodeService","BusinessBarService","ShowSimpleDialog","DispatchApiService","DevicePermissionService","TaskpaneService","AddinSkillActionService","UnifiedStoreService","close","registerOnShow","unregisterOnShow","id","_RegisterStateChange","_UnregisterStateChange","","null","registerOfficeThemeChangedEvent","unregisterOfficeThemeChangedEvent","isWarmedUp","isWarmingUp","displayName","email","emailAddresses","sipAddresses","birthday","birthdays","title","jobInfoDepartment","companyName","office","linkedTitles","linkedDepartments","linkedCompanyNames","linkedOffices","webSites","notes","getImageUri","setPlaceholderColor","getPlaceholderUri","getImageUriWithMetadata","getCount","getItem","instanceId","dispose","_RegisterPersonaUpdatedEvent","_UnregisterPersonaUpdatedEvent","this.instanceId","_RegisterLokiTokenAvailableEvent","_UnregisterLokiTokenAvailableEvent","_RegisterIdentityUniqueIdAvailableEvent","_UnregisterIdentityUniqueIdAvailableEvent","_RegisterClientAccessTokenAvailableEvent","_UnregisterClientAccessTokenAvailableEvent","getLokiTokenProvider","registerIdentityChangedEvent","unregisterIdentityChangedEvent","_RegisterHostMessageReceivedEvent","_UnregisterHostMessageReceivedEvent","_RegisterUndoStackChangedEvent","_UnregisterUndoStackChangedEvent","_RegisterUserFeedbackUIDismissedEvent","_UnregisterUserFeedbackUIDismissedEvent","_RegisterUserFeedbackResponseEvent","_UnregisterUserFeedbackResponseEvent","_RegisterSensitivityLabelChangedEvent","_UnregisterSensitivityLabelChangedEvent","execute","_RegisterPrivateApiEvent","_UnregisterPrivateApiEvent","registerExternalCodeExecutionCompletedEvent","unregisterExternalCodeExecutionCompletedEvent","registerExternalCodeServiceRequestCompletedEvent","unregisterExternalCodeServiceRequestCompletedEvent","registerExternalCodeServiceResultEvent","unregisterExternalCodeServiceResultEvent","_RegisterCopilotAgentEvent","_UnregisterCopilotAgentEvent"],enumTypes:[["DialogPageEventType",[],{onShow:1}],["LicenseFeatureTier",["unknown","basic","premium"]],["LicenseEventType",[],{featureStateChanged:1}],["AppRuntimeState",["inactive","background","visible"]],["Visibility",["hidden","visible"]],["ObjectType",["unknown","chart","smartArt","table","image","slide","text"],{ole:"OLE"}],["PersonaCardPerfPoint",["placeHolderRendered","initialCardRendered"]],["MessageType",[],{personaLifetimePersonaUpdatedEvent:3502,lokiTokenProviderLokiTokenAvailableEvent:3503,lokiTokenProviderIdentityUniqueIdAvailableEvent:3504,lokiTokenProviderClientAccessTokenAvailableEvent:3505}],["UnifiedCommunicationAvailability",["notSet","free","idle","busy","idleBusy","doNotDisturb","unalertable","unavailable"]],["UnifiedCommunicationStatus",["online","notOnline","away","busy","beRightBack","onThePhone","outToLunch","inAMeeting","outOfOffice","doNotDisturb","inAConference","getting","notABuddy","disconnected","notInstalled","urgentInterruptionsOnly","mayBeAvailable","idle","inPresentation"]],["UnifiedCommunicationPresence",["free","busy","idle","doNotDistrub","blocked","notSet","outOfOffice"]],["FreeBusyCalendarState",["unknown","free","busy","elsewhere","tentative","outOfOffice"]],["PersonaType",["unknown","enterprise","contact","bot","phoneOnly","oneOff","distributionList","personalDistributionList","anonymous","unifiedGroup"]],["PhoneType",["workPhone","homePhone","mobilePhone","businessFax","otherPhone"]],["AddressType",["workAddress","homeAddress","otherAddress"]],["MemberType",["unknown","individual","group"]],["PersonaDataUpdated",["hostId","type","photo","personaInfo","unifiedCommunicationInfo","organization","unifiedGroupInfo","members","membership","capabilities","customizations","viewableSources","placeholder"]],["CustomizedData",["email","workPhone","workPhone2","workFax","mobilePhone","homePhone","homePhone2","otherPhone","sipAddress","profile","office","company","workAddress","homeAddress","otherAddress","birthday"]],["CommentTextFormat",["plain","markdown","delta"]],["TimeStringFormat",["shortTime","longTime","shortDate","longDate"]],["ServiceProvider",["ariaBrowserPipeUrl","ariaUploadUrl","ariaVNextUploadUrl","lokiAutoDiscoverUrl"]],["IdentityType",["organizationAccount","microsoftAccount","unsupported"]],["AugLoopEventType",[],{onHostMessageReceivedEvent:65542}],["UndoType",[],{onUndoStackChangedEvent:65543,onCopilotOperationStartedEvent:65544}],["TriStateOption",["notSet","true","false"]],["UserFeedbackType",["like","dislike","idea","unclassified"]],["UserFeedbackUIType",["modalDialog","taskpane"]],["UserFeedbackEventType",[],{onUserFeedbackUIDismissedEvent:65546,onUserFeedbackResponseEvent:65550}],["UserFeedbackScreenshotInfoSourceType",["autoCapture","autoCaptureWithHtml2Canvas","providedAtInitialization","dynamicallyProvided"]],["UserFeedbackScreenshotInfoImageFormat",[],{jpeg:"jpeg",png:"png"}],["LabelMessageContext",[],{generic:0,firstPerson:1}],["LabelResultSeverity",[],{info:0,warning:1,error:2}],["SensitivityLabelEventType",[],{onLabelChangedEvent:65549}],["EncryptionType",[],{none:0,irmtemplate:1,irmuserDefinedPermission:2,irmencryptOnly:3,irmdoNotForward:4}],["TryUpgradeLabelError",[],{s_APPLYLABEL_OK:0,e_APPLYLABEL_FAIL:2147467259,e_APPLYLABEL_UNSUPPORTED_CROSSTENANT:2147205120,e_APPLYLABEL_DOCUMENT_READONLY:2147205119,e_APPLYLABEL_INSUFFICIENTPERMISSION:2147205118,e_APPLYLABEL_LABELDISABLED:2147205117,e_APPLYLABEL_UNSUPPORTED_UDP:2147205116,e_APPLYLABEL_LABELING_DISABLED:2147205115,e_APPLYLABEL_UNSUPPORTED_CONTENTTYPE:2147205114,e_APPLYLABEL_UNSUPPORTED_DKE:2147205113,e_APPLYLABEL_LABELNOTFOUND:2147205112,e_APPLYLABEL_USERNOTFOUND:2147220727,e_APPLYLABEL_NEWLABELSENSITIVITYORDER:2147205105}],["PrivateApiEventType",[],{onPrivateEvent:65552}],["RequestMethod",["get","post","patch","delete"]],["ResultType",["executionResult","runtimeInfo","serviceResponse"]],["ErrorCategory",["other","environment","runtime","license","user","auth","billing","invalidArg","python","service","unsupported","dataUpload"]],["BusinessBarType",["info","error","blocked","severeWarning","success","warning"]],["SimpleDialogState",[],{cancel:0,confirm:1,checkedConfirm:2}],["SimpleDialogCategory",[],{information:"information",error:"error",warning:"warning",question:"question",other:"other"}],["DevicePermissionType",[],{camera:"camera",microphone:"microphone",geolocation:"geolocation"}],["CopilotAgentEventType",[],{onCopilotAgentEvent:65556}]],clientObjectTypes:[[1,0,[["_Id",2]],0,[[59,0,2,0,4],["readyToShow",0,2,0,4],[60,0,2,0,4],[61,0,2,0,4],["sendMessageToHost",1,2,0,4]],0,0,0,[["OnShowEvent",0,0,"DialogPageEventType.onShow","this._Id",60,61]],"Microsoft.Office.DialogPage.DialogPage",4],[2,0,0,0,[["isFeatureEnabled",2,2,0,4],["getFeatureTier",2,2,0,4],["isFreemiumUpsellEnabled",0,2,0,4],["launchUpsellExperience",1,2,0,4],["_TestFireStateChangedEvent",1,0,0,3,0,1],["getMsaDeviceTicket",3,2,0,5]],[["getLicenseFeature",3,1,2,0,4]],0,0,0,"Microsoft.Office.Licensing.License",4],[3,0,[[62,3]],0,[[63,0,2,0,4],[64,0,2,0,4]],0,0,0,[["StateChanged",2,0,"LicenseEventType.featureStateChanged","this.id",63,64]]],[4,0,[["scopes",1,0,0,2,1]],0,0,0,0,0,0,"Microsoft.Office.Licensing.MsaDeviceTicketOptions",4],[5,0,0,0,[["setAppRuntimeStartState",1,0,0,2,0,2],["getAppRuntimeStartState",0,2,0,4]],0,0,0,0,"Microsoft.AppRuntime.AppRuntimePersistenceService",4],[6,0,0,0,[["setAppRuntimeState",1,0,0,2,0,2],["getAppRuntimeState",0,2,0,4],["setSnapshotEnabled",1,2,3,4],["getSnapshotEnabled",0,2,3,4],["getContentSnapshotAsBase64",0,2,3,4]],0,0,0,[["SnapshotImageReady",0,3,"65547",65,66,66],["VisibilityChanged",0,0,"65539",65,66,66]],"Microsoft.AppRuntime.AppRuntimeService",4],[7,0,0,0,[[67,0,0,0,2,0,4],[68,0,0,0,2,0,4]],0,0,0,[["OfficeThemeChanged",2,0,"65548",65,67,68]],"Microsoft.Theme.ThemeService",4],[8,0,0,0,[["getEnterpriseUserInfo",0,2,0,5],["getMruFriendlyPath",1,2,0,5],["launchFileUrlInOfficeApp",2,2,0,5],["performLocalSearch",4,2,0,5],["readSearchCache",3,2,0,5],["writeSearchCache",3,2,0,5]],0,0,0,0,"Microsoft.TapRichApi.Tap",4],[9,0,[[69,3],[70,3]],0,[["items",0,2,0,4]],[["getPersonaForMember",18,1,2,0,4]]],[10,0,0,0,[["addContact"],["editContact"],["composeEmail",1],["composeInstantMessage",1],["callPhoneNumber",1],["pinPersonaToQuickContacts"],["toggleTagForAlerts"],["scheduleMeeting"],["openLinkContactUx"],["editContactByIdentifier",1],["showHoverCardForPersona",6],["hideHoverCardForPersona"],["showContextMenu",6],["showContactCard",6],["showExpandedCard",6],["openGroupCalendar"],["subscribeToGroup"],["unsubscribeFromGroup"],["getChangePhotoUrlAndOpenInBrowser"],["startAudioCall"],["startVideoCall"],["openOutlookProperties"],["editUnifiedGroup"],["joinUnifiedGroup"],["leaveUnifiedGroup"]]],[11,0,[[71,3],[72,3],[73,3],[74,3],[75,3],[76,3],[77,3],[78,3],[79,3],[80,3],[81,3],[82,3],[83,3],[84,3],["phones",3],["addresses",3],[85,3],[86,3]]],[12,0,[[71,3],[72,3],[73,3],[74,3],[75,11],[76,11],[77,3],[78,3],[79,3],[80,3],[81,3],[82,3],[83,3],[84,3],[85,3],[86,3],["isPersonResolved",3]],[["sources",11,3,0,0,4]],[["getPhones",0,2,0,4],["getAddresses",0,2,0,4]]],[13,0,[["availability",3],["status",3],["isSelf",3],["isTagged",3],["customStatusString",3],["isBlocked",3],["presenceTooltip",3],["isOutOfOffice",3],["outOfOfficeNote",3],["timezone",3],["meetingLocation",3],["meetingSubject",3],["timezoneBias",3],["idleStartTime",11],["overallCapability",3],["isOnBuddyList",3],["presenceNote",3],["voiceMailUri",3],["availabilityText",3],["availabilityTooltip",3],["isDurationInAvailabilityText",3],["freeBusyStatus",3],["calendarState",3],["presence",3]]],[14,0,0,0,[[87,1,2,0,4,87],[88,1,0,0,0,88],[89,1,2,0,4,89],[90,1,2,0,4,90]]],[15,1,0,0,[[91,0,2,0,4]],[[92,18,1,18,0,4]],0,18],[16,0,[[69,3],[70,3]],[["hierarchy",15,18,0,0,4],["manager",18,2,0,0,4],["directReports",15,18,0,0,4]]],[17,0,[["description",1],["oneDrive",1],["oneNote",1],["isPublic",1],["amIOwner",1],["amIMember",1],["amISubscribed",1],["memberCount",1],["ownerCount",1],["hasGuests",1],["site",1],["planner",1],["classification",1],["subscriptionEnabled",1]]],[18,4,[["hostId",3],["type",3],["capabilities",3],["diagnosticId",3],[93,3]],[["photo",14,3,0,0,4],["personaInfo",12,3,0,0,4],["unifiedCommunicationInfo",13,3,0,0,4],["organization",16,3,0,0,4],["unifiedGroupInfo",17,35,0,0,4],["actions",10,2,0,0,4]],[["getCustomizations",0,2,0,4],["warmup",1],[94],["getViewableSources",0,2,0,4],["reportTimeForRender",2]],[["getMembers",9,0,2,0,4],["getMembership",9,0,2,0,4]]],[19,0,[[93,3]],0,[["getPolicies",0,2,0,4],[95],[96],["getTextScaleFactor",0,2,0,4]],[["getPersona",18,1,2,0,4],["getPersonaForOrgEntry",18,4,2,0,4],["getPersonaForOrgByEntryId",18,4,2,0,4]],0,0,[["PersonaUpdated",0,0,"MessageType.personaLifetimePersonaUpdatedEvent",97,95,96]]],[20,0,[["emailOrUpn",3],[93,3]],0,[["requestToken"],[98],[99],["requestIdentityUniqueId"],[100],[101],["requestClientAccessToken"],[102],[103]],0,0,0,[["ClientAccessTokenAvailable",0,0,"MessageType.lokiTokenProviderClientAccessTokenAvailableEvent",97,102,103],["IdentityUniqueIdAvailable",0,0,"MessageType.lokiTokenProviderIdentityUniqueIdAvailableEvent",97,100,101],["LokiTokenAvailable",0,0,"MessageType.lokiTokenProviderLokiTokenAvailableEvent",97,98,99]]],[21,0,0,0,0,[[104,20,1,2,0,4]],0,0,0,"Microsoft.People.LokiTokenProviderFactory",4],[22,0,0,0,[[94,1],["accountEmailOrUpn",1,2,0,4],["getPersonaPolicies",0,2,0,4]],[[104,20,1,2,0,4],["getPersonaLifetime",19,1,2,0,4],["getInitialPersona",18,1,2,0,4]],0,0,0,"Microsoft.People.ServiceContext",4],[23,0,0,0,[["isAddChangePhotoLinkOnLpcPersonaImageFlightEnabled",0,2,0,4]],0,0,0,0,"Microsoft.People.RichapiPcxFeatureChecks",4],[24,0,[[62,3],["text",1],["created",11],["level",3],["resolved",1],["author",3],["mentions",3]],[["parent",24,2,0,0,4],["parentOrNullObject",24,2,0,0,4],["replies",25,19,0,0,4]],[["getRichText",1,2,0,4],["setRichText",2],["delete"]],[["getParentOrSelf",24,0,2,0,4],["reply",24,2]]],[25,1,0,0,[[91,0,2,0,4]],[[92,24,1,18,0,4]],0,24],[26,0,0,0,[["launchExtensionComponent",3,2,0,5]],0,0,0,0,"Microsoft.OfficeSharedApi.ExtensionLifeCycle",4],[27,0,0,0,[["bindServiceToProfile",3]],0,0,0,0,"Microsoft.OfficeServicesManager.OfficeServicesManagerApi",4],[28,0,0,0,[["getLocaleDateTimeFormattingInfo",1,2,0,4],["formatDateTimeString",3,2,0,4]],0,0,0,0,"Microsoft.LocaleApi.LocaleApi",4],[29,0,0,0,[["displayDialog",2,2,0,5],[59,0,2,0,5]],0,0,0,[["DialogMessage",2,0,"65536",65,66,66]],"Microsoft.FirstPartyDialog.FirstPartyDialogService",4],[30,0,0,[["buttons",33,19,0,0,4]],[["executeRequestUpdate",1,2,0,4],["executeRequestCreate",1,2,5,4]],[["getButton",32,1,2,0,4],["getTab",31,1,2,0,4]],0,0,0,"Microsoft.DynamicRibbon.DynamicRibbon",4],[31,0,[[62,3]],0,[["setVisibility",1,0,0,2,0,6]]],[32,0,[[62,3],["enabled",1,0,0,2,6],["label",3]],0,[["setEnabled",1,0,0,2,0,6]]],[33,1,0,0,[[91,0,2,0,4]],[[92,32,1,18,0,4]],0,32],[34,0,0,0,[["getServiceUrl",2,2,0,4]],0,0,0,0,"Microsoft.DesktopCompliance.ServiceUrlProvider",4],[35,0,0,0,[["isEnabledForOffice",0,2,0,4],["recordLinkedInSettingsCompliance",2]],0,0,0,0,"Microsoft.DesktopCompliance.LinkedIn",4],[36,0,0,0,[["isInOnlineMode",0,2,0,4],["isInDisconnectedMode",0,2,0,4]],0,0,0,0,"Microsoft.DesktopCompliance.NetworkUsage",4],[37,0,0,0,[["enable",0,2,0,4],["disable",0,2,0,4]],0,0,0,[["BeforeCloseNotificationCancelled",0,0,"65540",65,66,66]],"Microsoft.BeforeDocumentCloseNotification.BeforeDocumentCloseNotification",4],[38,4,0,[["roamingSettings",40,2,0,0,4]],[["getAccessToken",2,2,0,5],["getPrimaryIdentityInfo",0,2,7,5],["getIdentities",0,2,8,5],[105,0,0,9,3,0,4],[106,0,0,9,3,0,4]],0,0,0,[["IdentityChanged",0,9,"65545",65,105,106],["TokenReceived",2,7,"3001","this._targetId",66,66]],"Microsoft.Authentication.AuthenticationService",4],[39,0,[[62,3],["value",1,0,0,2,4]]],[40,0,0,0,0,[[92,39,1,2,0,4],["getItemOrNullObject",39,1,2,0,4]]],[41,0,0,0,[["getSharedFilePickerResponse",1,2,0,4]],0,0,0,0,"Microsoft.Office.SharedFilePicker",4],[42,0,0,0,[["getShortcuts",0,2,0,4],["replaceShortcuts",1,0,0,2,0,4],["areShortcutsInUse",1,0,0,2,0,4]],0,0,0,0,"Microsoft.Office.ActionService",4],[43,0,0,0,[["getAccessTokenFirstPartyOAuth",2,2,0,5]],0,0,0,0,"Microsoft.Office.Auth",5],[44,0,0,0,[["sendMessage",1,2,0,5],[107,0,2,0,5],[108,0,2,0,5]],0,0,0,[["HostMessageReceived",0,0,"AugLoopEventType.onHostMessageReceivedEvent",65,107,108]],"Microsoft.Office.AugLoopEventService",5],[45,0,0,0,[["undo",0,0,0,1],[109,0,2,0,5],[110,0,2,0,5],["startCopilotOperation",1,0,0,1],["endCopilotOperation",1,0,0,1]],0,0,0,[["CopilotOperationStarted",0,0,"UndoType.onCopilotOperationStartedEvent",65,66,66],["UndoStackChanged",0,0,"UndoType.onUndoStackChangedEvent",65,109,110]],"Microsoft.Office.UndoService",5],[46,0,0,0,[["collectUserFeedback",4,2,0,5],[111,0,2,0,5],[112,0,2,0,5],["canCollectUserFeedback",0,2,0,5],[113,0,2,0,5],[114,0,2,0,5],["getInitializationData",0,2,0,5],["getHostScreenshot",0,2,0,5],["invokeDiagnosticsLogsUpload",1,2,0,5],["canCollectCopilotFeedback",0,2,0,5]],0,0,0,[["UserFeedbackResponse",0,0,"UserFeedbackEventType.onUserFeedbackResponseEvent",65,113,114],["UserFeedbackUIDismissed",0,0,"UserFeedbackEventType.onUserFeedbackUIDismissedEvent",65,111,112]],"Microsoft.Office.UserFeedbackService",5],[47,0,0,0,[["addNotification",2,0,0,3,0,1],["updateNotification",2,0,0,3,0,1],["removeNotification",1,0,0,3,0,1]],0,0,0,0,"Microsoft.Office.NotificationService",5],[48,0,0,0,[["getLabel",0,0,0,3,0,10],["tryUpgradeLabel",2,0,0,3,0,10],["getHighestSensitivityLabel",1,0,0,3,0,10],[115,0,2,0,5],[116,0,2,0,5],["getSensitivityResultDetails",2,0,11,3,0,12],["getSensitivityResultDetailsByStringErrorCode",2,0,13,3,0,14]],0,0,0,[["LabelChanged",0,0,"SensitivityLabelEventType.onLabelChangedEvent",65,115,116]],"Microsoft.Office.SensitivityService",5],[49,0,0,0,[["launchHelpPaneByQuery",1,0,0,1],["launchHelpPaneByArticleId",1,0,0,1],["launchHelpPaneByArticleIdString",1,0,0,1]],0,0,0,0,"Microsoft.Office.CopilotService",5],[50,0,0,0,[[117,1,0,0,3,0,15],[118,0,2,0,5],[119,0,2,0,5]],0,0,0,[["OnPrivateEvent",0,0,"PrivateApiEventType.onPrivateEvent",65,118,119]],"Microsoft.Office.PrivateApiService",5],[51,0,0,0,[["executePythonCode",1,0,0,3,0,16],["executePythonCodeAsync",1,0,0,3,0,16],[120,0,0,0,3,0,16],[121,0,0,0,3,0,16],["executePythonCodeAsync2",2,0,0,3,0,16],["sendRequestAsync",4,2,0,5],[122,0,2,0,5],[123,0,2,0,5],["getRuntimeInfoAsync",0,2,0,5],[124,0,0,0,3,0,16],[125,0,0,0,3,0,16],["getRuntimeInfoAsync2",1,2,0,5]],0,0,0,[["ExternalCodeExecutionCompleted",2,0,"65551",65,120,121],["ExternalCodeServiceRequestCompleted",2,0,"65553",65,122,123],["ExternalCodeServiceResult",2,0,"65554",65,124,125]],"Microsoft.Office.ExternalCodeService",5],[52,0,0,0,[["show",2,0,0,3,0,4],["hide",1,0,0,3,0,4]],0,0,0,0,"Microsoft.Office.BusinessBarService",5],[53,0,0,0,[["launchSimpleDialog",8,0,0,3]],0,0,0,0,"Microsoft.Office.ShowSimpleDialog",5],[54,0,0,0,[[117,2,2,0,5]],0,0,0,0,"Microsoft.Office.DispatchApiService",5],[55,0,0,0,[["requestPermissions",1,2,0,5]],0,0,0,0,"Microsoft.Office.DevicePermissionService",5],[56,0,0,0,[["notifyHeaderLoaded",0,0,0,3,0,17],[59,0,0,0,3,0,17],["move",0,0,0,3,0,17]],0,0,0,0,"Microsoft.Office.TaskpaneService",5],[57,0,0,0,[["invokeAction",4,2,0,5]],0,0,0,[["ReplyReceived",2,0,"65555",65,66,66]],"Microsoft.Office.AddinSkillActionService",5],[58,0,0,0,[["launchStoreDialogWithCopilotAgentPageShown",0,0,0,3],[126,0,2,0,5],[127,0,2,0,5]],0,0,0,[["CopilotAgentEvent",0,0,"CopilotAgentEventType.onCopilotAgentEvent",65,126,127]],"Microsoft.Office.UnifiedStoreService",5]]},targetNamespaceObject:i})}(OfficeCore=OfficeCore||{}),function(e){var i,t,a,n,r,s,o;function c(e){var t=new OfficeCore.RequestContext;return t._requestFlagModifier|=64,e&&(t._customData="WacPartition"),t}function l(n){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=c(!0),OfficeCore.AppRuntimeService.newObject(t).setAppRuntimeState(n),[4,t.sync()];case 1:return e.sent(),[2]}})})}function u(e){var t=new OfficeCore.RequestContext;return t._requestFlagModifier|=64,e&&(t._customData="WacPartition"),t}(t=i=e.VisibilityMode||(e.VisibilityMode={})).hidden="Hidden",t.taskpane="Taskpane",(n=a=e.StartupBehavior||(e.StartupBehavior={})).none="None",n.load="Load",(r=e.addin||(e.addin={})).setStartupBehavior=function(r){return __awaiter(this,void 0,void 0,function(){var t,n;return __generator(this,function(e){switch(e.label){case 0:if(r!==a.load&&r!==a.none)throw OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.invalidArgument,null,null);return t=r==a.load?OfficeCore.AppRuntimeState.background:OfficeCore.AppRuntimeState.inactive,n=c(!1),OfficeCore.AppRuntimePersistenceService.newObject(n).setAppRuntimeStartState(t),[4,n.sync()];case 1:return e.sent(),[2]}})})},r.getStartupBehavior=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r,o;return __generator(this,function(e){switch(e.label){case 0:return t=c(!1),n=OfficeCore.AppRuntimePersistenceService.newObject(t),r=n.getAppRuntimeStartState(),[4,t.sync()];case 1:return e.sent(),o=r.value,[2,o==OfficeCore.AppRuntimeState.inactive?a.none:a.load]}})})},r.setSnapshotEnabled=function(n){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=c(!0),OfficeCore.AppRuntimeService.newObject(t).setSnapshotEnabled(n),[4,t.sync()];case 1:return e.sent(),[2,Promise.resolve()]}})})},r.getSnapshotEnabled=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=c(!0),n=OfficeCore.AppRuntimeService.newObject(t),r=n.getSnapshotEnabled(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},r.getContentSnapshotAsBase64=function(){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(e){return[2,new OfficeExtension.CoreUtility.Promise(function(t,n){var r=c(!0),e=OfficeCore.AppRuntimeService.newObject(r),o=setTimeout(function(){i.remove(),r.sync().catch(function(){}),n(OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.generalException,"timeout","getContentSnapshotAsBase64"))},7e3),i=e.onSnapshotImageReady.add(function(e){return clearTimeout(o),i.remove(),OfficeExtension.CoreUtility.isNullOrUndefined(e)?(r.sync().catch(function(){}),n(OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.generalException,"execution failed","getContentSnapshotAsBase64"))):(r.sync().catch(function(){}),t(e.imageBase64)),null});r.sync().then(function(){e.getContentSnapshotAsBase64();return r.sync().then(function(){return null})}).catch(function(e){n(e)})})]})})},r._getState=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=c(!0),n=OfficeCore.AppRuntimeService.newObject(t),r=n.getAppRuntimeState(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},r.showAsTaskpane=function(){return l(OfficeCore.AppRuntimeState.visible)},r.hide=function(){return l(OfficeCore.AppRuntimeState.background)},r.onVisibilityModeChanged=function(o){return __awaiter(this,void 0,void 0,function(){var t,n,r=this;return __generator(this,function(e){switch(e.label){case 0:return t=function(){if(!s){var e=c(!0);s=OfficeCore.AppRuntimeService.newObject(e)}return s}(),n=t.onVisibilityChanged.add(function(e){if(o){var t={visibilityMode:e.visibility===OfficeCore.Visibility.visible?i.taskpane:i.hidden};o(t)}return null}),[4,t.context.sync()];case 1:return e.sent(),[2,function(){return __awaiter(r,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return n.remove(),[4,t.context.sync()];case 1:return e.sent(),[2]}})})}]}})})},(o=r.beforeDocumentCloseNotification||(r.beforeDocumentCloseNotification={})).enable=function(){return __awaiter(this,void 0,void 0,function(){var t,n;return __generator(this,function(e){switch(e.label){case 0:return t=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(t=!0),n=u(t),OfficeCore.BeforeDocumentCloseNotification.newObject(n).enable(),[4,n.sync()];case 1:return e.sent(),[2]}})})},o.disable=function(){return __awaiter(this,void 0,void 0,function(){var t,n;return __generator(this,function(e){switch(e.label){case 0:return t=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(t=!0),n=u(t),OfficeCore.BeforeDocumentCloseNotification.newObject(n).disable(),[4,n.sync()];case 1:return e.sent(),[2]}})})},o.onCloseActionCancelled=function(a){return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i=this;return __generator(this,function(e){switch(e.label){case 0:return t=!1,"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(t=!0),n=u(t),r=OfficeCore.BeforeDocumentCloseNotification.newObject(n),o=r.onBeforeCloseNotificationCancelled.add(function(e){return a&&a(),null}),[4,n.sync()];case 1:return e.sent(),[2,function(){return __awaiter(i,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return o.remove(),[4,n.sync()];case 1:return e.sent(),[2]}})})}]}})})}}(Office=Office||{}),function(s){var c,e,t,n,r;function o(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}function l(){return new OfficeCore.RequestContext}(e=c=c||{}).taskpane="Taskpane",e.dialog="Dialog",n=t=s.ExtensionLifeCycle||(s.ExtensionLifeCycle={}),(r=n.taskpane||(n.taskpane={})).close=function(){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=o(),OfficeCore.TaskpaneService.newObject(t).close(),[4,t.sync()];case 1:return e.sent(),[2]}})})},r.move=function(){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=o(),OfficeCore.TaskpaneService.newObject(t).move(),[4,t.sync()];case 1:return e.sent(),[2]}})})},r.notifyHeaderLoaded=function(){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=o(),OfficeCore.TaskpaneService.newObject(t).notifyHeaderLoaded(),[4,t.sync()];case 1:return e.sent(),[2]}})})},n.launchTaskpane=function(a){return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i;return __generator(this,function(e){switch(e.label){case 0:return s.context.platform&&"OfficeOnline"===s.context.platform?(t={SharedRuntimeId:a.sharedRuntimeId,SourceLocationOverrideResourceId:a.sourceLocationOverride,TaskPaneTitle:a.taskpaneTitle,TaskPaneWidth:a.taskpaneWidth},n={OptionalProperties:t,DevProperties:a.settings},s.context.extensionLifeCycle.launchExtensionComponent(null,"Taskpane",null,null,n),[3,3]):[3,1];case 1:return r=l(),o=OfficeCore.ExtensionLifeCycle.newObject(r),i=a.settings,a.settings=i&&OSF.OUtil.serializeSettings(i),o.launchExtensionComponent("",c.taskpane,a),[4,r.sync()];case 2:e.sent(),e.label=3;case 3:return[2]}})})},n.launchDialog=function(a){return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i;return __generator(this,function(e){switch(e.label){case 0:return s.context.platform&&"OfficeOnline"===s.context.platform?(t={SharedRuntimeId:a.sharedRuntimeId,SourceLocationOverrideResourceId:a.sourceLocationOverride},n={OptionalProperties:t,DevProperties:a.settings},s.context.extensionLifeCycle.launchExtensionComponent(null,"SDXDialog",null,null,n),[3,3]):[3,1];case 1:return r=l(),o=OfficeCore.ExtensionLifeCycle.newObject(r),i=a.settings,a.settings=i&&OSF.OUtil.serializeSettings(i),o.launchExtensionComponent("",c.dialog,a),[4,r.sync()];case 2:e.sent(),e.label=3;case 3:return[2]}})})},s.extensionLifeCycle=t}(Office=Office||{}),function(e){var t;function o(){var e=new OfficeCore.RequestContext;return"web"==OSF._OfficeAppFactory.getHostInfo().hostPlatform&&(e._customData="WacPartition"),e}(t=e.ribbon||(e.ribbon={})).requestUpdate=function(e){var t=o(),n=t.ribbon;function r(e){void 0!==e.controls&&void 0!==e.controls.length&&e.controls.length&&e.controls.filter(function(e){return!!e.id}).forEach(function(e){var t=n.getButton(e.id);void 0!==e.enabled&&null!==e.enabled&&(t.enabled=e.enabled)})}return e.tabs.filter(function(e){return!!e.id}).forEach(function(e){var t=n.getTab(e.id);void 0!==e.visible&&null!==e.visible&&t.setVisibility(e.visible),e.groups&&e.groups.length?e.groups.filter(function(e){return!!e.id}).forEach(function(e){r(e)}):r(e)}),t.sync()},t.requestCreateControls=function(e){var n,t=o();return t.ribbon.executeRequestCreate(JSON.stringify(e)),n=250,new Promise(function(e,t){return setTimeout(function(){return e()},n)}).then(function(){return t.sync()})}}(Office=Office||{}),function(e){var t;OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject,OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod,OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined,OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson,OfficeExtension.Utility.fixObjectPathIfNecessary,OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult,OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags;(t||(t={})).generalException="GeneralException";new OfficeExtension.LibraryBuilder({metadata:{version:"1.0.0",name:"OfficeCore",defaultApiSetName:"OfficeSharedApi",hostName:"Office",apiSets:[],strings:["AddinInternalService"],enumTypes:[],clientObjectTypes:[[1,0,0,0,[["notifyActionHandlerReady",0,2,0,4]],0,0,0,0,"Microsoft.InternalService.AddinInternalService",4]]},targetNamespaceObject:e})}(OfficeCore=OfficeCore||{}),function(e){var r,t,d,h,g,m;function y(e){if(e){var t=e.toUpperCase(),n=r.mappings[t];if(!d(n)&&"function"==typeof n)return n}throw OfficeExtension.Utility.createRuntimeError("invalidOperation","sourceData","ActionProxy._getFunction")}function n(e){try{OfficeExtension.Utility.log("ActionProxy._handleMessage"),OfficeExtension.Utility.checkArgumentNull(e,"args");function t(e){if(f[e].messageCategory!==h)return"continue";if("string"==typeof f[e].message&&(f[e].message=JSON.parse(f[e].message)),f[e].messageType===g){var t=null,n=y(o=f[e].message[0]);if(2<=f[e].message.length){var r=f[e].message[1];r&&(t="string"==typeof(p=r)&&"{"===p[0]?JSON.parse(r):r)}void 0!==OSF&&OSF.AppTelemetry&&OSF.AppTelemetry.CallOnAppActivatedIfPending&&OSF.AppTelemetry.CallOnAppActivatedIfPending(),n.apply(null,[t])}else if(f[e].messageType===m){if(d(window.external))throw new OfficeExtension.Error({code:"GenericException",message:"API currently unsupported."});t=null;var o=f[e].message[0],i=f[e].message[1],a=JSON.parse(i);t=a.message;var s=a.replyId,c=0;n=null;try{n=y(o)}catch(e){v(e),c=4}var l=null;if(0==c)try{l=n.apply(null,[t])}catch(e){v(e),c=1}0==c&&d(l)?c=2:0!=c||"object"==typeof l&&"function"==typeof l.then||(c=3);var u=d(OSF.MethodDispId)?OSF.DDA.MethodDispId.dispidAddinSkillActionReply:OSF.MethodDispId.dispidAddinSkillActionReply;if(0==c)try{l.then(function(e){"string"!=typeof e&&(e="",c=3),window.external.Execute(u,[s,e,c],null)},function(e){var t="";c=1,"string"==typeof e?t=e:v(e),window.external.Execute(u,[s,t,c],null)})}catch(e){c=3,v(e),window.external.Execute(u,[s,"",c],null)}else try{window.external.Execute(u,[s,"",c],null)}catch(e){v(e)}}else OfficeExtension.Utility.log("ActionProxy._handleMessage unknown message type "+f[e].messageType);var p}for(var f=e.entries,n=0;n<f.length;n++)t(n)}catch(e){throw v(e),e}return OfficeExtension.Utility._createPromiseFromResult(null)}function v(e){var t=function(e){var t="Unknown Error";if(e)try{e.toString&&(t=e.toString()),t=t+" "+JSON.stringify(e)}catch(e){t="Unexpected Error"}return t}(e);OfficeExtension.Utility.log(t)}function o(){try{Microsoft.Office.WebExtension.onReadyInternal().then(function(){return function(){if(void 0!==OSF&&OSF.DDA&&OSF.DDA.RichApi&&OSF.DDA.RichApi.richApiMessageManager)return(new OfficeExtension.ClientRequestContext).eventRegistration.register(5,"",n)}()}).then(function(){var e,t,n=OSF._OfficeAppFactory.getHostInfo();return!0===n.isDialog||"web"===n.hostPlatform&&"word"!==n.hostType&&"excel"!==n.hostType?void 0:(e=new OfficeExtension.ClientRequestContext,t=OfficeCore.AddinInternalService.newObject(e),e._customData="WacPartition",t.notifyActionHandlerReady(),e.sync())})}catch(e){}}d=OfficeExtension.Utility.isNullOrUndefined,h=2,g=1e3,m=1001,OfficeExtension.Utility.log("ActionProxy.initOnce"),void 0!==e.actions&&(t=e.actions._association,r=t),"undefined"!=typeof document&&(document.readyState&&"loading"!==document.readyState?(OfficeExtension.Utility.log("ActionProxy.initOnce: document.readyState is not loading state"),o()):document.addEventListener&&document.addEventListener("DOMContentLoaded",function(){OfficeExtension.Utility.log("ActionProxy.initOnce: DOMContentLoaded event triggered"),o()})),OfficeExtension.HostBridge.onInited(function(e){e.addHostMessageHandler(function(e){3===e.type&&n(e.message)})})}(Office=Office||{}),function(e){var t;function c(e){var t=new OfficeCore.RequestContext;return e&&e.controlId&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e.controlId),t._customData="WacPartition",t}(t=e.AugLoop||(e.AugLoop={})).SendMessage=function(r,o){return __awaiter(this,void 0,void 0,function(){var t,n;return __generator(this,function(e){switch(e.label){case 0:return t=void 0!==o?o:r,n=c(void 0!==o?r:void 0),OfficeCore.AugLoopEventService.newObject(n).sendMessage(t),[4,n.sync()];case 1:return e.sent(),[2]}})})},t.onHostMessageReceived=function(a,s){return __awaiter(this,void 0,void 0,function(){var n,t,r,o,i=this;return __generator(this,function(e){switch(e.label){case 0:return n=void 0!==s?s:a,t=c(void 0!==s?a:void 0),r=OfficeCore.AugLoopEventService.newObject(t),o=function(e){if(n){var t=e.data;n(t)}return null},r.onHostMessageReceived.add(o),[4,r.context.sync()];case 1:return e.sent(),[2,function(){return __awaiter(i,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return r.onHostMessageReceived.remove(o),[4,t.sync()];case 1:return e.sent(),[2]}})})}]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t,u,p;function f(e){return"object"==typeof e&&"string"==typeof e.controlId?e.controlId:void 0}function d(e){var t=new OfficeCore.RequestContext;return e&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e),t._customData="SkipUndoRecording",t}t=e.Undo||(e.Undo={}),p={},t.undo=function(o){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=d(f(o)),n=OfficeCore.UndoService.newObject(t),r=n.undo(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.onUndoStackChanged=function(i,a){return __awaiter(this,void 0,void 0,function(){var t,n,r,o=this;return __generator(this,function(e){switch(e.label){case 0:return t=a||i,n=d(f(a?i:void 0)),(r=OfficeCore.UndoService.newObject(n)).onUndoStackChanged.add(t),[4,n.sync()];case 1:return e.sent(),[2,function(){return __awaiter(o,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return r.onUndoStackChanged.remove(t),[4,n.sync()];case 1:return e.sent(),[2]}})})}]}})})},t.startCopilotOperation=function(l){return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i,a,s,c;return __generator(this,function(e){switch(e.label){case 0:if(void 0===(t=f(l))){if(void 0!==u)throw new Error("startCopilotOperation is already inprogress")}else if(p[t])throw new Error("startCopilotOperation is already in progress");n=function(){},r=new Promise(function(e){void 0===t?u=e:p[t]=e}),e.label=1;case 1:return e.trys.push([1,4,,5]),o=d(t),i=OfficeCore.UndoService.newObject(o),a=function(){return function(t){return __awaiter(this,void 0,void 0,function(){return __generator(this,function(e){return void 0===t?void 0!==u&&(u(),u=void 0):p[t]&&(p[t](),delete p[t]),[2]})})}(t)},n=function(){try{i.onCopilotOperationStarted.remove(a),o.sync()}catch(e){}},i.onCopilotOperationStarted.add(a),[4,o.sync()];case 2:return e.sent(),s=i.startCopilotOperation(""),[4,o.sync()];case 3:return(e.sent(),s.value)?(void 0!==t&&r.then(function(){n()}),[2,r]):(void 0===t?u=void 0:(n(),delete p[t]),[3,5]);case 4:throw c=e.sent(),void 0===t?u=void 0:(n(),delete p[t]),c;case 5:return[2]}})})},t.endCopilotOperation=function(n){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=d(f(n)),OfficeCore.UndoService.newObject(t).endCopilotOperation(""),[4,t.sync()];case 1:return e.sent(),[2]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t;(t=e.dialogPage||(e.dialogPage={})).close=function(){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(t).close(),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.readyToShow=function(){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(t).readyToShow(),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.onShow=function(o){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=new OfficeCore.RequestContext,(n=OfficeCore.DialogPage.newObject(t)).onOnShowEvent.add(o),r=function(){return n.onOnShowEvent.remove(o),null},[4,t.sync()];case 1:return e.sent(),[2,r]}})})},t.sendMessageToHost=function(n){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=new OfficeCore.RequestContext,OfficeCore.DialogPage.newObject(t).sendMessageToHost(n),[4,t.sync()];case 1:return e.sent(),[2]}})})}}(Office=Office||{}),function(e){var t;function a(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}(t=e.UserFeedback||(e.UserFeedback={})).CollectUserFeedback=function(n,r,o,i){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=a(),OfficeCore.UserFeedbackService.newObject(t).collectUserFeedback(n,r,o,i),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.onUserFeedbackUIDismissed=function(i){return __awaiter(this,void 0,void 0,function(){var t,n,r,o=this;return __generator(this,function(e){switch(e.label){case 0:return t=function(e){if(i){var t=e.isFeedbackSent;i(t)}return null},n=a(),(r=OfficeCore.UserFeedbackService.newObject(n)).onUserFeedbackUIDismissed.add(t),[4,r.context.sync()];case 1:return e.sent(),[2,function(){return __awaiter(o,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return r.onUserFeedbackUIDismissed.remove(t),[4,n.sync()];case 1:return e.sent(),[2]}})})}]}})})},t.CanCollectUserFeedback=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=a(),n=OfficeCore.UserFeedbackService.newObject(t),r=n.canCollectUserFeedback(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.onUserFeedbackResponse=function(i){return __awaiter(this,void 0,void 0,function(){var t,n,r,o=this;return __generator(this,function(e){switch(e.label){case 0:return t=function(e){if(i){var t=e.responseData;i(t)}return null},n=a(),(r=OfficeCore.UserFeedbackService.newObject(n)).onUserFeedbackResponse.add(t),[4,r.context.sync()];case 1:return e.sent(),[2,function(){return __awaiter(o,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return r.onUserFeedbackResponse.remove(t),[4,n.sync()];case 1:return e.sent(),[2]}})})}]}})})},t.InvokeDiagnosticsLogsUpload=function(n){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=a(),OfficeCore.UserFeedbackService.newObject(t).invokeDiagnosticsLogsUpload(n),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.GetInitializationData=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=a(),n=OfficeCore.UserFeedbackService.newObject(t),r=n.getInitializationData(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.GetHostScreenshot=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=a(),n=OfficeCore.UserFeedbackService.newObject(t),r=n.getHostScreenshot(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.CanCollectCopilotFeedback=function(){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=a(),n=OfficeCore.UserFeedbackService.newObject(t),r=n.canCollectCopilotFeedback(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t,n;function s(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}function c(e){return JSON.stringify(e instanceof n?{type:"callout",params:e.params}:{type:"custom",props:e})}t=e.Notification||(e.Notification={}),n=function(){},t.callout=function(e){var t=new n;return t.params=e,t},t.addNotification=function(i,a){return __awaiter(this,void 0,void 0,function(){var n,r,o;return __generator(this,function(e){switch(e.label){case 0:return n=s(),r=OfficeCore.NotificationService.newObject(n),o=r.addNotification(c(i),(t=a,JSON.stringify(t))),[4,n.sync()];case 1:return e.sent(),[2,o.value]}var t})})},t.updateNotification=function(n,r){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=s(),OfficeCore.NotificationService.newObject(t).updateNotification(n,c(r)),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.removeNotification=function(n){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=s(),OfficeCore.NotificationService.newObject(t).removeNotification(n),[4,t.sync()];case 1:return e.sent(),[2]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t;function l(e){var t=new OfficeCore.RequestContext;return e&&e.controlId&&(t.requestHeaders[OfficeExtension.Constants.officeControlId]=e.controlId),t._customData="WacPartition",t}(t=e.Sensitivity||(e.Sensitivity={})).getLabel=function(o){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=l(o),n=OfficeCore.SensitivityService.newObject(t),r=n.getLabel(),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.tryUpgradeLabel=function(){for(var a=[],e=0;e<arguments.length;e++)a[e]=arguments[e];return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i;return __generator(this,function(e){switch(e.label){case 0:if(t=3===a.length,2!==a.length&&3!==a.length)throw new Error("tryUpgradeLabel: Invalid number of parameters ("+a.length+")");return n=t?a[0]:void 0,r=t?a[1]:a[0],o=t?a[2]:a[1],i=l(n),OfficeCore.SensitivityService.newObject(i).tryUpgradeLabel(r,o),[4,i.sync()];case 1:return e.sent(),[2]}})})},t.getHighestSensitivityLabel=function(){for(var s=[],e=0;e<arguments.length;e++)s[e]=arguments[e];return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i,a;return __generator(this,function(e){switch(e.label){case 0:if(t=2===s.length,1!==s.length&&2!==s.length)throw new Error("getHighestSensitivityLabel: Invalid number of parameters ("+s.length+")");return n=t?s[0]:void 0,r=t?s[1]:s[0],o=l(n),i=OfficeCore.SensitivityService.newObject(o),a=i.getHighestSensitivityLabel(r),[4,o.sync()];case 1:return e.sent(),[2,a.value]}})})},t.getSensitivityResultDetails=function(){for(var c=[],e=0;e<arguments.length;e++)c[e]=arguments[e];return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i,a,s;return __generator(this,function(e){switch(e.label){case 0:if(t=3===c.length,2!==c.length&&3!==c.length)throw new Error("getSensitivityResultDetails: Invalid number of parameters ("+c.length+")");return n=t?c[0]:void 0,r=t?c[1]:c[0],o=t?c[2]:c[1],i=l(n),a=OfficeCore.SensitivityService.newObject(i),s=a.getSensitivityResultDetails(r,o),[4,i.sync()];case 1:return e.sent(),[2,s.value]}})})},t.getSensitivityResultDetailsByStringErrorCode=function(){for(var c=[],e=0;e<arguments.length;e++)c[e]=arguments[e];return __awaiter(this,void 0,void 0,function(){var t,n,r,o,i,a,s;return __generator(this,function(e){switch(e.label){case 0:if(t=3===c.length,2!==c.length&&3!==c.length)throw new Error("getSensitivityResultDetails: Invalid number of parameters ("+c.length+")");return n=t?c[0]:void 0,r=t?c[1]:c[0],o=t?c[2]:c[1],i=l(n),a=OfficeCore.SensitivityService.newObject(i),s=a.getSensitivityResultDetailsByStringErrorCode(r,o),[4,i.sync()];case 1:return e.sent(),[2,s.value]}})})},t.onLabelChangedEvent=function(){for(var c=[],e=0;e<arguments.length;e++)c[e]=arguments[e];return __awaiter(this,void 0,void 0,function(){var t,n,i,r,o,a,s=this;return __generator(this,function(e){switch(e.label){case 0:if(t=2===c.length,1!==c.length&&2!==c.length)throw new Error("onLabelChangedEvent: Invalid number of parameters ("+c.length+")");return n=t?c[0]:void 0,i=t?c[1]:c[0],r=function(e){if(i){var t=e.previousLabel,n=e.newLabel,r=e.context,o=e.error;i(t,n,r,o)}return null},o=l(n),(a=OfficeCore.SensitivityService.newObject(o)).onLabelChanged.add(r),[4,a.context.sync()];case 1:return e.sent(),[2,function(){return __awaiter(s,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return a.onLabelChanged.remove(r),[4,o.sync()];case 1:return e.sent(),[2]}})})}]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t;function o(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}(t=e.Copilot||(e.Copilot={})).launchHelpPaneByQuery=function(r){return __awaiter(this,void 0,void 0,function(){var t,n;return __generator(this,function(e){switch(e.label){case 0:return t=o(),n=OfficeCore.CopilotService.newObject(t),n.launchHelpPaneByQuery(r),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.launchHelpPaneByArticleId=function(r){return __awaiter(this,void 0,void 0,function(){var t,n;return __generator(this,function(e){switch(e.label){case 0:return t=o(),n=OfficeCore.CopilotService.newObject(t),n.launchHelpPaneByArticleId(r),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.launchHelpPaneByArticleIdString=function(r){return __awaiter(this,void 0,void 0,function(){var t,n;return __generator(this,function(e){switch(e.label){case 0:return t=o(),n=OfficeCore.CopilotService.newObject(t),n.launchHelpPaneByArticleIdString(r),[4,t.sync()];case 1:return e.sent(),[2]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t;function a(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}(t=e.PrivateApi||(e.PrivateApi={})).execute=function(o){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:return t=a(),n=OfficeCore.PrivateApiService.newObject(t),r=n.execute(o),[4,t.sync()];case 1:return e.sent(),[2,r.value]}})})},t.onPrivateEvent=function(i){return __awaiter(this,void 0,void 0,function(){var t,n,r,o=this;return __generator(this,function(e){switch(e.label){case 0:return t=function(e){if(i){var t=e.messageData;i(t)}return null},n=a(),(r=OfficeCore.PrivateApiService.newObject(n)).onOnPrivateEvent.add(t),[4,r.context.sync()];case 1:return e.sent(),[2,function(){return __awaiter(o,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return r.onOnPrivateEvent.remove(t),[4,n.sync()];case 1:return e.sent(),[2]}})})}]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t,i,n;function a(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}t=e.UnifiedStore||(e.UnifiedStore={}),(i=t.DefaultPageType||(t.DefaultPageType={})).copilotAgentsPage="CopilotAgentsPage",(n=t.CopilotAgentActionType||(t.CopilotAgentActionType={})).activated="Activated",n.removed="Removed",t.launchStore=function(o){return __awaiter(this,void 0,void 0,function(){var t,n,r;return __generator(this,function(e){switch(e.label){case 0:if(o!==i.copilotAgentsPage)throw OfficeExtension.Utility.createRuntimeError(OfficeExtension.ErrorCodes.invalidArgument,null,null);return(t=a(),n=OfficeCore.UnifiedStoreService.newObject(t),o!=i.copilotAgentsPage)?[3,2]:(r=n.launchStoreDialogWithCopilotAgentPageShown(),[4,t.sync()]);case 1:return e.sent(),[2,r];case 2:return[2]}})})},t.onCopilotAgentEvent=function(i){return __awaiter(this,void 0,void 0,function(){var t,n,r,o=this;return __generator(this,function(e){switch(e.label){case 0:return t=function(e){if(i){var t=JSON.parse(e.messageData),n=t.actionType,r=t.titleId;i({actionType:n,titleId:r})}return null},n=a(),(r=OfficeCore.UnifiedStoreService.newObject(n)).onCopilotAgentEvent.add(t),[4,r.context.sync()];case 1:return e.sent(),[2,function(){return __awaiter(o,void 0,void 0,function(){return __generator(this,function(e){switch(e.label){case 0:return r.onCopilotAgentEvent.remove(t),[4,n.sync()];case 1:return e.sent(),[2]}})})}]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t;function o(){var e=new OfficeCore.RequestContext;return e._customData="WacPartition",e}(t=e.BusinessBar||(e.BusinessBar={})).hide=function(r){return __awaiter(this,void 0,void 0,function(){var t,n;return __generator(this,function(e){switch(e.label){case 0:return t=o(),n=OfficeCore.BusinessBarService.newObject(t),n.hide(r),[4,t.sync()];case 1:return e.sent(),[2]}})})},t.show=function(n,r){return __awaiter(this,void 0,void 0,function(){var t;return __generator(this,function(e){switch(e.label){case 0:return t=o(),OfficeCore.BusinessBarService.newObject(t).show(n,r),[4,t.sync()];case 1:return e.sent(),[2]}})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){(e.SimpleDialog||(e.SimpleDialog={})).launchSimpleDialog=function(i){return __awaiter(this,void 0,void 0,function(){var n,r,o;return __generator(this,function(e){switch(e.label){case 0:return(t=new OfficeCore.RequestContext)._customData="WacPartition",n=t,r=OfficeCore.ShowSimpleDialog.newObject(n),o=r.launchSimpleDialog(i.title,i.description,i.telemetryid,i.category,i.hasButton,i.buttonLabel,i.hasCheckbox,i.checkboxLabel),[4,n.sync()];case 1:return e.sent(),[2,o.value]}var t})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){(e.DispatchApi||(e.DispatchApi={})).execute=function(i,a){return __awaiter(this,void 0,void 0,function(){var n,r,o;return __generator(this,function(e){switch(e.label){case 0:return(t=new OfficeCore.RequestContext)._customData="WacPartition",n=t,r=OfficeCore.DispatchApiService.newObject(n),o=r.execute(i,a),[4,n.sync()];case 1:return e.sent(),[2,o.value]}var t})})}}(OfficeFirstParty=OfficeFirstParty||{}),function(e){var t;(t=e.DevicePermissionType||(e.DevicePermissionType={})).camera="camera",t.microphone="microphone",t.geolocation="geolocation",(e.devicePermission||(e.devicePermission={})).requestPermissions=function(i){return __awaiter(this,void 0,void 0,function(){var n,r,o;return __generator(this,function(e){switch(e.label){case 0:return(t=new OfficeCore.RequestContext)._customData="WacPartition",n=t,r=OfficeCore.DevicePermissionService.newObject(n),o=r.requestPermissions(i),[4,n.sync()];case 1:return e.sent(),[2,o.value]}var t})})}}(Office=Office||{}),function(e){var t;function n(){try{if(void 0!==OSF&&void 0!==OSF.isOfficeReactNative&&OSF.isOfficeReactNative())return 1}catch(e){}}function r(){var e="web";try{void 0!==OSF&&void 0!==OSF._OfficeAppFactory&&void 0!==OSF._OfficeAppFactory.getHostInfo&&(e=OSF._OfficeAppFactory.getHostInfo().hostPlatform)}catch(e){}return e}(t=e.ApiHelper||(e.ApiHelper={})).isNativeStorage=function(){var e=r();return!(function(){try{if(void 0!==OSF&&void 0!==OSF._OfficeAppFactory&&void 0!==OSF._OfficeAppFactory.getHostInfo)if(OSF._OfficeAppFactory.getHostInfo().flags&OSF.HostInfoFlags.SharedApp)return 1}catch(e){}}()||!(n()||"win32"===e||"mac"===e&&window._useSDXSandbox))},t.isNativeApiInfomation=function(){var e=r();return!!(n()||"win32"===e||"mac"===e&&window._useSDXSandbox)},t.isNativeDialog=function(){var e=r();return!(!n()&&"win32"!==e)}}(OfficeRuntime=OfficeRuntime||{}),function(e){e.ApiHelper.isNativeApiInfomation()?e.apiInformation=t:e.apiInformation=n;var t={isSetSupported:function(e,t){if("string"!=typeof e)return!1;if(null==t&&(t="0.0.0"),void 0===global.__apiSets)return!1;var n=global.__apiSets,r=Object.keys(n).map(function(e){return e.toLowerCase()}).indexOf(e.toLowerCase());if(-1<r){var o=n[Object.keys(n)[r]];try{var i=s(t),a=void 0;if(0<(a=Array.isArray(o)?function(e,t){for(var n=0;n<e.length;n++){var r=s(e[n]);if(r.major==t)return r}return{major:0,minor:0,patch:0}}(o,i.major):s(o)).major){if(a.major>i.major)return!0;if(a.major==i.major&&a.minor>i.minor)return!0;if(a.major==i.major&&a.minor==i.minor&&a.patch>=i.patch)return!0}}catch(e){return!1}}return!1}},n={isSetSupported:function(e,t){try{return!!(Office&&Office.context&&Office.context.requirements)&&Office.context.requirements.isSetSupported(e,Number(t))}catch(e){return!1}}};function s(e){var t=e.split("."),n=0,r=0,o=0;if(t.length<2&&isNaN(Number(e)))throw"version format incorrect";if(n=Number(t[0]),2<=t.length&&(r=Number(t[1])),3<=t.length&&(o=Number(t[2])),isNaN(n)||isNaN(r)||isNaN(o))throw"version format incorrect";return{major:n,minor:r,patch:o}}}(OfficeRuntime=OfficeRuntime||{});var OfficeRuntime;__extends=this&&this.__extends||function(){var r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)};return function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}}();!function(i){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;function e(e){this._dialogService=e}var t=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,n=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),r=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),o=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),a=OfficeExtension.Utility.fixObjectPathIfNecessary,s=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult);OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags;i.Dialog=e;var c,l=(__extends(u,c=e),u.prototype.close=function(){return this._dialogService.close(),OfficeExtension.CoreUtility.Promise.resolve()},u);function u(){return null!==c&&c.apply(this,arguments)||this}var p,f=(__extends(d,p=e),d.prototype.close=function(){return this._dialogService.close(),this._dialogService.context.sync()},d);function d(){return null!==p&&p.apply(this,arguments)||this}function h(e){return/^(\-|\+)?([0-9]+)%?$/.test(e)}function g(e){var t,n=((t={})[12002]={code:"InvalidUrl",message:"Cannot load URL, no such page or bad URL syntax."},t[12003]={code:"InvalidUrl",message:"HTTPS is required."},t[12004]={code:"Untrusted",message:"Domain is not trusted."},t[12005]={code:"InvalidUrl",message:"HTTPS is required."},t[12007]={code:"FailedToOpen",message:"Another dialog is already opened."},t);return n[e]?n[e]:{code:"Unknown",message:"An unknown error has occured with code: "+e}}i.displayWebDialog=function(r,o){return void 0===o&&(o={}),new OfficeExtension.CoreUtility.Promise(function(e,t){if(o.width&&o.height&&(!h(o.width)||!h(o.height)))throw new OfficeExtension.Error({code:"InvalidArgument",message:'Dimensions must be "number%" or number.'});var n={width:o.width?parseInt(o.width):50,height:o.height?parseInt(o.height):50,displayInIFrame:o.displayInIFrame};(i.ApiHelper.isNativeDialog()?function(e,t,n,r,o){void 0===o&&(o={});var i=new OfficeExtension.ClientRequestContext,a=b.newObject(i),s=new f(a),c=a.onDialogMessage.add(function(e){switch(OfficeExtension.Utility.log("dialogMessageHandler:"+JSON.stringify(e)),e.type){case 17:e.error?n(e.error):t(s);break;case 12:o.onMessage&&o.onMessage(e.message,s);break;case 10:default:12006===e.originalErrorCode?(c&&(c.remove(),i.sync()),o.onClose&&o.onClose()):o.onRuntimeError&&(o.onRuntimeError(e.error,s),n(e.error))}return OfficeExtension.CoreUtility.Promise.resolve()});i.sync().then(function(){return a.displayDialog(r,e),i.sync()}).catch(function(e){n(e)})}:function(e,t,n,r,o){void 0===o&&(o={});var i;function a(e){o.onMessage&&o.onMessage(e.message,i,e.origin)}function s(e){12006===e.error?o.onClose&&o.onClose():o.onRuntimeError&&o.onRuntimeError(new OfficeExtension.Error(g(e.error)),i)}Office.context.ui.displayDialogAsync(r,e,function(e){"failed"===e.status?n(new OfficeExtension.Error(g(e.error.code))):((i=e.value).addEventHandler(Office.EventType.DialogMessageReceived,a),i.addEventHandler(Office.EventType.DialogEventReceived,s),t(new l(i)))})})(n,e,t,r,o)})};var m,y,v,b=(m=OfficeExtension.ClientObject,__extends(_,m),Object.defineProperty(_.prototype,"_className",{get:function(){return"DialogService"},enumerable:!0,configurable:!0}),_.prototype.close=function(){n(this,"Close",1,[],4,0)},_.prototype.displayDialog=function(e,t){n(this,"DisplayDialog",1,[e,t],4,0)},_.prototype._handleResult=function(e){m.prototype._handleResult.call(this,e),r(e)||a(this,e)},_.prototype._handleRetrieveResult=function(e,t){m.prototype._handleRetrieveResult.call(this,e,t),s(this,e,t)},_.newObject=function(e){return t(i.DialogService,e,"Microsoft.Dialog.DialogService",!1,4)},Object.defineProperty(_.prototype,"onDialogMessage",{get:function(){return this.m_dialogMessage||(this.m_dialogMessage=new OfficeExtension.GenericEventHandlers(this.context,this,"DialogMessage",{eventType:65536,registerFunc:function(){},unregisterFunc:function(){},getTargetIdFunc:function(){return null},eventArgsTransformFunc:function(e){var t;try{var n=JSON.parse(e.message),r=n.errorCode?new OfficeExtension.Error(g(n.errorCode)):null;t={originalErrorCode:n.errorCode,type:n.type,error:r,message:n.message,origin:n.origin}}catch(e){t={originalErrorCode:null,type:17,error:new OfficeExtension.Error({code:"GenericException",message:"Unknown error"}),message:e.message}}return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_dialogMessage},enumerable:!0,configurable:!0}),_.prototype.toJSON=function(){return o(this,{},{})},_);function _(){return null!==m&&m.apply(this,arguments)||this}i.DialogService=b,(v=y=y||{})[v.dialogMessageReceived=0]="dialogMessageReceived",v[v.dialogEventReceived=1]="dialogEventReceived",(i.DialogErrorCodes||(i.DialogErrorCodes={})).generalException="GeneralException"}(OfficeRuntime=OfficeRuntime||{}),function(e){var t;function n(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates[e];return null==n?t:"true"===n.toString().toLowerCase()}catch(e){return t}}function r(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates,r=parseInt(n[e]);return isNaN(r)?t:r}catch(e){return t}}function o(e,t){try{var n=Microsoft.Office.WebExtension.FeatureGates[e];return null==n?t:n}catch(e){return t}}(t=e.experimentation||(e.experimentation={})).getBooleanFeatureGate=n,t.getIntFeatureGate=r,t.getStringFeatureGate=o,t.getBooleanFeatureGateAsync=function(e,t){return Promise.resolve(n(e,t))},t.getIntFeatureGateAsync=function(e,t){return Promise.resolve(r(e,t))},t.getStringFeatureGateAsync=function(e,t){return Promise.resolve(o(e,t))}}(OfficeRuntime=OfficeRuntime||{}),function(e){var t,o;t=e.message||(e.message={}),o={},t.on=function(e,t){return function(e,t){o.hasOwnProperty(e)||(o[e]=new n,function(){Office&&Office.context&&Office.context.messaging&&!Office.context.messaging.onMessage&&(Office.context.messaging.onMessage=function(e){var t=e.eventName,n=e.message;o.hasOwnProperty(t)&&o[t].call(n)}.bind(this))}());o[e].add(t)}(e,t),new Promise(function(e){e()})},t.off=function(e,t){var n,r;return n=e,r=t,o.hasOwnProperty(n)&&(r?o[n].remove(r):delete o[n]),new Promise(function(e){e()})},t.emit=function(e,t){var n;return n={eventName:e,message:t},Office&&Office.context&&Office.context.messaging&&Office.context.messaging.sendMessage&&Office.context.messaging.sendMessage(n),new Promise(function(e){e()})};var n=(r.prototype.add=function(e){this.listeners.push(e)},r.prototype.remove=function(e){var t=this.listeners.lastIndexOf(e);-1!==t&&this.listeners.splice(t,1)},r.prototype.call=function(t){this.listeners.forEach(function(e){return e(t)})},r);function r(){this.listeners=[]}e.ListenerManager=n}(OfficeRuntime=OfficeRuntime||{}),function(t){OfficeExtension.BatchApiHelper.createPropertyObject,OfficeExtension.BatchApiHelper.createMethodObject,OfficeExtension.BatchApiHelper.createIndexerObject,OfficeExtension.BatchApiHelper.createRootServiceObject;var n=OfficeExtension.BatchApiHelper.createTopLevelServiceObject,r=(OfficeExtension.BatchApiHelper.createChildItemObject,OfficeExtension.BatchApiHelper.invokeMethod),o=(OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,OfficeExtension.BatchApiHelper.invokeSetProperty,OfficeExtension.Utility.isNullOrUndefined),e=(OfficeExtension.Utility.isUndefined,OfficeExtension.Utility.throwIfNotLoaded,OfficeExtension.Utility.throwIfApiNotSupported,OfficeExtension.Utility.load,OfficeExtension.Utility.retrieve,OfficeExtension.Utility.toJson),i=OfficeExtension.Utility.fixObjectPathIfNecessary,a=(OfficeExtension.Utility._handleNavigationPropertyResults,OfficeExtension.Utility.adjustToDateTime,OfficeExtension.Utility.processRetrieveResult),s=(OfficeExtension.Utility.setMockData,OfficeExtension.CommonUtility.calculateApiFlags,"_Office_AsyncStorage_"),c=s+"|_unusedKey_",l={getItem:function(n){return d(function(e,t){return e.multiGet(t,JSON.stringify([n]))},function(e){var t=JSON.parse(e);return t&&t[0]&&t[0][1]?t[0][1]:null})},setItem:function(n,r){return d(function(e,t){return e.multiSet(t,JSON.stringify([[n,r]]))},function(){return null})},removeItem:function(n){return d(function(e,t){return e.multiRemove(t,JSON.stringify([n]))},function(){return null})},getItems:function(n){return d(function(e,t){return e.multiGet(t,JSON.stringify(n))},function(e){var t=JSON.parse(e),r={};return t&&t.forEach(function(e){var t=e[0],n=e[1];return r[t]=n}),n&&n.forEach(function(e){r[e]&&r[e]}),r})},setItems:function(e){var n=[];for(var t in e)e.hasOwnProperty(t)&&n.push([t,e[t]]);return d(function(e,t){return e.multiSet(t,JSON.stringify(n))},function(){return null})},removeItems:function(n){return d(function(e,t){return e.multiRemove(t,JSON.stringify(n))},function(){return null})},getKeys:function(){return d(function(e,t){return e.getAllKeys(t)},function(e){return JSON.parse(e)})}},u={getItem:function(e){return m(function(){return p(e)})},setItem:function(e,t){return g(function(){return f(e,t)})},removeItem:function(e){return g(function(){return window.localStorage.removeItem(s+e)})},getItems:function(o){return new Promise(function(e,t){var n={},r=[];try{h()}catch(e){t(e)}o.forEach(function(e){try{var t=p(e);n[e]=t||null}catch(e){r.push(e)}}),0<r.length?t(new Error("Unknown error.")):e(n)})},setItems:function(t){return y(t,function(e){return f(e,t[e])})},removeItems:function(e){return y(e,function(e){return window.localStorage.removeItem(s+e)})},getKeys:function(){return m(function(){return Object.keys(window.localStorage).filter(function(e){return 0===e.indexOf(s)}).map(function(e){return e.substr(s.length)})})}};function p(e){return window.localStorage.getItem(s+e)}function f(e,t){window.localStorage.setItem(s+e,t)}function d(i,a){return new OfficeExtension.CoreUtility.Promise(function(r,o){var t=v.getInstance(),n=t.setCallBack(function(e,t){if(t)o(t);else{var n=a(e);r(n)}});t.ctx.sync().then(function(){var e=t.getPersistentKvStorageService();return i(e,n),t.ctx.sync()}).catch(function(e){o(e)})})}function h(){f(c,null),window.localStorage.removeItem(c)}function g(n,r){return void 0===r&&(r=function(){}),new Promise(function(e,t){try{h(),n(),r(null),e()}catch(e){r(e),t(e)}})}function m(r,o){return void 0===o&&(o=function(){}),new Promise(function(e,t){try{h();var n=r();o(null,n),e(n)}catch(e){o(e,null),t(e)}})}function y(o,i,a){return void 0===a&&(a=function(){}),new Promise(function(e,t){var n=[];try{h()}catch(e){n.push(e)}for(var r in o)if(o.hasOwnProperty(r)||Array.isArray(o))try{Array.isArray(o)?i(o[r]):i(r)}catch(e){n.push(e)}a(n),0<n.length?t(n):e()})}t.ApiHelper.isNativeStorage()?t.storage=l:t.storage=u;var v=(b.getInstance=function(){return void 0===b.instance?b.instance=new b:b.instance._perkvstorService=O.newObject(b.instance.ctx),b.instance},b.prototype.getPersistentKvStorageService=function(){return this._perkvstorService},b.prototype.getCallBack=function(e){return this._callDict[e]},b.prototype.setCallBack=function(e){var t=this._invokeId;return this._callDict[this._invokeId++]=e,t},b);function b(){var n=this;this._invokeId=0,this._callDict={},this.ctx=new OfficeExtension.ClientRequestContext,this._perkvstorService=O.newObject(this.ctx),this._eventResult=this._perkvstorService.onPersistentStorageMessage.add(function(e){OfficeExtension.Utility.log("persistentKvStoragegMessageHandler:"+JSON.stringify(e));var t=n._callDict[e.invokeId];t&&(t(e.message,e.error),delete n._callDict[e.invokeId])})}var _,O=(_=OfficeExtension.ClientObject,__extends(S,_),Object.defineProperty(S.prototype,"_className",{get:function(){return"PersistentKvStorageService"},enumerable:!0,configurable:!0}),S.prototype.clear=function(e){r(this,"Clear",1,[e],4,0)},S.prototype.getAllKeys=function(e){r(this,"GetAllKeys",1,[e],4,0)},S.prototype.multiGet=function(e,t){r(this,"MultiGet",1,[e,t],4,0)},S.prototype.multiRemove=function(e,t){r(this,"MultiRemove",1,[e,t],4,0)},S.prototype.multiSet=function(e,t){r(this,"MultiSet",1,[e,t],4,0)},S.prototype._handleResult=function(e){_.prototype._handleResult.call(this,e),o(e)||i(this,e)},S.prototype._handleRetrieveResult=function(e,t){_.prototype._handleRetrieveResult.call(this,e,t),a(this,e,t)},S.newObject=function(e){return n(t.PersistentKvStorageService,e,"Microsoft.PersistentKvStorage.PersistentKvStorageService",!1,4)},Object.defineProperty(S.prototype,"onPersistentStorageMessage",{get:function(){return this.m_persistentStorageMessage||(this.m_persistentStorageMessage=new OfficeExtension.GenericEventHandlers(this.context,this,"PersistentStorageMessage",{eventType:65537,registerFunc:function(){},unregisterFunc:function(){},getTargetIdFunc:function(){return null},eventArgsTransformFunc:function(e){var t,n,r,o;try{var i=JSON.parse(e.message),a=parseInt(i.errorCode),s=0!=a?new OfficeExtension.Error((n=a,(r={})[16389]={code:"GenericException",message:"Unknown error."},r[65535]={code:"Unexcepted",message:"Catastrophic failure."},r[14]={code:"OutOfMemory",message:"Ran out of memory."},r[87]={code:"InvalidArg",message:"One or more arguments are invalid."},r[16385]={code:"NotImplemented",message:"Not implemented."},r[6]={code:"BadHandle",message:"File Handle is not Set."},r[5]={code:"AccessDenied",message:"Can't read the Storage File."},(o=r)[n]?o[n]:{code:"Unknown",message:"An unknown error has occured"})):null;t={invokeId:i.invokeId,message:i.message,error:s}}catch(e){t={invokeId:-1,message:e.message,error:new OfficeExtension.Error({code:"GenericException",message:"Unknown error"})}}return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_persistentStorageMessage},enumerable:!0,configurable:!0}),S.prototype.toJSON=function(){return e(this,{},{})},S);function S(){return null!==_&&_.apply(this,arguments)||this}t.PersistentKvStorageService=O,(t.ErrorCodes||(t.ErrorCodes={})).generalException="GeneralException"}(OfficeRuntime=OfficeRuntime||{});var PowerPoint;__extends=this&&this.__extends||function(){var r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}}();!function(i){var n,r="PowerPoint",o="PowerPointApi",e=OfficeExtension.BatchApiHelper.createPropertyObject,a=OfficeExtension.BatchApiHelper.createMethodObject,t=OfficeExtension.BatchApiHelper.createIndexerObject,s=(OfficeExtension.BatchApiHelper.createRootServiceObject,OfficeExtension.BatchApiHelper.createTopLevelServiceObject),c=OfficeExtension.BatchApiHelper.createChildItemObject,l=OfficeExtension.BatchApiHelper.invokeMethod,u=OfficeExtension.BatchApiHelper.invokeEnsureUnchanged,p=OfficeExtension.BatchApiHelper.invokeSetProperty,f=OfficeExtension.Utility.isNullOrUndefined,d=OfficeExtension.Utility.isUndefined,h=OfficeExtension.Utility.throwIfNotLoaded,g=OfficeExtension.Utility.throwIfApiNotSupported,m=OfficeExtension.Utility.load,y=OfficeExtension.Utility.retrieve,v=OfficeExtension.Utility.toJson,b=OfficeExtension.Utility.fixObjectPathIfNecessary,_=OfficeExtension.Utility._handleNavigationPropertyResults,O=OfficeExtension.Utility.adjustToDateTime,S=OfficeExtension.Utility.processRetrieveResult,C=OfficeExtension.Utility.setMockData,A=(OfficeExtension.CommonUtility.calculateApiFlags,n=OfficeExtension.ClientObject,__extends(P,n),Object.defineProperty(P.prototype,"_className",{get:function(){return"Application"},enumerable:!0,configurable:!0}),P.prototype.insertHyperLink=function(e,t){g("Application.insertHyperLink",o,"1.1",r),l(this,"InsertHyperLink",0,[e,t],1,0)},P.prototype.insertSlideFromContent=function(e){return g("Application.insertSlideFromContent",o,"1.1",r),l(this,"InsertSlideFromContent",0,[e],1,0)},P.prototype._handleResult=function(e){n.prototype._handleResult.call(this,e),f(e)||b(this,e)},P.prototype._handleRetrieveResult=function(e,t){n.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},P.newObject=function(e){return s(i.Application,e,"Microsoft.Office.PowerPoint.Application",!1,4)},P.prototype.toJSON=function(){return v(this,{},{})},P);function P(){return null!==n&&n.apply(this,arguments)||this}i.Application=A;var E,T="Presentation",w=(E=OfficeExtension.ClientObject,__extends(I,E),Object.defineProperty(I.prototype,"_className",{get:function(){return"Presentation"},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"_scalarPropertyNames",{get:function(){return["title","id"]},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Title","Id"]},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"_navigationPropertyNames",{get:function(){return["slides","slideMasters","tags","bindings","customXmlParts","properties"]},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"bindings",{get:function(){return g("Presentation.bindings","Experiment52","1.1",r),this._B||(this._B=e(i.BindingCollection,this,"Bindings",!0,4)),this._B},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"customXmlParts",{get:function(){return g("Presentation.customXmlParts",o,"1.7",r),this._C||(this._C=e(i.CustomXmlPartCollection,this,"CustomXmlParts",!0,4)),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"properties",{get:function(){return g("Presentation.properties",o,"1.7",r),this._P||(this._P=e(i.DocumentProperties,this,"Properties",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"slideMasters",{get:function(){return g("Presentation.slideMasters",o,"1.3",r),this._S||(this._S=e(i.SlideMasterCollection,this,"SlideMasters",!0,4)),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"slides",{get:function(){return g("Presentation.slides",o,"1.2",r),this._Sl||(this._Sl=e(i.SlideCollection,this,"Slides",!0,4)),this._Sl},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"tags",{get:function(){return g("Presentation.tags",o,"1.3",r),this._T||(this._T=e(i.TagCollection,this,"Tags",!0,4)),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"id",{get:function(){return h("id",this._I,T,this._isNull),g("Presentation.id",o,"1.5",r),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"title",{get:function(){return h("title",this._Ti,T,this._isNull),this._Ti},enumerable:!0,configurable:!0}),I.prototype.applyJOfcCommands=function(e,t){return g("Presentation.applyJOfcCommands","PptCopilotActionApi","1.0",r),l(this,"ApplyJOfcCommands",0,[e,t],1,0)},I.prototype.applyJOfcCommandsAsync=function(e,t){return g("Presentation.applyJOfcCommandsAsync","PptCopilotActionApi","1.0",r),l(this,"ApplyJOfcCommandsAsync",0,[e,t],1,0)},I.prototype.copilotAction=function(e,t){return g("Presentation.copilotAction","PptCopilotActionApi","1.1",r),l(this,"CopilotAction",0,[e,t],1,0)},I.prototype.copilotActionAsync=function(e,t){return g("Presentation.copilotActionAsync","PptCopilotActionApi","1.1",r),l(this,"CopilotActionAsync",0,[e,t],1,0)},I.prototype.getSelectedShapes=function(){return g("Presentation.getSelectedShapes",o,"1.5",r),a(i.ShapeScopedCollection,this,"GetSelectedShapes",0,[],!0,!1,null,0)},I.prototype.getSelectedSlides=function(){return g("Presentation.getSelectedSlides",o,"1.5",r),a(i.SlideScopedCollection,this,"GetSelectedSlides",0,[],!0,!1,null,0)},I.prototype.getSelectedTextRange=function(){return g("Presentation.getSelectedTextRange",o,"1.5",r),a(i.TextRange,this,"GetSelectedTextRange",0,[],!1,!1,null,0)},I.prototype.getSelectedTextRangeOrNullObject=function(){return g("Presentation.getSelectedTextRangeOrNullObject",o,"1.5",r),a(i.TextRange,this,"GetSelectedTextRangeOrNullObject",0,[],!1,!1,null,0)},I.prototype.insertSlidesFromBase64=function(e,t){g("Presentation.insertSlidesFromBase64",o,"1.2",r),l(this,"InsertSlidesFromBase64",0,[e,t],0,0)},I.prototype.setSelectedSlides=function(e){g("Presentation.setSelectedSlides",o,"1.5",r),l(this,"SetSelectedSlides",0,[e],0,0)},I.prototype._RegisterEvent=function(e,t){l(this,"_RegisterEvent",1,[e,t],4,0)},I.prototype._RegisterEventApplyJOfcCommandsCompleted=function(){g("Presentation._RegisterEventApplyJOfcCommandsCompleted","PptCopilotActionApi","1.0",r),l(this,"_RegisterEventApplyJOfcCommandsCompleted",0,[],0,0)},I.prototype._RegisterEventCopilotActionCompleted=function(){g("Presentation._RegisterEventCopilotActionCompleted","PptCopilotActionApi","1.1",r),l(this,"_RegisterEventCopilotActionCompleted",0,[],0,0)},I.prototype._UnregisterEvent=function(e,t){l(this,"_UnregisterEvent",1,[e,t],4,0)},I.prototype._UnregisterEventApplyJOfcCommandsCompleted=function(){g("Presentation._UnregisterEventApplyJOfcCommandsCompleted","PptCopilotActionApi","1.0",r),l(this,"_UnregisterEventApplyJOfcCommandsCompleted",0,[],0,0)},I.prototype._UnregisterEventCopilotActionCompleted=function(){g("Presentation._UnregisterEventCopilotActionCompleted","PptCopilotActionApi","1.1",r),l(this,"_UnregisterEventCopilotActionCompleted",0,[],0,0)},I.prototype._handleResult=function(e){if(E.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Id)||(this._I=t.Id),d(t.Title)||(this._Ti=t.Title),_(this,t,["bindings","Bindings","customXmlParts","CustomXmlParts","properties","Properties","slideMasters","SlideMasters","slides","Slides","tags","Tags"])}},I.prototype.load=function(e){return m(this,e)},I.prototype.retrieve=function(e){return y(this,e)},I.prototype._handleIdResult=function(e){E.prototype._handleIdResult.call(this,e),f(e)||d(e.Id)||(this._I=e.Id)},I.prototype._handleRetrieveResult=function(e,t){E.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Object.defineProperty(I.prototype,"onApplyJOfcCommandsCompleted",{get:function(){var e=this;return g("Presentation.onApplyJOfcCommandsCompleted","PptCopilotActionApi","1.0",r),this.m_applyJOfcCommandsCompleted||(this.m_applyJOfcCommandsCompleted=new OfficeExtension.GenericEventHandlers(this.context,this,"ApplyJOfcCommandsCompleted",{eventType:1,registerFunc:function(){return e._RegisterEventApplyJOfcCommandsCompleted()},unregisterFunc:function(){return e._UnregisterEventApplyJOfcCommandsCompleted()},getTargetIdFunc:function(){return e.id},eventArgsTransformFunc:function(e){var t={requestId:e.requestId,result:e.result};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_applyJOfcCommandsCompleted},enumerable:!0,configurable:!0}),Object.defineProperty(I.prototype,"onCopilotActionCompleted",{get:function(){var e=this;return g("Presentation.onCopilotActionCompleted","PptCopilotActionApi","1.1",r),this.m_copilotActionCompleted||(this.m_copilotActionCompleted=new OfficeExtension.GenericEventHandlers(this.context,this,"CopilotActionCompleted",{eventType:2,registerFunc:function(){return e._RegisterEventCopilotActionCompleted()},unregisterFunc:function(){return e._UnregisterEventCopilotActionCompleted()},getTargetIdFunc:function(){return e.id},eventArgsTransformFunc:function(e){var t={requestId:e.requestId,result:e.result};return OfficeExtension.Utility._createPromiseFromResult(t)}})),this.m_copilotActionCompleted},enumerable:!0,configurable:!0}),I.prototype.toJSON=function(){return v(this,{title:this._Ti},{})},I.prototype.setMockData=function(e){C(this,e)},I.prototype.ensureUnchanged=function(e){u(this,e)},I);function I(){return null!==E&&E.apply(this,arguments)||this}i.Presentation=w,(i.BindingType||(i.BindingType={})).shape="Shape";var x,D="CustomXmlPart",F=(x=OfficeExtension.ClientObject,__extends(R,x),Object.defineProperty(R.prototype,"_className",{get:function(){return"CustomXmlPart"},enumerable:!0,configurable:!0}),Object.defineProperty(R.prototype,"_scalarPropertyNames",{get:function(){return["id","namespaceUri"]},enumerable:!0,configurable:!0}),Object.defineProperty(R.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","NamespaceUri"]},enumerable:!0,configurable:!0}),Object.defineProperty(R.prototype,"id",{get:function(){return h("id",this._I,D,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(R.prototype,"namespaceUri",{get:function(){return h("namespaceUri",this._N,D,this._isNull),this._N},enumerable:!0,configurable:!0}),R.prototype.delete=function(){l(this,"Delete",0,[],0,0)},R.prototype.getXml=function(){return l(this,"GetXml",1,[],4,0)},R.prototype.setXml=function(e){l(this,"SetXml",0,[e],0,0)},R.prototype._handleResult=function(e){if(x.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Id)||(this._I=t.Id),d(t.NamespaceUri)||(this._N=t.NamespaceUri)}},R.prototype.load=function(e){return m(this,e)},R.prototype.retrieve=function(e){return y(this,e)},R.prototype._handleIdResult=function(e){x.prototype._handleIdResult.call(this,e),f(e)||d(e.Id)||(this._I=e.Id)},R.prototype._handleRetrieveResult=function(e,t){x.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},R.prototype.toJSON=function(){return v(this,{},{})},R.prototype.setMockData=function(e){C(this,e)},R.prototype.ensureUnchanged=function(e){u(this,e)},R);function R(){return null!==x&&x.apply(this,arguments)||this}i.CustomXmlPart=F;var N,M=(N=OfficeExtension.ClientObject,__extends(j,N),Object.defineProperty(j.prototype,"_className",{get:function(){return"CustomXmlPartScopedCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(j.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(j.prototype,"items",{get:function(){return h("items",this.m__items,"CustomXmlPartScopedCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),j.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},j.prototype.getItem=function(e){return t(i.CustomXmlPart,this,[e])},j.prototype.getItemOrNullObject=function(e){return a(i.CustomXmlPart,this,"GetItemOrNullObject",1,[e],!1,!1,null,4)},j.prototype.getOnlyItem=function(){return a(i.CustomXmlPart,this,"GetOnlyItem",1,[],!1,!1,null,4)},j.prototype.getOnlyItemOrNullObject=function(){return a(i.CustomXmlPart,this,"GetOnlyItemOrNullObject",1,[],!1,!1,null,4)},j.prototype._handleResult=function(e){if(N.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.CustomXmlPart,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},j.prototype.load=function(e){return m(this,e)},j.prototype.retrieve=function(e){return y(this,e)},j.prototype._handleRetrieveResult=function(e,t){var n=this;N.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.CustomXmlPart,!0,n,e,t)})},j.prototype.toJSON=function(){return v(this,{},{},this.m__items)},j.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.CustomXmlPart,!0,n,e,t)},function(e){return n.m__items=e})},j);function j(){return null!==N&&N.apply(this,arguments)||this}i.CustomXmlPartScopedCollection=M;var k,H=(k=OfficeExtension.ClientObject,__extends(U,k),Object.defineProperty(U.prototype,"_className",{get:function(){return"CustomXmlPartCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(U.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(U.prototype,"items",{get:function(){return h("items",this.m__items,"CustomXmlPartCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),U.prototype.add=function(e){return a(i.CustomXmlPart,this,"Add",0,[e],!1,!0,null,0)},U.prototype.getByNamespace=function(e){return a(i.CustomXmlPartScopedCollection,this,"GetByNamespace",1,[e],!0,!1,null,4)},U.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},U.prototype.getItem=function(e){return t(i.CustomXmlPart,this,[e])},U.prototype.getItemOrNullObject=function(e){return a(i.CustomXmlPart,this,"GetItemOrNullObject",1,[e],!1,!1,null,4)},U.prototype._handleResult=function(e){if(k.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.CustomXmlPart,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},U.prototype.load=function(e){return m(this,e)},U.prototype.retrieve=function(e){return y(this,e)},U.prototype._handleRetrieveResult=function(e,t){var n=this;k.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.CustomXmlPart,!0,n,e,t)})},U.prototype.toJSON=function(){return v(this,{},{},this.m__items)},U.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.CustomXmlPart,!0,n,e,t)},function(e){return n.m__items=e})},U);function U(){return null!==k&&k.apply(this,arguments)||this}i.CustomXmlPartCollection=H;var L,B=(L=OfficeExtension.ClientObject,__extends(W,L),Object.defineProperty(W.prototype,"_className",{get:function(){return"Hyperlink"},enumerable:!0,configurable:!0}),Object.defineProperty(W.prototype,"_scalarPropertyNames",{get:function(){return["address","screenTip"]},enumerable:!0,configurable:!0}),Object.defineProperty(W.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Address","ScreenTip"]},enumerable:!0,configurable:!0}),Object.defineProperty(W.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(W.prototype,"address",{get:function(){return h("address",this._A,"Hyperlink",this._isNull),this._A},set:function(e){this._A=e,p(this,"Address",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(W.prototype,"screenTip",{get:function(){return h("screenTip",this._S,"Hyperlink",this._isNull),this._S},set:function(e){this._S=e,p(this,"ScreenTip",e,0)},enumerable:!0,configurable:!0}),W.prototype._handleResult=function(e){if(L.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Address)||(this._A=t.Address),d(t.ScreenTip)||(this._S=t.ScreenTip)}},W.prototype.load=function(e){return m(this,e)},W.prototype.retrieve=function(e){return y(this,e)},W.prototype._handleRetrieveResult=function(e,t){L.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},W.prototype.toJSON=function(){return v(this,{},{})},W.prototype.setMockData=function(e){C(this,e)},W.prototype.ensureUnchanged=function(e){u(this,e)},W);function W(){return null!==L&&L.apply(this,arguments)||this}i.Hyperlink=B;var q,V,G,J,z,K,X,Q=(q=OfficeExtension.ClientObject,__extends($,q),Object.defineProperty($.prototype,"_className",{get:function(){return"HyperlinkCollection"},enumerable:!0,configurable:!0}),Object.defineProperty($.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty($.prototype,"items",{get:function(){return h("items",this.m__items,"HyperlinkCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),$.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},$.prototype.getItemAt=function(e){return a(i.Hyperlink,this,"GetItemAt",1,[e],!1,!1,null,4)},$.prototype._handleResult=function(e){if(q.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.Hyperlink,!1,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},$.prototype.load=function(e){return m(this,e)},$.prototype.retrieve=function(e){return y(this,e)},$.prototype._handleRetrieveResult=function(e,t){var n=this;q.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.Hyperlink,!1,n,e,t)})},$.prototype.toJSON=function(){return v(this,{},{},this.m__items)},$.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.Hyperlink,!1,n,e,t)},function(e){return n.m__items=e})},$);function $(){return null!==q&&q.apply(this,arguments)||this}i.HyperlinkCollection=Q,(V=i.ConnectorType||(i.ConnectorType={})).straight="Straight",V.elbow="Elbow",V.curve="Curve",(G=i.GeometricShapeType||(i.GeometricShapeType={})).lineInverse="LineInverse",G.triangle="Triangle",G.rightTriangle="RightTriangle",G.rectangle="Rectangle",G.diamond="Diamond",G.parallelogram="Parallelogram",G.trapezoid="Trapezoid",G.nonIsoscelesTrapezoid="NonIsoscelesTrapezoid",G.pentagon="Pentagon",G.hexagon="Hexagon",G.heptagon="Heptagon",G.octagon="Octagon",G.decagon="Decagon",G.dodecagon="Dodecagon",G.star4="Star4",G.star5="Star5",G.star6="Star6",G.star7="Star7",G.star8="Star8",G.star10="Star10",G.star12="Star12",G.star16="Star16",G.star24="Star24",G.star32="Star32",G.roundRectangle="RoundRectangle",G.round1Rectangle="Round1Rectangle",G.round2SameRectangle="Round2SameRectangle",G.round2DiagonalRectangle="Round2DiagonalRectangle",G.snipRoundRectangle="SnipRoundRectangle",G.snip1Rectangle="Snip1Rectangle",G.snip2SameRectangle="Snip2SameRectangle",G.snip2DiagonalRectangle="Snip2DiagonalRectangle",G.plaque="Plaque",G.ellipse="Ellipse",G.teardrop="Teardrop",G.homePlate="HomePlate",G.chevron="Chevron",G.pieWedge="PieWedge",G.pie="Pie",G.blockArc="BlockArc",G.donut="Donut",G.noSmoking="NoSmoking",G.rightArrow="RightArrow",G.leftArrow="LeftArrow",G.upArrow="UpArrow",G.downArrow="DownArrow",G.stripedRightArrow="StripedRightArrow",G.notchedRightArrow="NotchedRightArrow",G.bentUpArrow="BentUpArrow",G.leftRightArrow="LeftRightArrow",G.upDownArrow="UpDownArrow",G.leftUpArrow="LeftUpArrow",G.leftRightUpArrow="LeftRightUpArrow",G.quadArrow="QuadArrow",G.leftArrowCallout="LeftArrowCallout",G.rightArrowCallout="RightArrowCallout",G.upArrowCallout="UpArrowCallout",G.downArrowCallout="DownArrowCallout",G.leftRightArrowCallout="LeftRightArrowCallout",G.upDownArrowCallout="UpDownArrowCallout",G.quadArrowCallout="QuadArrowCallout",G.bentArrow="BentArrow",G.uturnArrow="UturnArrow",G.circularArrow="CircularArrow",G.leftCircularArrow="LeftCircularArrow",G.leftRightCircularArrow="LeftRightCircularArrow",G.curvedRightArrow="CurvedRightArrow",G.curvedLeftArrow="CurvedLeftArrow",G.curvedUpArrow="CurvedUpArrow",G.curvedDownArrow="CurvedDownArrow",G.swooshArrow="SwooshArrow",G.cube="Cube",G.can="Can",G.lightningBolt="LightningBolt",G.heart="Heart",G.sun="Sun",G.moon="Moon",G.smileyFace="SmileyFace",G.irregularSeal1="IrregularSeal1",G.irregularSeal2="IrregularSeal2",G.foldedCorner="FoldedCorner",G.bevel="Bevel",G.frame="Frame",G.halfFrame="HalfFrame",G.corner="Corner",G.diagonalStripe="DiagonalStripe",G.chord="Chord",G.arc="Arc",G.leftBracket="LeftBracket",G.rightBracket="RightBracket",G.leftBrace="LeftBrace",G.rightBrace="RightBrace",G.bracketPair="BracketPair",G.bracePair="BracePair",G.callout1="Callout1",G.callout2="Callout2",G.callout3="Callout3",G.accentCallout1="AccentCallout1",G.accentCallout2="AccentCallout2",G.accentCallout3="AccentCallout3",G.borderCallout1="BorderCallout1",G.borderCallout2="BorderCallout2",G.borderCallout3="BorderCallout3",G.accentBorderCallout1="AccentBorderCallout1",G.accentBorderCallout2="AccentBorderCallout2",G.accentBorderCallout3="AccentBorderCallout3",G.wedgeRectCallout="WedgeRectCallout",G.wedgeRRectCallout="WedgeRRectCallout",G.wedgeEllipseCallout="WedgeEllipseCallout",G.cloudCallout="CloudCallout",G.cloud="Cloud",G.ribbon="Ribbon",G.ribbon2="Ribbon2",G.ellipseRibbon="EllipseRibbon",G.ellipseRibbon2="EllipseRibbon2",G.leftRightRibbon="LeftRightRibbon",G.verticalScroll="VerticalScroll",G.horizontalScroll="HorizontalScroll",G.wave="Wave",G.doubleWave="DoubleWave",G.plus="Plus",G.flowChartProcess="FlowChartProcess",G.flowChartDecision="FlowChartDecision",G.flowChartInputOutput="FlowChartInputOutput",G.flowChartPredefinedProcess="FlowChartPredefinedProcess",G.flowChartInternalStorage="FlowChartInternalStorage",G.flowChartDocument="FlowChartDocument",G.flowChartMultidocument="FlowChartMultidocument",G.flowChartTerminator="FlowChartTerminator",G.flowChartPreparation="FlowChartPreparation",G.flowChartManualInput="FlowChartManualInput",G.flowChartManualOperation="FlowChartManualOperation",G.flowChartConnector="FlowChartConnector",G.flowChartPunchedCard="FlowChartPunchedCard",G.flowChartPunchedTape="FlowChartPunchedTape",G.flowChartSummingJunction="FlowChartSummingJunction",G.flowChartOr="FlowChartOr",G.flowChartCollate="FlowChartCollate",G.flowChartSort="FlowChartSort",G.flowChartExtract="FlowChartExtract",G.flowChartMerge="FlowChartMerge",G.flowChartOfflineStorage="FlowChartOfflineStorage",G.flowChartOnlineStorage="FlowChartOnlineStorage",G.flowChartMagneticTape="FlowChartMagneticTape",G.flowChartMagneticDisk="FlowChartMagneticDisk",G.flowChartMagneticDrum="FlowChartMagneticDrum",G.flowChartDisplay="FlowChartDisplay",G.flowChartDelay="FlowChartDelay",G.flowChartAlternateProcess="FlowChartAlternateProcess",G.flowChartOffpageConnector="FlowChartOffpageConnector",G.actionButtonBlank="ActionButtonBlank",G.actionButtonHome="ActionButtonHome",G.actionButtonHelp="ActionButtonHelp",G.actionButtonInformation="ActionButtonInformation",G.actionButtonForwardNext="ActionButtonForwardNext",G.actionButtonBackPrevious="ActionButtonBackPrevious",G.actionButtonEnd="ActionButtonEnd",G.actionButtonBeginning="ActionButtonBeginning",G.actionButtonReturn="ActionButtonReturn",G.actionButtonDocument="ActionButtonDocument",G.actionButtonSound="ActionButtonSound",G.actionButtonMovie="ActionButtonMovie",G.gear6="Gear6",G.gear9="Gear9",G.funnel="Funnel",G.mathPlus="MathPlus",G.mathMinus="MathMinus",G.mathMultiply="MathMultiply",G.mathDivide="MathDivide",G.mathEqual="MathEqual",G.mathNotEqual="MathNotEqual",G.cornerTabs="CornerTabs",G.squareTabs="SquareTabs",G.plaqueTabs="PlaqueTabs",G.chartX="ChartX",G.chartStar="ChartStar",G.chartPlus="ChartPlus",(J=i.ShapeLineDashStyle||(i.ShapeLineDashStyle={})).dash="Dash",J.dashDot="DashDot",J.dashDotDot="DashDotDot",J.longDash="LongDash",J.longDashDot="LongDashDot",J.roundDot="RoundDot",J.solid="Solid",J.squareDot="SquareDot",J.longDashDotDot="LongDashDotDot",J.systemDash="SystemDash",J.systemDot="SystemDot",J.systemDashDot="SystemDashDot",(z=i.ShapeFontUnderlineStyle||(i.ShapeFontUnderlineStyle={})).none="None",z.single="Single",z.double="Double",z.heavy="Heavy",z.dotted="Dotted",z.dottedHeavy="DottedHeavy",z.dash="Dash",z.dashHeavy="DashHeavy",z.dashLong="DashLong",z.dashLongHeavy="DashLongHeavy",z.dotDash="DotDash",z.dotDashHeavy="DotDashHeavy",z.dotDotDash="DotDotDash",z.dotDotDashHeavy="DotDotDashHeavy",z.wavy="Wavy",z.wavyHeavy="WavyHeavy",z.wavyDouble="WavyDouble",(K=i.ParagraphHorizontalAlignment||(i.ParagraphHorizontalAlignment={})).left="Left",K.center="Center",K.right="Right",K.justify="Justify",K.justifyLow="JustifyLow",K.distributed="Distributed",K.thaiDistributed="ThaiDistributed",(X=i.TextVerticalAlignment||(i.TextVerticalAlignment={})).top="Top",X.middle="Middle",X.bottom="Bottom",X.topCentered="TopCentered",X.middleCentered="MiddleCentered",X.bottomCentered="BottomCentered";var Z,Y="TableMergedArea",ee=(Z=OfficeExtension.ClientObject,__extends(te,Z),Object.defineProperty(te.prototype,"_className",{get:function(){return"TableMergedArea"},enumerable:!0,configurable:!0}),Object.defineProperty(te.prototype,"_scalarPropertyNames",{get:function(){return["columnCount","columnIndex","rowCount","rowIndex"]},enumerable:!0,configurable:!0}),Object.defineProperty(te.prototype,"_scalarPropertyOriginalNames",{get:function(){return["ColumnCount","ColumnIndex","RowCount","RowIndex"]},enumerable:!0,configurable:!0}),Object.defineProperty(te.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(te.prototype,"columnCount",{get:function(){return h("columnCount",this._C,Y,this._isNull),this._C},set:function(e){this._C=e,p(this,"ColumnCount",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(te.prototype,"columnIndex",{get:function(){return h("columnIndex",this._Co,Y,this._isNull),this._Co},set:function(e){this._Co=e,p(this,"ColumnIndex",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(te.prototype,"rowCount",{get:function(){return h("rowCount",this._R,Y,this._isNull),this._R},set:function(e){this._R=e,p(this,"RowCount",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(te.prototype,"rowIndex",{get:function(){return h("rowIndex",this._Ro,Y,this._isNull),this._Ro},set:function(e){this._Ro=e,p(this,"RowIndex",e,0)},enumerable:!0,configurable:!0}),te.prototype.delete=function(){l(this,"Delete",0,[],0,0)},te.prototype.resize=function(e,t){l(this,"Resize",0,[e,t],0,0)},te.prototype._handleResult=function(e){if(Z.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.ColumnCount)||(this._C=t.ColumnCount),d(t.ColumnIndex)||(this._Co=t.ColumnIndex),d(t.RowCount)||(this._R=t.RowCount),d(t.RowIndex)||(this._Ro=t.RowIndex)}},te.prototype.load=function(e){return m(this,e)},te.prototype.retrieve=function(e){return y(this,e)},te.prototype._handleRetrieveResult=function(e,t){Z.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},te.prototype.toJSON=function(){return v(this,{},{})},te.prototype.setMockData=function(e){C(this,e)},te.prototype.ensureUnchanged=function(e){u(this,e)},te);function te(){return null!==Z&&Z.apply(this,arguments)||this}i.TableMergedArea=ee;var ne,re="TableCell",oe=(ne=OfficeExtension.ClientObject,__extends(ie,ne),Object.defineProperty(ie.prototype,"_className",{get:function(){return"TableCell"},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"_scalarPropertyNames",{get:function(){return["borders","fill","font","horizontalAlignment","indentLevel","margins","text","textRuns","verticalAlignment"]},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Borders","Fill","Font","HorizontalAlignment","IndentLevel","Margins","Text","TextRuns","VerticalAlignment"]},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0,!0,!0,!0,!0,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"borders",{get:function(){return h("borders",this._B,re,this._isNull),this._B},set:function(e){this._B=e,p(this,"Borders",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"fill",{get:function(){return h("fill",this._F,re,this._isNull),this._F},set:function(e){this._F=e,p(this,"Fill",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"font",{get:function(){return h("font",this._Fo,re,this._isNull),this._Fo},set:function(e){this._Fo=e,p(this,"Font",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"horizontalAlignment",{get:function(){return h("horizontalAlignment",this._H,re,this._isNull),this._H},set:function(e){this._H=e,p(this,"HorizontalAlignment",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"indentLevel",{get:function(){return h("indentLevel",this._I,re,this._isNull),this._I},set:function(e){this._I=e,p(this,"IndentLevel",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"margins",{get:function(){return h("margins",this._M,re,this._isNull),this._M},set:function(e){this._M=e,p(this,"Margins",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"text",{get:function(){return h("text",this._T,re,this._isNull),this._T},set:function(e){this._T=e,p(this,"Text",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"textRuns",{get:function(){return h("textRuns",this._Te,re,this._isNull),this._Te},set:function(e){this._Te=e,p(this,"TextRuns",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(ie.prototype,"verticalAlignment",{get:function(){return h("verticalAlignment",this._V,re,this._isNull),this._V},set:function(e){this._V=e,p(this,"VerticalAlignment",e,0)},enumerable:!0,configurable:!0}),ie.prototype.getMergedAreaOrNullObject=function(){return a(i.TableMergedArea,this,"GetMergedAreaOrNullObject",1,[],!1,!1,null,4)},ie.prototype._handleResult=function(e){if(ne.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Borders)||(this._B=t.Borders),d(t.Fill)||(this._F=t.Fill),d(t.Font)||(this._Fo=t.Font),d(t.HorizontalAlignment)||(this._H=t.HorizontalAlignment),d(t.IndentLevel)||(this._I=t.IndentLevel),d(t.Margins)||(this._M=t.Margins),d(t.Text)||(this._T=t.Text),d(t.TextRuns)||(this._Te=t.TextRuns),d(t.VerticalAlignment)||(this._V=t.VerticalAlignment)}},ie.prototype.load=function(e){return m(this,e)},ie.prototype.retrieve=function(e){return y(this,e)},ie.prototype._handleRetrieveResult=function(e,t){ne.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},ie.prototype.toJSON=function(){return v(this,{},{})},ie.prototype.setMockData=function(e){C(this,e)},ie.prototype.ensureUnchanged=function(e){u(this,e)},ie);function ie(){return null!==ne&&ne.apply(this,arguments)||this}i.TableCell=oe;var ae,se="TableColumn",ce=(ae=OfficeExtension.ClientObject,__extends(le,ae),Object.defineProperty(le.prototype,"_className",{get:function(){return"TableColumn"},enumerable:!0,configurable:!0}),Object.defineProperty(le.prototype,"_scalarPropertyNames",{get:function(){return["width","columnIndex"]},enumerable:!0,configurable:!0}),Object.defineProperty(le.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Width","ColumnIndex"]},enumerable:!0,configurable:!0}),Object.defineProperty(le.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(le.prototype,"columnIndex",{get:function(){return h("columnIndex",this._C,se,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(le.prototype,"width",{get:function(){return h("width",this._W,se,this._isNull),this._W},set:function(e){this._W=e,p(this,"Width",e,0)},enumerable:!0,configurable:!0}),le.prototype.delete=function(){l(this,"Delete",0,[],0,0)},le.prototype._handleResult=function(e){if(ae.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.ColumnIndex)||(this._C=t.ColumnIndex),d(t.Width)||(this._W=t.Width)}},le.prototype.load=function(e){return m(this,e)},le.prototype.retrieve=function(e){return y(this,e)},le.prototype._handleRetrieveResult=function(e,t){ae.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},le.prototype.toJSON=function(){return v(this,{},{})},le.prototype.setMockData=function(e){C(this,e)},le.prototype.ensureUnchanged=function(e){u(this,e)},le);function le(){return null!==ae&&ae.apply(this,arguments)||this}i.TableColumn=ce;var ue,pe=(ue=OfficeExtension.ClientObject,__extends(fe,ue),Object.defineProperty(fe.prototype,"_className",{get:function(){return"TableColumnCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(fe.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(fe.prototype,"items",{get:function(){return h("items",this.m__items,"TableColumnCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),fe.prototype.add=function(e,t){l(this,"Add",0,[e,t],0,0)},fe.prototype.deleteColumns=function(e){l(this,"DeleteColumns",0,[e],0,0)},fe.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},fe.prototype.getItemAt=function(e){return a(i.TableColumn,this,"GetItemAt",1,[e],!1,!1,null,4)},fe.prototype._handleResult=function(e){if(ue.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.TableColumn,!1,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},fe.prototype.load=function(e){return m(this,e)},fe.prototype.retrieve=function(e){return y(this,e)},fe.prototype._handleRetrieveResult=function(e,t){var n=this;ue.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.TableColumn,!1,n,e,t)})},fe.prototype.toJSON=function(){return v(this,{},{},this.m__items)},fe.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.TableColumn,!1,n,e,t)},function(e){return n.m__items=e})},fe);function fe(){return null!==ue&&ue.apply(this,arguments)||this}i.TableColumnCollection=pe;var de,he=(de=OfficeExtension.ClientObject,__extends(ge,de),Object.defineProperty(ge.prototype,"_className",{get:function(){return"TableMergedAreaCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(ge.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(ge.prototype,"items",{get:function(){return h("items",this.m__items,"TableMergedAreaCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),ge.prototype.add=function(e){l(this,"Add",0,[e],0,0)},ge.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},ge.prototype.getItemAtOrNullObject=function(e,t){return a(i.TableMergedArea,this,"GetItemAtOrNullObject",1,[e,t],!1,!1,null,4)},ge.prototype._handleResult=function(e){if(de.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.TableMergedArea,!1,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},ge.prototype.load=function(e){return m(this,e)},ge.prototype.retrieve=function(e){return y(this,e)},ge.prototype._handleRetrieveResult=function(e,t){var n=this;de.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.TableMergedArea,!1,n,e,t)})},ge.prototype.toJSON=function(){return v(this,{},{},this.m__items)},ge.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.TableMergedArea,!1,n,e,t)},function(e){return n.m__items=e})},ge);function ge(){return null!==de&&de.apply(this,arguments)||this}i.TableMergedAreaCollection=he;var me,ye="TableRow",ve=(me=OfficeExtension.ClientObject,__extends(be,me),Object.defineProperty(be.prototype,"_className",{get:function(){return"TableRow"},enumerable:!0,configurable:!0}),Object.defineProperty(be.prototype,"_scalarPropertyNames",{get:function(){return["height","currentHeight","rowIndex"]},enumerable:!0,configurable:!0}),Object.defineProperty(be.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Height","CurrentHeight","RowIndex"]},enumerable:!0,configurable:!0}),Object.defineProperty(be.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!1,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(be.prototype,"currentHeight",{get:function(){return h("currentHeight",this._C,ye,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(be.prototype,"height",{get:function(){return h("height",this._H,ye,this._isNull),this._H},set:function(e){this._H=e,p(this,"Height",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(be.prototype,"rowIndex",{get:function(){return h("rowIndex",this._R,ye,this._isNull),this._R},enumerable:!0,configurable:!0}),be.prototype.delete=function(){l(this,"Delete",0,[],0,0)},be.prototype._handleResult=function(e){if(me.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.CurrentHeight)||(this._C=t.CurrentHeight),d(t.Height)||(this._H=t.Height),d(t.RowIndex)||(this._R=t.RowIndex)}},be.prototype.load=function(e){return m(this,e)},be.prototype.retrieve=function(e){return y(this,e)},be.prototype._handleRetrieveResult=function(e,t){me.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},be.prototype.toJSON=function(){return v(this,{},{})},be.prototype.setMockData=function(e){C(this,e)},be.prototype.ensureUnchanged=function(e){u(this,e)},be);function be(){return null!==me&&me.apply(this,arguments)||this}i.TableRow=ve;var _e,Oe,Se=(_e=OfficeExtension.ClientObject,__extends(Ce,_e),Object.defineProperty(Ce.prototype,"_className",{get:function(){return"TableRowCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(Ce.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(Ce.prototype,"items",{get:function(){return h("items",this.m__items,"TableRowCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),Ce.prototype.add=function(e,t){l(this,"Add",0,[e,t],0,0)},Ce.prototype.deleteRows=function(e){l(this,"DeleteRows",0,[e],0,0)},Ce.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},Ce.prototype.getItemAt=function(e){return a(i.TableRow,this,"GetItemAt",1,[e],!1,!1,null,4)},Ce.prototype._handleResult=function(e){if(_e.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.TableRow,!1,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},Ce.prototype.load=function(e){return m(this,e)},Ce.prototype.retrieve=function(e){return y(this,e)},Ce.prototype._handleRetrieveResult=function(e,t){var n=this;_e.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.TableRow,!1,n,e,t)})},Ce.prototype.toJSON=function(){return v(this,{},{},this.m__items)},Ce.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.TableRow,!1,n,e,t)},function(e){return n.m__items=e})},Ce);function Ce(){return null!==_e&&_e.apply(this,arguments)||this}i.TableRowCollection=Se,(Oe=i.TableStyle||(i.TableStyle={})).noStyleNoGrid="NoStyleNoGrid",Oe.themedStyle1Accent1="ThemedStyle1Accent1",Oe.themedStyle1Accent2="ThemedStyle1Accent2",Oe.themedStyle1Accent3="ThemedStyle1Accent3",Oe.themedStyle1Accent4="ThemedStyle1Accent4",Oe.themedStyle1Accent5="ThemedStyle1Accent5",Oe.themedStyle1Accent6="ThemedStyle1Accent6",Oe.noStyleTableGrid="NoStyleTableGrid",Oe.themedStyle2Accent1="ThemedStyle2Accent1",Oe.themedStyle2Accent2="ThemedStyle2Accent2",Oe.themedStyle2Accent3="ThemedStyle2Accent3",Oe.themedStyle2Accent4="ThemedStyle2Accent4",Oe.themedStyle2Accent5="ThemedStyle2Accent5",Oe.themedStyle2Accent6="ThemedStyle2Accent6",Oe.lightStyle1="LightStyle1",Oe.lightStyle1Accent1="LightStyle1Accent1",Oe.lightStyle1Accent2="LightStyle1Accent2",Oe.lightStyle1Accent3="LightStyle1Accent3",Oe.lightStyle1Accent4="LightStyle1Accent4",Oe.lightStyle1Accent5="LightStyle1Accent5",Oe.lightStyle1Accent6="LightStyle1Accent6",Oe.lightStyle2="LightStyle2",Oe.lightStyle2Accent1="LightStyle2Accent1",Oe.lightStyle2Accent2="LightStyle2Accent2",Oe.lightStyle2Accent3="LightStyle2Accent3",Oe.lightStyle2Accent4="LightStyle2Accent4",Oe.lightStyle2Accent5="LightStyle2Accent5",Oe.lightStyle2Accent6="LightStyle2Accent6",Oe.lightStyle3="LightStyle3",Oe.lightStyle3Accent1="LightStyle3Accent1",Oe.lightStyle3Accent2="LightStyle3Accent2",Oe.lightStyle3Accent3="LightStyle3Accent3",Oe.lightStyle3Accent4="LightStyle3Accent4",Oe.lightStyle3Accent5="LightStyle3Accent5",Oe.lightStyle3Accent6="LightStyle3Accent6",Oe.mediumStyle1="MediumStyle1",Oe.mediumStyle1Accent1="MediumStyle1Accent1",Oe.mediumStyle1Accent2="MediumStyle1Accent2",Oe.mediumStyle1Accent3="MediumStyle1Accent3",Oe.mediumStyle1Accent4="MediumStyle1Accent4",Oe.mediumStyle1Accent5="MediumStyle1Accent5",Oe.mediumStyle1Accent6="MediumStyle1Accent6",Oe.mediumStyle2="MediumStyle2",Oe.mediumStyle2Accent1="MediumStyle2Accent1",Oe.mediumStyle2Accent2="MediumStyle2Accent2",Oe.mediumStyle2Accent3="MediumStyle2Accent3",Oe.mediumStyle2Accent4="MediumStyle2Accent4",Oe.mediumStyle2Accent5="MediumStyle2Accent5",Oe.mediumStyle2Accent6="MediumStyle2Accent6",Oe.mediumStyle3="MediumStyle3",Oe.mediumStyle3Accent1="MediumStyle3Accent1",Oe.mediumStyle3Accent2="MediumStyle3Accent2",Oe.mediumStyle3Accent3="MediumStyle3Accent3",Oe.mediumStyle3Accent4="MediumStyle3Accent4",Oe.mediumStyle3Accent5="MediumStyle3Accent5",Oe.mediumStyle3Accent6="MediumStyle3Accent6",Oe.mediumStyle4="MediumStyle4",Oe.mediumStyle4Accent1="MediumStyle4Accent1",Oe.mediumStyle4Accent2="MediumStyle4Accent2",Oe.mediumStyle4Accent3="MediumStyle4Accent3",Oe.mediumStyle4Accent4="MediumStyle4Accent4",Oe.mediumStyle4Accent5="MediumStyle4Accent5",Oe.mediumStyle4Accent6="MediumStyle4Accent6",Oe.darkStyle1="DarkStyle1",Oe.darkStyle1Accent1="DarkStyle1Accent1",Oe.darkStyle1Accent2="DarkStyle1Accent2",Oe.darkStyle1Accent3="DarkStyle1Accent3",Oe.darkStyle1Accent4="DarkStyle1Accent4",Oe.darkStyle1Accent5="DarkStyle1Accent5",Oe.darkStyle1Accent6="DarkStyle1Accent6",Oe.darkStyle2="DarkStyle2",Oe.darkStyle2Accent1="DarkStyle2Accent1",Oe.darkStyle2Accent2="DarkStyle2Accent2",Oe.darkStyle2Accent3="DarkStyle2Accent3";var Ae,Pe="Table",Ee=(Ae=OfficeExtension.ClientObject,__extends(Te,Ae),Object.defineProperty(Te.prototype,"_className",{get:function(){return"Table"},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"_scalarPropertyNames",{get:function(){return["columnCount","rowCount","values","styleOptions"]},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"_scalarPropertyOriginalNames",{get:function(){return["ColumnCount","RowCount","Values","StyleOptions"]},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!1,!1,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"_navigationPropertyNames",{get:function(){return["columns","rows","mergedAreas"]},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"columns",{get:function(){return this._Co||(this._Co=e(i.TableColumnCollection,this,"Columns",!0,4)),this._Co},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"mergedAreas",{get:function(){return this._M||(this._M=e(i.TableMergedAreaCollection,this,"MergedAreas",!0,4)),this._M},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"rows",{get:function(){return this._Ro||(this._Ro=e(i.TableRowCollection,this,"Rows",!0,4)),this._Ro},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"columnCount",{get:function(){return h("columnCount",this._C,Pe,this._isNull),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"rowCount",{get:function(){return h("rowCount",this._R,Pe,this._isNull),this._R},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"styleOptions",{get:function(){return h("styleOptions",this._S,Pe,this._isNull),this._S},set:function(e){this._S=e,p(this,"StyleOptions",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Te.prototype,"values",{get:function(){return h("values",this._V,Pe,this._isNull),this._V},enumerable:!0,configurable:!0}),Te.prototype.clear=function(e){l(this,"Clear",0,[e],0,0)},Te.prototype.getCellOrNullObject=function(e,t){return a(i.TableCell,this,"GetCellOrNullObject",1,[e,t],!1,!1,null,4)},Te.prototype.getShape=function(){return a(i.Shape,this,"GetShape",1,[],!1,!1,null,4)},Te.prototype._handleResult=function(e){if(Ae.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.ColumnCount)||(this._C=t.ColumnCount),d(t.RowCount)||(this._R=t.RowCount),d(t.StyleOptions)||(this._S=t.StyleOptions),d(t.Values)||(this._V=t.Values),_(this,t,["columns","Columns","mergedAreas","MergedAreas","rows","Rows"])}},Te.prototype.load=function(e){return m(this,e)},Te.prototype.retrieve=function(e){return y(this,e)},Te.prototype._handleRetrieveResult=function(e,t){Ae.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Te.prototype.toJSON=function(){return v(this,{},{})},Te.prototype.setMockData=function(e){C(this,e)},Te.prototype.ensureUnchanged=function(e){u(this,e)},Te);function Te(){return null!==Ae&&Ae.apply(this,arguments)||this}i.Table=Ee;var we,Ie,xe=(we=OfficeExtension.ClientObject,__extends(De,we),Object.defineProperty(De.prototype,"_className",{get:function(){return"ShapeCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(De.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(De.prototype,"items",{get:function(){return h("items",this.m__items,"ShapeCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),De.prototype.addGeometricShape=function(e,t){return g("ShapeCollection.addGeometricShape",o,"1.4",r),a(i.Shape,this,"AddGeometricShape",0,[e,t],!1,!1,null,0)},De.prototype.addGroup=function(e){return g("ShapeCollection.addGroup",o,"1.8",r),a(i.Shape,this,"AddGroup",0,[e],!1,!1,null,0)},De.prototype.addLine=function(e,t){return g("ShapeCollection.addLine",o,"1.4",r),a(i.Shape,this,"AddLine",0,[e,t],!1,!1,null,0)},De.prototype.addTable=function(e,t,n){return g("ShapeCollection.addTable","Experiment52","1.1",r),a(i.Shape,this,"AddTable",0,[e,t,n],!1,!1,null,0)},De.prototype.addTextBox=function(e,t){return g("ShapeCollection.addTextBox",o,"1.4",r),a(i.Shape,this,"AddTextBox",0,[e,t],!1,!1,null,0)},De.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},De.prototype.getItem=function(e){return t(i.Shape,this,[e])},De.prototype.getItemAt=function(e){return a(i.Shape,this,"GetItemAt",1,[e],!1,!1,null,4)},De.prototype.getItemOrNullObject=function(e){return a(i.Shape,this,"GetItemOrNullObject",0,[e],!1,!1,null,0)},De.prototype._handleResult=function(e){if(we.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.Shape,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},De.prototype.load=function(e){return m(this,e)},De.prototype.retrieve=function(e){return y(this,e)},De.prototype._handleRetrieveResult=function(e,t){var n=this;we.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.Shape,!0,n,e,t)})},De.prototype.toJSON=function(){return v(this,{},{},this.m__items)},De.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.Shape,!0,n,e,t)},function(e){return n.m__items=e})},De);function De(){return null!==we&&we.apply(this,arguments)||this}i.ShapeCollection=xe,(Ie=i.SlideLayoutType||(i.SlideLayoutType={})).blank="Blank",Ie.chart="Chart",Ie.chartAndText="ChartAndText",Ie.clipArtAndText="ClipArtAndText",Ie.clipArtAndVerticalText="ClipArtAndVerticalText",Ie.comparison="Comparison",Ie.contentWithCaption="ContentWithCaption",Ie.custom="Custom",Ie.fourObjects="FourObjects",Ie.largeObject="LargeObject",Ie.mediaClipAndText="MediaClipAndText",Ie.mixed="Mixed",Ie.object="Object",Ie.objectAndText="ObjectAndText",Ie.objectAndTwoObjects="ObjectAndTwoObjects",Ie.objectOverText="ObjectOverText",Ie.organizationChart="OrganizationChart",Ie.pictureWithCaption="PictureWithCaption",Ie.sectionHeader="SectionHeader",Ie.table="Table",Ie.text="Text",Ie.textAndChart="TextAndChart",Ie.textAndClipArt="TextAndClipArt",Ie.textAndMediaClip="TextAndMediaClip",Ie.textAndObject="TextAndObject",Ie.textAndTwoObjects="TextAndTwoObjects",Ie.textOverObject="TextOverObject",Ie.title="Title",Ie.titleOnly="TitleOnly",Ie.twoColumnText="TwoColumnText",Ie.twoObjects="TwoObjects",Ie.twoObjectsAndObject="TwoObjectsAndObject",Ie.twoObjectsAndText="TwoObjectsAndText",Ie.twoObjectsOverText="TwoObjectsOverText",Ie.verticalText="VerticalText",Ie.verticalTitleAndText="VerticalTitleAndText",Ie.verticalTitleAndTextOverChart="VerticalTitleAndTextOverChart";var Fe,Re="SlideLayout",Ne=(Fe=OfficeExtension.ClientObject,__extends(Me,Fe),Object.defineProperty(Me.prototype,"_className",{get:function(){return"SlideLayout"},enumerable:!0,configurable:!0}),Object.defineProperty(Me.prototype,"_scalarPropertyNames",{get:function(){return["id","name","type"]},enumerable:!0,configurable:!0}),Object.defineProperty(Me.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Name","Type"]},enumerable:!0,configurable:!0}),Object.defineProperty(Me.prototype,"_navigationPropertyNames",{get:function(){return["shapes","customXmlParts"]},enumerable:!0,configurable:!0}),Object.defineProperty(Me.prototype,"customXmlParts",{get:function(){return g("SlideLayout.customXmlParts",o,"1.7",r),this._C||(this._C=e(i.CustomXmlPartCollection,this,"CustomXmlParts",!0,4)),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(Me.prototype,"shapes",{get:function(){return this._S||(this._S=e(i.ShapeCollection,this,"Shapes",!0,4)),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(Me.prototype,"id",{get:function(){return h("id",this._I,Re,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(Me.prototype,"name",{get:function(){return h("name",this._N,Re,this._isNull),this._N},enumerable:!0,configurable:!0}),Object.defineProperty(Me.prototype,"type",{get:function(){return h("type",this._T,Re,this._isNull),g("SlideLayout.type",o,"1.8",r),this._T},enumerable:!0,configurable:!0}),Me.prototype._handleResult=function(e){if(Fe.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Id)||(this._I=t.Id),d(t.Name)||(this._N=t.Name),d(t.Type)||(this._T=t.Type),_(this,t,["customXmlParts","CustomXmlParts","shapes","Shapes"])}},Me.prototype.load=function(e){return m(this,e)},Me.prototype.retrieve=function(e){return y(this,e)},Me.prototype._handleIdResult=function(e){Fe.prototype._handleIdResult.call(this,e),f(e)||d(e.Id)||(this._I=e.Id)},Me.prototype._handleRetrieveResult=function(e,t){Fe.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Me.prototype.toJSON=function(){return v(this,{},{})},Me.prototype.setMockData=function(e){C(this,e)},Me.prototype.ensureUnchanged=function(e){u(this,e)},Me);function Me(){return null!==Fe&&Fe.apply(this,arguments)||this}i.SlideLayout=Ne;var je,ke=(je=OfficeExtension.ClientObject,__extends(He,je),Object.defineProperty(He.prototype,"_className",{get:function(){return"SlideLayoutCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(He.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(He.prototype,"items",{get:function(){return h("items",this.m__items,"SlideLayoutCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),He.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},He.prototype.getItem=function(e){return t(i.SlideLayout,this,[e])},He.prototype.getItemAt=function(e){return a(i.SlideLayout,this,"GetItemAt",1,[e],!1,!1,null,4)},He.prototype.getItemOrNullObject=function(e){return a(i.SlideLayout,this,"GetItemOrNullObject",0,[e],!1,!1,null,0)},He.prototype._handleResult=function(e){if(je.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.SlideLayout,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},He.prototype.load=function(e){return m(this,e)},He.prototype.retrieve=function(e){return y(this,e)},He.prototype._handleRetrieveResult=function(e,t){var n=this;je.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.SlideLayout,!0,n,e,t)})},He.prototype.toJSON=function(){return v(this,{},{},this.m__items)},He.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.SlideLayout,!0,n,e,t)},function(e){return n.m__items=e})},He);function He(){return null!==je&&je.apply(this,arguments)||this}i.SlideLayoutCollection=ke;var Ue,Le="SlideMaster",Be=(Ue=OfficeExtension.ClientObject,__extends(We,Ue),Object.defineProperty(We.prototype,"_className",{get:function(){return"SlideMaster"},enumerable:!0,configurable:!0}),Object.defineProperty(We.prototype,"_scalarPropertyNames",{get:function(){return["id","name"]},enumerable:!0,configurable:!0}),Object.defineProperty(We.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Name"]},enumerable:!0,configurable:!0}),Object.defineProperty(We.prototype,"_navigationPropertyNames",{get:function(){return["layouts","shapes","customXmlParts"]},enumerable:!0,configurable:!0}),Object.defineProperty(We.prototype,"customXmlParts",{get:function(){return g("SlideMaster.customXmlParts",o,"1.7",r),this._C||(this._C=e(i.CustomXmlPartCollection,this,"CustomXmlParts",!0,4)),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(We.prototype,"layouts",{get:function(){return this._L||(this._L=e(i.SlideLayoutCollection,this,"Layouts",!0,4)),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(We.prototype,"shapes",{get:function(){return this._S||(this._S=e(i.ShapeCollection,this,"Shapes",!0,4)),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(We.prototype,"id",{get:function(){return h("id",this._I,Le,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(We.prototype,"name",{get:function(){return h("name",this._N,Le,this._isNull),this._N},enumerable:!0,configurable:!0}),We.prototype._handleResult=function(e){if(Ue.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Id)||(this._I=t.Id),d(t.Name)||(this._N=t.Name),_(this,t,["customXmlParts","CustomXmlParts","layouts","Layouts","shapes","Shapes"])}},We.prototype.load=function(e){return m(this,e)},We.prototype.retrieve=function(e){return y(this,e)},We.prototype._handleIdResult=function(e){Ue.prototype._handleIdResult.call(this,e),f(e)||d(e.Id)||(this._I=e.Id)},We.prototype._handleRetrieveResult=function(e,t){Ue.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},We.prototype.toJSON=function(){return v(this,{},{})},We.prototype.setMockData=function(e){C(this,e)},We.prototype.ensureUnchanged=function(e){u(this,e)},We);function We(){return null!==Ue&&Ue.apply(this,arguments)||this}i.SlideMaster=Be;var qe,Ve=(qe=OfficeExtension.ClientObject,__extends(Ge,qe),Object.defineProperty(Ge.prototype,"_className",{get:function(){return"Tag"},enumerable:!0,configurable:!0}),Object.defineProperty(Ge.prototype,"_scalarPropertyNames",{get:function(){return["key","value"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ge.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Key","Value"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ge.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(Ge.prototype,"key",{get:function(){return h("key",this._K,"Tag",this._isNull),this._K},enumerable:!0,configurable:!0}),Object.defineProperty(Ge.prototype,"value",{get:function(){return h("value",this._V,"Tag",this._isNull),this._V},set:function(e){this._V=e,p(this,"Value",e,0)},enumerable:!0,configurable:!0}),Ge.prototype._handleResult=function(e){if(qe.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Key)||(this._K=t.Key),d(t.Value)||(this._V=t.Value)}},Ge.prototype.load=function(e){return m(this,e)},Ge.prototype.retrieve=function(e){return y(this,e)},Ge.prototype._handleRetrieveResult=function(e,t){qe.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Ge.prototype.toJSON=function(){return v(this,{},{})},Ge.prototype.setMockData=function(e){C(this,e)},Ge.prototype.ensureUnchanged=function(e){u(this,e)},Ge);function Ge(){return null!==qe&&qe.apply(this,arguments)||this}i.Tag=Ve;var Je,ze=(Je=OfficeExtension.ClientObject,__extends(Ke,Je),Object.defineProperty(Ke.prototype,"_className",{get:function(){return"TagCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(Ke.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(Ke.prototype,"items",{get:function(){return h("items",this.m__items,"TagCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),Ke.prototype.add=function(e,t){l(this,"Add",0,[e,t],0,0)},Ke.prototype.delete=function(e){l(this,"Delete",0,[e],0,0)},Ke.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},Ke.prototype.getItem=function(e){return t(i.Tag,this,[e])},Ke.prototype.getItemAt=function(e){return a(i.Tag,this,"GetItemAt",1,[e],!1,!1,null,4)},Ke.prototype.getItemOrNullObject=function(e){return a(i.Tag,this,"GetItemOrNullObject",0,[e],!1,!1,null,0)},Ke.prototype._handleResult=function(e){if(Je.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.Tag,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},Ke.prototype.load=function(e){return m(this,e)},Ke.prototype.retrieve=function(e){return y(this,e)},Ke.prototype._handleRetrieveResult=function(e,t){var n=this;Je.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.Tag,!0,n,e,t)})},Ke.prototype.toJSON=function(){return v(this,{},{},this.m__items)},Ke.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.Tag,!0,n,e,t)},function(e){return n.m__items=e})},Ke);function Ke(){return null!==Je&&Je.apply(this,arguments)||this}i.TagCollection=ze;var Xe,Qe,$e=(Xe=OfficeExtension.ClientObject,__extends(Ze,Xe),Object.defineProperty(Ze.prototype,"_className",{get:function(){return"Slide"},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"_scalarPropertyNames",{get:function(){return["id","index"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Index"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"_navigationPropertyNames",{get:function(){return["shapes","layout","slideMaster","tags","hyperlinks","customXmlParts"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"customXmlParts",{get:function(){return g("Slide.customXmlParts",o,"1.7",r),this._C||(this._C=e(i.CustomXmlPartCollection,this,"CustomXmlParts",!0,4)),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"hyperlinks",{get:function(){return g("Slide.hyperlinks",o,"1.6",r),this._H||(this._H=e(i.HyperlinkCollection,this,"Hyperlinks",!0,4)),this._H},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"layout",{get:function(){return g("Slide.layout",o,"1.3",r),this._L||(this._L=e(i.SlideLayout,this,"Layout",!1,4)),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"shapes",{get:function(){return g("Slide.shapes",o,"1.3",r),this._S||(this._S=e(i.ShapeCollection,this,"Shapes",!0,4)),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"slideMaster",{get:function(){return g("Slide.slideMaster",o,"1.3",r),this._Sl||(this._Sl=e(i.SlideMaster,this,"SlideMaster",!1,4)),this._Sl},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"tags",{get:function(){return g("Slide.tags",o,"1.3",r),this._T||(this._T=e(i.TagCollection,this,"Tags",!0,4)),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"id",{get:function(){return h("id",this._I,"Slide",this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(Ze.prototype,"index",{get:function(){return h("index",this._In,"Slide",this._isNull),g("Slide.index",o,"1.8",r),this._In},enumerable:!0,configurable:!0}),Ze.prototype.applyLayout=function(e){g("Slide.applyLayout",o,"1.8",r),l(this,"ApplyLayout",0,[e],0,0)},Ze.prototype.delete=function(){l(this,"Delete",0,[],0,0)},Ze.prototype.exportAsBase64=function(){return g("Slide.exportAsBase64",o,"1.8",r),l(this,"ExportAsBase64",1,[],4,0)},Ze.prototype.getImageAsBase64=function(e){return g("Slide.getImageAsBase64",o,"1.8",r),l(this,"GetImageAsBase64",1,[e],4,0)},Ze.prototype.moveTo=function(e){g("Slide.moveTo",o,"1.8",r),l(this,"MoveTo",0,[e],0,0)},Ze.prototype.setSelectedShapes=function(e){g("Slide.setSelectedShapes",o,"1.5",r),l(this,"SetSelectedShapes",0,[e],0,0)},Ze.prototype._handleResult=function(e){if(Xe.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Id)||(this._I=t.Id),d(t.Index)||(this._In=t.Index),_(this,t,["customXmlParts","CustomXmlParts","hyperlinks","Hyperlinks","layout","Layout","shapes","Shapes","slideMaster","SlideMaster","tags","Tags"])}},Ze.prototype.load=function(e){return m(this,e)},Ze.prototype.retrieve=function(e){return y(this,e)},Ze.prototype._handleIdResult=function(e){Xe.prototype._handleIdResult.call(this,e),f(e)||d(e.Id)||(this._I=e.Id)},Ze.prototype._handleRetrieveResult=function(e,t){Xe.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Ze.prototype.toJSON=function(){return v(this,{},{})},Ze.prototype.setMockData=function(e){C(this,e)},Ze.prototype.ensureUnchanged=function(e){u(this,e)},Ze);function Ze(){return null!==Xe&&Xe.apply(this,arguments)||this}i.Slide=$e,(Qe=i.ShapeFillType||(i.ShapeFillType={})).noFill="NoFill",Qe.solid="Solid",Qe.gradient="Gradient",Qe.pattern="Pattern",Qe.pictureAndTexture="PictureAndTexture",Qe.slideBackground="SlideBackground";var Ye,et="ShapeFill",tt=(Ye=OfficeExtension.ClientObject,__extends(nt,Ye),Object.defineProperty(nt.prototype,"_className",{get:function(){return"ShapeFill"},enumerable:!0,configurable:!0}),Object.defineProperty(nt.prototype,"_scalarPropertyNames",{get:function(){return["foregroundColor","transparency","type"]},enumerable:!0,configurable:!0}),Object.defineProperty(nt.prototype,"_scalarPropertyOriginalNames",{get:function(){return["ForegroundColor","Transparency","Type"]},enumerable:!0,configurable:!0}),Object.defineProperty(nt.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(nt.prototype,"foregroundColor",{get:function(){return h("foregroundColor",this._F,et,this._isNull),this._F},set:function(e){this._F=e,p(this,"ForegroundColor",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(nt.prototype,"transparency",{get:function(){return h("transparency",this._T,et,this._isNull),this._T},set:function(e){this._T=e,p(this,"Transparency",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(nt.prototype,"type",{get:function(){return h("type",this._Ty,et,this._isNull),this._Ty},enumerable:!0,configurable:!0}),nt.prototype.clear=function(){l(this,"Clear",0,[],0,0)},nt.prototype.setImage=function(e){g("ShapeFill.setImage","Experiment52","1.1",r),l(this,"SetImage",0,[e],0,0)},nt.prototype.setSolidColor=function(e){l(this,"SetSolidColor",0,[e],0,0)},nt.prototype._handleResult=function(e){if(Ye.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.ForegroundColor)||(this._F=t.ForegroundColor),d(t.Transparency)||(this._T=t.Transparency),d(t.Type)||(this._Ty=t.Type)}},nt.prototype.load=function(e){return m(this,e)},nt.prototype.retrieve=function(e){return y(this,e)},nt.prototype._handleRetrieveResult=function(e,t){Ye.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},nt.prototype.toJSON=function(){return v(this,{},{})},nt.prototype.setMockData=function(e){C(this,e)},nt.prototype.ensureUnchanged=function(e){u(this,e)},nt);function nt(){return null!==Ye&&Ye.apply(this,arguments)||this}i.ShapeFill=tt;var rt,ot=(rt=OfficeExtension.ClientObject,__extends(it,rt),Object.defineProperty(it.prototype,"_className",{get:function(){return"ShapeScopedCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(it.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(it.prototype,"items",{get:function(){return h("items",this.m__items,"ShapeScopedCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),it.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},it.prototype.getItem=function(e){return t(i.Shape,this,[e])},it.prototype.getItemAt=function(e){return a(i.Shape,this,"GetItemAt",1,[e],!1,!1,null,4)},it.prototype.getItemOrNullObject=function(e){return a(i.Shape,this,"GetItemOrNullObject",0,[e],!1,!1,null,0)},it.prototype.group=function(){return g("ShapeScopedCollection.group",o,"1.8",r),a(i.Shape,this,"Group",0,[],!1,!1,null,0)},it.prototype._handleResult=function(e){if(rt.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.Shape,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},it.prototype.load=function(e){return m(this,e)},it.prototype.retrieve=function(e){return y(this,e)},it.prototype._handleRetrieveResult=function(e,t){var n=this;rt.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.Shape,!0,n,e,t)})},it.prototype.toJSON=function(){return v(this,{},{},this.m__items)},it.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.Shape,!0,n,e,t)},function(e){return n.m__items=e})},it);function it(){return null!==rt&&rt.apply(this,arguments)||this}i.ShapeScopedCollection=ot;var at,st,ct=(at=OfficeExtension.ClientObject,__extends(lt,at),Object.defineProperty(lt.prototype,"_className",{get:function(){return"ShapeGroup"},enumerable:!0,configurable:!0}),Object.defineProperty(lt.prototype,"_scalarPropertyNames",{get:function(){return["id"]},enumerable:!0,configurable:!0}),Object.defineProperty(lt.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id"]},enumerable:!0,configurable:!0}),Object.defineProperty(lt.prototype,"_navigationPropertyNames",{get:function(){return["shape","shapes"]},enumerable:!0,configurable:!0}),Object.defineProperty(lt.prototype,"shape",{get:function(){return this._S||(this._S=e(i.Shape,this,"Shape",!1,4)),this._S},enumerable:!0,configurable:!0}),Object.defineProperty(lt.prototype,"shapes",{get:function(){return this._Sh||(this._Sh=e(i.ShapeScopedCollection,this,"Shapes",!0,4)),this._Sh},enumerable:!0,configurable:!0}),Object.defineProperty(lt.prototype,"id",{get:function(){return h("id",this._I,"ShapeGroup",this._isNull),this._I},enumerable:!0,configurable:!0}),lt.prototype.ungroup=function(){l(this,"Ungroup",0,[],0,0)},lt.prototype._handleResult=function(e){if(at.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Id)||(this._I=t.Id),_(this,t,["shape","Shape","shapes","Shapes"])}},lt.prototype.load=function(e){return m(this,e)},lt.prototype.retrieve=function(e){return y(this,e)},lt.prototype._handleIdResult=function(e){at.prototype._handleIdResult.call(this,e),f(e)||d(e.Id)||(this._I=e.Id)},lt.prototype._handleRetrieveResult=function(e,t){at.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},lt.prototype.toJSON=function(){return v(this,{},{})},lt.prototype.setMockData=function(e){C(this,e)},lt.prototype.ensureUnchanged=function(e){u(this,e)},lt);function lt(){return null!==at&&at.apply(this,arguments)||this}i.ShapeGroup=ct,(st=i.ShapeLineStyle||(i.ShapeLineStyle={})).single="Single",st.thickBetweenThin="ThickBetweenThin",st.thickThin="ThickThin",st.thinThick="ThinThick",st.thinThin="ThinThin";var ut,pt,ft,dt="ShapeLineFormat",ht=(ut=OfficeExtension.ClientObject,__extends(gt,ut),Object.defineProperty(gt.prototype,"_className",{get:function(){return"ShapeLineFormat"},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"_scalarPropertyNames",{get:function(){return["color","dashStyle","style","transparency","visible","weight"]},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Color","DashStyle","Style","Transparency","Visible","Weight"]},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0,!0,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"color",{get:function(){return h("color",this._C,dt,this._isNull),this._C},set:function(e){this._C=e,p(this,"Color",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"dashStyle",{get:function(){return h("dashStyle",this._D,dt,this._isNull),this._D},set:function(e){this._D=e,p(this,"DashStyle",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"style",{get:function(){return h("style",this._S,dt,this._isNull),this._S},set:function(e){this._S=e,p(this,"Style",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"transparency",{get:function(){return h("transparency",this._T,dt,this._isNull),this._T},set:function(e){this._T=e,p(this,"Transparency",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"visible",{get:function(){return h("visible",this._V,dt,this._isNull),this._V},set:function(e){this._V=e,p(this,"Visible",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(gt.prototype,"weight",{get:function(){return h("weight",this._W,dt,this._isNull),this._W},set:function(e){this._W=e,p(this,"Weight",e,0)},enumerable:!0,configurable:!0}),gt.prototype._handleResult=function(e){if(ut.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Color)||(this._C=t.Color),d(t.DashStyle)||(this._D=t.DashStyle),d(t.Style)||(this._S=t.Style),d(t.Transparency)||(this._T=t.Transparency),d(t.Visible)||(this._V=t.Visible),d(t.Weight)||(this._W=t.Weight)}},gt.prototype.load=function(e){return m(this,e)},gt.prototype.retrieve=function(e){return y(this,e)},gt.prototype._handleRetrieveResult=function(e,t){ut.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},gt.prototype.toJSON=function(){return v(this,{},{})},gt.prototype.setMockData=function(e){C(this,e)},gt.prototype.ensureUnchanged=function(e){u(this,e)},gt);function gt(){return null!==ut&&ut.apply(this,arguments)||this}i.ShapeLineFormat=ht,(pt=i.ShapeType||(i.ShapeType={})).unsupported="Unsupported",pt.image="Image",pt.geometricShape="GeometricShape",pt.group="Group",pt.line="Line",pt.table="Table",pt.callout="Callout",pt.chart="Chart",pt.contentApp="ContentApp",pt.diagram="Diagram",pt.freeform="Freeform",pt.graphic="Graphic",pt.ink="Ink",pt.media="Media",pt.model3D="Model3D",pt.ole="Ole",pt.placeholder="Placeholder",pt.smartArt="SmartArt",pt.textBox="TextBox",(ft=i.ShapeAutoSize||(i.ShapeAutoSize={})).autoSizeNone="AutoSizeNone",ft.autoSizeTextToFitShape="AutoSizeTextToFitShape",ft.autoSizeShapeToFitText="AutoSizeShapeToFitText",ft.autoSizeMixed="AutoSizeMixed";var mt,yt=(mt=OfficeExtension.ClientObject,__extends(vt,mt),Object.defineProperty(vt.prototype,"_className",{get:function(){return"BulletFormat"},enumerable:!0,configurable:!0}),Object.defineProperty(vt.prototype,"_scalarPropertyNames",{get:function(){return["visible"]},enumerable:!0,configurable:!0}),Object.defineProperty(vt.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Visible"]},enumerable:!0,configurable:!0}),Object.defineProperty(vt.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0]},enumerable:!0,configurable:!0}),Object.defineProperty(vt.prototype,"visible",{get:function(){return h("visible",this._V,"BulletFormat",this._isNull),this._V},set:function(e){this._V=e,p(this,"Visible",e,0)},enumerable:!0,configurable:!0}),vt.prototype._handleResult=function(e){if(mt.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Visible)||(this._V=t.Visible)}},vt.prototype.load=function(e){return m(this,e)},vt.prototype.retrieve=function(e){return y(this,e)},vt.prototype._handleRetrieveResult=function(e,t){mt.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},vt.prototype.toJSON=function(){return v(this,{},{})},vt.prototype.setMockData=function(e){C(this,e)},vt.prototype.ensureUnchanged=function(e){u(this,e)},vt);function vt(){return null!==mt&&mt.apply(this,arguments)||this}i.BulletFormat=yt;var bt,_t=(bt=OfficeExtension.ClientObject,__extends(Ot,bt),Object.defineProperty(Ot.prototype,"_className",{get:function(){return"ParagraphFormat"},enumerable:!0,configurable:!0}),Object.defineProperty(Ot.prototype,"_scalarPropertyNames",{get:function(){return["horizontalAlignment"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ot.prototype,"_scalarPropertyOriginalNames",{get:function(){return["HorizontalAlignment"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ot.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0]},enumerable:!0,configurable:!0}),Object.defineProperty(Ot.prototype,"_navigationPropertyNames",{get:function(){return["bulletFormat"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ot.prototype,"bulletFormat",{get:function(){return this._B||(this._B=e(i.BulletFormat,this,"BulletFormat",!1,4)),this._B},enumerable:!0,configurable:!0}),Object.defineProperty(Ot.prototype,"horizontalAlignment",{get:function(){return h("horizontalAlignment",this._H,"ParagraphFormat",this._isNull),this._H},set:function(e){this._H=e,p(this,"HorizontalAlignment",e,0)},enumerable:!0,configurable:!0}),Ot.prototype._handleResult=function(e){if(bt.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.HorizontalAlignment)||(this._H=t.HorizontalAlignment),_(this,t,["bulletFormat","BulletFormat"])}},Ot.prototype.load=function(e){return m(this,e)},Ot.prototype.retrieve=function(e){return y(this,e)},Ot.prototype._handleRetrieveResult=function(e,t){bt.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Ot.prototype.toJSON=function(){return v(this,{},{})},Ot.prototype.setMockData=function(e){C(this,e)},Ot.prototype.ensureUnchanged=function(e){u(this,e)},Ot);function Ot(){return null!==bt&&bt.apply(this,arguments)||this}i.ParagraphFormat=_t;var St,Ct="ShapeFont",At=(St=OfficeExtension.ClientObject,__extends(Pt,St),Object.defineProperty(Pt.prototype,"_className",{get:function(){return"ShapeFont"},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"_scalarPropertyNames",{get:function(){return["bold","color","italic","name","size","underline","allCaps","doubleStrikethrough","smallCaps","strikethrough","subscript","superscript"]},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Bold","Color","Italic","Name","Size","Underline","AllCaps","DoubleStrikethrough","SmallCaps","Strikethrough","Subscript","Superscript"]},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0,!0,!0,!0,!0,!0,!0,!0,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"allCaps",{get:function(){return h("allCaps",this._A,Ct,this._isNull),g("ShapeFont.allCaps",o,"99.9",r),this._A},set:function(e){this._A=e,p(this,"AllCaps",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"bold",{get:function(){return h("bold",this._B,Ct,this._isNull),this._B},set:function(e){this._B=e,p(this,"Bold",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"color",{get:function(){return h("color",this._C,Ct,this._isNull),this._C},set:function(e){this._C=e,p(this,"Color",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"doubleStrikethrough",{get:function(){return h("doubleStrikethrough",this._D,Ct,this._isNull),g("ShapeFont.doubleStrikethrough",o,"99.9",r),this._D},set:function(e){this._D=e,p(this,"DoubleStrikethrough",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"italic",{get:function(){return h("italic",this._I,Ct,this._isNull),this._I},set:function(e){this._I=e,p(this,"Italic",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"name",{get:function(){return h("name",this._N,Ct,this._isNull),this._N},set:function(e){this._N=e,p(this,"Name",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"size",{get:function(){return h("size",this._S,Ct,this._isNull),this._S},set:function(e){this._S=e,p(this,"Size",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"smallCaps",{get:function(){return h("smallCaps",this._Sm,Ct,this._isNull),g("ShapeFont.smallCaps",o,"99.9",r),this._Sm},set:function(e){this._Sm=e,p(this,"SmallCaps",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"strikethrough",{get:function(){return h("strikethrough",this._St,Ct,this._isNull),g("ShapeFont.strikethrough",o,"99.9",r),this._St},set:function(e){this._St=e,p(this,"Strikethrough",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"subscript",{get:function(){return h("subscript",this._Su,Ct,this._isNull),g("ShapeFont.subscript",o,"99.9",r),this._Su},set:function(e){this._Su=e,p(this,"Subscript",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"superscript",{get:function(){return h("superscript",this._Sup,Ct,this._isNull),g("ShapeFont.superscript",o,"99.9",r),this._Sup},set:function(e){this._Sup=e,p(this,"Superscript",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Pt.prototype,"underline",{get:function(){return h("underline",this._U,Ct,this._isNull),this._U},set:function(e){this._U=e,p(this,"Underline",e,0)},enumerable:!0,configurable:!0}),Pt.prototype._handleResult=function(e){if(St.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.AllCaps)||(this._A=t.AllCaps),d(t.Bold)||(this._B=t.Bold),d(t.Color)||(this._C=t.Color),d(t.DoubleStrikethrough)||(this._D=t.DoubleStrikethrough),d(t.Italic)||(this._I=t.Italic),d(t.Name)||(this._N=t.Name),d(t.Size)||(this._S=t.Size),d(t.SmallCaps)||(this._Sm=t.SmallCaps),d(t.Strikethrough)||(this._St=t.Strikethrough),d(t.Subscript)||(this._Su=t.Subscript),d(t.Superscript)||(this._Sup=t.Superscript),d(t.Underline)||(this._U=t.Underline)}},Pt.prototype.load=function(e){return m(this,e)},Pt.prototype.retrieve=function(e){return y(this,e)},Pt.prototype._handleRetrieveResult=function(e,t){St.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Pt.prototype.toJSON=function(){return v(this,{},{})},Pt.prototype.setMockData=function(e){C(this,e)},Pt.prototype.ensureUnchanged=function(e){u(this,e)},Pt);function Pt(){return null!==St&&St.apply(this,arguments)||this}i.ShapeFont=At;var Et,Tt="TextRange",wt=(Et=OfficeExtension.ClientObject,__extends(It,Et),Object.defineProperty(It.prototype,"_className",{get:function(){return"TextRange"},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"_scalarPropertyNames",{get:function(){return["text","length","start"]},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Text","Length","Start"]},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"_navigationPropertyNames",{get:function(){return["font","paragraphFormat"]},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"font",{get:function(){return this._F||(this._F=e(i.ShapeFont,this,"Font",!1,4)),this._F},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"paragraphFormat",{get:function(){return this._P||(this._P=e(i.ParagraphFormat,this,"ParagraphFormat",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"length",{get:function(){return h("length",this._L,Tt,this._isNull),g("TextRange.length",o,"1.5",r),this._L},set:function(e){this._L=e,p(this,"Length",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"start",{get:function(){return h("start",this._S,Tt,this._isNull),g("TextRange.start",o,"1.5",r),this._S},set:function(e){this._S=e,p(this,"Start",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(It.prototype,"text",{get:function(){return h("text",this._T,Tt,this._isNull),this._T},set:function(e){this._T=e,p(this,"Text",e,0)},enumerable:!0,configurable:!0}),It.prototype.getParentTextFrame=function(){return g("TextRange.getParentTextFrame",o,"1.5",r),a(i.TextFrame,this,"GetParentTextFrame",0,[],!1,!1,null,0)},It.prototype.getSubstring=function(e,t){return a(i.TextRange,this,"GetSubstring",0,[e,t],!1,!1,null,0)},It.prototype.setSelected=function(){g("TextRange.setSelected",o,"1.5",r),l(this,"SetSelected",0,[],0,0)},It.prototype._handleResult=function(e){if(Et.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Length)||(this._L=t.Length),d(t.Start)||(this._S=t.Start),d(t.Text)||(this._T=t.Text),_(this,t,["font","Font","paragraphFormat","ParagraphFormat"])}},It.prototype.load=function(e){return m(this,e)},It.prototype.retrieve=function(e){return y(this,e)},It.prototype._handleRetrieveResult=function(e,t){Et.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},It.prototype.toJSON=function(){return v(this,{},{})},It.prototype.setMockData=function(e){C(this,e)},It.prototype.ensureUnchanged=function(e){u(this,e)},It);function It(){return null!==Et&&Et.apply(this,arguments)||this}i.TextRange=wt;var xt,Dt,Ft="TextFrame",Rt=(xt=OfficeExtension.ClientObject,__extends(Nt,xt),Object.defineProperty(Nt.prototype,"_className",{get:function(){return"TextFrame"},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"_scalarPropertyNames",{get:function(){return["autoSizeSetting","bottomMargin","hasText","leftMargin","rightMargin","topMargin","verticalAlignment","wordWrap"]},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"_scalarPropertyOriginalNames",{get:function(){return["AutoSizeSetting","BottomMargin","HasText","LeftMargin","RightMargin","TopMargin","VerticalAlignment","WordWrap"]},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!1,!0,!0,!0,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"_navigationPropertyNames",{get:function(){return["textRange"]},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"textRange",{get:function(){return this._T||(this._T=e(i.TextRange,this,"TextRange",!1,4)),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"autoSizeSetting",{get:function(){return h("autoSizeSetting",this._A,Ft,this._isNull),this._A},set:function(e){this._A=e,p(this,"AutoSizeSetting",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"bottomMargin",{get:function(){return h("bottomMargin",this._B,Ft,this._isNull),this._B},set:function(e){this._B=e,p(this,"BottomMargin",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"hasText",{get:function(){return h("hasText",this._H,Ft,this._isNull),this._H},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"leftMargin",{get:function(){return h("leftMargin",this._L,Ft,this._isNull),this._L},set:function(e){this._L=e,p(this,"LeftMargin",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"rightMargin",{get:function(){return h("rightMargin",this._R,Ft,this._isNull),this._R},set:function(e){this._R=e,p(this,"RightMargin",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"topMargin",{get:function(){return h("topMargin",this._To,Ft,this._isNull),this._To},set:function(e){this._To=e,p(this,"TopMargin",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"verticalAlignment",{get:function(){return h("verticalAlignment",this._V,Ft,this._isNull),this._V},set:function(e){this._V=e,p(this,"VerticalAlignment",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Nt.prototype,"wordWrap",{get:function(){return h("wordWrap",this._W,Ft,this._isNull),this._W},set:function(e){this._W=e,p(this,"WordWrap",e,0)},enumerable:!0,configurable:!0}),Nt.prototype.deleteText=function(){l(this,"DeleteText",0,[],0,0)},Nt.prototype.getParentShape=function(){return g("TextFrame.getParentShape",o,"1.5",r),a(i.Shape,this,"GetParentShape",0,[],!1,!1,null,0)},Nt.prototype._handleResult=function(e){if(xt.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.AutoSizeSetting)||(this._A=t.AutoSizeSetting),d(t.BottomMargin)||(this._B=t.BottomMargin),d(t.HasText)||(this._H=t.HasText),d(t.LeftMargin)||(this._L=t.LeftMargin),d(t.RightMargin)||(this._R=t.RightMargin),d(t.TopMargin)||(this._To=t.TopMargin),d(t.VerticalAlignment)||(this._V=t.VerticalAlignment),d(t.WordWrap)||(this._W=t.WordWrap),_(this,t,["textRange","TextRange"])}},Nt.prototype.load=function(e){return m(this,e)},Nt.prototype.retrieve=function(e){return y(this,e)},Nt.prototype._handleRetrieveResult=function(e,t){xt.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Nt.prototype.toJSON=function(){return v(this,{},{})},Nt.prototype.setMockData=function(e){C(this,e)},Nt.prototype.ensureUnchanged=function(e){u(this,e)},Nt);function Nt(){return null!==xt&&xt.apply(this,arguments)||this}i.TextFrame=Rt,(Dt=i.ShapeZOrder||(i.ShapeZOrder={})).bringForward="BringForward",Dt.bringToFront="BringToFront",Dt.sendBackward="SendBackward",Dt.sendToBack="SendToBack";var Mt,jt="Shape",kt=(Mt=OfficeExtension.ClientObject,__extends(Ht,Mt),Object.defineProperty(Ht.prototype,"_className",{get:function(){return"Shape"},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"_scalarPropertyNames",{get:function(){return["id","height","left","name","top","type","width","zorderPosition","level"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Height","Left","Name","Top","Type","Width","ZOrderPosition","Level"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!0,!0,!0,!0,!1,!0,!1,!1]},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"_navigationPropertyNames",{get:function(){return["tags","fill","lineFormat","textFrame","customXmlParts","group","parentGroup"]},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"customXmlParts",{get:function(){return g("Shape.customXmlParts",o,"1.7",r),this._C||(this._C=e(i.CustomXmlPartCollection,this,"CustomXmlParts",!0,4)),this._C},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"fill",{get:function(){return g("Shape.fill",o,"1.4",r),this._F||(this._F=e(i.ShapeFill,this,"Fill",!1,4)),this._F},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"group",{get:function(){return g("Shape.group",o,"1.8",r),this._G||(this._G=e(i.ShapeGroup,this,"Group",!1,4)),this._G},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"lineFormat",{get:function(){return g("Shape.lineFormat",o,"1.4",r),this._Li||(this._Li=e(i.ShapeLineFormat,this,"LineFormat",!1,4)),this._Li},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"parentGroup",{get:function(){return g("Shape.parentGroup",o,"1.8",r),this._P||(this._P=e(i.Shape,this,"ParentGroup",!1,4)),this._P},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"tags",{get:function(){return this._T||(this._T=e(i.TagCollection,this,"Tags",!0,4)),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"textFrame",{get:function(){return g("Shape.textFrame",o,"1.4",r),this._Te||(this._Te=e(i.TextFrame,this,"TextFrame",!1,4)),this._Te},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"height",{get:function(){return h("height",this._H,jt,this._isNull),g("Shape.height",o,"1.4",r),this._H},set:function(e){this._H=e,p(this,"Height",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"id",{get:function(){return h("id",this._I,jt,this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"left",{get:function(){return h("left",this._L,jt,this._isNull),g("Shape.left",o,"1.4",r),this._L},set:function(e){this._L=e,p(this,"Left",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"level",{get:function(){return h("level",this._Le,jt,this._isNull),g("Shape.level",o,"1.8",r),this._Le},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"name",{get:function(){return h("name",this._N,jt,this._isNull),g("Shape.name",o,"1.4",r),this._N},set:function(e){this._N=e,p(this,"Name",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"top",{get:function(){return h("top",this._To,jt,this._isNull),g("Shape.top",o,"1.4",r),this._To},set:function(e){this._To=e,p(this,"Top",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"type",{get:function(){return h("type",this._Ty,jt,this._isNull),g("Shape.type",o,"1.4",r),this._Ty},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"width",{get:function(){return h("width",this._W,jt,this._isNull),g("Shape.width",o,"1.4",r),this._W},set:function(e){this._W=e,p(this,"Width",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(Ht.prototype,"zorderPosition",{get:function(){return h("zorderPosition",this._Z,jt,this._isNull),g("Shape.zorderPosition","Experiment52","1.1",r),this._Z},enumerable:!0,configurable:!0}),Ht.prototype.delete=function(){l(this,"Delete",0,[],0,0)},Ht.prototype.getParentSlide=function(){return g("Shape.getParentSlide",o,"1.5",r),a(i.Slide,this,"GetParentSlide",0,[],!1,!1,null,0)},Ht.prototype.getParentSlideLayout=function(){return g("Shape.getParentSlideLayout",o,"1.5",r),a(i.SlideLayout,this,"GetParentSlideLayout",0,[],!1,!1,null,0)},Ht.prototype.getParentSlideLayoutOrNullObject=function(){return g("Shape.getParentSlideLayoutOrNullObject",o,"1.5",r),a(i.SlideLayout,this,"GetParentSlideLayoutOrNullObject",0,[],!1,!1,null,0)},Ht.prototype.getParentSlideMaster=function(){return g("Shape.getParentSlideMaster",o,"1.5",r),a(i.SlideMaster,this,"GetParentSlideMaster",0,[],!1,!1,null,0)},Ht.prototype.getParentSlideMasterOrNullObject=function(){return g("Shape.getParentSlideMasterOrNullObject",o,"1.5",r),a(i.SlideMaster,this,"GetParentSlideMasterOrNullObject",0,[],!1,!1,null,0)},Ht.prototype.getParentSlideOrNullObject=function(){return g("Shape.getParentSlideOrNullObject",o,"1.5",r),a(i.Slide,this,"GetParentSlideOrNullObject",0,[],!1,!1,null,0)},Ht.prototype.getTable=function(){return g("Shape.getTable","Experiment52","1.1",r),a(i.Table,this,"GetTable",1,[],!1,!1,null,4)},Ht.prototype.setZOrder=function(e){g("Shape.setZOrder","Experiment52","1.1",r),l(this,"SetZOrder",0,[e],0,0)},Ht.prototype._handleResult=function(e){if(Mt.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Height)||(this._H=t.Height),d(t.Id)||(this._I=t.Id),d(t.Left)||(this._L=t.Left),d(t.Level)||(this._Le=t.Level),d(t.Name)||(this._N=t.Name),d(t.Top)||(this._To=t.Top),d(t.Type)||(this._Ty=t.Type),d(t.Width)||(this._W=t.Width),d(t.ZOrderPosition)||(this._Z=t.ZOrderPosition),_(this,t,["customXmlParts","CustomXmlParts","fill","Fill","group","Group","lineFormat","LineFormat","parentGroup","ParentGroup","tags","Tags","textFrame","TextFrame"])}},Ht.prototype.load=function(e){return m(this,e)},Ht.prototype.retrieve=function(e){return y(this,e)},Ht.prototype._handleIdResult=function(e){Mt.prototype._handleIdResult.call(this,e),f(e)||d(e.Id)||(this._I=e.Id)},Ht.prototype._handleRetrieveResult=function(e,t){Mt.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Ht.prototype.toJSON=function(){return v(this,{},{})},Ht.prototype.setMockData=function(e){C(this,e)},Ht.prototype.ensureUnchanged=function(e){u(this,e)},Ht);function Ht(){return null!==Mt&&Mt.apply(this,arguments)||this}i.Shape=kt;var Ut,Lt=(Ut=OfficeExtension.ClientObject,__extends(Bt,Ut),Object.defineProperty(Bt.prototype,"_className",{get:function(){return"Binding"},enumerable:!0,configurable:!0}),Object.defineProperty(Bt.prototype,"_scalarPropertyNames",{get:function(){return["id","type"]},enumerable:!0,configurable:!0}),Object.defineProperty(Bt.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Id","Type"]},enumerable:!0,configurable:!0}),Object.defineProperty(Bt.prototype,"id",{get:function(){return h("id",this._I,"Binding",this._isNull),this._I},enumerable:!0,configurable:!0}),Object.defineProperty(Bt.prototype,"type",{get:function(){return h("type",this._T,"Binding",this._isNull),this._T},enumerable:!0,configurable:!0}),Bt.prototype.delete=function(){l(this,"Delete",0,[],0,0)},Bt.prototype.getShape=function(){return a(i.Shape,this,"GetShape",0,[],!1,!1,null,0)},Bt.prototype._handleResult=function(e){if(Ut.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Id)||(this._I=t.Id),d(t.Type)||(this._T=t.Type)}},Bt.prototype.load=function(e){return m(this,e)},Bt.prototype.retrieve=function(e){return y(this,e)},Bt.prototype._handleIdResult=function(e){Ut.prototype._handleIdResult.call(this,e),f(e)||d(e.Id)||(this._I=e.Id)},Bt.prototype._handleRetrieveResult=function(e,t){Ut.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Bt.prototype.toJSON=function(){return v(this,{},{})},Bt.prototype.setMockData=function(e){C(this,e)},Bt.prototype.ensureUnchanged=function(e){u(this,e)},Bt);function Bt(){return null!==Ut&&Ut.apply(this,arguments)||this}i.Binding=Lt;var Wt,qt,Vt=(Wt=OfficeExtension.ClientObject,__extends(Gt,Wt),Object.defineProperty(Gt.prototype,"_className",{get:function(){return"BindingCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(Gt.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(Gt.prototype,"items",{get:function(){return h("items",this.m__items,"BindingCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),Gt.prototype.add=function(e,t,n){return a(i.Binding,this,"Add",0,[e,t,n],!1,!0,null,0)},Gt.prototype.addFromSelection=function(e,t){return a(i.Binding,this,"AddFromSelection",0,[e,t],!1,!1,null,0)},Gt.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},Gt.prototype.getItem=function(e){return t(i.Binding,this,[e])},Gt.prototype.getItemAt=function(e){return a(i.Binding,this,"GetItemAt",1,[e],!1,!1,null,4)},Gt.prototype.getItemOrNullObject=function(e){return a(i.Binding,this,"GetItemOrNullObject",0,[e],!1,!1,null,0)},Gt.prototype._handleResult=function(e){if(Wt.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.Binding,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},Gt.prototype.load=function(e){return m(this,e)},Gt.prototype.retrieve=function(e){return y(this,e)},Gt.prototype._handleRetrieveResult=function(e,t){var n=this;Wt.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.Binding,!0,n,e,t)})},Gt.prototype.toJSON=function(){return v(this,{},{},this.m__items)},Gt.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.Binding,!0,n,e,t)},function(e){return n.m__items=e})},Gt);function Gt(){return null!==Wt&&Wt.apply(this,arguments)||this}i.BindingCollection=Vt,(qt=i.DocumentPropertyType||(i.DocumentPropertyType={})).boolean="Boolean",qt.date="Date",qt.number="Number",qt.string="String";var Jt,zt="CustomProperty",Kt=(Jt=OfficeExtension.ClientObject,__extends(Xt,Jt),Object.defineProperty(Xt.prototype,"_className",{get:function(){return"CustomProperty"},enumerable:!0,configurable:!0}),Object.defineProperty(Xt.prototype,"_scalarPropertyNames",{get:function(){return["key","type","value"]},enumerable:!0,configurable:!0}),Object.defineProperty(Xt.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Key","Type","Value"]},enumerable:!0,configurable:!0}),Object.defineProperty(Xt.prototype,"_scalarPropertyUpdateable",{get:function(){return[!1,!1,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(Xt.prototype,"key",{get:function(){return h("key",this._K,zt,this._isNull),this._K},enumerable:!0,configurable:!0}),Object.defineProperty(Xt.prototype,"type",{get:function(){return h("type",this._T,zt,this._isNull),this._T},enumerable:!0,configurable:!0}),Object.defineProperty(Xt.prototype,"value",{get:function(){return h("value",this._V,zt,this._isNull),this._V},set:function(e){this._V=e,p(this,"Value",e,0)},enumerable:!0,configurable:!0}),Xt.prototype.delete=function(){l(this,"Delete",0,[],0,0)},Xt.prototype._handleResult=function(e){if(Jt.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Key)||(this._K=t.Key),d(t.Type)||(this._T=t.Type),d(t.Value)||(this._V=t.Value)}},Xt.prototype.load=function(e){return m(this,e)},Xt.prototype.retrieve=function(e){return y(this,e)},Xt.prototype._handleRetrieveResult=function(e,t){Jt.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t)},Xt.prototype.toJSON=function(){return v(this,{},{})},Xt.prototype.setMockData=function(e){C(this,e)},Xt.prototype.ensureUnchanged=function(e){u(this,e)},Xt);function Xt(){return null!==Jt&&Jt.apply(this,arguments)||this}i.CustomProperty=Kt;var Qt,$t=(Qt=OfficeExtension.ClientObject,__extends(Zt,Qt),Object.defineProperty(Zt.prototype,"_className",{get:function(){return"CustomPropertyCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(Zt.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(Zt.prototype,"items",{get:function(){return h("items",this.m__items,"CustomPropertyCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),Zt.prototype.add=function(e,t){return a(i.CustomProperty,this,"Add",0,[e,t],!1,!0,null,0)},Zt.prototype.deleteAll=function(){l(this,"DeleteAll",0,[],0,0)},Zt.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},Zt.prototype.getItem=function(e){return t(i.CustomProperty,this,[e])},Zt.prototype.getItemOrNullObject=function(e){return a(i.CustomProperty,this,"GetItemOrNullObject",1,[e],!1,!1,null,4)},Zt.prototype._handleResult=function(e){if(Qt.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.CustomProperty,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},Zt.prototype.load=function(e){return m(this,e)},Zt.prototype.retrieve=function(e){return y(this,e)},Zt.prototype._handleRetrieveResult=function(e,t){var n=this;Qt.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.CustomProperty,!0,n,e,t)})},Zt.prototype.toJSON=function(){return v(this,{},{},this.m__items)},Zt.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.CustomProperty,!0,n,e,t)},function(e){return n.m__items=e})},Zt);function Zt(){return null!==Qt&&Qt.apply(this,arguments)||this}i.CustomPropertyCollection=$t;var Yt,en,tn="DocumentProperties",nn=(Yt=OfficeExtension.ClientObject,__extends(rn,Yt),Object.defineProperty(rn.prototype,"_className",{get:function(){return"DocumentProperties"},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"_scalarPropertyNames",{get:function(){return["author","category","comments","company","creationDate","keywords","lastAuthor","manager","revisionNumber","subject","title"]},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"_scalarPropertyOriginalNames",{get:function(){return["Author","Category","Comments","Company","CreationDate","Keywords","LastAuthor","Manager","RevisionNumber","Subject","Title"]},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"_scalarPropertyUpdateable",{get:function(){return[!0,!0,!0,!0,!1,!0,!1,!0,!0,!0,!0]},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"_navigationPropertyNames",{get:function(){return["customProperties"]},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"customProperties",{get:function(){return this._Cu||(this._Cu=e(i.CustomPropertyCollection,this,"CustomProperties",!0,4)),this._Cu},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"author",{get:function(){return h("author",this._A,tn,this._isNull),this._A},set:function(e){this._A=e,p(this,"Author",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"category",{get:function(){return h("category",this._C,tn,this._isNull),this._C},set:function(e){this._C=e,p(this,"Category",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"comments",{get:function(){return h("comments",this._Co,tn,this._isNull),this._Co},set:function(e){this._Co=e,p(this,"Comments",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"company",{get:function(){return h("company",this._Com,tn,this._isNull),this._Com},set:function(e){this._Com=e,p(this,"Company",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"creationDate",{get:function(){return h("creationDate",this._Cr,tn,this._isNull),this._Cr},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"keywords",{get:function(){return h("keywords",this._K,tn,this._isNull),this._K},set:function(e){this._K=e,p(this,"Keywords",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"lastAuthor",{get:function(){return h("lastAuthor",this._L,tn,this._isNull),this._L},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"manager",{get:function(){return h("manager",this._M,tn,this._isNull),this._M},set:function(e){this._M=e,p(this,"Manager",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"revisionNumber",{get:function(){return h("revisionNumber",this._R,tn,this._isNull),this._R},set:function(e){this._R=e,p(this,"RevisionNumber",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"subject",{get:function(){return h("subject",this._S,tn,this._isNull),this._S},set:function(e){this._S=e,p(this,"Subject",e,0)},enumerable:!0,configurable:!0}),Object.defineProperty(rn.prototype,"title",{get:function(){return h("title",this._T,tn,this._isNull),this._T},set:function(e){this._T=e,p(this,"Title",e,0)},enumerable:!0,configurable:!0}),rn.prototype._handleResult=function(e){if(Yt.prototype._handleResult.call(this,e),!f(e)){var t=e;b(this,t),d(t.Author)||(this._A=t.Author),d(t.Category)||(this._C=t.Category),d(t.Comments)||(this._Co=t.Comments),d(t.Company)||(this._Com=t.Company),d(t.CreationDate)||(this._Cr=O(t.CreationDate)),d(t.Keywords)||(this._K=t.Keywords),d(t.LastAuthor)||(this._L=t.LastAuthor),d(t.Manager)||(this._M=t.Manager),d(t.RevisionNumber)||(this._R=t.RevisionNumber),d(t.Subject)||(this._S=t.Subject),d(t.Title)||(this._T=t.Title),_(this,t,["customProperties","CustomProperties"])}},rn.prototype.load=function(e){return m(this,e)},rn.prototype.retrieve=function(e){return y(this,e)},rn.prototype._handleRetrieveResult=function(e,t){if(Yt.prototype._handleRetrieveResult.call(this,e,t),!f(e)){var n=e;d(n.CreationDate)||(n.creationDate=O(n.creationDate)),S(this,e,t)}},rn.prototype.toJSON=function(){return v(this,{},{})},rn.prototype.setMockData=function(e){C(this,e)},rn.prototype.ensureUnchanged=function(e){u(this,e)},rn);function rn(){return null!==Yt&&Yt.apply(this,arguments)||this}i.DocumentProperties=nn,(en=i.InsertSlideFormatting||(i.InsertSlideFormatting={})).keepSourceFormatting="KeepSourceFormatting",en.useDestinationTheme="UseDestinationTheme";var on,an=(on=OfficeExtension.ClientObject,__extends(sn,on),Object.defineProperty(sn.prototype,"_className",{get:function(){return"SlideCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(sn.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(sn.prototype,"items",{get:function(){return h("items",this.m__items,"SlideCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),sn.prototype.add=function(e){g("SlideCollection.add",o,"1.3",r),l(this,"Add",0,[e],0,0)},sn.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},sn.prototype.getItem=function(e){return t(i.Slide,this,[e])},sn.prototype.getItemAt=function(e){return a(i.Slide,this,"GetItemAt",1,[e],!1,!1,null,4)},sn.prototype.getItemOrNullObject=function(e){return a(i.Slide,this,"GetItemOrNullObject",0,[e],!1,!1,null,0)},sn.prototype._handleResult=function(e){if(on.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.Slide,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},sn.prototype.load=function(e){return m(this,e)},sn.prototype.retrieve=function(e){return y(this,e)},sn.prototype._handleRetrieveResult=function(e,t){var n=this;on.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.Slide,!0,n,e,t)})},sn.prototype.toJSON=function(){return v(this,{},{},this.m__items)},sn.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.Slide,!0,n,e,t)},function(e){return n.m__items=e})},sn);function sn(){return null!==on&&on.apply(this,arguments)||this}i.SlideCollection=an;var cn,ln=(cn=OfficeExtension.ClientObject,__extends(un,cn),Object.defineProperty(un.prototype,"_className",{get:function(){return"SlideScopedCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(un.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(un.prototype,"items",{get:function(){return h("items",this.m__items,"SlideScopedCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),un.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},un.prototype.getItem=function(e){return t(i.Slide,this,[e])},un.prototype.getItemAt=function(e){return a(i.Slide,this,"GetItemAt",1,[e],!1,!1,null,4)},un.prototype.getItemOrNullObject=function(e){return a(i.Slide,this,"GetItemOrNullObject",0,[e],!1,!1,null,0)},un.prototype._handleResult=function(e){if(cn.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.Slide,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},un.prototype.load=function(e){return m(this,e)},un.prototype.retrieve=function(e){return y(this,e)},un.prototype._handleRetrieveResult=function(e,t){var n=this;cn.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.Slide,!0,n,e,t)})},un.prototype.toJSON=function(){return v(this,{},{},this.m__items)},un.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.Slide,!0,n,e,t)},function(e){return n.m__items=e})},un);function un(){return null!==cn&&cn.apply(this,arguments)||this}i.SlideScopedCollection=ln;var pn,fn=(pn=OfficeExtension.ClientObject,__extends(dn,pn),Object.defineProperty(dn.prototype,"_className",{get:function(){return"SlideMasterCollection"},enumerable:!0,configurable:!0}),Object.defineProperty(dn.prototype,"_isCollection",{get:function(){return!0},enumerable:!0,configurable:!0}),Object.defineProperty(dn.prototype,"items",{get:function(){return h("items",this.m__items,"SlideMasterCollection",this._isNull),this.m__items},enumerable:!0,configurable:!0}),dn.prototype.getCount=function(){return l(this,"GetCount",1,[],4,0)},dn.prototype.getItem=function(e){return t(i.SlideMaster,this,[e])},dn.prototype.getItemAt=function(e){return a(i.SlideMaster,this,"GetItemAt",1,[e],!1,!1,null,4)},dn.prototype.getItemOrNullObject=function(e){return a(i.SlideMaster,this,"GetItemOrNullObject",0,[e],!1,!1,null,0)},dn.prototype._handleResult=function(e){if(pn.prototype._handleResult.call(this,e),!f(e)){var t=e;if(b(this,t),!f(t[OfficeExtension.Constants.items])){this.m__items=[];for(var n=t[OfficeExtension.Constants.items],r=0;r<n.length;r++){var o=c(i.SlideMaster,!0,this,n[r],r);o._handleResult(n[r]),this.m__items.push(o)}}}},dn.prototype.load=function(e){return m(this,e)},dn.prototype.retrieve=function(e){return y(this,e)},dn.prototype._handleRetrieveResult=function(e,t){var n=this;pn.prototype._handleRetrieveResult.call(this,e,t),S(this,e,t,function(e,t){return c(i.SlideMaster,!0,n,e,t)})},dn.prototype.toJSON=function(){return v(this,{},{},this.m__items)},dn.prototype.setMockData=function(e){var n=this;C(this,e,function(e,t){return c(i.SlideMaster,!0,n,e,t)},function(e){return n.m__items=e})},dn);function dn(){return null!==pn&&pn.apply(this,arguments)||this}i.SlideMasterCollection=fn,(i.ErrorCodes||(i.ErrorCodes={})).generalException="GeneralException",i.Interfaces||(i.Interfaces={})}(PowerPoint=PowerPoint||{}),function(n){var r,e=(r=OfficeCore.RequestContext,__extends(t,r),Object.defineProperty(t.prototype,"presentation",{get:function(){return this.m_presentation},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"application",{get:function(){return null==this.m_application&&(this.m_application=new n.Application(this,OfficeExtension.ObjectPathFactory.createNewObjectObjectPath(this,"Microsoft.Office.PowerPoint.Application",!1))),this.m_application},enumerable:!0,configurable:!0}),t);function t(e){var t=r.call(this,e)||this;return t.m_presentation=new n.Presentation(t,OfficeExtension.ObjectPathFactory.createGlobalObjectObjectPath(t)),t._rootObject=t.m_presentation,t}n.RequestContext=e,n.run=function(e,t){return OfficeExtension.ClientRequestContext._runBatch("PowerPoint.run",arguments,function(){return new n.RequestContext})}}(PowerPoint=PowerPoint||{}),function(e){var t=(Object.defineProperty(n.prototype,"type",{get:function(){return e.EventType.ActiveViewChanged},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"activeView",{get:function(){return this.m_activeView.activeView},enumerable:!0,configurable:!0}),n);function n(e){this.m_activeView=e}e.ActiveViewChangedEventArgs=t}(OSF=OSF||{}),function(c){var e=(t.prototype.verifyArguments=function(e,t){for(var n in e){var r=e[n],o=t[n];if(r.enum)switch(typeof o){case"string":if(c.OUtil.listContainsValue(r.enum,o))break;case"undefined":throw 5007;default:throw this.getInvalidParameterString()}if(r.types&&!c.OUtil.listContainsValue(r.types,typeof o))throw this.getInvalidParameterString()}},t.prototype.extractRequiredArguments=function(e,t,n){if(e.length<this._requiredCount)throw c.Utility.createParameterException(Strings.OfficeOM.L_MissingRequiredArguments);var r,o=[];for(r=0;r<this._requiredCount;r++)o.push(e[r]);this.verifyArguments(this._requiredParameters,o);var i={};for(r=0;r<this._requiredCount;r++){var a=this._requiredParameters[r],s=o[r];if(a.verify&&!a.verify(s,t,n))throw this.getInvalidParameterString();i[a.name]=s}return i},t.prototype.fillOptions=function(e,t,n,r){for(var o in e=e||{},this._supportedOptions)if(!c.OUtil.listContainsKey(e,o)){var i=void 0,a=this._supportedOptions[o];a.calculate&&t&&(i=a.calculate(t,n,r)),i||void 0===a.defaultValue||(i=a.defaultValue),e[o]=i}return e},t.prototype.constructCallArgs=function(e,t,n,r){var o={};for(var i in e)o[i]=e[i];for(var a in t)o[a]=t[a];for(var s in this._privateStateCallbacks)o[s]=this._privateStateCallbacks[s](n,r);return this._checkCallArgs&&(o=this._checkCallArgs(o,n,r)),o},t.prototype.getInvalidParameterString=function(){var e=this;c.OUtil.delayExecutionAndCache(function(){return c.OUtil.formatString(Strings.OfficeOM.L_InvalidParameters,e._displayName)})},t);function t(e,t,n,r,o){this._requiredParameters=e,this._supportedOptions=t,this._privateStateCallbacks=n,this._checkCallArgs=r,this._displayName=o,this._requiredCount=e.length}c.ApiMethodCall=e}(OSF=OSF||{}),function(c){var e=(t.prototype.verifyAndExtractCall=function(e,t,n){var r=this._apiMethods.extractRequiredArguments(e,t,n),o=this.extractOptions(e,r,t,n);return this._apiMethods.constructCallArgs(r,o,t,n)},t.prototype.processResponse=function(e,t,n,r){return 0==e?this._onSucceeded?this._onSucceeded(t,n,r):t:this._onFailed?this._onFailed(e,t):c.DDA.ErrorCodeManager.getErrorArgs(e)},t.prototype.getCallArgs=function(e){for(var t,n,r=e.length-1;r>=this._requiredCount;r--){var o=e[r];switch(typeof o){case"object":t=o;break;case"function":n=o}}return t=t||{},n&&(t[c.ParameterNames.Callback]=n),t},t.prototype.extractOptions=function(e,t,n,r){if(e.length>this._requiredCount+2)throw c.Utility.createParameterException(Strings.OfficeOM.L_TooManyArguments);for(var o,i,a=e.length-1;a>=this._requiredCount;a--){var s=e[a];switch(typeof s){case"object":if(o)throw c.Utility.createParameterException(Strings.OfficeOM.L_TooManyOptionalObjects);o=s;break;case"function":if(i)throw c.Utility.createParameterException(Strings.OfficeOM.L_TooManyOptionalFunction);i=s;break;default:throw c.Utility.createArgumentException(Strings.OfficeOM.L_InValidOptionalArgument)}}if(o=this._apiMethods.fillOptions(o,t,n,r),i){if(o[c.ParameterNames.Callback])throw Strings.OfficeOM.L_RedundantCallbackSpecification;o[c.ParameterNames.Callback]=i}return this._apiMethods.verifyArguments(this._supportedOptions,o),o},t);function t(e,t,n,r,o,i,a){this._requiredParameters=e,this._supportedOptions=t,this._privateStateCallbacks=n,this._onSucceeded=r,this._onFailed=o,this._displayName=a,this._checkCallArgs=i,this._requiredCount=e.length,this._apiMethods=new c.ApiMethodCall(e,t,n,i,a)}c.AsyncMethodCall=e}(OSF=OSF||{}),function(o){var e,i;e=o.AsyncMethodCalls||(o.AsyncMethodCalls={}),i={},e.define=function(e){var t,n,r;i[e.method]=(n=(t=e).supportedOptions?o.OUtil.createObject(t.supportedOptions):[],r=t.privateStateCallbacks?o.OUtil.createObject(t.privateStateCallbacks):[],new o.AsyncMethodCall(t.requiredArguments||[],n,r,t.onSucceeded,t.onFailed,t.checkCallArgs,t.method))},e.get=function(e){return i[e]}}(OSF=OSF||{}),(OSF||(OSF={})).AsyncMethods={AddColumnsAsync:"addColumnsAsync",AddFromSelectionAsync:"addFromSelectionAsync",AddFromNamedItemAsync:"addFromNamedItemAsync",AddFromPromptAsync:"addFromPromptAsync",AddHandlerAsync:"addHandlerAsync",AddRowsAsync:"addRowsAsync",BindingSelectionChanged:"bindingSelectionChanged",BindingDataChanged:"bindingDataChanged",ClearFormatsAsync:"clearFormatsAsync",CloseAsync:"close",CloseContainerAsync:"closeContainer",DeleteAllDataValuesAsync:"deleteAllDataValuesAsync",DisplayDialogAsync:"displayDialogAsync",ExecuteFeature:"executeFeature",ExecuteRichApiRequestAsync:"executeRichApiRequestAsync",GetAllAsync:"getAllAsync",GetAccessTokenAsync:"getAccessTokenAsync",GetByIdAsync:"getByIdAsync",GetDataAsync:"getDataAsync",GetDocumentCopyAsync:"getFileAsync",GetDocumentCopyChunkAsync:"getSliceAsync",GetFilePropertiesAsync:"getFilePropertiesAsync",GetSelectedDataAsync:"getSelectedDataAsync",GoToByIdAsync:"goToByIdAsync",OpenBrowserWindow:"openBrowserWindow",QueryFeature:"queryFeature",ReleaseByIdAsync:"releaseByIdAsync",RemoveHandlerAsync:"removeHandlerAsync",ReleaseDocumentCopyAsync:"closeAsync",SetDataAsync:"setDataAsync",SetFormatsAsync:"setFormatsAsync",SetSelectedDataAsync:"setSelectedDataAsync",SetTableOptionsAsync:"setTableOptionsAsync",GetOfficeThemeAsync:"getOfficeThemeAsync",GetDocumentThemeAsync:"getDocumentThemeAsync"},function(e){var t;(t=e.PropertyDescriptors||(e.PropertyDescriptors={})).Subset="subset",t.BindingProperties="BindingProperties";var n=(Object.defineProperty(r.prototype,"startRow",{get:function(){return this.m_subset.startRow},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"startColumn",{get:function(){return this.m_subset.startColumn},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"rowCount",{get:function(){return this.m_subset.rowCount},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"columnCount",{get:function(){return this.m_subset.columnCount},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"type",{get:function(){return e.EventType.BindingSelectionChanged},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"binding",{get:function(){return this.m_bindingInstance},enumerable:!0,configurable:!0}),r);function r(e,t){this.m_bindingInstance=e,this.m_subset=t}e.BindingSelectionChangedEventArgs=n;var o=(Object.defineProperty(i.prototype,"type",{get:function(){return e.EventType.BindingDataChanged},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"binding",{get:function(){return this.m_bindingInstance},enumerable:!0,configurable:!0}),i);function i(e){this.m_bindingInstance=e}e.BindingDataChangedEventArgs=o}(OSF=OSF||{}),function(e){var t,n,r,o,i,a;(t=e.PropertyDescriptors||(e.PropertyDescriptors={})).DataPartProperties="DataPartProperties",t.DataNodeProperties="DataNodeProperties",n=e.Marshaling||(e.Marshaling={}),r=n.Customxml||(n.Customxml={}),(o=r.DataNodeEventProperties||(r.DataNodeEventProperties={})).OldNode="OldNode",o.NewNode="NewNode",o.NextSiblingNode="NextSiblingNode",o.InUndoRedo="InUndoRedo",(i=e.EventDescriptors||(e.EventDescriptors={})).DataNodeInsertedEvent="DataNodeInsertedEvent",i.DataNodeReplacedEvent="DataNodeReplacedEvent",i.DataNodeDeletedEvent="DataNodeDeletedEvent",(a=e.DataNodeEventProperties||(e.DataNodeEventProperties={})).OldNode="OldNode",a.NewNode="NewNode",a.NextSiblingNode="NextSiblingNode",a.InUndoRedo="InUndoRedo";var s=(Object.defineProperty(c.prototype,"type",{get:function(){return e.EventType.DataNodeInserted},enumerable:!0,configurable:!0}),Object.defineProperty(c.prototype,"newNode",{get:function(){return this.m_newNode},enumerable:!0,configurable:!0}),Object.defineProperty(c.prototype,"inUndoRedo",{get:function(){return this.m_inUndoRedo},enumerable:!0,configurable:!0}),c);function c(e,t){this.m_newNode=e,this.m_inUndoRedo=t}e.NodeInsertedEventArgs=s;var l=(Object.defineProperty(u.prototype,"type",{get:function(){return e.EventType.DataNodeReplaced},enumerable:!0,configurable:!0}),Object.defineProperty(u.prototype,"oldNode",{get:function(){return this.m_oldNode},enumerable:!0,configurable:!0}),Object.defineProperty(u.prototype,"newNode",{get:function(){return this.m_newNode},enumerable:!0,configurable:!0}),Object.defineProperty(u.prototype,"inUndoRedo",{get:function(){return this.m_inUndoRedo},enumerable:!0,configurable:!0}),u);function u(e,t,n){this.m_oldNode=e,this.m_newNode=t,this.m_inUndoRedo=n}e.NodeReplacedEventArgs=l;var p=(Object.defineProperty(f.prototype,"type",{get:function(){return e.EventType.DataNodeDeleted},enumerable:!0,configurable:!0}),Object.defineProperty(f.prototype,"oldNode",{get:function(){return this.m_oldNode},enumerable:!0,configurable:!0}),Object.defineProperty(f.prototype,"oldNextSibling",{get:function(){return this.m_oldNextSibling},enumerable:!0,configurable:!0}),Object.defineProperty(f.prototype,"inUndoRedo",{get:function(){return this.m_inUndoRedo},enumerable:!0,configurable:!0}),f);function f(e,t,n){this.m_oldNode=e,this.m_oldNextSibling=t,this.m_inUndoRedo=n}e.NodeDeletedEventArgs=p}(OSF=OSF||{}),function(t){function e(e){0==e[t.PropertyDescriptors.MessageType]?t.OUtil.defineEnumerableProperties(this,{type:{value:t.EventType.DialogMessageReceived},message:{value:e[t.PropertyDescriptors.MessageContent]},origin:{value:e[t.PropertyDescriptors.MessageOrigin]}}):t.OUtil.defineEnumerableProperties(this,{type:{value:t.EventType.DialogEventReceived},error:{value:e[t.PropertyDescriptors.MessageType]}})}var n;t.DialogEventArgs=e,(n=t.PropertyDescriptors||(t.PropertyDescriptors={})).MessageType="messageType",n.MessageContent="messageContent",n.MessageOrigin="messageOrigin"}(OSF=OSF||{}),function(e){var t=(Object.defineProperty(n.prototype,"type",{get:function(){return e.EventType.DocumentSelectionChanged},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"document",{get:function(){return this.m_docInstance},enumerable:!0,configurable:!0}),n);function n(e){this.m_docInstance=e}e.DocumentSelectionChangedEventArgs=t}(OSF=OSF||{}),function(t){function e(e){t.OUtil.defineEnumerableProperties(this,{type:{value:t.EventType.DialogParentMessageReceived},message:{value:e[t.PropertyDescriptors.MessageContent]},origin:{value:e[t.PropertyDescriptors.MessageOrigin]}})}t.DialogParentEventArgs=e}(OSF=OSF||{}),function(h){var e,i;function g(e){return e==h.EventDispId.dispidObjectDeletedEvent||e==h.EventDispId.dispidObjectSelectionChangedEvent||e==h.EventDispId.dispidObjectDataChangedEvent||e==h.EventDispId.dispidContentControlAddedEvent}function m(e,t,n,r){if("number"!=typeof e)throw e;b(r=r||t.getCallArgs(n),e,h.DDA.ErrorCodeManager.getErrorArgs(e))}function y(e){return(h._OfficeAppFactory.getHostInfo().hostPlatform==h.HostInfoPlatform.web?h.WACDelegate:h.SafeArrayDelegate)[e]}function v(){return i||function(){i={};var e={GoToByIdAsync:82,GetSelectedDataAsync:64,SetSelectedDataAsync:65,GetDocumentCopyChunkAsync:80,ReleaseDocumentCopyAsync:81,GetDocumentCopyAsync:77,AddFromSelectionAsync:66,AddFromPromptAsync:67,AddFromNamedItemAsync:78,GetAllAsync:74,GetByIdAsync:68,ReleaseByIdAsync:69,GetDataAsync:70,SetDataAsync:71,AddRowsAsync:72,AddColumnsAsync:79,DeleteAllDataValuesAsync:73,RefreshAsync:75,SaveAsync:76,GetActiveViewAsync:83,GetFilePropertiesAsync:86,GetOfficeThemeAsync:85,GetDocumentThemeAsync:84,ClearFormatsAsync:87,SetTableOptionsAsync:88,SetFormatsAsync:89,GetUserIdentityInfoAsync:92,GetAccessTokenAsync:98,GetAuthContextAsync:99,ExecuteRichApiRequestAsync:93,AppCommandInvocationCompletedAsync:94,CloseContainerAsync:97,OpenBrowserWindow:102,CreateDocumentAsync:105,InsertFormAsync:106,ExecuteFeature:146,QueryFeature:147,AddDataPartAsync:128,GetDataPartByIdAsync:129,GetDataPartsByNameSpaceAsync:130,GetPartXmlAsync:131,GetPartNodesAsync:132,DeleteDataPartAsync:133,GetNodeValueAsync:134,GetNodeXmlAsync:135,GetRelativeNodesAsync:136,SetNodeValueAsync:137,SetNodeXmlAsync:138,AddDataPartNamespaceAsync:139,GetDataPartNamespaceAsync:140,GetDataPartPrefixAsync:141,GetNodeTextAsync:142,SetNodeTextAsync:143,GetSelectedTask:110,GetTask:112,GetWSSUrl:114,GetTaskField:115,GetSelectedResource:111,GetResourceField:113,GetProjectField:116,GetSelectedView:117,GetTaskByIndex:118,GetResourceByIndex:119,SetTaskField:120,SetResourceField:121,GetMaxTaskIndex:122,GetMaxResourceIndex:123,CreateTask:124};for(var t in e)h.AsyncMethods[t]&&(i[h.AsyncMethods[t]]=e[t]);var n={MessageParent:144,SendMessage:145};for(var t in n)h.SyncMethods[t]&&(i[h.SyncMethods[t]]=n[t]);var r={SettingsChanged:h.EventDispId.dispidSettingsChangedEvent,DocumentSelectionChanged:h.EventDispId.dispidDocumentSelectionChangedEvent,BindingSelectionChanged:h.EventDispId.dispidBindingSelectionChangedEvent,BindingDataChanged:h.EventDispId.dispidBindingDataChangedEvent,ActiveViewChanged:h.EventDispId.dispidActiveViewChangedEvent,OfficeThemeChanged:h.EventDispId.dispidOfficeThemeChangedEvent,DocumentThemeChanged:h.EventDispId.dispidDocumentThemeChangedEvent,AppCommandInvoked:h.EventDispId.dispidAppCommandInvokedEvent,DialogMessageReceived:h.EventDispId.dispidDialogMessageReceivedEvent,DialogParentMessageReceived:h.EventDispId.dispidDialogParentMessageReceivedEvent,ObjectDeleted:h.EventDispId.dispidObjectDeletedEvent,ObjectSelectionChanged:h.EventDispId.dispidObjectSelectionChangedEvent,ObjectDataChanged:h.EventDispId.dispidObjectDataChangedEvent,ContentControlAdded:h.EventDispId.dispidContentControlAddedEvent,LiveShareStateChanged:h.EventDispId.dispidLiveShareStateChangedEvent,RichApiMessage:h.EventDispId.dispidRichApiMessageEvent,DataNodeInserted:h.EventDispId.dispidDataNodeAddedEvent,DataNodeReplaced:h.EventDispId.dispidDataNodeReplacedEvent,DataNodeDeleted:h.EventDispId.dispidDataNodeDeletedEvent};for(var o in r)h.EventType[o]&&(i[h.EventType[o]]=r[o])}(),i}function b(e,t,n){var r=e[h.ParameterNames.Callback];if(r){var o,i={};i[h.DDA.AsyncResultEnum.Properties.Context]=e[h.ParameterNames.AsyncContext],0==t?i[h.DDA.AsyncResultEnum.Properties.Value]=n:(o={},n=n||h.DDA.ErrorCodeManager.getErrorArgs(5001),o[h.DDA.AsyncResultEnum.ErrorProperties.Code]=t||5001,o[h.DDA.AsyncResultEnum.ErrorProperties.Name]=n.name||n,o[h.DDA.AsyncResultEnum.ErrorProperties.Message]=n.message||n),r(new h.DDA.AsyncResult(i,o))}}h.DialogShownStatus={hasDialogShown:!1,isWindowDialog:!1},(e=h.DispIdHost||(h.DispIdHost={})).InvokeMethod=function(e,t,o,n){var i;try{var a=h.AsyncMethodCalls.get(e);i=a.verifyAndExtractCall(t,o,n);var s=v()[e],r=y("executeAsync"),c=null;if(window.Excel&&window.Office.context.requirements.isSetSupported("RedirectV1Api")&&(window.Excel._RedirectV1APIs=!0),window.Excel&&window.Excel._RedirectV1APIs&&(c=window.Excel._V1APIMap[e])){var l=h.OUtil.shallowCopy(i);delete l[h.ParameterNames.AsyncContext],c.preprocess&&(l=c.preprocess(l));var u=new window.Excel.RequestContext,p=c.call(u,l);u.sync().then(function(){var e=p.value,t=e.status;delete e.status,delete e["@odata.type"],c.postprocess&&(e=c.postprocess(e,l)),0!=t&&(e=h.DDA.ErrorCodeManager.getErrorArgs(t)),b(i,t,e)}).catch(function(e){b(i,13991,null)})}else{var f;f=h.HostParameterMap.toHost(s,i);var d=(new Date).getTime();r({dispId:s,hostCallArgs:f,onCalling:function(){},onReceiving:function(){},onComplete:function(e,t){var n;n=0==e?h.HostParameterMap.fromHost(s,t):t;var r=a.processResponse(e,n,o,i);b(i,e,r),h.AppTelemetry&&h.AppTelemetry.onMethodDone(s,f,Math.abs((new Date).getTime()-d),e)}})}}catch(e){m(e,a,t,i)}},e.AddEventHandler=function(t,n,r,e){var o,i,a,s=!1;function c(e){var t;0==e&&((s?n.addObjectEventHandler(i,o[h.ParameterNames.Id],a):n.addEventHandler(i,a))||(e=13991));0!=e&&(t=h.DDA.ErrorCodeManager.getErrorArgs(e)),b(o,e,t)}try{var l=h.AsyncMethodCalls.get(h.AsyncMethods.AddHandlerAsync);if(o=l.verifyAndExtractCall(t,r,n),i=o[h.ParameterNames.EventType],a=o[h.ParameterNames.Handler],e)return void c(0);var u=v()[i],p=(s=g(u))?o[h.ParameterNames.Id]:r.id||"";if(0==(s?n.getObjectEventHandlerCount(i,p):n.getEventHandlerCount(i)))y("registerEventAsync")({eventType:i,dispId:u,targetId:p,onCalling:function(){},onReceiving:function(){},onComplete:c,onEvent:function(e){var t=h.HostParameterMap.fromHost(u,e);s?n.fireObjectEvent(p,h.manufactureEventArgs(i,p,t)):n.fireEvent(h.manufactureEventArgs(i,r,t))}});else c(0)}catch(e){m(e,l,t,o)}},e.RemoveEventHandler=function(t,e,n){var r,o,i,a=!1;function s(e){var t;0!=e&&(t=h.DDA.ErrorCodeManager.getErrorArgs(e)),b(r,e,t)}try{var c=h.AsyncMethodCalls.get(h.AsyncMethods.RemoveHandlerAsync);o=(r=c.verifyAndExtractCall(t,n,e))[h.ParameterNames.EventType],i=r[h.ParameterNames.Handler];var l,u,p=v()[o],f=(a=g(p))?r[h.ParameterNames.Id]:n.id||"";l=null===i?(u=a?e.clearObjectEventHandlers(o,f):e.clearEventHandlers(o),0):(u=a?e.removeObjectEventHandler(o,f,i):e.removeEventHandler(o,i))?0:5003;var d=a?e.getObjectEventHandlerCount(o,f):e.getEventHandlerCount(o);if(u&&0==d)y("unregisterEventAsync")({eventType:o,dispId:p,targetId:f,onCalling:function(){},onReceiving:function(){},onComplete:s});else s(l)}catch(e){m(e,c,t,r)}},e.OpenDialog=function(t,o,i){var r,a,s=h.EventType.DialogMessageReceived,c=h.EventType.DialogEventReceived;function e(e){if(0!=e)n=h.DDA.ErrorCodeManager.getErrorArgs(e);else{var t={};t.id=a,t.data=o;var n=l.processResponse(e,t,i,r);h.DialogShownStatus.hasDialogShown=!0,o.clearEventHandlers(s),o.clearEventHandlers(c)}b(r,e,n)}try{if(null!=s&&null!=c||e(5e3),null==h.AsyncMethods.DisplayDialogAsync)return void e(5001);var l=h.AsyncMethodCalls.get(h.AsyncMethods.DisplayDialogAsync);r=l.verifyAndExtractCall(t,i,o);var u=v()[s],n=y("openDialog");a=JSON.stringify(r),h.DialogShownStatus.hasDialogShown||(o.clearQueuedEvent(s),o.clearQueuedEvent(c),o.clearQueuedEvent(h.EventType.DialogParentMessageReceived)),n({eventType:s,dispId:u,targetId:a,onCalling:function(){},onReceiving:function(){},onComplete:e,onEvent:function(e){var t=h.HostParameterMap.fromHost(u,e),n=h.manufactureEventArgs(s,i,t);if(n.type==c){h.DDA.ErrorCodeManager.getErrorArgs(n.error);var r={};r.code=status||5001,n.error=new h.DDA.Error(r[h.DDA.AsyncResultEnum.ErrorProperties.Name],r[h.DDA.AsyncResultEnum.ErrorProperties.Message],r[h.DDA.AsyncResultEnum.ErrorProperties.Code])}o.fireOrQueueEvent(n),12006==t.messageType&&(o.clearEventHandlers(s),o.clearEventHandlers(c),o.clearEventHandlers(h.EventType.DialogParentMessageReceived),h.DialogShownStatus.hasDialogShown=!1)}})}catch(e){m(e,l,t,r)}},e.CloseDialog=function(t,e,n,r){var o,i,a;try{var s=h.AsyncMethodCalls.get(h.AsyncMethods.CloseAsync);o=s.verifyAndExtractCall(t,r,n),i=h.EventType.DialogMessageReceived,a=h.EventType.DialogEventReceived,n.clearEventHandlers(i),n.clearEventHandlers(a);var c=v()[i];y("closeDialog")({eventType:i,dispId:c,targetId:e,onCalling:function(){},onReceiving:function(){},onComplete:function(e){h.DialogShownStatus.hasDialogShown=!1}})}catch(e){m(e,s,t,o)}},e.MessageParent=function(e,t){var n=h.SyncMethodCalls.get(h.SyncMethods.MessageParent).verifyAndExtractCall(e,t,{});return y("messageParent")({dispId:v()[h.SyncMethods.MessageParent],hostCallArgs:n,onCalling:function(){},onReceiving:function(){}})},e.SendMessage=function(e,t,n){var r=h.SyncMethodCalls.get(h.SyncMethods.SendMessage).verifyAndExtractCall(e,n,{});return y("sendMessage")({dispId:v()[h.SyncMethods.SendMessage],hostCallArgs:r,onCalling:function(){},onReceiving:function(){}})},e.addAsyncMethods=function(t,e,n){for(var r in e){var o=e[r];t[o]||h.OUtil.defineEnumerableProperty(t,o,{value:function(e){return function(){(0,h.DispIdHost.InvokeMethod)(e,arguments,t,n)}}(o)})}},e.addEventSupport=function(e,t,n){var r=h.AsyncMethods.AddHandlerAsync,o=h.AsyncMethods.RemoveHandlerAsync;e[r]||h.OUtil.defineEnumerableProperty(e,r,{value:function(){(0,h.DispIdHost.AddEventHandler)(arguments,t,e,n)}}),e[o]||h.OUtil.defineEnumerableProperty(e,o,{value:function(){(0,h.DispIdHost.RemoveEventHandler)(arguments,t,e)}})},e.issueAsyncResult=b}(OSF=OSF||{}),function(o){o.manufactureEventArgs=function(e,t,n){var r;switch(e){case o.EventType.DocumentSelectionChanged:r=new o.DocumentSelectionChangedEventArgs(t);break;case o.EventType.BindingSelectionChanged:r=new o.BindingSelectionChangedEventArgs(o.manufactureBinding(n,t.document),n[o.PropertyDescriptors.Subset]);break;case o.EventType.BindingDataChanged:r=new o.BindingDataChangedEventArgs(o.manufactureBinding(n,t.document));break;case o.EventType.SettingsChanged:r=new o.SettingsChangedEventArgs(t);break;case o.EventType.ActiveViewChanged:r=new o.ActiveViewChangedEventArgs(n);break;case o.EventType.LiveShareStateChanged:r=new o.LiveShareStateChangedEventArgs(n);break;case o.EventType.OfficeThemeChanged:r=new o.DDA.Theming.OfficeThemeChangedEventArgs(n);break;case o.EventType.DocumentThemeChanged:r=new o.DDA.Theming.DocumentThemeChangedEventArgs(n);break;case o.EventType.DataNodeInserted:r=new o.NodeInsertedEventArgs(o.manufactureDataNode(n[o.DataNodeEventProperties.NewNode]),n[o.DataNodeEventProperties.InUndoRedo]);break;case o.EventType.DataNodeReplaced:r=new o.NodeReplacedEventArgs(o.manufactureDataNode(n[o.DataNodeEventProperties.OldNode]),o.manufactureDataNode(n[o.DataNodeEventProperties.NewNode]),n[o.DataNodeEventProperties.InUndoRedo]);break;case o.EventType.DataNodeDeleted:r=new o.NodeDeletedEventArgs(o.manufactureDataNode(n[o.DataNodeEventProperties.OldNode]),o.manufactureDataNode(n[o.DataNodeEventProperties.NextSiblingNode]),n[o.DataNodeEventProperties.InUndoRedo]);break;case o.EventType.DialogMessageReceived:r=new o.DialogEventArgs(n);break;case o.EventType.DialogParentMessageReceived:r=new o.DialogParentEventArgs(n)}return r}}(OSF=OSF||{}),function(d){var h="toHost",g="fromHost";!function(u){var t;u.self="self",u.dynamicTypes={},u.dynamicTypes[d.ParameterNames.Data]={toHost:function(e){if(null!=e&&void 0!==e.rows){var t={};t[d.TableDataProperties.TableRows]=e.rows,t[d.TableDataProperties.TableHeaders]=e.headers,e=t}return e},fromHost:function(e){return e}},u.dynamicTypes.sampleData=u.dynamicTypes.data;var p={};function r(e,t){var n,r;if(t.map)for(var o in r={},n=t.map){var i=n[o];i==u.self&&(i=o),r[i]=o}else n=t.toHost,r=t.fromHost;var a=p[e];if(a){var s=a[h];for(var c in s)n[c]=s[c];for(var l in s=a[g])r[l]=s[l]}else a=p[e]={};a[h]=n,a[g]=r}function o(e){f().addComplexType(e)}function l(e,t){var n=e?{}:void 0;for(var r in e){var o,i=e[r];if(d.ListType.isListType(r))for(var a in o=[],i)o.push(l(i[a],t));else if(d.OUtil.listContainsKey(u.dynamicTypes,r))o=u.dynamicTypes[r][t](i);else if(t==g&&f().preserveNesting(r))o=l(i,t);else{var s=p[r];if(s){var c=s[t];c&&void 0===(o=c[i])&&(o=i)}else o=i}n[r]=o}return n}function n(e,t,n){var r,o=p[e][n];if("toHost"==n)r=function e(t,n){var r;for(var o in n){var i;if(null!=(i=f().isComplexType(o)?e(t,p[o][h]):t[o])){r=r||{};var a=n[o];a==u.self&&(a=o),r[a]=f().pack(o,i)}}return r}(l(t,n),o);else if("fromHost"==n){r=l(function e(t,n,r){for(var o in r=r||{},n){var i,a,s=n[o];if(s==u.self)i=t;else{if("sourceData"==s){r[o]=t.toArray();continue}i=t[s]}if(null==i)r[o]=void 0;else if(i=f().unpack(o,i),f().isComplexType(o))a=p[o][g],f().preserveNesting(o)?r[o]=e(i,a):e(i,a,r);else if(d.ListType.isListType(o)){(a={})[d.ListType.getDescriptor(o)]=u.self;var c=new Array(i.length);for(var l in i)c[l]=e(i[l],a);r[o]=c}else r[o]=i}return r}(t,o),n)}return r}function f(){if(!t){var e=d._OfficeAppFactory.getHostInfo();t=e.hostPlatform==d.HostInfoPlatform.web?new d.WebSpecialProcessor:new d.SafeArraySpecialProcessor}return t}function i(e){var t=null;if(e){t={};for(var n=e.length,r=0;r<n;r++)t[e[r].name]=e[r].value}return t}u.define=function(e){var t={},n=i(e.toHost);e.invertible?t.map=n:e.canonical?t.toHost=t.fromHost=n:(t.toHost=n,t.fromHost=i(e.fromHost)),r(e.type,t),e.isComplexType&&o(e.type)},u.toHost=function(e,t){return n(e,t,h)},u.fromHost=function(e,t){return n(e,t,g)},u.addMapping=r,u.addComplexType=o,u.getDynamicType=function(e){return f().getDynamicType(e)},u.setDynamicType=function(e,t){f().setDynamicType(e,t)},u.doMapValues=function(e,t){return l(e,t)}}(d.HostParameterMap||(d.HostParameterMap={}))}(OSF=OSF||{}),function(t){var e,n;e=t.ListType||(t.ListType={}),n={},e.setListType=function(e,t){n[e]=t},e.isListType=function(e){return t.OUtil.listContainsKey(n,e)},e.getDescriptor=function(e){return n[e]}}(OSF=OSF||{}),function(e){var t=(Object.defineProperty(n.prototype,"type",{get:function(){return e.EventType.LiveShareStateChanged},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"liveShareState",{get:function(){return this.m_liveShareStateInstance},enumerable:!0,configurable:!0}),n);function n(e){this.m_liveShareStateInstance=e}e.LiveShareStateChangedEventArgs=t}(OSF=OSF||{}),function(e){var t;(t=e.EventType||(e.EventType={})).ActiveViewChanged="activeViewChanged",t.DialogMessageReceived="dialogMessageReceived",t.DialogParentMessageReceived="dialogParentMessageReceived",t.DialogParentEventReceived="dialogParentEventReceived",t.DialogEventReceived="dialogEventReceived",t.BindingDataChanged="bindingDataChanged",t.BindingSelectionChanged="bindingSelectionChanged",t.OfficeThemeChanged="officeThemeChanged",t.DocumentThemeChanged="documentThemeChanged",t.DataNodeDeleted="nodeDeleted",t.DataNodeInserted="nodeInserted",t.DataNodeReplaced="nodeReplaced",t.DocumentSelectionChanged="documentSelectionChanged",t.LiveShareStateChanged="liveShareStateChanged",t.NodeDeleted="nodeDeleted",t.NodeInserted="nodeInserted",t.NodeReplaced="nodeReplaced",t.SettingsChanged="settingsChanged"}(Office=Office||{}),function(e){var t;(t=e.TableDataProperties||(e.TableDataProperties={})).TableRows="TableRows",t.TableHeaders="TableHeaders"}(OSF=OSF||{}),function(d){!function(e){var t,n,r,o,i,a,s;function c(){try{var e=window.navigator.userAgent;return-1<e.indexOf("MSIE ")||-1<e.indexOf("Trident/")||-1<e.indexOf("Edge/")}catch(e){return f("Error happens in isInternetExplorer.",e),!1}}function l(e){if("undefined"!=typeof JSON)try{return JSON.stringify(e)}catch(e){}return""}(t=e.HostThemeButtonStyleKeys||(e.HostThemeButtonStyleKeys={})).ButtonBorderColor="buttonBorderColor",t.ButtonBackgroundColor="buttonBackgroundColor",(r=n=n||{}).HostButtonBorderColor="#86bfa0",r.HostButtonBackgroundColor="#d3f0e0",(i=o=o||{}).HostButtonBorderColor="#a3bde3",i.HostButtonBackgroundColor="#d5e1f2",(s=a=a||{}).HostButtonBorderColor="#f5ba9d",s.HostButtonBackgroundColor="#fcf0ed",e.finalizeProperties=function(e,t){t=t||{};for(var n=Object.getOwnPropertyNames(e),r=n.length,o=0;o<r;o++){var i=n[o],a=Object.getOwnPropertyDescriptor(e,i);a.get||a.set||(a.writable=t.writable||!1),a.configurable=t.configurable||!1,a.enumerable=t.enumerable||!0,Object.defineProperty(e,i,a)}return e},e.defineEnumerableProperties=function(e,t){return function(e,t,n){for(var r in t=t||{})p(e,r,t[r],n);return e}(e,t,["enumerable"])},e.defineEnumerableProperty=function(e,t,n){return p(e,t,n,["enumerable"])},e.listContainsKey=function(e,t){for(var n in e)if(t==n)return!0;return!1},e.augmentList=function(n,e){var t=n.push?function(e,t){n.push(t)}:function(e,t){n[e]=t};for(var r in e)t(r,e[r])},e.createObject=function(e){var t=null;if(e){t={};for(var n=e.length,r=0;r<n;r++)t[e[r].name]=e[r].value}return t},e.listContainsValue=function(e,t){for(var n in e)if(t==e[n])return!0;return!1},e.shouldUseLocalStorageToPassMessage=function(){try{for(var e=["Windows NT 6.1","Windows NT 6.2","Windows NT 6.3","Windows NT 10.0"],t=window.navigator.userAgent,n=0,r=e.length;n<r;n++)if(-1<t.indexOf(e[n]))return c();return!1}catch(e){return f("Error happens in shouldUseLocalStorageToPassMessage.",e),!1}},e.isInternetExplorer=c,e.serializeObjectToString=l,e.formatString=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var r=e;return r[0].replace(/{(\d+)}/gm,function(e,t){var n=parseInt(t,10)+1;return void 0===r[n]?"{"+t+"}":r[n]})},e.addHostInfoAsQueryParam=function(e,t){if(!e)return null;var n,r="#",o=(e=e.trim()||"").split(r),i=o.shift(),a=o.join(r),s=i.split("?");return 1<s.length?n=i+"&_host_Info="+t:0<s.length&&(n=i+"?_host_Info="+t),a?[n,r,a].join(""):n},e.getHostnamePortionForLogging=function(e){var t=e.split("."),n=t.length;return 2<=n?t[n-2]+"."+t[n-1]:1==n?t[0]:void 0},e.shallowCopy=function(e){if(null==e)return null;if(e instanceof Object){if(Array.isArray(e)){for(var t=[],n=0;n<e.length;n++)t.push(e[n]);return t}var r=e.constructor();for(var o in e)e.hasOwnProperty(o)&&(r[o]=e[o]);return r}return e},e.getXdmEventName=function(e,t){return t==d.EventType.BindingSelectionChanged||t==d.EventType.BindingDataChanged||t==d.EventType.DataNodeDeleted||t==d.EventType.DataNodeInserted||t==d.EventType.DataNodeReplaced?e+"_"+t:t},e.getCommonUI=function(){switch(Office.context.host){case Office.HostType.Excel:return n;case Office.HostType.Word:return o;case Office.HostType.PowerPoint:return a}return null},e.getDomainForUrl=function(e){if(!e)return null;var t=document.createElement("a");return t.href=e,t.protocol+"//"+t.host},e.delayExecutionAndCache=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];var n={calc:e[0]};return n.calc&&(n.val=n.calc.apply(this,e),delete n.calc),n.val};var u=-1;function p(e,t,n,r){for(var o in n=n||{},r){var i=r[o];null==n[i]&&(n[i]=!0)}return Object.defineProperty(e,t,n),e}function f(e,t){d.Utility.trace(e+" Exception details: "+l(t))}e.getUniqueId=function(){return(u+=1).toString()}}(d.OUtil||(d.OUtil={}))}(OSF=OSF||{}),function(e){var t;(t=e.ParameterNames||(e.ParameterNames={})).BindingType="bindingType",t.CoercionType="coercionType",t.ValueFormat="valueFormat",t.FilterType="filterType",t.Columns="columns",t.SampleData="sampleData",t.GoToType="goToType",t.SelectionMode="selectionMode",t.Id="id",t.PromptText="promptText",t.ItemName="itemName",t.FailOnCollision="failOnCollision",t.StartRow="startRow",t.StartColumn="startColumn",t.RowCount="rowCount",t.ColumnCount="columnCount",t.Rows="rows",t.OverwriteIfStale="overwriteIfStale",t.FileType="fileType",t.EventType="eventType",t.Handler="handler",t.SliceSize="sliceSize",t.SliceIndex="sliceIndex",t.ActiveView="activeView",t.Status="status",t.PlatformType="platformType",t.HostType="hostType",t.Email="email",t.OfficeTheme="officeTheme",t.DocumentTheme="documentTheme",t.ForceConsent="forceConsent",t.ForceAddAccount="forceAddAccount",t.AuthChallenge="authChallenge",t.AllowConsentPrompt="allowConsentPrompt",t.ForMSGraphAccess="forMSGraphAccess",t.AllowSignInPrompt="allowSignInPrompt",t.JsonPayload="jsonPayload",t.EnableNewHosts="enableNewHosts",t.AccountTypeFilter="accountTypeFilter",t.AddinTrustId="addinTrustId",t.Reserved="reserved",t.Tcid="tcid",t.Xml="xml",t.Namespace="namespace",t.Prefix="prefix",t.XPath="xPath",t.Text="text",t.ImageLeft="imageLeft",t.ImageTop="imageTop",t.ImageWidth="imageWidth",t.ImageHeight="imageHeight",t.TaskId="taskId",t.FieldId="fieldId",t.FieldValue="fieldValue",t.ServerUrl="serverUrl",t.ListName="listName",t.ResourceId="resourceId",t.ViewType="viewType",t.ViewName="viewName",t.GetRawValue="getRawValue",t.CellFormat="cellFormat",t.TableOptions="tableOptions",t.TaskIndex="taskIndex",t.ResourceIndex="resourceIndex",t.CustomFieldId="customFieldId",t.Url="url",t.MessageHandler="messageHandler",t.Width="width",t.Height="height",t.RequireHTTPs="requireHTTPS",t.DisplayInIframe="displayInIframe",t.HideTitle="hideTitle",t.UseDeviceIndependentPixels="useDeviceIndependentPixels",t.PromptBeforeOpen="promptBeforeOpen",t.EnforceAppDomain="enforceAppDomain",t.UrlNoHostInfo="urlNoHostInfo",t.Base64="base64",t.FormId="formId"}(OSF=OSF||{}),function(s){var e;function r(n,r){var o=(new Date).getTime();return function(e){r.onReceiving&&r.onReceiving();var t=e.toArray?e.toArray()[0]:e;return r.onComplete&&r.onComplete(t),s.AppTelemetry&&s.AppTelemetry.onRegisterDone(n,r.dispId,Math.abs((new Date).getTime()-o),t),!0}}function c(e){var t=e;if(null!=e&&e.toArray){var n=e.toArray();t=new Array(n.length);for(var r=0;r<n.length;r++)t[r]=c(n[r])}return t}(e=s.SafeArrayDelegate||(s.SafeArrayDelegate={})).executeAsync=function(a){try{a.onCalling&&a.onCalling(),s._OfficeAppFactory.getClientHostController().execute(a.dispId,function e(t){var n=t;if(s.OUtil.isArray(t))for(var r=n.length,o=0;o<r;o++)n[o]=e(n[o]);else if(s.OUtil.isDate(t))n=t.getVarDate();else if("object"==typeof t&&!s.OUtil.isArray(t))for(var i in n=[],t)s.OUtil.isFunction(t[i])||(n[i]=e(t[i]));return n}(a.hostCallArgs),function(e){var t,n;if(1==(n="number"==typeof e?(t=[],e):(t=e.toArray())[0]))return null!=(r=c(r=t[1]))&&(a._chunkResultData||(a._chunkResultData=new Array),a._chunkResultData[r[0]]=r[1]),!1;if(a.onReceiving&&a.onReceiving(),a.onComplete){var r;if(0==n){if(2<t.length){r=[];for(var o=1;o<t.length;o++)r[o-1]=t[o]}else r=t[1];if(a._chunkResultData&&null!=(r=c(r))){var i=r[r.length-1];a._chunkResultData.length==i?r[r.length-1]=a._chunkResultData:n=5001}}else r=t[1];a.onComplete(n,r)}return!0})}catch(e){s.SafeArrayDelegate.onException(e,a)}},e.registerEventAsync=function(n){n.onCalling&&n.onCalling();var e=r(!0,n);try{s._OfficeAppFactory.getClientHostController().registerEvent(n.dispId,void 0,n.targetId,function(e,t){n.onEvent&&n.onEvent(t),s.AppTelemetry&&s.AppTelemetry.onEventDone(n.dispId)},e)}catch(e){s.SafeArrayDelegate.onException(e,n)}},e.unregisterEventAsync=function(t){t.onCalling&&t.onCalling();var e=r(!1,t);try{s._OfficeAppFactory.getClientHostController().unregisterEvent(t.dispId,void 0,t.targetId,e)}catch(e){s.SafeArrayDelegate.onException(e,t)}},e.onException=function(e,t){var n,r=e.number;if(r)switch(r){case-2146828218:n=7e3;break;case-2147467259:n=t.dispId==s.EventDispId.dispidDialogMessageReceivedEvent?12007:5001;break;case-2146828283:case-2147209089:n=5010;break;case-2147208704:n=5100;break;case-2146827850:default:n=5001}t.onComplete&&t.onComplete(n||5001)},e.onExceptionSyncMethod=function(e,t){var n,r=e.number;if(r)switch(r){case-2146828218:n=7e3;break;case-2146827850:default:n=5001}return n||5001},e.getOnAfterRegisterEvent=r}(OSF=OSF||{}),function(e){var t=(Object.defineProperty(n.prototype,"type",{get:function(){return e.EventType.SettingsChanged},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"settings",{get:function(){return this.m_settingsInstance},enumerable:!0,configurable:!0}),n);function n(e){this.m_settingsInstance=e}e.SettingsChangedEventArgs=t}(OSF=OSF||{}),function(t){var e=(n.prototype.addComplexType=function(e){this._complexTypes.push(e)},n.prototype.getDynamicType=function(e){return this.dynamicTypes[e]},n.prototype.setDynamicType=function(e,t){this.dynamicTypes[e]=t},n.prototype.isComplexType=function(e){return t.OUtil.listContainsValue(this._complexTypes,e)},n.prototype.isDynamicType=function(e){return t.OUtil.listContainsKey(this.dynamicTypes,e)},n.prototype.preserveNesting=function(e){return!1},n.prototype.pack=function(e,t){return this.isDynamicType(e)?this.dynamicTypes[e].toHost(t):t},n.prototype.unpack=function(e,t){return this.isDynamicType(e)?this.dynamicTypes[e].fromHost(t):t},n);function n(e,t){this._complexTypes=e,this.dynamicTypes=t}t.SpecialProcessor=e}(OSF=OSF||{});__extends=this&&this.__extends||function(){var r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)};return function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}}();!function(r){var t,e=(t=r.SpecialProcessor,__extends(n,t),n.prototype.unpack=function(e,t){return this.isComplexType(e)||r.ListType.isListType(e)?void 0!==t&&void 0!==t.toArray?t.toArray():t||{}:this.isDynamicType(e)?this.dynamicTypes[e].fromHost(t):t},n);function n(){var e={};return e[r.ParameterNames.Data]={toHost:function(e){if(r.TableDataProperties&&"string"!=typeof e&&void 0!==e[r.TableDataProperties.TableRows]){var t=[];t[0]=e[r.TableDataProperties.TableRows],t[1]=e[r.TableDataProperties.TableHeaders],e=t}return e},fromHost:function(e){var t;if(e.toArray)if(2===e.dimensions())t=r.Utility.twoDVBArrayToJaggedArray(e);else{var n=e.toArray();2===n.length&&(null!=n[0]&&n[0].toArray||null!=n[1]&&n[1].toArray)?((t={})[r.TableDataProperties.TableRows]=r.Utility.twoDVBArrayToJaggedArray(n[0]),t[r.TableDataProperties.TableHeaders]=r.Utility.twoDVBArrayToJaggedArray(n[1])):t=n}else t=e;return t}},t.call(this,[],e)||this}r.SafeArraySpecialProcessor=e}(OSF=OSF||{}),function(s){var e=(t.prototype.verifyAndExtractCall=function(e,t,n){var r=this._apiMethods.extractRequiredArguments(e,t,n),o=this.extractOptions(e,r,t,n);return this._apiMethods.constructCallArgs(r,o,t,n)},t.prototype.extractOptions=function(e,t,n,r){if(e.length>this._requiredCount+1)throw s.Utility.createParameterException(Strings.OfficeOM.L_TooManyArguments);for(var o,i=e.length-1;i>=this._requiredCount;i--){var a=e[i];switch(typeof a){case"object":if(o)throw s.Utility.createParameterException(Strings.OfficeOM.L_TooManyArguments);o=a;break;default:throw s.Utility.createArgumentException(Strings.OfficeOM.L_InValidOptionalArgument)}}return o=this._apiMethods.fillOptions(o,t,n,r),this._apiMethods.verifyArguments(this._supportedOptions,o),o},t);function t(e,t,n,r,o){this._requiredCount=e.length,this._apiMethods=new s.ApiMethodCall(e,t,n,r,o),this._supportedOptions=t}s.SyncMethodCall=e}(OSF=OSF||{}),function(r){var e,o;e=r.SyncMethodCalls||(r.SyncMethodCalls={}),o={},e.define=function(e){var t,n;o[e.method]=(n=(t=e).supportedOptions?r.OUtil.createObject(t.supportedOptions):[],new r.SyncMethodCall(t.requiredArguments||[],n,t.privateStateCallbacks,t.checkCallArgs,t.method.displayName))},e.get=function(e){return o[e]}}(OSF=OSF||{}),(OSF||(OSF={})).SyncMethods={MessageParent:"messageParent",MessageChild:"messageChild",SendMessage:"sendMessage",AddMessageHandler:"addEventHandler"},function(l){var e;(function(e){var t,n,r,o;function i(e){for(var t=[{name:l.DDA.Theming.DocumentThemeEnum.PrimaryFontColor,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.PrimaryBackgroundColor,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.SecondaryFontColor,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.SecondaryBackgroundColor,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.Accent1,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.Accent2,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.Accent3,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.Accent4,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.Accent5,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.Accent6,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.Hyperlink,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.FollowedHyperlink,needToConvertToHex:!0},{name:l.DDA.Theming.DocumentThemeEnum.HeaderLatinFont,needToConvertToHex:!1},{name:l.DDA.Theming.DocumentThemeEnum.HeaderEastAsianFont,needToConvertToHex:!1},{name:l.DDA.Theming.DocumentThemeEnum.HeaderScriptFont,needToConvertToHex:!1},{name:l.DDA.Theming.DocumentThemeEnum.HeaderLocalizedFont,needToConvertToHex:!1},{name:l.DDA.Theming.DocumentThemeEnum.BodyLatinFont,needToConvertToHex:!1},{name:l.DDA.Theming.DocumentThemeEnum.BodyEastAsianFont,needToConvertToHex:!1},{name:l.DDA.Theming.DocumentThemeEnum.BodyScriptFont,needToConvertToHex:!1},{name:l.DDA.Theming.DocumentThemeEnum.BodyLocalizedFont,needToConvertToHex:!1}],n={},r=0;r<t.length;r++)t[r].needToConvertToHex?n[t[r].name]=l.OUtil.convertIntToCssHexColor(e[t[r].name]):n[t[r].name]=e[t[r].name];return n}function a(e){var t={};if(e){var n=l.DDA.Theming.OfficeThemeEnum,r={bodyBackgroundColor:{name:n.BodyBackgroundColor,convertToHex:!0},bodyForegroundColor:{name:n.BodyForegroundColor,convertToHex:!0},controlBackgroundColor:{name:n.ControlBackgroundColor,convertToHex:!0},controlForegroundColor:{name:n.ControlForegroundColor,convertToHex:!0},primaryFontColor:{name:n.BodyForegroundColor,convertToHex:!0},primaryBackgroundColor:{name:n.BodyBackgroundColor,convertToHex:!0},secondaryFontColor:{name:n.ControlBackgroundColor,convertToHex:!0},secondaryBackgroundColor:{name:n.ControlForegroundColor,convertToHex:!0}};for(var o in e){var i=!1,a=o;r[o]&&(a=r[o].name,i=r[o].convertToHex),t[a]=i?l.OUtil.convertIntToCssHexColor(e[o]):e[o]}null==t[n.IsDarkTheme]&&(t[n.IsDarkTheme]=l.DDA.Theming.GetIsDarkThemeFromCSSHexColor(t[n.BodyBackgroundColor])),null==t[n.ThemeId]&&(t[n.ThemeId]=t[n.IsDarkTheme]?l.DDA.Theming.ThemeId.Black:l.DDA.Theming.ThemeId.White)}return t}(t=e.DocumentThemeEnum||(e.DocumentThemeEnum={})).PrimaryFontColor="primaryFontColor",t.PrimaryBackgroundColor="primaryBackgroundColor",t.SecondaryFontColor="secondaryFontColor",t.SecondaryBackgroundColor="secondaryBackgroundColor",t.Accent1="accent1",t.Accent2="accent2",t.Accent3="accent3",t.Accent4="accent4",t.Accent5="accent5",t.Accent6="accent6",t.Hyperlink="hyperlink",t.FollowedHyperlink="followedHyperlink",t.HeaderLatinFont="headerLatinFont",t.HeaderEastAsianFont="headerEastAsianFont",t.HeaderScriptFont="headerScriptFont",t.HeaderLocalizedFont="headerLocalizedFont",t.BodyLatinFont="bodyLatinFont",t.BodyEastAsianFont="bodyEastAsianFont",t.BodyScriptFont="bodyScriptFont",t.BodyLocalizedFont="bodyLocalizedFont",(n=e.OfficeThemeEnum||(e.OfficeThemeEnum={})).BodyBackgroundColor="bodyBackgroundColor",n.BodyForegroundColor="bodyForegroundColor",n.ControlBackgroundColor="controlBackgroundColor",n.ControlForegroundColor="controlForegroundColor",n.IsDarkTheme="isDarkTheme",n.ThemeId="themeId",(r=e.OfficeThemeEnumWac||(e.OfficeThemeEnumWac={})).PrimaryFontColor="primaryFontColor",r.PrimaryBackgroundColor="primaryBackgroundColor",r.SecondaryFontColor="secondaryFontColor",r.SecondaryBackgroundColor="secondaryBackgroundColor",r.IsDarkTheme="isDarkTheme",r.ThemeId="themeId",(o=e.ThemeId||(e.ThemeId={}))[o.Colorful=0]="Colorful",o[o.DarkGray=1]="DarkGray",o[o.Black=2]="Black",o[o.White=3]="White",e.ConvertToDocumentTheme=i,e.GetIsDarkThemeFromCSSHexColor=function(e){var t="#"===e.charAt(0)?e.substring(1,7):e;return.299*parseInt(t.substring(0,2),16)+.587*parseInt(t.substring(2,4),16)+.114*parseInt(t.substring(4,6),16)<186},e.ConvertToOfficeTheme=a;function s(e){var t=null,n=l._OfficeAppFactory.getHostInfo();(t=n.hostPlatform==l.HostInfoPlatform.web?e:a(e)).isDarkTheme=l.DDA.Theming.GetIsDarkThemeFromCSSHexColor(t.bodyBackgroundColor),n.hostPlatform!=l.HostInfoPlatform.web&&"mac"!=n.hostPlatform.toLowerCase()&&"ios"!=n.hostPlatform.toLowerCase()||(t.themeId=t.isDarkTheme?l.DDA.Theming.ThemeId.Black:l.DDA.Theming.ThemeId.White,Office.context&&Office.context.officeTheme&&(Office.context.officeTheme.bodyBackgroundColor=t.bodyBackgroundColor,Office.context.officeTheme.bodyForegroundColor=t.bodyForegroundColor,Office.context.officeTheme.controlBackgroundColor=t.controlBackgroundColor,Office.context.officeTheme.controlForegroundColor=t.controlForegroundColor,Office.context.officeTheme.isDarkTheme=t.isDarkTheme,Office.context.officeTheme.themeId=t.themeId)),l.OUtil.defineEnumerableProperties(this,{type:{value:Microsoft.Office.WebExtension.EventType.OfficeThemeChanged},officeTheme:{value:t}})}e.OfficeThemeChangedEventArgs=s;function c(e){var t=i(e);l.OUtil.defineEnumerableProperties(this,{type:{value:Microsoft.Office.WebExtension.EventType.DocumentThemeChanged},documentTheme:{value:t}})}e.DocumentThemeChangedEventArgs=c})((e=l.DDA||(l.DDA={})).Theming||(e.Theming={}))}(OSF=OSF||{}),function(t){var e,n;e=t.V10ApiFeatureRegistry||(t.V10ApiFeatureRegistry={}),n=[],e.initialize=function(){n.forEach(function(e){e.defineMethodsFunc(),t.OUtil.getHostPlatform()==t.HostInfoPlatform.web?"function"==typeof e.defineWebParameterMapFunc&&e.defineWebParameterMapFunc():"function"==typeof e.defineSafeArrayParameterMapFunc&&e.defineSafeArrayParameterMapFunc(),"function"==typeof e.initializeFunc&&e.initializeFunc()})},e.register=function(e){n.push(e)}}(OSF=OSF||{}),function(a){var e,t;function n(r,o){var i=(new Date).getTime();return function(e,t){var n;if(o.onReceiving&&o.onReceiving(),0!=e)switch(e){case-5:n=7e3;break;default:n=5001}else n=t?t.Error?t.Error:0:5001;o.onComplete&&o.onComplete(n),a.AppTelemetry&&a.AppTelemetry.onRegisterDone(r,o.dispId,Math.abs((new Date).getTime()-i),n)}}(e=a.WACDelegate||(a.WACDelegate={})).version=1,(t=e.UniqueArguments||(e.UniqueArguments={})).Data="Data",t.Properties="Properties",t.BindingRequest="DdaBindingsMethod",t.BindingResponse="Bindings",t.SingleBindingResponse="singleBindingResponse",t.GetData="DdaGetBindingData",t.AddRowsColumns="DdaAddRowsColumns",t.SetData="DdaSetBindingData",t.ClearFormats="DdaClearBindingFormats",t.SetFormats="DdaSetBindingFormats",t.SettingsRequest="DdaSettingsMethod",t.BindingEventSource="ddaBinding",t.ArrayData="ArrayData",e.executeAsync=function(r){r.hostCallArgs||(r.hostCallArgs={}),r.hostCallArgs.DdaMethod={ControlId:a._OfficeAppFactory.getId(),Version:a.WACDelegate.version,DispatchId:r.dispId},r.hostCallArgs.__timeout__=-1,r.onCalling&&r.onCalling(),a.getClientEndPoint()&&a.getClientEndPoint().invoke("executeMethod",function(e,t){var n;if(r.onReceiving&&r.onReceiving(),0==e)a.WACDelegate.version=t.Version,n=t.Error;else switch(e){case-5:n=7e3;break;default:n=5001}r.onComplete&&r.onComplete(n,t)},r.hostCallArgs)},e.getOnAfterRegisterEvent=n,e.registerEventAsync=function(t){t.onCalling&&t.onCalling(),a.getClientEndPoint()&&a.getClientEndPoint().registerForEvent(a.OUtil.getXdmEventName(t.targetId,t.eventType),function(e){t.onEvent&&t.onEvent(e),a.AppTelemetry&&a.AppTelemetry.onEventDone(t.dispId)},n(!0,t),{controlId:a._OfficeAppFactory.getId(),eventDispId:t.dispId,targetId:t.targetId})},e.unregisterEventAsync=function(e){e.onCalling&&e.onCalling(),a.getClientEndPoint()&&a.getClientEndPoint().unregisterForEvent(a.OUtil.getXdmEventName(e.targetId,e.eventType),n(!1,e),{controlId:a._OfficeAppFactory.getId(),eventDispId:e.dispId,targetId:e.targetId})}}(OSF=OSF||{}),function(t){var n,e=(n=t.SpecialProcessor,__extends(r,n),r);function r(){var e=[t.WACDelegate.UniqueArguments.SingleBindingResponse,t.WACDelegate.UniqueArguments.BindingRequest,t.WACDelegate.UniqueArguments.BindingResponse,t.WACDelegate.UniqueArguments.GetData,t.WACDelegate.UniqueArguments.AddRowsColumns,t.WACDelegate.UniqueArguments.SetData,t.WACDelegate.UniqueArguments.ClearFormats,t.WACDelegate.UniqueArguments.SetFormats,t.WACDelegate.UniqueArguments.SettingsRequest,t.WACDelegate.UniqueArguments.BindingEventSource];return n.call(this,e,{})||this}t.WebSpecialProcessor=e}(OSF=OSF||{}),function(e){(e.EventDescriptors||(e.EventDescriptors={})).ActiveViewChangedEvent="ActiveViewChangedEvent",e.ActiveView||(e.ActiveView={}),e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){},defineSafeArrayParameterMapFunc:function(){e.HostParameterMap.define({type:e.ParameterNames.ActiveView,fromHost:[{name:0,value:Office.ActiveView.Read},{name:1,value:Office.ActiveView.Edit}]}),e.HostParameterMap.define({type:e.EventDescriptors.ActiveViewChangedEvent,fromHost:[{name:e.ParameterNames.ActiveView,value:0}],isComplexType:!0}),e.HostParameterMap.define({type:e.EventDispId.dispidActiveViewChangedEvent,fromHost:[{name:e.EventDescriptors.ActiveViewChangedEvent,value:e.HostParameterMap.self}]})}})}(OSF=OSF||{}),function(r){var e;((e=r.context||(r.context={})).document||(e.document={})).getActiveViewAsync=function(e,t){"function"==typeof e&&(t=e);var n={toSafeArrayHost:function(){return[]},fromSafeArrayHost:function(e){return 0==e?r.ActiveView.Read:1==e?r.ActiveView.Edit:void 0},toWebHost:function(){return[]},fromWebHost:function(e){return 0==e?r.ActiveView.Read:1==e?r.ActiveView.Edit:void 0}};OSF._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(83,n,t,null!=e?e.asyncContext:void 0)}}(Office=Office||{}),function(o){var e;function r(e){if(null==e||null==e)return null;var t=null,n=typeof e;return void 0!==e.rows?t=Office.CoercionType.Table:o.OUtil.isArray(e)?t=Office.CoercionType.Matrix:"string"!=n&&"number"!=n&&"boolean"!=n&&!o.OUtil.isDate(e)||(t=Office.CoercionType.Text),t}function i(e,t,n){return(n=n||r(e))&&n!=t&&(e=function(e,t){var n;switch(e){case Office.CoercionType.Table:n=t;break;case Office.CoercionType.Matrix:n=function(e){var t=e.rows;null!=e.headers&&t.unshift(e.headers);return t}(t);break;case Office.CoercionType.SlideRange:o.manufactureSlideRange&&null==(n=o.manufactureSlideRange(s(t)))&&(n=s(t));break;case Office.CoercionType.Text:case Office.CoercionType.Html:case Office.CoercionType.Ooxml:default:n=s(t)}return n}(t,function(e,t){null==t&&(t=r(e));var n;switch(t){case Office.CoercionType.Table:n=e;break;case Office.CoercionType.Matrix:n=new Office.TableData(e);break;case Office.CoercionType.Text:case Office.CoercionType.Html:case Office.CoercionType.Ooxml:default:n=new Office.TableData(function(e){for(var t=e.split("\n"),n=0;n<t.length;n++)t[n]=t[n].split("\t");return t}(e))}return n}(e,n))),e}function a(e){if(1==e.length&&1==e[0].length)return""+e[0][0];for(var t="",n=0;n<e.length;n++)t+=e[n].join("\t")+"\n";return t.substring(0,t.length-1)}function s(e){var t="";null!=e.headers&&(t=a([e.headers])+"\n");var n=a(e.rows);return""==n&&(t=t.substring(0,t.length-1)),t+n}e=o.DataCoercion||(o.DataCoercion={}),o.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){},defineSafeArrayParameterMapFunc:function(){o.HostParameterMap.define({type:o.ParameterNames.CoercionType,toHost:[{name:Office.CoercionType.Text,value:0},{name:Office.CoercionType.Matrix,value:1},{name:Office.CoercionType.Table,value:2},{name:Office.CoercionType.Html,value:3},{name:Office.CoercionType.Ooxml,value:4},{name:Office.CoercionType.OoxmlPackage,value:5},{name:Office.CoercionType.PdfFile,value:6},{name:Office.CoercionType.SlideRange,value:7}]});var e=o._OfficeAppFactory.getHostInfo();e.hostPlatform!=o.HostInfoPlatform.win32&&e.hostPlatform!=o.HostInfoPlatform.mac&&e.hostPlatform!=o.HostInfoPlatform.ios&&e.hostPlatform!=o.HostInfoPlatform.android||(o.OUtil.augmentList(Office.CoercionType,{Image:"image"}),o.OUtil.augmentList(Office.CoercionType,{XmlSvg:"xmlSvg"}),o.HostParameterMap.define({type:o.ParameterNames.CoercionType,toHost:[{name:"image",value:8},{name:"xmlSvg",value:9}]}));o.HostParameterMap.define({type:o.ParameterNames.ValueFormat,toHost:[{name:Office.ValueFormat.Unformatted,value:0},{name:Office.ValueFormat.Formatted,value:1}]}),o.HostParameterMap.define({type:o.ParameterNames.FilterType,toHost:[{name:Office.FilterType.All,value:0}]})},defineWebParameterMapFunc:function(){o.OUtil.augmentList(Office.CoercionType,{Image:"image"}),o.OUtil.augmentList(Office.CoercionType,{XmlSvg:"xmlSvg"}),o.HostParameterMap.define({type:o.ParameterNames.CoercionType,toHost:[{name:Office.CoercionType.Text,value:0},{name:Office.CoercionType.Matrix,value:1},{name:Office.CoercionType.Table,value:2},{name:Office.CoercionType.Html,value:3},{name:Office.CoercionType.Ooxml,value:4},{name:Office.CoercionType.OoxmlPackage,value:5},{name:Office.CoercionType.PdfFile,value:6},{name:Office.CoercionType.SlideRange,value:7},{name:"image",value:8},{name:"xmlSvg",value:9}]}),o.HostParameterMap.define({type:o.ParameterNames.ValueFormat,toHost:[{name:Office.ValueFormat.Unformatted,value:0},{name:Office.ValueFormat.Formatted,value:1}]}),o.HostParameterMap.define({type:o.ParameterNames.FilterType,toHost:[{name:Office.FilterType.All,value:0}]})}}),e.findArrayDimensionality=function e(t){if(o.OUtil.isArray(t)){for(var n=0,r=0;r<t.length;r++)n=Math.max(n,e(t[r]));return n+1}return 0},e.getCoercionDefaultForBinding=function(e){switch(e){case Office.BindingType.Matrix:return Office.CoercionType.Matrix;case Office.BindingType.Table:return Office.CoercionType.Table;case Office.BindingType.Text:default:return Office.CoercionType.Text}},e.getBindingDefaultForCoercion=function(e){switch(e){case Office.CoercionType.Matrix:return Office.BindingType.Matrix;case Office.CoercionType.Table:return Office.BindingType.Table;case Office.CoercionType.Text:case Office.CoercionType.Html:case Office.CoercionType.Ooxml:default:return Office.BindingType.Text}},e.determineCoercionType=r,e.coerceData=i,e.serializeDynamicData=function(e){if(null!=e&&void 0!==e.rows){var t={};t[o.TableDataProperties.TableRows]=e.rows,t[o.TableDataProperties.TableHeaders]=e.headers,e=t}var n;if(o._OfficeAppFactory.getHostInfo().hostPlatform==o.HostInfoPlatform.web)return"string"!=typeof e&&void 0!==e[o.TableDataProperties.TableRows]?((n={}).Rows=e[o.TableDataProperties.TableRows],n.Headers=e[o.TableDataProperties.TableHeaders],e=n):o.DataCoercion.determineCoercionType(e)==Office.CoercionType.Text&&(e=[[e]]),e;if(o.TableDataProperties&&"string"!=typeof e&&void 0!==e[o.TableDataProperties.TableRows]){(n=[])[0]=e[o.TableDataProperties.TableRows],n[1]=e[o.TableDataProperties.TableHeaders],e=n}return e},e.deserializeDynamicData=function(e,t){var n=null;if(o._OfficeAppFactory.getHostInfo().hostPlatform==o.HostInfoPlatform.web)null!=e.Rows?((n={})[o.TableDataProperties.TableRows]=e.Rows,n[o.TableDataProperties.TableHeaders]=e.Headers):n=e,!n||null==n[o.TableDataProperties.TableRows]&&null==n[o.TableDataProperties.TableHeaders]||(n=Office.manufactureTableData(n)),n=i(n,t);else{if(2===e.length){(n={})[o.TableDataProperties.TableRows]=e[0],n[o.TableDataProperties.TableHeaders]=e[1],n=Office.manufactureTableData(n)}else n=e;n=i(n,t)}return n}}(OSF=OSF||{}),function(e){var t,n,r,o,i;t=e.Marshaling||(e.Marshaling={}),(n=t.DialogMessageReceivedEventKeys||(t.DialogMessageReceivedEventKeys={})).MessageType="messageType",n.MessageContent="messageContent",n.MessageOrigin="messageOrigin",(r=t.DialogParentMessageReceivedEventKeys||(t.DialogParentMessageReceivedEventKeys={})).MessageType="messageType",r.MessageContent="messageContent",r.MessageOrigin="messageOrigin",(o=t.MessageParentKeys||(t.MessageParentKeys={})).MessageToParent="messageToParent",o.TargetOrigin="targetOrigin",(t.DialogNotificationShownEventType||(t.DialogNotificationShownEventType={})).DialogNotificationShown="dialogNotificationShown",(i=t.SendMessageKeys||(t.SendMessageKeys={})).MessageContent="messageContent",i.TargetOrigin="targetOrigin"}(OSF=OSF||{}),function(u){var e;(e=u.EventDescriptors||(u.EventDescriptors={})).DialogParentMessageReceivedEvent="DialogParentMessageReceivedEvent",e.DialogMessageReceivedEvent="DialogMessageReceivedEvent",u.DialogParentMessageEventDispatch=new u.EventDispatch([u.EventType.DialogParentMessageReceived,u.EventType.DialogParentEventReceived]),u.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){u.AsyncMethodCalls.define({method:u.AsyncMethods.DisplayDialogAsync,requiredArguments:[{name:u.ParameterNames.Url,types:["string"]}],supportedOptions:[{name:u.ParameterNames.Width,value:{types:["number"],defaultValue:99}},{name:u.ParameterNames.Height,value:{types:["number"],defaultValue:99}},{name:u.ParameterNames.RequireHTTPs,value:{types:["boolean"],defaultValue:!0}},{name:u.ParameterNames.DisplayInIframe,value:{types:["boolean"],defaultValue:!1}},{name:u.ParameterNames.HideTitle,value:{types:["boolean"],defaultValue:!1}},{name:u.ParameterNames.UseDeviceIndependentPixels,value:{types:["boolean"],defaultValue:!1}},{name:u.ParameterNames.PromptBeforeOpen,value:{types:["boolean"],defaultValue:!0}},{name:u.ParameterNames.EnforceAppDomain,value:{types:["boolean"],defaultValue:!0}},{name:u.ParameterNames.UrlNoHostInfo,value:{types:["boolean"],defaultValue:!1}}],privateStateCallbacks:[],onSucceeded:function(e,t,n){var r=e[u.ParameterNames.Id],o=e[u.ParameterNames.Data],i={},a=u.AsyncMethods.CloseAsync;u.OUtil.defineEnumerableProperty(i,a,{value:function(){(0,u.DispIdHost.CloseDialog)(arguments,r,o,i)}});var s=u.SyncMethods.AddMessageHandler;if(u.OUtil.defineEnumerableProperty(i,s,{value:function(){var e=u.SyncMethodCalls.get(u.SyncMethods.AddMessageHandler).verifyAndExtractCall(arguments,i,o),t=e[u.ParameterNames.EventType],n=e[u.ParameterNames.Handler];return o.addEventHandlerAndFireQueuedEvent(t,n)}}),!0===u.EnableSendMessageDialogAPI){var c=u.SyncMethods.SendMessage;u.OUtil.defineEnumerableProperty(i,c,{value:function(){return(0,u.DispIdHost.SendMessage)(arguments,o,i)}})}if(!0===u.EnableMessageChildDialogAPI){var l=u.SyncMethods.MessageChild;u.OUtil.defineEnumerableProperty(i,l,{value:function(){return(0,u.DispIdHost.SendMessage)(arguments,o,i)}})}return i},checkCallArgs:function(e,t,n){return e[u.ParameterNames.Width]<=0&&(e[u.ParameterNames.Width]=1),!e[u.ParameterNames.UseDeviceIndependentPixels]&&100<e[u.ParameterNames.Width]&&(e[u.ParameterNames.Width]=99),e[u.ParameterNames.Height]<=0&&(e[u.ParameterNames.Height]=1),!e[u.ParameterNames.UseDeviceIndependentPixels]&&100<e[u.ParameterNames.Height]&&(e[u.ParameterNames.Height]=99),e[u.ParameterNames.RequireHTTPs]||(e[u.ParameterNames.RequireHTTPs]=!0),e}}),u.AsyncMethodCalls.define({method:u.AsyncMethods.CloseAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[]}),u.SyncMethodCalls.define({method:u.SyncMethods.MessageParent,requiredArguments:[{name:u.ParameterNames.MessageToParent,types:["string","number","boolean"]}],supportedOptions:[{name:u.ParameterNames.TargetOrigin,value:{types:["string"],defaultValue:""}}]}),u.SyncMethodCalls.define({method:u.SyncMethods.AddMessageHandler,requiredArguments:[{name:u.ParameterNames.EventType,enum:u.EventType,verify:function(e,t,n){return n.supportsEvent(e)}},{name:u.ParameterNames.Handler,types:["function"]}],supportedOptions:[]}),u.SyncMethodCalls.define({method:u.SyncMethods.SendMessage,requiredArguments:[{name:u.ParameterNames.MessageContent,types:["string"]}],supportedOptions:[{name:u.ParameterNames.TargetOrigin,value:{types:["string"],defaultValue:""}}],privateStateCallbacks:[]})},defineSafeArrayParameterMapFunc:function(){u.HostParameterMap.define({type:u.EventDispId.dispidDialogMessageReceivedEvent,fromHost:[{name:u.EventDescriptors.DialogMessageReceivedEvent,value:u.HostParameterMap.self}],isComplexType:!0}),u.HostParameterMap.define({type:u.EventDescriptors.DialogMessageReceivedEvent,fromHost:[{name:u.PropertyDescriptors.MessageType,value:0},{name:u.PropertyDescriptors.MessageContent,value:1},{name:u.PropertyDescriptors.MessageOrigin,value:2}],isComplexType:!0}),u.HostParameterMap.define({type:u.EventDispId.dispidDialogParentMessageReceivedEvent,fromHost:[{name:u.EventDescriptors.DialogParentMessageReceivedEvent,value:u.HostParameterMap.self}],isComplexType:!0}),u.HostParameterMap.define({type:u.EventDescriptors.DialogParentMessageReceivedEvent,fromHost:[{name:u.PropertyDescriptors.MessageType,value:0},{name:u.PropertyDescriptors.MessageContent,value:1},{name:u.PropertyDescriptors.MessageOrigin,value:2}],isComplexType:!0})},defineWebParameterMapFunc:function(){u.HostParameterMap.define({type:u.EventDispId.dispidDialogMessageReceivedEvent,fromHost:[{name:u.EventDescriptors.DialogMessageReceivedEvent,value:u.HostParameterMap.self}]}),u.HostParameterMap.addComplexType(u.EventDescriptors.DialogMessageReceivedEvent),u.HostParameterMap.define({type:u.EventDescriptors.DialogMessageReceivedEvent,fromHost:[{name:u.PropertyDescriptors.MessageType,value:u.Marshaling.DialogMessageReceivedEventKeys.MessageType},{name:u.PropertyDescriptors.MessageContent,value:u.Marshaling.DialogMessageReceivedEventKeys.MessageContent},{name:u.PropertyDescriptors.MessageOrigin,value:u.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin}]}),u.HostParameterMap.define({type:u.EventDispId.dispidDialogParentMessageReceivedEvent,fromHost:[{name:u.EventDescriptors.DialogParentMessageReceivedEvent,value:u.HostParameterMap.self}]}),u.HostParameterMap.addComplexType(u.EventDescriptors.DialogParentMessageReceivedEvent),u.HostParameterMap.define({type:u.EventDescriptors.DialogParentMessageReceivedEvent,fromHost:[{name:u.PropertyDescriptors.MessageType,value:u.Marshaling.DialogParentMessageReceivedEventKeys.MessageType},{name:u.PropertyDescriptors.MessageContent,value:u.Marshaling.DialogParentMessageReceivedEventKeys.MessageContent},{name:u.PropertyDescriptors.MessageOrigin,value:u.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin}]}),u.HostParameterMap.define({type:144,toHost:[{name:u.ParameterNames.MessageToParent,value:u.Marshaling.MessageParentKeys.MessageToParent},{name:u.ParameterNames.TargetOrigin,value:u.Marshaling.MessageParentKeys.TargetOrigin}]}),u.HostParameterMap.define({type:145,toHost:[{name:u.ParameterNames.MessageContent,value:u.Marshaling.SendMessageKeys.MessageContent},{name:u.ParameterNames.TargetOrigin,value:u.Marshaling.MessageParentKeys.TargetOrigin}]})},initializeFunc:function(){var e=u.OUtil.isPopupWindow();u.EnableMessageChildDialogAPI=!0,"onenote"==u._OfficeAppFactory.getHostInfo().hostType?u.EnableSendMessageDialogAPI=!1:u.EnableSendMessageDialogAPI=!0;var t=Office.context.ui;if(u.OUtil.isDialog()){var n=u.SyncMethods.MessageParent;t[n]||u.OUtil.defineEnumerableProperty(t,n,{value:function(){return(0,u.DispIdHost.MessageParent)(arguments,t)}});var r=u.SyncMethods.AddMessageHandler;t[r]||void 0===u.DialogParentMessageEventDispatch||u.DispIdHost.addEventSupport(t,u.DialogParentMessageEventDispatch,e),e&&u.WacDialogAction.registerMessageReceivedEvent()}else{var o;o=null!=u.EventType.DialogParentMessageReceived?new u.EventDispatch([u.EventType.DialogMessageReceived,u.EventType.DialogEventReceived,u.EventType.DialogParentMessageReceived]):new u.EventDispatch([u.EventType.DialogMessageReceived,u.EventType.DialogEventReceived]);var i=u.AsyncMethods.DisplayDialogAsync;t[i]||u.OUtil.defineEnumerableProperty(t,i,{value:function(){(0,u.DispIdHost.OpenDialog)(arguments,o,t)}})}u.OUtil.finalizeProperties(t)}})}(OSF=OSF||{});var OfficeExt,Office,OSF,DialogApiManager=function(){function e(){}return e.messageChildRichApiBridge=function(){if(!0===OSF.EnableMessageChildDialogAPI)return(0,OSF.DispIdHost.SendMessage)(arguments,null,null)},e}();!function(b){var e,t,l,u,f,d,s,h,g,p,o,n,i,a,r,m,c,y,v,_;function O(e,t){var n=t.message,r=t.targetOrigin;if(r)e.postMessage(n,r);else{var o=b._OfficeAppFactory.getOfficeAppContext().get_appDomains(),i=window.location.origin;if(i=i||window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:""),o)for(var a=0;a<o.length&&-1!==o[a].indexOf("://");a++)e.postMessage(n,o[a]);b.XdmCommunicationManager.checkUrlWithAppDomains(o,i)||e.postMessage(n,i)}}function S(){try{d&&d.id==m&&h&&h(12009)}catch(e){b.AppTelemetry&&b.AppTelemetry.logAppException("Error happened during executing displayDialogAsync callback."+e)}x()}function C(e,t){var n=!1,r=b.WacCommonUICssManager.getDialogCssManager(t);f=F(r),document.body.insertBefore(f,document.body.firstChild),(d=function(e,t){var n=document.createElement("div");n.style.cssText=e.getDialogNotificationPanelCSS(),M(n);var r=document.createElement("div");r.style.cssText=e.getCrossZoneNotificationTextPanelCSS(),r.id=v;var o=document.createElement("a");o.id=y,o.href="#",o.innerText=Strings.OfficeOM.L_NewWindowCrossZoneConfigureBrowserLink,o.setAttribute("onclick","window.open('https://support.microsoft.com/en-us/help/17479/windows-internet-explorer-11-change-security-privacy-settings', '_blank', 'fullscreen=1')");var i=document.createElement("span");if(Strings.OfficeOM.L_NewWindowCrossZone){var a=Strings.OfficeOM.L_NewWindowCrossZone.replace(/{1+}/gm,b.OUtil.getDomainForUrl(t)).split("{0}");i.appendChild(document.createTextNode(a[0])),i.appendChild(o),i.appendChild(document.createTextNode(a[1]))}return r.appendChild(i),n.appendChild(r),n}(r,e)).id=c;var o=R(r),i=T(r,Strings.OfficeOM.L_DialogOK?Strings.OfficeOM.L_DialogOK:"OK");o.appendChild(i),d.appendChild(o),document.body.insertBefore(d,document.body.firstChild),g=!0,i.onclick=function(){x()},i.addEventListener("keydown",function(e){9==e.keyCode?(document.getElementById(y).focus(),e.preventDefault(),e.stopPropagation()):13==e.keyCode&&(n=!0,e.preventDefault(),e.stopPropagation())},!1),i.addEventListener("keyup",function(e){13==e.keyCode&&n&&(n=!1,x(),e.preventDefault(),e.stopPropagation())},!1),document.getElementById(y).addEventListener("keydown",function(e){9==e.keyCode&&(i.focus(),e.preventDefault(),e.stopPropagation())},!1),window.focus(),i.focus()}function A(e){if(e.source==l)try{var t=e.origin;if(!function(e,t,n){if(void 0===n&&(n=!0),!e||!t)return!1;var r=b.OUtil.parseUrl(e),o=b.OUtil.parseUrl(t),i=b._OfficeAppFactory.getOfficeAppContext().get_appDomains();if(!("https:"===r.protocol))return!1;var a=r.protocol===o.protocol&&r.hostname===o.hostname&&r.port===o.port,s=b.XdmCommunicationManager.checkUrlWithAppDomains(i,e),c=a||s;return!c&&n&&(c=b.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(t,e)),c}(t,b._OfficeAppFactory.getOfficeAppContext().get_docUrl(),!0))throw new Error("Received a message from a dialog with an untrusted domain.");var n={};n[b.Marshaling.DialogMessageReceivedEventKeys.MessageType]=0,n[b.Marshaling.DialogMessageReceivedEventKeys.MessageContent]=e.data,n[b.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin]=t,u(n)}catch(e){b.AppTelemetry&&b.AppTelemetry.logAppException("Error happened during receive message handler."+e)}}function P(e){var t=b._OfficeAppFactory.getId()+o;if(e.key==t)try{var n={};n[b.Marshaling.DialogMessageReceivedEventKeys.MessageType]=0,n[b.Marshaling.DialogMessageReceivedEventKeys.MessageContent]=e.newValue,n[b.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin]=e.origin,u(n)}catch(e){b.AppTelemetry&&b.AppTelemetry.logAppException("Error happened during storage changed handler."+e)}}function E(e){var t=b._OfficeAppFactory.getHostInfo(),n=[t.hostType,t.hostPlatform,t.hostSpecificFileVersion,t.hostLocale,t.osfControlAppCorrelationId,"isDialog",t.disableLogging?"disableLogging":"",t.flags&b.HostInfoFlags.PublicAddin].join("$"),r=b._OfficeAppFactory.getOfficeAppContext();r.set_taskpaneUrl(window.location.origin),r.get_taskpaneUrl()||r.set_taskpaneUrl(window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:""));var o=e.url;e[b.ShowWindowDialogParameterKeys.UrlNoHostInfo]||(o=b.OUtil.addHostInfoAsQueryParam(o,n));var i=JSON.parse(window.name);i.hostInfo=n,i.appContext=r;var a=e[b.ShowWindowDialogParameterKeys.Width]*screen.width/100,s=e[b.ShowWindowDialogParameterKeys.Height]*screen.height/100,c="width="+a+", height="+s+", left="+(r.get_clientWindowWidth()/2-a/2)+", top="+(r.get_clientWindowHeight()/2-s/2)+",channelmode=no,directories=no,fullscreen=no,location=no,menubar=no,resizable=yes,scrollbars=yes,status=no,titlebar=yes,toolbar=no";if(null==(l=window.open(o,b.OUtil.serializeObjectToString(i),c)))return b.AppTelemetry.logAppCommonMessage("Encountered cross zone issue in displayDialogAsync api."),D(),C(o,t.hostType),void h(12011);b.OUtil.shouldUseLocalStorageToPassMessage()?window.addEventListener("storage",P):window.addEventListener("message",A),p=window.setInterval(function(){try{if(null==l||l.closed){window.clearInterval(p),b.OUtil.shouldUseLocalStorageToPassMessage()?window.removeEventListener("storage",P):window.removeEventListener("message",A);var e={};e[b.Marshaling.DialogMessageReceivedEventKeys.MessageType]=12006,u(e)}}catch(e){b.AppTelemetry&&b.AppTelemetry.logAppException("Error happened during check or handle window close."+e)}},1e3),null!=h?h(0):b.AppTelemetry&&b.AppTelemetry.logAppException("showDialogCallback can not be null.")}function T(e,t){var n=document.createElement("input");n.setAttribute("type","button"),n.style.cssText=e.getDialogButtonCSS(),n.style.borderColor=i,n.style.backgroundColor=a,n.setAttribute("value",t);function r(){w(n)}function o(){I(n)}return n.addEventListener("mouseover",r),n.addEventListener("focus",r),n.addEventListener("mouseout",o),n.addEventListener("focusout",o),n}function w(e){null!=n?(e.style.borderColor=n.HostButtonBorderColor,e.style.backgroundColor=n.HostButtonBackgroundColor):b.OUtil.getCommonUI()?(e.style.borderColor=b.OUtil.getCommonUI().HostButtonBorderColor,e.style.backgroundColor=b.OUtil.getCommonUI().HostButtonBackgroundColor):e.style.backgroundColor=r}function I(e){e.style.borderColor=i,e.style.backgroundColor=a}function x(){_.onCalling=function(e){D(),N(e)},b.WACDelegate.unregisterEventAsync(_)}function D(){null!=d&&(document.body.removeChild(d),d=null),null!=f&&(document.body.removeChild(f),f=null)}function F(e){var t=document.createElement("div");return t.style.cssText=e.getOverlayElementCSS(),t}function R(e){var t=document.createElement("div");return t.style.cssText=e.getDialogNotificationButtonPanelCSS(),"rtl"==document.documentElement.getAttribute("dir")?t.style.cssFloat="left":t.style.cssFloat="right",t}function N(e){if(0!=e){var t=document.querySelectorAll(b._OfficeAppFactory.getInitializationHelper().getTabbableElements());b.OUtil.focusToFirstTabbable(t,!1)}}function M(e){e.setAttribute("role","dialog"),e.setAttribute("aria-describedby",v)}(e=b.ShowWindowDialogParameterKeys||(b.ShowWindowDialogParameterKeys={})).Url="url",e.Width="width",e.Height="height",e.DisplayInIframe="displayInIframe",e.HideTitle="hideTitle",e.UseDeviceIndependentPixels="useDeviceIndependentPixels",e.PromptBeforeOpen="promptBeforeOpen",e.EnforceAppDomain="enforceAppDomain",e.UrlNoHostInfo="urlNoHostInfo",e.TargetOrigin="targetOrigin",function(e){var t="excel",n="word",r="powerpoint",o="outlook",i="visio";e.getDialogCssManager=function(e){switch(e){case t:case n:case r:case o:case i:default:return new a}};var a=(s.prototype.getOverlayElementCSS=function(){return this.overlayElementCSS.join(";")},s.prototype.getDialogNotificationPanelCSS=function(){return this.dialogNotificationPanelCSS.join(";")},s.prototype.getNewWindowNotificationTextPanelCSS=function(){return this.newWindowNotificationTextPanelCSS.join(";")},s.prototype.getNewWindowNotificationTextSpanCSS=function(){return this.newWindowNotificationTextSpanCSS.join(";")},s.prototype.getCrossZoneNotificationTextPanelCSS=function(){return this.crossZoneNotificationTextPanelCSS.join(";")},s.prototype.getDialogNotificationButtonPanelCSS=function(){return this.dialogNotificationButtonPanelCSS},s.prototype.getDialogButtonCSS=function(){return this.buttonStyleCSS.join(";")},s);function s(){this.overlayElementCSS=["position: absolute","top: 0","left: 0","width: 100%","height: 100%","background-color: rgba(198, 198, 198, 0.5)","z-index: 99998"],this.dialogNotificationPanelCSS=["width: 100%","height: 190px","position: absolute","z-index: 99999","background-color: rgba(255, 255, 255, 1)","left: 0px","top: 50%","margin-top: -95px"],this.newWindowNotificationTextPanelCSS=["margin: 20px 14px","font-family: Segoe UI,Arial,Verdana,sans-serif","font-size: 14px","height: 100px","line-height: 100px"],this.newWindowNotificationTextSpanCSS=["display: inline-block","line-height: normal","vertical-align: middle"],this.crossZoneNotificationTextPanelCSS=["margin: 20px 14px","font-family: Segoe UI,Arial,Verdana,sans-serif","font-size: 14px","height: 100px"],this.dialogNotificationButtonPanelCSS="margin:0px 9px",this.buttonStyleCSS=["text-align: center","width: 70px","height: 25px","font-size: 14px","font-family: Segoe UI,Arial,Verdana,sans-serif","margin: 0px 5px","border-width: 1px","border-style: solid"]}e.DefaultDialogCSSManager=a}(b.WacCommonUICssManager||(b.WacCommonUICssManager={})),t=b.WacDialogAction||(b.WacDialogAction={}),g=!(s="osfDialogInternal:action=closeDialog"),p=-1,o="messageParentKey",n=h=d=f=u=l=null,i="#ababab",a="#ffffff",r="#ccc",m="newWindowNotificaiton",c="crossZoneNotification",y="configureBrowserLink",v="dialogNotificationTextPanel",_={dispId:b.EventDispId.dispidDialogNotificationShownInAddinEvent,eventType:b.Marshaling.DialogNotificationShownEventType.DialogNotificationShown,onComplete:null,onCalling:null},t.setHostThemeButtonStyle=function(e){var t=e.input;null!=t&&(n={HostButtonBorderColor:t[b.OUtil.HostThemeButtonStyleKeys.ButtonBorderColor],HostButtonBackgroundColor:t[b.OUtil.HostThemeButtonStyleKeys.ButtonBackgroundColor]}),e.completed()},t.removeEventListenersForDialog=function(e){!function(e){function t(){b._OfficeAppFactory.getWebAppState().focused||(b._OfficeAppFactory.getWebAppState().focused=!0),b.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,b.AgaveHostAction.Select])}function n(){b&&(b._OfficeAppFactory.getWebAppState().focused&&(b._OfficeAppFactory.getWebAppState().focused=!1),b.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,b.AgaveHostAction.UnSelect]))}function r(e){if(e.preventDefault=e.preventDefault||function(){e.returnValue=!1},117==e.keyCode&&(e.ctrlKey||e.metaKey)){e.preventDefault();var t=b.AgaveHostAction.CtrlF6Exit;e.shiftKey&&(t=b.AgaveHostAction.CtrlF6ExitShift),b.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,t])}else if(9==e.keyCode){e.preventDefault();var n=document.querySelectorAll(i._tabbableElements);b.OUtil.focusToNextTabbable(n,e.target||e.srcElement,e.shiftKey)||(i._hostInfo.isDialog?b.OUtil.focusToFirstTabbable(n,e.shiftKey):e.shiftKey?b.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,b.AgaveHostAction.TabExitShift]):b.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,b.AgaveHostAction.TabExit]))}else if(27==e.keyCode)e.preventDefault(),S(),b.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,b.AgaveHostAction.EscExit]);else if(113==e.keyCode)e.preventDefault(),b.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,b.AgaveHostAction.F2Exit]);else if((e.ctrlKey||e.metaKey||e.shiftKey||e.altKey)&&1<=e.keyCode&&e.keyCode<=255){var r={keyCode:e.keyCode,shiftKey:e.shiftKey,altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey};b.getClientEndPoint().invoke("ContextActivationManager_notifyHost",null,[i._webAppState.id,b.AgaveHostAction.KeyboardShortcuts,r])}}function o(e){117==e.keyCode&&e.ctrlKey&&(e.preventDefault?e.preventDefault():e.returnValue=!1)}var i=this;e?(b.OUtil.addEventListener(window,"focus",t),b.OUtil.addEventListener(window,"blur",n),b.OUtil.addEventListener(window,"keydown",r),b.OUtil.addEventListener(window,"keypress",o)):(b.OUtil.removeEventListener(window,"focus",t),b.OUtil.removeEventListener(window,"blur",n),b.OUtil.removeEventListener(window,"keydown",r),b.OUtil.removeEventListener(window,"keypress",o))}(!1),e.completed()},t.handleNewWindowDialog=function(t){try{if(l=t,u=b._OfficeAppFactory.getOfficeAppContext().get_appDomains(),p=l.url,!(b.XdmCommunicationManager.checkUrlWithAppDomains(u,p)||b._OfficeAppFactory.getOfficeAppContext().get_docUrl()&&b.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(b._OfficeAppFactory.getOfficeAppContext().get_docUrl(),p)))return void h(12004);if(!t[b.ShowWindowDialogParameterKeys.PromptBeforeOpen])return void E(t);var n=g=!1,e=b._OfficeAppFactory.getHostInfo(),r=b.WacCommonUICssManager.getDialogCssManager(e.hostType),o=b.OUtil.formatString(Strings.OfficeOM.L_ShowWindowDialogNotification,b._OfficeAppFactory.getOfficeAppContext().get_addinName());f=F(r),document.body.insertBefore(f,document.body.firstChild),(d=function(e,t){var n=document.createElement("div");n.style.cssText=e.getDialogNotificationPanelCSS(),M(n);var r=document.createElement("div");r.style.cssText=e.getNewWindowNotificationTextPanelCSS(),r.id=v,"rtl"==document.documentElement.getAttribute("dir")?r.style.paddingRight="30px":r.style.paddingLeft="30px";var o=document.createElement("span");return o.style.cssText=e.getNewWindowNotificationTextSpanCSS(),o.innerText=t,r.appendChild(o),n.appendChild(r),n}(r,o)).id=m;var i=R(r),a=T(r,Strings.OfficeOM.L_ShowWindowDialogNotificationAllow),s=T(r,Strings.OfficeOM.L_ShowWindowDialogNotificationIgnore);function c(e){_.onCalling=function(e){D(),N(e),h(12009)},b.WACDelegate.unregisterEventAsync(_),e.preventDefault(),e.stopPropagation()}i.appendChild(a),i.appendChild(s),d.appendChild(i),document.body.insertBefore(d,document.body.firstChild),a.onclick=function(e){E(t),g||x(),e.preventDefault(),e.stopPropagation()},s.onclick=c,a.addEventListener("keydown",function(e){e.shiftKey&&9==e.keyCode&&(I(a),w(s),s.focus(),e.preventDefault(),e.stopPropagation())},!1),s.addEventListener("keydown",function(e){e.shiftKey||9!=e.keyCode?13==e.keyCode&&(n=!0,e.preventDefault(),e.stopPropagation()):(I(s),w(a),a.focus(),e.preventDefault(),e.stopPropagation())},!1),s.addEventListener("keyup",function(e){13==e.keyCode&&n&&(n=!1,c(e))},!1),window.focus(),_.onCalling=function(e){a.focus()},b.WACDelegate.registerEventAsync(_)}catch(e){b.AppTelemetry&&b.AppTelemetry.logAppException("Exception happens at new window dialog."+e),h(5001)}var l,u,p},t.closeDialog=function(t){try{if(null!=l){var e=b._OfficeAppFactory.getOfficeAppContext().get_appDomains();if(e)for(var n=0;n<e.length&&-1!==e[n].indexOf("://");n++)l.postMessage(s,e[n]);null==l||l.closed||l.close(),b.OUtil.shouldUseLocalStorageToPassMessage()?window.removeEventListener("storage",P):window.removeEventListener("message",A),window.clearInterval(p),l=null,t(0)}else t(5001)}catch(e){b.AppTelemetry&&b.AppTelemetry.logAppException("Exception happens at close window dialog."+e),t(5001)}},t.messageParent=function(e){var t=e.hostCallArgs[b.ParameterNames.MessageToParent],n=e.hostCallArgs[b.ParameterNames.TargetOrigin]||null;if(b.OUtil.shouldUseLocalStorageToPassMessage())try{var r=b._OfficeAppFactory.getId()+o;window.localStorage.setItem(r,t)}catch(e){b.AppTelemetry&&b.AppTelemetry.logAppException("Error happened during messageParent method:"+e)}else O(window.opener,{message:t,targetOrigin:n})},t.sendMessage=function(e){if(null!=l){var t=e.hostCallArgs,n=t[b.ParameterNames.TargetOrigin]||null;delete t[b.ParameterNames.TargetOrigin],"string"!=typeof t&&(t=JSON.stringify(t)),O(l,{message:t,targetOrigin:n})}},t.postDialogMessage=O,t.registerMessageReceivedEvent=function(){window.addEventListener("message",function(e){var t=e.origin;if(e.source==window.opener&&(!0===window.office_disable_receive_dialog_message_prompt||b.WacDialogAction.validateTaskpaneDomain(t,!0)))if("string"==typeof e.data&&-1<e.data.indexOf(s))window.close();else{var n=e.data,r=typeof n;if(n&&("object"==r||"string"==r)){var o="string"==r?JSON.parse(n):n,i={};i[b.Marshaling.DialogMessageReceivedEventKeys.MessageContent]=o.messageContent,i[b.Marshaling.DialogMessageReceivedEventKeys.MessageOrigin]=e.origin;var a=b.manufactureEventArgs(b.EventType.DialogParentMessageReceived,null,i);b.DialogParentMessageEventDispatch.fireEvent(a)}}})},t.setHandlerAndShowDialogCallback=function(e,t){u=e,h=t},t.escDismissDialogNotification=S,t.showCrossZoneNotification=C,t.getWithExpiry=function(e,t){var n=e.getItem(t);if(!n)return"undefined";var r=JSON.parse(n);return r.expiry&&r.value?(new Date).getTime()>r.expiry?(e.removeItem(t),"undefined"):r.value:"undefined"},t.setWithExpiry=function(e,t,n){var r={value:n,expiry:(new Date).getTime()+864e5};e.setItem(t,JSON.stringify(r))},t.getLocalStorage=function(){return b.SafeStorage?new b.SafeStorage(window.localStorage):window.localStorage},t.getSessionStorage=function(){return b.SafeStorage?new b.SafeStorage(window.sessionStorage):window.sessionStorage},t.getUrlProtocolHostnamePort=function(e){var t=e.port?":"+e.port:"";return e.protocol+"//"+e.hostname+t},t.validateTaskpaneDomain=function(e,t){try{if(!e)return!1;t=t||!0;var n=window.location.origin;n=n||window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:"");var r=b.OUtil.parseUrl(n,!0),o=b.OUtil.parseUrl(e,!0);if(!(r.protocol&&r.hostname&&o.protocol&&o.hostname&&void 0!==o.port))return!1;var i=(m=o,(g=r).hostname==m.hostname&&g.protocol==m.protocol&&(v=m,(y=g).port==v.port||""==y.port&&"http:"==y.protocol&&"80"==v.port||""==y.port&&"https:"==y.protocol&&"443"==v.port||""==v.port&&"http:"==v.protocol&&"80"==y.port||""==v.port&&"https:"==v.protocol&&"443"==y.port)),a=!1;if(t&&(a=b.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(e,n)),i||a)return!0;var s=this.getLocalStorage(),c=this.getSessionStorage(),l="_trusts_"+(o.protocol+"//"+o.hostname+(o.port?":"+o.port:"")),u=this.getWithExpiry(s,l),p=this.getWithExpiry(c,l);if("true"===u)return!0;if("false"===p)return!1;var f=this.getUrlProtocolHostnamePort(o),d=this.getUrlProtocolHostnamePort(r),h='You are about to send and receive potentially sensitive information from "'+d+'". Only click OK if you trust the following website recieving the sensitive information: "'+f+'".';return Strings.OfficeOM.L_ConfirmDialogApiTrustsParent&&(h=Strings.OfficeOM.L_ConfirmDialogApiTrustsParent.replace("{0}",d).replace("{1}",f)),window.confirm(h)?(this.setWithExpiry(s,l,"true"),this.setWithExpiry(c,l,"true"),!0):(this.setWithExpiry(s,l,"false"),this.setWithExpiry(c,l,"false"),!1)}catch(e){return b.AppTelemetry&&b.AppTelemetry.logAppException("Error happened during validateTaskpaneDomain method:"+e),!1}var g,m,y,v}}(OSF=OSF||{}),function(r){var e;(e=r.SafeArrayDelegate||(r.SafeArrayDelegate={})).openDialog=function(n){try{n.onCalling&&n.onCalling();var e=r.SafeArrayDelegate.getOnAfterRegisterEvent(!0,n);r._OfficeAppFactory.getClientHostController().openDialog(n.dispId,void 0,n.targetId,function(e,t){n.onEvent&&n.onEvent(t),r.AppTelemetry&&r.AppTelemetry.onEventDone(n.dispId)},e)}catch(e){r.SafeArrayDelegate.onException(e,n)}},e.closeDialog=function(t){t.onCalling&&t.onCalling();var e=r.SafeArrayDelegate.getOnAfterRegisterEvent(!1,t);try{r._OfficeAppFactory.getClientHostController().closeDialog(t.dispId,void 0,t.targetId,e)}catch(e){r.SafeArrayDelegate.onException(e,t)}},e.messageParent=function(e){try{e.onCalling&&e.onCalling();var t=(new Date).getTime(),n=r._OfficeAppFactory.getClientHostController().messageParent(e.hostCallArgs);return e.onReceiving&&e.onReceiving(),r.AppTelemetry&&r.AppTelemetry.onMethodDone(e.dispId,e.hostCallArgs,Math.abs((new Date).getTime()-t),n),n}catch(e){return r.SafeArrayDelegate.onExceptionSyncMethod(e)}},e.sendMessage=function(e){try{e.onCalling&&e.onCalling();(new Date).getTime();var t=r._OfficeAppFactory.getClientHostController().sendMessage(e.hostCallArgs);return e.onReceiving&&e.onReceiving(),t}catch(e){return r.SafeArrayDelegate.onExceptionSyncMethod(e)}}}(OSF=OSF||{}),function(m){var y;(y=m.WACDelegate||(m.WACDelegate={})).openDialog=function(t){var e=JSON.parse(t.targetId),n=y.getOnAfterRegisterEvent(!0,t);function r(e){var t={Error:e};try{n(0,t)}catch(e){m.AppTelemetry&&m.AppTelemetry.logAppException("Exception happens at showDialogCallback."+e)}}if(m.DialogShownStatus.hasDialogShown)r(12007);else{var o=e[m.ShowWindowDialogParameterKeys.Url].toLowerCase(),i=window.location.href.toLowerCase();if(m.AppTelemetry){var a=!1,s=!1,c=!1,l=!1,u="",p="";if(m.OUtil){var f=m.OUtil.parseUrl(o),d=m.OUtil.parseUrl(i);a=f.protocol===d.protocol&&f.hostname===d.hostname&&f.port===d.port,u=m.OUtil.getHostnamePortionForLogging(f.hostname),a?p=u:(p=m.OUtil.getHostnamePortionForLogging(d.hostname),s=m.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(o,i),c=m.XdmCommunicationManager.isTargetSubdomainOfSourceLocation(i,o));var h=m._OfficeAppFactory.getOfficeAppContext().get_appDomains();l=m.XdmCommunicationManager.checkUrlWithAppDomains(h,o)}var g="openDialog isInline: "+e[m.ShowWindowDialogParameterKeys.DisplayInIframe].toString()+", taskpaneHostname: "+p+", dialogHostName: "+u+", isSameDomain: "+a.toString()+", parentIsSubdomain: "+s.toString()+", childIsSubdomain: "+c.toString()+", isAppDomain: "+l.toString();m.AppTelemetry.logAppCommonMessage(g)}null!=o&&"https://"===o.substr(0,"https://".length)?e[m.ShowWindowDialogParameterKeys.DisplayInIframe]?(m.DialogShownStatus.isWindowDialog=!1,m.WACDelegate.registerEventAsync(t)):(m.DialogShownStatus.isWindowDialog=!0,m.WacDialogAction.setHandlerAndShowDialogCallback(function(e){t.onEvent&&t.onEvent(e),m.AppTelemetry&&m.AppTelemetry.onEventDone(t.dispId)},r),m.WacDialogAction.handleNewWindowDialog(e)):"http://"===o.substr(0,"http://".length)?r(12005):r(12003)}},y.validateTaskpaneDomain=function(e,t){return m.WacDialogAction.validateTaskpaneDomain(e,t)},y.messageParent=function(e){var t=e.hostCallArgs.targetOrigin,n=!!t;if(n&&"*"!=t){var r=m.WacDialogAction.getLocalStorage(),o=m.WacDialogAction.getSessionStorage(),i="_trusts_",a=m.OUtil.parseUrl(t,!0);i+=a.protocol+"//"+a.hostname+(a.port?":"+a.port:""),m.WacDialogAction.setWithExpiry(r,i,"true"),m.WacDialogAction.setWithExpiry(o,i,"true")}if(null!=window.opener){if(!n){var s=m._OfficeAppFactory.getOfficeAppContext().get_taskpaneUrl();if(s){if(!m.WacDialogAction.validateTaskpaneDomain(s,!0)){var c="messageParent called but the taskpane domain is untrusted: "+s;throw m.AppTelemetry&&m.AppTelemetry.logAppException(c),new Error(c)}}else s=window.location.origin;e.hostCallArgs.targetOrigin=s}m.WacDialogAction.messageParent(e)}else{var l=window.location.origin;l=l||window.location.protocol+"//"+window.location.hostname+(window.location.port?":"+window.location.port:""),n||(e.hostCallArgs.targetOrigin=l),m.WACDelegate.executeAsync(e)}},y.sendMessage=function(e){m.DialogShownStatus.hasDialogShown&&(m.DialogShownStatus.isWindowDialog?m.WacDialogAction.sendMessage(e):m.WACDelegate.executeAsync(e))},y.closeDialog=function(e){var n=y.getOnAfterRegisterEvent(!1,e);function t(e){var t={Error:e};try{n(0,t)}catch(e){m.AppTelemetry&&m.AppTelemetry.logAppException("Exception happens at closeDialogCallback."+e)}}m.DialogShownStatus.hasDialogShown?m.DialogShownStatus.isWindowDialog?(e.onCalling&&e.onCalling(),m.WacDialogAction.closeDialog(t)):m.WACDelegate.unregisterEventAsync(e):t(12006)}}(OSF=OSF||{}),function(t){t.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){},defineSafeArrayParameterMapFunc:function(){t.HostParameterMap.define({type:t.EventDispId.dispidDocumentSelectionChangedEvent})},defineWebParameterMapFunc:function(){t.HostParameterMap.define({type:t.EventDispId.dispidDocumentSelectionChangedEvent})},initializeFunc:function(){var e=Office.context.document;t.DispIdHost.addEventSupport(e,new t.EventDispatch([t.EventType.DocumentSelectionChanged,t.EventType.ActiveViewChanged]))}})}(OSF=OSF||{}),function(e){e.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){e.AsyncMethodCalls.define({method:e.AsyncMethods.AddHandlerAsync,requiredArguments:[{name:e.ParameterNames.EventType,enum:e.EventType,verify:function(e,t,n){return n.supportsEvent(e)}},{name:e.ParameterNames.Handler,types:["function"]}],supportedOptions:[],privateStateCallbacks:[]}),e.AsyncMethodCalls.define({method:e.AsyncMethods.RemoveHandlerAsync,requiredArguments:[{name:e.ParameterNames.EventType,enum:e.EventType,verify:function(e,t,n){return n.supportsEvent(e)}}],supportedOptions:[{name:e.ParameterNames.Handler,value:{types:["function","object"],defaultValue:null}}],privateStateCallbacks:[]})}})}(OSF=OSF||{}),function(t){var e;function n(){t.HostParameterMap.define({type:t.PropertyDescriptors.FeatureProperties,fromHost:[{name:t.PropertyDescriptors.TcidEnabled,value:0},{name:t.PropertyDescriptors.TcidVisible,value:1}],isComplexType:!0}),t.HostParameterMap.define({type:146,toHost:[{name:t.ParameterNames.Tcid,value:0}]}),t.HostParameterMap.define({type:147,fromHost:[{name:t.PropertyDescriptors.FeatureProperties,value:t.HostParameterMap.self}],toHost:[{name:t.ParameterNames.Tcid,value:0}]})}(e=t.PropertyDescriptors||(t.PropertyDescriptors={})).FeatureProperties="FeatureProperties",e.TcidEnabled="TcidEnabled",e.TcidVisible="TcidVisible",t.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){t.AsyncMethodCalls.define({method:t.AsyncMethods.ExecuteFeature,requiredArguments:[{name:t.ParameterNames.Tcid,types:["number"]}],privateStateCallbacks:[]}),t.AsyncMethodCalls.define({method:t.AsyncMethods.QueryFeature,requiredArguments:[{name:t.ParameterNames.Tcid,types:["number"]}],privateStateCallbacks:[]})},defineSafeArrayParameterMapFunc:n,defineWebParameterMapFunc:n,initializeFunc:function(){var e=Office.context.ui;t.DispIdHost.addAsyncMethods(e,[t.AsyncMethods.ExecuteFeature]),t.DispIdHost.addAsyncMethods(e,[t.AsyncMethods.QueryFeature])}})}(OSF=OSF||{}),function(e){var t,n;((t=e.context||(e.context={})).extensionLifeCycle||(t.extensionLifeCycle={})).launchExtensionComponent=function(e,t,n,r,o){var i=OSF.OUtil.Guid.generateNewGuid();null==o&&(o={OptionalProperties:{},DevProperties:{}}),o.OptionalProperties.InstanceToken=i;var a={ExtId:e,ComponentType:t,ComponentId:n,HostProps:r,OptionalProps:o};if(OSF._OfficeAppFactory.getHostInfo().hostPlatform!=OSF.HostInfoPlatform.web)throw OSF.Utility.createNotImplementedException();var s=OSF._OfficeAppFactory.getWebAppState();return s.clientEndPoint.invoke("ContextActivationManager_notifyHost",null,[s.id,OSF.AgaveHostAction.LaunchExtensionComponent,a]),{Id:e,ComponentType:t,ComponentId:n,InstanceToken:i,LaunchProperties:o}},(n=e.ExtensionLifeCycle||(e.ExtensionLifeCycle={})).close=function(e){OSF._OfficeAppFactory.getClientHostController().closeSdxDialog(e)},n.resize=function(e,t){OSF.Utility.isNullOrUndefined(e)||OSF.Utility.isNullOrUndefined(t)||"number"!=typeof e||"number"!=typeof t?OSF.Utility.debugLog("Invaid dialog width or height. Kindly provide two numbers as input parameters."):OSF._OfficeAppFactory.getClientHostController().resizeSdxDialog(e,t)}}(Office=Office||{}),function(e){var t=(Object.defineProperty(n.prototype,"size",{get:function(){return this.m_fileSize},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"sliceCount",{get:function(){return Math.ceil(this.m_fileSize/this.m_sliceSize)},enumerable:!0,configurable:!0}),n.prototype.getSliceAsync=function(e,t){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.GetDocumentCopyChunkAsync,arguments,this,this.m_privateState)},n.prototype.closeAsync=function(e){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.ReleaseDocumentCopyAsync,arguments,this,this.m_privateState)},n);function n(e,t,n){this.m_fileSize=t,this.m_sliceSize=n,this.m_privateState={},this.m_privateState[OSF.FileProperties.Handle]=e,this.m_privateState[OSF.FileProperties.SliceSize]=n}e.File=t}(Office=Office||{}),function(r){var e;((e=r.context||(r.context={})).document||(e.document={})).getFileAsync=function(e,t,n){OSF.DispIdHost.InvokeMethod(OSF.AsyncMethods.GetDocumentCopyAsync,arguments,r.context.document,void 0)}}(Office=Office||{}),function(o){var e,t,n,r,i,a,s,c;(e=o.PropertyDescriptors||(o.PropertyDescriptors={})).FileProperties="FileProperties",e.FileSliceProperties="FileSliceProperties",(t=o.FileProperties||(o.FileProperties={})).Handle="FileHandle",t.FileSize="FileSize",t.SliceSize="sliceSize",(o.additionalParameter||(o.additionalParameter={})).FileSliceOffset="fileSliceoffset",n=o.Marshaling||(o.Marshaling={}),r=n.File||(n.File={}),(i=r.FilePropertiesKeys||(r.FilePropertiesKeys={}))[i.Handle=0]="Handle",i[i.FileSize=1]="FileSize",(a=r.SlicePropertiesKeys||(r.SlicePropertiesKeys={}))[a.Data=0]="Data",a[a.SliceSize=1]="SliceSize",(s=r.FileType||(r.FileType={}))[s.Text=0]="Text",s[s.Compressed=1]="Compressed",s[s.Pdf=2]="Pdf",(c=r.ParameterKeys||(r.ParameterKeys={}))[c.FileType=0]="FileType",c[c.SliceSize=1]="SliceSize",c[c.Handle=2]="Handle",c[c.SliceIndex=3]="SliceIndex",o.File||(o.File={}),o.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){o.AsyncMethodCalls.define({method:o.AsyncMethods.GetDocumentCopyAsync,requiredArguments:[{name:o.ParameterNames.FileType,enum:Office.FileType}],supportedOptions:[{name:o.ParameterNames.SliceSize,value:{types:["number"],defaultValue:o.OUtil.getHostPlatform()==o.HostInfoPlatform.ios?65536:4194304}}],checkCallArgs:function(e,t,n){var r=e[o.ParameterNames.SliceSize];if(r<=0||4194304<r)throw 11002;return e},onSucceeded:function(e,t,n){return new Office.File(e[o.FileProperties.Handle],e[o.FileProperties.FileSize],n[o.ParameterNames.SliceSize])}}),o.AsyncMethodCalls.define({method:o.AsyncMethods.GetDocumentCopyChunkAsync,requiredArguments:[{name:o.ParameterNames.SliceIndex,types:["number"]}],privateStateCallbacks:[{name:o.FileProperties.Handle,value:function(e,t){return t[o.FileProperties.Handle]}},{name:o.FileProperties.SliceSize,value:function(e,t){return t[o.FileProperties.SliceSize]}}],checkCallArgs:function(e,t,n){var r=e[o.ParameterNames.SliceIndex];if(r<0||r>=t.sliceCount)throw 5008;return e[o.additionalParameter.FileSliceOffset]=parseInt((r*n[o.FileProperties.SliceSize]).toString()),e},onSucceeded:function(e,t,n){var r={};return o.OUtil.defineEnumerableProperties(r,{data:{value:o.OUtil.getHostPlatform()==o.HostInfoPlatform.mac?o.OUtil.shallowCopy(e[o.ParameterNames.Data]):e[o.ParameterNames.Data]},index:{value:n[o.ParameterNames.SliceIndex]},size:{value:e[o.FileProperties.SliceSize]}}),r}}),o.AsyncMethodCalls.define({method:o.AsyncMethods.ReleaseDocumentCopyAsync,privateStateCallbacks:[{name:o.FileProperties.Handle,value:function(e,t){return t[o.FileProperties.Handle]}}]})},defineSafeArrayParameterMapFunc:function(){o.HostParameterMap.define({type:o.PropertyDescriptors.FileProperties,fromHost:[{name:o.FileProperties.Handle,value:0},{name:o.FileProperties.FileSize,value:1}],isComplexType:!0}),o.HostParameterMap.define({type:o.PropertyDescriptors.FileSliceProperties,fromHost:[{name:o.ParameterNames.Data,value:0},{name:o.FileProperties.SliceSize,value:1}],isComplexType:!0}),o.HostParameterMap.define({type:o.ParameterNames.FileType,toHost:[{name:Office.FileType.Text,value:0},{name:Office.FileType.Compressed,value:5},{name:Office.FileType.Pdf,value:6}]}),o.HostParameterMap.define({type:77,toHost:[{name:o.ParameterNames.FileType,value:0}],fromHost:[{name:o.PropertyDescriptors.FileProperties,value:o.HostParameterMap.self}]}),o.HostParameterMap.define({type:80,toHost:[{name:o.FileProperties.Handle,value:0},{name:o.additionalParameter.FileSliceOffset,value:1},{name:o.FileProperties.SliceSize,value:2}],fromHost:[{name:o.PropertyDescriptors.FileSliceProperties,value:o.HostParameterMap.self}]}),o.HostParameterMap.define({type:81,toHost:[{name:o.FileProperties.Handle,value:0}]})},defineWebParameterMapFunc:function(){o.HostParameterMap.addComplexType(o.PropertyDescriptors.FileProperties),o.HostParameterMap.addComplexType(o.PropertyDescriptors.FileSliceProperties),o.HostParameterMap.define({type:o.PropertyDescriptors.FileProperties,fromHost:[{name:o.FileProperties.Handle,value:o.Marshaling.File.FilePropertiesKeys.Handle},{name:o.FileProperties.FileSize,value:o.Marshaling.File.FilePropertiesKeys.FileSize}]}),o.HostParameterMap.define({type:o.PropertyDescriptors.FileSliceProperties,fromHost:[{name:o.ParameterNames.Data,value:o.Marshaling.File.SlicePropertiesKeys.Data},{name:o.FileProperties.SliceSize,value:o.Marshaling.File.SlicePropertiesKeys.SliceSize}]}),o.HostParameterMap.define({type:o.ParameterNames.FileType,toHost:[{name:Office.FileType.Text,value:o.Marshaling.File.FileType.Text},{name:Office.FileType.Compressed,value:o.Marshaling.File.FileType.Compressed},{name:Office.FileType.Pdf,value:o.Marshaling.File.FileType.Pdf}]}),o.HostParameterMap.define({type:77,toHost:[{name:o.ParameterNames.FileType,value:o.Marshaling.File.ParameterKeys.FileType},{name:o.ParameterNames.SliceSize,value:o.Marshaling.File.ParameterKeys.SliceSize}],fromHost:[{name:o.PropertyDescriptors.FileProperties,value:o.HostParameterMap.self}]}),o.HostParameterMap.define({type:80,toHost:[{name:o.FileProperties.Handle,value:o.Marshaling.File.ParameterKeys.Handle},{name:o.ParameterNames.SliceIndex,value:o.Marshaling.File.ParameterKeys.SliceIndex}],fromHost:[{name:o.PropertyDescriptors.FileSliceProperties,value:o.HostParameterMap.self}]}),o.HostParameterMap.define({type:81,toHost:[{name:o.FileProperties.Handle,value:o.Marshaling.File.ParameterKeys.Handle}]})}})}(OSF=OSF||{}),(OfficeExt||(OfficeExt={})).FileProperties=function(e){OSF.OUtil.defineEnumerableProperties(this,{url:{value:e[OSF.FilePropertiesDescriptor.Url]}})},function(t){var e,n;t.FilePropertiesDescriptor={Url:"Url"},(t.PropertyDescriptors||(t.PropertyDescriptors={})).FilePropertiesDescriptor="FilePropertiesDescriptor",e=t.Marshaling||(t.Marshaling={}),(n=e.FilePropertiesKeys||(e.FilePropertiesKeys={}))[n.Properties=0]="Properties",n[n.Url=1]="Url",t.FileProperties||(t.FileProperties={}),t.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){t.AsyncMethodCalls.define({method:t.AsyncMethods.GetFilePropertiesAsync,fromHost:[{name:t.PropertyDescriptors.FilePropertiesDescriptor,value:0}],requiredArguments:[],supportedOptions:[],onSucceeded:function(e,t,n){return new OfficeExt.FileProperties(e)}})},defineSafeArrayParameterMapFunc:function(){t.HostParameterMap.define({type:t.PropertyDescriptors.FilePropertiesDescriptor,fromHost:[{name:t.FilePropertiesDescriptor.Url,value:0}],isComplexType:!0}),t.HostParameterMap.define({type:86,fromHost:[{name:t.PropertyDescriptors.FilePropertiesDescriptor,value:t.HostParameterMap.self}]})},defineWebParameterMapFunc:function(){t.HostParameterMap.addComplexType(t.PropertyDescriptors.FilePropertiesDescriptor),t.HostParameterMap.define({type:t.PropertyDescriptors.FilePropertiesDescriptor,fromHost:[{name:t.FilePropertiesDescriptor.Url,value:t.Marshaling.FilePropertiesKeys.Url}]}),t.HostParameterMap.define({type:86,fromHost:[{name:t.PropertyDescriptors.FilePropertiesDescriptor,value:t.Marshaling.FilePropertiesKeys.Properties}]})},initializeFunc:function(){var e=Office.context.document;t.DispIdHost.addAsyncMethods(e,[t.AsyncMethods.GetFilePropertiesAsync])}})}(OSF=OSF||{}),function(s){var e,t;function c(e){var t=0;switch(e){case s.CoercionType.Text:t=0;break;case s.CoercionType.Matrix:t=1;break;case s.CoercionType.Table:t=2;break;case s.CoercionType.Html:t=3;break;case s.CoercionType.Ooxml:t=4;break;case s.CoercionType.OoxmlPackage:t=5;break;case s.CoercionType.PdfFile:t=6;break;case s.CoercionType.SlideRange:t=7;break;case"image":t=8;break;case"xmlSvg":t=9}return t}e=s.context||(s.context={}),(t=e.document||(e.document={})).setSelectedDataAsync=function(t,n,e){var r=null==n.coercionType?OSF.DataCoercion.determineCoercionType(t):n.coercionType;"function"==typeof n&&(e=n);var o={toSafeArrayHost:function(){var e=OSF._OfficeAppFactory.getHostInfo();return e.hostType.toLowerCase()==s.HostType.Word.toLowerCase()||e.hostType.toLowerCase()==s.HostType.PowerPoint.toLowerCase()||e.hostType.toLowerCase()==s.HostType.OneNote.toLowerCase()||e.hostType.toLowerCase()==s.HostType.Visio.toLowerCase()||"image"==r||"xmlSvg"==r?[c(r),OSF.DataCoercion.serializeDynamicData(t),null!=n.imageLeft&&n.imageLeft,null!=n.imageTop&&n.imageTop,null!=n.imageWidth&&n.imageWidth,null!=n.imageHeight&&n.imageHeight]:e.hostType.toLowerCase()==s.HostType.Excel.toLowerCase()?[c(r),OSF.DataCoercion.serializeDynamicData(t),null==n.cellFormat?[]:n.cellFormat,null==n.tableOptions?[]:n.tableOptions,null!=n.imageWidth&&n.imageWidth,null!=n.imageHeight&&n.imageHeight]:[c(r),OSF.DataCoercion.serializeDynamicData(t),null==n.cellFormat?[]:n.cellFormat,null==n.tableOptions?[]:n.tableOptions]},fromSafeArrayHost:function(e){return e},toWebHost:function(){return{DdaSetBindingData:{CoerceType:r,Data:OSF.DataCoercion.serializeDynamicData(t),CellFormat:[],TableOptions:[]}}},fromWebHost:function(e){return e}};OSF._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(65,o,e,null)},t.getSelectedDataAsync=function(t,e,n){var r,o=s.ValueFormat.Unformatted,i=s.FilterType.All;"function"==typeof e?n=e:void 0!==e&&(void 0!==e.valueFormat&&(o=e.valueFormat),void 0!==e.filterType&&(i=e.filterType),void 0!==e.asyncContext&&(r=e.asyncContext));var a={toSafeArrayHost:function(){return[c(t),function(e){var t=0;switch(e){case s.ValueFormat.Unformatted:t=0;break;case s.ValueFormat.Formatted:t=1}return t}(o),function(e){var t=0;switch(e){case s.FilterType.All:t=0;break;case s.FilterType.OnlyVisible:t=1}return t}(i)]},fromSafeArrayHost:function(e){return OSF.DataCoercion.deserializeDynamicData(e,t)},toWebHost:function(){return{DdaGetBindingData:{CoerceType:t,ValueFormat:o,FilterType:i}}},fromWebHost:function(e){return OSF.DataCoercion.deserializeDynamicData(e.Data,t)}};OSF._OfficeAppFactory.getAsyncMethodExecutor().executeAsync(64,a,n,r)}}(Office=Office||{}),function(u){u.SlideProperties={Id:0,Title:1,Index:2};var e=(Object.defineProperty(t.prototype,"id",{get:function(){return this.m_id},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"title",{get:function(){return this.m_title},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"index",{get:function(){return this.m_index},enumerable:!0,configurable:!0}),t);function t(e,t,n){this.m_id=e,this.m_title=t,this.m_index=n}u.Slide=e;var n=(Object.defineProperty(r.prototype,"slides",{get:function(){return this.m_slides},enumerable:!0,configurable:!0}),r);function r(e){this.m_slides=e}u.SlideRange=n,u.manufactureSlideRange=function(e){var t=JSON.parse(e);if(null==t)return null;var n=0;for(var r in u.SlideProperties)u.SlideProperties.hasOwnProperty(r)&&n++;for(var o=[],i=!0,a=0;a<t.length&&i;a++)if(i=!1,t[a].length==n){var s=parseInt(t[a][u.SlideProperties.Id]),c=t[a][u.SlideProperties.Title],l=parseInt(t[a][u.SlideProperties.Index]);isNaN(s)||isNaN(l)||(i=!0,o.push(new u.Slide(s,c,l)))}return i?new u.SlideRange(o):null}}(OSF=OSF||{}),function(t){var e=(Object.defineProperty(n.prototype,"headers",{get:function(){return this._header},set:function(e){this._header=this.fixData(e)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"rows",{get:function(){return this._rows},set:function(e){this._rows=null==e||OSF.OUtil.isArray(e)&&0==e.length?[]:this.fixData(e)},enumerable:!0,configurable:!0}),n.prototype.fixData=function(e){if(null==e||null==e)return null;try{for(var t=OSF.DataCoercion.findArrayDimensionality(e);t<2;t++)e=[e];return e}catch(e){}},n);function n(e,t){this._rows=e,this._header=t}t.TableData=e,t.manufactureTableData=function(e){return new t.TableData(e[OSF.TableDataProperties.TableRows],e[OSF.TableDataProperties.TableHeaders])}}(Office=Office||{}),function(e){e.BootStrapExtension.prepareApiSurface=function(){return new Promise(function(){e.V10ApiFeatureRegistry.initialize()})}}(OSF=OSF||{}),function(a){var e;(function(r){var e;(e=r.EventDescriptors||(r.EventDescriptors={})).OfficeThemeChangedEvent="OfficeThemeChangedEvent",e.DocumentThemeChangedEvent="DocumentThemeChangedEvent",a.V10ApiFeatureRegistry.register({defineMethodsFunc:function(){a.AsyncMethodCalls.define({method:a.AsyncMethods.GetDocumentThemeAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[],onSucceeded:a.DDA.Theming.ConvertToDocumentTheme}),a.AsyncMethodCalls.define({method:a.AsyncMethods.GetOfficeThemeAsync,requiredArguments:[],supportedOptions:[],privateStateCallbacks:[],onSucceeded:a.DDA.Theming.ConvertToOfficeTheme})},defineSafeArrayParameterMapFunc:function(){a.HostParameterMap.define({type:85,fromHost:[{name:a.ParameterNames.OfficeTheme,value:a.HostParameterMap.self}]}),a.HostParameterMap.define({type:a.ParameterNames.OfficeTheme,fromHost:[{name:a.DDA.Theming.OfficeThemeEnum.BodyForegroundColor,value:0},{name:a.DDA.Theming.OfficeThemeEnum.BodyBackgroundColor,value:1},{name:a.DDA.Theming.OfficeThemeEnum.ControlForegroundColor,value:2},{name:a.DDA.Theming.OfficeThemeEnum.ControlBackgroundColor,value:3},{name:a.DDA.Theming.OfficeThemeEnum.ThemeId,value:4}],isComplexType:!0}),a.HostParameterMap.define({type:a.EventDispId.dispidOfficeThemeChangedEvent,fromHost:[{name:a.DDA.Theming.EventDescriptors.OfficeThemeChangedEvent,value:a.HostParameterMap.self}],isComplexType:!0}),a.HostParameterMap.define({type:a.DDA.Theming.EventDescriptors.OfficeThemeChangedEvent,fromHost:[{name:a.ParameterNames.OfficeTheme,value:a.HostParameterMap.self}],isComplexType:!0})},defineWebParameterMapFunc:function(){a.HostParameterMap.addComplexType(a.ParameterNames.DocumentTheme),a.HostParameterMap.addComplexType(a.ParameterNames.OfficeTheme),a.HostParameterMap.define({type:a.EventDispId.dispidOfficeThemeChangedEvent,fromHost:[{name:a.ParameterNames.OfficeTheme,value:a.HostParameterMap.self}]}),a.HostParameterMap.define({type:a.ParameterNames.OfficeTheme,fromHost:[{name:a.DDA.Theming.OfficeThemeEnum.BodyForegroundColor,value:a.DDA.Theming.OfficeThemeEnumWac.PrimaryFontColor},{name:a.DDA.Theming.OfficeThemeEnum.BodyBackgroundColor,value:a.DDA.Theming.OfficeThemeEnumWac.PrimaryBackgroundColor},{name:a.DDA.Theming.OfficeThemeEnum.ControlForegroundColor,value:a.DDA.Theming.OfficeThemeEnumWac.SecondaryFontColor},{name:a.DDA.Theming.OfficeThemeEnum.ControlBackgroundColor,value:a.DDA.Theming.OfficeThemeEnumWac.SecondaryBackgroundColor}],isComplexType:!0})},initializeFunc:function(){var e=a._OfficeAppFactory.getHostInfo(),t=e.hostType.toLowerCase();if(e.hostPlatform==a.HostInfoPlatform.web&&(t==Office.HostType.Word.toLowerCase()||t==Office.HostType.PowerPoint.toLowerCase())&&Office.context.officeTheme){var n=r.GetIsDarkThemeFromCSSHexColor(Office.context.officeTheme.bodyBackgroundColor);Office.context.officeTheme[a.DDA.Theming.OfficeThemeEnum.IsDarkTheme]=n,Office.context.officeTheme[a.DDA.Theming.OfficeThemeEnum.ThemeId]=n?a.DDA.Theming.ThemeId.Black:a.DDA.Theming.ThemeId.White}Office.context&&Office.context.themeManager&&Office.context.themeManager.InitializeAndChangeOnce()}});var t=(n.prototype.InitializeThemeManager=function(){this._eventTarget=this,a.DispIdHost.addAsyncMethods(this,[a.AsyncMethods.GetOfficeThemeAsync,a.AsyncMethods.GetDocumentThemeAsync]),a.DispIdHost.addEventSupport(this,new a.EventDispatch([Microsoft.Office.WebExtension.EventType.OfficeThemeChanged,Microsoft.Office.WebExtension.EventType.DocumentThemeChanged]))},n.prototype.InitializeAndChangeOnce=function(e){var t=this;this._officeCss=this._getOfficeThemesCss(),this._officeCss?(this._onAsyncCallsCompleted=e,this._asyncCallsCompleted={},this._asyncCallsCompleted[a.AsyncMethods.GetOfficeThemeAsync]=!1,this._asyncCallsCompleted[a.AsyncMethods.GetDocumentThemeAsync]=!1,this._getAndProcessThemeData(this._eventTarget.getOfficeThemeAsync,function(e){t._processOfficeThemeData(e)},a.AsyncMethods.GetOfficeThemeAsync)):e&&e()},n.prototype.isDarkTheme=function(){var e=!1;if(Office.context&&Office.context.officeTheme&&Office.context.officeTheme.bodyBackgroundColor){var t=Office.context.officeTheme.bodyBackgroundColor;e=r.GetIsDarkThemeFromCSSHexColor(t)}return e},n.prototype._getOfficeThemesCss=function(){try{return function(){for(var e="officethemes.css",t=0;t<document.styleSheets.length;t++){var n=document.styleSheets[t];if(!n.disabled&&n.href&&e==n.href.substring(n.href.length-e.length,n.href.length).toLowerCase())return n.cssRules||n.rules?n:(a.AppTelemetry&&a.AppTelemetry.logAppException("Browser styleSheet object does not implement cssRules or rules property. Viloates browser's css access rule"),null)}}()}catch(e){return a.AppTelemetry&&a.AppTelemetry.logAppException("Exception thrown when trying to read officethems.css:["+e+"]"),null}},n.prototype._changeCss=function(e,t,n){for(var r=e.cssRules?e.cssRules.length:e.rules.length,o=0;o<r;o++){var i=(e.cssRules?e.cssRules[o]:e.rules[o]).selectorText;i&&i.toLowerCase()==t.toLowerCase()&&(e.cssRules?(e.deleteRule(o),e.insertRule(i+n,o)):(e.removeRule(o),e.addRule(i,n,o)))}},n.prototype._changeDocumentThemeData=function(e){for(var t=[{name:a.DDA.Theming.DocumentThemeEnum.PrimaryFontColor,cssSelector:".office-docTheme-primary-fontColor",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.PrimaryBackgroundColor,cssSelector:".office-docTheme-primary-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.DocumentThemeEnum.SecondaryFontColor,cssSelector:".office-docTheme-secondary-fontColor",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.SecondaryBackgroundColor,cssSelector:".office-docTheme-secondary-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent1,cssSelector:".office-contentAccent1-color",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent2,cssSelector:".office-contentAccent2-color",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent3,cssSelector:".office-contentAccent3-color",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent4,cssSelector:".office-contentAccent4-color",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent5,cssSelector:".office-contentAccent5-color",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent6,cssSelector:".office-contentAccent6-color",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent1,cssSelector:".office-contentAccent1-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent2,cssSelector:".office-contentAccent2-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent3,cssSelector:".office-contentAccent3-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent4,cssSelector:".office-contentAccent4-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent5,cssSelector:".office-contentAccent5-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent6,cssSelector:".office-contentAccent6-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent1,cssSelector:".office-contentAccent1-borderColor",cssProperty:"border-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent2,cssSelector:".office-contentAccent2-borderColor",cssProperty:"border-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent3,cssSelector:".office-contentAccent3-borderColor",cssProperty:"border-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent4,cssSelector:".office-contentAccent4-borderColor",cssProperty:"border-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent5,cssSelector:".office-contentAccent5-borderColor",cssProperty:"border-color"},{name:a.DDA.Theming.DocumentThemeEnum.Accent6,cssSelector:".office-contentAccent6-borderColor",cssProperty:"border-color"},{name:a.DDA.Theming.DocumentThemeEnum.Hyperlink,cssSelector:".office-a",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.FollowedHyperlink,cssSelector:".office-a:visited",cssProperty:"color"},{name:a.DDA.Theming.DocumentThemeEnum.HeaderLatinFont,cssSelector:".office-headerFont-latin",cssProperty:"font-family"},{name:a.DDA.Theming.DocumentThemeEnum.HeaderEastAsianFont,cssSelector:".office-headerFont-eastAsian",cssProperty:"font-family"},{name:a.DDA.Theming.DocumentThemeEnum.HeaderScriptFont,cssSelector:".office-headerFont-script",cssProperty:"font-family"},{name:a.DDA.Theming.DocumentThemeEnum.HeaderLocalizedFont,cssSelector:".office-headerFont-localized",cssProperty:"font-family"},{name:a.DDA.Theming.DocumentThemeEnum.BodyLatinFont,cssSelector:".office-bodyFont-latin",cssProperty:"font-family"},{name:a.DDA.Theming.DocumentThemeEnum.BodyEastAsianFont,cssSelector:".office-bodyFont-eastAsian",cssProperty:"font-family"},{name:a.DDA.Theming.DocumentThemeEnum.BodyScriptFont,cssSelector:".office-bodyFont-script",cssProperty:"font-family"},{name:a.DDA.Theming.DocumentThemeEnum.BodyLocalizedFont,cssSelector:".office-bodyFont-localized",cssProperty:"font-family"}],n=e.type==a.EventType.DocumentThemeChanged?e.documentTheme:e,r=0;r<t.length;r++)if(null===this._previousDocumentThemeData||this._previousDocumentThemeData[t[r].name]!=n[t[r].name])if(null!=n[t[r].name]&&""!=n[t[r].name]){var o=n[t[r].name];"font-family"===t[r].cssProperty&&(o='"'+o.replace(new RegExp('"',"g"),'\\"')+'"'),this._changeCss(this._officeCss,t[r].cssSelector,"{"+t[r].cssProperty+":"+o+";}")}else this._changeCss(this._officeCss,t[r].cssSelector,"{}");this._previousDocumentThemeData=n},n.prototype._changeOfficeThemeData=function(e){for(var t=[{name:a.DDA.Theming.OfficeThemeEnum.BodyForegroundColor,cssSelector:".office-officeTheme-primary-fontColor",cssProperty:"color"},{name:a.DDA.Theming.OfficeThemeEnum.BodyBackgroundColor,cssSelector:".office-officeTheme-primary-bgColor",cssProperty:"background-color"},{name:a.DDA.Theming.OfficeThemeEnum.ControlForegroundColor,cssSelector:".office-officeTheme-secondary-fontColor",cssProperty:"color"},{name:a.DDA.Theming.OfficeThemeEnum.ControlBackgroundColor,cssSelector:".office-officeTheme-secondary-bgColor",cssProperty:"background-color"}],n=e.type==a.EventType.OfficeThemeChanged?e.officeTheme:e,r=0;r<t.length;r++)null!==this._previousOfficeThemeData&&this._previousOfficeThemeData[t[r].name]==n[t[r].name]||void 0!==n[t[r].name]&&this._changeCss(this._officeCss,t[r].cssSelector,"{"+t[r].cssProperty+":"+n[t[r].name]+";}");this._previousOfficeThemeData=n},n.prototype._getAndProcessThemeData=function(e,n,r){var o=this,t=a._OfficeAppFactory.getHostInfo();if(t&&t.hostPlatform==a.HostInfoPlatform.web){if(r==a.AsyncMethods.GetOfficeThemeAsync&&Office.context.officeTheme){var i={};i[a.DDA.Theming.OfficeThemeEnum.BodyBackgroundColor]=Office.context.officeTheme.bodyBackgroundColor,i[a.DDA.Theming.OfficeThemeEnum.BodyForegroundColor]=Office.context.officeTheme.bodyForegroundColor,i[a.DDA.Theming.OfficeThemeEnum.ControlBackgroundColor]=Office.context.officeTheme.controlBackgroundColor,i[a.DDA.Theming.OfficeThemeEnum.ControlForegroundColor]=Office.context.officeTheme.controlForegroundColor,i[a.DDA.Theming.OfficeThemeEnum.IsDarkTheme]=Office.context.officeTheme.isDarkTheme,i[a.DDA.Theming.OfficeThemeEnum.ThemeId]=Office.context.officeTheme.isDarkTheme?a.DDA.Theming.ThemeId.Black:a.DDA.Theming.ThemeId.White,n(i)}}else e(function(e){if("succeeded"==e.status){var t=e.value;n(t)}o._areAllCallsCompleted(r)&&o._onAsyncCallsCompleted&&(o._onAsyncCallsCompleted(),o._onAsyncCallsCompleted=null)})},n.prototype._processOfficeThemeData=function(e){var t=this;this._changeOfficeThemeData(e),this._eventTarget.addHandlerAsync(Microsoft.Office.WebExtension.EventType.OfficeThemeChanged,function(e){t._changeOfficeThemeData(e)},null)},n.prototype._processDocumentThemeData=function(e){var t=this;this._changeDocumentThemeData(e),this._eventTarget.addHandlerAsync(Microsoft.Office.WebExtension.EventType.DocumentThemeChanged,function(e){t._changeDocumentThemeData(e)},null)},n.prototype._areAllCallsCompleted=function(e){var t;if(!(t=this._asyncCallsCompleted))return!0;for(var n in e&&t.hasOwnProperty(e)&&(t[e]=!0),t)if(!t.hasOwnProperty(n)||!t[n])return!1;return!0},n);function n(){this._eventTarget=null,this._previousDocumentThemeData=null,this._previousOfficeThemeData=null,this._officeCss=null,this._asyncCallsCompleted=null,this._onAsyncCallsCompleted=null}r.InternalThemeHandler=t})((e=a.DDA||(a.DDA={})).Theming||(e.Theming={}))}(OSF=OSF||{}),function(e){var t,n;t=e.context||(e.context={}),OSF.definePropertyOnNamespace(t,"themeManager",function(){return n||(n=new OSF.DDA.Theming.InternalThemeHandler).InitializeThemeManager(),n})}(Office=Office||{}),(OSF||(OSF={})).BootStrapExtension.prepareHostSpecificSurface=function(){},function(e){if(!function(){try{return"object"==typeof process&&"[object process]"===String(process)}catch(e){return}}()&&!e.isOfficeReactNative()){try{e.Flights=e.OUtil.parseFlights(!0),e.DisabledChangeGates=e.OUtil.parseDisabledChangeGates(!0)}catch(e){}function t(){OSFPerformance.hostSpecificFileName=e.LoadScriptHelper.getHostBundleJsName(),Office.onReadyInternal(function(){OSFPerfUtil.sendPerformanceTelemetry()}),e._OfficeAppFactory.getHostInfo().hostLocale&&setTimeout(function(){e.OUtil.ensureOfficeStringsJs().catch(function(e){console.error(e)})},0)}e._OfficeAppFactory.bootstrap(function(){},function(e){e instanceof Error?console.warn(e.message):console.warn(JSON.stringify(e))}),"complete"===document.readyState||"interactive"===document.readyState?t():window.addEventListener("DOMContentLoaded",function(e){t()})}}(OSF=OSF||{}),OSFPerformance.hostInitializationEnd=OSFPerformance.now(),OSFPerformance.totalJSHeapSize=OSFPerformance.getTotalJSHeapSize(),OSFPerformance.usedJSHeapSize=OSFPerformance.getUsedJSHeapSize(),OSFPerformance.jsHeapSizeLimit=OSFPerformance.getJSHeapSizeLimit();