/// <reference types="node" />
import { URL } from 'url';
import { Readable } from 'stream';
import { Adapter, AdapterOption, Bucket, Domain, Object, SetObjectHeader, ObjectGetResult, ObjectHeader, ObjectInfo, TransferObject, PartialObjectError, BatchCallback, FrozenInfo, ListedObjects, ListObjectsOption, PutObjectOption, InitPartsOutput, UploadPartOutput, Part, GetObjectStreamOption } from './adapter';
export declare const USER_AGENT: string;
export declare class S3 implements Adapter {
    private readonly adapterOption;
    private readonly bucketNameToIdCache;
    private readonly bucketIdToNameCache;
    private readonly clients;
    private readonly bucketNameToIdCacheLock;
    private readonly clientsLock;
    private readonly kodo;
    private readonly regionService;
    constructor(adapterOption: AdapterOption);
    private getClient;
    fromKodoBucketNameToS3BucketId(bucketName: string): Promise<string>;
    fromS3BucketIdToKodoBucketName(bucketId: string): Promise<string>;
    private sendS3Request;
    createBucket(s3RegionId: string, bucket: string): Promise<void>;
    deleteBucket(s3RegionId: string, bucket: string): Promise<void>;
    getBucketLocation(bucket: string): Promise<string>;
    private _getBucketLocation;
    listBuckets(): Promise<Array<Bucket>>;
    listDomains(_s3RegionId: string, _bucket: string): Promise<Array<Domain>>;
    isExists(s3RegionId: string, object: Object): Promise<boolean>;
    deleteObject(s3RegionId: string, object: Object): Promise<void>;
    putObject(s3RegionId: string, object: Object, data: Buffer, originalFileName: string, header?: SetObjectHeader, option?: PutObjectOption): Promise<void>;
    getObject(s3RegionId: string, object: Object, _domain?: Domain): Promise<ObjectGetResult>;
    getObjectStream(s3RegionId: string, object: Object, _domain?: Domain, option?: GetObjectStreamOption): Promise<Readable>;
    getObjectURL(s3RegionId: string, object: Object, _domain?: Domain, deadline?: Date): Promise<URL>;
    getObjectInfo(s3RegionId: string, object: Object): Promise<ObjectInfo>;
    getObjectHeader(s3RegionId: string, object: Object, _domain?: Domain): Promise<ObjectHeader>;
    moveObject(s3RegionId: string, transferObject: TransferObject): Promise<void>;
    copyObject(s3RegionId: string, transferObject: TransferObject): Promise<void>;
    private getObjectStorageClass;
    moveObjects(s3RegionId: string, transferObjects: Array<TransferObject>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    copyObjects(s3RegionId: string, transferObjects: Array<TransferObject>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    deleteObjects(s3RegionId: string, bucket: string, keys: Array<string>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    getFrozenInfo(s3RegionId: string, object: Object): Promise<FrozenInfo>;
    unfreeze(s3RegionId: string, object: Object, days: number): Promise<void>;
    listObjects(s3RegionId: string, bucket: string, prefix: string, option?: ListObjectsOption): Promise<ListedObjects>;
    private _listObjects;
    createMultipartUpload(s3RegionId: string, object: Object, originalFileName: string, header?: SetObjectHeader): Promise<InitPartsOutput>;
    uploadPart(s3RegionId: string, object: Object, uploadId: string, partNumber: number, data: Buffer, option?: PutObjectOption): Promise<UploadPartOutput>;
    completeMultipartUpload(s3RegionId: string, object: Object, uploadId: string, parts: Array<Part>, _originalFileName: string, _header?: SetObjectHeader): Promise<void>;
    clearCache(): void;
}
//# sourceMappingURL=s3.d.ts.map