"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const process_1 = __importDefault(require("process"));
const fs_1 = __importDefault(require("fs"));
const chai_1 = require("chai");
const region_1 = require("../region");
process_1.default.on('uncaughtException', (err, origin) => {
    fs_1.default.writeSync(process_1.default.stderr.fd, `Caught exception: ${err}\n` +
        `Exception origin: ${origin}`);
    chai_1.assert.fail();
});
describe('Region', () => {
    context('Region query', () => {
        it('queries for https urls', async () => {
            const region = await region_1.Region.query({ accessKey: process_1.default.env.QINIU_ACCESS_KEY, bucketName: process_1.default.env.QINIU_TEST_BUCKET });
            chai_1.expect(region.id).to.equal('na0');
            chai_1.expect(region.s3Id).to.equal('us-north-1');
            chai_1.expect(region.s3Urls).to.eql(['https://s3-us-north-1.qiniucs.com/']);
        });
        it('queries for http urls', async () => {
            const region = await region_1.Region.query({ accessKey: process_1.default.env.QINIU_ACCESS_KEY, bucketName: process_1.default.env.QINIU_TEST_BUCKET, ucUrl: 'http://uc.qbox.me' });
            chai_1.expect(region.id).to.equal('na0');
            chai_1.expect(region.s3Id).to.equal('us-north-1');
            chai_1.expect(region.s3Urls).to.eql(['http://s3-us-north-1.qiniucs.com/']);
        });
    });
    context('Region getAll', () => {
        it('get for https urls', async () => {
            const regions = await region_1.Region.getAll({ accessKey: process_1.default.env.QINIU_ACCESS_KEY, secretKey: process_1.default.env.QINIU_SECRET_KEY });
            chai_1.expect(regions.map((r) => r.id)).to.have.members(['z0', 'z1', 'z2', 'as0', 'na0', 'fog-cn-east-1', 'cn-east-2']);
            regions.forEach((r) => {
                chai_1.expect(r.label).not.to.be.empty;
                chai_1.expect(r.translatedLabels['zh_CN']).not.to.be.empty;
                chai_1.expect(r.translatedLabels['ja_JP']).not.to.be.empty;
            });
        });
    });
});
//# sourceMappingURL=region.js.map