<?php
/**
 * html.class.php ɾ̬
 */
defined('IN_PHPCMS') or exit('No permission resources.');

class html {
	private $db, $type_db, $c_db, $data_db, $site, $queue;
	
	public function __construct() {
		$this->db = pc_base::load_model('special_model'); //רģ
		$this->type_db = pc_base::load_model('type_model'); //רģ
		$this->c_db = pc_base::load_model('special_content_model'); //רģ
		$this->data_db = pc_base::load_model('special_c_data_model'); 
		$this->site = pc_base::load_app_class('sites', 'admin');
		$this->queue = pc_base::load_model('queue_model');
		define('HTML', true);
	}
	
	/**
	 * ¾̬ҳ
	 * @param intval $contentid ID
	 * @return string	µurl
	 */
	public function _create_content($contentid = 0) {
		if (!$contentid) return false;
		pc_base::load_app_func('global', 'special');
		$r = $this->c_db->get_one(array('id'=>$contentid));
		$_special = $s_info = $this->db->get_one(array('id'=>$r['specialid']));
		if($s_info['ishtml']==0) return content_url($contentid, '1', 0, 'php');
		unset($arr_content);
		$arr_content = $this->data_db->get_one(array('id'=>$contentid));
		@extract($r);
		$title = strip_tags($title);
		if ($arr_content['paginationtype']) {			//ʹ÷ҳʱ
			if($arr_content['paginationtype']==1) {
				if (strpos($arr_content['content'], '[/page]')!==false) {
					$arr_content['content'] = preg_replace("|\[page\](.*)\[/page\]|U", '', $arr_content['content']);
				}
				if (strpos($arr_content['content'], '[page]')!==false) {
					$arr_content['content'] = str_replace('[page]', '', $data['content']);
				}
				$contentpage = pc_base::load_app_class('contentpage', 'content'); //Զҳ
				$arr_content['content'] = $contentpage->get_data($arr_content['content'], $arr_content['maxcharperpage']); //ԶҳԶ[page]
			} 
		} else {
			if (strpos($arr_content['content'], '[/page]')!==false) {
				$arr_content['content'] = preg_replace("|\[page\](.*)\[/page\]|U", '', $arr_content['content']);
			}
			if (strpos($arr_content['content'], '[page]')!==false) {
				$arr_content['content'] = str_replace('[page]', '', $arr_content['content']);
			}
		}
		$template = $arr_content['show_template'] ? $arr_content['show_template'] : 'show'; //ģ
		
		//վʱվ·
		if ($s_info['siteid']>1) {
			$site_info = $this->site->get_by_id($s_info['siteid']);
		}
		$siteid = $s_info['siteid'];
		$CONTENT_POS = strpos($arr_content['content'], '[page]');
		if ($CONTENT_POS !== false) {
			$contents = array_filter(explode('[page]', $arr_content['content']));
			$pagenumber = count($contents);
			$END_POS = strpos($arr_content['content'], '[/page]');
			if ($END_POS!==false && ($CONTENT_POS<7)) {
				$pagenumber--;
			}
			for ($i=1; $i<=$pagenumber; $i++) {
				$pageurls[$i] = content_url($contentid, $i, $inputtime, 'html', $site_info); 
			}
			if ($END_POS !== false) {
				if($CONTENT_POS>7) {
					$arr_content['content'] = '[page]'.$title.'[/page]'.$arr_content['content'];
				}
				if (preg_match_all("|\[page\](.*)\[/page\]|U", $arr_content['content'], $m, PREG_PATTERN_ORDER)) {
					foreach ($m[1] as $k=>$v) {
						$p = $k+1;
						$titles[$p]['title'] = strip_tags($v);
						$titles[$p]['url'] = $pageurls[$p][1];
					}
				}
			}
			$currentpage = $filesize = 0;
			for ($i=1; $i<=$pagenumber; $i++) {
				$currentpage++;
				//ж[page]ֵλǷڵһλ 
				if($CONTENT_POS<7) {
					$content = $contents[$currentpage];
				} else {
					if ($currentpage==1 && !empty($titles)) {
						$content = $title.'[/page]'.$contents[$currentpage-1];
					} else {
						$content = $contents[$currentpage-1];
					}
				}
				if($titles) {
					list($title, $content) = explode('[/page]', $content);
					$content = trim($content);
					if(strpos($content,'</p>')===0) {
						$content = '<p>'.$content;
					}
					if(stripos($content,'<p>')===0) {
						$content = $content.'</p>';
					}
				}
				$file_url = content_url($contentid, $currentpage, $inputtime, 'html', $site_info);
				if ($currentpage==1) $urls = $file_url;
				pc_base::load_app_func('util', 'content');
				$title_pages = content_pages($pagenumber,$currentpage, $pageurls);
				$SEO = seo($s_info['siteid'], '', $title);
				$file = $file_url[1];
				
				//Ƿվļļд뵽Ϣ
				$this->queue->add_queue('add', $file, $siteid);
				$file = PHPCMS_PATH.$file; //ļ·
				
				ob_start();
				include template('special', $template);
				$this->create_html($file);
			}
		} else {
			$page = 1;
			$title = strip_tags($title);
			$SEO = seo($s_info['siteid'], '', $title);
			$content = $arr_content['content'];
			$urls = content_url($contentid, $page, $inputtime, 'html', $site_info);
			$file = $urls[1];
			
			//Ƿվļļд뵽Ϣ
			$this->queue->add_queue('add', $file, $siteid);
			$file = PHPCMS_PATH.$file;
			ob_start();
			include template('special', $template);
			$this->create_html($file);
		}
		//$this->_index($specialid, 20, 5);  //רҳ
		//$this->_list($typeid, 20, 5); 		//ڵķҳ
		return $urls;
	}
	
	/**
	 * ɾ̬ļ
	 * @param string $file ļ·
	 * @return boolen/intval ɹļĴС
	 */
	private function create_html($file) {
		$data = ob_get_contents();
		ob_end_clean();
		pc_base::load_sys_func('dir');
		dir_create(dirname($file));
		$strlen = file_put_contents($file, $data);
		@chmod($file, 0777);
		return $strlen;
	}
	
	/**
	 * רҳ
	 * @param intval $specialid רID
	 * @param intval $pagesize ÿҳ
	 * @param intval $pages_num ҳ
	 * @return boolen/intval ɹļĴС
	 */
	public function _index($specialid = 0, $pagesize = 20, $pages_num = 0) {
		pc_base::load_app_func('global', 'special');
		$specialid = intval($specialid);
		if (!$specialid) return false;
		$r = $this->db->get_one(array('id'=>$specialid, 'siteid'=>get_siteid()));
		if (!$r['ishtml'] || $r['disabled'] != 0 ) return true;
		
		if (!$specialid) showmessage(L('illegal_action'));
		$info = $this->db->get_one(array('id'=>$specialid));
		if(!$info) showmessage(L('special_not_exist'), 'back');
		extract($info);
		if ($pics) {
			$pic_data = get_pic_content($pics);
			unset($pics);
		}
		if ($voteid) {
			$vote_info = explode('|', $voteid);
			$voteid = $vote_info[1];
		}
		$commentid = id_encode('special', $id, $siteid);
		//վʱ·
		if ($siteid>1) {
			$site_info = $this->site->get_by_id($siteid);
			$file = pc_base::load_config('system', 'html_root').'/'.$site_info['dirname'].'/special/'.$filename.'/index.html';
		} else {
			$file = pc_base::load_config('system', 'html_root').'/special/'.$filename.'/index.html';
		}
		if(!$ispage) {
			$type_db = pc_base::load_model('type_model');
			$types = $type_db->select(array('module'=>'special', 'parentid'=>$specialid), '*', '', '`listorder` ASC, `typeid` ASC', '', 'listorder');
		}
		$css = get_css(unserialize($css));
		$template = $index_template ? $index_template : 'index';
		$SEO = seo($siteid, '', $title, $description);
		if($ispage) {
			$re = $this->c_db->get_one(array('specialid'=>$specialid), 'COUNT(`id`) AS num');
			$total = $re['num'];
			$times = ceil($total/$pagesize);
			if ($pages_num) $pages_num = min($times, $pages_num);
			else $pages_num = $times;
			for ($i=1; $i<=$pages_num; $i++) {
				if ($i==1) $file_root = $file;
				else $file_root = str_replace('index', 'index-'.$i, $file);
				$this->queue->add_queue('add', $file_root, $siteid); //Ϣ
				$file_root = PHPCMS_PATH.$file_root;
				ob_start();
				include template('special', $template);
				$this->create_html($file_root);
			}
			return true;
		} else {
			$this->queue->add_queue('add', $file, $siteid); //Ϣ
			$file = PHPCMS_PATH.$file;
			ob_start();
			include template('special', $template, $style);
			return $this->create_html($file);
		}
	}
	
	/**
	 * бҳ
	 */
	public function create_list($page = 1) {
		$siteid = get_siteid();
		$site_info = $this->site->get_by_id($siteid);
		define('URLRULE', $site_info['domain'].substr(pc_base::load_config('system', 'html_root'), 1).'/special/index.html~'.$site_info['domain'].substr(pc_base::load_config('system', 'html_root'), 1).'/special/index-{$page}.html');
		//վʱ·
		if ($siteid>1) {
			if ($page==1) $file = pc_base::load_config('system', 'html_root').'/'.$site_info['dirname'].'/special/index.html';
			else $file = pc_base::load_config('system', 'html_root').'/'.$site_info['dirname'].'/special/index-'.$page.'.html';
		} else {
			if ($page==1)  $file = pc_base::load_config('system', 'html_root').'/special/index.html';
			else $file = pc_base::load_config('system', 'html_root').'/special/index-'.$page.'.html';
		}
		$this->queue->add_queue('add', $file, $siteid);
		$file  = PHPCMS_PATH.$file;
		ob_start();
		include template('special', 'special_list');
		return $this->create_html($file);
	}
	
	/**
	 * ɷҳ
	 * @param intval $typeid ID
	 * @param intval $page ҳ
	 */
	public function create_type($typeid = 0, $page = 1) {
		if (!$typeid) return false;
		$info = $this->type_db->get_one(array('typeid'=>$typeid));
		$s_info = $this->db->get_one(array('id'=>$info['parentid']));
		extract($s_info);
		$site_info = $this->site->get_by_id($siteid);
		define('URLRULE', $site_info['domain'].substr(pc_base::load_config('system', 'html_root'), 1).'/special/{$specialdir}/{$typedir}/type-{$typeid}.html~'.$site_info['domain'].substr(pc_base::load_config('system', 'html_root'), 1).'/special/{$specialdir}/{$typedir}/type-{$typeid}-{$page}.html');
		$GLOBALS['URL_ARRAY'] = array('specialdir'=>$filename, 'typedir'=>$info['typedir'], 'typeid'=>$typeid);
		$SEO = seo($siteid, '', $info['typename'], '');
		$template = $list_template ? $list_template : 'list';
		
		if ($siteid>1) {
			if ($page==1) $file = pc_base::load_config('system', 'html_root').'/'.$site_info['dirname'].'/special/'.$filename.'/'.$info['typedir'].'/type-'.$typeid.'.html';
			else $file = pc_base::load_config('system', 'html_root').'/'.$site_info['dirname'].'/special/'.$filename.'/'.$info['typedir'].'/type-'.$typeid.'-'.$page.'.html';
		} else {
			if ($page==1) $file = pc_base::load_config('system', 'html_root').'/special/'.$filename.'/'.$info['typedir'].'/type-'.$typeid.'.html';
			else $file = pc_base::load_config('system', 'html_root').'/special/'.$filename.'/'.$info['typedir'].'/type-'.$typeid.'-'.$page.'.html';
		}
		$this->queue->add_queue('add', $file, $siteid);
		$file = PHPCMS_PATH.$file;
		ob_start();
		include template('special', $template);
		$this->create_html($file);
	}
	
	/**
	 * ɷྲ̬ҳ
	 * @param intval $typeid ID
	 * @param intval $pagesize ÿҳƪ
	 * @param intval $pages ҳ
 	 */
	public function _list($typeid = 0, $pagesize = 20, $pages = 0) {
		if (!$typeid) return false;
		$r = $this->c_db->get_one(array('typeid'=>$typeid), 'COUNT(`id`) AS num');
		$total = $r['num'];
		$times = ceil($total/$pagesize);
		if ($pages) $pages = min($times, $pages);
		else $pages = $times;
		for ($i=1; $i<=$pages; $i++) {
			$this->create_type($typeid, $i);
		}
		return true;
	}
}
?>