<?php 
/**
 *  model.class.php ģͻ
 *
 * @copyright			(C) 2005-2010 PHPCMS
 * @license				http://www.phpcms.cn/license/
 * @lastmodify			2010-6-7
 */
defined('IN_PHPCMS') or exit('Access Denied');
pc_base::load_sys_class('db_factory', '', 0);
class model {
	
	//ݿ
	protected $db_config = '';
	//ݿ
	protected $db = '';
	//ݿ
	protected $db_setting = 'default';
	//ݱ
	protected $table_name = '';
	//ǰ׺
	public  $db_tablepre = '';
	
	public function __construct() {
		if (!isset($this->db_config[$this->db_setting])) {
			$this->db_setting = 'default';
		}
		$this->table_name = $this->db_config[$this->db_setting]['tablepre'].$this->table_name;
		$this->db_tablepre = $this->db_config[$this->db_setting]['tablepre'];
		$this->db = db_factory::get_instance($this->db_config)->get_database($this->db_setting);
	}
		
	/**
	 * ִsqlѯ
	 * @param $where 		ѯ[`name`='$name']
	 * @param $data 		Ҫѯֵֶ[`name`,`gender`,`birthday`]
	 * @param $limit 		ؽΧ[1010,10 ĬΪ]
	 * @param $order 		ʽ	[ĬϰݿĬϷʽ]
	 * @param $group 		鷽ʽ	[ĬΪ]
	 * @return array		ѯ
	 */
	final public function select($where = '', $data = '*', $limit = '', $order = '', $group = '', $key='') {
		if (is_array($where)) $where = $this->sqls($where);
		return $this->db->select($data, $this->table_name, $where, $limit, $order, $group, $key);
	}

	/**
	 * ѯݲҳ
	 * @param $where
	 * @param $order
	 * @param $page
	 * @param $pagesize
	 * @return unknown_type
	 */
	final public function listinfo($where = '', $order = '', $page = 1, $pagesize = 20, $key='', $setpages = 10,$urlrule = '',$array = array()) {
		$where = to_sqls($where);
		$this->number = $this->count($where);
		$page = max(intval($page), 1);
		$offset = $pagesize*($page-1);
		$this->pages = pages($this->number, $page, $pagesize, $urlrule, $array, $setpages);
		$array = array();
		return $this->select($where, '*', "$offset, $pagesize", $order, '', $key);
	}

	/**
	 * ȡ¼ѯ
	 * @param $where 		ѯ
	 * @param $data 		Ҫѯֵֶ[`name`,`gender`,`birthday`]
	 * @param $order 		ʽ	[ĬϰݿĬϷʽ]
	 * @param $group 		鷽ʽ	[ĬΪ]
	 * @return array/null	ݲѯ,ڣ򷵻ؿ
	 */
	final public function get_one($where = '', $data = '*', $order = '', $group = '') {
		if (is_array($where)) $where = $this->sqls($where);
		return $this->db->get_one($data, $this->table_name, $where, $order, $group);
	}
	
	/**
	 * ֱִsqlѯ
	 * @param $sql							ѯsql
	 * @return	boolean/query resource		Ϊѯ䣬Դ򷵻true/false
	 */
	final public function query($sql) {
		return $this->db->query($sql);
	}
	
	/**
	 * ִӼ¼
	 * @param $data 		ҪӵݣΪ顣keyΪֵֵֶΪȡֵ
	 * @param $return_insert_id Ƿ񷵻½ID
	 * @param $replace Ƿ replace intoķʽ
	 * @return boolean
	 */
	final public function insert($data, $return_insert_id = false, $replace = false) {
		return $this->db->insert($data, $this->table_name, $return_insert_id, $replace);
	}
	
	/**
	 * ȡһӼ¼
	 * @return int 
	 */
	final public function insert_id() {
		return $this->db->insert_id();
	}
	
	/**
	 * ִи¼¼
	 * @param $data 		ҪµݣΪҲΪַ顣
	 * 						ΪʱkeyΪֵֵֶΪȡֵ
	 * 						Ϊַʱ[`name`='phpcms',`hits`=`hits`+1]
	 *						Ϊʱ[: array('name'=>'phpcms','password'=>'123456')]
	 *						һʹarray('name'=>'+=1', 'base'=>'-=1');ԶΪ`name` = `name` + 1, `base` = `base` - 1
	 * @param $where 		ʱ,Ϊַ
	 * @return boolean
	 */
	final public function update($data, $where = '') {
		if (is_array($where)) $where = $this->sqls($where);
		return $this->db->update($data, $this->table_name, $where);
	}
	
	/**
	 * ִɾ¼
	 * @param $where 		ɾ,Ϊա
	 * @return boolean
	 */
	final public function delete($where) {
		if (is_array($where)) $where = $this->sqls($where);
		return $this->db->delete($this->table_name, $where);
	}
	
	/**
	 * ¼
	 * @param string/array $where ѯ
	 */
	final public function count($where = '') {
		$r = $this->get_one($where, "COUNT(*) AS num");
		return $r['num'];
	}
	
	/**
	 * תΪSQL
	 * @param array $where Ҫɵ
	 * @param string $font Ӵ
	 */
	final public function sqls($where, $font = ' AND ') {
		if (is_array($where)) {
			$sql = '';
			foreach ($where as $key=>$val) {
				$sql .= $sql ? " $font `$key` = '$val' " : " `$key` = '$val'";
			}
			return $sql;
		} else {
			return $where;
		}
	}
	
	/**
	 * ȡݿӰ쵽
	 * @return int
	 */
	final public function affected_rows() {
		return $this->db->affected_rows();
	}
	
	/**
	 * ȡݱ
	 * @return array
	 */
	final public function get_primary() {
		return $this->db->get_primary($this->table_name);
	}
	
	/**
	 * ȡֶ
	 * @return array
	 */
	final public function get_fields() {
		return $this->db->get_fields($this->table_name);
	}
	
	/**
	 * Ƿ
	 * @param $table 
	 * @return boolean
	 */
	final public function table_exists($table){
		return $this->db->table_exists($this->db_tablepre.$table);
	}
	
	final public function list_tables() {
		return $this->db->list_tables();
	}
	/**
	 * ݽ
	 * @param $query mysql_queryֵ
	 * @return array
	 */
	final public function fetch_array() {
		$data = array();
		while($r = $this->db->fetch_next()) {
			$data[] = $r;		
		}
		return $data;
	}
	
	/**
	 * ݿ汾
	 */
	final public function version() {
		return $this->db->version();
	}
}