---
title: Upgrading from 0.6.x
---

# Upgrading from 0.6.x
Upgrading to Marathon 0.7.0 is straight forward if you haven't been using 
any of the Docker features.

We recommend creating a backup of the ZooKeeper state before upgrading to be able to downgrade in case
of problems after an upgrade. This can done by creating a copy of ZooKeeper's [data directory](http://zookeeper.apache.org/doc/r3.1.2/zookeeperAdmin.html#The+Data+Directory).

## Mesos
Marathon will run with either Mesos 0.19.x or Mesos 0.20.0.  However to leverage
the new Docker features Mesos 0.20.0 is required.

## v1 API

The v1 API has been removed from Marathon. See [REST API]({{ site.baseurl }}/docs/rest-api.html) for up to
date documentation of the REST API.

## Task Rate Limit

The `taskRateLimit` app parameter has been replaced with two new parameters
that together control per-app exponential backoff.  The new parameters are
`backoffSeconds` and  `backoffFactor`.  The backoff period (`backoffSeconds`)
is multiplied by the factor for each consecutive failed task launch.

## HAProxy Bridge

Make sure you're using the latest version of the script, as `/v1/endpoints`
no longer available.

## Deployment Design

There is a new set of features specifically dedicated to deploying your app.
Your app will automatically be updated to make use of these features.
See the [full docs]({{ site.baseurl }}/docs/deployment-design-doc.html) for details.

## Artifact Store

Marathon now has support for configuring an artifact cache that can be used 
when deploying your app, this facilitates removing load from package servers
and shifts the load to something like HDFS.
See the [full docs]({{ site.baseurl }}/docs/artifact-store.html) for details.

## Docker

See [Running Docker Containers on Marathon]({{ site.baseurl }}/docs/native-docker.html)
for full documentation.

### Updating from Deimos

  <div class="alert alert-warning">
    <strong>Careful:</strong> Deimos supported the fetching of `s3` URLs using the
    `aws` commandline tool and IAM roles, mesos only supports `s3` URLs if HDFS 
    is also running on the slave. Using the `https` URL for the resource will not
    take IAM roles into account.
  </div>

1. Remove Deimos slave configuration

    ```bash
    rm /etc/mesos-slave/containerizer_path
    rm /etc/mesos-slave/isolation
    rm /etc/deimos.cfg
    ```
    
2. Uninstall Deimos
  
    ```bash
    pip uninstall deimos
    ```
  
3. Restart `mesos-slave` process to load the new configuration


### New container format

The old container format has been replaced with a new format.
Therefore the following changes are **obligatory** for Marathon users
upgrading to `0.7.x` who were previously using
[Deimos](https://github.com/mesosphere/deimos) to run Docker containers.

Previously, the `container` field looked like this:

```json
{
  "container": {
    "image": "docker:///megacorp/product:1.2.3",
    "options": [
      "-v", "/var/data/a:/etc/a:ro",
      "-v", "/var/data/b:/etc/b:rw",
      "-e", "FOO=bar",
      "-p", "443:443"
    ]
  }
}
```

Here is the `container` field, translated to the new format:

```json
{
  "container": {
    "type": "DOCKER",
    "docker": {
      "image": "megacorp/product:1.2.3"
    },
    "volumes": [
      {
        "hostPath": "/var/data/a",
        "containerPath": "/etc/a",
        "mode": "RO"
      },
      {
        "hostPath": "/var/data/b",
        "containerPath": "/etc/b",
        "mode": "RW"
      }
    ]
  },
  "env": {
    "FOO": "bar"
  },
  "ports": [443],
  "requirePorts": true
}
```

## Resources

- [Native Docker Containers with Mesos and Marathon]({{ site.baseurl }}/docs/native-docker.html)
- [Mesos Docker Containerizer](http://mesos.apache.org/documentation/latest/docker-containerizer/)
- [Docker on Mesos 0.20](http://tnachen.wordpress.com/2014/08/19/docker-in-mesos-0-20/)
