// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef __MAINTENANCE_PROTO_HPP__
#define __MAINTENANCE_PROTO_HPP__

// ONLY USEFUL AFTER RUNNING PROTOC.
#include <mesos/maintenance/maintenance.pb.h>

#include <mesos/resources.hpp>

namespace mesos {

// A wrapper for resources and unavailability used to communicate between the
// Allocator and Master in order to let the Master create InverseOffers from the
// Allocator.
struct UnavailableResources
{
  Resources resources;
  Unavailability unavailability;
};

} // namespace mesos {

#endif // __MAINTENANCE_PROTO_HPP__
