#!/usr/bin/perl -w
###############################################################################
# This program creates C struct definitions of functions/procedures defined
# in an module declaration xml file
###############################################################################
use 5.008000;
use strict;
use warnings;

use Carp;
use Data::Dumper;
use XML::Simple;

if ( scalar(@ARGV) < 1 )
{
    print STDERR "usage: apidoc.pl [-lang LANG] api.xml\n";
    exit(1);
}
my $input = shift(@ARGV);
my $lang = "en";
if ( $input eq "-lang" )
{
    $lang = shift(@ARGV);
    $input = shift(@ARGV);
}
my $xs = XML::Simple->new();
my $hash = $xs->XMLin($input,
		      KeyAttr => [],
		      KeepRoot => 0,  #strips the <fields> tag without KeepRoot
		      ForceArray => 0,
    ) || croak("XMLin failed: " . $@);

my $module = $hash->{module};

open(OUT, "> fields-" . $module . ".xml") || croak("couldn't open output");

print OUT "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<section id=\"$module" . "_fields\">
 <title>Fields generated by $module</title>
 <para>
  The following fields are set by $module:
";

dump_fields($hash);
print OUT "
 </para>
</section>
";
close(OUT);

exit 0;
###########################################################################################################

sub dump_fields
{
    my $hash = shift;

    my $fields = $hash->{field};
    if ( defined($fields) && (ref($fields) ne 'ARRAY') )
    {
	$fields = [$hash->{field}];
    }

    if ( defined($fields) && (@{$fields} > 0) )
    {
	print OUT "
  <variablelist>";

	my %defines;

	foreach my $field ( @{$fields} )
	{
	    my $desc;
	    if ( defined($field->{description}{$lang}) )
	    {
		$desc = $field->{description}{$lang};
	    }
	    else
	    {
		$desc = $field->{description}{en};
	    }
	    $desc =~ s/\s+$//;
#	    my $persist = $field->{persist};
#	    if ( ! defined($persist) )
#	    {
#		$persist = 'FALSE';
#	    }
	    my $linkname = $field->{name};
	    $linkname =~ s/\./_/g;
	    print OUT "
   <varlistentry> 
     <term><anchor id=\"" . $module . "_field_" . $linkname . "\"/>\$" . $field->{name} . "</term>
     <listitem>
      <para>
       <simplelist type='horiz' columns='2'>
	<member>Type</member><member><link linkend=\"lang_type_" . $field->{type} . "\">" . $field->{type} . "</link></member>
	<!--<member>Persist</member><member>persist</member>-->
       </simplelist>$desc
      </para>
     </listitem>
   </varlistentry>
";
	}
	
	print OUT "
  </variablelist>
";
    }
    else
    { # no fields
    }
}
