import { RequestInfo, ResponseInfo } from './adapter';
export declare const USER_AGENT: string;
export declare const DEFAULT_UC_URL: string;
interface Options {
    accessKey: string;
    ucUrl?: string;
    requestCallback?: (request: RequestInfo) => void;
    responseCallback?: (response: ResponseInfo) => void;
}
export interface GetAllOptions extends Options {
    secretKey: string;
}
export interface QueryOptions extends Options {
    bucketName: string;
}
export declare class Region {
    readonly id: string;
    readonly s3Id: string;
    readonly label?: string | undefined;
    readonly translatedLabels?: {
        [lang: string]: string;
    } | undefined;
    private static readonly httpClient;
    upUrls: Array<string>;
    ucUrls: Array<string>;
    rsUrls: Array<string>;
    rsfUrls: Array<string>;
    apiUrls: Array<string>;
    s3Urls: Array<string>;
    constructor(id: string, s3Id: string, label?: string | undefined, translatedLabels?: {
        [lang: string]: string;
    } | undefined);
    static getAll(options: GetAllOptions): Promise<Array<Region>>;
    static query(options: QueryOptions): Promise<Region>;
    private static extraError;
    private static isRetry;
    private static fromResponseBody;
}
export {};
//# sourceMappingURL=region.d.ts.map