# Installation
> `npm install --save @types/async-lock`

# Summary
This package contains type definitions for async-lock (https://github.com/rain1017/async-lock).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/async-lock.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/async-lock/index.d.ts)
````ts
// Type definitions for async-lock 1.1
// Project: https://github.com/rain1017/async-lock, https://github.com/rogierschouten/async-lock
// Definitions by: Elisée MAURER <https://github.com/elisee>
//                 Alejandro <https://github.com/afharo>
//                 Anatoly <https://github.com/rhymmor>
//                 Humulus <https://github.com/humulus>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 2.1

type AsyncLockDoneCallback<T> = (err?: Error, ret?: T) => void;

interface AsyncLockOptions {
    timeout?: number | undefined;
    maxPending?: number | undefined;
    domainReentrant?: boolean | undefined;
    Promise?: any;
    skipQueue?: boolean | undefined;
}

declare class AsyncLock {
    constructor(options?: AsyncLockOptions);

    acquire<T>(key: string | string[],
               fn: (() => T | PromiseLike<T>) | ((done: AsyncLockDoneCallback<T>) => any),
               opts?: AsyncLockOptions): Promise<T>;
    acquire<T>(key: string | string[],
               fn: (done: AsyncLockDoneCallback<T>) => any,
               cb: AsyncLockDoneCallback<T>,
               opts?: AsyncLockOptions): void;

    isBusy(key?: string): boolean;
}

declare namespace AsyncLock { }

export = AsyncLock;

````

### Additional Details
 * Last updated: Tue, 06 Jul 2021 18:05:36 GMT
 * Dependencies: none
 * Global values: none

# Credits
These definitions were written by [Elisée MAURER](https://github.com/elisee), [Alejandro](https://github.com/afharo), [Anatoly](https://github.com/rhymmor), and [Humulus](https://github.com/humulus).
