import { Region } from './region';
import { Adapter, RequestInfo, ResponseInfo } from './adapter';
export declare const KODO_MODE: string;
export declare const S3_MODE: string;
export interface ModeOptions {
    appName?: string;
    appVersion?: string;
    uplogBufferSize?: number;
    requestCallback?: (request: RequestInfo) => void;
    responseCallback?: (response: ResponseInfo) => void;
}
export declare class Qiniu {
    private readonly accessKey;
    private readonly secretKey;
    private readonly ucUrl?;
    private readonly appendedUserAgent?;
    private static readonly ADAPTERS;
    static register(modeName: string, adapter: any): void;
    private regions;
    constructor(accessKey: string, secretKey: string, ucUrl?: string | undefined, appendedUserAgent?: string | undefined, regions?: Region[]);
    mode(modeName: string, options?: ModeOptions): Adapter;
}
//# sourceMappingURL=qiniu.d.ts.map