"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateReqId = void 0;
const object_hash_1 = __importDefault(require("object-hash"));
const timestamp_nano_1 = __importDefault(require("timestamp-nano"));
function generateReqId(request) {
    const t = timestamp_nano_1.default.fromDate(new Date());
    const value = {
        'secs': t.getTimeT(), 'nsecs': t.getNano(), 'r': Math.random(),
    };
    Object.assign(value, request);
    return object_hash_1.default(value);
}
exports.generateReqId = generateReqId;
//# sourceMappingURL=req_id.js.map