"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromQiniuPath = exports.fromPosixPath = exports.fromWin32Path = exports.fromLocalPath = void 0;
const path_1 = require("./path");
const path_2 = __importDefault(require("path"));
function fromLocalPath(pathStr) {
    return _fromLocalPath(pathStr, path_2.default);
}
exports.fromLocalPath = fromLocalPath;
function fromWin32Path(pathStr) {
    return _fromLocalPath(pathStr, path_2.default.win32);
}
exports.fromWin32Path = fromWin32Path;
function fromPosixPath(pathStr) {
    return _fromLocalPath(pathStr, path_2.default.posix);
}
exports.fromPosixPath = fromPosixPath;
function _fromLocalPath(pathStr, path) {
    const sep = path.sep;
    let isDir = false;
    if (pathStr.endsWith(sep)) {
        isDir = true;
    }
    const parsed = path.parse(pathStr);
    const dirPathPart = parsed.dir.substr(parsed.root.length);
    let dirSegments = [];
    if (dirPathPart.length > 0) {
        dirSegments = dirPathPart.split(sep);
    }
    let base = parsed.base;
    let ext = parsed.ext;
    if (isDir) {
        dirSegments.push(parsed.base);
        base = undefined;
        ext = undefined;
    }
    return new path_1.Path(sep, parsed.root, base, ext, dirSegments, isDir);
}
function fromQiniuPath(pathStr) {
    const sep = '/';
    let isDir = false;
    if (pathStr.endsWith(sep)) {
        isDir = true;
    }
    const segments = pathStr.split(sep);
    let basename = undefined;
    let ext = undefined;
    if (isDir) {
        segments.pop();
    }
    else {
        basename = segments.pop();
        if (basename) {
            ext = path_2.default.extname(basename);
        }
    }
    return new path_1.Path(sep, '', basename, ext, segments, isDir);
}
exports.fromQiniuPath = fromQiniuPath;
//# sourceMappingURL=convert.js.map