/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedLongKeyHashMap;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Type;

public class RowSetNavigatorDataChange
extends RowSetNavigator {
    OrderedLongKeyHashMap list = new OrderedLongKeyHashMap(8, true);
    boolean enforceDeleteOrUpdate;
    boolean enforceSingleUpdate;

    public RowSetNavigatorDataChange() {
    }

    public RowSetNavigatorDataChange(boolean bl, boolean bl2) {
        this.enforceDeleteOrUpdate = bl;
        this.enforceSingleUpdate = bl2;
    }

    @Override
    public Object[] getCurrent() {
        return this.getCurrentRow().getData();
    }

    @Override
    public Row getCurrentRow() {
        return (Row)this.list.getValueByIndex(this.currentPos);
    }

    public Object[] getCurrentChangedData() {
        return (Object[])this.list.getSecondValueByIndex(this.currentPos);
    }

    public int[] getCurrentChangedColumns() {
        return (int[])this.list.getThirdValueByIndex(this.currentPos);
    }

    @Override
    public Row getNextRow() {
        return this.next() ? this.getCurrentRow() : null;
    }

    @Override
    public void remove() {
        throw new NoSuchElementException();
    }

    @Override
    public boolean next() {
        return super.next();
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws IOException {
        this.beforeFirst();
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(0);
        rowOutputInterface.writeInt(this.size);
        while (this.hasNext()) {
            Object[] objectArray = this.getNext();
            rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
        this.beforeFirst();
    }

    @Override
    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
        this.id = rowInputInterface.readLong();
        int n = rowInputInterface.readInt();
        rowInputInterface.readInt();
        rowInputInterface.readInt();
        while (n-- > 0) {
            this.add(rowInputInterface.readData(resultMetaData.columnTypes));
        }
    }

    @Override
    public void clear() {
        this.reset();
        this.list.clear();
        this.size = 0;
    }

    @Override
    public void add(Object[] objectArray) {
        throw Error.runtimeError(201, "RowSetNavigatorDataChange");
    }

    @Override
    public boolean addRow(Row row) {
        int n = this.list.getLookup(row.getId());
        if (n == -1) {
            this.list.put(row.getId(), row, null);
            ++this.size;
            return true;
        }
        if (this.list.getSecondValueByIndex(n) != null) {
            if (this.enforceDeleteOrUpdate) {
                throw Error.error(3900);
            }
            this.list.setSecondValueByIndex(n, null);
            this.list.setThirdValueByIndex(n, null);
            return true;
        }
        return false;
    }

    public Object[] addRow(Session session, Row row, Object[] objectArray, Type[] typeArray, int[] nArray) {
        long l = row.getId();
        int n = this.list.getLookup(l);
        if (n == -1) {
            this.list.put(l, row, objectArray);
            this.list.setThirdValueByIndex(this.size, nArray);
            ++this.size;
            return objectArray;
        }
        Object[] objectArray2 = ((Row)this.list.getFirstByLookup(n)).getData();
        Object[] objectArray3 = (Object[])this.list.getSecondValueByIndex(n);
        if (objectArray3 == null) {
            if (this.enforceDeleteOrUpdate) {
                throw Error.error(3900);
            }
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (typeArray[n2].compare(session, objectArray[n2], objectArray3[n2]) == 0) continue;
            if (typeArray[n2].compare(session, objectArray2[n2], objectArray3[n2]) != 0) {
                if (!this.enforceSingleUpdate) continue;
                throw Error.error(3900);
            }
            objectArray3[n2] = objectArray[n2];
        }
        int[] nArray2 = (int[])this.list.getThirdValueByIndex(n);
        nArray2 = ArrayUtil.union(nArray2, nArray);
        this.list.setThirdValueByIndex(n, nArray2);
        return objectArray3;
    }

    public boolean containsDeletedRow(Row row) {
        int n = this.list.getLookup(row.getId());
        if (n == -1) {
            return false;
        }
        Object[] objectArray = (Object[])this.list.getSecondValueByIndex(n);
        return objectArray == null;
    }
}

