/*
 * Decompiled with CFR 0.152.
 */
package com.smartmarmot.common.db;

import com.smartmarmot.common.SmartLogger;
import com.smartmarmot.common.db.DBEnquiry;
import com.smartmarmot.orabbix.Query;
import com.smartmarmot.orabbix.Sender;
import com.smartmarmot.zabbix.ZabbixItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;
import org.apache.log4j.Level;

public class DBJob
implements Runnable {
    private final SharedPoolDataSource _spds;
    private Query[] _queries;
    private final BlockingQueue<ZabbixItem> _queue = new LinkedBlockingQueue<ZabbixItem>();
    private final String _dbname;
    private final String _queriesGroup;
    private final int _dgNum;
    private final Hashtable<String, Integer> _zabbixServers;

    public DBJob(SharedPoolDataSource spds, Query[] queries, String queriesGroup, Hashtable<String, Integer> zabbixServers, String dbname) {
        this._spds = spds;
        this._queries = queries;
        this._queriesGroup = queriesGroup;
        this._zabbixServers = zabbixServers;
        this._dbname = dbname;
        this._dgNum = 0;
    }

    public DBJob(SharedPoolDataSource spds, Query[] queries, String queriesGroup, Hashtable<String, Integer> zabbixServers, String dbname, int dgNum) {
        this._spds = spds;
        this._queries = queries;
        this._zabbixServers = zabbixServers;
        this._queriesGroup = queriesGroup;
        this._dbname = dbname;
        this._dgNum = dgNum > 0 ? dgNum : 0;
    }

    private boolean Alive(SharedPoolDataSource _myspds) {
        try {
            Connection dbConn = _myspds.getConnection();
            PreparedStatement p_stmt = null;
            p_stmt = dbConn.prepareStatement("SELECT SYSDATE FROM DUAL");
            ResultSet rs = null;
            rs = p_stmt.executeQuery();
            rs.next();
            dbConn.close();
            return true;
        }
        catch (Exception e) {
            SmartLogger.logThis(Level.DEBUG, "Database " + this._dbname + " is not alive");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SmartLogger.logThis(Level.DEBUG, "Starting dbJob on database " + this._dbname + " " + this._queriesGroup);
        long start = System.currentTimeMillis();
        try {
            if (this.Alive(this._spds)) {
                Connection dbConn = this._spds.getConnection();
                this._queue.offer(new ZabbixItem("alive", "1", this._dbname));
                this._queue.offer(new ZabbixItem("Orabbix.Version", "Orabbix Version 1.2.3 ", this._dbname));
                ZabbixItem[] zitems = DBEnquiry.execute(this._queries, dbConn, this._dbname);
                if (zitems != null && zitems.length > 0) {
                    SmartLogger.logThis(Level.DEBUG, "Item retrieved " + zitems.length + " on database " + this._dbname);
                    for (int cnt = 0; cnt < zitems.length; ++cnt) {
                        String zItemName = zitems[cnt].getKey();
                        if (this._dgNum > 0) {
                            zItemName = zItemName + "_" + this._dgNum;
                        }
                        SmartLogger.logThis(Level.DEBUG, "dbname " + this._dbname + " sending item  " + zitems[cnt].getKey() + " value " + zitems[cnt].getValue());
                        this._queue.offer(new ZabbixItem(zItemName, zitems[cnt].getValue(), this._dbname));
                    }
                }
                dbConn.close();
                Sender sender = new Sender(this._queue, this._zabbixServers, this._dbname);
                sender.run();
            } else {
                LinkedBlockingQueue<ZabbixItem> _queue = new LinkedBlockingQueue<ZabbixItem>();
                _queue.offer(new ZabbixItem("alive", "0", this._dbname));
                _queue.offer(new ZabbixItem("Orabbix.Version", "Orabbix Version 1.2.3 ", this._dbname));
                for (int cnt = 0; cnt < this._queries.length; ++cnt) {
                    if (this._queries[cnt].getWhenNotAlive() == null || this._queries[cnt].getWhenNotAlive() == "") continue;
                    _queue.offer(new ZabbixItem(this._queries[cnt].getName(), this._queries[cnt].getWhenNotAlive(), this._dbname));
                }
                Sender sender = new Sender(_queue, this._zabbixServers, this._dbname);
                sender.run();
            }
        }
        catch (Exception e) {
            SmartLogger.logThis(Level.ERROR, "Error on dbJob for database " + this._dbname + " " + this._queriesGroup + " error: " + e);
        }
        finally {
            if (this._queries != null) {
                this._queries = null;
            }
        }
        SmartLogger.logThis(Level.INFO, "Done with dbJob on database " + this._dbname + " " + this._queriesGroup + " elapsed time " + (System.currentTimeMillis() - start) + " ms");
    }
}

