/*
 * Decompiled with CFR 0.152.
 */
package com.smartmarmot.orabbix;

import com.smartmarmot.common.SmartLogger;
import com.smartmarmot.zabbix.ZabbixItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class Sender
implements Runnable {
    private static final Logger log = Logger.getLogger((String)"Orabbix");
    private final BlockingQueue<ZabbixItem> queue;
    private final Hashtable<String, Integer> zabbixServers;
    private final String head;
    private final String host;
    private static final String middle = "</key><data>";
    private static final String tail = "</data></req>";
    private final byte[] response = new byte[1024];
    private boolean stopping = false;
    private static final int retryNumber = 10;
    private static final int TIMEOUT = 30000;

    public Sender(BlockingQueue<ZabbixItem> queue, Hashtable<String, Integer> ZabbixServers, String host) {
        this.queue = queue;
        this.zabbixServers = ZabbixServers;
        this.host = host;
        this.head = "<req><host>" + this.base64Encode(host) + "</host><key>";
    }

    public void stopping() {
        this.stopping = true;
    }

    @Override
    public void run() {
        int retryCount;
        ZabbixItem item;
        try {
            item = this.queue.take();
            retryCount = 0;
            while (retryCount <= 10) {
                try {
                    this.send(item.getKey(), item.getValue());
                    break;
                }
                catch (Exception e) {
                    SmartLogger.logThis(Level.WARN, "Warning while sending item " + item.getKey() + " value " + item.getValue() + " on host " + this.host + " retry number " + retryCount + " error:" + e);
                    Thread.sleep(1000L);
                    if (++retryCount != 10) continue;
                    SmartLogger.logThis(Level.WARN, "Error i didn't sent item " + item.getKey() + " on Zabbix server " + " on host " + this.host + " tried " + retryCount + " times");
                }
            }
        }
        catch (InterruptedException e) {
            if (!this.stopping) {
                log.warn((Object)"ignoring exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.warn((Object)"ignoring exception", (Throwable)e);
        }
        while (this.queue.size() > 0) {
            item = (ZabbixItem)this.queue.remove();
            for (retryCount = 0; retryCount <= 10; ++retryCount) {
                try {
                    this.send(item.getKey(), item.getValue());
                    break;
                }
                catch (Exception e) {
                    SmartLogger.logThis(Level.WARN, "Warning while sending item " + item.getKey() + " on host " + this.host + " retry number " + retryCount + " error:" + e);
                    continue;
                }
            }
            if (retryCount != 10) continue;
            SmartLogger.logThis(Level.WARN, "Error i didn't sent item " + item.getKey() + "  on host " + this.host + " tried " + retryCount);
        }
    }

    protected byte[] encodeString(String data) {
        try {
            return data.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return data.getBytes();
        }
    }

    protected String base64Encode(String data) {
        return new String(Base64.encodeBase64((byte[])this.encodeString(data)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(String key, String value) throws IOException {
        StringBuilder message = new StringBuilder(this.head);
        message.append(this.base64Encode(key));
        message.append(middle);
        message.append(this.base64Encode(value == null ? "" : value));
        message.append(tail);
        if (log.isDebugEnabled()) {
            SmartLogger.logThis(Level.DEBUG, "sending " + message);
        }
        Socket zabbix = null;
        OutputStreamWriter out = null;
        InputStream in = null;
        Enumeration<String> serverlist = this.zabbixServers.keys();
        while (serverlist.hasMoreElements()) {
            String zabbixServer = serverlist.nextElement();
            try {
                zabbix = new Socket(zabbixServer, (int)this.zabbixServers.get(zabbixServer));
                zabbix.setSoTimeout(30000);
                out = new OutputStreamWriter(zabbix.getOutputStream());
                out.write(message.toString());
                out.flush();
                in = zabbix.getInputStream();
                int read = in.read(this.response);
                if (log.isDebugEnabled()) {
                    SmartLogger.logThis(Level.DEBUG, "received " + new String(this.response));
                }
                if (read == 2 && this.response[0] == 79 && this.response[1] == 75) continue;
                SmartLogger.logThis(Level.WARN, "received unexpected response '" + new String(this.response) + "' for key '" + key + "'");
            }
            catch (Exception ex) {
                SmartLogger.logThis(Level.ERROR, "Error contacting Zabbix server " + zabbixServer + "  on port " + this.zabbixServers.get(zabbixServer));
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (zabbix == null) continue;
                zabbix.close();
            }
        }
    }
}

