/*
 * Decompiled with CFR 0.152.
 */
package com.orangefunction.tomcat.redissessions;

import com.orangefunction.tomcat.redissessions.DeserializedSessionContainer;
import com.orangefunction.tomcat.redissessions.RedisSession;
import com.orangefunction.tomcat.redissessions.RedisSessionHandlerValve;
import com.orangefunction.tomcat.redissessions.Serializer;
import com.orangefunction.tomcat.redissessions.SessionSerializationMetadata;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class RedisSessionManager
extends ManagerBase
implements Lifecycle {
    protected byte[] NULL_SESSION = "null".getBytes();
    private final Log log = LogFactory.getLog(RedisSessionManager.class);
    protected String host = "localhost";
    protected int port = 6379;
    protected int database = 0;
    protected String password = null;
    protected int timeout = 2000;
    protected String sentinelMaster = null;
    Set<String> sentinelSet = null;
    private String redisNodes;
    private int maxRedirections;
    private long maxWaitMillis = -1L;
    private int maxTotal = 8;
    private int minIdle = 0;
    private int maxIdle = 8;
    private JedisCluster jedisCluster;
    protected final JedisPoolConfig connectionPoolConfig = new JedisPoolConfig();
    protected RedisSessionHandlerValve handlerValve;
    protected ThreadLocal<RedisSession> currentSession = new ThreadLocal();
    protected ThreadLocal<SessionSerializationMetadata> currentSessionSerializationMetadata = new ThreadLocal();
    protected ThreadLocal<String> currentSessionId = new ThreadLocal();
    protected ThreadLocal<Boolean> currentSessionIsPersisted = new ThreadLocal();
    protected Serializer serializer;
    protected static String name = "RedisSessionManager";
    protected String serializationStrategyClass = "com.orangefunction.tomcat.redissessions.JavaSerializer";
    protected EnumSet<SessionPersistPolicy> sessionPersistPoliciesSet = EnumSet.of(SessionPersistPolicy.DEFAULT);
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private Pattern p = Pattern.compile("^.+[:]\\d{1,5}\\s*$");

    public String getHost() {
        return this.host;
    }

    public String getRedisNodes() {
        return this.redisNodes;
    }

    public void setRedisNodes(String redisNodes) {
        this.redisNodes = redisNodes;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxRedirections() {
        return this.maxRedirections;
    }

    public void setMaxRedirections(int maxRedirections) {
        this.maxRedirections = maxRedirections;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setSerializationStrategyClass(String strategy) {
        this.serializationStrategyClass = strategy;
    }

    public String getSessionPersistPolicies() {
        StringBuilder policies = new StringBuilder();
        Iterator iter = this.sessionPersistPoliciesSet.iterator();
        while (iter.hasNext()) {
            SessionPersistPolicy policy = (SessionPersistPolicy)((Object)iter.next());
            policies.append(policy.name());
            if (!iter.hasNext()) continue;
            policies.append(",");
        }
        return policies.toString();
    }

    public void setSessionPersistPolicies(String sessionPersistPolicies) {
        String[] policyArray = sessionPersistPolicies.split(",");
        EnumSet<SessionPersistPolicy> policySet = EnumSet.of(SessionPersistPolicy.DEFAULT);
        for (String policyName : policyArray) {
            SessionPersistPolicy policy = SessionPersistPolicy.fromName(policyName);
            policySet.add(policy);
        }
        this.sessionPersistPoliciesSet = policySet;
    }

    public boolean getSaveOnChange() {
        return this.sessionPersistPoliciesSet.contains((Object)SessionPersistPolicy.SAVE_ON_CHANGE);
    }

    public boolean getAlwaysSaveAfterRequest() {
        return this.sessionPersistPoliciesSet.contains((Object)SessionPersistPolicy.ALWAYS_SAVE_AFTER_REQUEST);
    }

    public String getSentinels() {
        StringBuilder sentinels = new StringBuilder();
        Iterator<String> iter = this.sentinelSet.iterator();
        while (iter.hasNext()) {
            sentinels.append(iter.next());
            if (!iter.hasNext()) continue;
            sentinels.append(",");
        }
        return sentinels.toString();
    }

    public void setSentinels(String sentinels) {
        if (null == sentinels) {
            sentinels = "";
        }
        String[] sentinelArray = sentinels.split(",");
        this.sentinelSet = new HashSet<String>(Arrays.asList(sentinelArray));
    }

    public Set<String> getSentinelSet() {
        return this.sentinelSet;
    }

    public String getSentinelMaster() {
        return this.sentinelMaster;
    }

    public void setSentinelMaster(String master) {
        this.sentinelMaster = master;
    }

    public int getRejectedSessions() {
        return 0;
    }

    public void setRejectedSessions(int i) {
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        this.setState(LifecycleState.STARTING);
        Boolean attachedToValve = false;
        for (Valve valve : this.getContainer().getPipeline().getValves()) {
            if (!(valve instanceof RedisSessionHandlerValve)) continue;
            this.handlerValve = (RedisSessionHandlerValve)valve;
            this.handlerValve.setRedisSessionManager(this);
            this.log.info((Object)"Attached to RedisSessionHandlerValve");
            attachedToValve = true;
            break;
        }
        if (!attachedToValve.booleanValue()) {
            String error = "Unable to attach to session handling valve; sessions cannot be saved after the request without the valve starting properly.";
            this.log.fatal((Object)error);
            throw new LifecycleException(error);
        }
        try {
            this.initializeSerializer();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.log.fatal((Object)"Unable to load serializer", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        this.log.info((Object)("Will expire sessions after " + this.getMaxInactiveInterval() + " seconds"));
        this.initializeDatabaseConnection();
        this.setDistributable(true);
    }

    protected synchronized void stopInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        try {
            this.jedisCluster.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopInternal();
    }

    public Session createSession(String requestedSessionId) {
        RedisSession session = null;
        String sessionId = null;
        String jvmRoute = this.getJvmRoute();
        Boolean error = true;
        if (null != requestedSessionId) {
            sessionId = this.sessionIdWithJvmRoute(requestedSessionId, jvmRoute);
            if (this.jedisCluster.setnx(sessionId.getBytes(), this.NULL_SESSION) == 0L) {
                sessionId = null;
            }
        } else {
            while (this.jedisCluster.setnx((sessionId = this.sessionIdWithJvmRoute(this.generateSessionId(), jvmRoute)).getBytes(), this.NULL_SESSION) == 0L) {
            }
        }
        error = false;
        if (null != sessionId) {
            session = (RedisSession)this.createEmptySession();
            session.setNew(true);
            session.setValid(true);
            session.setCreationTime(System.currentTimeMillis());
            session.setMaxInactiveInterval(this.getMaxInactiveInterval());
            session.setId(sessionId);
            session.tellNew();
        }
        this.currentSession.set(session);
        this.currentSessionId.set(sessionId);
        this.currentSessionIsPersisted.set(false);
        this.currentSessionSerializationMetadata.set(new SessionSerializationMetadata());
        if (null != session) {
            try {
                error = this.saveInternal(this.jedisCluster, (Session)session, true);
            }
            catch (IOException ex) {
                this.log.error((Object)("Error saving newly created session: " + ex.getMessage()));
                this.currentSession.set(null);
                this.currentSessionId.set(null);
                session = null;
            }
        }
        return session;
    }

    private String sessionIdWithJvmRoute(String sessionId, String jvmRoute) {
        if (jvmRoute != null) {
            String jvmRoutePrefix = '.' + jvmRoute;
            return sessionId.endsWith(jvmRoutePrefix) ? sessionId : sessionId + jvmRoutePrefix;
        }
        return sessionId;
    }

    public Session createEmptySession() {
        return new RedisSession((Manager)this);
    }

    public void add(Session session) {
        try {
            this.save(session);
        }
        catch (IOException ex) {
            this.log.warn((Object)("Unable to add to session manager store: " + ex.getMessage()));
            throw new RuntimeException("Unable to add to session manager store.", ex);
        }
    }

    public Session findSession(String id) throws IOException {
        RedisSession session = null;
        if (null == id) {
            this.currentSessionIsPersisted.set(false);
            this.currentSession.set(null);
            this.currentSessionSerializationMetadata.set(null);
            this.currentSessionId.set(null);
        } else if (id.equals(this.currentSessionId.get())) {
            session = this.currentSession.get();
        } else {
            byte[] data = this.loadSessionDataFromRedis(id);
            if (data != null) {
                DeserializedSessionContainer container = this.sessionFromSerializedData(id, data);
                session = container.session;
                this.currentSession.set(session);
                this.currentSessionSerializationMetadata.set(container.metadata);
                this.currentSessionIsPersisted.set(true);
                this.currentSessionId.set(id);
            } else {
                this.currentSessionIsPersisted.set(false);
                this.currentSession.set(null);
                this.currentSessionSerializationMetadata.set(null);
                this.currentSessionId.set(null);
            }
        }
        return session;
    }

    public byte[] loadSessionDataFromRedis(String id) throws IOException {
        Boolean error = true;
        this.log.trace((Object)("Attempting to load session " + id + " from Redis"));
        byte[] data = this.jedisCluster.get(id.getBytes());
        error = false;
        if (data == null) {
            this.log.trace((Object)("Session " + id + " not found in Redis"));
        }
        return data;
    }

    public DeserializedSessionContainer sessionFromSerializedData(String id, byte[] data) throws IOException {
        this.log.trace((Object)("Deserializing session " + id + " from Redis"));
        if (Arrays.equals(this.NULL_SESSION, data)) {
            this.log.error((Object)("Encountered serialized session " + id + " with data equal to NULL_SESSION. This is a bug."));
            throw new IOException("Serialized session data was equal to NULL_SESSION");
        }
        RedisSession session = null;
        SessionSerializationMetadata metadata = new SessionSerializationMetadata();
        try {
            session = (RedisSession)this.createEmptySession();
            this.serializer.deserializeInto(data, session, metadata);
            session.setId(id);
            session.setNew(false);
            session.setMaxInactiveInterval(this.getMaxInactiveInterval());
            session.access();
            session.setValid(true);
            session.resetDirtyTracking();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Session Contents [" + id + "]:"));
                Enumeration en = session.getAttributeNames();
                while (en.hasMoreElements()) {
                    this.log.trace((Object)("  " + en.nextElement()));
                }
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.fatal((Object)"Unable to deserialize into session", (Throwable)ex);
            throw new IOException("Unable to deserialize into session", ex);
        }
        return new DeserializedSessionContainer(session, metadata);
    }

    public void save(Session session) throws IOException {
        this.save(session, false);
    }

    public void save(Session session, boolean forceSave) throws IOException {
        Boolean error = true;
        error = this.saveInternal(this.jedisCluster, session, forceSave);
    }

    protected boolean saveInternal(JedisCluster jedis, Session session, boolean forceSave) throws IOException {
        Boolean error = true;
        try {
            Boolean isCurrentSessionPersisted;
            this.log.trace((Object)("Saving session " + session + " into Redis"));
            RedisSession redisSession = (RedisSession)session;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Session Contents [" + redisSession.getId() + "]:"));
                Enumeration en = redisSession.getAttributeNames();
                while (en.hasMoreElements()) {
                    this.log.trace((Object)("  " + en.nextElement()));
                }
            }
            byte[] binaryId = redisSession.getId().getBytes();
            SessionSerializationMetadata sessionSerializationMetadata = this.currentSessionSerializationMetadata.get();
            byte[] originalSessionAttributesHash = sessionSerializationMetadata.getSessionAttributesHash();
            byte[] sessionAttributesHash = null;
            if (forceSave || redisSession.isDirty().booleanValue() || null == (isCurrentSessionPersisted = this.currentSessionIsPersisted.get()) || !isCurrentSessionPersisted.booleanValue() || !Arrays.equals(originalSessionAttributesHash, sessionAttributesHash = this.serializer.attributesHashFrom(redisSession))) {
                this.log.trace((Object)"Save was determined to be necessary");
                if (null == sessionAttributesHash) {
                    sessionAttributesHash = this.serializer.attributesHashFrom(redisSession);
                }
                SessionSerializationMetadata updatedSerializationMetadata = new SessionSerializationMetadata();
                updatedSerializationMetadata.setSessionAttributesHash(sessionAttributesHash);
                jedis.set(binaryId, this.serializer.serializeFrom(redisSession, updatedSerializationMetadata));
                redisSession.resetDirtyTracking();
                this.currentSessionSerializationMetadata.set(updatedSerializationMetadata);
                this.currentSessionIsPersisted.set(true);
            } else {
                this.log.trace((Object)"Save was determined to be unnecessary");
            }
            this.log.trace((Object)("Setting expire timeout on session [" + redisSession.getId() + "] to " + this.getMaxInactiveInterval()));
            jedis.expire(binaryId, this.getMaxInactiveInterval());
            error = false;
            boolean bl = error;
            return bl;
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
            throw e;
        }
        finally {
            return error;
        }
    }

    public void remove(Session session) {
        this.remove(session, false);
    }

    public void remove(Session session, boolean update) {
        this.log.trace((Object)("Removing session ID : " + session.getId()));
        this.jedisCluster.del(session.getId());
    }

    public void afterRequest() {
        RedisSession redisSession = this.currentSession.get();
        if (redisSession != null) {
            try {
                if (redisSession.isValid()) {
                    this.log.trace((Object)("Request with session completed, saving session " + redisSession.getId()));
                    this.save((Session)redisSession, this.getAlwaysSaveAfterRequest());
                } else {
                    this.log.trace((Object)("HTTP Session has been invalidated, removing :" + redisSession.getId()));
                    this.remove((Session)redisSession);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Error storing/removing session", (Throwable)e);
            }
            finally {
                this.currentSession.remove();
                this.currentSessionId.remove();
                this.currentSessionIsPersisted.remove();
                this.log.trace((Object)("Session removed from ThreadLocal :" + redisSession.getIdInternal()));
            }
        }
    }

    public void processExpires() {
    }

    private Set<HostAndPort> parseHostAndPort() throws Exception {
        try {
            if (this.redisNodes == null || this.redisNodes.length() == 0) {
                throw new RuntimeException("redis\u95c6\u55d9\u5162\u95b0\u5d87\u7586\u95bf\u6b12\ue1e4");
            }
            String[] nodes = this.redisNodes.split(",");
            HashSet<HostAndPort> haps = new HashSet<HostAndPort>();
            for (String node : nodes) {
                boolean isIpPort = this.p.matcher(node).matches();
                if (!isIpPort) {
                    throw new IllegalArgumentException("ip \u93b4\ufffd port \u6d93\u5d85\u608e\u5a09\ufffd");
                }
                String[] ipAndPort = node.split(":");
                HostAndPort hap = new HostAndPort(ipAndPort[0], Integer.parseInt(ipAndPort[1]));
                haps.add(hap);
            }
            return haps;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new Exception("\u7459\uff46\u703d jedis \u95b0\u5d87\u7586\u93c2\u56e6\u6b22\u6fb6\u8fab\u89e6", ex);
        }
    }

    private void initializeDatabaseConnection() throws LifecycleException {
        try {
            Set<HostAndPort> haps = this.parseHostAndPort();
            this.connectionPoolConfig.setMaxWaitMillis(this.getMaxWaitMillis());
            this.connectionPoolConfig.setMaxTotal(this.getMaxTotal());
            this.connectionPoolConfig.setMinIdle(this.getMinIdle());
            this.connectionPoolConfig.setMaxIdle(this.getMaxIdle());
            this.jedisCluster = new JedisCluster(haps, this.timeout, this.maxRedirections, (GenericObjectPoolConfig)this.connectionPoolConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LifecycleException("Error connecting to Redis", (Throwable)e);
        }
    }

    private void initializeSerializer() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.log.info((Object)("Attempting to use serializer :" + this.serializationStrategyClass));
        this.serializer = (Serializer)Class.forName(this.serializationStrategyClass).newInstance();
        Loader loader = null;
        if (this.getContainer() != null) {
            loader = this.getContainer().getLoader();
        }
        ClassLoader classLoader = null;
        if (loader != null) {
            classLoader = loader.getClassLoader();
        }
        this.serializer.setClassLoader(classLoader);
    }

    public int getConnectionPoolMaxTotal() {
        return this.connectionPoolConfig.getMaxTotal();
    }

    public void setConnectionPoolMaxTotal(int connectionPoolMaxTotal) {
        this.connectionPoolConfig.setMaxTotal(connectionPoolMaxTotal);
    }

    public int getConnectionPoolMaxIdle() {
        return this.connectionPoolConfig.getMaxIdle();
    }

    public void setConnectionPoolMaxIdle(int connectionPoolMaxIdle) {
        this.connectionPoolConfig.setMaxIdle(connectionPoolMaxIdle);
    }

    public int getConnectionPoolMinIdle() {
        return this.connectionPoolConfig.getMinIdle();
    }

    public void setConnectionPoolMinIdle(int connectionPoolMinIdle) {
        this.connectionPoolConfig.setMinIdle(connectionPoolMinIdle);
    }

    public boolean getLifo() {
        return this.connectionPoolConfig.getLifo();
    }

    public void setLifo(boolean lifo) {
        this.connectionPoolConfig.setLifo(lifo);
    }

    public long getMaxWaitMillis() {
        return this.connectionPoolConfig.getMaxWaitMillis();
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.connectionPoolConfig.setMaxWaitMillis(maxWaitMillis);
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.connectionPoolConfig.getMinEvictableIdleTimeMillis();
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.connectionPoolConfig.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public long getSoftMinEvictableIdleTimeMillis() {
        return this.connectionPoolConfig.getSoftMinEvictableIdleTimeMillis();
    }

    public void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.connectionPoolConfig.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
    }

    public int getNumTestsPerEvictionRun() {
        return this.connectionPoolConfig.getNumTestsPerEvictionRun();
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.connectionPoolConfig.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public boolean getTestOnCreate() {
        return this.connectionPoolConfig.getTestOnCreate();
    }

    public void setTestOnCreate(boolean testOnCreate) {
        this.connectionPoolConfig.setTestOnCreate(testOnCreate);
    }

    public boolean getTestOnBorrow() {
        return this.connectionPoolConfig.getTestOnBorrow();
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.connectionPoolConfig.setTestOnBorrow(testOnBorrow);
    }

    public boolean getTestOnReturn() {
        return this.connectionPoolConfig.getTestOnReturn();
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.connectionPoolConfig.setTestOnReturn(testOnReturn);
    }

    public boolean getTestWhileIdle() {
        return this.connectionPoolConfig.getTestWhileIdle();
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.connectionPoolConfig.setTestWhileIdle(testWhileIdle);
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.connectionPoolConfig.getTimeBetweenEvictionRunsMillis();
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.connectionPoolConfig.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public String getEvictionPolicyClassName() {
        return this.connectionPoolConfig.getEvictionPolicyClassName();
    }

    public void setEvictionPolicyClassName(String evictionPolicyClassName) {
        this.connectionPoolConfig.setEvictionPolicyClassName(evictionPolicyClassName);
    }

    public boolean getBlockWhenExhausted() {
        return this.connectionPoolConfig.getBlockWhenExhausted();
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.connectionPoolConfig.setBlockWhenExhausted(blockWhenExhausted);
    }

    public boolean getJmxEnabled() {
        return this.connectionPoolConfig.getJmxEnabled();
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.connectionPoolConfig.setJmxEnabled(jmxEnabled);
    }

    public String getJmxNameBase() {
        return this.connectionPoolConfig.getJmxNameBase();
    }

    public void setJmxNameBase(String jmxNameBase) {
        this.connectionPoolConfig.setJmxNameBase(jmxNameBase);
    }

    public String getJmxNamePrefix() {
        return this.connectionPoolConfig.getJmxNamePrefix();
    }

    public void setJmxNamePrefix(String jmxNamePrefix) {
        this.connectionPoolConfig.setJmxNamePrefix(jmxNamePrefix);
    }

    static enum SessionPersistPolicy {
        DEFAULT,
        SAVE_ON_CHANGE,
        ALWAYS_SAVE_AFTER_REQUEST;


        static SessionPersistPolicy fromName(String name) {
            for (SessionPersistPolicy policy : SessionPersistPolicy.values()) {
                if (!policy.name().equalsIgnoreCase(name)) continue;
                return policy;
            }
            throw new IllegalArgumentException("Invalid session persist policy [" + name + "]. Must be one of " + Arrays.asList(SessionPersistPolicy.values()) + ".");
        }
    }
}

