/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiRuntimeException;
import com.macromedia.generator.api.peer.ContextPeer;

public class Context
extends GenObject {
    public Context() {
        this.peer = ContextPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("unable to create peer");
        }
    }

    protected Context(int n) {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            ContextPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            ContextPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setValue(String string, String string2) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string != null) {
            int n;
            if (string2 == null) {
                string2 = "";
            }
            if ((n = ContextPeer.SetValue(this.peer, string, string2)) == 0) {
                throw new GeneratorApiRuntimeException("error setting value");
            }
        }
    }

    public String getValue(String string) {
        int n;
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string != null && (n = ContextPeer.GetValue(this.peer, string, stringArray)) == 0) {
            stringArray[0] = null;
        }
        return stringArray[0];
    }

    public void setParent(Context context) {
        int n;
        int n2 = 0;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (context != null) {
            n2 = context.peer;
        }
        if ((n = ContextPeer.SetParent(this.peer, n2)) == 0) {
            throw new GeneratorApiRuntimeException("error setting parent");
        }
    }

    public Context getParent() {
        int[] nArray = new int[]{0};
        Context context = null;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ContextPeer.GetParent(this.peer, nArray);
        if (n != 0) {
            context = new Context(nArray[0]);
        }
        return context;
    }

    public String apply(String string) {
        if (string.indexOf(123) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl) {
                if (c == '}') {
                    if (n + 1 < string.length() && string.charAt(n + 1) == '}') {
                        stringBuffer2.append(c);
                        ++n;
                    } else {
                        bl = false;
                        String string2 = this.getValue(stringBuffer2.toString());
                        if (string2 != null) {
                            stringBuffer.append(string2);
                        }
                        stringBuffer2.setLength(0);
                    }
                } else {
                    stringBuffer2.append(c);
                }
            } else if (c == '{') {
                if (n + 1 < string.length() && string.charAt(n + 1) == '{') {
                    stringBuffer.append(c);
                    ++n;
                } else {
                    stringBuffer2.setLength(0);
                    bl = true;
                }
            } else if (c == '}' && n + 1 < string.length() && string.charAt(n + 1) == '}') {
                stringBuffer.append(c);
                ++n;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        String string3 = stringBuffer.toString();
        if (stringBuffer2.length() > 0) {
            string3 = string3 + "{" + stringBuffer2.toString();
        }
        return string3;
    }
}

