/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.Action;
import com.macromedia.generator.api.Bitmap;
import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.Button;
import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.Context;
import com.macromedia.generator.api.Font;
import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.GeneratorApiRuntimeException;
import com.macromedia.generator.api.Matrix;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.Serial;
import com.macromedia.generator.api.Shape;
import com.macromedia.generator.api.Sound;
import com.macromedia.generator.api.Text;
import com.macromedia.generator.api.peer.BufferPeer;
import com.macromedia.generator.api.peer.ScriptPeer;
import com.macromedia.generator.platform.Mac;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;

public class Script
extends GenObject {
    public Script() {
        this.peer = ScriptPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("unable to create peer");
        }
    }

    protected Script(int n) {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            ScriptPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            ScriptPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setSerial(Serial serial) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = serial != null ? serial.peer : 0;
        ScriptPeer.SetSerial(this.peer, n);
    }

    public void setFile(String string, boolean bl) throws GeneratorApiException {
        int n;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        Mac mac = Mac.getMac();
        if (mac != null) {
            string = mac.makeSystemPretty(string);
        }
        if ((n = ScriptPeer.SetFile(this.peer, string, bl)) == 0) {
            throw new GeneratorApiException("error setting file");
        }
    }

    public void setBuffer(Buffer buffer) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.SetBuffer(this.peer, buffer.peer);
        if (n == 0) {
            throw new GeneratorApiException("error setting buffer");
        }
    }

    public void insertAction(Action action, int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.InsertAction(this.peer, action.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error inserting action");
        }
    }

    public void insertObject(GenObject genObject, int n, int n2, Matrix matrix, int n3, Matrix matrix2, GenObject genObject2, String string) throws GeneratorApiException {
        String string2;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n4 = genObject2 != null ? genObject2.peer : 0;
        int n5 = ScriptPeer.InsertObject(this.peer, genObject.peer, n, n2, matrix.peer, n3, matrix2.peer, n4, string2 = string != null ? string : "");
        if (n5 == 0) {
            throw new GeneratorApiException("error inserting object");
        }
    }

    public void insertScript(Script script, int n, int n2, Matrix matrix, int n3, Matrix matrix2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n4 = ScriptPeer.InsertScript(this.peer, script.peer, n, n2, matrix.peer, n3, matrix2.peer);
        if (n4 == 0) {
            throw new GeneratorApiException("error inserting script");
        }
    }

    public void insertButton(Button button, int n, int n2, Matrix matrix, int n3, Matrix matrix2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n4 = ScriptPeer.InsertButton(this.peer, button.peer, n, n2, matrix.peer, n3, matrix2.peer);
        if (n4 == 0) {
            throw new GeneratorApiException("error inserting button");
        }
    }

    public void insertShape(Shape shape, int n, int n2, Matrix matrix, int n3, Matrix matrix2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n4 = ScriptPeer.InsertShape(this.peer, shape.peer, n, n2, matrix.peer, n3, matrix2.peer);
        if (n4 == 0) {
            throw new GeneratorApiException("error inserting shape");
        }
    }

    public void insertText(Text text, int n, int n2, Matrix matrix, int n3, Matrix matrix2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n4 = ScriptPeer.InsertText(this.peer, text.peer, n, n2, matrix.peer, n3, matrix2.peer);
        if (n4 == 0) {
            throw new GeneratorApiException("error inserting text");
        }
    }

    public void insertBitmap(Bitmap bitmap, int n, int n2, Matrix matrix, int n3, Matrix matrix2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n4 = ScriptPeer.InsertBitmap(this.peer, bitmap.peer, n, n2, matrix.peer, n3, matrix2.peer);
        if (n4 == 0) {
            throw new GeneratorApiException("error inserting bitmap");
        }
    }

    public void MP3convert(Buffer buffer, Buffer buffer2, int n, int n2, int n3, int n4, int n5) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n6 = ScriptPeer.MP3convert(this.peer, buffer.peer, buffer2.peer, n, n2, n3, n4, n5);
        if (n6 == 0) {
            throw new GeneratorApiException("error inserting MP3 sound file");
        }
    }

    public void insertAnimatedBitmap(String string, int n, int n2, Matrix matrix, int n3, Matrix matrix2, boolean bl, int n4, int n5, int n6) throws GeneratorApiException {
        int n7;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        Mac mac = Mac.getMac();
        if (mac != null) {
            String string2 = mac.makeSystemPretty(string);
            n7 = ScriptPeer.InsertAnimatedBitmap(this.peer, string2, n, n2, matrix.peer, n3, matrix2.peer, bl, n4, n5, n6);
        } else {
            n7 = ScriptPeer.InsertAnimatedBitmap(this.peer, string, n, n2, matrix.peer, n3, matrix2.peer, bl, n4, n5, n6);
        }
        if (n7 == 0) {
            throw new GeneratorApiException("error inserting bitmap");
        }
    }

    public void insertAnimatedBitmapBuffer(Buffer buffer, int n, int n2, Matrix matrix, int n3, Matrix matrix2, boolean bl, int n4, int n5, int n6) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n7 = ScriptPeer.InsertAnimatedBitmapBuffer(this.peer, buffer.peer, n, n2, matrix.peer, n3, matrix2.peer, bl, n4, n5, n6);
        if (n7 == 0) {
            throw new GeneratorApiException("error inserting bitmap");
        }
    }

    public void insertBackgroundRgb(int n) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.InsertBackgroundRgb(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error inserting background rgb color");
        }
    }

    public void insertBackgroundColor(Color color) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.InsertBackgroundColor(this.peer, color.peer);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error inserting background color");
        }
    }

    public void insertFrames(int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n3 = ScriptPeer.InsertFrames(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error inserting frames");
        }
    }

    public void insertSound(Sound sound, int n, int n2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n3 = ScriptPeer.InsertSound(this.peer, sound.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error inserting sound");
        }
    }

    public void mergeScript(Script script, int n, int n2, int n3, int n4, Matrix matrix) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n5 = ScriptPeer.MergeScript(this.peer, script.peer, n, n2, n3, n4, matrix.peer);
        if (n5 == 0) {
            throw new GeneratorApiException("error merging script");
        }
    }

    public void appendScript(Script script) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.AppendScript(this.peer, script.peer);
        if (n == 0) {
            throw new GeneratorApiException("error appending script");
        }
    }

    public Buffer writeBuffer() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (ScriptPeer.Write(this.peer, nArray) == 0) {
            throw new GeneratorApiRuntimeException("unable to write to buffer");
        }
        return new Buffer(nArray[0]);
    }

    public void writeFile(String string) throws GeneratorApiException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        if (ScriptPeer.Write(this.peer, nArray2) == 0) {
            throw new GeneratorApiException("unable to write " + string);
        }
        BufferPeer.GetBufferCount(nArray2[0], nArray);
        if (nArray[0] > 0) {
            try {
                File file = new File(string);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                int n = 0;
                while (n < nArray[0]) {
                    int[] nArray3 = new int[]{0};
                    BufferPeer.GetBufferSize(nArray2[0], n, nArray3);
                    byte[] byArray = new byte[nArray3[0]];
                    BufferPeer.GetBuffer(nArray2[0], n, byArray);
                    fileOutputStream.write(byArray);
                    ++n;
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                BufferPeer.Release(nArray2[0]);
                throw new GeneratorApiException("unable to write " + string);
            }
        }
        BufferPeer.Release(nArray2[0]);
    }

    public void writeStream(OutputStream outputStream) throws GeneratorApiException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (ScriptPeer.Write(this.peer, nArray2) == 0) {
            throw new GeneratorApiException("unable to write to stream");
        }
        BufferPeer.GetBufferCount(nArray2[0], nArray);
        if (nArray[0] > 0) {
            try {
                int n = 0;
                while (n < nArray[0]) {
                    int[] nArray3 = new int[]{0};
                    BufferPeer.GetBufferSize(nArray2[0], n, nArray3);
                    byte[] byArray = new byte[nArray3[0]];
                    BufferPeer.GetBuffer(nArray2[0], n, byArray);
                    outputStream.write(byArray);
                    ++n;
                }
            }
            catch (IOException iOException) {
                BufferPeer.Release(nArray2[0]);
                throw new GeneratorApiException("unable to write to stream");
            }
        }
        BufferPeer.Release(nArray2[0]);
    }

    public void setWidth(int n) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = n * 20;
        int n3 = ScriptPeer.SetWidth(this.peer, n2);
        if (n3 == 0) {
            throw new GeneratorApiRuntimeException("error setting width");
        }
    }

    public int getWidth() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetWidth(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting width");
        }
        return nArray[0];
    }

    public void setHeight(int n) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = n * 20;
        int n3 = ScriptPeer.SetHeight(this.peer, n2);
        if (n3 == 0) {
            throw new GeneratorApiRuntimeException("error setting height");
        }
    }

    public int getHeight() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetHeight(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting height");
        }
        return nArray[0];
    }

    public Rect getBounds() {
        Rect rect = null;
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetBounds(this.peer, nArray);
        if (n != 0) {
            rect = new Rect(nArray[0]);
        }
        return rect;
    }

    public void setFrameRate(float f) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.SetFrameRate(this.peer, f);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error setting frame rate");
        }
    }

    public float getFrameRate() {
        float[] fArray = new float[]{0.0f};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetFrameRate(this.peer, fArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting frame rate");
        }
        return fArray[0];
    }

    public int getCommandCount() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetCommandCount(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting command count");
        }
        return nArray[0];
    }

    public String getCommandString(int n) {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetCommandString(this.peer, n, stringArray);
        if (n2 == 0) {
            return null;
        }
        return stringArray[0];
    }

    public int getCommandFrameIndex(int n) {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetCommandFrameIndex(this.peer, n, nArray);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error getting command frame index");
        }
        return nArray[0];
    }

    public int getCommandFrameCount(int n) {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetCommandFrameCount(this.peer, n, nArray);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error getting command frame count");
        }
        return nArray[0];
    }

    public int getCommandLayer(int n) {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetCommandLayer(this.peer, n, nArray);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error getting command layer");
        }
        return nArray[0];
    }

    public void setCommandScript(int n, Script script) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = script != null ? script.peer : 0;
        int n3 = ScriptPeer.SetCommandScript(this.peer, n, n2);
        if (n3 == 0) {
            throw new GeneratorApiException("error setting command script");
        }
    }

    public Script getCommandScript(int n) {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetCommandScript(this.peer, n, nArray);
        if (n2 == 0) {
            return null;
        }
        if (nArray[0] == 0) {
            return null;
        }
        return new Script(nArray[0]);
    }

    public void setCommandMask(int n, GenObject genObject) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.SetCommandMask(this.peer, n, genObject.peer);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting command mask");
        }
    }

    public void setCommandLabel(int n, String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        String string2 = string != null ? string : "";
        int n2 = ScriptPeer.SetCommandLabel(this.peer, n, string2);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting command label");
        }
    }

    public Rect getCommandRect(int n) throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetCommandRect(this.peer, n, nArray);
        if (n2 == 0) {
            return null;
        }
        if (nArray[0] == 0) {
            return null;
        }
        return new Rect(nArray[0]);
    }

    public void setCommandTint(int n, int n2, float f) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n3 = ScriptPeer.SetCommandTint(this.peer, n, n2, f);
        if (n3 == 0) {
            throw new GeneratorApiRuntimeException("error setting tint");
        }
    }

    public void setCommandBrightness(int n, float f) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.SetCommandBrightness(this.peer, n, f);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error setting brightness");
        }
    }

    public void setCommandTransparency(int n, float f) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.SetCommandTransparency(this.peer, n, f);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error setting transparency");
        }
    }

    public void setCommandColor(int n, float f, int n2, float f2, int n3, float f3, int n4, float f4, int n5) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n6 = ScriptPeer.SetCommandColor(this.peer, n, f, n2, f2, n3, f3, n4, f4, n5);
        if (n6 == 0) {
            throw new GeneratorApiRuntimeException("error setting custom color");
        }
    }

    public void setCommandMatrix(int n, Matrix matrix) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.SetCommandMatrix(this.peer, n, matrix.peer);
        if (n2 == 0) {
            throw new GeneratorApiRuntimeException("error setting matrix");
        }
    }

    public Matrix getCommandMatrix(int n) throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetCommandMatrix(this.peer, n, nArray);
        if (n2 == 0) {
            return null;
        }
        if (nArray[0] == 0) {
            return null;
        }
        return new Matrix(nArray[0]);
    }

    public void addExternalMedia(Script script) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.AddExternalMedia(this.peer, script.peer);
        if (n == 0) {
            throw new GeneratorApiException("error adding external media");
        }
    }

    public void newExternalFont(Font font) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.NewExternalFont(this.peer, font.peer);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error applying the context");
        }
    }

    public int getExternalFontCount() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetExternalFontCount(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting external font count");
        }
        return nArray[0];
    }

    public String getExternalFontFile(int n) {
        String[] stringArray = new String[1];
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetExternalFontFile(this.peer, n, stringArray);
        if (n2 == 0) {
            return null;
        }
        return stringArray[0];
    }

    public void loadExternalFontFile(int n, String string, boolean bl) throws GeneratorApiException {
        int n2;
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        Mac mac = Mac.getMac();
        if (mac != null) {
            string = mac.makeSystemPretty(string);
        }
        if ((n2 = ScriptPeer.LoadExternalFontFile(this.peer, n, string, bl)) == 0) {
            throw new GeneratorApiException("error loading external font file");
        }
    }

    public void loadExternalFontBuffer(int n, Buffer buffer) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.LoadExternalFontBuffer(this.peer, n, buffer.peer);
        if (n2 == 0) {
            throw new GeneratorApiException("error loading external font file");
        }
    }

    public int getLastFrame() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetLastFrame(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting last frame index");
        }
        return nArray[0];
    }

    public boolean getIsCommand() {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetIsCommand(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting command flag");
        }
        return blArray[0];
    }

    public boolean getIsReferenced() {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetIsReferenced(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting referenced flag");
        }
        return blArray[0];
    }

    public boolean getIsProcessed() {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetIsProcessed(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting processed flag");
        }
        return blArray[0];
    }

    public void setIsProcessed(boolean bl) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.SetIsProcessed(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error setting processed flag");
        }
    }

    public boolean getLoadTopDown() {
        boolean[] blArray = new boolean[]{false};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetLoadTopDown(this.peer, blArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting load top down flag");
        }
        return blArray[0];
    }

    public void setLoadTopDown(boolean bl) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.SetLoadTopDown(this.peer, bl);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error setting load top down flag");
        }
    }

    public int findFrameLabel(String string) throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            throw new GeneratorApiException("null string");
        }
        int n = ScriptPeer.FindFrameLabel(this.peer, string, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting frame label");
        }
        return nArray[0];
    }

    public int getScriptCount() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.GetScriptCount(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error getting script count");
        }
        return nArray[0];
    }

    public Script getScript(int n) {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.GetScript(this.peer, n, nArray);
        if (n2 == 0) {
            return null;
        }
        return new Script(nArray[0]);
    }

    public Script findScript(String string) {
        int n;
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            string = "";
        }
        if ((n = ScriptPeer.FindScript(this.peer, string, nArray)) == 0) {
            return null;
        }
        return new Script(nArray[0]);
    }

    public Script copyScript() {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.CopyScript(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error copying script");
        }
        return new Script(nArray[0]);
    }

    public Sound findSound(String string) {
        int n;
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null) {
            string = "";
        }
        if ((n = ScriptPeer.FindSound(this.peer, string, nArray)) == 0) {
            return null;
        }
        return new Sound(nArray[0]);
    }

    public void applyContext(Context context) {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.ApplyContext(this.peer, context.peer);
        if (n == 0) {
            throw new GeneratorApiRuntimeException("error applying the context");
        }
    }

    public Buffer writeText() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (ScriptPeer.WriteText(this.peer, nArray) == 0) {
            throw new GeneratorApiRuntimeException("unable to write text to the buffer");
        }
        return new Buffer(nArray[0]);
    }

    public int getFileVersion() throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int[] nArray = new int[]{0};
        int n = ScriptPeer.GetFileVersion(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting file version");
        }
        return nArray[0];
    }

    public void setFileVersion(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n2 = ScriptPeer.SetFileVersion(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting file version");
        }
    }

    public void extrude(Script script, float f, int n, Color color, Color color2, int n2, Color color3, float f2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n3 = ScriptPeer.Extrude(this.peer, script.getPeer(), f, n, color.getPeer(), color2.getPeer(), n2, color3.getPeer(), f2);
        if (n3 == 0) {
            throw new GeneratorApiException("error extruding");
        }
    }

    public void addTag(String string) throws GeneratorApiException {
        this.addTag(string, "");
    }

    public void addTag(String string, String string2) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        int n = ScriptPeer.AddTag(this.peer, string, string2);
        if (n == 0) {
            throw new GeneratorApiException("error adding tag");
        }
    }

    public void addCommand(String string, Properties properties, int n, int n2, int n3) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiRuntimeException("invalid peer");
        }
        if (string == null || string.length() == 0) {
            throw new GeneratorApiRuntimeException("invalid command name");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("command")) continue;
            String string3 = properties.getProperty(string2);
            string = string + " " + string2 + "=\"" + string3 + "\"";
        }
        int n4 = ScriptPeer.AddCommand(this.peer, string, n, n2, n3);
        if (n4 == 0) {
            throw new GeneratorApiException("error adding tag");
        }
    }
}

