/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.app;

import com.macromedia.generator.api.Buffer;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.app.CacheLog;
import com.macromedia.generator.app.GenCache;
import com.macromedia.generator.app.GenCacheEntry;
import com.macromedia.generator.app.RequestCacheValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RequestCache
extends GenCache {
    protected boolean mForce = false;

    public RequestCache(long l, boolean bl, boolean bl2, long l2, CacheLog cacheLog) {
        super(l, bl2, l2, cacheLog);
        this.setForce(bl);
    }

    protected boolean addRequest(String string, Buffer buffer, boolean bl, long l) {
        if (this.isCacheEnabled() && (this.getForce() || bl)) {
            RequestCacheValue requestCacheValue = new RequestCacheValue();
            if (requestCacheValue == null) {
                return false;
            }
            byte[] byArray = this.getBufferData(buffer);
            if (byArray == null) {
                return false;
            }
            requestCacheValue.request = string;
            requestCacheValue.data = byArray;
            if (!this.verifyRequestCacheValue(requestCacheValue)) {
                return false;
            }
            return this.setCacheRequest(requestCacheValue, l);
        }
        return false;
    }

    protected Buffer getMatchingRequestBuffer(String string) {
        if (!this.isCacheEnabled()) {
            return null;
        }
        RequestCacheValue requestCacheValue = this.getCacheRequest(string);
        if (requestCacheValue == null) {
            return null;
        }
        if (!this.verifyRequestCacheValue(requestCacheValue)) {
            return null;
        }
        Buffer buffer = null;
        try {
            buffer = new Buffer();
            if (buffer == null) {
                return null;
            }
            buffer.write(requestCacheValue.data);
        }
        catch (GeneratorApiException generatorApiException) {
            this.logCacheMessage(generatorApiException.toString(), 5);
            return null;
        }
        return buffer;
    }

    private byte[] getBufferData(Buffer buffer) {
        byte[] byArray = null;
        try {
            int n = buffer.getBufferCount();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            while (n2 < n) {
                byte[] byArray2 = buffer.getBuffer(n2);
                if (byArray2 != null) {
                    byteArrayOutputStream.write(byArray2);
                }
                ++n2;
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (GeneratorApiException generatorApiException) {
            this.logCacheMessage(generatorApiException.toString(), 5);
            return null;
        }
        catch (IOException iOException) {
            this.logCacheMessage(iOException.toString(), 5);
            return null;
        }
        return byArray;
    }

    protected boolean setCacheRequest(RequestCacheValue requestCacheValue, long l) {
        if (!this.isCacheEnabled()) {
            return false;
        }
        if (!this.verifyRequestCacheValue(requestCacheValue)) {
            return false;
        }
        long l2 = requestCacheValue.data.length;
        return this.setCacheValue(requestCacheValue.request, requestCacheValue, l2, l);
    }

    protected RequestCacheValue getCacheRequest(String string) {
        if (!this.isCacheEnabled()) {
            return null;
        }
        return (RequestCacheValue)this.getCacheValue(string);
    }

    protected boolean verifyRequestCacheValue(RequestCacheValue requestCacheValue) {
        return requestCacheValue != null && requestCacheValue.request != null && requestCacheValue.data != null;
    }

    public boolean getForce() {
        return this.mForce;
    }

    public void setForce(boolean bl) {
        this.mForce = bl;
        this.logCacheMessage(this.getResString("SetForce") + new Boolean(bl).toString(), 2);
    }

    protected boolean verifyCacheValue(GenCacheEntry genCacheEntry) {
        if (genCacheEntry == null) {
            return false;
        }
        RequestCacheValue requestCacheValue = (RequestCacheValue)genCacheEntry.value;
        return this.verifyRequestCacheValue(requestCacheValue);
    }

    protected void logCacheMessage(String string, int n) {
        if (this.mLog != null) {
            String string2 = "RequestCache: " + string;
            super.logCacheMessage(string2, n);
        }
    }
}

