/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.utils;

import com.macromedia.generator.api.Action;
import com.macromedia.generator.api.Button;
import com.macromedia.generator.api.Color;
import com.macromedia.generator.api.Context;
import com.macromedia.generator.api.FillStyle;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.LineStyle;
import com.macromedia.generator.api.Matrix;
import com.macromedia.generator.api.Rect;
import com.macromedia.generator.api.Shape;
import com.macromedia.generator.app.FlashEnvironment;
import com.macromedia.generator.app.GenVector;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ActionParser {
    GenVector mGenVector;
    Context mContext;
    Properties mParams;
    StreamTokenizer tokenizer = null;
    StringTokenizer strTokenizer = null;
    Vector actionVector = new Vector(5, 5);
    FlashEnvironment mEnv = null;
    boolean mVerbose = true;
    int tokenType = 0;

    public ActionParser(FlashEnvironment flashEnvironment, boolean bl) {
        this.mEnv = flashEnvironment;
        this.mVerbose = bl;
    }

    public Action[] ParseActionsFromString(String string) {
        if (this.actionVector == null) {
            this.actionVector = new Vector(5, 5);
        }
        this.strTokenizer = new StringTokenizer(string);
        this.ParseActions();
        int n = this.actionVector.size();
        Action[] actionArray = null;
        if (n > 0) {
            actionArray = new Action[n];
            Enumeration enumeration = this.actionVector.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                actionArray[n2++] = (Action)enumeration.nextElement();
            }
        }
        this.actionVector = null;
        this.strTokenizer = null;
        return actionArray;
    }

    public Action[] ParseActionsFromFile(String string) {
        Action[] actionArray;
        if (this.actionVector == null) {
            this.actionVector = new Vector(5, 5);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            actionArray = new BufferedReader(new InputStreamReader(fileInputStream));
            this.tokenizer = new StreamTokenizer((Reader)actionArray);
            this.tokenizer.ordinaryChar(46);
            this.tokenizer.ordinaryChar(47);
            this.tokenizer.ordinaryChar(58);
            this.tokenizer.parseNumbers();
            this.ParseActions();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.LogMessage("Failed to open data source: " + fileNotFoundException);
            return null;
        }
        catch (IOException iOException) {
            this.LogMessage("Error getting token: " + iOException);
            return null;
        }
        this.tokenizer = null;
        int n = this.actionVector.size();
        actionArray = null;
        if (n > 0) {
            actionArray = new Action[n];
            Enumeration enumeration = this.actionVector.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                actionArray[n2++] = (Action)enumeration.nextElement();
            }
        }
        this.actionVector = null;
        return actionArray;
    }

    private int GetTokenType() {
        return this.tokenType;
    }

    private String GetNextToken() {
        String string;
        block14: {
            string = null;
            if (this.tokenizer != null) {
                try {
                    this.tokenizer.nextToken();
                    this.tokenType = this.tokenizer.ttype;
                    if (this.tokenizer.ttype == -3) {
                        string = this.tokenizer.sval;
                        break block14;
                    }
                    if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == 39) {
                        string = this.tokenizer.sval;
                        break block14;
                    }
                    if (this.tokenizer.ttype == -2) {
                        int n = (int)this.tokenizer.nval;
                        double d = n;
                        string = d == this.tokenizer.nval ? Integer.toString((int)this.tokenizer.nval) : Double.toString(this.tokenizer.nval);
                        break block14;
                    }
                    if (this.tokenizer.ttype == -1) {
                        this.LogMessage("EOF");
                        break block14;
                    }
                    this.LogMessage("Unknown tokenizer type: " + this.tokenizer.ttype);
                }
                catch (IOException iOException) {
                    this.LogMessage("error getting token: " + iOException);
                }
            } else if (this.strTokenizer != null) {
                try {
                    string = this.strTokenizer.nextToken();
                    this.tokenType = -3;
                    if (string != null) {
                        if (string.startsWith("\"")) {
                            string = string.substring(1);
                        }
                        if (string.endsWith("\"")) {
                            string = string.substring(0, string.length() - 1);
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.tokenType = -1;
                    this.LogMessage("EOF");
                }
            }
        }
        return string;
    }

    private void ParseActions() {
        String string = null;
        try {
            Action action = new Action();
            this.actionVector.addElement(action);
            action.setTransitionState(4);
            string = this.GetNextToken();
            while (this.GetTokenType() != -1) {
                int n;
                String string2;
                if (string.equalsIgnoreCase("newAction")) {
                    action = new Action();
                    this.actionVector.addElement(action);
                    action.setTransitionState(4);
                    this.LogMessage("New Action");
                } else if (string.equalsIgnoreCase("transition")) {
                    string2 = this.GetNextToken();
                    this.LogMessage("Transition: " + string2);
                    n = this.DecodeTransition(string2);
                    action.setTransitionState(n);
                } else if (string.equalsIgnoreCase("push")) {
                    string2 = this.GetNextToken();
                    if (string2 != null) {
                        this.LogMessage("Push: " + string2);
                        action.addPush(string2);
                    } else {
                        this.LogMessage("Push argument error");
                    }
                } else if (string.equalsIgnoreCase("GotoFrame")) {
                    string2 = this.GetNextToken();
                    this.LogMessage("GotoFrame " + string2);
                    action.addGotoFrame(Integer.parseInt(string2));
                } else if (string.equalsIgnoreCase("GetURL")) {
                    string2 = this.GetNextToken();
                    String string3 = this.GetNextToken();
                    this.LogMessage("GetURL: " + string2 + ", " + string3);
                    action.addGetURL(string2, string3);
                } else if (string.equalsIgnoreCase("NextFrame")) {
                    this.LogMessage("NextFrame");
                    action.addNextFrame();
                } else if (string.equalsIgnoreCase("PrevFrame")) {
                    this.LogMessage("PrevFrame");
                    action.addPrevFrame();
                } else if (string.equalsIgnoreCase("Play")) {
                    this.LogMessage("Play");
                    action.addPlay();
                } else if (string.equalsIgnoreCase("Stop")) {
                    this.LogMessage("Stop");
                    action.addStop();
                } else if (string.equalsIgnoreCase("ToggleQuality")) {
                    this.LogMessage("ToggleQuality");
                    action.addToggleQuality();
                } else if (string.equalsIgnoreCase("StopSounds")) {
                    this.LogMessage("StopSounds");
                    action.addStopSounds();
                } else if (string.equalsIgnoreCase("WaitForFrame")) {
                    string2 = this.GetNextToken();
                    this.LogMessage("WaitForFrame " + string2);
                    action.addWaitForFrame(Integer.parseInt(string2));
                } else if (string.equalsIgnoreCase("TellTarget")) {
                    string2 = this.GetNextToken();
                    this.LogMessage("TellTarget " + string2);
                    action.addTellTarget(string2);
                } else if (string.equalsIgnoreCase("GotoLabel")) {
                    string2 = this.GetNextToken();
                    this.LogMessage("GotoLabel " + string2);
                    action.addGotoLabel(string2);
                } else if (string.equalsIgnoreCase("Add")) {
                    this.LogMessage("Add");
                    action.addAdd();
                } else if (string.equalsIgnoreCase("Subtract")) {
                    this.LogMessage("Subtract");
                    action.addSubtract();
                } else if (string.equalsIgnoreCase("Multiply")) {
                    this.LogMessage("Multiply");
                    action.addMultiply();
                } else if (string.equalsIgnoreCase("Divide")) {
                    this.LogMessage("Divide");
                    action.addDivide();
                } else if (string.equalsIgnoreCase("Eq") || string.equalsIgnoreCase("Equals")) {
                    this.LogMessage("Eq");
                    action.addEq();
                } else if (string.equalsIgnoreCase("Less")) {
                    this.LogMessage("Less");
                    action.addLess();
                } else if (string.equalsIgnoreCase("And")) {
                    this.LogMessage("And");
                    action.addAnd();
                } else if (string.equalsIgnoreCase("Or")) {
                    this.LogMessage("Or");
                    action.addOr();
                } else if (string.equalsIgnoreCase("Not")) {
                    this.LogMessage("Not");
                    action.addNot();
                } else if (string.equalsIgnoreCase("StringEq") || string.equalsIgnoreCase("StringEquals") || string.equalsIgnoreCase("StrEq") || string.equalsIgnoreCase("StrEquals")) {
                    this.LogMessage("StringEq");
                    action.addStringEq();
                } else if (string.equalsIgnoreCase("StringLen") || string.equalsIgnoreCase("StringLength") || string.equalsIgnoreCase("StrLen") || string.equalsIgnoreCase("StrLength")) {
                    this.LogMessage("StringLength");
                    action.addStringLength();
                } else if (string.equalsIgnoreCase("StringAdd") || string.equalsIgnoreCase("StrAdd")) {
                    this.LogMessage("StringAdd");
                    action.addStringAdd();
                } else if (string.equalsIgnoreCase("StringExtract") || string.equalsIgnoreCase("StrExtract")) {
                    this.LogMessage("StringExtract");
                    action.addStringExtract();
                } else if (string.equalsIgnoreCase("Push")) {
                    string2 = this.GetNextToken();
                    this.LogMessage("Push " + string2);
                    action.addPush(string2);
                } else if (string.equalsIgnoreCase("Pop")) {
                    this.LogMessage("Pop");
                    action.addPop();
                } else if (string.equalsIgnoreCase("ToInteger")) {
                    this.LogMessage("ToInteger");
                    action.addToInteger();
                } else if (string.equalsIgnoreCase("Jump")) {
                    this.LogMessage("Jump");
                    action.addJump();
                } else if (string.equalsIgnoreCase("EndJump")) {
                    this.LogMessage("EndJump");
                    action.addEndJump();
                } else if (string.equalsIgnoreCase("If")) {
                    this.LogMessage("If");
                    action.addIf();
                } else if (string.equalsIgnoreCase("EndIf")) {
                    this.LogMessage("EndIf");
                    action.addEndIf();
                } else if (string.equalsIgnoreCase("Call")) {
                    this.LogMessage("Call");
                    action.addCall();
                } else if (string.equalsIgnoreCase("GetVariable")) {
                    this.LogMessage("GetVariable");
                    action.addGetVariable();
                } else if (string.equalsIgnoreCase("SetVariable")) {
                    this.LogMessage("SetVariable");
                    action.addSetVariable();
                } else if (string.equalsIgnoreCase("GetURL2")) {
                    string2 = this.GetNextToken();
                    this.LogMessage("GetURL2: " + string2);
                    n = 0;
                    if (string2.equalsIgnoreCase("GET")) {
                        n = 129;
                    } else if (string2.equalsIgnoreCase("POST")) {
                        n = 130;
                    } else if (string2.equalsIgnoreCase("MOVIE") || string2.equalsIgnoreCase("LOADMOVIE")) {
                        n = 0;
                    } else {
                        if (!string2.equalsIgnoreCase("NOSEND")) {
                            this.LogMessage("Unrecognized send type.  Using NOSEND");
                        }
                        n = 128;
                    }
                    action.addGetURL2(n);
                } else if (string.equalsIgnoreCase("GotoFrame2")) {
                    this.LogMessage("GotoFrame2");
                    action.addGotoFrame2();
                } else if (string.equalsIgnoreCase("PushProperty") || string.equalsIgnoreCase("PushProp")) {
                    string2 = this.GetNextToken();
                    n = this.GetPropertyToken(string2);
                    action.addPushProperty(n);
                } else if (string.equalsIgnoreCase("SetTarget2")) {
                    this.LogMessage("SetTarget2");
                    action.addSetTarget2();
                } else if (string.equalsIgnoreCase("GetProperty")) {
                    this.LogMessage("GetProperty");
                    action.addGetProperty();
                } else if (string.equalsIgnoreCase("SetProperty")) {
                    this.LogMessage("SetProperty");
                    action.addSetProperty();
                } else if (string.equalsIgnoreCase("CloneSprite")) {
                    this.LogMessage("CloneSprite");
                    action.addCloneSprite();
                } else if (string.equalsIgnoreCase("RemoveSprite")) {
                    this.LogMessage("RemoveSprite");
                    action.addRemoveSprite();
                } else if (string.equalsIgnoreCase("Trace")) {
                    this.LogMessage("Trace");
                    action.addTrace();
                } else if (string.equalsIgnoreCase("StartDrag")) {
                    this.LogMessage("StartDrag");
                    action.addStartDrag();
                } else if (string.equalsIgnoreCase("EndDrag")) {
                    this.LogMessage("EndDrag");
                    action.addEndDrag();
                } else if (string.equalsIgnoreCase("StringLess")) {
                    this.LogMessage("StringLess");
                    action.addStringLess();
                } else if (string.equalsIgnoreCase("WaitForFrame2")) {
                    this.LogMessage("WaitForFrame2");
                    action.addWaitForFrame2();
                } else if (string.equalsIgnoreCase("RandomNumber")) {
                    this.LogMessage("RandomNumber");
                    action.addRandomNumber();
                } else if (string.equalsIgnoreCase("MBStringLength")) {
                    this.LogMessage("MBStringLength");
                    action.addMBStringLength();
                } else if (string.equalsIgnoreCase("CharToAscii")) {
                    this.LogMessage("CharToAscii");
                    action.addCharToAscii();
                } else if (string.equalsIgnoreCase("AsciiToChar")) {
                    this.LogMessage("AsciiToChar");
                    action.addAsciiToChar();
                } else if (string.equalsIgnoreCase("GetTime")) {
                    this.LogMessage("GetTime ");
                    action.addGetTime();
                } else if (string.equalsIgnoreCase("MBStringExtract")) {
                    this.LogMessage("MBStringExtract");
                    action.addMBStringExtract();
                } else if (string.equalsIgnoreCase("MBCharToAscii")) {
                    this.LogMessage("MBCharToAscii");
                    action.addMBCharToAscii();
                } else if (string.equalsIgnoreCase("MBAsciiToChar")) {
                    this.LogMessage("MBAsciiToChar");
                    action.addMBAsciiToChar();
                } else {
                    this.LogMessage("Unknown command: " + string);
                    return;
                }
                string = this.GetNextToken();
            }
        }
        catch (GeneratorApiException generatorApiException) {
            this.LogMessage("api exception: " + generatorApiException);
        }
        catch (NumberFormatException numberFormatException) {
            this.LogMessage("Number format exception: " + numberFormatException);
        }
    }

    private int GetPropertyToken(String string) {
        int n = 1;
        if (string.equalsIgnoreCase("xpos") || string.equalsIgnoreCase("xposition")) {
            n = 1;
        } else if (string.equalsIgnoreCase("ypos") || string.equalsIgnoreCase("yposition")) {
            n = 2;
        } else if (string.equalsIgnoreCase("xscale")) {
            n = 3;
        } else if (string.equalsIgnoreCase("yscale")) {
            n = 4;
        } else if (string.equalsIgnoreCase("alpha")) {
            n = 5;
        } else if (string.equalsIgnoreCase("vis") || string.equalsIgnoreCase("visibility")) {
            n = 6;
        } else if (string.equalsIgnoreCase("rot") || string.equalsIgnoreCase("rotation")) {
            n = 7;
        } else if (string.equalsIgnoreCase("name")) {
            n = 8;
        } else {
            this.LogMessage("Invalid property: " + string);
        }
        return n;
    }

    private int DecodeTransition(String string) {
        int n = 4;
        if (string.equalsIgnoreCase("Enter")) {
            n = 1;
        } else if (string.equalsIgnoreCase("Down")) {
            n = 4;
        } else if (string.equalsIgnoreCase("Up")) {
            n = 64;
        } else if (string.equalsIgnoreCase("Exit")) {
            n = 272;
        } else {
            this.LogMessage("InvalidTransition: " + string);
        }
        return n;
    }

    private Button BuildButton(Rect rect) {
        Button button = null;
        try {
            Matrix matrix = new Matrix();
            button = new Button(true);
            Shape shape = this.BuildShape(rect, "red");
            Shape shape2 = this.BuildShape(rect, "green");
            Shape shape3 = this.BuildShape(rect, "yellow");
            Shape shape4 = this.BuildShape(rect, "black");
            button.addShape(shape, matrix, 1, 1);
            button.addShape(shape2, matrix, 2, 1);
            button.addShape(shape3, matrix, 4, 1);
            button.addShape(shape4, matrix, 8, 1);
        }
        catch (GeneratorApiException generatorApiException) {
            this.LogError("API Exception: " + generatorApiException);
        }
        return button;
    }

    private Shape BuildShape(Rect rect, String string) {
        Shape shape = null;
        try {
            int n = rect.getXMin();
            int n2 = rect.getYMin();
            int n3 = rect.getXMax();
            int n4 = rect.getYMax();
            shape = new Shape();
            Color color = new Color();
            color.setRGBValue(string);
            FillStyle fillStyle = new FillStyle();
            FillStyle fillStyle2 = new FillStyle();
            fillStyle.setColor(color);
            shape.setFillStyle(fillStyle, fillStyle2);
            LineStyle lineStyle = new LineStyle();
            Color color2 = new Color();
            color2.setRGBValue("black");
            lineStyle.setColor(color2);
            shape.setLineStyle(lineStyle);
            shape.moveTo(n, n2);
            shape.lineTo(n, n4);
            shape.lineTo(n3, n4);
            shape.lineTo(n3, n2);
            shape.lineTo(n, n2);
        }
        catch (GeneratorApiException generatorApiException) {
            this.LogError("API Exception: " + generatorApiException);
        }
        return shape;
    }

    private void LogMessage(String string) {
        if (this.mVerbose) {
            if (this.mEnv != null) {
                this.mEnv.logMessage(string);
            } else {
                System.out.println("ActionParser Error: " + string);
            }
        }
    }

    private void LogError(String string) {
        if (this.mEnv != null) {
            this.mEnv.logMessage(string);
        } else {
            System.out.println("ActionParser Error: " + string);
        }
    }
}

