/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.Environment;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

final class HttpDownloadHelper
implements HttpDownload {
    private static final int BUF_SIZE = 32768;
    private static final int BUFFER_SIZE = 8192;
    private static final String JAR_FILE_EXT = ".jar";
    private static final String JARJAR_FILE_EXT = ".jarjar";
    private static final String META_FILE_DIR = "meta-inf/";
    private HttpRequest _httpRequest;

    public HttpDownloadHelper(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    public void download(int n, URL uRL, InputStream inputStream, String string, File file, final HttpDownloadListener httpDownloadListener, int n2) throws CanceledDownloadException, IOException {
        final int n3 = n;
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(0, n3);
        }
        Trace.println(ResourceManager.getString("httpDownloadHelper.doingDownload", uRL == null ? "" : uRL.toString(), n, string), TraceLevel.NETWORK);
        int n4 = DownloadEngine.getJarCompressionLevel();
        OutputStream outputStream = null;
        ZipOutputStream zipOutputStream = null;
        ZipInputStream zipInputStream = null;
        ZipInputStream zipInputStream2 = null;
        try {
            if (string != null && string.compareTo("pack200-gzip") == 0 && DownloadEngine.isPack200Supported()) {
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                unpacker.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (httpDownloadListener != null && propertyChangeEvent.getPropertyName().compareTo("unpack.progress") == 0) {
                            String string = (String)propertyChangeEvent.getNewValue();
                            int n = string != null ? Integer.parseInt(string) : 0;
                            httpDownloadListener.downloadProgress(n * n3 / 100, n3);
                        }
                    }
                });
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
                if (Environment.isJavaPlugin() && n4 != 0) {
                    jarOutputStream.setLevel(n4);
                }
                unpacker.unpack((InputStream)new GZIPInputStream(inputStream), jarOutputStream);
                jarOutputStream.close();
            } else if (DownloadEngine.isAlwaysCached(uRL.toString()) && !DownloadEngine.isZipFile(uRL.toString())) {
                zipOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                if (n4 != 0) {
                    zipOutputStream.setLevel(n4);
                }
                if (string != null && string.indexOf("gzip") >= 0) {
                    zipInputStream = new ZipInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(inputStream), 8192));
                    this.decompressWrite(zipInputStream, zipOutputStream, n3, httpDownloadListener);
                } else {
                    ZipEntry zipEntry;
                    zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream, 8192));
                    if (uRL.toString().toLowerCase().endsWith(JARJAR_FILE_EXT)) {
                        zipEntry = zipInputStream.getNextEntry();
                        while (zipEntry != null) {
                            if (zipEntry.toString().toLowerCase().startsWith(META_FILE_DIR)) {
                                zipEntry = zipInputStream.getNextEntry();
                                continue;
                            }
                            if (zipEntry.toString().toLowerCase().endsWith(JAR_FILE_EXT)) break;
                            throw new IOException("cache.jarjar.invalid_file");
                        }
                        zipInputStream2 = zipInputStream;
                        zipInputStream = new ZipInputStream(zipInputStream);
                    }
                    this.decompressWrite(zipInputStream, zipOutputStream, n3, httpDownloadListener);
                    if (zipInputStream2 != null && (zipEntry = zipInputStream2.getNextEntry()) != null) {
                        String string2 = null;
                        string2 = !zipEntry.toString().toLowerCase().endsWith(JAR_FILE_EXT) ? "cache.jarjar.invalid_file" : "cache.jarjar.multiple_jar";
                        throw new IOException(string2);
                    }
                }
            } else {
                FilterInputStream filterInputStream = new BufferedInputStream(inputStream);
                URL uRL2 = HttpUtils.removeQueryStringFromURL(uRL);
                if (uRL2 != null && !uRL2.toString().toLowerCase().endsWith(".gz") && string != null && string.indexOf("gzip") >= 0) {
                    filterInputStream = new GZIPInputStream((InputStream)filterInputStream, 8192);
                }
                int n5 = 0;
                int n6 = 0;
                byte[] byArray = new byte[32768];
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n7 = 0;
                while ((n5 = ((InputStream)filterInputStream).read(byArray, 0, byArray.length)) != -1) {
                    if (DownloadEngine.isJarContentType(n2) && n7 == 0 && !DownloadEngine.isJarHeaderValid(byArray)) {
                        throw new IOException("Invalid jar file");
                    }
                    outputStream.write(byArray, 0, n5);
                    if ((n6 += n5) > n3 && n3 != 0) {
                        n6 = n3;
                    }
                    if (httpDownloadListener != null) {
                        httpDownloadListener.downloadProgress(n6, n3);
                    }
                    ++n7;
                }
            }
            Trace.println(ResourceManager.getString("httpDownloadHelper.wroteUrlToFile", uRL == null ? "" : uRL.toString(), file == null ? "" : file.toString()), TraceLevel.NETWORK);
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
            if (zipInputStream != null) {
                zipInputStream.close();
                zipInputStream = null;
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
                zipOutputStream = null;
            }
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
            if (outputStream != null) {
                outputStream.close();
                outputStream = null;
            }
            if (zipInputStream != null) {
                zipInputStream.close();
                zipInputStream = null;
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
                zipOutputStream = null;
            }
            if (file != null) {
                file.delete();
            }
            throw iOException;
        }
        if (httpDownloadListener != null) {
            httpDownloadListener.downloadProgress(n3, n3);
        }
    }

    private void decompressWrite(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, int n, HttpDownloadListener httpDownloadListener) throws IOException {
        byte[] byArray = new byte[8192];
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        int n2 = 0;
        while (zipEntry != null) {
            ZipEntry zipEntry2 = (ZipEntry)zipEntry.clone();
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            int n3 = 0;
            while ((n3 = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                zipOutputStream.write(byArray, 0, n3);
                if ((n2 += n3) > n && n != 0) {
                    n2 = n;
                }
                if (httpDownloadListener == null) continue;
                httpDownloadListener.downloadProgress(n2, n);
            }
            zipOutputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipOutputStream.flush();
    }

    class PropertyChangeListenerTask
    implements PropertyChangeListener {
        HttpDownloadListener _dl = null;

        PropertyChangeListenerTask(HttpDownloadListener httpDownloadListener) {
            this._dl = httpDownloadListener;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().compareTo("unpack.progress") == 0) {
                String string = (String)propertyChangeEvent.getNewValue();
                if (this._dl != null && string != null) {
                    this._dl.downloadProgress(Integer.parseInt(string), 100);
                }
            }
        }
    }
}

