/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function RemoteWorkflowStorage(/*[String]*/ inCacheBasePath, /*[String]*/ inBaseURL)
{
 	var cache = new LocalWorkflowStorage(inCacheBasePath);
 	var baseURL = inBaseURL;
 	var downloadedWorkflowFiles = {};
 	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Return an array consisting of workflows
	//
	this.getWorkflows = function()
	{
		dbglogInfo("RemoteWorkflowStorge.getWorkflows: start");

		var ret = null;

		try
		{
			ret = cache.getWorkflows();
		}
		catch(exc)
		{
			exclog(exc);
		}

		if (!ret.isStatus(IJob.STATUS_FINISHED | IJob.STATUS_SUCCESS) || ret.getResult().length == 0)
		{
			ret = new CompoundJob();
			var workflowIDsJob = getRemoteWorkflowIDs();
			if (isValidProperty(workflowIDsJob))
			{
				workflowIDsJob.wait(function(/*[Array]*/ inFilePaths)
				{
					dbglogInfo("RemoteWorkflowStorge.getRemoteWorkflowIDs: " + inFilePaths);

					if (isValidProperty(inFilePaths.length) && inFilePaths.length > 0)
					{
						forEach(inFilePaths, function (/*[String]*/ inFilePath)
						{
							if (inFilePath.length > 0)
							{
								try
								{
									ret.addJob(getRemoteWorkflow(inFilePath));
								}
								catch (exc)
								{
									exclog(exc);
								}
							}
						});
					}
					else
					{
						ret.cancel();
					}
				},
				function ()
				{
					dbglogError("RemoteWorkflowStorge.getRemoteWorkflowIDs: null");
				});
			}
			else
			{
				ret.cancel();
			}
		}

		return ret;
	}
 
	//////////////////////////////////////////////////////////////////////////////
	//
	// Return Workflow object for the given workflow id inID
	//
	this.getWorkflow = function(/*[string]*/ inID)
	{
		dbglogInfo("RemoteWorkflowStorage.getWorkflow: " + inID);
		var job = cache.getWorkflow(inID);

		if (!job.isStatus(IJob.STATUS_SUCCESS))
		{
			job = getRemoteWorkflow(inID);
		}
		else
		{
			dbglogInfo("RemoteWorkflowStorage.getWorkflow: cached " + inID);
		}

		return job;
	}

	// private ///////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////////////////////////////////////
	//
	// Download and cache workflow
	//
	function getRemoteWorkflow(/*[string]*/ inFilePath)
	{
		var job = new Job();
		var filePath = (inFilePath.indexOf('/') == 0) ? inFilePath.substring(1) : inFilePath;
		
		if (navigator.onLine)
		{
			var url = inFilePath;
			if (url.indexOf('http') != 0)
			{
				url = baseURL + filePath;
			}

			job = new HTTPGetJob(url, function (/*[XMLHttpRequest]*/ inResult)
			{
				var wf = Workflow.create(inResult.responseText, true);

				if (isValidProperty(wf))
				{
					downloadedWorkflowFiles[filePath] = true;
					cache.addWorkflow(wf);
					dbglogInfo("RemoteWorkflowStorage.geRemotetWorkflow: " + wf.id);
				}

				return wf;
			},
			function (/*[XMLHttpRequest]*/ inError)
			{
				dbglogError("RemoteWorkflowStorage.geRemotetWorkflow: null");
			});
		}
		else
		{
			job.setError("RemoteWorkflowStorage.geRemotetWorkflow: offline " + inFilePath);
			dbglogError(job.getError());
		}

		return job;
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Get all workflows IDs from remote
	//
	function getRemoteWorkflowIDs()
	{
		var job = new Job();

		if (navigator.onLine)
		{
			job = new HTTPGetJob(baseURL + 'workflows.lst', function(/*[XMLHttpRequest]*/ inResult)
			{
				var ret = '';

				if (isValidProperty(inResult))
				{
					ret = inResult.responseText.split('\n');
				}

				return ret;
			});
		}
		else
		{
			job.setError("RemoteWorkflowStorge.getRemoteWorkflowIDs: offline")
			dbglogError(job.getError());
		}

		return job;
	}
	
	//////////////////////////////////////////////////////////////////////////////
	//
	// Initialize
	//
	(function()
	{
		var res = cep.fs.stat(inCacheBasePath);
		
		if (isValidProperty(res) && res.err != cep.fs.NO_ERROR)
		{
			cep.fs.makedir(inCacheBasePath);
		}
	})();
}