/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.bn;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.bn.BengaliNormalizationFilter;
import org.apache.lucene.analysis.bn.BengaliStemFilter;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public final class BengaliAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public BengaliAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Set)stemExclusionSet));
    }

    public BengaliAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public BengaliAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        Object result = new LowerCaseFilter((TokenStream)source);
        result = new DecimalDigitFilter((TokenStream)result);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        result = new IndicNormalizationFilter((TokenStream)result);
        result = new BengaliNormalizationFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopwords);
        result = new BengaliStemFilter((TokenStream)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        Object result = new LowerCaseFilter(in);
        result = new DecimalDigitFilter((TokenStream)result);
        result = new IndicNormalizationFilter((TokenStream)result);
        result = new BengaliNormalizationFilter((TokenStream)result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = BengaliAnalyzer.loadStopwordSet((boolean)false, (Class)BengaliAnalyzer.class, (String)BengaliAnalyzer.DEFAULT_STOPWORD_FILE, (String)BengaliAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

