/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.RandomAccessVectorValuesProducer;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.util.BytesRef;

public abstract class KnnVectorsWriter
implements Closeable {
    protected KnnVectorsWriter() {
    }

    public abstract void writeField(FieldInfo var1, VectorValues var2) throws IOException;

    public abstract void finish() throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        for (int i = 0; i < mergeState.fieldInfos.length; ++i) {
            KnnVectorsReader reader = mergeState.knnVectorsReaders[i];
            assert (reader != null || !mergeState.fieldInfos[i].hasVectorValues());
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (!fieldInfo.hasVectorValues()) continue;
            this.mergeVectors(fieldInfo, mergeState);
        }
        this.finish();
    }

    private void mergeVectors(FieldInfo mergeFieldInfo, MergeState mergeState) throws IOException {
        if (mergeState.infoStream.isEnabled("VV")) {
            mergeState.infoStream.message("VV", "merging " + mergeState.segmentInfo);
        }
        ArrayList<VectorValuesSub> subs = new ArrayList<VectorValuesSub>();
        int dimension = -1;
        VectorSimilarityFunction similarityFunction = null;
        int nonEmptySegmentIndex = 0;
        for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
            KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
            if (knnVectorsReader == null || mergeFieldInfo == null || !mergeFieldInfo.hasVectorValues()) continue;
            int segmentDimension = mergeFieldInfo.getVectorDimension();
            VectorSimilarityFunction segmentSimilarityFunction = mergeFieldInfo.getVectorSimilarityFunction();
            if (dimension == -1) {
                dimension = segmentDimension;
                similarityFunction = mergeFieldInfo.getVectorSimilarityFunction();
            } else {
                if (dimension != segmentDimension) {
                    throw new IllegalStateException("Varying dimensions for vector-valued field " + mergeFieldInfo.name + ": " + dimension + "!=" + segmentDimension);
                }
                if (similarityFunction != segmentSimilarityFunction) {
                    throw new IllegalStateException("Varying similarity functions for vector-valued field " + mergeFieldInfo.name + ": " + similarityFunction + "!=" + segmentSimilarityFunction);
                }
            }
            VectorValues values = knnVectorsReader.getVectorValues(mergeFieldInfo.name);
            if (values == null) continue;
            subs.add(new VectorValuesSub(nonEmptySegmentIndex++, mergeState.docMaps[i], values));
        }
        this.writeField(mergeFieldInfo, new VectorValuesMerger(subs, mergeState));
        if (mergeState.infoStream.isEnabled("VV")) {
            mergeState.infoStream.message("VV", "merge done " + mergeState.segmentInfo);
        }
    }

    private static class VectorValuesSub
    extends DocIDMerger.Sub {
        final VectorValues values;
        final int segmentIndex;
        int count;

        VectorValuesSub(int segmentIndex, MergeState.DocMap docMap, VectorValues values) {
            super(docMap);
            this.values = values;
            this.segmentIndex = segmentIndex;
            assert (values.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            int docId = this.values.nextDoc();
            if (docId != Integer.MAX_VALUE) {
                ++this.count;
            }
            return docId;
        }
    }

    private static class VectorValuesMerger
    extends VectorValues
    implements RandomAccessVectorValuesProducer {
        private final List<VectorValuesSub> subs;
        private final DocIDMerger<VectorValuesSub> docIdMerger;
        private final int[] ordBase;
        private final int cost;
        private int size;
        private int docId;
        private VectorValuesSub current;
        private int[] ordMap;
        private int ord;

        VectorValuesMerger(List<VectorValuesSub> subs, MergeState mergeState) throws IOException {
            this.subs = subs;
            this.docIdMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
            int totalCost = 0;
            int totalSize = 0;
            for (VectorValuesSub sub : subs) {
                totalCost = (int)((long)totalCost + sub.values.cost());
                totalSize += sub.values.size();
            }
            this.cost = totalCost;
            this.size = totalSize;
            this.ordMap = new int[this.size];
            this.ordBase = new int[subs.size()];
            int lastBase = 0;
            for (int k = 0; k < subs.size(); ++k) {
                int size = subs.get((int)k).values.size();
                this.ordBase[k] = lastBase;
                lastBase += size;
            }
            this.docId = -1;
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() throws IOException {
            this.current = this.docIdMerger.next();
            if (this.current == null) {
                this.docId = Integer.MAX_VALUE;
                this.size = this.ord;
            } else {
                this.docId = this.current.mappedDocID;
                this.ordMap[this.ord++] = this.ordBase[this.current.segmentIndex] + this.current.count - 1;
            }
            return this.docId;
        }

        @Override
        public float[] vectorValue() throws IOException {
            return this.current.values.vectorValue();
        }

        @Override
        public BytesRef binaryValue() throws IOException {
            return this.current.values.binaryValue();
        }

        @Override
        public RandomAccessVectorValues randomAccess() {
            return new MergerRandomAccess();
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public int dimension() {
            return this.subs.get((int)0).values.dimension();
        }

        class MergerRandomAccess
        implements RandomAccessVectorValues {
            private final List<RandomAccessVectorValues> raSubs;

            MergerRandomAccess() {
                this.raSubs = new ArrayList<RandomAccessVectorValues>(VectorValuesMerger.this.subs.size());
                for (VectorValuesSub sub : VectorValuesMerger.this.subs) {
                    if (sub.values instanceof RandomAccessVectorValuesProducer) {
                        this.raSubs.add(((RandomAccessVectorValuesProducer)((Object)sub.values)).randomAccess());
                        continue;
                    }
                    throw new IllegalStateException("Cannot merge VectorValues without support for random access");
                }
            }

            @Override
            public int size() {
                return VectorValuesMerger.this.size;
            }

            @Override
            public int dimension() {
                return VectorValuesMerger.this.dimension();
            }

            @Override
            public float[] vectorValue(int target) throws IOException {
                int unmappedOrd = VectorValuesMerger.this.ordMap[target];
                int segmentOrd = Arrays.binarySearch(VectorValuesMerger.this.ordBase, unmappedOrd);
                if (segmentOrd < 0) {
                    segmentOrd = -2 - segmentOrd;
                }
                while (segmentOrd < VectorValuesMerger.this.ordBase.length - 1 && VectorValuesMerger.this.ordBase[segmentOrd + 1] == VectorValuesMerger.this.ordBase[segmentOrd]) {
                    ++segmentOrd;
                }
                return this.raSubs.get(segmentOrd).vectorValue(unmappedOrd - VectorValuesMerger.this.ordBase[segmentOrd]);
            }

            @Override
            public BytesRef binaryValue(int targetOrd) throws IOException {
                throw new UnsupportedOperationException();
            }
        }
    }
}

