/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteSnapshotRequest
extends MasterNodeRequest<DeleteSnapshotRequest> {
    private String repository;
    private String[] snapshots;

    public DeleteSnapshotRequest() {
    }

    public DeleteSnapshotRequest(String repository, String ... snapshots) {
        this.repository = repository;
        this.snapshots = snapshots;
    }

    public DeleteSnapshotRequest(String repository) {
        this.repository = repository;
    }

    public DeleteSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.snapshots = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeStringArray(this.snapshots);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.snapshots == null || this.snapshots.length == 0) {
            validationException = ValidateActions.addValidationError("snapshots are missing", validationException);
        }
        return validationException;
    }

    public DeleteSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String[] snapshots() {
        return this.snapshots;
    }

    public DeleteSnapshotRequest snapshots(String ... snapshots) {
        this.snapshots = snapshots;
        return this;
    }
}

