/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetIndexTemplatesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<IndexTemplateMetadata> indexTemplates;

    public GetIndexTemplatesResponse(StreamInput in) throws IOException {
        super(in);
        this.indexTemplates = in.readList(IndexTemplateMetadata::readFrom);
    }

    public GetIndexTemplatesResponse(List<IndexTemplateMetadata> indexTemplates) {
        this.indexTemplates = indexTemplates;
    }

    public List<IndexTemplateMetadata> getIndexTemplates() {
        return this.indexTemplates;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.indexTemplates.size());
        for (IndexTemplateMetadata indexTemplate : this.indexTemplates) {
            indexTemplate.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetIndexTemplatesResponse that = (GetIndexTemplatesResponse)o;
        return Objects.equals(this.indexTemplates, that.indexTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.indexTemplates);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        params = new ToXContent.DelegatingMapParams(Collections.singletonMap("reduce_mappings", "true"), params);
        builder.startObject();
        for (IndexTemplateMetadata indexTemplateMetadata : this.getIndexTemplates()) {
            if (builder.getRestApiVersion() == RestApiVersion.V_7 && params.paramAsBoolean("include_type_name", false)) {
                IndexTemplateMetadata.Builder.toXContentWithTypes(indexTemplateMetadata, builder, params);
                continue;
            }
            IndexTemplateMetadata.Builder.toXContent(indexTemplateMetadata, builder, params);
        }
        builder.endObject();
        return builder;
    }
}

