/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.CountedCollector;
import org.elasticsearch.action.search.QueryPhaseResultConsumer;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.transport.Transport;

final class DfsQueryPhase
extends SearchPhase {
    private final QueryPhaseResultConsumer queryResult;
    private final List<DfsSearchResult> searchResults;
    private final AggregatedDfs dfs;
    private final Function<ArraySearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final SearchTransportService searchTransportService;
    private final SearchProgressListener progressListener;

    DfsQueryPhase(List<DfsSearchResult> searchResults, AggregatedDfs dfs, QueryPhaseResultConsumer queryResult, Function<ArraySearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory, SearchPhaseContext context) {
        super("dfs_query");
        this.progressListener = context.getTask().getProgressListener();
        this.queryResult = queryResult;
        this.searchResults = searchResults;
        this.dfs = dfs;
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.searchTransportService = context.getSearchTransport();
        context.addReleasable(queryResult);
    }

    @Override
    public void run() throws IOException {
        final CountedCollector<SearchPhaseResult> counter = new CountedCollector<SearchPhaseResult>(this.queryResult, this.searchResults.size(), () -> this.context.executeNextPhase(this, this.nextPhaseFactory.apply(this.queryResult)), this.context);
        for (DfsSearchResult dfsResult : this.searchResults) {
            final SearchShardTarget shardTarget = dfsResult.getSearchShardTarget();
            final Transport.Connection connection = this.context.getConnection(shardTarget.getClusterAlias(), shardTarget.getNodeId());
            final QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.context.getOriginalIndices(dfsResult.getShardIndex()), dfsResult.getContextId(), dfsResult.getShardSearchRequest(), this.dfs);
            final int shardIndex = dfsResult.getShardIndex();
            this.searchTransportService.sendExecuteQuery(connection, querySearchRequest, this.context.getTask(), new SearchActionListener<QuerySearchResult>(shardTarget, shardIndex){

                @Override
                protected void innerOnResponse(QuerySearchResult response) {
                    try {
                        counter.onResult(response);
                    }
                    catch (Exception e) {
                        DfsQueryPhase.this.context.onPhaseFailure(DfsQueryPhase.this, "", e);
                    }
                }

                @Override
                public void onFailure(Exception exception) {
                    try {
                        DfsQueryPhase.this.context.getLogger().debug(() -> new ParameterizedMessage("[{}] Failed to execute query phase", (Object)querySearchRequest.contextId()), (Throwable)exception);
                        DfsQueryPhase.this.progressListener.notifyQueryFailure(shardIndex, shardTarget, exception);
                        counter.onFailure(shardIndex, shardTarget, exception);
                    }
                    finally {
                        if (!DfsQueryPhase.this.context.isPartOfPointInTime(querySearchRequest.contextId())) {
                            DfsQueryPhase.this.context.sendReleaseSearchContext(querySearchRequest.contextId(), connection, DfsQueryPhase.this.context.getOriginalIndices(shardIndex));
                        }
                    }
                }
            });
        }
    }
}

