/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SnapshotDeletionsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final SnapshotDeletionsInProgress EMPTY = new SnapshotDeletionsInProgress(List.of());
    public static final String TYPE = "snapshot_deletions";
    private final List<Entry> entries;

    private SnapshotDeletionsInProgress(List<Entry> entries) {
        this.entries = entries;
        assert ((long)entries.size() == entries.stream().map(Entry::uuid).distinct().count()) : "Found duplicate UUIDs in entries " + entries;
        assert (SnapshotDeletionsInProgress.assertNoConcurrentDeletionsForSameRepository(entries));
    }

    public static SnapshotDeletionsInProgress of(List<Entry> entries) {
        if (entries.isEmpty()) {
            return EMPTY;
        }
        return new SnapshotDeletionsInProgress(Collections.unmodifiableList(entries));
    }

    public SnapshotDeletionsInProgress(StreamInput in) throws IOException {
        this(in.readList(Entry::new));
    }

    private static boolean assertNoConcurrentDeletionsForSameRepository(List<Entry> entries) {
        HashSet<String> activeRepositories = new HashSet<String>();
        for (Entry entry : entries) {
            if (entry.state() != State.STARTED) continue;
            boolean added = activeRepositories.add(entry.repository());
            assert (added) : "Found multiple running deletes for a single repository in " + entries;
        }
        return true;
    }

    public SnapshotDeletionsInProgress withAddedEntry(Entry entry) {
        return SnapshotDeletionsInProgress.of(CollectionUtils.appendToCopy(this.getEntries(), entry));
    }

    public SnapshotDeletionsInProgress withRemovedEntry(String deleteUUID) {
        ArrayList<Entry> updatedEntries = new ArrayList<Entry>(this.entries.size() - 1);
        boolean removed = false;
        for (Entry entry : this.entries) {
            if (entry.uuid().equals(deleteUUID)) {
                removed = true;
                continue;
            }
            updatedEntries.add(entry);
        }
        return removed ? SnapshotDeletionsInProgress.of(updatedEntries) : this;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean hasExecutingDeletion(String repository) {
        for (Entry entry : this.entries) {
            if (entry.state() != State.STARTED || !entry.repository().equals(repository)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeletionsInProgress() {
        return !this.entries.isEmpty();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotDeletionsInProgress that = (SnapshotDeletionsInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return 31 + this.entries.hashCode();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.entries);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotDeletionsInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TYPE);
        for (Entry entry : this.entries) {
            builder.startObject();
            builder.field("repository", entry.repository());
            builder.startArray("snapshots");
            for (SnapshotId snapshot : entry.snapshots) {
                builder.value(snapshot.getName());
            }
            builder.endArray();
            builder.timeField("start_time_millis", "start_time", entry.startTime);
            builder.field("repository_state_id", entry.repositoryStateId);
            builder.field("state", entry.state);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotDeletionsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).getSnapshots());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public static final class Entry
    implements Writeable,
    RepositoryOperation {
        private final List<SnapshotId> snapshots;
        private final String repoName;
        private final State state;
        private final long startTime;
        private final long repositoryStateId;
        private final String uuid;

        public Entry(List<SnapshotId> snapshots, String repoName, long startTime, long repositoryStateId, State state) {
            this(snapshots, repoName, startTime, repositoryStateId, state, UUIDs.randomBase64UUID());
        }

        private Entry(List<SnapshotId> snapshots, String repoName, long startTime, long repositoryStateId, State state, String uuid) {
            this.snapshots = snapshots;
            assert (snapshots.size() == new HashSet<SnapshotId>(snapshots).size()) : "Duplicate snapshot ids in " + snapshots;
            this.repoName = repoName;
            this.startTime = startTime;
            this.repositoryStateId = repositoryStateId;
            this.state = state;
            this.uuid = uuid;
        }

        public Entry(StreamInput in) throws IOException {
            this.repoName = in.readString();
            this.snapshots = in.readList(SnapshotId::new);
            this.startTime = in.readVLong();
            this.repositoryStateId = in.readLong();
            this.state = State.readFrom(in);
            this.uuid = in.readString();
        }

        public Entry started() {
            assert (this.state == State.WAITING);
            return new Entry(this.snapshots, this.repository(), this.startTime, this.repositoryStateId, State.STARTED, this.uuid);
        }

        public Entry withAddedSnapshots(Collection<SnapshotId> newSnapshots) {
            assert (this.state == State.WAITING);
            HashSet<SnapshotId> updatedSnapshots = new HashSet<SnapshotId>(this.snapshots);
            if (!updatedSnapshots.addAll(newSnapshots)) {
                return this;
            }
            return new Entry(List.copyOf(updatedSnapshots), this.repository(), this.startTime, this.repositoryStateId, State.WAITING, this.uuid);
        }

        public Entry withSnapshots(Collection<SnapshotId> snapshots) {
            return new Entry(List.copyOf(snapshots), this.repository(), this.startTime, this.repositoryStateId, this.state, this.uuid);
        }

        public Entry withRepoGen(long repoGen) {
            return new Entry(this.snapshots, this.repository(), this.startTime, repoGen, this.state, this.uuid);
        }

        public State state() {
            return this.state;
        }

        public String uuid() {
            return this.uuid;
        }

        public List<SnapshotId> getSnapshots() {
            return this.snapshots;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry that = (Entry)o;
            return this.repoName.equals(that.repoName) && this.snapshots.equals(that.snapshots) && this.startTime == that.startTime && this.repositoryStateId == that.repositoryStateId && this.state == that.state && this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.snapshots, this.repoName, this.startTime, this.repositoryStateId, this.state, this.uuid);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.repoName);
            out.writeCollection(this.snapshots);
            out.writeVLong(this.startTime);
            out.writeLong(this.repositoryStateId);
            this.state.writeTo(out);
            out.writeString(this.uuid);
        }

        @Override
        public String repository() {
            return this.repoName;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        public String toString() {
            return "SnapshotDeletionsInProgress.Entry[[" + this.uuid + "][" + this.state + "]" + this.snapshots + "]";
        }
    }

    public static enum State implements Writeable
    {
        WAITING(0),
        STARTED(1);

        private final byte value;

        private State(byte value) {
            this.value = value;
        }

        public static State readFrom(StreamInput in) throws IOException {
            byte value = in.readByte();
            switch (value) {
                case 0: {
                    return WAITING;
                }
                case 1: {
                    return STARTED;
                }
            }
            throw new IllegalArgumentException("No snapshot delete state for value [" + value + "]");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.value);
        }
    }
}

