/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SnapshotsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final SnapshotsInProgress EMPTY = new SnapshotsInProgress(Map.of());
    public static final String TYPE = "snapshots";
    public static final String ABORTED_FAILURE_TEXT = "Snapshot was aborted by deletion";
    private final Map<String, List<Entry>> entries;

    public SnapshotsInProgress(StreamInput in) throws IOException {
        this(SnapshotsInProgress.collectByRepo(in));
    }

    private static Map<String, List<Entry>> collectByRepo(StreamInput in) throws IOException {
        int count = in.readVInt();
        if (count == 0) {
            return Map.of();
        }
        HashMap<String, List<Entry>> entriesByRepo = new HashMap<String, List<Entry>>();
        for (int i = 0; i < count; ++i) {
            Entry entry = Entry.readFrom(in);
            entriesByRepo.computeIfAbsent(entry.repository(), repo -> new ArrayList()).add(entry);
        }
        for (Map.Entry entry : entriesByRepo.entrySet()) {
            entry.setValue(List.copyOf((Collection)entry.getValue()));
        }
        return entriesByRepo;
    }

    private SnapshotsInProgress(Map<String, List<Entry>> entries) {
        this.entries = Map.copyOf(entries);
        assert (SnapshotsInProgress.assertConsistentEntries(this.entries));
    }

    public SnapshotsInProgress withUpdatedEntriesForRepo(String repository, List<Entry> updatedEntries) {
        if (updatedEntries.equals(this.forRepo(repository))) {
            return this;
        }
        HashMap<String, List<Entry>> copy = new HashMap<String, List<Entry>>(this.entries);
        if (updatedEntries.isEmpty()) {
            copy.remove(repository);
            if (copy.isEmpty()) {
                return EMPTY;
            }
        } else {
            copy.put(repository, List.copyOf(updatedEntries));
        }
        return new SnapshotsInProgress(copy);
    }

    public SnapshotsInProgress withAddedEntry(Entry entry) {
        ArrayList<Entry> forRepo = new ArrayList<Entry>(this.entries.getOrDefault(entry.repository(), List.of()));
        forRepo.add(entry);
        return this.withUpdatedEntriesForRepo(entry.repository(), forRepo);
    }

    public List<Entry> forRepo(String repository) {
        return this.entries.getOrDefault(repository, List.of());
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int count() {
        int count = 0;
        for (List<Entry> list : this.entries.values()) {
            count += list.size();
        }
        return count;
    }

    public Collection<List<Entry>> entriesByRepo() {
        return this.entries.values();
    }

    public Stream<Entry> asStream() {
        return this.entries.values().stream().flatMap(Collection::stream);
    }

    public Entry snapshot(Snapshot snapshot) {
        for (Entry entry : this.forRepo(snapshot.getRepository())) {
            Snapshot curr = entry.snapshot();
            if (!curr.equals(snapshot)) continue;
            return entry;
        }
        return null;
    }

    public Map<RepositoryShardId, Set<ShardGeneration>> obsoleteGenerations(String repository, SnapshotsInProgress old) {
        HashMap<RepositoryShardId, Set> obsoleteGenerations = new HashMap<RepositoryShardId, Set>();
        for (Entry entry : old.forRepo(repository)) {
            Entry updatedEntry = this.snapshot(entry.snapshot());
            if (updatedEntry == null) continue;
            for (ObjectObjectCursor<RepositoryShardId, ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                RepositoryShardId repositoryShardId = (RepositoryShardId)objectObjectCursor.key;
                ShardSnapshotStatus oldStatus = (ShardSnapshotStatus)objectObjectCursor.value;
                ShardSnapshotStatus newStatus = updatedEntry.shardsByRepoShardId().get(repositoryShardId);
                if (oldStatus.state != ShardState.SUCCESS || oldStatus.generation() == null || newStatus == null || newStatus.state() != ShardState.SUCCESS || newStatus.generation() == null || oldStatus.generation().equals(newStatus.generation())) continue;
                obsoleteGenerations.computeIfAbsent(repositoryShardId, ignored -> new HashSet()).add(oldStatus.generation());
            }
        }
        return Map.copyOf(obsoleteGenerations);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotsInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.count());
        Iterator iterator = this.asStream().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TYPE);
        Iterator iterator = this.asStream().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.entries.equals(((SnapshotsInProgress)o).entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotsInProgress[");
        Iterator entryList = this.asStream().iterator();
        boolean firstEntry = true;
        while (entryList.hasNext()) {
            if (!firstEntry) {
                builder.append(",");
            }
            builder.append(((Entry)entryList.next()).snapshot().getSnapshotId().getName());
            firstEntry = false;
        }
        return builder.append("]").toString();
    }

    public static Entry startedEntry(Snapshot snapshot, boolean includeGlobalState, boolean partial, Map<String, IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, Version version, List<SnapshotFeatureInfo> featureStates) {
        return new Entry(snapshot, includeGlobalState, partial, SnapshotsInProgress.completed(shards.values()) ? State.SUCCESS : State.STARTED, indices, dataStreams, featureStates, startTime, repositoryStateId, shards, null, userMetadata, version);
    }

    public static Entry startClone(Snapshot snapshot, SnapshotId source, Map<String, IndexId> indices, long startTime, long repositoryStateId, Version version) {
        return new Entry(snapshot, true, false, State.STARTED, indices, Collections.emptyList(), Collections.emptyList(), startTime, repositoryStateId, ImmutableOpenMap.of(), null, Collections.emptyMap(), version, source, ImmutableOpenMap.of());
    }

    public static boolean completed(Collection<ShardSnapshotStatus> shards) {
        for (ShardSnapshotStatus status : shards) {
            if (status.state().completed) continue;
            return false;
        }
        return true;
    }

    private static boolean hasFailures(ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> clones) {
        for (ShardSnapshotStatus value : clones.values()) {
            if (!value.state().failed()) continue;
            return true;
        }
        return false;
    }

    private static boolean assertConsistentEntries(Map<String, List<Entry>> entries) {
        for (Map.Entry<String, List<Entry>> repoEntries : entries.entrySet()) {
            HashSet<Tuple<String, Integer>> assignedShards = new HashSet<Tuple<String, Integer>>();
            HashSet<Tuple<String, Integer>> queuedShards = new HashSet<Tuple<String, Integer>>();
            List<Entry> entriesForRepository = repoEntries.getValue();
            String repository = repoEntries.getKey();
            assert (!entriesForRepository.isEmpty()) : "found empty list of snapshots for " + repository + " in " + entries;
            for (Entry entry : entriesForRepository) {
                assert (entry.repository().equals(repository)) : "mismatched repository " + entry + " tracked under " + repository;
                for (ObjectObjectCursor<RepositoryShardId, ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                    RepositoryShardId sid = (RepositoryShardId)objectObjectCursor.key;
                    assert (SnapshotsInProgress.assertShardStateConsistent(entriesForRepository, assignedShards, queuedShards, sid.indexName(), sid.shardId(), (ShardSnapshotStatus)objectObjectCursor.value));
                }
            }
            InFlightShardSnapshotStates.forEntries(entriesForRepository);
        }
        return true;
    }

    private static boolean assertShardStateConsistent(List<Entry> entries, Set<Tuple<String, Integer>> assignedShards, Set<Tuple<String, Integer>> queuedShards, String indexName, int shardId, ShardSnapshotStatus shardSnapshotStatus) {
        if (shardSnapshotStatus.isActive()) {
            Tuple<String, Integer> plainShardId = Tuple.tuple(indexName, shardId);
            assert (assignedShards.add(plainShardId)) : plainShardId + " is assigned twice in " + entries;
            assert (!queuedShards.contains(plainShardId)) : plainShardId + " is queued then assigned in " + entries;
        } else if (shardSnapshotStatus.state() == ShardState.QUEUED) {
            queuedShards.add(Tuple.tuple(indexName, shardId));
        }
        return true;
    }

    public static class Entry
    implements Writeable,
    ToXContent,
    RepositoryOperation {
        private final State state;
        private final Snapshot snapshot;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards;
        private final Map<String, IndexId> indices;
        private final Map<String, Index> snapshotIndices;
        private final List<String> dataStreams;
        private final List<SnapshotFeatureInfo> featureStates;
        private final long startTime;
        private final long repositoryStateId;
        private final Version version;
        @Nullable
        private final SnapshotId source;
        private final ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> shardStatusByRepoShardId;
        @Nullable
        private final Map<String, Object> userMetadata;
        @Nullable
        private final String failure;

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, Map<String, IndexId> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, Version version) {
            this(snapshot, includeGlobalState, partial, state, indices, dataStreams, featureStates, startTime, repositoryStateId, shards, failure, userMetadata, version, null, ImmutableOpenMap.of());
        }

        private Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, Map<String, IndexId> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, Version version, @Nullable SnapshotId source, ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> shardStatusByRepoShardId) {
            this.state = state;
            this.snapshot = snapshot;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.indices = Map.copyOf(indices);
            this.dataStreams = List.copyOf(dataStreams);
            this.featureStates = List.copyOf(featureStates);
            this.startTime = startTime;
            this.shards = shards;
            this.repositoryStateId = repositoryStateId;
            this.failure = failure;
            this.userMetadata = userMetadata == null ? null : Map.copyOf(userMetadata);
            this.version = version;
            this.source = source;
            if (source == null) {
                assert (shardStatusByRepoShardId == null || shardStatusByRepoShardId.isEmpty()) : "Provided explict repo shard id statuses [" + shardStatusByRepoShardId + "] but no source";
                HashMap<String, Index> res = new HashMap<String, Index>(indices.size());
                ImmutableOpenMap.Builder<RepositoryShardId, ShardSnapshotStatus> byRepoShardIdBuilder = ImmutableOpenMap.builder(shards.size());
                for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : shards) {
                    ShardId shardId = (ShardId)objectObjectCursor.key;
                    IndexId indexId = indices.get(shardId.getIndexName());
                    Index index = shardId.getIndex();
                    Index existing = res.put(indexId.getName(), index);
                    assert (existing == null || existing.equals(index)) : "Conflicting indices [" + existing + "] and [" + index + "]";
                    byRepoShardIdBuilder.put(new RepositoryShardId(indexId, shardId.id()), (ShardSnapshotStatus)objectObjectCursor.value);
                }
                this.shardStatusByRepoShardId = byRepoShardIdBuilder.build();
                this.snapshotIndices = Map.copyOf(res);
            } else {
                assert (shards.isEmpty());
                this.shardStatusByRepoShardId = shardStatusByRepoShardId;
                this.snapshotIndices = Map.of();
            }
            assert (Entry.assertShardsConsistent(this.source, this.state, this.indices, this.shards, this.shardStatusByRepoShardId));
        }

        private static Entry readFrom(StreamInput in) throws IOException {
            Map<String, IndexId> indices;
            Snapshot snapshot = new Snapshot(in);
            boolean includeGlobalState = in.readBoolean();
            boolean partial = in.readBoolean();
            State state = State.fromValue(in.readByte());
            int indexCount = in.readVInt();
            if (indexCount == 0) {
                indices = Collections.emptyMap();
            } else {
                HashMap<String, IndexId> idx = new HashMap<String, IndexId>(indexCount);
                for (int i = 0; i < indexCount; ++i) {
                    IndexId indexId = new IndexId(in);
                    idx.put(indexId.getName(), indexId);
                }
                indices = Collections.unmodifiableMap(idx);
            }
            long startTime = in.readLong();
            ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards = in.readImmutableMap(ShardId::new, ShardSnapshotStatus::readFrom);
            long repositoryStateId = in.readLong();
            String failure = in.readOptionalString();
            Map<String, Object> userMetadata = in.readMap();
            Version version = Version.readVersion(in);
            List<String> dataStreams = in.readStringList();
            SnapshotId source = in.readOptionalWriteable(SnapshotId::new);
            ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> clones = in.readImmutableMap(RepositoryShardId::new, ShardSnapshotStatus::readFrom);
            List<SnapshotFeatureInfo> featureStates = Collections.unmodifiableList(in.readList(SnapshotFeatureInfo::new));
            return new Entry(snapshot, includeGlobalState, partial, state, indices, dataStreams, featureStates, startTime, repositoryStateId, shards, failure, userMetadata, version, source, clones);
        }

        private static boolean assertShardsConsistent(SnapshotId source, State state, Map<String, IndexId> indices, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> statusByRepoShardId) {
            boolean shardsCompleted;
            if ((state == State.INIT || state == State.ABORTED) && shards.isEmpty()) {
                return true;
            }
            Set<String> indexNames = indices.keySet();
            HashSet indexNamesInShards = new HashSet();
            shards.iterator().forEachRemaining(s -> {
                indexNamesInShards.add(((ShardId)s.key).getIndexName());
                assert (source == null || ((ShardSnapshotStatus)s.value).nodeId == null) : "Shard snapshot must not be assigned to data node when copying from snapshot [" + source + "]";
            });
            assert (source == null || !indexNames.isEmpty()) : "No empty snapshot clones allowed";
            assert (source != null || indexNames.equals(indexNamesInShards)) : "Indices in shards " + indexNamesInShards + " differ from expected indices " + indexNames + " for state [" + state + "]";
            boolean bl = shardsCompleted = SnapshotsInProgress.completed(shards.values()) && SnapshotsInProgress.completed(statusByRepoShardId.values());
            if (source == null || !statusByRepoShardId.isEmpty()) assert (state.completed() && shardsCompleted || !state.completed() && !shardsCompleted) : "Completed state must imply all shards completed but saw state [" + state + "] and shards " + shards;
            if (source != null && state.completed()) assert (!SnapshotsInProgress.hasFailures(statusByRepoShardId) || state == State.FAILED) : "Failed shard clones in [" + statusByRepoShardId + "] but state was [" + state + "]";
            if (source == null) {
                assert (shards.size() == statusByRepoShardId.size());
                for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : shards) {
                    ShardId routingShardId = (ShardId)objectObjectCursor.key;
                    assert (statusByRepoShardId.get(new RepositoryShardId(indices.get(routingShardId.getIndexName()), routingShardId.id())) == objectObjectCursor.value) : "found inconsistent values tracked by routing- and repository shard id";
                }
            }
            return true;
        }

        public Entry withRepoGen(long newRepoGen) {
            assert (newRepoGen > this.repositoryStateId) : "Updated repository generation [" + newRepoGen + "] must be higher than current generation [" + this.repositoryStateId + "]";
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.featureStates, this.startTime, newRepoGen, this.shards, this.failure, this.userMetadata, this.version, this.source, this.source == null ? ImmutableOpenMap.of() : this.shardStatusByRepoShardId);
        }

        public Entry withClones(ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> updatedClones) {
            if (updatedClones.equals(this.shardStatusByRepoShardId)) {
                return this;
            }
            assert (this.shards.isEmpty());
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, SnapshotsInProgress.completed(updatedClones.values()) ? (SnapshotsInProgress.hasFailures(updatedClones) ? State.FAILED : State.SUCCESS) : this.state, this.indices, this.dataStreams, this.featureStates, this.startTime, this.repositoryStateId, ImmutableOpenMap.of(), this.failure, this.userMetadata, this.version, this.source, updatedClones);
        }

        @Nullable
        public Entry abort() {
            ImmutableOpenMap.Builder<ShardId, ShardSnapshotStatus> shardsBuilder = ImmutableOpenMap.builder();
            boolean completed = true;
            boolean allQueued = true;
            for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : this.shards) {
                ShardSnapshotStatus status = (ShardSnapshotStatus)objectObjectCursor.value;
                allQueued &= status.state() == ShardState.QUEUED;
                if (!status.state().completed()) {
                    String nodeId;
                    status = new ShardSnapshotStatus(nodeId, (nodeId = status.nodeId()) == null ? ShardState.FAILED : ShardState.ABORTED, "aborted by snapshot deletion", status.generation());
                }
                completed &= status.state().completed();
                shardsBuilder.put((ShardId)objectObjectCursor.key, status);
            }
            if (allQueued) {
                return null;
            }
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, completed ? State.SUCCESS : State.ABORTED, this.indices, this.dataStreams, this.featureStates, this.startTime, this.repositoryStateId, shardsBuilder.build(), SnapshotsInProgress.ABORTED_FAILURE_TEXT, this.userMetadata, this.version, this.source, ImmutableOpenMap.of());
        }

        public Entry withShardStates(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            if (SnapshotsInProgress.completed(shards.values())) {
                return new Entry(this.snapshot, this.includeGlobalState, this.partial, State.SUCCESS, this.indices, this.dataStreams, this.featureStates, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version);
            }
            return this.withStartedShards(shards);
        }

        public Entry withStartedShards(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            Entry updated = new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.featureStates, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version);
            assert (!updated.state().completed() && !SnapshotsInProgress.completed(updated.shardsByRepoShardId().values())) : "Only running snapshots allowed but saw [" + updated + "]";
            return updated;
        }

        @Override
        public String repository() {
            return this.snapshot.getRepository();
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ImmutableOpenMap<RepositoryShardId, ShardSnapshotStatus> shardsByRepoShardId() {
            return this.shardStatusByRepoShardId;
        }

        public Index indexByName(String name) {
            assert (!this.isClone()) : "tried to get routing index for clone entry [" + this + "]";
            return this.snapshotIndices.get(name);
        }

        public ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards() {
            assert (!this.isClone()) : "tried to get routing shards for clone entry [" + this + "]";
            return this.shards;
        }

        public ShardId shardId(RepositoryShardId repositoryShardId) {
            assert (!this.isClone()) : "must not be called for clone [" + this + "]";
            return new ShardId(this.indexByName(repositoryShardId.indexName()), repositoryShardId.shardId());
        }

        public State state() {
            return this.state;
        }

        public Map<String, IndexId> indices() {
            return this.indices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public Map<String, Object> userMetadata() {
            return this.userMetadata;
        }

        public boolean partial() {
            return this.partial;
        }

        public long startTime() {
            return this.startTime;
        }

        public List<String> dataStreams() {
            return this.dataStreams;
        }

        public List<SnapshotFeatureInfo> featureStates() {
            return this.featureStates;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        public String failure() {
            return this.failure;
        }

        public Version version() {
            return this.version;
        }

        @Nullable
        public SnapshotId source() {
            return this.source;
        }

        public boolean isClone() {
            return this.source != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.partial != entry.partial) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.dataStreams.equals(entry.dataStreams)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshot.equals(entry.snapshot)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            if (this.repositoryStateId != entry.repositoryStateId) {
                return false;
            }
            if (!Objects.equals(this.failure, ((Entry)o).failure)) {
                return false;
            }
            if (!Objects.equals(this.userMetadata, ((Entry)o).userMetadata)) {
                return false;
            }
            if (!this.version.equals(entry.version)) {
                return false;
            }
            if (!Objects.equals(this.source, ((Entry)o).source)) {
                return false;
            }
            if (!this.shardStatusByRepoShardId.equals(((Entry)o).shardStatusByRepoShardId)) {
                return false;
            }
            return this.featureStates.equals(entry.featureStates);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshot.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + (this.partial ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + this.dataStreams.hashCode();
            result = 31 * result + Long.hashCode(this.startTime);
            result = 31 * result + Long.hashCode(this.repositoryStateId);
            result = 31 * result + (this.failure == null ? 0 : this.failure.hashCode());
            result = 31 * result + (this.userMetadata == null ? 0 : this.userMetadata.hashCode());
            result = 31 * result + this.version.hashCode();
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + this.shardStatusByRepoShardId.hashCode();
            result = 31 * result + this.featureStates.hashCode();
            return result;
        }

        public String toString() {
            return Strings.toString(this);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            Writeable shardId;
            builder.startObject();
            builder.field("repository", this.snapshot.getRepository());
            builder.field("snapshot", this.snapshot.getSnapshotId().getName());
            builder.field("uuid", this.snapshot.getSnapshotId().getUUID());
            builder.field("include_global_state", this.includeGlobalState());
            builder.field("partial", this.partial);
            builder.field("state", this.state);
            builder.startArray("indices");
            for (IndexId indexId : this.indices.values()) {
                indexId.toXContent(builder, params);
            }
            builder.endArray();
            builder.timeField("start_time_millis", "start_time", this.startTime);
            builder.field("repository_state_id", this.repositoryStateId);
            builder.startArray("shards");
            for (ObjectObjectCursor objectObjectCursor : this.shards) {
                shardId = (ShardId)objectObjectCursor.key;
                this.writeShardSnapshotStatus(builder, ((ShardId)shardId).getIndex(), ((ShardId)shardId).getId(), (ShardSnapshotStatus)objectObjectCursor.value);
            }
            builder.endArray();
            builder.startArray("feature_states");
            for (SnapshotFeatureInfo snapshotFeatureInfo : this.featureStates) {
                snapshotFeatureInfo.toXContent(builder, params);
            }
            builder.endArray();
            if (this.isClone()) {
                builder.field("source", this.source);
                builder.startArray("clones");
                for (ObjectObjectCursor objectObjectCursor : this.shardStatusByRepoShardId) {
                    shardId = (RepositoryShardId)objectObjectCursor.key;
                    this.writeShardSnapshotStatus(builder, ((RepositoryShardId)shardId).index(), ((RepositoryShardId)shardId).shardId(), (ShardSnapshotStatus)objectObjectCursor.value);
                }
                builder.endArray();
            }
            builder.array("data_streams", this.dataStreams.toArray(new String[0]));
            builder.endObject();
            return builder;
        }

        private void writeShardSnapshotStatus(XContentBuilder builder, ToXContent indexId, int shardId, ShardSnapshotStatus status) throws IOException {
            builder.startObject();
            builder.field("index", indexId);
            builder.field("shard", shardId);
            builder.field("state", status.state());
            builder.field("generation", status.generation());
            builder.field("node", status.nodeId());
            if (status.state() == ShardState.SUCCESS) {
                ShardSnapshotResult result = status.shardSnapshotResult();
                builder.startObject("result");
                builder.field("generation", result.getGeneration());
                builder.humanReadableField("size_in_bytes", "size", result.getSize());
                builder.field("segments", result.getSegmentCount());
                builder.endObject();
            }
            if (status.reason() != null) {
                builder.field("reason", status.reason());
            }
            builder.endObject();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.snapshot.writeTo(out);
            out.writeBoolean(this.includeGlobalState);
            out.writeBoolean(this.partial);
            out.writeByte(this.state.value());
            out.writeCollection(this.indices.values());
            out.writeLong(this.startTime);
            out.writeMap(this.shards);
            out.writeLong(this.repositoryStateId);
            out.writeOptionalString(this.failure);
            out.writeMap(this.userMetadata);
            Version.writeVersion(this.version, out);
            out.writeStringCollection(this.dataStreams);
            out.writeOptionalWriteable(this.source);
            if (this.source == null) {
                out.writeMap(ImmutableOpenMap.of());
            } else {
                out.writeMap(this.shardStatusByRepoShardId);
            }
            out.writeList(this.featureStates);
        }

        @Override
        public boolean isFragment() {
            return false;
        }
    }

    public static class ShardSnapshotStatus
    implements Writeable {
        public static final ShardSnapshotStatus UNASSIGNED_QUEUED = new ShardSnapshotStatus(null, ShardState.QUEUED, null);
        public static final ShardSnapshotStatus MISSING = new ShardSnapshotStatus(null, ShardState.MISSING, "missing index", null);
        private final ShardState state;
        @Nullable
        private final String nodeId;
        @Nullable
        private final ShardGeneration generation;
        @Nullable
        private final String reason;
        @Nullable
        private final ShardSnapshotResult shardSnapshotResult;

        public ShardSnapshotStatus(String nodeId, ShardGeneration generation) {
            this(nodeId, ShardState.INIT, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable ShardGeneration generation) {
            this(nodeId, ShardSnapshotStatus.assertNotSuccess(state), null, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, String reason, @Nullable ShardGeneration generation) {
            this(nodeId, ShardSnapshotStatus.assertNotSuccess(state), reason, generation, null);
        }

        private ShardSnapshotStatus(@Nullable String nodeId, ShardState state, String reason, @Nullable ShardGeneration generation, @Nullable ShardSnapshotResult shardSnapshotResult) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
            this.generation = generation;
            this.shardSnapshotResult = shardSnapshotResult;
            assert (this.assertConsistent());
        }

        private static ShardState assertNotSuccess(ShardState shardState) {
            assert (shardState != ShardState.SUCCESS) : "use ShardSnapshotStatus#success";
            return shardState;
        }

        public static ShardSnapshotStatus success(String nodeId, ShardSnapshotResult shardSnapshotResult) {
            return new ShardSnapshotStatus(nodeId, ShardState.SUCCESS, null, shardSnapshotResult.getGeneration(), shardSnapshotResult);
        }

        private boolean assertConsistent() {
            assert (!this.state.failed() || this.reason != null);
            assert (this.state != ShardState.INIT && this.state != ShardState.WAITING || this.nodeId != null) : "Null node id for state [" + this.state + "]";
            assert (this.state != ShardState.QUEUED || this.nodeId == null && this.generation == null && this.reason == null) : "Found unexpected non-null values for queued state shard nodeId[" + this.nodeId + "][" + this.generation + "][" + this.reason + "]";
            assert (this.state == ShardState.SUCCESS || this.shardSnapshotResult == null);
            assert (this.shardSnapshotResult == null || this.shardSnapshotResult.getGeneration().equals(this.generation)) : "generation [" + this.generation + "] does not match result generation [" + this.shardSnapshotResult.getGeneration() + "]";
            return true;
        }

        public static ShardSnapshotStatus readFrom(StreamInput in) throws IOException {
            String nodeId = in.readOptionalString();
            ShardState state = ShardState.fromValue(in.readByte());
            ShardGeneration generation = in.readOptionalWriteable(ShardGeneration::new);
            String reason = in.readOptionalString();
            ShardSnapshotResult shardSnapshotResult = in.readOptionalWriteable(ShardSnapshotResult::new);
            if (state == ShardState.QUEUED) {
                return UNASSIGNED_QUEUED;
            }
            return new ShardSnapshotStatus(nodeId, state, reason, generation, shardSnapshotResult);
        }

        public ShardState state() {
            return this.state;
        }

        @Nullable
        public String nodeId() {
            return this.nodeId;
        }

        @Nullable
        public ShardGeneration generation() {
            return this.generation;
        }

        public String reason() {
            return this.reason;
        }

        public ShardSnapshotStatus withUpdatedGeneration(ShardGeneration newGeneration) {
            assert (this.state == ShardState.SUCCESS) : "can't move generation in state " + this.state;
            return new ShardSnapshotStatus(this.nodeId, this.state, this.reason, newGeneration, this.shardSnapshotResult == null ? null : new ShardSnapshotResult(newGeneration, this.shardSnapshotResult.getSize(), this.shardSnapshotResult.getSegmentCount()));
        }

        @Nullable
        public ShardSnapshotResult shardSnapshotResult() {
            assert (this.state == ShardState.SUCCESS) : "result is unavailable in state " + this.state;
            return this.shardSnapshotResult;
        }

        public boolean isActive() {
            return this.state == ShardState.INIT || this.state == ShardState.ABORTED || this.state == ShardState.WAITING;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalWriteable(this.generation);
            out.writeOptionalString(this.reason);
            out.writeOptionalWriteable(this.shardSnapshotResult);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            return Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason) && Objects.equals(this.generation, status.generation) && this.state == status.state && Objects.equals(this.shardSnapshotResult, status.shardSnapshotResult);
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            result = 31 * result + (this.generation != null ? this.generation.hashCode() : 0);
            result = 31 * result + (this.shardSnapshotResult != null ? this.shardSnapshotResult.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ShardSnapshotStatus[state=" + this.state + ", nodeId=" + this.nodeId + ", reason=" + this.reason + ", generation=" + this.generation + ", shardSnapshotResult=" + this.shardSnapshotResult + "]";
        }
    }

    public static enum ShardState {
        INIT(0, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false),
        QUEUED(7, false, false);

        private final byte value;
        private final boolean completed;
        private final boolean failed;

        private ShardState(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static ShardState fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
                case 7: {
                    return QUEUED;
                }
            }
            throw new IllegalArgumentException("No shard snapshot state for value [" + value + "]");
        }
    }

    public static enum State {
        INIT(0, false),
        STARTED(1, false),
        SUCCESS(2, true),
        FAILED(3, true),
        ABORTED(4, false);

        private final byte value;
        private final boolean completed;

        private State(byte value, boolean completed) {
            this.value = value;
            this.completed = completed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }
}

