/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;

public class DiscoveryNodeRole
implements Comparable<DiscoveryNodeRole> {
    private final String roleName;
    private final String roleNameAbbreviation;
    private final boolean canContainData;
    private final boolean isKnownRole;
    public static final DiscoveryNodeRole DATA_ROLE = new DiscoveryNodeRole("data", "d", true);
    public static DiscoveryNodeRole DATA_CONTENT_NODE_ROLE = new DiscoveryNodeRole("data_content", "s", true){

        @Override
        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole(settings, DATA_ROLE);
        }
    };
    public static DiscoveryNodeRole DATA_HOT_NODE_ROLE = new DiscoveryNodeRole("data_hot", "h", true){

        @Override
        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole(settings, DATA_ROLE);
        }
    };
    public static DiscoveryNodeRole DATA_WARM_NODE_ROLE = new DiscoveryNodeRole("data_warm", "w", true){

        @Override
        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole(settings, DATA_ROLE);
        }
    };
    public static DiscoveryNodeRole DATA_COLD_NODE_ROLE = new DiscoveryNodeRole("data_cold", "c", true){

        @Override
        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole(settings, DATA_ROLE);
        }
    };
    public static DiscoveryNodeRole DATA_FROZEN_NODE_ROLE = new DiscoveryNodeRole("data_frozen", "f", true){

        @Override
        public boolean isEnabledByDefault(Settings settings) {
            return DiscoveryNode.hasRole(settings, DATA_ROLE);
        }
    };
    public static final DiscoveryNodeRole INGEST_ROLE = new DiscoveryNodeRole("ingest", "i");
    public static final DiscoveryNodeRole MASTER_ROLE = new DiscoveryNodeRole("master", "m");
    public static final DiscoveryNodeRole VOTING_ONLY_NODE_ROLE = new DiscoveryNodeRole("voting_only", "v"){

        @Override
        public boolean isEnabledByDefault(Settings settings) {
            return false;
        }

        @Override
        public void validateRoles(List<DiscoveryNodeRole> roles) {
            if (!roles.contains(MASTER_ROLE)) {
                throw new IllegalArgumentException("voting-only node must be master-eligible");
            }
        }
    };
    public static final DiscoveryNodeRole REMOTE_CLUSTER_CLIENT_ROLE = new DiscoveryNodeRole("remote_cluster_client", "r");
    public static final DiscoveryNodeRole ML_ROLE = new DiscoveryNodeRole("ml", "l");
    public static final DiscoveryNodeRole TRANSFORM_ROLE = new DiscoveryNodeRole("transform", "t");
    private static final SortedSet<DiscoveryNodeRole> ROLES;
    private static final Map<String, DiscoveryNodeRole> ROLE_MAP;

    public final String roleName() {
        return this.roleName;
    }

    public final String roleNameAbbreviation() {
        return this.roleNameAbbreviation;
    }

    public final boolean canContainData() {
        return this.canContainData;
    }

    public boolean isEnabledByDefault(Settings settings) {
        return true;
    }

    public void validateRoles(List<DiscoveryNodeRole> roles) {
    }

    protected DiscoveryNodeRole(String roleName, String roleNameAbbreviation) {
        this(roleName, roleNameAbbreviation, false);
    }

    protected DiscoveryNodeRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
        this(true, roleName, roleNameAbbreviation, canContainData);
    }

    private DiscoveryNodeRole(boolean isKnownRole, String roleName, String roleNameAbbreviation, boolean canContainData) {
        this.isKnownRole = isKnownRole;
        this.roleName = Objects.requireNonNull(roleName);
        this.roleNameAbbreviation = Objects.requireNonNull(roleNameAbbreviation);
        this.canContainData = canContainData;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNodeRole that = (DiscoveryNodeRole)o;
        return this.roleName.equals(that.roleName) && this.roleNameAbbreviation.equals(that.roleNameAbbreviation) && this.canContainData == that.canContainData && this.isKnownRole == that.isKnownRole;
    }

    public final int hashCode() {
        return Objects.hash(this.isKnownRole, this.roleName(), this.roleNameAbbreviation(), this.canContainData());
    }

    @Override
    public final int compareTo(DiscoveryNodeRole o) {
        return this.roleName.compareTo(o.roleName);
    }

    public final String toString() {
        return "DiscoveryNodeRole{roleName='" + this.roleName + "', roleNameAbbreviation='" + this.roleNameAbbreviation + "', canContainData=" + this.canContainData + (this.isKnownRole ? "" : ", isKnownRole=false") + "}";
    }

    public static SortedSet<DiscoveryNodeRole> roles() {
        return ROLES;
    }

    public static SortedSet<String> roleNames() {
        return ROLE_MAP.keySet().stream().collect(Sets.toUnmodifiableSortedSet());
    }

    public static Optional<DiscoveryNodeRole> maybeGetRoleFromRoleName(String roleName) {
        return Optional.ofNullable(ROLE_MAP.get(roleName));
    }

    public static DiscoveryNodeRole getRoleFromRoleName(String roleName) {
        return DiscoveryNodeRole.maybeGetRoleFromRoleName(roleName).orElseThrow(() -> new IllegalArgumentException("unknown role [" + roleName + "]"));
    }

    static {
        List roleFields = Arrays.stream(DiscoveryNodeRole.class.getFields()).filter(f -> f.getType().equals(DiscoveryNodeRole.class)).collect(Collectors.toUnmodifiableList());
        Map roleMap = roleFields.stream().map(f -> {
            try {
                return (DiscoveryNodeRole)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }).collect(Collectors.toUnmodifiableMap(DiscoveryNodeRole::roleName, Function.identity()));
        assert (roleMap.size() == roleFields.size()) : "roles by name [" + roleMap + "], role fields [" + roleFields + "]";
        SortedSet roles = roleMap.values().stream().collect(Sets.toUnmodifiableSortedSet());
        Map abbreviations = roles.stream().collect(Collectors.toUnmodifiableMap(DiscoveryNodeRole::roleNameAbbreviation, Function.identity()));
        assert (abbreviations.size() == roleFields.size()) : "role abbreviations [" + abbreviations + "], role fields [" + roleFields + "]";
        ROLES = roles;
        ROLE_MAP = roleMap;
    }

    static class UnknownRole
    extends DiscoveryNodeRole {
        UnknownRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
            super(false, roleName, roleNameAbbreviation, canContainData);
        }
    }
}

