/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesLeafFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public class PagedBytesIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    private final double minFrequency;
    private final double maxFrequency;
    private final int minSegmentSize;

    public PagedBytesIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, IndexFieldDataCache cache, CircuitBreakerService breakerService, double minFrequency, double maxFrequency, int minSegmentSize) {
        super(fieldName, valuesSourceType, cache, breakerService, AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION);
        this.minFrequency = minFrequency;
        this.maxFrequency = maxFrequency;
        this.minSegmentSize = minSegmentSize;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), source, reverse);
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    @Override
    public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        LeafReader reader = context.reader();
        LeafOrdinalsFieldData data = null;
        PagedBytesEstimator estimator = new PagedBytesEstimator(context, this.breakerService.getBreaker("fielddata"), this.getFieldName());
        Terms terms = reader.terms(this.getFieldName());
        if (terms == null) {
            data = AbstractLeafOrdinalsFieldData.empty();
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        PagedBytes bytes = new PagedBytes(15);
        PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder(0.0f);
        float acceptableTransientOverheadRatio = 0.5f;
        TermsEnum termsEnum = estimator.beforeLoad(terms);
        boolean success = false;
        try {
            LeafOrdinalsFieldData leafOrdinalsFieldData;
            try (OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), 0.5f);){
                PostingsEnum docsEnum = null;
                BytesRef term = termsEnum.next();
                while (term != null) {
                    long termOrd = builder.nextOrdinal();
                    assert (termOrd == termOrdToBytesOffset.size());
                    termOrdToBytesOffset.add(bytes.copyUsingLengthPrefix(term));
                    docsEnum = termsEnum.postings(docsEnum, 0);
                    int docId = docsEnum.nextDoc();
                    while (docId != Integer.MAX_VALUE) {
                        builder.addDoc(docId);
                        docId = docsEnum.nextDoc();
                    }
                    term = termsEnum.next();
                }
                PagedBytes.Reader bytesReader = bytes.freeze(true);
                Ordinals ordinals = builder.build();
                data = new PagedBytesLeafFieldData(bytesReader, termOrdToBytesOffset.build(), ordinals);
                success = true;
                leafOrdinalsFieldData = data;
            }
            return leafOrdinalsFieldData;
        }
        finally {
            if (!success) {
                estimator.afterLoad(termsEnum, 0L);
            } else {
                estimator.afterLoad(termsEnum, data.ramBytesUsed());
            }
        }
    }

    public class PagedBytesEstimator
    implements AbstractIndexOrdinalsFieldData.PerValueEstimator {
        private final LeafReaderContext context;
        private final CircuitBreaker breaker;
        private final String fieldName;
        private long estimatedBytes;

        PagedBytesEstimator(LeafReaderContext context, CircuitBreaker breaker, String fieldName) {
            this.breaker = breaker;
            this.context = context;
            this.fieldName = fieldName;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            if (term == null) {
                return 0L;
            }
            long bytes = term.length;
            bytes += 64L;
            bytes = (long)((double)bytes / 1.5) + 1L;
            return bytes;
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            LeafReader reader = this.context.reader();
            TermsEnum iterator = terms.iterator();
            TermsEnum filteredIterator = this.filter(terms, iterator, reader);
            return new RamAccountingTermsEnum(filteredIterator, this.breaker, this, this.fieldName);
        }

        private TermsEnum filter(Terms terms, TermsEnum iterator, LeafReader reader) throws IOException {
            if (iterator == null) {
                return null;
            }
            int docCount = terms.getDocCount();
            if (docCount == -1) {
                docCount = reader.maxDoc();
            }
            if (docCount >= PagedBytesIndexFieldData.this.minSegmentSize) {
                int maxFreq;
                int minFreq = PagedBytesIndexFieldData.this.minFrequency > 1.0 ? (int)PagedBytesIndexFieldData.this.minFrequency : (int)((double)docCount * PagedBytesIndexFieldData.this.minFrequency);
                int n = maxFreq = PagedBytesIndexFieldData.this.maxFrequency > 1.0 ? (int)PagedBytesIndexFieldData.this.maxFrequency : (int)((double)docCount * PagedBytesIndexFieldData.this.maxFrequency);
                if (minFreq > 1 || maxFreq < docCount) {
                    iterator = new FrequencyFilter(iterator, minFreq, maxFreq);
                }
            }
            return iterator;
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            if (termsEnum instanceof RamAccountingTermsEnum) {
                this.estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            }
            this.breaker.addWithoutBreaking(-(this.estimatedBytes - actualUsed));
        }
    }

    private static final class FrequencyFilter
    extends FilteredTermsEnum {
        private final int minFreq;
        private final int maxFreq;

        FrequencyFilter(TermsEnum delegate, int minFreq, int maxFreq) {
            super(delegate, false);
            this.minFreq = minFreq;
            this.maxFreq = maxFreq;
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef arg0) throws IOException {
            int docFreq = this.docFreq();
            if (docFreq >= this.minFreq && docFreq <= this.maxFreq) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final double minFrequency;
        private final double maxFrequency;
        private final int minSegmentSize;
        private final ValuesSourceType valuesSourceType;

        public Builder(String name, double minFrequency, double maxFrequency, int minSegmentSize, ValuesSourceType valuesSourceType) {
            this.name = name;
            this.minFrequency = minFrequency;
            this.maxFrequency = maxFrequency;
            this.minSegmentSize = minSegmentSize;
            this.valuesSourceType = valuesSourceType;
        }

        public IndexOrdinalsFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new PagedBytesIndexFieldData(this.name, this.valuesSourceType, cache, breakerService, this.minFrequency, this.maxFrequency, this.minSegmentSize);
        }
    }
}

