/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentParser;

public class BooleanFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "boolean";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.scriptCompiler()));
    private final Boolean nullValue;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Script script;
    private final FieldValues<Boolean> scriptValues;
    private final ScriptCompiler scriptCompiler;

    private static BooleanFieldMapper toType(FieldMapper in) {
        return (BooleanFieldMapper)in;
    }

    protected BooleanFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, Lucene.KEYWORD_ANALYZER, multiFields, copyTo, builder.script.get() != null, builder.onScriptError.getValue());
        this.nullValue = builder.nullValue.getValue();
        this.stored = builder.stored.getValue();
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.docValues.getValue();
        this.script = builder.script.get();
        this.scriptValues = builder.scriptValues();
        this.scriptCompiler = builder.scriptCompiler;
    }

    @Override
    public BooleanFieldType fieldType() {
        return (BooleanFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        if (!(this.indexed || this.stored || this.hasDocValues)) {
            return;
        }
        Boolean value = null;
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue != null) {
                value = this.nullValue;
            }
        } else {
            value = context.parser().booleanValue();
        }
        this.indexValue(context, value);
    }

    private void indexValue(DocumentParserContext context, Boolean value) {
        if (value == null) {
            return;
        }
        if (this.indexed) {
            context.doc().add(new Field(this.fieldType().name(), value != false ? "T" : "F", (IndexableFieldType)Defaults.FIELD_TYPE));
        }
        if (this.stored) {
            context.doc().add(new StoredField(this.fieldType().name(), value != false ? "T" : "F"));
        }
        if (this.hasDocValues) {
            context.doc().add(new SortedNumericDocValuesField(this.fieldType().name(), value != false ? 1L : 0L));
        } else {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (Boolean)value));
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.scriptCompiler).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> BooleanFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> BooleanFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> BooleanFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Boolean> nullValue = new FieldMapper.Parameter<Boolean>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Boolean.valueOf(XContentMapValues.nodeBooleanValue(o)), m -> BooleanFieldMapper.toType((FieldMapper)m).nullValue).acceptsNull();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> BooleanFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<String> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> BooleanFieldMapper.toType((FieldMapper)m).onScriptError, this.script);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;

        public Builder(String name, ScriptCompiler scriptCompiler) {
            super(name);
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.script.precludesParameters(this.nullValue);
            this.addScriptValidation(this.script, this.indexed, this.docValues);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.meta, this.docValues, this.indexed, this.nullValue, this.stored, this.script, this.onScriptError);
        }

        @Override
        public BooleanFieldMapper build(MapperBuilderContext context) {
            BooleanFieldType ft = new BooleanFieldType(context.buildFullName(this.name), this.indexed.getValue(), this.stored.getValue(), this.docValues.getValue(), this.nullValue.getValue(), this.scriptValues(), this.meta.getValue());
            return new BooleanFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }

        private FieldValues<Boolean> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            BooleanFieldScript.Factory scriptFactory = this.scriptCompiler.compile(this.script.get(), BooleanFieldScript.CONTEXT);
            return scriptFactory == null ? null : (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(this.name, this.script.get().getParams(), lookup).newInstance(ctx).runForDoc(doc, consumer);
        }
    }

    public static final class BooleanFieldType
    extends TermBasedFieldType {
        private final Boolean nullValue;
        private final FieldValues<Boolean> scriptValues;

        public BooleanFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Boolean nullValue, FieldValues<Boolean> scriptValues, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
        }

        public BooleanFieldType(String name) {
            this(name, true, false, true, false, null, Collections.emptyMap());
        }

        public BooleanFieldType(String name, boolean searchable) {
            this(name, searchable, false, true, false, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return BooleanFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, context);
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected Boolean parseSourceValue(Object value) {
                    if (value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    String textValue = value.toString();
                    return Booleans.parseBoolean(textValue.toCharArray(), 0, textValue.length(), false);
                }
            };
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return Values.FALSE;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Values.TRUE : Values.FALSE;
            }
            String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            switch (sValue) {
                case "true": {
                    return Values.TRUE;
                }
                case "false": {
                    return Values.FALSE;
                }
            }
            throw new IllegalArgumentException("Can't parse boolean value [" + sValue + "], expected [true] or [false]");
        }

        @Override
        public Boolean valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            switch (value.toString()) {
                case "F": {
                    return false;
                }
                case "T": {
                    return true;
                }
            }
            throw new IllegalArgumentException("Expected [T] or [F] but got [" + value + "]");
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.BOOLEAN);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            this.checkNoFormat(format);
            this.checkNoTimeZone(timeZone);
            return DocValueFormat.BOOLEAN;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexed();
            return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.freeze();
        }
    }

    public static class Values {
        public static final BytesRef TRUE = new BytesRef("T");
        public static final BytesRef FALSE = new BytesRef("F");
    }
}

